/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.MenuComponent;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.MenuItemPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class MenuItem
extends MenuComponent {
    private boolean enabled;
    private String label;
    private String actionCommand;
    private long eventMask;
    private MenuShortcut shortcut;
    private int menuItemSerializedDataVersion;
    transient ActionListener actionListener;

    public MenuItem() {
        this(null);
    }

    public MenuItem(String label) {
        this(label, null);
    }

    public MenuItem(String label, MenuShortcut shortcut) {
        this.label = label;
        this.shortcut = shortcut;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void setEnabled(boolean condition) {
        this.enabled = condition;
        if (this.enabled) {
            ((MenuItemPeer)this.peer).setEnabled();
        } else {
            ((MenuItemPeer)this.peer).setDisabled();
        }
    }

    public String getLabel() {
        return this.label;
    }

    public synchronized void setLabel(String label) {
        this.label = label;
    }

    public void deleteShortcut() {
        this.shortcut = null;
    }

    public MenuShortcut getShortcut() {
        return this.shortcut;
    }

    public void setShortcut(MenuShortcut shortcut) {
        this.shortcut = shortcut;
    }

    public synchronized void addActionListener(ActionListener listener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, listener);
    }

    protected final void enableEvents(long eventTypes) {
    }

    protected final void disableEvents(long eventTypes) {
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    protected void processActionEvent(ActionEvent event) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(event);
        }
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof ActionEvent) {
            this.processActionEvent(new ActionEvent(event.getSource(), event.getID(), this.actionCommand == null ? this.label : this.actionCommand));
        } else {
            super.processEvent(event);
        }
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, listener);
    }

    public void setActionCommand(String command) {
        this.actionCommand = command;
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = Toolkit.getDefaultToolkit().createMenuItem(this);
        }
    }

    public String paramString() {
        return "java.awt.MenuItem";
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
    }

    private void writeObject(ObjectOutputStream s) throws ClassNotFoundException, IOException {
    }
}

