/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.peer.FileDialogPeer;
import java.io.File;
import java.io.FilenameFilter;

public class FileDialog
extends Dialog {
    private static final long serialVersionUID = 5035145889651310422L;
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    private int mode;
    private FilenameFilter filter;
    private String dir = "";
    private String file;
    private int width = 250;
    private int height = 300;

    public FileDialog(Frame owner) {
        this(owner, "");
    }

    public FileDialog(Frame owner, String title) {
        this(owner, title, 0);
    }

    public FileDialog(Frame owner, String title, int mode) {
        super(owner, title, true);
        this.mode = mode;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.width = Math.min(this.width, screen.width);
        this.height = Math.min(this.height, screen.height);
        int x = (screen.width - this.width) / 2;
        int y = (screen.height - this.height) / 2;
        this.setBounds(x > 0 ? x : 0, y > 0 ? y : 0, this.width, this.height);
        try {
            this.dir = new File("").getCanonicalPath();
        }
        catch (Exception e) {
            // empty catch block
        }
        ((FileDialogPeer)this.peer).setDirectory(this.dir);
        ((FileDialogPeer)this.peer).setFile(this.file);
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createFileDialog(this);
        }
        if (!this.notified) {
            super.addNotify();
        }
    }

    public String getDirectory() {
        return this.dir + "/";
    }

    public synchronized void setDirectory(String dir) {
        this.dir = dir;
        ((FileDialogPeer)this.peer).setDirectory(dir);
    }

    public String getFile() {
        return this.file;
    }

    public synchronized void setFile(String file) {
        this.file = file;
        ((FileDialogPeer)this.peer).setFile(file);
    }

    public FilenameFilter getFilenameFilter() {
        return this.filter;
    }

    public synchronized void setFilenameFilter(FilenameFilter filter) {
        this.filter = filter;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("Only LOAD and SAVE are allowed");
        }
        this.mode = mode;
    }

    protected String paramString() {
        return "";
    }
}

