/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test;

public class Calculator {
    private static final int NO_OPERATOR = 0;
    private static final int DIVIDE_OPERATOR = 1;
    private static final int MULTIPLY_OPERATOR = 2;
    private static final int PLUS_OPERATOR = 3;
    private static final int SUBTRACT_OPERATOR = 4;
    private double accumulatorValue = 0.0;
    private double transientValue = 0.0;
    private int operatorCode = 0;
    private int trailingDigits = 0;
    private boolean startNewDigit = true;

    public double accumulator() {
        return this.accumulatorValue;
    }

    public int trailingDigits() {
        return this.trailingDigits;
    }

    public void divideOperator() {
        this.acceptOperator(1);
    }

    public void multiplyOperator() {
        this.acceptOperator(2);
    }

    public void plusOperator() {
        this.acceptOperator(3);
    }

    public void subtractOperator() {
        this.acceptOperator(4);
    }

    public void zero() {
        this.newDigit(0);
    }

    public void one() {
        this.newDigit(1);
    }

    public void two() {
        this.newDigit(2);
    }

    public void three() {
        this.newDigit(3);
    }

    public void four() {
        this.newDigit(4);
    }

    public void five() {
        this.newDigit(5);
    }

    public void six() {
        this.newDigit(6);
    }

    public void seven() {
        this.newDigit(7);
    }

    public void eight() {
        this.newDigit(8);
    }

    public void nine() {
        this.newDigit(9);
    }

    public void dot() {
        if (this.startNewDigit) {
            this.accumulatorValue = 0.0;
            this.startNewDigit = false;
        }
        if (this.trailingDigits == 0) {
            this.trailingDigits = 1;
        }
    }

    public void clear() {
        this.transientValue = 0.0;
        this.accumulatorValue = 0.0;
        this.operatorCode = 0;
        this.trailingDigits = 0;
        this.startNewDigit = true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enter() {
        try {
            try {
                switch (this.operatorCode) {
                    case 0: {
                        break;
                    }
                    case 3: {
                        this.accumulatorValue = this.transientValue + this.accumulatorValue;
                        break;
                    }
                    case 4: {
                        this.accumulatorValue = this.transientValue - this.accumulatorValue;
                        break;
                    }
                    case 2: {
                        this.accumulatorValue = this.transientValue * this.accumulatorValue;
                        break;
                    }
                    case 1: {
                        this.accumulatorValue = this.transientValue / this.accumulatorValue;
                        break;
                    }
                }
            }
            catch (ArithmeticException e) {
                this.accumulatorValue = 0.0;
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.transientValue = 0.0;
            this.operatorCode = 0;
            this.trailingDigits = 0;
            this.startNewDigit = true;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.transientValue = 0.0;
            this.operatorCode = 0;
            this.trailingDigits = 0;
            this.startNewDigit = true;
            return;
        }
    }

    public void invert() {
        this.accumulatorValue = -this.accumulatorValue;
    }

    public void reciprocal() {
        if (this.accumulatorValue == 0.0) {
            return;
        }
        this.accumulatorValue = 1.0 / this.accumulatorValue;
        this.startNewDigit = true;
        this.trailingDigits = 0;
    }

    private final void acceptOperator(int code) {
        if (this.operatorCode == 0) {
            this.transientValue = this.accumulatorValue;
            this.startNewDigit = true;
        } else {
            this.enter();
        }
        this.operatorCode = code;
        this.trailingDigits = 0;
    }

    private final void newDigit(int digit) {
        if (this.startNewDigit) {
            this.transientValue = this.accumulatorValue;
            this.startNewDigit = false;
            this.accumulatorValue = digit;
        } else {
            boolean negative = false;
            if (this.accumulatorValue < 0.0) {
                this.accumulatorValue = -this.accumulatorValue;
                negative = true;
            }
            if (this.trailingDigits == 0) {
                this.accumulatorValue = this.accumulatorValue * 10.0 + (double)digit;
            } else {
                this.accumulatorValue += (double)digit / Math.pow(10.0, this.trailingDigits);
                ++this.trailingDigits;
            }
            if (negative) {
                this.accumulatorValue = -this.accumulatorValue;
            }
        }
    }
}

