/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.taskbar;

import com.acunia.wonka.rudolph.taskbar.TaskBar;
import com.acunia.wonka.rudolph.taskbar.TaskBarApplet;
import com.acunia.wonka.rudolph.taskbar.TaskBarConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Vector;

public class TaskBarLayout
implements LayoutManager2 {
    public static final String LEFT = "Left";
    public static final String CENTER = "Center";
    public static final String RIGHT = "Right";
    public static final String TOP = "Left";
    public static final String BOTTOM = "Right";
    private Vector applets = new Vector();
    private Vector consts = new Vector();
    private int gap;

    public TaskBarLayout() {
        this(2);
    }

    public TaskBarLayout(int gap) {
        if (gap < 0) {
            throw new IllegalArgumentException("invalid gap value");
        }
        this.gap = gap;
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints instanceof TaskBarConstraints) {
            this.applets.add(comp);
            this.consts.add(constraints);
        }
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container container) {
        int psize = 0;
        int plh = 0;
        int plw = 0;
        TaskBar taskbar = (TaskBar)container;
        int orientation = TaskBar.getBarOrientation();
        for (int i = 0; i < taskbar.getAppletCount(); ++i) {
            TaskBarApplet c = taskbar.getApplet(i);
            if (!c.isVisible()) continue;
            psize += (orientation == 0 ? c.getPreferredSize().width : c.getPreferredSize().height) + this.gap;
        }
        Insets insets = taskbar.getInsets();
        if (orientation == 0) {
            plw = psize + insets.left + this.gap + insets.right;
            plh = taskbar.getSize().height;
        } else {
            plw = taskbar.getSize().width;
            plh = psize + insets.top + this.gap + insets.bottom;
        }
        return new Dimension(plw, plh);
    }

    public Dimension minimumLayoutSize(Container container) {
        int psize = 0;
        int plh = 0;
        int plw = 0;
        TaskBar taskbar = (TaskBar)container;
        int orientation = TaskBar.getBarOrientation();
        for (int i = 0; i < taskbar.getAppletCount(); ++i) {
            TaskBarApplet c = taskbar.getApplet(i);
            if (!c.isVisible()) continue;
            psize += (orientation == 0 ? c.getMinimumSize().width : c.getMinimumSize().height) + this.gap;
        }
        Insets insets = taskbar.getInsets();
        if (TaskBar.getBarOrientation() == 0) {
            plw = psize + insets.left + this.gap + insets.right;
            plh = taskbar.getSize().height;
        } else {
            plw = taskbar.getSize().width;
            plh = psize + insets.top + this.gap + insets.bottom;
        }
        return new Dimension(plw, plh);
    }

    public Dimension maximumLayoutSize(Container container) {
        int psize = 0;
        int plh = 0;
        int plw = 0;
        TaskBar taskbar = (TaskBar)container;
        int orientation = TaskBar.getBarOrientation();
        for (int i = 0; i < taskbar.getAppletCount(); ++i) {
            TaskBarApplet c = taskbar.getApplet(i);
            if (!c.isVisible()) continue;
            psize += (orientation == 0 ? c.getMaximumSize().width : c.getMaximumSize().height) + this.gap;
        }
        Insets insets = taskbar.getInsets();
        if (TaskBar.getBarOrientation() == 0) {
            plw = psize + insets.left + this.gap + insets.right;
            plh = taskbar.getSize().height;
        } else {
            plw = taskbar.getSize().width;
            plh = psize + insets.top + this.gap + insets.bottom;
        }
        return new Dimension(plw, plh);
    }

    public void layoutContainer(Container container) {
        int height;
        int pos;
        TaskBar taskbar = (TaskBar)container;
        Insets insets = taskbar.getInsets();
        if (TaskBar.getBarOrientation() == 0) {
            pos = insets.left;
            height = taskbar.getSize().height - insets.top - insets.bottom;
        } else {
            pos = insets.top;
            height = taskbar.getSize().width - insets.left - insets.right;
        }
        for (int i = 0; i < this.applets.size(); ++i) {
            int cheight;
            TaskBarApplet c = (TaskBarApplet)this.applets.elementAt(i);
            TaskBarConstraints co = (TaskBarConstraints)this.consts.elementAt(i);
            if (co != null) {
                pos = co.position;
            }
            if (!c.isVisible()) continue;
            int size = 0;
            if (TaskBar.getBarOrientation() == 0) {
                size = c.getPreferredSize().width;
                cheight = c.getPreferredSize().height;
                c.setBounds(pos, insets.top + (height < cheight ? 0 : (height - cheight) / 2), size, height < cheight ? height : cheight);
            } else {
                size = c.getPreferredSize().height;
                cheight = c.getPreferredSize().width;
                c.setBounds(insets.left + (height < cheight ? 0 : (height - cheight) / 2), pos, height < cheight ? height : cheight, size);
            }
            pos += size + this.gap;
        }
    }

    public float getLayoutAlignmentX(Container parent) {
        return parent.getAlignmentX();
    }

    public float getLayoutAlignmentY(Container parent) {
        return parent.getAlignmentY();
    }

    public void invalidateLayout(Container container) {
    }
}

