/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.peers;

import com.acunia.wonka.rudolph.peers.RudolphPeer;
import com.acunia.wonka.rudolph.peers.RudolphTextAreaPeer;
import com.acunia.wonka.rudolph.peers.TextAreaPainter_ScrollingFixFont;
import com.acunia.wonka.rudolph.peers.TextAreaPainter_ScrollingVarFont;
import com.acunia.wonka.rudolph.peers.TextAreaPainter_WrappingFixFont;
import com.acunia.wonka.rudolph.peers.TextAreaPainter_WrappingVarFont;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class TextAreaPainter {
    protected Dimension viewport;
    protected int lineOffset;
    protected Font painterFont;
    protected FontMetrics painterMetrics;
    protected Color[] textColors;
    protected char[] textBuffer;
    protected int[] textlineEnd;
    protected int[] viewTextOffset;
    protected int[] viewTextLength;
    protected boolean drawCursor;

    public Dimension getScreenSize(int chars, int lines) {
        return new Dimension(RudolphTextAreaPeer.getScreenSize(chars * this.painterMetrics.charWidth('a')), RudolphTextAreaPeer.getHeight(lines, this.painterMetrics));
    }

    public int getMaxAdvance() {
        return this.painterMetrics.getMaxAdvance();
    }

    public int getBorder() {
        return this.painterMetrics.getHeight() / 2;
    }

    public void setSize(Dimension newsize) {
        this.viewport.width = RudolphTextAreaPeer.getInnerwidth(newsize.width);
        this.viewport.height = RudolphTextAreaPeer.getLines(newsize.height, this.painterMetrics);
        this.calculateVisibleLineparts();
    }

    public int getViewportWidth() {
        return this.viewport.width;
    }

    public int getViewportLines() {
        return this.viewport.height;
    }

    public int getMaximumWidth() {
        return this.viewport.width;
    }

    public int getMaximumLines() {
        return this.textlineEnd.length;
    }

    public int getTextOffset() {
        return 0;
    }

    public int getLineOffset() {
        return this.lineOffset;
    }

    public Point getOffset() {
        return new Point(0, this.lineOffset);
    }

    public void setTextOffset(int offset) {
    }

    public void setLineOffset(int offset) {
        this.lineOffset = offset;
    }

    public void setOffset(int offsetx, int offsety) {
        this.lineOffset = offsety;
    }

    public void setTextColors(Color back, Color font) {
        this.textColors = RudolphPeer.getBarColors(back, font);
    }

    public void setTextColors(Color[] newcolors) {
        if (newcolors.length >= 5) {
            this.textColors = newcolors;
        }
    }

    public Color[] getTextColors() {
        return this.textColors;
    }

    public Color getBackground() {
        return this.textColors[0];
    }

    public Color getForeground() {
        return this.textColors[4];
    }

    public void setImage(String text) {
        int breaks = 0;
        int pos = 0;
        while ((pos = text.indexOf(10, pos + 1)) >= 0) {
            ++breaks;
        }
        this.textBuffer = new char[text.length() - breaks];
        this.textlineEnd = new int[breaks + 1];
        this.viewTextOffset = new int[breaks + 1];
        this.viewTextLength = new int[breaks + 1];
        int bufstart = 0;
        int textstart = 0;
        int i = 0;
        while (i < breaks) {
            pos = text.indexOf(10, textstart);
            text.getChars(textstart, pos, this.textBuffer, bufstart);
            this.textlineEnd[i] = bufstart + pos - textstart;
            bufstart = this.textlineEnd[i];
            textstart = pos + 1;
            ++i;
        }
        text.getChars(textstart, text.length(), this.textBuffer, bufstart);
        this.textlineEnd[breaks] = this.textBuffer.length;
        if (this.viewport.width > 0) {
            this.calculateVisibleLineparts();
        }
    }

    protected abstract void calculateVisibleLineparts();

    public abstract void setScreenPosition(int var1, int var2, int[] var3);

    public abstract void setScreenPosition(int var1, int[] var2);

    public abstract void setScreenPositionLine(int var1, int var2, int[] var3);

    public abstract void paint(int var1, int var2, int var3, int var4, int var5, Graphics var6);

    public abstract void paint(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, Graphics var9);

    public static TextAreaPainter getNewPainter(Font newfont, String text, Color[] colors, Dimension screen, boolean scrolling) {
        if (newfont == null) {
            newfont = RudolphTextAreaPeer.DEFAULT_FONT;
        }
        FontMetrics metrics = new FontMetrics(newfont);
        int maxwidth = metrics.getMaxAdvance();
        TextAreaPainter newpainter = scrolling && maxwidth > metrics.charWidth('i') ? new TextAreaPainter_ScrollingVarFont(newfont, metrics, text, screen, colors) : (scrolling ? new TextAreaPainter_ScrollingFixFont(newfont, metrics, maxwidth, text, screen, colors) : (maxwidth > metrics.charWidth('i') ? new TextAreaPainter_WrappingVarFont(newfont, metrics, text, screen, colors) : new TextAreaPainter_WrappingFixFont(newfont, metrics, maxwidth, text, screen, colors)));
        return newpainter;
    }

    public void setCursor(boolean enabled) {
        this.drawCursor = enabled;
    }

    private final /* synthetic */ void this() {
        this.textColors = RudolphPeer.getBarColors();
        this.drawCursor = true;
    }

    public TextAreaPainter(Font textfont, FontMetrics metrics, String text, Dimension size, Color[] colors) {
        this.this();
        this.viewport = new Dimension(RudolphTextAreaPeer.getInnerwidth(size.width), RudolphTextAreaPeer.getLines(size.height, metrics));
        if (this.viewport.width < 0) {
            this.viewport.width = 0;
        }
        this.textColors = colors;
        this.painterFont = textfont;
        this.painterMetrics = metrics;
        this.setImage(text);
    }

    public TextAreaPainter(FontMetrics metrics, Dimension size, Color[] colors) {
        this.this();
        this.viewport = new Dimension(RudolphTextAreaPeer.getInnerwidth(size.width), RudolphTextAreaPeer.getLines(size.height, metrics));
        if (this.viewport.width < 0) {
            this.viewport.width = 0;
        }
        this.textColors = colors;
    }
}

