/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.peers;

import com.acunia.wonka.rudolph.peers.RudolphPeer;
import com.acunia.wonka.rudolph.peers.RudolphScrollbarPeer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ScrollPainter {
    public final int minimumThickness;
    public final int lineUpSpan;
    public final int lineDnSpan;
    public final int minimumScreenSpan;
    public int barPos;
    public int barSpan;
    public int barRange;
    public int screenPos;
    public int screenSpan;
    public int screenRange;
    public int paintedScreenPos;
    public int lineStep;
    public int blockStep;
    public int currentActive;
    public int currentThickness;
    public int crippledSpan;
    public int barOffset;
    public Color[] barColors;

    public abstract int getPos(int var1, int var2);

    public abstract int getThickness(int var1, int var2);

    public abstract Dimension getSize(int var1, int var2);

    public Dimension getMinimumSize() {
        return this.getSize(this.lineUpSpan + this.lineDnSpan + this.minimumScreenSpan, this.minimumThickness);
    }

    public Dimension getPreferredSize() {
        return this.getSize(this.lineUpSpan + this.lineDnSpan + this.screenRange, this.minimumThickness);
    }

    public Dimension getCurrentSize() {
        return this.getSize(this.lineUpSpan + this.lineDnSpan + this.screenRange, this.currentThickness);
    }

    public Dimension getPreferredSize(int width, int height) {
        return this.getSize(this.getPos(width, height), this.minimumThickness);
    }

    public boolean setRange(int totalwidth) {
        if (totalwidth <= this.lineUpSpan + this.lineDnSpan) {
            if (totalwidth == this.crippledSpan) {
                return false;
            }
            this.crippledSpan = totalwidth;
            return true;
        }
        this.crippledSpan = -1;
        if ((totalwidth = totalwidth - this.lineUpSpan - this.lineDnSpan) == this.screenRange) {
            return false;
        }
        this.screenRange = totalwidth;
        this.setScreen();
        return true;
    }

    public boolean setRange(int width, int height) {
        return this.setRange(this.getPos(width, height));
    }

    public int getMinimumThickness() {
        return this.minimumThickness;
    }

    public int getCurrentThickness() {
        return this.currentThickness;
    }

    public void setThickness(int newthickness) {
        this.currentThickness = newthickness > this.minimumThickness ? newthickness : this.minimumThickness;
    }

    public void setThickness(int width, int height) {
        this.setThickness(this.getThickness(width, height));
    }

    public void setMinimumThickness() {
        this.currentThickness = this.minimumThickness;
    }

    public void setOffset(int offset) {
        this.barOffset = offset;
    }

    public int getOffset() {
        return this.barOffset;
    }

    public void setBarColors(Color back, Color font) {
        this.barColors = RudolphPeer.getBarColors(back, font);
    }

    public void setBarColors(Color[] newcolors) {
        if (newcolors.length >= 5) {
            this.barColors = newcolors;
        }
    }

    public Color getBackground() {
        return this.barColors[0];
    }

    public Color getForeground() {
        return this.barColors[4];
    }

    public int getBarPos() {
        return this.barPos;
    }

    public int getBarSpan() {
        return this.barSpan;
    }

    public int getBarRange() {
        return this.barRange;
    }

    public int getScreenPos() {
        return this.screenPos;
    }

    public int getScreenSpan() {
        return this.screenSpan;
    }

    public int getScreenRange() {
        return this.screenRange;
    }

    public int getLineStep() {
        return this.lineStep;
    }

    public int getBlockStep() {
        return this.blockStep;
    }

    public void setLineStep(int step) {
        this.lineStep = step;
    }

    public void setBlockStep(int step) {
        this.blockStep = step;
    }

    public boolean setBarPos(int newpos) {
        if (newpos < 0) {
            newpos = 0;
        } else if (newpos + this.barSpan > this.barRange) {
            newpos = this.barRange - this.barSpan;
        }
        if (newpos != this.barPos) {
            this.barPos = newpos;
            this.setScreen();
            return true;
        }
        return false;
    }

    public boolean setBarSpan(int newspan) {
        if (newspan < 1) {
            newspan = 1;
        } else if (newspan > this.barRange) {
            newspan = this.barRange;
        }
        if (newspan != this.barSpan) {
            this.barSpan = newspan;
            if (this.barPos + this.barSpan > this.barRange) {
                this.barPos = this.barRange - this.barSpan;
            }
            this.setScreen();
            return true;
        }
        return false;
    }

    public boolean setBarRange(int newrange) {
        if (newrange < 1) {
            newrange = 1;
        }
        if (newrange != this.barRange) {
            this.barRange = newrange;
            if (this.barSpan > this.barRange) {
                this.barSpan = this.barRange;
                this.barPos = 0;
            } else if (this.barPos + this.barSpan > this.barRange) {
                this.barPos = this.barRange - this.barSpan;
            }
            this.setScreen();
            return true;
        }
        return false;
    }

    public boolean setBarValues(int newpos, int newspan, int newrange) {
        if (newrange < 1) {
            newrange = 1;
        }
        if (newspan < 1) {
            newspan = 1;
        } else if (newspan > newrange) {
            newspan = newrange;
        }
        if (newpos < 0) {
            newpos = 0;
        } else if (newpos + newspan > newrange) {
            newpos = newrange - newspan;
        }
        if (newrange != this.barRange || newspan != this.barSpan || newpos != this.barPos) {
            this.barRange = newrange;
            this.barSpan = newspan;
            this.barPos = newpos;
            this.setScreen();
            return true;
        }
        return false;
    }

    public boolean setScreenRange(int range) {
        if (range < 1) {
            range = 1;
        }
        if (range != this.screenRange) {
            this.screenRange = range;
            this.setScreen();
            return true;
        }
        return false;
    }

    public boolean setScreenPos(int newpos) {
        if (newpos < 0) {
            newpos = 0;
        } else if (newpos + this.screenSpan > this.screenRange) {
            newpos = this.screenRange - this.screenSpan;
        }
        if (this.screenPos != newpos) {
            this.screenPos = newpos;
            return this.setBar();
        }
        return false;
    }

    public boolean lineUp() {
        if (this.barPos > 0) {
            int n = 0;
            if (this.barPos > this.lineStep) {
                n = this.barPos - this.lineStep;
            }
            this.barPos = n;
            this.setScreen();
            return true;
        }
        return false;
    }

    public boolean lineDn() {
        int lastpos = this.barRange - this.barSpan;
        if (this.barPos <= lastpos) {
            this.barPos = this.barPos + this.lineStep < lastpos ? this.barPos + this.lineStep : lastpos;
            this.setScreen();
            return true;
        }
        return false;
    }

    public boolean pageUp() {
        if (this.barPos > 0) {
            int n = 0;
            if (this.barPos > this.blockStep) {
                n = this.barPos - this.blockStep;
            }
            this.barPos = n;
            this.setScreen();
            return true;
        }
        return false;
    }

    public boolean pageDn() {
        int lastpos = this.barRange - this.barSpan;
        if (this.barPos <= lastpos) {
            this.barPos = this.barPos + this.blockStep < lastpos ? this.barPos + this.blockStep : lastpos;
            this.setScreen();
            return true;
        }
        return false;
    }

    public void setScreen() {
        if (this.barSpan >= this.barRange) {
            this.barPos = 0;
            this.barSpan = this.barRange;
            this.screenPos = 0;
            this.paintedScreenPos = 0;
            this.screenSpan = this.screenRange;
        } else if (this.minimumScreenSpan * this.barRange > this.screenRange * this.barSpan) {
            this.screenSpan = this.minimumScreenSpan;
            this.screenPos = this.barPos <= 0 ? 0 : (this.barPos >= this.barRange - this.barSpan ? this.screenRange - this.screenSpan : this.barPos * (this.screenRange - this.minimumScreenSpan) / (this.barRange - this.barSpan));
            this.paintedScreenPos = this.screenPos;
        } else {
            this.screenSpan = this.barSpan * this.screenRange / this.barRange;
            this.screenPos = this.barPos <= 0 ? 0 : (this.barPos >= this.barRange - this.barSpan ? this.screenRange - this.screenSpan : this.barPos * this.screenRange / this.barRange);
            this.paintedScreenPos = this.screenPos;
        }
    }

    public boolean setBar() {
        if (this.screenPos < 0) {
            this.screenPos = 0;
            if (this.barPos > 0) {
                this.barPos = 0;
                this.paintedScreenPos = 0;
                return true;
            }
        } else if (this.screenPos + this.screenSpan >= this.screenRange) {
            this.barPos = this.barRange - this.barSpan;
            this.screenPos = this.screenRange - this.screenSpan;
            if (this.paintedScreenPos != this.screenPos) {
                this.paintedScreenPos = this.screenPos;
                return true;
            }
        } else if (this.minimumScreenSpan * this.barRange > this.screenRange * this.barSpan) {
            int newpos = this.screenPos * (this.barRange - this.barSpan) / (this.screenRange - this.minimumScreenSpan);
            if (newpos != this.barPos) {
                this.barPos = newpos;
                this.paintedScreenPos = newpos * (this.screenRange - this.minimumScreenSpan) / (this.barRange - this.barSpan);
                return true;
            }
        } else {
            int newpos = this.screenPos * this.barRange / this.screenRange;
            if (newpos != this.barPos) {
                this.barPos = newpos;
                this.paintedScreenPos = newpos * this.screenRange / this.barRange;
                return true;
            }
        }
        return false;
    }

    public boolean moveBar(int dl) {
        if (this.screenPos + dl < 0) {
            this.screenPos = 0;
            if (this.barPos > 0) {
                this.barPos = 0;
                this.paintedScreenPos = 0;
                return true;
            }
        } else if (this.screenPos + dl + this.screenSpan >= this.screenRange) {
            this.barPos = this.barRange - this.barSpan;
            this.screenPos = this.screenRange - this.screenSpan;
            if (this.paintedScreenPos != this.screenPos) {
                this.paintedScreenPos = this.screenPos;
                return true;
            }
        } else if (this.minimumScreenSpan * this.barRange > this.screenRange * this.barSpan) {
            this.screenPos += dl;
            int newpos = this.screenPos * (this.barRange - this.barSpan) / (this.screenRange - this.minimumScreenSpan);
            if (newpos != this.barPos) {
                this.barPos = newpos;
                this.paintedScreenPos = newpos * (this.screenRange - this.minimumScreenSpan) / (this.barRange - this.barSpan);
                return true;
            }
        } else {
            this.screenPos += dl;
            int newpos = this.screenPos * this.barRange / this.screenRange;
            if (newpos != this.barPos) {
                this.barPos = newpos;
                this.paintedScreenPos = newpos * this.screenRange / this.barRange;
                return true;
            }
        }
        return false;
    }

    public boolean moveScreenPos(int dx, int dy) {
        return this.moveBar(this.getPos(dx, dy));
    }

    public synchronized int getActive() {
        return this.currentActive;
    }

    public synchronized void setNoSelected() {
        this.currentActive = -1;
    }

    public synchronized boolean isNoSelected() {
        boolean bl = false;
        if (this.currentActive < 0) {
            bl = true;
        }
        return bl;
    }

    public synchronized boolean isSelected() {
        boolean bl = false;
        if (this.currentActive >= 0) {
            bl = true;
        }
        return bl;
    }

    public int getField(int x, int y) {
        return this.getField(this.getPos(x, y));
    }

    public synchronized int setActive(int x, int y) {
        this.currentActive = this.getField(this.getPos(x, y));
        return this.currentActive;
    }

    public int getField(int pos) {
        int field = -1;
        if (this.crippledSpan > 0 && pos >= 0 && pos <= this.crippledSpan) {
            int n = 0;
            if (pos < this.crippledSpan / 2) {
                n = 1;
            }
            field = n + 1;
        } else if (pos >= 0 && pos <= this.lineUpSpan + this.screenRange + this.lineDnSpan) {
            field = pos <= this.lineUpSpan ? 2 : (pos < this.lineUpSpan + this.screenPos ? 3 : (pos <= this.lineUpSpan + this.screenPos + this.screenSpan ? 5 : (pos < this.lineUpSpan + this.screenRange ? 4 : 1)));
        }
        return field;
    }

    public abstract void paint(Graphics var1);

    public String toString() {
        String param = "ScrollPainter: virtual bar <pos = " + this.barPos + ", span = " + this.barSpan + ", range = " + this.barRange + '>';
        param = param + "screen <pos = " + this.screenPos + ", span = " + this.screenSpan + ", range = " + this.screenRange + "> ";
        param = param + "increment <unit = " + this.lineStep + ",block = " + this.blockStep + '>';
        param = param + "current field <" + this.currentActive + '>';
        return param;
    }

    public String paramString() {
        String param = "ScrollPainter:bar<pos" + this.barPos + ",span" + this.barSpan + ",range" + this.barRange + '>';
        param = param + "screen<pos" + this.screenPos + ",span" + this.screenSpan + ",range" + this.screenRange + '>';
        param = param + "increment<unit" + this.lineStep + ",block" + this.blockStep + '>';
        param = param + "currentActive:" + this.currentActive;
        return param;
    }

    private final /* synthetic */ void this() {
        this.barPos = 0;
        this.barSpan = 10;
        this.barRange = 100;
        this.screenPos = 0;
        this.screenSpan = 10;
        this.screenRange = 100;
        this.paintedScreenPos = 0;
        this.lineStep = 1;
        this.blockStep = 10;
        this.crippledSpan = -1;
        this.barColors = RudolphScrollbarPeer.getBarColors();
    }

    public ScrollPainter(int thickness, int lineup, int linedn, int box) {
        this.this();
        this.minimumThickness = thickness;
        this.lineUpSpan = lineup;
        this.lineDnSpan = linedn;
        this.minimumScreenSpan = box;
    }
}

