/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.peers;

import com.acunia.wonka.rudolph.peers.DefaultTextComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.peer.TextFieldPeer;

public class DefaultTextField
extends DefaultTextComponent
implements TextFieldPeer,
FocusListener,
MouseListener,
MouseMotionListener,
KeyListener {
    private boolean focus;
    private String str;
    private int cols;
    private char echo;
    private int xoffset = 0;
    private boolean selecting = false;
    private int selstart = 0;
    private int selstop = 0;

    public DefaultTextField(TextField textField) {
        super(textField);
        textField.addFocusListener(this);
        textField.addMouseListener(this);
        textField.addMouseMotionListener(this);
        textField.addKeyListener(this);
    }

    public Dimension getMinimumSize(int cols) {
        return this.getPreferredSize(cols);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize(int cols) {
        Dimension preferredSize;
        Object object = this.component.getTreeLock();
        synchronized (object) {
            Font f = this.component.getFont();
            FontMetrics fm = this.getFontMetrics(f != null ? f : Component.DEFAULT_FONT);
            int cx = Math.max(30, cols * 8);
            int cy = Math.max(10, fm.getHeight() + 4);
            preferredSize = new Dimension(cx, cy);
        }
        return preferredSize;
    }

    public void setEchoChar(char c) {
        this.echo = c;
        this.setText(this.text);
    }

    public void setCaretPosition(int newposition) {
        super.setCaretPosition(newposition);
        this.paint(this.getGraphics());
    }

    public Dimension minimumSize(int cols) {
        return null;
    }

    public Dimension preferredSize(int cols) {
        return null;
    }

    public void setEchoCharacter(char c) {
    }

    public void setText(String text) {
        this.str = text;
        this.text = this.echo != '\u0000' ? this.echo(this.str) : this.str;
        super.setText(this.text);
        this.paint(this.getGraphics());
    }

    private String echo(String s) {
        int length = s.length();
        char[] sb = new char[length];
        for (int i = 0; i < length; ++i) {
            sb[i] = this.echo;
        }
        return new String(sb);
    }

    public String getText() {
        return this.echo != '\u0000' ? this.str : this.text;
    }

    public void paint(Graphics g) {
        if (g == null) {
            return;
        }
        int x = 0;
        int y = this.component.getSize().height / 2 - (g.getFontMetrics().getHeight() + 4) / 2;
        int w = this.component.getSize().width - 1;
        int h = g.getFontMetrics().getHeight() + 4;
        if (this.component.getSize().height - 1 < h) {
            h = this.component.getSize().height - 1;
        }
        int ystr = (h - (g.getFontMetrics().getHeight() + 4)) / 2 + g.getFontMetrics().getAscent() + 2;
        int carretx = g.getFontMetrics().stringWidth(this.text.substring(0, this.getCaretPosition()));
        if (this.xoffset > x + (w - 4) - carretx) {
            this.xoffset = x + (w - 4) - carretx;
        }
        if (this.xoffset < x - carretx) {
            this.xoffset = x - carretx;
        }
        g.setColor(this.component.getBackground());
        g.fillRect(x, y, w, h);
        g.setColor(SystemColor.controlHighlight);
        g.drawLine(x, y + h, x + w, y + h);
        g.drawLine(x + w, y, x + w, y + h);
        g.setColor(SystemColor.controlShadow);
        g.drawLine(x, y, x + w, y);
        g.drawLine(x, y, x, y + h);
        g.setClip(x + 2, y, w - 4, h);
        if (this.component.isEnabled()) {
            g.setColor(this.component.getForeground());
        } else {
            g.setColor(SystemColor.textInactiveText);
        }
        g.drawString(this.text, x + this.xoffset + 2, y + ystr);
        if (this.getSelectionEnd() - this.getSelectionStart() > 0 && this.focus) {
            int sx = g.getFontMetrics().stringWidth(this.text.substring(0, this.getSelectionStart()));
            int ex = g.getFontMetrics().stringWidth(this.text.substring(0, this.getSelectionEnd()));
            g.setColor(new Color(80, 80, 80));
            g.fillRect(sx + this.xoffset + 2, y + 2, ex - sx, h - 4);
            g.setColor(Color.white);
            g.setClip(sx + this.xoffset + 2, y, ex - sx, h);
            g.drawString(this.text, x + this.xoffset + 2, y + ystr);
            g.setClip(x, y, w, h);
            g.setColor(Color.black);
        }
        if (this.focus && ((TextField)this.component).isEditable()) {
            g.drawLine(carretx + this.xoffset + 2, y + 2, carretx + this.xoffset + 2, y + h - 2);
            g.drawLine(carretx + this.xoffset + 3, y + 2, carretx + this.xoffset + 3, y + h - 2);
        }
        super.paint(g);
    }

    public void focusGained(FocusEvent fe) {
        this.focus = true;
        this.paint(this.getGraphics());
    }

    public void focusLost(FocusEvent fe) {
        this.focus = false;
        this.paint(this.getGraphics());
    }

    private int getNearestPos(int x) {
        Font f = this.component.getFont();
        FontMetrics fm = this.getFontMetrics(f != null ? f : Component.DEFAULT_FONT);
        int length = this.text.length();
        for (int i = 0; i <= length; ++i) {
            if (x - 2 - this.xoffset >= fm.stringWidth(this.text.substring(0, i))) continue;
            return i - 1;
        }
        return length;
    }

    private void doSelection() {
        if (this.selstart <= this.selstop) {
            this.select(this.selstart, this.selstop);
        } else {
            this.select(this.selstop, this.selstart);
        }
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
    }

    public void mouseMoved(MouseEvent me) {
    }

    public void mouseClicked(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
        this.selstart = this.getNearestPos(me.getX());
        this.selstop = this.getNearestPos(me.getX());
        this.doSelection();
        this.setCaretPosition(this.selstart);
        this.paint(this.getGraphics());
    }

    public void mouseReleased(MouseEvent me) {
        this.selstop = this.getNearestPos(me.getX());
        this.doSelection();
        this.setCaretPosition(this.selstop);
        this.paint(this.getGraphics());
    }

    public void mouseDragged(MouseEvent me) {
        this.selstop = this.getNearestPos(me.getX());
        this.doSelection();
        this.setCaretPosition(this.selstop);
        this.paint(this.getGraphics());
    }

    public void keyPressed(KeyEvent ke) {
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void keyTyped(KeyEvent evt) {
        switch (evt.getKeyCode()) {
            case 10: {
                this.component.dispatchEvent(new ActionEvent(this.component, 1001, ""));
                break;
            }
            default: {
                super.keyTyped(evt);
            }
        }
    }

    protected boolean deleteCaret(int newpos) {
        if (newpos < 0 || newpos >= this.text.length()) {
            return false;
        }
        this.position = newpos;
        this.selectionStart = newpos;
        this.selectionStop = newpos;
        this.text = new String(new StringBuffer(this.text).deleteCharAt(newpos));
        if (this.echo != '\u0000') {
            this.str = new String(new StringBuffer(this.str).deleteCharAt(newpos));
        }
        return true;
    }

    protected void deleteSelection() {
        this.text = new String(new StringBuffer(this.text).delete(this.selectionStart, this.selectionStop));
        if (this.echo != '\u0000') {
            this.str = new String(new StringBuffer(this.str).delete(this.selectionStart, this.selectionStop));
        }
        this.position = this.selectionStart;
        this.selectionStop = this.selectionStart;
    }

    protected boolean insertCaret(int newpos, char c) {
        if (newpos < 0 || newpos > this.text.length()) {
            return false;
        }
        this.selectionStart = this.position = newpos + 1;
        this.selectionStop = this.position;
        if (this.echo != '\u0000') {
            this.str = new String(new StringBuffer(this.str).insert(newpos, c));
            this.text = new String(new StringBuffer(this.text).insert(newpos, this.echo));
        } else {
            this.text = new String(new StringBuffer(this.text).insert(newpos, c));
        }
        return true;
    }

    protected void insertSelection(char c) {
        StringBuffer buf = new StringBuffer(this.text);
        buf.delete(this.selectionStart, this.selectionStop);
        if (this.echo != '\u0000') {
            buf.insert(this.selectionStart, this.echo);
            StringBuffer plain = new StringBuffer(this.str);
            plain.delete(this.selectionStart, this.selectionStop);
            plain.insert(this.selectionStart, c);
            this.str = new String(plain);
        } else {
            buf.insert(this.selectionStart, c);
        }
        this.text = new String(buf);
        this.position = this.selectionStart;
        this.selectionStop = this.selectionStart;
    }

    public boolean inRange(MouseEvent e) {
        return new Rectangle(0, this.component.getSize().height / 2 - (this.component.getGraphics().getFontMetrics().getHeight() + 4) / 2, this.component.getSize().width - 1, this.component.getGraphics().getFontMetrics().getHeight() + 4).contains(e.getX(), e.getY());
    }
}

