/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.peers;

import com.acunia.wonka.rudolph.peers.DefaultComponent;
import java.awt.Button;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.peer.ButtonPeer;

public class DefaultButton
extends DefaultComponent
implements ButtonPeer,
MouseListener {
    private String label;
    private boolean pressed;
    private boolean drawpressed;

    public DefaultButton(Button button) {
        super(button);
        button.addMouseListener(this);
    }

    public Dimension getMinimumSize() {
        Button button = (Button)this.component;
        FontMetrics fm = button.getFontMetrics(button.getFont());
        int cx = Math.max(30, 4 * fm.stringWidth(button.getLabel()) / 3);
        int cy = Math.max(20, 2 * fm.getHeight());
        return new Dimension(cx, cy);
    }

    public Dimension getPreferredSize() {
        Button button = (Button)this.component;
        FontMetrics fm = button.getFontMetrics(button.getFont());
        int cx = Math.max(30, 4 * fm.stringWidth(button.getLabel()) / 3);
        int cy = Math.max(20, 2 * fm.getHeight());
        return new Dimension(cx, cy);
    }

    public void setLabel(String label) {
        this.label = label;
        this.paint(this.getGraphics());
    }

    public void paint(Graphics g) {
        if (g == null) {
            return;
        }
        Dimension dim = this.component.getSize();
        int w = dim.width;
        int h = dim.height;
        if (this.label == null) {
            this.label = ((Button)this.component).getLabel();
        }
        g.clearRect(0, 0, w, h);
        if (this.drawpressed) {
            g.setColor(SystemColor.controlShadow);
        } else {
            g.setColor(SystemColor.controlHighlight);
        }
        g.drawLine(0, 0, w - 1, 0);
        g.drawLine(0, 0, 0, h - 1);
        g.drawLine(1, 1, w - 2, 1);
        g.drawLine(1, 1, 1, h - 2);
        if (this.drawpressed) {
            g.setColor(SystemColor.controlHighlight);
        } else {
            g.setColor(SystemColor.controlShadow);
        }
        g.drawLine(0, h - 1, w - 1, h - 1);
        g.drawLine(w - 1, 0, w - 1, h - 1);
        g.drawLine(1, h - 2, w - 2, h - 2);
        g.drawLine(w - 2, 1, w - 2, h - 2);
        if (this.component.isEnabled()) {
            g.setColor(this.component.getForeground());
        } else {
            g.setColor(SystemColor.textInactiveText);
        }
        FontMetrics fm = g.getFontMetrics();
        g.drawString(this.label, (w - fm.stringWidth(this.label)) / 2, (h - fm.getHeight()) / 2 + fm.getAscent());
        if (!this.pressed) {
            super.paint(g);
        }
    }

    public void mouseClicked(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
        this.pressed = true;
        this.drawpressed = true;
        this.paint(this.getGraphics());
    }

    public void mouseReleased(MouseEvent me) {
        boolean action = this.drawpressed;
        this.pressed = false;
        this.drawpressed = false;
        this.paint(this.getGraphics());
        if (action) {
            this.component.dispatchEvent(new ActionEvent(this.component, 1001, ""));
        }
    }

    public void mouseEntered(MouseEvent me) {
        if (this.pressed) {
            this.drawpressed = true;
        }
        this.paint(this.getGraphics());
    }

    public void mouseExited(MouseEvent me) {
        if (this.pressed) {
            this.drawpressed = false;
        }
        this.paint(this.getGraphics());
    }

    public void setEnabled(boolean enable) {
        this.drawpressed = false;
        this.pressed = false;
    }
}

