/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph;

import com.acunia.wonka.rudolph.BufferImageSource;
import com.acunia.wonka.rudolph.GIFAnimator;
import com.acunia.wonka.rudolph.GIFImageSource;
import com.acunia.wonka.rudolph.Toolkit;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.WeakHashMap;

public class Image
extends java.awt.Image {
    private Component component;
    private String filename;
    protected ImageProducer producer;
    private Hashtable props;
    private char[] pixels;
    private char[] alpha;
    protected ImageConsumer consumer;
    protected int flags;
    int width = -1;
    int height = -1;
    private int key = 0;
    WeakHashMap observers;

    private static native int convertRGB(int var0, int var1, int var2);

    private native void setPixel(int var1, int var2, int var3, int var4);

    private native void do_conversion(byte[] var1, char[] var2, IndexColorModel var3, int var4, int var5, int var6, int var7, int var8, int var9);

    private native void do_conversion(int[] var1, char[] var2, DirectColorModel var3, int var4, int var5, int var6, int var7, int var8, int var9);

    Image() {
    }

    public Image(ImageProducer producer) {
        this.consumer = new Consumer();
        this.producer = producer;
        producer.startProduction(this.consumer);
    }

    private native void createImage();

    public int getWidth(ImageObserver observer) {
        if (observer != null) {
            observer.imageUpdate(this, this.flags, 0, 0, this.width, this.height);
        }
        return this.width;
    }

    public int getHeight(ImageObserver observer) {
        if (observer != null) {
            observer.imageUpdate(this, this.flags, 0, 0, this.width, this.height);
        }
        return this.height;
    }

    public native Graphics getGraphics();

    public Object getProperty(String name, ImageObserver observer) {
        Object result;
        if (observer != null) {
            observer.imageUpdate(this, this.flags, 0, 0, this.width, this.height);
        }
        if (this.props != null) {
            result = this.props.get(name);
            if (result == null) {
                result = UndefinedProperty;
            }
        } else {
            result = UndefinedProperty;
        }
        return result;
    }

    public ImageProducer getSource() {
        return this.producer != null ? this.producer : new BufferImageSource(this);
    }

    public void flush() {
        this.producer = null;
        this.pixels = null;
        this.createImage();
        if (this.key != 0) {
            Toolkit.t.imageCache.remove(this.key);
            this.key = 0;
        }
    }

    void setKey(int key) {
        this.key = key;
    }

    protected void finalize() {
        if (this.key != 0) {
            try {
                Toolkit.t.imageCache.remove(this.key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.finalize0();
    }

    private native void finalize0();

    void addObserver(ImageObserver observer) {
        if (observer != null) {
            if (this.observers == null) {
                this.observers = new WeakHashMap();
            }
            if (!this.observers.containsKey(observer)) {
                this.observers.put(observer, null);
            }
            if (this.producer instanceof GIFImageSource && ((GIFImageSource)this.producer).isAnimated()) {
                GIFAnimator.getInstance().startAnimator();
            }
        }
    }

    private synchronized boolean imageUpdate(int flags, int x, int y, int w, int h) {
        boolean result = false;
        if (this.observers != null) {
            Iterator iter = this.observers.keySet().iterator();
            WeakHashMap newObs = new WeakHashMap();
            while (iter.hasNext()) {
                ImageObserver obs = (ImageObserver)iter.next();
                if (obs == null || !obs.imageUpdate(this, flags, x, y, w, h)) continue;
                newObs.put(obs, null);
                result = true;
            }
            this.observers = newObs;
        }
        return result;
    }

    static /* synthetic */ char[] access$102(Image x0, char[] x1) {
        x0.pixels = x1;
        return x1;
    }

    protected class Consumer
    implements ImageConsumer {
        protected Consumer() {
        }

        public void setColorModel(ColorModel model) {
        }

        public void setHints(int hints) {
        }

        public void imageComplete(int status) {
            if ((status & 0xFFFF) == 8) {
                Image.this.createImage();
                Image.access$102(Image.this, null);
                Image.this.flags |= 0x20;
            } else {
                Image.this.createImage();
                Image.access$102(Image.this, null);
                Image.this.flags = (status & Integer.MIN_VALUE) != 0 ? (Image.this.flags |= Integer.MIN_VALUE) : (Image.this.flags &= Integer.MAX_VALUE);
                if (!Image.this.imageUpdate(16, 0, 0, 0, 0)) {
                    Image.this.consumer = null;
                }
            }
        }

        public void setProperties(Hashtable properties) {
            Image.this.flags |= 4;
            Image.this.props = properties;
        }

        public void setDimensions(int w, int h) {
            Image.this.width = w;
            Image.this.height = h;
            Image.this.flags |= 3;
            Image.access$102(Image.this, new char[w * h]);
        }

        public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pix, int offset, int scansize) {
            if (model instanceof IndexColorModel) {
                Image.this.do_conversion(pix, Image.this.pixels, (IndexColorModel)model, x, y, w, h, offset, scansize);
            } else {
                for (int j = 0; j < h; ++j) {
                    for (int i = 0; i < w; ++i) {
                        byte pixel = pix[j * scansize + i + offset];
                        Image.this.setPixel(i, j, Image.this.width, Image.convertRGB(model.getRed(pixel), model.getGreen(pixel), model.getBlue(pixel)));
                    }
                }
            }
            pix = null;
        }

        public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pix, int offset, int scansize) {
            if (model instanceof DirectColorModel) {
                Image.this.do_conversion(pix, Image.this.pixels, (DirectColorModel)model, x, y, w, h, offset, scansize);
            } else {
                for (int j = 0; j < h; ++j) {
                    for (int i = 0; i < w; ++i) {
                        int pixel = pix[j * scansize + i + offset];
                        Image.this.setPixel(i, j, Image.this.width, Image.convertRGB(model.getRed(pixel), model.getGreen(pixel), model.getBlue(pixel)));
                    }
                }
            }
            pix = null;
        }
    }
}

