/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rmi;

import com.acunia.wonka.rmi.DGCClient;
import com.acunia.wonka.rmi.ObjIDData;
import com.acunia.wonka.rmi.ParameterSet;
import com.acunia.wonka.rmi.RMIConnection;
import com.acunia.wonka.rmi.RegistryConstants;
import java.net.MalformedURLException;
import java.net.Socket;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;

public class RegistryStub
implements Registry,
RegistryConstants {
    private String host;
    private int port;
    private RMIClientSocketFactory csf;

    public RegistryStub(String host, int port, RMIClientSocketFactory csf) {
        this.host = host;
        this.port = port;
        this.csf = csf;
    }

    public void bind(String name, Remote obj) throws AlreadyBoundException, MalformedURLException, RemoteException {
        ObjIDData data = (ObjIDData)RMIConnection.exports.get(obj);
        if (data == null) {
            throw new RemoteException("Object " + obj + " is not exported");
        }
        Socket s = this.createConnection();
        Object[] params = new Object[]{name, data.stub};
        RMIConnection.requestObject(s, 4905912898345647071L, 0, RegistryConstants.NULLID, new ParameterSet(params), false);
    }

    public String[] list() throws MalformedURLException, RemoteException {
        Socket s = this.createConnection();
        Object o = RMIConnection.requestObject(s, 4905912898345647071L, 1, RegistryConstants.NULLID, ParameterSet.NOARGS_SET, true);
        return (String[])o;
    }

    public Remote lookup(String name) throws NotBoundException, MalformedURLException, RemoteException {
        Socket s = this.createConnection();
        Object o = RMIConnection.requestObject(s, 4905912898345647071L, 2, RegistryConstants.NULLID, name, true);
        Remote remote = (Remote)o;
        DGCClient.registerRemote(remote);
        return remote;
    }

    public void rebind(String name, Remote obj) throws MalformedURLException, RemoteException {
        ObjIDData data = (ObjIDData)RMIConnection.exports.get(obj);
        if (data == null) {
            throw new RemoteException("Object " + obj + " is not exported");
        }
        Socket s = this.createConnection();
        Object[] params = new Object[]{name, data.stub};
        RMIConnection.requestObject(s, 4905912898345647071L, 3, RegistryConstants.NULLID, new ParameterSet(params), false);
    }

    public void unbind(String name) throws NotBoundException, MalformedURLException, RemoteException {
        Socket s = this.createConnection();
        RMIConnection.requestObject(s, 4905912898345647071L, 4, RegistryConstants.NULLID, name, false);
    }

    private Socket createConnection() throws RemoteException {
        try {
            if (this.csf != null) {
                return this.csf.createSocket(this.host, this.port);
            }
            return new Socket(this.host, this.port);
        }
        catch (Exception ioe) {
            throw new RemoteException("unable to connect", ioe);
        }
    }
}

