/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rmi;

import com.acunia.wonka.rmi.DGCClient;
import com.acunia.wonka.rmi.RMIRegistryRequest;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.HashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RegistryImpl
extends Thread
implements Registry {
    private HashMap map;
    private ServerSocket server;
    private RMIClientSocketFactory csf;

    public void run() {
        try {
            while (true) {
                Socket s = this.server.accept();
                new RMIRegistryRequest(s, this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.server.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
    }

    public synchronized void bind(String name, Remote obj) throws AlreadyBoundException {
        if (name == null || this.map.containsKey(name)) {
            throw new AlreadyBoundException("'" + name + "' is not valid");
        }
        DGCClient.registerRemote(obj);
        this.map.put(name, obj);
    }

    public synchronized String[] list() {
        int size = this.map.size();
        Object[] strings = new String[size];
        if (size > 0) {
            this.map.keySet().toArray(strings);
        }
        return strings;
    }

    public synchronized Remote lookup(String name) throws NotBoundException {
        if (name == null || !this.map.containsKey(name)) {
            throw new NotBoundException("'" + name + "' is not valid");
        }
        return (Remote)this.map.get(name);
    }

    public synchronized void rebind(String name, Remote obj) throws RemoteException {
        if (name == null) {
            throw new RemoteException("name is null");
        }
        this.map.put(name, obj);
        DGCClient.registerRemote(obj);
    }

    public synchronized void unbind(String name) throws NotBoundException {
        Object obj = this.map.remove(name);
        if (obj == null) {
            throw new NotBoundException("'" + name + "' is not valid");
        }
    }

    private final /* synthetic */ void this() {
        this.map = new HashMap(31);
    }

    public RegistryImpl(int port) throws RemoteException {
        super("RegistryImplThread on port:" + port);
        this.this();
        try {
            this.server = new ServerSocket(port);
        }
        catch (IOException ioe) {
            throw new RemoteException("failed to create ServerSocket", ioe);
        }
        this.setDaemon(true);
        this.start();
    }

    public RegistryImpl(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        super("RegistryImplThread on port:" + port);
        this.this();
        try {
            this.server = ssf != null ? ssf.createServerSocket(port) : new ServerSocket(port);
        }
        catch (IOException ioe) {
            throw new RemoteException("failed to create ServerSocket", ioe);
        }
        this.csf = csf;
        this.setDaemon(true);
        this.start();
    }
}

