/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rmi;

import com.acunia.wonka.rmi.ObjIDData;
import com.acunia.wonka.rmi.ParameterSet;
import com.acunia.wonka.rmi.RMIObjectInputStream;
import com.acunia.wonka.rmi.RMIObjectOutputStream;
import com.acunia.wonka.rmi.RMIPermission;
import com.acunia.wonka.rmi.RMIRequestHandler;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.Method;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.UnexpectedException;
import java.rmi.dgc.VMID;
import java.rmi.server.ObjID;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UID;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.WeakHashMap;

public class RMIConnection {
    static final int DEBUG = 11;
    private static final byte[] headers = new byte[]{74, 82, 77, 73, 0, 2, 75};
    private static final Class REMOTE_CLASS = class$java$rmi$Remote == null ? (class$java$rmi$Remote = RMIConnection.class$("java.rmi.Remote")) : class$java$rmi$Remote;
    static final VMID TheVMID = new VMID();
    static final RMIPermission RMIPERMISSION = new RMIPermission();
    static Hashtable exports = new Hashtable(3);
    static final Hashtable idData = new Hashtable(13);
    static /* synthetic */ Class class$java$rmi$Remote;

    private RMIConnection() {
    }

    private static native long getStringHash(String var0);

    private static long getMethodHash(Method method) {
        StringBuffer name = new StringBuffer(128);
        name.append(method.getName());
        name.append('(');
        Class[] args = method.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            name.append(RMIConnection.class2String(args[i]));
        }
        name.append(")");
        name.append(RMIConnection.class2String(method.getReturnType()));
        long l = RMIConnection.getStringHash(name.toString());
        return l;
    }

    private static String class2String(Class c) {
        String name;
        String prefix = "";
        while (c.isArray()) {
            prefix = "[" + prefix;
            c = c.getComponentType();
        }
        if (c.isPrimitive()) {
            name = c == Integer.TYPE ? "I" : (c == Long.TYPE ? "J" : (c == Double.TYPE ? "D" : (c == Float.TYPE ? "F" : (c == Short.TYPE ? "S" : (c == Byte.TYPE ? "B" : (c == Character.TYPE ? "C" : (c == Boolean.TYPE ? "Z" : "V")))))));
        } else {
            name = "L" + c.getName() + ";";
            name = name.replace('.', '/');
        }
        return prefix + name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClientHost() throws ServerNotActiveException {
        String name;
        WeakHashMap weakHashMap = RMIRequestHandler.clientHostNames;
        synchronized (weakHashMap) {
            name = (String)RMIRequestHandler.clientHostNames.get(Thread.currentThread());
        }
        if (name == null) {
            throw new ServerNotActiveException("current Thread is not handling any RMI requests");
        }
        return name;
    }

    public static void setupTable(Hashtable map) {
        RMIConnection.securityCheck();
        exports = map;
    }

    public static void registerObjIDData(ObjID id, ObjIDData data) throws RemoteException {
        RMIConnection.securityCheck();
        Class[] interfaces = data.stub.getClass().getInterfaces();
        int length = interfaces.length;
        if (length == 0) {
            throw new RemoteException("bad stub: no interfaces implemented");
        }
        HashMap hashes2ID = new HashMap(13);
        boolean remoteOnly = true;
        for (int i = 0; i < length; ++i) {
            if (REMOTE_CLASS.equals(interfaces[i])) continue;
            remoteOnly = false;
            Method[] methods = interfaces[i].getMethods();
            for (int k = 0; k < methods.length; ++k) {
                hashes2ID.put(new Long(RMIConnection.getMethodHash(methods[k])), methods[k]);
            }
        }
        if (remoteOnly) {
            throw new RemoteException("bad stub: only implements the Remote interface");
        }
        data.methods = hashes2ID;
        idData.put(id, data);
    }

    public static void deregisterObjIDData(ObjID id) {
        RMIConnection.securityCheck();
        idData.remove(id);
    }

    static void securityCheck() {
    }

    static Object requestObject(Socket socket, long hash, int operation, ObjID id, Object arg, boolean returns) throws RemoteException {
        Object o = null;
        int rd = 0;
        try {
            RMIConnection.handShake(socket);
            OutputStream out = socket.getOutputStream();
            out.write(80);
            RMIObjectOutputStream oos = new RMIObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            id.write(oos);
            oos.writeInt(operation);
            oos.writeLong(hash);
            if (arg instanceof ParameterSet) {
                ((ParameterSet)arg).writeData(oos);
            } else {
                oos.writeObject(arg);
            }
            oos.flush();
            InputStream in = socket.getInputStream();
            rd = in.read();
            if ((rd & 0xFF) != 81) {
                // empty if block
            }
            RMIObjectInputStream ois = new RMIObjectInputStream(new PushbackInputStream(in));
            rd = ois.read();
            UID uid = UID.read(ois);
            if (!returns && rd != 2) {
                return null;
            }
            o = ois.readObject();
        }
        catch (Exception e) {
            throw new RemoteException("oops", e);
        }
        return RMIConnection.verifyObject(o, rd);
    }

    static Object requestPrimitive(Socket socket, long hash, int operation, ObjID id, Object arg, Class primitiveClass) throws RemoteException {
        Object o = null;
        int rd = 0;
        try {
            RMIConnection.handShake(socket);
            OutputStream out = socket.getOutputStream();
            out.write(80);
            RMIObjectOutputStream oos = new RMIObjectOutputStream(socket.getOutputStream());
            id.write(oos);
            oos.writeInt(operation);
            oos.writeLong(hash);
            if (arg instanceof ParameterSet) {
                ((ParameterSet)arg).writeData(oos);
            } else {
                oos.writeObject(arg);
            }
            oos.flush();
            InputStream in = socket.getInputStream();
            rd = in.read();
            if ((rd & 0xFF) != 81) {
                // empty if block
            }
            RMIObjectInputStream ois = new RMIObjectInputStream(new PushbackInputStream(in));
            rd = ois.read();
            UID uid = UID.read(ois);
            if (rd != 2) {
                return ParameterSet.readPrimitive(primitiveClass, ois);
            }
            o = ois.readObject();
        }
        catch (Exception e) {
            throw new RemoteException("oops", e);
        }
        return RMIConnection.verifyObject(o, rd);
    }

    static void pingVM(Socket socket) throws RemoteException {
        int rd = 0;
        try {
            RMIConnection.handShake(socket);
            OutputStream out = socket.getOutputStream();
            out.write(82);
            InputStream in = socket.getInputStream();
            rd = in.read();
        }
        catch (Exception e) {
            throw new RemoteException("oops", e);
        }
        if ((rd & 0xFF) != 83) {
            throw new RemoteException("bad response " + rd);
        }
    }

    static Object sendDGCAck(Socket socket, UID uid) throws RemoteException {
        Object o = null;
        int rd = 0;
        try {
            RMIConnection.handShake(socket);
            OutputStream out = socket.getOutputStream();
            out.write(84);
            uid.write(new DataOutputStream(out));
            out.flush();
            InputStream in = socket.getInputStream();
            rd = in.read();
            if ((rd & 0xFF) != 81) {
                // empty if block
            }
            RMIObjectInputStream ois = new RMIObjectInputStream(new PushbackInputStream(in));
            rd = ois.read();
            uid = UID.read(ois);
            o = ois.readObject();
        }
        catch (Exception e) {
            throw new RemoteException("oops", e);
        }
        return RMIConnection.verifyObject(o, rd);
    }

    static void writeVoidResponse(OutputStream out) {
        try {
            out.write(81);
            RMIObjectOutputStream oout = new RMIObjectOutputStream(out);
            oout.write(1);
            new UID().write(oout);
            oout.flush();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    static void writeResponse(OutputStream out, Object response) {
        try {
            out.write(81);
            RMIObjectOutputStream oout = new RMIObjectOutputStream(out);
            oout.write(1);
            new UID().write(oout);
            oout.writeObject(response);
            oout.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void writeException(OutputStream out, String message) {
        try {
            out.write(81);
            RMIObjectOutputStream oout = new RMIObjectOutputStream(out);
            oout.write(2);
            new UID().write(oout);
            oout.writeObject(new RemoteException(message));
            oout.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void writeException(OutputStream out, RemoteException re) {
        try {
            out.write(81);
            RMIObjectOutputStream oout = new RMIObjectOutputStream(out);
            oout.write(2);
            new UID().write(oout);
            oout.writeObject(re);
            oout.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void wrapException(OutputStream out, Throwable t) {
        try {
            out.write(81);
            RMIObjectOutputStream oout = new RMIObjectOutputStream(out);
            oout.write(2);
            new UID().write(oout);
            oout.writeObject(new RemoteException("RMI invocation fialed", t));
            oout.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void serverSideHandShake(Socket socket) throws IOException {
        byte[] bytes;
        InputStream in = socket.getInputStream();
        int len = in.read(bytes = new byte[7]);
        if (len == -1) {
            throw new IOException("no data available");
        }
        while (len < 7) {
            int rd = in.read(bytes, len, 7 - len);
            if (rd == -1) {
                throw new IOException("header is to short");
            }
            len += rd;
        }
        if (!Arrays.equals(bytes, headers)) {
            throw new RemoteException("invalid header");
        }
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
        out.write(78);
        out.writeUTF(socket.getInetAddress().getHostAddress());
        out.writeInt(socket.getPort());
    }

    static void handShake(Socket socket) throws IOException {
        OutputStream out = socket.getOutputStream();
        out.write(headers);
        DataInputStream in = new DataInputStream(socket.getInputStream());
        int answer = in.read();
        if (answer != 78) {
            throw new IOException("GAME OVER");
        }
        String address = in.readUTF();
        int port = in.readInt();
        DataOutputStream sout = new DataOutputStream(out);
        sout.writeUTF(socket.getInetAddress().getHostAddress());
        sout.writeInt(socket.getPort());
        sout.flush();
    }

    private static Object verifyObject(Object o, int type) throws RemoteException {
        if (type == 1) {
            return o;
        }
        if (type == 2 && o instanceof Throwable) {
            if (o instanceof RemoteException) {
                throw (RemoteException)o;
            }
            if (o instanceof RuntimeException) {
                throw (RuntimeException)o;
            }
            if (o instanceof Exception) {
                throw new UnexpectedException("Unexpected server Exception", (Exception)o);
            }
            if (o instanceof Error) {
                throw new ServerError("Unexpected server Error", (Error)o);
            }
            throw new RemoteException("UnexpectedExeption", (Throwable)o);
        }
        throw new RemoteException("invalid response");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

