/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rmi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;

final class ParameterSet {
    static final ParameterSet NOARGS_SET = new ParameterSet(new Object[0]);
    private Method method;
    private Object[] params;

    final void writeData(ObjectOutputStream out) throws IOException {
        if (this.method != null) {
            Class[] classes = this.method.getParameterTypes();
            int i = 0;
            while (i < classes.length) {
                if (classes[i].isPrimitive()) {
                    ParameterSet.writePrimitive(classes[i], this.params[i], out);
                } else {
                    out.writeObject(this.params[i]);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.params.length) {
                out.writeObject(this.params[i]);
                ++i;
            }
        }
    }

    static final void writePrimitive(Class primitive, Object o, ObjectOutputStream oout) throws IOException {
        if (primitive == Integer.TYPE) {
            oout.writeInt((Integer)o);
        } else if (primitive == Long.TYPE) {
            oout.writeLong((Long)o);
        } else if (primitive == Double.TYPE) {
            oout.writeDouble((Double)o);
        } else if (primitive == Float.TYPE) {
            oout.writeFloat(((Float)o).floatValue());
        } else if (primitive == Short.TYPE) {
            oout.writeShort(((Short)o).shortValue());
        } else if (primitive == Byte.TYPE) {
            oout.writeByte(((Byte)o).byteValue());
        } else if (primitive == Character.TYPE) {
            oout.writeChar(((Character)o).charValue());
        } else if (primitive == Boolean.TYPE) {
            oout.writeBoolean((Boolean)o);
        }
    }

    static final Object readPrimitive(Class primitive, ObjectInputStream oin) throws IOException {
        if (primitive == Integer.TYPE) {
            return new Integer(oin.readInt());
        }
        if (primitive == Long.TYPE) {
            return new Long(oin.readLong());
        }
        if (primitive == Double.TYPE) {
            return new Double(oin.readDouble());
        }
        if (primitive == Float.TYPE) {
            return new Float(oin.readFloat());
        }
        if (primitive == Short.TYPE) {
            return new Short(oin.readShort());
        }
        if (primitive == Byte.TYPE) {
            return new Byte(oin.readByte());
        }
        if (primitive == Character.TYPE) {
            return new Character(oin.readChar());
        }
        if (primitive == Boolean.TYPE) {
            return new Boolean(oin.readBoolean());
        }
        throw new IOException("Cannot read of variable of type void");
    }

    ParameterSet(Method method, Object[] params) {
        this.method = method;
        this.params = params;
    }

    ParameterSet(Object[] params) {
        this.params = params;
    }
}

