/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.net.http;

import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends InputStream {
    private InputStream in;
    private int count;
    private boolean eof;

    public void close() throws IOException {
        this.count = 0;
        this.in.close();
    }

    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.count == 0 && this.nextChunk(true)) {
            return -1;
        }
        --this.count;
        int rd = this.in.read();
        if (rd == -1) {
            throw new IOException("unexpected EOF");
        }
        return rd;
    }

    public int read(byte[] bytes, int o, int l) throws IOException {
        int rd;
        if (this.eof) {
            return -1;
        }
        if (this.count == 0 && this.nextChunk(true)) {
            return -1;
        }
        if (this.count < l) {
            l = this.count;
        }
        if ((rd = this.in.read(bytes, o, l)) == -1) {
            throw new IOException();
        }
        this.count -= rd;
        return rd;
    }

    private final boolean nextChunk(boolean skip) throws IOException {
        try {
            int size;
            String line;
            int idx;
            if (skip) {
                this.in.skip(2);
            }
            if ((idx = (line = this.readLine()).indexOf(59)) != -1) {
                line = line.substring(0, idx);
            }
            if ((size = Integer.parseInt(line, 16)) == 0) {
                this.eof = true;
                while (!"".equals(this.readLine())) {
                }
                return true;
            }
            this.count = size;
            return false;
        }
        catch (RuntimeException rt) {
            rt.printStackTrace();
            throw new IOException("bad chunck -- 1");
        }
    }

    private final String readLine() throws IOException {
        StringBuffer buf = new StringBuffer(64);
        int ch = this.in.read();
        while (ch != -1) {
            if (ch == 13) {
                ch = this.in.read();
                if (ch == 10) break;
                throw new IOException("bad chunck -- 2");
            }
            buf.append((char)ch);
            ch = this.in.read();
        }
        return buf.toString();
    }

    ChunkedInputStream(InputStream in) throws IOException {
        this.in = in;
        this.nextChunk(false);
    }
}

