/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.net.http;

import com.acunia.wonka.net.http.ChunkedInputStream;
import com.acunia.wonka.net.http.HttpOutputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import wonka.decoders.Latin1Decoder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BasicHttpURLConnection
extends HttpURLConnection {
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'");
    private static SimpleDateFormat rfc850Parser = new SimpleDateFormat("EEEE, dd-MMM-yy HH:mm:ss 'GMT'");
    private static SimpleDateFormat asctimeParser = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy");
    private static Latin1Decoder decoder = new Latin1Decoder();
    private Socket socket;
    private InputStream in;
    private HttpOutputStream out;
    private Properties requestHeaders;
    private Properties responseHeaders;
    private ArrayList keys;

    public synchronized void connect() throws IOException {
        if (!this.connected) {
            this.responseHeaders = new Properties();
            this.keys = new ArrayList();
            int port = this.url.getPort();
            this.socket = new Socket(this.url.getHost(), port == -1 ? 80 : port);
            this.in = new BufferedInputStream(this.socket.getInputStream(), 4096);
            this.connected = true;
            if ("PUT".equals(this.method) || "POST".equals(this.method)) {
                OutputStream out = this.socket.getOutputStream();
                out.write(this.getRequestLine().getBytes());
                this.sendPartialHeaders(out);
                this.doOutput = true;
            } else if ("GET".equals(this.method)) {
                this.requestGET();
            } else if ("HEAD".equals(this.method)) {
                this.requestGET();
            } else if ("DELETE".equals(this.method)) {
                this.requestGET();
            } else if ("OPTIONS".equals(this.method)) {
                this.requestGET();
            } else if ("TRACE".equals(this.method)) {
                this.requestGET();
            } else {
                throw new IOException("invalid method '" + this.method + '\'');
            }
        }
    }

    public synchronized void disconnect() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.connected = false;
            this.socket = null;
        }
        this.connected = false;
    }

    public String getHeaderField(int n) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return null;
            }
        }
        if (n < 0 || n >= this.keys.size()) {
            return null;
        }
        return (String)this.responseHeaders.get(this.keys.get(n));
    }

    public String getHeaderField(String name) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return null;
            }
        }
        return this.responseHeaders.getProperty(name);
    }

    public long getHeaderFieldDate(String name, long def) {
        String field = this.getHeaderField(name);
        if (field != null) {
            try {
                return dateFormatter.parse(field).getTime();
            }
            catch (ParseException pe1) {
                try {
                    return rfc850Parser.parse(field).getTime();
                }
                catch (ParseException pe2) {
                    try {
                        return asctimeParser.parse(field).getTime();
                    }
                    catch (ParseException pe3) {
                        // empty catch block
                    }
                }
            }
        }
        return def;
    }

    public String getHeaderFieldKey(int n) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return null;
            }
        }
        if (n < 0 || n >= this.keys.size()) {
            return null;
        }
        Object key = this.keys.get(n);
        if (key instanceof String) {
            return (String)key;
        }
        return null;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.in;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.doOutput) {
            throw new IOException("output is disabled");
        }
        if (this.out == null) {
            this.out = new HttpOutputStream(this.socket.getOutputStream(), this);
        }
        return this.out;
    }

    public String getRequestProperty(String key) {
        return this.requestHeaders.getProperty(key);
    }

    public void setIfModifiedSince(long time) {
        super.setIfModifiedSince(time);
        this.requestHeaders.put("If-modified-since", dateFormatter.format(new Date(time)));
    }

    public void setRequestProperty(String key, String value) {
        this.requestHeaders.put(key.toLowerCase(), value);
    }

    public boolean usingProxy() {
        return false;
    }

    private final String getRequestLine() {
        String file = this.url.getFile();
        String add = this.url.getRef();
        if (add != null) {
            file = file + '#' + add;
        }
        if (file.length() == 0) {
            file = "/";
        }
        return this.method + ' ' + file + " HTTP/1.1\r\n";
    }

    private final String getRequestHeaders() {
        StringBuffer request = new StringBuffer(1024);
        request.append("Connection: close\r\n");
        this.requestHeaders.remove("connection");
        request.append("Date: ");
        dateFormatter.format(new Date(), request, new FieldPosition(0));
        request.append("\r\n");
        Iterator it = this.requestHeaders.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            request.append(entry.getKey());
            request.append(": ");
            request.append(entry.getValue());
            request.append("\r\n");
        }
        request.append("\r\n");
        return request.toString();
    }

    private final void sendPartialHeaders(OutputStream out) throws IOException {
        StringBuffer request = new StringBuffer(1024);
        request.append("Connection: close\r\n");
        this.requestHeaders.remove("connection");
        this.requestHeaders.remove("content-length");
        request.append("Date: ");
        dateFormatter.format(new Date(), request, new FieldPosition(0));
        request.append("\r\n");
        Iterator it = this.requestHeaders.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            request.append(entry.getKey());
            request.append(": ");
            request.append(entry.getValue());
            request.append("\r\n");
        }
        int length = request.length();
        char[] chars = new char[length];
        request.getChars(0, length, chars, 0);
        out.write(decoder.cToB(chars, 0, length));
    }

    private final void requestGET() throws IOException {
        OutputStream out = this.socket.getOutputStream();
        out.write(this.getRequestLine().getBytes());
        out.write(this.getRequestHeaders().getBytes());
        this.doOutput = false;
        this.parseResponse();
    }

    void parseResponse() throws IOException {
        try {
            if (this.probeStatusLine()) {
                String line = this.readLine(false);
                int index = line.indexOf(32);
                String version = line.substring(0, index++);
                int end = line.indexOf(32, index);
                this.responseCode = Integer.parseInt(line.substring(index, end++));
                this.responseMessage = line.substring(end);
                while (!"".equals(line)) {
                    Object key;
                    index = line.indexOf(58);
                    if (index != -1) {
                        key = line.substring(0, index);
                        if (key.equals("")) {
                            key = new Integer(this.keys.size());
                        }
                        this.responseHeaders.put(key, line.substring(index + 1).trim());
                        this.keys.add(key);
                    } else {
                        key = new Integer(this.keys.size());
                        this.responseHeaders.put(key, line.trim());
                        this.keys.add(key);
                    }
                    line = this.readLine(true);
                }
            }
        }
        catch (RuntimeException rt) {
            rt.printStackTrace();
            throw new IOException();
        }
        if ("Chunked".equals(this.responseHeaders.getProperty("Transfer-Encoding"))) {
            this.in = new ChunkedInputStream(this.in);
        }
    }

    private final boolean probeStatusLine() throws IOException {
        byte[] bytes = new byte[5];
        this.in.mark(5);
        int len = this.in.read(bytes, 0, 5);
        this.in.reset();
        if (len == -1) {
            return false;
        }
        return "HTTP/".equals(new String(bytes, 0, len));
    }

    private final String readLine(boolean continued) throws IOException {
        StringBuffer buf = new StringBuffer(64);
        int ch = this.in.read();
        while (ch != -1) {
            boolean stop = false;
            if (ch == 13) {
                stop = true;
                this.in.mark(1);
                ch = this.in.read();
            }
            if (ch == 10) {
                if (buf.length() == 0) break;
                stop = true;
                this.in.mark(1);
                ch = this.in.read();
            }
            if (stop) {
                if (continued && (ch == 32 || ch == 9)) continue;
                this.in.reset();
                break;
            }
            buf.append((char)ch);
            ch = this.in.read();
        }
        return buf.toString();
    }

    private final /* synthetic */ void this() {
        this.requestHeaders = new Properties();
    }

    public BasicHttpURLConnection(URL url) {
        super(url);
        this.this();
        this.requestHeaders.put("accept-encoding", "gzip");
        this.requestHeaders.put("host", url.getHost() + (url.getPort() == -1 ? "" : ":" + String.valueOf(url.getPort())));
        this.requestHeaders.put("user-agent", "wonka Http protocol Handler");
    }

    static {
        try {
            TimeZone tz = TimeZone.getTimeZone("GMT");
            dateFormatter.setTimeZone(tz);
            rfc850Parser.setTimeZone(tz);
            asctimeParser.setTimeZone(tz);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

