/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.device.uart;

import java.io.IOException;
import java.io.InputStream;
import wonka.vm.Etc;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UARTInputStream
extends InputStream
implements Runnable {
    private int rxThreshold;
    private int rxTimeout;
    private int desired;
    private final long micronap = 100L;
    private final long meganap = 1000L;
    private byte[] microbuffer;
    private Thread uartMonitor;
    private boolean open;
    private String name;

    private final native void createFromString(String var1) throws SecurityException;

    private final native int readIntoBuffer(byte[] var1, int var2, int var3) throws IOException;

    public synchronized int read() throws IOException {
        int readlen = this.read(this.microbuffer, 0, 1);
        if (readlen > 0) {
            return this.microbuffer[0] & 0xFF;
        }
        return readlen;
    }

    public synchronized int read(byte[] b) throws IOException, NullPointerException {
        return this.read(b, 0, b.length);
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException, NullPointerException, ArrayIndexOutOfBoundsException {
        long remaining;
        long deadline;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.desired = this.rxThreshold > 0 ? this.rxThreshold : 1;
        if (this.rxTimeout > 0) {
            deadline = System.currentTimeMillis() + (long)this.rxTimeout;
            remaining = this.rxTimeout;
        } else {
            deadline = Long.MAX_VALUE;
            remaining = Long.MAX_VALUE;
        }
        this.notify();
        try {
            while (remaining > 0L && this.available() < this.desired) {
                if (this.rxTimeout > 0) {
                    this.wait(remaining);
                    remaining = deadline - System.currentTimeMillis();
                    continue;
                }
                this.wait(100L);
            }
        }
        catch (InterruptedException bytesToRead) {
            // empty catch block
        }
        int bytesToRead = this.available();
        this.desired = 0;
        if (bytesToRead == 0) {
            return -1;
        }
        if (bytesToRead > len) {
            return this.readIntoBuffer(b, off, len);
        }
        return this.readIntoBuffer(b, off, bytesToRead);
    }

    public native long skip0(long var1) throws IOException;

    public long skip(long n) throws IOException {
        int bytesToRead = this.available();
        if (bytesToRead == 0) {
            return 0L;
        }
        if ((long)bytesToRead > n) {
            return this.skip0(n);
        }
        return this.skip0(bytesToRead);
    }

    public synchronized native int available() throws IOException;

    private final native void close0();

    public synchronized void close() throws IOException {
        if (this.open) {
            this.open = false;
            this.close0();
        }
    }

    public synchronized void setRxThreshold(int t) {
        if (t == 0) {
            this.clearRxThreshold();
        } else {
            if (this.uartMonitor == null) {
                Etc.woempa(9, "setRxThreshold: starting a monitor thread for " + this.name);
                this.uartMonitor = new Thread(this, this.name + "-monitor");
                this.uartMonitor.start();
            }
            this.rxThreshold = t;
            this.notify();
        }
    }

    public void clearRxThreshold() {
        this.rxThreshold = 0;
        this.desired = 1;
        this.notify();
    }

    public synchronized void setRxTimeout(int t) {
        if (t == 0) {
            this.clearRxTimeout();
        } else {
            if (this.uartMonitor == null) {
                Etc.woempa(9, "setRxTimeout: starting a monitor thread for " + this.name);
                this.uartMonitor = new Thread(this, this.name + "-monitor");
                this.uartMonitor.start();
            }
            this.rxTimeout = t;
            this.notify();
        }
    }

    public void clearRxTimeout() {
        this.rxTimeout = 0;
        this.notify();
    }

    public synchronized void run() {
        while (this.open) {
            try {
                while (this.available() < this.desired) {
                    this.wait(100L);
                }
                this.notify();
                this.wait(1000L);
            }
            catch (InterruptedException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private final /* synthetic */ void this() {
        this.rxThreshold = 0;
        this.rxTimeout = 0;
        this.microbuffer = new byte[1];
        this.uartMonitor = null;
    }

    public UARTInputStream(String portname) {
        this.this();
        this.createFromString(portname);
        this.name = portname;
        this.open = true;
    }
}

