/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.vm;

public class SystemTest {
    static final int ASX = 10;
    static final int NPX = 20;
    static final int ISX = 30;
    static final int AOK = 40;
    static final int ERR = 50;

    public static void fill(int[] a) {
        int i = 0;
        while (i < a.length) {
            a[i] = i;
            ++i;
        }
    }

    public static boolean check(int[] expect, int[] result) {
        boolean bl = false;
        if (expect.length == result.length) {
            bl = true;
        }
        boolean ok = bl;
        int i = 0;
        while (ok && i < expect.length) {
            if (expect[i] != result[i]) {
                ok = false;
            }
            ++i;
        }
        return ok;
    }

    public static int copy(Object from, int a, Object to2, int b, int c) {
        try {
            System.arraycopy(from, a, to2, b, c);
            return 40;
        }
        catch (ArrayStoreException xa) {
            return 10;
        }
        catch (IndexOutOfBoundsException xb) {
            return 30;
        }
        catch (NullPointerException xc) {
            return 20;
        }
        catch (Throwable xd) {
            return 50;
        }
    }

    public int test() {
        int[] x = new int[5];
        int[] y = new int[5];
        SystemTest.fill(x);
        if (SystemTest.copy(x, 0, y, 0, x.length) != 40) {
            return 160;
        }
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        int[] one = nArray;
        if (!SystemTest.check(y, one)) {
            return 170;
        }
        if (SystemTest.copy(x, 1, y, 0, x.length - 1) != 40) {
            return 180;
        }
        if (SystemTest.copy(x, 0, y, x.length - 1, 1) != 40) {
            return 190;
        }
        int[] nArray2 = new int[5];
        nArray2[0] = 1;
        nArray2[1] = 2;
        nArray2[2] = 3;
        nArray2[3] = 4;
        int[] two = nArray2;
        if (!SystemTest.check(y, two)) {
            return 200;
        }
        Object[] z = new Object[5];
        if (SystemTest.copy(x, 0, z, 0, x.length) != 10) {
            return 210;
        }
        if (SystemTest.copy(x, 0, y, 0, -23) != 30) {
            return 220;
        }
        if (SystemTest.copy(null, 0, y, 0, -23) != 20) {
            return 230;
        }
        if (SystemTest.copy(x, 0, null, 0, -23) != 20) {
            return 240;
        }
        String q = "metonymy";
        if (SystemTest.copy(q, 0, y, 0, 19) != 10) {
            return 250;
        }
        if (SystemTest.copy(x, 0, q, 0, 19) != 10) {
            return 260;
        }
        double[] v = new double[5];
        if (SystemTest.copy(x, 0, v, 0, 5) != 10) {
            return 270;
        }
        if (SystemTest.copy(x, -1, y, 0, 1) != 30) {
            return 280;
        }
        if (SystemTest.copy(x, 0, z, 0, x.length) != 10) {
            return 290;
        }
        if (SystemTest.copy(x, 0, y, -1, 1) != 30) {
            return 300;
        }
        if (SystemTest.copy(x, 3, y, 0, 5) != 30) {
            return 310;
        }
        if (SystemTest.copy(x, 0, y, 3, 5) != 30) {
            return 320;
        }
        Object[] w = new Object[5];
        String[] ss = new String[5];
        int i = 0;
        while (i < 5) {
            w[i] = "" + i;
            ss[i] = "" + (i + 23);
            ++i;
        }
        w[3] = new Integer(23);
        if (SystemTest.copy(w, 0, ss, 0, 5) != 10) {
            return 330;
        }
        if (!ss[0].equals("0")) {
            return 340;
        }
        if (!ss[1].equals("1")) {
            return 350;
        }
        if (!ss[2].equals("2")) {
            return 360;
        }
        if (!ss[3].equals("26")) {
            return 370;
        }
        if (!ss[4].equals("27")) {
            return 380;
        }
        return 0;
    }
}

