/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.util.zip;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipTest
implements Testlet {
    private TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.util.zip.Adler32");
        this.quick_Adler();
        this.th.setclass("java.util.zip.CRC32");
        this.quick_CRC();
        this.th.setclass("java.util.zip.Deflater");
        this.test_Deflater();
        this.quick_Deflater();
        this.th.setclass("java.util.zip.ZipOutputStream");
        this.test_stored();
        this.th.setclass("java.util.zip.DeflaterOutputStream");
        this.test_streams();
        this.th.setclass("java.util.zip.ZipOutputStream");
        this.create_file();
        this.th.setclass("java.util.jar.JarOutputStream");
        this.create_Jarfile();
        this.th.setclass("java.util.jar.JarFile");
    }

    public void test_Deflater() {
        this.th.checkPoint("Deflater()");
        try {
            Deflater def = new Deflater();
            def.end();
            def.finished();
            def.getTotalIn();
            def.getTotalOut();
            def.getAdler();
            def.needsInput();
            def.finish();
            def.reset();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void test_stored() {
        this.th.checkPoint("ZipOutputStream(java.io.OutputStream)");
        try {
            File file = new File("stored.zip");
            int i = 0;
            FileOutputStream fos = new FileOutputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ZipEntry ze = new ZipEntry("entry1");
            CRC32 crc = new CRC32();
            String s = "Acunia\ntest stored data";
            byte[] buf = s.getBytes();
            crc.update(buf);
            ze.setSize(23L);
            ze.setCrc(crc.getValue());
            ze.setCompressedSize(23L);
            ze.setMethod(0);
            ZipOutputStream zos = new ZipOutputStream(bos);
            zos.putNextEntry(ze);
            zos.write(buf);
            zos.setMethod(0);
            ze = new ZipEntry("entry2");
            String s2 = "Acunia\ntest2 stored data";
            buf = s2.getBytes();
            crc.reset();
            crc.update(buf);
            ze.setSize(24L);
            ze.setTime(0L);
            ze.setCrc(crc.getValue());
            ze.setCompressedSize(24L);
            zos.putNextEntry(ze);
            zos.write(buf);
            buf = new byte[10000];
            i = 0;
            while (i < 10000) {
                buf[i] = (byte)i;
                ++i;
            }
            crc.reset();
            crc.update(buf);
            ze = new ZipEntry("entry3");
            ze.setMethod(8);
            ze.setSize(10000L);
            ze.setCrc(crc.getValue());
            ze.setCompressedSize(381L);
            zos.putNextEntry(ze);
            zos.write(buf);
            ze = new ZipEntry("entry4");
            zos.setMethod(8);
            ze.setSize(10000L);
            ze.setCrc(crc.getValue());
            ze.setCompressedSize(381L);
            zos.putNextEntry(ze);
            zos.write(buf);
            byte[] buf2 = (byte[])buf.clone();
            zos.close();
            buf = bos.toByteArray();
            fos.write(buf);
            fos.close();
            FileInputStream fis = new FileInputStream(file);
            this.th.setclass("java.util.zip.ZipInputStream");
            this.th.checkPoint("ZipInputStream(java.io.InputStream)");
            ZipInputStream zip = new ZipInputStream(fis);
            buf = new byte[10000];
            ze = zip.getNextEntry();
            i = zip.read(buf);
            crc.reset();
            crc.update(buf, 0, i);
            this.th.checkPoint("getNextEntry()java.util.zip.ZipEntry");
            this.th.check(i, 23, "23 stored bytes read");
            this.th.check(new String(buf, 0, i), s, "data read");
            this.th.check(ze.getName(), "entry1", "check name ...");
            this.th.check(ze.getSize(), 23L, "check size ...");
            this.th.check(ze.getCrc(), crc.getValue(), "check crc32 ...");
            this.th.check(ze.getCompressedSize(), 23L, "check compressed size ...");
            this.th.check(ze.getMethod(), 0, "check method ...");
            ze = zip.getNextEntry();
            i = zip.read(buf);
            this.th.check(i, 24, "24 stored bytes read");
            this.th.check(new String(buf, 0, i), s2, "data read");
            crc.reset();
            crc.update(buf, 0, i);
            this.th.check(ze.getName(), "entry2", "check name ...");
            this.th.check(ze.getSize(), 24L, "check size ...");
            this.th.check(ze.getCrc(), crc.getValue(), "check crc32 ...");
            this.th.check(ze.getCompressedSize(), 24L, "check compressed size ...");
            this.th.check(ze.getMethod(), 0, "check method ...");
            ze = zip.getNextEntry();
            i = zip.read(buf);
            this.th.check(i, 10000, "10000 stored bytes read");
            this.th.check(Arrays.equals(buf, buf2), "verify data read");
            crc.reset();
            crc.update(buf, 0, i);
            this.th.check(ze.getName(), "entry3", "check name ...");
            this.th.check(ze.getSize(), 10000L, "check size ...");
            this.th.check(ze.getCrc(), crc.getValue(), "check crc32 ...");
            this.th.check(ze.getCompressedSize(), 381L, "check compressed size ...");
            this.th.check(ze.getMethod(), 8, "check method ...");
            ze = zip.getNextEntry();
            i = zip.read(buf);
            this.th.check(i, 10000, "10000 stored bytes read");
            this.th.check(Arrays.equals(buf, buf2), "verify data read");
            crc.reset();
            crc.update(buf, 0, i);
            this.th.check(ze.getName(), "entry4", "check name ...");
            this.th.check(ze.getSize(), 10000L, "check size ...");
            this.th.check(ze.getCrc(), crc.getValue(), "check crc32 ...");
            this.th.check(ze.getCompressedSize(), 381L, "check compressed size ...");
            this.th.check(ze.getMethod(), 8, "check method ...");
            this.th.check(zip.getNextEntry(), null, "null expected");
            this.th.check(zip.getNextEntry(), null, "null expected");
            this.th.check(zip.getNextEntry(), null, "null expected");
            zip.close();
            this.th.setclass("java.util.zip.ZipFile");
            this.th.checkPoint("ZipFile(java.io.File)");
            ZipFile zf = new ZipFile(file);
            Enumeration<? extends ZipEntry> e = zf.entries();
            ze = e.nextElement();
            InputStream in = zf.getInputStream(ze);
            i = in.read(buf);
            crc.reset();
            crc.update(buf, 0, i);
            this.th.check(i, 23, "23 stored bytes read");
            this.th.check(new String(buf, 0, i), s, "data read");
            this.th.check(ze.getName(), "entry1", "check name ...");
            this.th.check(ze.getSize(), 23L, "check size ...");
            this.th.check(ze.getCrc(), crc.getValue(), "check crc32 ...");
            this.th.check(ze.getCompressedSize(), 23L, "check compressed size ...");
            this.th.check(ze.getMethod(), 0, "check method ...");
            this.th.checkPoint("entries()java.util.Enumeration");
            ze = e.nextElement();
            in = zf.getInputStream(ze);
            i = in.read(buf);
            this.th.check(i, 24, "24 stored bytes read");
            this.th.check(new String(buf, 0, i), s2, "data read");
            crc.reset();
            crc.update(buf, 0, i);
            this.th.check(ze.getName(), "entry2", "check name ...");
            this.th.check(ze.getSize(), 24L, "check size ...");
            this.th.check(ze.getCrc(), crc.getValue(), "check crc32 ...");
            this.th.check(ze.getCompressedSize(), 24L, "check compressed size ...");
            this.th.check(ze.getMethod(), 0, "check method ...");
            this.th.checkPoint("getInputStream(java.util.zip.ZipEntry)java.io.InputStream");
            ze = e.nextElement();
            in = zf.getInputStream(ze);
            i = in.read(buf);
            this.th.check(i, 10000, "10000 stored bytes read");
            this.th.check(Arrays.equals(buf, buf2), "verify data read");
            crc.reset();
            crc.update(buf, 0, i);
            this.th.check(ze.getName(), "entry3", "check name ...");
            this.th.check(ze.getSize(), 10000L, "check size ...");
            this.th.check(ze.getCrc(), crc.getValue(), "check crc32 ...");
            this.th.check(ze.getCompressedSize(), 381L, "check compressed size ...");
            this.th.check(ze.getMethod(), 8, "check method ...");
            ze = e.nextElement();
            in = zf.getInputStream(ze);
            i = in.read(buf);
            this.th.check(i, 10000, "10000 stored bytes read");
            this.th.check(Arrays.equals(buf, buf2), "verify data read");
            crc.reset();
            crc.update(buf, 0, i);
            this.th.check(ze.getName(), "entry4", "check name ...");
            this.th.check(ze.getSize(), 10000L, "check size ...");
            this.th.check(ze.getCrc(), crc.getValue(), "check crc32 ...");
            this.th.check(ze.getCompressedSize(), 381L, "check compressed size ...");
            this.th.check(ze.getMethod(), 8, "check method ...");
            this.th.check(e.hasMoreElements() ^ true, "no more Entries");
        }
        catch (Exception e) {
            this.th.fail("unwanted exception");
            e.printStackTrace();
        }
    }

    public void quickJarFile() {
        this.th.checkPoint("JarFile(java.lang.String)");
        try {
            File file = new File("pyramid.jar");
            byte[] buf = new byte[1000];
            int i = 0;
            FileInputStream fis = new FileInputStream(file);
            i = fis.read(buf, 0, 1000);
            JarFile zf = new JarFile(file);
            this.th.checkPoint("getManifest()java.util.zip.Manifest");
            boolean bl = false;
            if (zf.getManifest() != null) {
                bl = true;
            }
            this.th.check(bl, "Manifest is avialable");
            byte[] bytes = new byte[100];
            JarEntry ze = null;
            this.th.checkPoint("entries()java.util.Enumeration");
            Enumeration<JarEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ze = e.nextElement();
            }
            e = zf.entries();
            InputStream is = zf.getInputStream(ze);
            i = is.read(buf, 0, 1000);
            file = new File(ze.getName());
            file = new File(file.getName());
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(buf, 0, i);
            fos.close();
        }
        catch (Exception e) {
            this.th.fail("unwanted exception");
            e.printStackTrace();
        }
    }

    public void create_Jarfile() {
        this.th.checkPoint("JarOutputStream(java.io.OutputStream)");
        try {
            File file = new File("test2.jar");
            file.createNewFile();
            String s = "abcdefghijklmnopqrstuvwxyz";
            String sa = "Acunia rules !, yeah baby \nmore input";
            FileOutputStream fos = new FileOutputStream(file);
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            JarOutputStream gzo = new JarOutputStream(bas);
            ZipEntry ze = new ZipEntry("./gnu/jtest.txt");
            ze.setComment("cool\r\n");
            ze.setExtra("toppie\r\n".getBytes());
            gzo.putNextEntry(ze);
            gzo.write(s.getBytes());
            ze.setComment("\noverwrite\r\n");
            ze.setExtra("floppie\r\n".getBytes());
            try {
                gzo.putNextEntry(ze);
                this.th.fail("should throw ZipException");
            }
            catch (ZipException zipe) {
                this.th.check(true);
            }
            ze = new ZipEntry("./jAcunia.txt");
            gzo.putNextEntry(ze);
            gzo.write(sa.getBytes());
            gzo.setComment("hello world JAR UP !!!");
            gzo.finish();
            fos.write(bas.toByteArray());
            fos.close();
            this.th.setclass("java.util.jar.JarInputStream");
            this.th.checkPoint("JarInputStream(java.io.InputStream)");
            FileInputStream fin = new FileInputStream(file);
            JarInputStream zip = new JarInputStream(fin);
            byte[] bytes = new byte[100];
            ze = zip.getNextEntry();
            boolean bl = false;
            if (zip.getManifest() != null) {
                bl = true;
            }
            this.th.check(bl, "Manifest should be found");
            this.th.check(ze.getName(), (Object)"./gnu/jtest.txt");
            int read = zip.read(bytes, 0, 100);
            this.th.check(new String(bytes, 0, read), s, "checking contents");
            this.th.check(zip.read(bytes), -1, "no bytes available");
            ze = zip.getNextEntry();
            this.th.check(ze.getName(), (Object)"./jAcunia.txt");
            read = zip.read(bytes, 0, 100);
            this.th.check(read, 37, "37 bytes available");
            this.th.check(new String(bytes, 0, read), sa, "checking data");
            ze = zip.getNextEntry();
            this.th.check(ze, null, "null should be returned");
            this.th.check(zip.read(bytes), -1, "no bytes available");
            this.th.setclass("java.util.jar.JarFile");
            this.th.checkPoint("JarFile(java.io.File)");
            JarFile zf = new JarFile(file);
            Enumeration<JarEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ze = e.nextElement();
                InputStream is = zf.getInputStream(ze);
                byte[] buf = new byte[100];
                int i = is.read(buf, 0, 100);
            }
        }
        catch (Exception e) {
            this.th.fail("unwanted exception");
            e.printStackTrace();
        }
    }

    public void create_file() {
        this.th.checkPoint("ZipOutputStream(java.io.OutputStream)");
        try {
            ZipEntry ze;
            File file = new File("./test.zip");
            file.createNewFile();
            String s = "abcdefghijklmnopqrstuvwxyz";
            String sa = "Acunia rules !, yeah baby \nmore input";
            FileOutputStream fos = new FileOutputStream(file);
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            int i = 0;
            while (i < 3) {
                ZipOutputStream gzo = new ZipOutputStream(bas);
                ze = new ZipEntry("./gnu/test.txt");
                ze.setComment("cool\r\n");
                ze.setExtra("toppie\r\n".getBytes());
                gzo.putNextEntry(ze);
                gzo.write(s.getBytes());
                ze.setComment("\noverwrite\r\n");
                ze.setExtra("floppie\r\n".getBytes());
                try {
                    gzo.putNextEntry(ze);
                    this.th.fail("should throw ZipException");
                }
                catch (ZipException zipe) {
                    this.th.check(true);
                }
                ze = new ZipEntry("./Acunia.txt");
                this.th.checkPoint("putNextEntry(java.util.zip.ZipEntry)void");
                gzo.putNextEntry(ze);
                gzo.write(sa.getBytes());
                gzo.setComment("hello world");
                gzo.finish();
                ++i;
            }
            fos.write(bas.toByteArray());
            fos.close();
            this.th.setclass("java.util.zip.ZipInputStream");
            this.th.checkPoint("ZipInputStream(java.io.InputStream)");
            FileInputStream fin = new FileInputStream(file);
            ZipInputStream zip = new ZipInputStream(fin);
            byte[] bytes = new byte[100];
            this.th.check(zip.read(bytes), -1, "no bytes available");
            ze = zip.getNextEntry();
            this.th.check(ze.getName(), (Object)"./gnu/test.txt");
            int read = zip.read(bytes, 0, 100);
            this.th.check(read, 26, "26 bytes available");
            this.th.check(new String(bytes, 0, read), s, "checking contents");
            this.th.check(zip.read(bytes), -1, "no bytes available");
            this.th.checkPoint("getNextEntry()java.util.zip.ZipEntry");
            ze = zip.getNextEntry();
            this.th.check(ze.getName(), (Object)"./Acunia.txt");
            read = zip.read(bytes, 0, 100);
            this.th.check(read, 37, "37 bytes available");
            this.th.check(new String(bytes, 0, read), sa, "checking data");
            bytes = new byte[100];
            this.th.check(zip.read(bytes), -1, "no bytes available");
            ze = zip.getNextEntry();
            this.th.check(ze.getName(), "./gnu/test.txt", "got name");
            read = zip.read(bytes, 0, 100);
            this.th.check(read, 26, "26 bytes available");
            this.th.check(new String(bytes, 0, read), s, "checking contents");
            this.th.check(zip.read(bytes), -1, "no bytes available");
            ze = zip.getNextEntry();
            this.th.check(ze.getName(), "./Acunia.txt", "got name");
            read = zip.read(bytes, 0, 100);
            this.th.check(read, 37, "37 bytes available");
            this.th.check(new String(bytes, 0, read), sa, "checking data");
            ze = zip.getNextEntry();
            this.th.check(ze.getName(), (Object)"./gnu/test.txt");
            ze = zip.getNextEntry();
            this.th.check(ze.getName(), "./Acunia.txt", "got name");
            this.th.check(ze.getSize(), (long)-1, "checking Size");
            this.th.check(ze.getCompressedSize(), (long)-1, "checking Size");
            this.th.check(ze.getCrc(), (long)-1, "checking Size");
            this.th.checkPoint("closeEntry()void");
            zip.closeEntry();
            this.th.check(ze.getSize(), 37L, "checking Size");
            this.th.check(ze.getCompressedSize(), 66L, "checking Size");
            this.th.check(ze.getCrc(), 266064239L, "checking Size");
            ze = zip.getNextEntry();
            this.th.check(ze, null, "null should be returned");
            this.th.setclass("java.util.zip.ZipFile");
            this.th.checkPoint("ZipFile(java.io.File)");
            ZipFile zf = new ZipFile(file);
            Enumeration<? extends ZipEntry> e = zf.entries();
            ze = e.nextElement();
            InputStream is = zf.getInputStream(ze);
            byte[] buf = new byte[100];
            int i2 = is.read(buf, 0, 100);
            ze = e.nextElement();
            is = zf.getInputStream(ze);
            i2 = is.read(buf, 0, 100);
        }
        catch (Exception e) {
            this.th.fail("unwanted exception");
            e.printStackTrace();
        }
    }

    public void test_streams() {
        InflaterInputStream gzi;
        byte[] buf;
        DeflaterOutputStream gzo;
        ByteArrayOutputStream bas;
        this.th.checkPoint("DeflaterOutputStream(java.io.OutputStream)");
        try {
            bas = new ByteArrayOutputStream();
            gzo = new DeflaterOutputStream(bas);
            buf = new byte[10000];
            int i = 0;
            while (i < 10000) {
                buf[i] = (byte)i;
                ++i;
            }
            gzo.write(buf, 0, 10000);
            gzo.finish();
            bas.write(buf, 0, 10);
            Inflater inf = new Inflater(false);
            byte[] buf2 = bas.toByteArray();
            this.th.check(inf.needsInput(), "input needed");
            this.th.check(inf.finished() ^ true, "new Inflater is not finished");
            inf.setInput(buf2);
            buf2 = new byte[10000];
            inf.inflate(buf2);
            this.th.check(Arrays.equals(buf, buf2), "array should be equal -- 1");
            inf = new Inflater(false);
            buf2 = bas.toByteArray();
            this.th.check(inf.needsInput(), "input needed");
            this.th.check(inf.finished() ^ true, "new Inflater is not finished");
            inf.setInput(buf2);
            buf2 = new byte[10000];
            inf.inflate(buf2);
            this.th.check(Arrays.equals(buf, buf2), "array should be equal -- 2");
            this.th.check(inf.getRemaining(), 10, "checking remaining bytes");
            inf = new Inflater();
            buf2 = new byte[10000];
            gzi = new InflaterInputStream(new ByteArrayInputStream(bas.toByteArray()), inf);
            this.th.check(gzi.read(buf2), 10000, "checking return value");
            this.th.check(gzi.available(), 1, "stream has finished");
            this.th.check(inf.getRemaining(), 10, "checking remaining bytes");
            this.th.check(Arrays.equals(buf, buf2), "array should be equal");
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception -- de/inflater streams -- 1");
            e.printStackTrace();
        }
        this.th.setclass("java.util.zip.InflaterInputStream");
        this.th.checkPoint("InflaterInputStream(java.io.InputStream)");
        try {
            bas = new ByteArrayOutputStream();
            gzo = new DeflaterOutputStream((OutputStream)bas, new Deflater(8, true));
            buf = new byte[10000];
            int i = 0;
            while (i < 10000) {
                buf[i] = (byte)i;
                ++i;
            }
            byte[] buf2 = (byte[])buf.clone();
            gzo.write(buf, 0, 10000);
            gzo.finish();
            Inflater inf = new Inflater(true);
            gzi = new InflaterInputStream(new ByteArrayInputStream(bas.toByteArray()), inf);
            buf = new byte[10000];
            this.th.check(gzi.read(buf), 10000, "checking return value");
            this.th.check(Arrays.equals(buf, buf2), "array should be equal");
            this.th.check(inf.finished() ^ true, "not finished yet (still expects adler32)");
            bas = new ByteArrayOutputStream();
            gzo = new DeflaterOutputStream((OutputStream)bas, new Deflater(8, true));
            gzo.write(buf2, 0, 10000);
            gzo.finish();
            bas.write(buf2, 0, 10);
            inf = new Inflater(true);
            gzi = new InflaterInputStream(new ByteArrayInputStream(bas.toByteArray()), inf);
            buf = new byte[10000];
            this.th.check(gzi.read(buf), 10000, "checking return value");
            this.th.check(Arrays.equals(buf, buf2), "array should be equal");
            this.th.check(gzi.read(buf), -1, "checking return value");
            this.th.check(inf.finished(), "finished (used extra bytes to fake adler32)");
            this.th.check(inf.getRemaining(), 10, "10 bytes left");
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception -- de/inflater streams -- 2");
            e.printStackTrace();
        }
        this.th.setclass("java.util.zip.GZIPInputStream");
        this.th.checkPoint("GZIPInputStream(java.io.InputStream");
        try {
            bas = new ByteArrayOutputStream();
            gzo = new GZIPOutputStream(bas);
            buf = new byte[10000];
            int i = 0;
            while (i < 10000) {
                buf[i] = (byte)i;
                ++i;
            }
            byte[] buf2 = (byte[])buf.clone();
            ((GZIPOutputStream)gzo).write(buf, 0, 10000);
            ((GZIPOutputStream)gzo).finish();
            GZIPInputStream gzi2 = new GZIPInputStream(new ByteArrayInputStream(bas.toByteArray()));
            buf = new byte[10000];
            this.th.check(gzi2.read(buf), 10000, "checking return value");
            this.th.setclass("java.util.zip.GZIPOutputStream");
            this.th.checkPoint("GZIPOutputStream(java.io.OutputStream");
            this.th.check(Arrays.equals(buf, buf2), "array should be equal");
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception -- GZIPstreams");
            e.printStackTrace();
        }
    }

    public void quick_Deflater() {
        this.th.checkPoint("Deflater(int,boolean)");
        byte[] buf = new byte[10000];
        int i = 0;
        while (i < 10000) {
            buf[i] = (byte)i;
            ++i;
        }
        byte[] buf2 = (byte[])buf.clone();
        Deflater def = new Deflater(8, false);
        this.th.checkPoint("needsInput()boolean");
        this.th.check(def.needsInput(), "a new Defalter needs input");
        this.th.checkPoint("finished()boolean");
        this.th.check(def.finished() ^ true, "a new Deflater is not finished");
        def.setInput(buf, 0, 10000);
        buf = new byte[10000];
        def.finish();
        this.th.checkPoint("deflate(byte[],int,int)int");
        this.th.check(def.deflate(buf, 0, 100), 100, "checking return value");
        int rem = 100 + def.deflate(buf, 100, 9900);
        this.th.checkPoint("DEFAULT_COMPRESSION(public)int");
        this.th.check(-1, -1, "DEFAULT_COMPRESSION");
        this.th.checkPoint("BEST_COMPRESSION(public)int");
        this.th.check(9, 9, "BEST_COMPRESSION ");
        this.th.checkPoint("BEST_SPEED(public)int");
        this.th.check(1, 1, "BEST_SPEED");
        this.th.checkPoint("NO_COMPRESSION(public)int");
        this.th.check(0, 0, "NO_COMPRESSION ");
        this.th.checkPoint("DEFLATED(public)int");
        this.th.check(8, 8, "DEFLATED");
        this.th.checkPoint("DEFAULT_STRATEGY(public)int");
        this.th.check(0, 0, "DEFAULT_STRATEGY");
        this.th.checkPoint("FILTERED(public)int");
        this.th.check(1, 1, "FILTERED");
        this.th.checkPoint("HUFFMAN_ONLY(public)int");
        this.th.check(2, 2, "HUFFMAN_ONLY");
        this.th.setclass("java.util.zip.Inflater");
        Inflater inf = new Inflater(false);
        this.th.checkPoint("needsInput()boolean");
        this.th.check(inf.needsInput(), "a new Defalter needs input");
        this.th.checkPoint("finished()boolean");
        this.th.check(inf.finished() ^ true, "a new Deflater is not finished");
        inf.setInput(buf, 0, rem + 10);
        buf = new byte[10000];
        this.th.checkPoint("inflate(byte[],int,int)int");
        try {
            this.th.check(inf.inflate(buf, 0, 100), 100, "checking return value");
            this.th.check(inf.inflate(buf, 100, 9900), 9900, "checking return value");
            this.th.check(inf.getRemaining(), 10, "checking remaining bytes");
        }
        catch (DataFormatException dfe) {
            this.th.fail("shouldn't throw a DataFormatException");
            dfe.printStackTrace();
        }
        this.th.check(Arrays.equals(buf, buf2), "array should be equal");
    }

    public void quick_Adler() {
        this.th.checkPoint("getValue()long");
        Adler32 ad = new Adler32();
        this.th.check(ad.getValue(), 1L, "basic value -- 1");
        this.th.checkPoint("update(int)void");
        ad.update(255);
        this.th.check(ad.getValue(), 0x1000100L, "adding one byte");
        ad.update(25);
        this.th.check(ad.getValue(), 35193113L, "adding another byte");
        this.th.checkPoint("reset()void");
        ad.reset();
        this.th.check(ad.getValue(), 1L, "basic value -- 2");
        this.th.checkPoint("update(byte[])void");
        try {
            ad.update((byte[])null);
            this.th.fail("should throw a NullPointerException -- 1");
        }
        catch (NullPointerException npe) {
            this.th.check(true, "caught NullPointerException -- 1");
        }
        this.th.checkPoint("update(byte[],int,int)void");
        try {
            ad.update(null, 1, 2);
            this.th.fail("should throw a NullPointerException -- 2");
        }
        catch (NullPointerException npe) {
            this.th.check(true, "caught NullPointerException -- 2");
        }
        byte[] buf = new byte[5];
        try {
            ad.update(buf, -1, 2);
            this.th.fail("should throw a IndexOutOfBoundsException -- 3");
        }
        catch (ArrayIndexOutOfBoundsException npe) {
            this.th.check(true, "caught IndexOutOfBoundsException -- 3");
        }
        try {
            ad.update(buf, 1, -2);
            this.th.fail("should throw a IndexOutOfBoundsException -- 4");
        }
        catch (ArrayIndexOutOfBoundsException npe) {
            this.th.check(true, "caught IndexOutOfBoundsException -- 4");
        }
        try {
            ad.update(buf, 4, 2);
            this.th.fail("should throw a IndexOutOfBoundsException -- 5");
        }
        catch (ArrayIndexOutOfBoundsException npe) {
            this.th.check(true, "caught IndexOutOfBoundsException -- 5");
        }
        buf = new byte[1000];
        int i = 0;
        while (i < 1000) {
            buf[i] = (byte)i;
            ++i;
        }
        this.th.checkPoint("update(byte[])void");
        ad.update(buf);
        this.th.check(ad.getValue(), 486795068L, "complex value -- 1");
        buf = new byte[3000];
        i = 0;
        while (i < 3000) {
            buf[i] = -1;
            ++i;
        }
        ad.update(buf);
        this.th.check(ad.getValue(), 3513947192L, "complex value -- 2");
        buf = new byte[3000];
        i = 0;
        while (i < 3000) {
            buf[i] = 127;
            ++i;
        }
        ad.update(buf);
        this.th.check(ad.getValue(), 1959224538L, "complex value -- 3");
        ad.reset();
        this.th.check(ad.getValue(), 1L, "basic value -- 4");
        this.th.checkPoint("update(byte[],int,int)void");
        ad.update(buf, 5, 0);
        this.th.check(ad.getValue(), 1L, "basic value -- 5");
        i = 0;
        while (i < 1000) {
            buf[i] = (byte)i;
            ++i;
        }
        ad.update(buf, 0, 500);
        ad.update(buf, 500, 500);
        this.th.check(ad.getValue(), 486795068L, "complex value -- 1 bis");
    }

    public void quick_CRC() {
        this.th.checkPoint("getValue()long");
        CRC32 ad = new CRC32();
        this.th.check(ad.getValue(), 0L, "basic value -- 1");
        this.th.checkPoint("update(int)void");
        ad.update(255);
        this.th.check(ad.getValue(), 0xFF000000L, "adding one byte");
        ad.update(25);
        this.th.check(ad.getValue(), 3063301965L, "adding another byte");
        this.th.checkPoint("reset()void");
        ad.reset();
        this.th.check(ad.getValue(), 0L, "basic value -- 2");
        this.th.checkPoint("update(byte[])void");
        try {
            ad.update((byte[])null);
            this.th.fail("should throw a NullPointerException -- 1");
        }
        catch (NullPointerException npe) {
            this.th.check(true, "caught NullPointerException -- 1");
        }
        this.th.checkPoint("update(byte[],int,int)void");
        try {
            ad.update(null, 1, 2);
            this.th.fail("should throw a NullPointerException -- 2");
        }
        catch (NullPointerException npe) {
            this.th.check(true, "caught NullPointerException -- 2");
        }
        byte[] buf = new byte[5];
        try {
            ad.update(buf, -1, 2);
            this.th.fail("should throw a IndexOutOfBoundsException -- 3");
        }
        catch (ArrayIndexOutOfBoundsException npe) {
            this.th.check(true, "caught IndexOutOfBoundsException -- 3");
        }
        try {
            ad.update(buf, 1, -2);
            this.th.fail("should throw a IndexOutOfBoundsException -- 4");
        }
        catch (ArrayIndexOutOfBoundsException npe) {
            this.th.check(true, "caught IndexOutOfBoundsException -- 4");
        }
        try {
            ad.update(buf, 4, 2);
            this.th.fail("should throw a IndexOutOfBoundsException -- 5");
        }
        catch (ArrayIndexOutOfBoundsException npe) {
            this.th.check(true, "caught IndexOutOfBoundsException -- 5");
        }
        buf = new byte[1000];
        int i = 0;
        while (i < 1000) {
            buf[i] = (byte)i;
            ++i;
        }
        this.th.checkPoint("update(byte[])void");
        ad.update(buf);
        this.th.check(ad.getValue(), 1961098049L, "complex value -- 1");
        buf = new byte[3000];
        i = 0;
        while (i < 3000) {
            buf[i] = -1;
            ++i;
        }
        ad.update(buf);
        this.th.check(ad.getValue(), 319854888L, "complex value -- 2");
        buf = new byte[3000];
        i = 0;
        while (i < 3000) {
            buf[i] = 127;
            ++i;
        }
        ad.update(buf);
        this.th.check(ad.getValue(), 1717866834L, "complex value -- 3");
        ad.reset();
        this.th.check(ad.getValue(), 0L, "basic value -- 3");
        this.th.checkPoint("update(byte[],int,int)void");
        this.th.check(ad.getValue(), 0L, "basic value -- 4");
        ad.update(buf, 5, 0);
        this.th.check(ad.getValue(), 0L, "basic value -- 5");
        i = 0;
        while (i < 1000) {
            buf[i] = (byte)i;
            ++i;
        }
        ad.update(buf, 0, 500);
        ad.update(buf, 500, 500);
        this.th.check(ad.getValue(), 1961098049L, "complex value -- 1 bis");
    }

    public void printStream(byte[] s, int len, String message) {
        System.out.println(message + "--> Length of array: " + len);
        int i = 0;
        while (i < len) {
            System.out.print(Byte.toString(s[i]) + ", ");
            if ((i + 1) % 16 == 0) {
                System.out.println();
            }
            ++i;
        }
        System.out.println("\n");
    }
}

