/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.util.zip.GZIPInputStream;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class basic
implements Testlet {
    private final String readall(InputStream in) {
        StringBuffer sb = new StringBuffer();
        byte[] buf = new byte[512];
        try {
            int n;
            while ((n = in.read(buf)) > 0) {
                sb.append(new String(buf, 0, n, "8859_1"));
            }
        }
        catch (IOException _) {
            System.out.println("got exception while unzipping" + _);
            _.printStackTrace();
        }
        return sb.toString();
    }

    public void test(TestHarness harness) {
        GZIPInputStream gzin;
        harness.checkPoint("reading gzip file");
        String plain = "";
        FileInputStream is = null;
        try {
            is = new FileInputStream("/test/reference.data");
            plain = this.readall(is);
            gzin = new GZIPInputStream(new FileInputStream("/test/reference.gz"));
            String uncompressed = this.readall(gzin);
            harness.check(plain, (Object)uncompressed);
        }
        catch (IOException _2) {
            harness.check(false);
        }
        harness.checkPoint("compressing and re-reading");
        if (is == null) {
            harness.check(false);
        } else {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                GZIPOutputStream gzout = new GZIPOutputStream(bout);
                gzout.write(plain.getBytes("8859_1"));
                gzout.close();
                gzin = new GZIPInputStream(new ByteArrayInputStream(bout.toByteArray()));
                String full = this.readall(gzin);
                harness.check(plain, (Object)full);
            }
            catch (UnsupportedEncodingException _1) {
                harness.check(false);
            }
            catch (IOException _2) {
                harness.check(false);
            }
        }
    }
}

