/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.util.TimeZone;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class SMTimeZoneTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.util.TimeZone");
        this.test_setDefault();
        this.test_LONG_SHORT();
        this.test_getDefault();
        this.test_getDisplayName();
        this.test_getTimeZone();
        this.test_hasSameRules();
        this.test_getAvailableIDs();
        this.test_getID();
        this.test_setID();
        this.test_clone();
    }

    public void test_LONG_SHORT() {
        this.th.checkPoint("LONG_SHORT");
        this.th.check(1, 1, "LONG value");
        this.th.check(0, 0, "SHORT value");
    }

    public void test_getDefault() {
        this.th.checkPoint("getDefault()java.util.TimeZone");
        SimpleTimeZone stz = new SimpleTimeZone(1, "gmt");
        TimeZone.setDefault(stz);
        this.th.check(TimeZone.getDefault(), stz, "checking if value is set");
    }

    public void test_getDisplayName() {
        this.th.checkPoint("()");
    }

    public void test_getTimeZone() {
        this.th.checkPoint("()");
    }

    public void test_hasSameRules() {
        this.th.checkPoint("()");
    }

    public void test_setDefault() {
        this.th.checkPoint("setDefault(java.util.TimeZone)void");
        TimeZone.setDefault(null);
        TimeZone defTZ = TimeZone.getDefault();
        SimpleTimeZone mySTZ = new SimpleTimeZone(4, "MYT");
        TimeZone.setDefault(mySTZ);
        this.th.check(TimeZone.getDefault(), mySTZ, "checking if default timezone changed set");
        TimeZone.setDefault(null);
        this.th.check(TimeZone.getDefault(), defTZ, "checking if default timezone was restored");
    }

    public void test_getAvailableIDs() {
        this.th.checkPoint("getAvailableIDs()");
    }

    public void test_getID() {
        this.th.checkPoint("getID()java.lang.String");
        SimpleTimeZone stz = new SimpleTimeZone(1, "gmt");
        this.th.check(stz.getID(), "gmt", "checking value of get");
    }

    public void test_setID() {
        this.th.checkPoint("setID(java.lang.String)void");
        SimpleTimeZone stz = new SimpleTimeZone(1, "gmt");
        try {
            stz.setID(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        stz.setID("ECT");
        this.th.check(stz.getID(), "ECT", "checking if value is set");
    }

    public void test_clone() {
        this.th.checkPoint("()");
    }
}

