/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.util.ResourceBundle;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class SMResourceBundleTest
extends ResourceBundle
implements Testlet {
    protected TestHarness th;

    public Enumeration getKeys() {
        return null;
    }

    protected Object handleGetObject(String key) {
        String[] sa = null;
        if (key.equals("")) {
            sa = new String[]{"nothing"};
        }
        return sa;
    }

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.util.ResourceBundle");
        this.test_getBundle();
        this.test_getObject();
        this.test_getString();
        this.test_getStringArray();
        this.test_handleGetObject();
        this.test_setParent();
    }

    public void test_getBundle() {
        this.th.checkPoint("()");
    }

    public void test_getObject() {
        this.th.checkPoint("getObject(java.lang.String)java.lang.Object");
        Locale jap = new Locale("jp", "ja", "win_95");
        String s = "gnu.testlet.wonka.util.ResourceBundle.Resource5";
        ResourceBundle res = SMResourceBundleTest.getBundle(s, jap);
        this.th.check(s.equals(res.getObject(s)), "checking all parents checked for the Object");
        try {
            res.getObject("not there");
            this.th.fail("should throw a MissingResourceException");
        }
        catch (MissingResourceException mre) {
            this.th.check(true);
        }
    }

    public void test_getString() {
        this.th.checkPoint("getString(java.lang.String)java.lang.String");
        Locale jap = new Locale("jp", "ja", "win_95");
        String s = "gnu.testlet.wonka.util.ResourceBundle.Resource5";
        ResourceBundle res = SMResourceBundleTest.getBundle(s, jap);
        this.th.check(s.equals(res.getString(s)), "checking all parents checked for the Object");
        try {
            res.getObject("not there");
            this.th.fail("should throw a MissingResourceException");
        }
        catch (MissingResourceException mre) {
            this.th.check(true);
        }
    }

    public void test_getStringArray() {
        this.th.checkPoint("getStringArray(java.lang.String)java.lang.String[]");
        String s = "gnu.testlet.wonka.util.ResourceBundle.Resource5";
        this.th.check("nothing", this.getStringArray("")[0], "checking all parents checked for the Object");
    }

    public void test_handleGetObject() {
        this.th.checkPoint("()");
    }

    public void test_setParent() {
        this.th.checkPoint("setParent(java.util.ResourceBundle)void");
        Locale jap = new Locale("jp", "ja", "win_95");
        String s = "gnu.testlet.wonka.util.ResourceBundle.Resource5";
        ResourceBundle res = SMResourceBundleTest.getBundle(s, jap);
        this.setParent(res);
        this.th.check(s, this.getObject(s), "checking all parents checked for the Object");
    }
}

