/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.util.Locale;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.Locale;

public class SMLocaleTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.util.Locale");
        this.test_Locale();
        this.test_PredefinedLocales();
        this.test_setDefault();
        this.test_getAvailableLocales();
        this.test_getCountry();
        this.test_getDefault();
        this.test_getDisplayCountry();
        this.test_getDisplayLanguage();
        this.test_getDisplayName();
        this.test_getDisplayVariant();
        this.test_getISOCountries();
        this.test_getISO3Country();
        this.test_getISOLanguages();
        this.test_getISO3Language();
        this.test_getLanguage();
        this.test_getVariant();
        this.test_clone();
        this.test_equals();
        this.test_hashCode();
        this.test_toString();
    }

    public void test_Locale() {
        this.th.checkPoint("Locale(java.lang.String,java.lang.String)");
        try {
            new Locale(null, "abc");
            this.th.fail("should throw NullPointerExeption -- 1");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        try {
            new Locale("null", null);
            this.th.fail("should throw NullPointerExeption -- 2");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        Locale loc = new Locale("be", "AC");
        this.th.check(loc.getLanguage(), "be", "checking language -- 1");
        this.th.check(loc.getCountry(), "AC", "checking country -- 1");
        this.th.check(loc.getVariant(), "", "checking variant -- 1");
        loc = new Locale("", "ok");
        this.th.check(loc.getLanguage(), "", "checking language -- 2");
        this.th.check(loc.getCountry(), "OK", "checking country -- 2");
        loc = new Locale("ABC", "def");
        this.th.check(loc.getLanguage(), "abc", "checking language -- 3");
        this.th.check(loc.getCountry(), "DEF", "checking country -- 3");
        loc = new Locale("A_c", "d_e_f");
        this.th.check(loc.getLanguage(), "a_c", "checking language -- 4");
        this.th.check(loc.getCountry(), "D_E_F", "checking country -- 4");
        this.th.check(loc.getVariant(), "", "checking variant -- 4");
        loc = new Locale("HE", "@9f");
        this.th.check(loc.getLanguage(), "iw", "checking language -- 5");
        this.th.check(loc.getCountry(), "@9F", "checking country -- 5");
        loc = new Locale("yI", "_f");
        this.th.check(loc.getLanguage(), "ji", "checking language -- 6");
        this.th.check(loc.getCountry(), "_F", "checking country -- 6");
        loc = new Locale("iD", "be");
        this.th.check(loc.getLanguage(), "in", "checking language -- 7");
        this.th.check(loc.getCountry(), "BE", "checking country -- 7");
        this.th.check(loc.getVariant(), "", "checking variant -- 7");
        this.th.checkPoint("Locale(java.lang.String,java.lang.String,java.lang.String)");
        try {
            new Locale(null, "abc", "def");
            this.th.fail("should throw NullPointerExeption -- 1");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        try {
            new Locale("null", null, "def");
            this.th.fail("should throw NullPointerExeption -- 2");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        try {
            new Locale("null", "null", null);
            this.th.fail("should throw NullPointerExeption -- 3");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        loc = new Locale("be", "AC", "tof");
        this.th.check(loc.getLanguage(), "be", "checking language -- 1");
        this.th.check(loc.getCountry(), "AC", "checking country -- 1");
        this.th.check(loc.getVariant(), "TOF", "checking variant -- 1");
        loc = new Locale("", "ok", "tOf");
        this.th.check(loc.getLanguage(), "", "checking language -- 2");
        this.th.check(loc.getCountry(), "OK", "checking country -- 2");
        this.th.check(loc.getVariant(), "TOF", "checking variant -- 2");
        loc = new Locale("ABC", "def", "T_O_F");
        this.th.check(loc.getLanguage(), "abc", "checking language -- 3");
        this.th.check(loc.getCountry(), "DEF", "checking country -- 3");
        this.th.check(loc.getVariant(), "T_O_F", "checking variant -- 3");
        loc = new Locale("A_c", "", "tof");
        this.th.check(loc.getLanguage(), "a_c", "checking language -- 4");
        this.th.check(loc.getCountry(), "", "checking country -- 4");
        this.th.check(loc.getVariant(), "TOF", "checking variant -- 4");
        this.th.debug(loc.toString());
        loc = new Locale("HE", "@9f", "tof");
        this.th.check(loc.getLanguage(), "iw", "checking language -- 5");
        this.th.check(loc.getCountry(), "@9F", "checking country -- 5");
        this.th.check(loc.getVariant(), "TOF", "checking variant -- 5");
        loc = new Locale("yI", "_f", "tof");
        this.th.check(loc.getLanguage(), "ji", "checking language -- 6");
        this.th.check(loc.getCountry(), "_F", "checking country -- 6");
        this.th.check(loc.getVariant(), "TOF", "checking variant -- 6");
        loc = new Locale("iD", "be", "");
        this.th.check(loc.getLanguage(), "in", "checking language -- 7");
        this.th.check(loc.getCountry(), "BE", "checking country -- 7");
        this.th.check(loc.getVariant(), "", "checking variant -- 7");
    }

    public void test_PredefinedLocales() {
        this.th.checkPoint("US(public)java.util.Locale");
        this.th.check(Locale.CANADA.toString(), "en_CA", "Locale.CANADA");
        this.th.check(Locale.CHINA.toString(), "zh_CN", "Locale.CHINA");
        this.th.check(Locale.FRANCE.toString(), "fr_FR", "Locale.FRANCE");
        this.th.check(Locale.GERMANY.toString(), "de_DE", "Locale.GERMANY");
        this.th.check(Locale.ITALY.toString(), "it_IT", "Locale.ITALY");
        this.th.check(Locale.JAPAN.toString(), "ja_JP", "Locale.JAPAN");
        this.th.check(Locale.KOREA.toString(), "ko_KR", "Locale.KOREA");
        this.th.check(Locale.PRC.toString(), "zh_CN", "Locale.PRC");
        this.th.check(Locale.TAIWAN.toString(), "zh_TW", "Locale.TAIWAN");
        this.th.check(Locale.UK.toString(), "en_GB", "Locale.UK");
        this.th.check(Locale.US.toString(), "en_US", "Locale.US");
        this.th.check(Locale.CANADA_FRENCH.toString(), "fr_CA", "Locale.CANADA_FRENCH");
        this.th.check(Locale.CHINESE.toString(), "zh", "Locale.CHINESE");
        this.th.check(Locale.ENGLISH.toString(), "en", "Locale.ENGLISH");
        this.th.check(Locale.FRENCH.toString(), "fr", "Locale.FRENCH");
        this.th.check(Locale.GERMAN.toString(), "de", "Locale.GERMAN");
        this.th.check(Locale.ITALIAN.toString(), "it", "Locale.ITALIAN");
        this.th.check(Locale.JAPANESE.toString(), "ja", "Locale.JAPANESE");
        this.th.check(Locale.KOREAN.toString(), "ko", "Locale.KOREAN");
        this.th.check(Locale.SIMPLIFIED_CHINESE.toString(), "zh_CN", "Locale.SIMPLIFIED_CHINESE");
        this.th.check(Locale.TRADITIONAL_CHINESE.toString(), "zh_TW", "Locale.TRADITIONAL_CHINESE");
    }

    public void test_setDefault() {
        this.th.checkPoint("setDefault(java.util.Locale)void");
        Locale def = Locale.getDefault();
        try {
            Locale.setDefault(null);
            this.th.fail("should throw NullPointerExeption -- 1");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        Locale loc = new Locale("nl", "be", "linux");
        Locale.setDefault(loc);
        boolean bl = false;
        if (loc == Locale.getDefault()) {
            bl = true;
        }
        this.th.check(bl, "checking set/getDefault -- 1");
        Locale.setDefault(def);
        boolean bl2 = false;
        if (def == Locale.getDefault()) {
            bl2 = true;
        }
        this.th.check(bl2, "checking set/getDefault -- 2");
    }

    public void test_getAvailableLocales() {
        this.th.checkPoint("getAvailableLocales()java.util.Locale[]");
        boolean bl = false;
        if (Locale.getAvailableLocales() != null) {
            bl = true;
        }
        this.th.check(bl);
    }

    public void test_getCountry() {
        this.th.checkPoint("()");
    }

    public void test_getDefault() {
        this.th.checkPoint("()");
    }

    public void test_getDisplayCountry() {
        this.th.checkPoint("getDisplayCountry()");
    }

    public void test_getDisplayLanguage() {
        this.th.checkPoint("()");
    }

    public void test_getDisplayName() {
        this.th.checkPoint("()");
    }

    public void test_getDisplayVariant() {
        this.th.checkPoint("()");
    }

    public void test_getISOCountries() {
        this.th.checkPoint("()");
    }

    public void test_getISO3Country() {
        this.th.checkPoint("()");
    }

    public void test_getISOLanguages() {
        this.th.checkPoint("()");
    }

    public void test_getISO3Language() {
        this.th.checkPoint("()");
    }

    public void test_getLanguage() {
        this.th.checkPoint("()");
    }

    public void test_getVariant() {
        this.th.checkPoint("()");
    }

    public void test_clone() {
        this.th.checkPoint("clone()java.lang.Object");
        Locale lo = new Locale("be", "AC", "tof");
        Locale loc = (Locale)lo.clone();
        boolean bl = false;
        if (loc != lo) {
            bl = true;
        }
        this.th.check(bl, "the clone is not the same object");
        this.th.check(loc, lo, "both object are equal");
        this.th.check(loc.getLanguage(), "be", "checking language -- 1");
        this.th.check(loc.getCountry(), "AC", "checking country -- 1");
        this.th.check(loc.getVariant(), "TOF", "checking variant -- 1");
    }

    public void test_equals() {
        this.th.checkPoint("equals(java.lang.Object)boolean");
        Locale loc = new Locale("acd", "BEFG", "adfg");
        this.th.check(loc.equals(null) ^ true, "null is allowed");
        this.th.check(loc.equals("acd_BEFG_ADFG") ^ true, "not equals to its string representation");
    }

    public void test_hashCode() {
        this.th.checkPoint("hashCode()int");
        Locale loc = new Locale("acd", "BEFG", "adfg");
        this.th.check(loc.hashCode(), loc.clone().hashCode(), "checking hashcode");
    }

    public void test_toString() {
        this.th.checkPoint("toString()java.lang.String");
        Locale loc = new Locale("acd", "BEFG", "adfg");
        this.th.check(loc.toString(), (Object)"acd_BEFG_ADFG");
        loc = new Locale("be", "BEF_G", "a_f_g");
        this.th.check(loc.toString(), (Object)"be_BEF_G_A_F_G");
        loc = new Locale("ac_d", "BEFG", "adfg");
        this.th.check(loc.toString(), (Object)"ac_d_BEFG_ADFG");
        loc = new Locale("", "BEFG", "adfg");
        this.th.check(loc.toString(), (Object)"_BEFG_ADFG");
        loc = new Locale("a", "", "adfg");
        this.th.check(loc.toString(), (Object)"a");
        loc = new Locale("yi", "BE_FG", "adfg");
        this.th.check(loc.toString(), (Object)"ji_BE_FG_ADFG");
        loc = new Locale("id", "BE_FG", "ad_fg");
        this.th.check(loc.toString(), (Object)"in_BE_FG_AD_FG");
        loc = new Locale("zh", "tw", "a_d_f_g");
        this.th.check(loc.toString(), (Object)"zh_TW_A_D_F_G");
        loc = new Locale("zoth", "cn", "");
        this.th.check(loc.toString(), (Object)"zoth_CN");
    }
}

