/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.util.Date;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.Date;

public class SMDateTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.util.Date");
        this.test_Date();
        this.test_getTime();
        this.test_setTime();
        this.test_after();
        this.test_before();
        this.test_compareTo();
        this.test_equals();
        this.test_clone();
        this.test_hashCode();
        this.test_toString();
    }

    public void test_Date() {
        this.th.checkPoint("Date()");
        Date d1 = new Date();
        boolean bl = false;
        if (d1.getTime() > 100000000L) {
            bl = true;
        }
        this.th.check(bl, "got:" + d1.getTime());
        this.th.checkPoint("Date(long)");
        Date d2 = new Date(0L);
        boolean bl2 = false;
        if (d2.getTime() == 0L) {
            bl2 = true;
        }
        this.th.check(bl2);
        d2 = new Date(Integer.MAX_VALUE);
        boolean bl3 = false;
        if (d2.getTime() == Integer.MAX_VALUE) {
            bl3 = true;
        }
        this.th.check(bl3);
        d2 = new Date(Integer.MIN_VALUE);
        boolean bl4 = false;
        if (d2.getTime() == Integer.MIN_VALUE) {
            bl4 = true;
        }
        this.th.check(bl4);
        d2 = new Date(Long.MAX_VALUE);
        boolean bl5 = false;
        if (d2.getTime() == Long.MAX_VALUE) {
            bl5 = true;
        }
        this.th.check(bl5);
        d2 = new Date(Long.MIN_VALUE);
        boolean bl6 = false;
        if (d2.getTime() == Long.MIN_VALUE) {
            bl6 = true;
        }
        this.th.check(bl6);
    }

    public void test_getTime() {
        this.th.checkPoint("getTime()long");
        Date d2 = new Date(0L);
        boolean bl = false;
        if (d2.getTime() == 0L) {
            bl = true;
        }
        this.th.check(bl);
        d2 = new Date(Integer.MAX_VALUE);
        boolean bl2 = false;
        if (d2.getTime() == Integer.MAX_VALUE) {
            bl2 = true;
        }
        this.th.check(bl2);
        d2 = new Date(Integer.MIN_VALUE);
        boolean bl3 = false;
        if (d2.getTime() == Integer.MIN_VALUE) {
            bl3 = true;
        }
        this.th.check(bl3);
        d2 = new Date(Long.MAX_VALUE);
        boolean bl4 = false;
        if (d2.getTime() == Long.MAX_VALUE) {
            bl4 = true;
        }
        this.th.check(bl4);
        d2 = new Date(Long.MIN_VALUE);
        boolean bl5 = false;
        if (d2.getTime() == Long.MIN_VALUE) {
            bl5 = true;
        }
        this.th.check(bl5);
    }

    public void test_setTime() {
        this.th.checkPoint("setTime(long)void");
        Date d = new Date(0L);
        long l = -24556798768787867L;
        d.setTime(l);
        boolean bl = false;
        if (d.getTime() == l) {
            bl = true;
        }
        this.th.check(bl);
        d.setTime(-l);
        boolean bl2 = false;
        if (d.getTime() == -l) {
            bl2 = true;
        }
        this.th.check(bl2);
        d.setTime(0L);
        boolean bl3 = false;
        if (d.getTime() == 0L) {
            bl3 = true;
        }
        this.th.check(bl3);
    }

    public void test_after() {
        this.th.checkPoint("after(java.util.Date)boolean");
        Date d2 = new Date(34396989L);
        Date d1 = new Date();
        this.th.check(d1.after(d2));
        this.th.check(d2.after(d1) ^ true);
        Date d4 = new Date(-45469456L);
        Date d3 = new Date(-d1.getTime());
        this.th.check(d4.after(d3));
        this.th.check(d3.after(d4) ^ true);
        this.th.check(d1.after(d3));
        this.th.check(d3.after(d1) ^ true);
        this.th.check(d1.after(d4));
        this.th.check(d4.after(d1) ^ true);
        this.th.check(d2.after(d3));
        this.th.check(d3.after(d2) ^ true);
        this.th.check(d3.after(d3) ^ true);
        this.th.check(d1.after(d1) ^ true);
        try {
            d1.after(null);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
    }

    public void test_before() {
        this.th.checkPoint("before(java.util.Date)boolean");
        Date d2 = new Date(34396989L);
        Date d1 = new Date();
        this.th.check(d1.before(d2) ^ true);
        this.th.check(d2.before(d1));
        Date d4 = new Date(-45469456L);
        Date d3 = new Date(-d1.getTime());
        this.th.check(d4.before(d3) ^ true);
        this.th.check(d3.before(d4));
        this.th.check(d1.before(d3) ^ true);
        this.th.check(d3.before(d1));
        this.th.check(d1.before(d4) ^ true);
        this.th.check(d4.before(d1));
        this.th.check(d2.before(d3) ^ true);
        this.th.check(d3.before(d2));
        this.th.check(d3.before(d3) ^ true);
        this.th.check(d1.before(d1) ^ true);
        try {
            d1.before(null);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        this.th.debug(d1.toString());
        this.th.debug(d2.toString());
        this.th.debug(d3.toString());
        this.th.debug(d4.toString());
    }

    public void test_compareTo() {
        this.th.checkPoint("compareTo(java.lang.Object)int");
        Date d = new Date(0L);
        try {
            d.compareTo(null);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        try {
            d.compareTo("a");
            this.th.fail("should throw ClassCastException");
        }
        catch (ClassCastException ne) {
            this.th.check(true);
        }
        Date o = new Date();
        try {
            boolean bl = false;
            if (d.compareTo((Object)o) < 0) {
                bl = true;
            }
            this.th.check(bl);
            o = new Date(-1);
            boolean bl2 = false;
            if (d.compareTo((Object)o) > 0) {
                bl2 = true;
            }
            this.th.check(bl2);
            o = new Date(0L);
            boolean bl3 = false;
            if (d.compareTo((Object)o) == 0) {
                bl3 = true;
            }
            this.th.check(bl3);
        }
        catch (Exception e) {
            this.th.fail("did not Expect Exception -- got:" + e);
        }
        this.th.checkPoint("compareTo(java.util.Date)int");
        d = new Date();
        boolean bl = false;
        if (d.compareTo(d) == 0) {
            bl = true;
        }
        this.th.check(bl);
        Date d1 = new Date(d.getTime() - 1L);
        boolean bl4 = false;
        if (d.compareTo(d1) > 0) {
            bl4 = true;
        }
        this.th.check(bl4);
        d1 = new Date(d.getTime() + 1L);
        boolean bl5 = false;
        if (d.compareTo(d1) < 0) {
            bl5 = true;
        }
        this.th.check(bl5);
        try {
            d.compareTo(null);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
    }

    public void test_equals() {
        this.th.checkPoint("equals(java.lang.Object)boolean");
        Date d2 = new Date(34396989L);
        Date d1 = new Date();
        this.th.check(d1.equals(d2) ^ true);
        this.th.check(d2.equals(d1) ^ true);
        Date d4 = new Date(-45469456L);
        Date d3 = new Date(-45469456L);
        this.th.check(d4.equals(d3));
        this.th.check(d3.equals("a") ^ true);
        this.th.check(d1.equals(new Object()) ^ true);
        this.th.check(d1.equals(d4) ^ true);
        this.th.check(d2.equals(d3) ^ true);
        this.th.check(d3.equals(d2) ^ true);
        this.th.check(d3.equals(d3));
        this.th.check(d1.equals(d1));
        this.th.check(d3.equals(d4));
        try {
            this.th.check(d1.equals(null) ^ true);
        }
        catch (NullPointerException ne) {
            this.th.fail("should throw NullPointerException");
        }
    }

    public void test_clone() {
        this.th.checkPoint("()");
    }

    public void test_hashCode() {
        this.th.checkPoint("hashCode()int");
        Date d = new Date(0L);
        boolean bl = false;
        if (d.hashCode() == 0) {
            bl = true;
        }
        this.th.check(bl, "got:" + d.hashCode());
        d = new Date(1000L);
        boolean bl2 = false;
        if (d.hashCode() == 1000) {
            bl2 = true;
        }
        this.th.check(bl2, "got:" + d.hashCode());
        d = new Date(-14587L);
        long l = d.getTime();
        boolean bl3 = false;
        if (d.hashCode() == (int)((long)((int)l) ^ l >>> 32)) {
            bl3 = true;
        }
        this.th.check(bl3, "got:" + d.hashCode() + ", exp:" + (int)((long)((int)l) ^ l >>> 32));
        d = new Date();
        l = d.getTime();
        boolean bl4 = false;
        if (d.hashCode() == (int)((long)((int)l) ^ l >>> 32)) {
            bl4 = true;
        }
        this.th.check(bl4, "got:" + d.hashCode() + ", exp:" + (int)((long)((int)l) ^ l >>> 32));
        l = -l;
        d = new Date(l);
        boolean bl5 = false;
        if (d.hashCode() == (int)((long)((int)l) ^ l >>> 32)) {
            bl5 = true;
        }
        this.th.check(bl5, "got:" + d.hashCode() + ", exp:" + (int)((long)((int)l) ^ l >>> 32));
    }

    public void test_toString() {
        this.th.checkPoint("toString()java.lang.String");
        Date d = new Date();
        this.th.debug("Debuging -- printing current Date\n" + d.toString());
        d = new Date(0L);
        this.th.debug("Debuging -- printing reference Date\n" + d.toString());
        d = new Date(31536000000555L);
        this.th.debug("Debuging -- printing futere Date\n" + d.toString());
        d = new Date(-31536000000000L);
        this.th.debug("Debuging -- printing past Date\n" + d.toString());
        d = new Date(31876576555L);
        this.th.debug("Debuging -- printing a random Date\n" + d.toString());
        d = new Date(31962976555L);
        this.th.debug("Debuging -- printing a random Date\n" + d.toString());
    }
}

