/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.util.BitSet;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.BitSet;
import java.util.Vector;

public class SMBitSetTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.util.BitSet");
        this.test_BitSet();
        this.test_clone();
        this.test_equals();
        this.test_hashCode();
        this.test_toString();
        this.test_and();
        this.test_andNot();
        this.test_clear();
        this.test_get();
        this.test_or();
        this.test_set();
        this.test_xor();
        this.test_length();
        this.test_size();
    }

    public void test_BitSet() {
        this.th.checkPoint("BitSet()");
        BitSet bs = new BitSet();
        boolean bl = false;
        if (bs.size() == 64) {
            bl = true;
        }
        this.th.check(bl, "new BitSet has size 64");
        boolean ok = true;
        int i = 0;
        while (i < 64) {
            if (bs.get(i)) {
                ok = false;
            }
            ++i;
        }
        this.th.check(ok, "all bits should be 0 -- got:" + bs);
        this.th.checkPoint("BitSet(int)");
        bs = new BitSet(1);
        boolean bl2 = false;
        if (bs.size() == 64) {
            bl2 = true;
        }
        this.th.check(bl2, "new BitSet has size 64");
        ok = true;
        i = 0;
        while (i < 64) {
            if (bs.get(i)) {
                ok = false;
            }
            ++i;
        }
        this.th.check(ok, "all bits should be 0 -- got:" + bs);
        bs = new BitSet(65);
        boolean bl3 = false;
        if (bs.size() == 128) {
            bl3 = true;
        }
        this.th.check(bl3, "new BitSet has size 128");
        bs = new BitSet(129);
        boolean bl4 = false;
        if (bs.size() == 192) {
            bl4 = true;
        }
        this.th.check(bl4, "new BitSet has size 192");
        bs = new BitSet(1024);
        boolean bl5 = false;
        if (bs.size() == 1024) {
            bl5 = true;
        }
        this.th.check(bl5, "new BitSet has size 1024");
        bs = new BitSet(0);
        boolean bl6 = false;
        if (bs.size() == 0) {
            bl6 = true;
        }
        this.th.check(bl6, "new BitSet has size 0");
        try {
            new BitSet(-1);
            this.th.fail("should throw NegativeArraySizeException");
        }
        catch (NegativeArraySizeException ne) {
            this.th.check(true);
        }
    }

    public void test_clone() {
        this.th.checkPoint("clone()java.lang.Object");
        BitSet bs = new BitSet(3);
        int i = 0;
        while (i < 64) {
            bs.set(i);
            i += 2;
        }
        BitSet bsc = (BitSet)bs.clone();
        boolean ok = true;
        i = 0;
        while (i < 64) {
            boolean bl = bsc.get(i);
            boolean bl2 = false;
            if (i % 2 == 0) {
                bl2 = true;
            }
            if (bl != bl2) {
                ok = false;
            }
            ++i;
        }
        this.th.check(ok, "all bits should be set");
        boolean bl = false;
        if (bsc.size() == 64) {
            bl = true;
        }
        this.th.check(bl, "size is the same !!!");
        bs = new BitSet(0);
        bsc = (BitSet)bs.clone();
        bs.set(4);
        boolean bl3 = false;
        if (bsc.size() == 0) {
            bl3 = true;
        }
        this.th.check(bl3, "changes in the original don't affect the clone");
    }

    public void test_equals() {
        this.th.checkPoint("equals(java.lang.Object)boolean");
        BitSet bs = new BitSet(35);
        int i = 0;
        while (i < 64) {
            bs.set(i);
            i += 2;
        }
        this.th.check(bs.equals(null) ^ true, "returns false if compared to null");
        this.th.check(bs.equals("dsf") ^ true, "returns false if compared to another Object");
        Vector<Integer> v = new Vector<Integer>();
        i = 0;
        while (i < 64) {
            v.add(new Integer(1));
            v.add(new Integer(0));
            i += 2;
        }
        this.th.check(bs.equals(v) ^ true, "returns false if compared to a vector");
        BitSet bsc = (BitSet)bs.clone();
        this.th.check(bsc.equals(bs), "a BitSet equals his clone");
        bs.set(1);
        this.th.check(bsc.equals(bs) ^ true, "one different bit ==> not equal");
        bs.clear(1);
        bsc.clear(100);
        this.th.check(bsc.equals(bs), "different size still can be equal -- 1");
        this.th.check(bs.equals(bsc), "different size still can be equal -- 2");
        bsc.set(127);
        this.th.check(bsc.equals(bs) ^ true, "different size don't have to be equal -- 1");
        this.th.check(bs.equals(bsc) ^ true, "different size don't have to be equal -- 2");
    }

    public void test_hashCode() {
        this.th.checkPoint("hashCode()int");
        BitSet bs = new BitSet(34);
        boolean bl = false;
        if (bs.hashCode() == 1234) {
            bl = true;
        }
        this.th.check(bl, "checking hashCode for empty BitSet size 64");
        bs = new BitSet(0);
        boolean bl2 = false;
        if (bs.hashCode() == 1234) {
            bl2 = true;
        }
        this.th.check(bl2, "checking hashCode for empty BitSet size 0");
        int i = 0;
        while (i < 8) {
            bs.set(i);
            ++i;
        }
        boolean bl3 = false;
        if (bs.hashCode() == 1069) {
            bl3 = true;
        }
        this.th.check(bl3, "checking hashCode for  BitSet  FF");
    }

    public void test_toString() {
        this.th.checkPoint("toString()java.lang.String");
        BitSet bs = new BitSet();
        this.th.check(bs.toString(), "{}", "check empty BitSet");
        bs.set(1);
        this.th.check(bs.toString(), "{1}", "check BitSet string representation -- 1");
        bs.set(60);
        this.th.check(bs.toString(), "{1, 60}", "check BitSet string representation -- 1");
        bs.set(15);
        this.th.check(bs.toString(), "{1, 15, 60}", "check BitSet string representation -- 1");
    }

    public void test_and() {
        this.th.checkPoint("and(java.util.BitSet)void");
        BitSet bs1 = new BitSet();
        BitSet bs2 = new BitSet();
        int i = 0;
        while (i < 64) {
            bs2.set(i);
            ++i;
        }
        try {
            bs1.and(null);
            this.th.fail("Should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        bs2.and(bs1);
        this.th.check(bs1.equals(bs2), "all ones anded to zeros give zeros");
        bs1.set(1);
        bs2.set(1);
        bs1.and(bs2);
        boolean bl = false;
        if (bs1.get(1) && bs2.equals(bs1)) {
            bl = true;
        }
        this.th.check(bl, "checking and -- 1");
        i = 0;
        while (i < 64) {
            bs2.set(i);
            bs1.set(i);
            ++i;
        }
        i = 64;
        while (i < 128) {
            bs2.set(i);
            ++i;
        }
        bs1.clear(2);
        bs1.clear(20);
        bs1.clear(25);
        bs1.clear(28);
        Object o = bs1.clone();
        bs1.and(bs2);
        this.th.check(bs1.equals(o), "extra bits from bs2 are unused");
        boolean bl2 = false;
        if (bs1.size() == 64) {
            bl2 = true;
        }
        this.th.check(bl2, "BitSet is not grown to size bs2");
        bs2.and(bs1);
        this.th.check(bs1.equals(bs2), "extra bits in bs2 are cleared");
    }

    public void test_andNot() {
        this.th.checkPoint("andNot(java.util.BitSet)void");
        BitSet bs1 = new BitSet();
        BitSet bs2 = new BitSet();
        int i = 0;
        while (i < 64) {
            bs2.set(i);
            ++i;
        }
        try {
            bs1.and(null);
            this.th.fail("Should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        BitSet bs3 = (BitSet)bs2.clone();
        bs2.andNot(bs1);
        this.th.check(bs3.equals(bs2), "all ones andnotted to zeros give ones");
        bs3.andNot(bs2);
        boolean bl = false;
        if (!bs3.get(1) && bs3.equals(bs1)) {
            bl = true;
        }
        this.th.check(bl, "checking andNot -- 1");
        i = 0;
        while (i < 64) {
            bs2.set(i);
            bs1.set(i);
            ++i;
        }
        i = 64;
        while (i < 128) {
            bs2.set(i);
            ++i;
        }
        BitSet bs4 = (BitSet)bs2.clone();
        bs3 = (BitSet)bs1.clone();
        bs4.xor(bs1);
        bs1.andNot(bs2);
        this.th.check(bs1.equals(new BitSet(64)), "extra bits from bs2 are unused");
        boolean bl2 = false;
        if (bs1.size() == 64) {
            bl2 = true;
        }
        this.th.check(bl2, "BitSet is not grown to size bs2");
        bs2.andNot(bs3);
        this.th.check(bs4.equals(bs2), "extra bits in bs2 are not altered");
        bs1.clear(0);
        bs2.clear(0);
        bs2.andNot(bs1);
        this.th.check(bs2.get(0) ^ true, "checking or -- 1");
        bs2.set(0);
        bs2.andNot(bs1);
        this.th.check(bs2.get(0), "checking or -- 2");
        bs1.set(0);
        bs2.andNot(bs1);
        this.th.check(bs2.get(0) ^ true, "checking or -- 3");
        bs2.andNot(bs1);
        this.th.check(bs2.get(0) ^ true, "checking or -- 4");
    }

    public void test_clear() {
        this.th.checkPoint("clear(int)void");
        BitSet bs = new BitSet();
        Object o = bs.clone();
        int i = 0;
        while (i < 64) {
            bs.set(i);
            bs.clear(i);
            ++i;
        }
        this.th.check(bs.equals(o), "checking set/clear");
        bs.set(4);
        this.th.check(bs.get(4), "make sure the set worked");
        bs.clear(4);
        this.th.check(bs.get(4) ^ true, "make sure the clear worked -- 1");
        bs.clear(4);
        this.th.check(bs.get(4) ^ true, "make sure the clear worked -- 2");
        bs.clear(123);
        this.th.check(bs.size(), 64, "clear can't make the set grow -- got: " + bs.size());
        try {
            bs.clear(-1);
            this.th.fail("should throw an IndexsOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ie) {
            this.th.check(true);
        }
        bs.set(134);
        boolean bl = false;
        if (bs.size() == 192) {
            bl = true;
        }
        this.th.check(bl, "growing BitSet");
        bs.clear(134);
        boolean bl2 = false;
        if (bs.size() == 192) {
            bl2 = true;
        }
        this.th.check(bl2, "clear cannot cause the BitSet to downsize");
        bs = new BitSet(0);
        try {
            bs.clear(0);
            bs.clear(64);
            bs.clear(128);
            bs.set(146);
            bs.clear(146);
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("should not throw an exception");
        }
    }

    public void test_get() {
        this.th.checkPoint("get(int)boolean");
        BitSet bs = new BitSet();
        try {
            bs.get(-1);
            this.th.fail("should throw an IndexsOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ie) {
            this.th.check(true);
        }
        this.th.check(bs.get(Integer.MAX_VALUE) ^ true, "returns false if pos > size");
        bs.set(3);
        this.th.check(bs.get(3), "returns true if pos is set");
        bs.clear(3);
        this.th.check(bs.get(3) ^ true, "returns false if pos is cleared");
        this.th.check(bs.get(0) ^ true, "returns false if pos is cleared/or not set -- 1");
        this.th.check(bs.get(63) ^ true, "returns false if pos is cleared/or not set -- 2");
    }

    public void test_or() {
        this.th.checkPoint("or(java.util.BitSet)void");
        BitSet bs1 = new BitSet();
        BitSet bs2 = new BitSet();
        try {
            bs1.or(null);
            this.th.fail("Should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        int i = 0;
        while (i < 64) {
            bs2.set(i);
            ++i;
        }
        bs1.or(bs2);
        this.th.check(bs1, bs2, "all ones ored with zeros give ones");
        i = 64;
        while (i < 128) {
            bs2.set(i);
            ++i;
        }
        BitSet bs3 = new BitSet(3);
        BitSet bs4 = new BitSet(127);
        bs3.or(bs2);
        this.th.check(bs1, bs3, "extra bits from bs2 are unused -- got: " + bs3);
        bs4.or(bs1);
        this.th.check(bs4.equals(bs1), "extra bits in bs4 are left" + bs1);
        bs1.clear(0);
        bs2.clear(0);
        bs2.or(bs1);
        this.th.check(bs2.get(0) ^ true, "checking or -- 1");
        bs1.set(0);
        bs2.or(bs1);
        this.th.check(bs2.get(0), "checking or -- 2");
        bs2.or(bs1);
        this.th.check(bs2.get(0), "checking or -- 3");
        bs1.clear(0);
        bs2.or(bs1);
        this.th.check(bs2.get(0), "checking or -- 4");
    }

    public void test_set() {
        this.th.checkPoint("set(int)void");
        BitSet bs = new BitSet(3);
        try {
            bs.clear(-1);
            this.th.fail("should throw an IndexsOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ie) {
            this.th.check(true);
        }
        bs = new BitSet(0);
        bs.set(0);
        bs.set(23);
    }

    public void test_xor() {
        this.th.checkPoint("xor(java.util.BitSet)void");
        BitSet bs1 = new BitSet();
        BitSet bs2 = new BitSet();
        int i = 0;
        while (i < 32) {
            bs2.set(i);
            ++i;
        }
        try {
            bs1.xor(null);
            this.th.fail("Should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        bs1.xor(bs2);
        this.th.check(bs1.equals(bs2), "checking global xor");
        i = 64;
        while (i < 128) {
            bs1.set(i);
            ++i;
        }
        BitSet bs3 = new BitSet(3);
        bs3.xor(bs1);
        this.th.check(bs2.equals(bs3), "extra bits from bs1 are unused -- got: " + bs3);
        bs1.xor(bs2);
        boolean ok = true;
        i = 0;
        while (i < 64) {
            if (bs1.get(i)) {
                ok = false;
            }
            ++i;
        }
        i = 64;
        while (i < 128) {
            if (!bs1.get(i)) {
                ok = false;
            }
            ++i;
        }
        if (!ok) {
            this.th.debug("got wrong bitpattern:" + bs1);
        }
        this.th.check(ok, "extra bits in bs4 are left");
        bs1.clear(0);
        bs2.clear(0);
        bs2.xor(bs1);
        this.th.check(bs2.get(0) ^ true, "checking xor -- 1");
        bs1.set(0);
        bs2.xor(bs1);
        this.th.check(bs2.get(0), "checking xor -- 2");
        bs2.xor(bs1);
        this.th.check(bs2.get(0) ^ true, "checking xor -- 3");
        bs2.xor(bs1);
        this.th.check(bs2.get(0), "checking xor -- 4");
        bs1.clear(0);
        bs2.xor(bs1);
        this.th.check(bs2.get(0), "checking xor -- 5");
    }

    public void test_length() {
        this.th.checkPoint("length()int");
        BitSet bs = new BitSet(0);
        this.th.check(bs.length(), 0);
        bs.clear(100);
        this.th.check(bs.length(), 0);
        bs.set(50);
        this.th.check(bs.length(), 51);
        bs.set(120);
        this.th.check(bs.length(), 121);
        bs.set(150);
        this.th.check(bs.length(), 151);
        bs.set(150);
        this.th.check(bs.length(), 151);
        bs.clear(150);
        this.th.check(bs.length(), 121);
        bs.clear(120);
        this.th.check(bs.length(), 51);
        bs.clear(50);
        this.th.check(bs.length(), 0);
    }

    public void test_size() {
        this.th.checkPoint("size()int");
        BitSet bs = new BitSet();
        bs.set(56);
        boolean bl = false;
        if (bs.size() == 64) {
            bl = true;
        }
        this.th.check(bl);
        bs.set(64);
        boolean bl2 = false;
        if (bs.size() == 128) {
            bl2 = true;
        }
        this.th.check(bl2);
    }
}

