/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.util.ArrayList;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.util.ArrayList.SMExArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Vector;

public class SMArrayListTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.util.ArrayList");
        this.test_ArrayList();
        this.test_get();
        this.test_ensureCapacity();
        this.test_trimToSize();
        this.test_add();
        this.test_addAll();
        this.test_clear();
        this.test_remove();
        this.test_set();
        this.test_contains();
        this.test_isEmpty();
        this.test_indexOf();
        this.test_size();
        this.test_lastIndexOf();
        this.test_toArray();
        this.test_clone();
        this.test_removeRange();
        this.test_MC_iterator();
    }

    protected ArrayList buildAL() {
        Vector<String> v = new Vector<String>();
        v.add("a");
        v.add("c");
        v.add("u");
        v.add("n");
        v.add("i");
        v.add("a");
        v.add(null);
        v.add("a");
        v.add("c");
        v.add("u");
        v.add("n");
        v.add("i");
        v.add("a");
        v.add(null);
        return new ArrayList(v);
    }

    public void test_ArrayList() {
        this.th.checkPoint("ArrayList(java.util.Collection)");
        Vector<String> v = new Vector<String>();
        ArrayList al = new ArrayList(v);
        this.th.check(al.isEmpty(), "no elements added");
        v.add("a");
        v.add("c");
        v.add("u");
        v.add("n");
        v.add("i");
        v.add("a");
        v.add(null);
        al = new ArrayList(v);
        this.th.check(v.equals(al), "check if everything is OK");
        try {
            new ArrayList(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
    }

    public void test_get() {
        this.th.checkPoint("get(int)java.lang.Object");
        ArrayList al = new ArrayList();
        try {
            al.get(0);
            this.th.fail("should throw an IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.th.check(true);
        }
        try {
            al.get(-1);
            this.th.fail("should throw an IndexOutOfBoundsException -- 2");
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.th.check(true);
        }
        al = this.buildAL();
        try {
            al.get(14);
            this.th.fail("should throw an IndexOutOfBoundsException -- 3");
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.th.check(true);
        }
        try {
            al.get(-1);
            this.th.fail("should throw an IndexOutOfBoundsException -- 4");
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.th.check(true);
        }
        this.th.check("a".equals(al.get(0)), "checking returnvalue -- 1");
        this.th.check("c".equals(al.get(1)), "checking returnvalue -- 2");
        this.th.check("u".equals(al.get(2)), "checking returnvalue -- 3");
        this.th.check("a".equals(al.get(5)), "checking returnvalue -- 4");
        this.th.check("a".equals(al.get(7)), "checking returnvalue -- 5");
        this.th.check("c".equals(al.get(8)), "checking returnvalue -- 6");
        this.th.check("u".equals(al.get(9)), "checking returnvalue -- 7");
        this.th.check("a".equals(al.get(12)), "checking returnvalue -- 8");
        boolean bl = false;
        if (al.get(6) == null) {
            bl = true;
        }
        this.th.check(bl, "checking returnvalue -- 9");
        boolean bl2 = false;
        if (al.get(13) == null) {
            bl2 = true;
        }
        this.th.check(bl2, "checking returnvalue -- 10");
    }

    public void test_ensureCapacity() {
        this.th.checkPoint("ensureCapacity(int)void");
        ArrayList al = this.buildAL();
        al.ensureCapacity(4);
        boolean bl = false;
        if (al.size() == 14) {
            bl = true;
        }
        this.th.check(bl, "make sure the list cannot be downsized !");
    }

    public void test_trimToSize() {
        this.th.checkPoint("trimToSize()");
    }

    public void test_add() {
        this.th.checkPoint("add(int,java.lang.Object)void");
        ArrayList<String> al = new ArrayList<String>();
        try {
            al.add(-1, "a");
            this.th.fail("should throw an IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.th.check(true);
        }
        try {
            al.add(1, "a");
            this.th.fail("should throw an IndexOutOfBoundsException -- 2");
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.th.check(true);
        }
        al.add(0, "a");
        al.add(1, "c");
        al.add(2, "u");
        al.add(1, null);
        boolean bl = false;
        if ("a".equals(al.get(0)) && al.get(1) == null && "c".equals(al.get(2)) && "u".equals(al.get(3))) {
            bl = true;
        }
        this.th.check(bl, "checking add ...");
        this.th.checkPoint("add(java.lang.Object)boolean");
        al = new ArrayList();
        this.th.check(al.add("a"), "checking return value -- 1");
        this.th.check(al.add("c"), "checking return value -- 2");
        this.th.check(al.add("u"), "checking return value -- 3");
        this.th.check(al.add("n"), "checking return value -- 4");
        this.th.check(al.add("i"), "checking return value -- 5");
        this.th.check(al.add("a"), "checking return value -- 6");
        this.th.check(al.add(null), "checking return value -- 7");
        this.th.check(al.add("end"), "checking return value -- 8");
        boolean bl2 = false;
        if ("a".equals(al.get(0)) && al.get(6) == null && "c".equals(al.get(1)) && "u".equals(al.get(2))) {
            bl2 = true;
        }
        this.th.check(bl2, "checking add ... -- 1");
        boolean bl3 = false;
        if ("a".equals(al.get(5)) && "end".equals(al.get(7)) && "n".equals(al.get(3)) && "i".equals(al.get(4))) {
            bl3 = true;
        }
        this.th.check(bl3, "checking add ... -- 2");
    }

    public void test_addAll() {
        this.th.checkPoint("addAll(java.util.Collection)boolean");
        ArrayList al = new ArrayList();
        try {
            al.addAll(null);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        ArrayList c = al;
        this.th.check(al.addAll(c) ^ true, "checking returnvalue -- 1");
        al.add("a");
        al.add("b");
        al.add("c");
        c = al;
        al = this.buildAL();
        this.th.check(al.addAll(c), "checking returnvalue -- 2");
        this.th.check(al.containsAll(c), "extra on containsAll -- 1");
        boolean bl = false;
        if (al.get(14) == "a" && al.get(15) == "b" && al.get(16) == "c") {
            bl = true;
        }
        this.th.check(bl, "checking added on right positions");
        this.th.checkPoint("addAll(int,java.util.Collection)boolean");
        c = al = new ArrayList();
        this.th.check(al.addAll(0, c) ^ true, "checking returnvalue -- 1");
        al.add("a");
        al.add("b");
        al.add("c");
        c = al;
        al = this.buildAL();
        try {
            al.addAll(-1, c);
            this.th.fail("should throw exception -- 1");
        }
        catch (IndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        try {
            al.addAll(15, c);
            this.th.fail("should throw exception -- 2");
        }
        catch (IndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        try {
            this.th.check(al.addAll(11, c), "checking returnvalue -- 2");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.fail("shouldn't throw exception -- 1");
        }
        this.th.check(al.containsAll(c), "extra on containsAll -- 1");
        boolean bl2 = false;
        if (al.get(11) == "a" && al.get(12) == "b" && al.get(13) == "c") {
            bl2 = true;
        }
        this.th.check(bl2, "checking added on right positions -- 1");
        this.th.check(al.addAll(1, c), "checking returnvalue -- 3");
        boolean bl3 = false;
        if (al.get(1) == "a" && al.get(2) == "b" && al.get(3) == "c") {
            bl3 = true;
        }
        this.th.check(bl3, "checking added on right positions -- 2");
    }

    public void test_clear() {
        this.th.checkPoint("clear()void");
        ArrayList al = new ArrayList();
        al.clear();
        al = this.buildAL();
        al.clear();
        boolean bl = false;
        if (al.size() == 0 && al.isEmpty()) {
            bl = true;
        }
        this.th.check(bl, "list is empty ...");
    }

    public void test_remove() {
        this.th.checkPoint("remove(int)java.lang.Object");
        ArrayList al = this.buildAL();
        try {
            al.remove(-1);
            this.th.fail("should throw an IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException e) {
            this.th.check(true);
        }
        try {
            al.remove(14);
            this.th.fail("should throw an IndexOutOfBoundsException -- 2");
        }
        catch (IndexOutOfBoundsException e) {
            this.th.check(true);
        }
        this.th.check("a".equals(al.remove(5)), "checking returnvalue remove -- 1");
        boolean bl = false;
        if ("a".equals(al.get(0)) && al.get(5) == null && "c".equals(al.get(1)) && "u".equals(al.get(2))) {
            bl = true;
        }
        this.th.check(bl, "checking remove ... -- 1");
        boolean bl2 = false;
        if ("a".equals(al.get(6)) && "c".equals(al.get(7)) && "n".equals(al.get(3)) && "i".equals(al.get(4))) {
            bl2 = true;
        }
        this.th.check(bl2, "checking remove ... -- 2");
        boolean bl3 = false;
        if (al.size() == 13) {
            bl3 = true;
        }
        this.th.check(bl3, "checking new size -- 1");
        boolean bl4 = false;
        if (al.remove(5) == null) {
            bl4 = true;
        }
        this.th.check(bl4, "checking returnvalue remove -- 2");
        boolean bl5 = false;
        if (al.size() == 12) {
            bl5 = true;
        }
        this.th.check(bl5, "checking new size -- 2");
        boolean bl6 = false;
        if (al.remove(11) == null) {
            bl6 = true;
        }
        this.th.check(bl6, "checking returnvalue remove -- 3");
        this.th.check("a".equals(al.remove(0)), "checking returnvalue remove -- 4");
        this.th.check("u".equals(al.remove(1)), "checking returnvalue remove -- 5");
        this.th.check("i".equals(al.remove(2)), "checking returnvalue remove -- 6");
        this.th.check("a".equals(al.remove(2)), "checking returnvalue remove -- 7");
        this.th.check("u".equals(al.remove(3)), "checking returnvalue remove -- 8");
        this.th.check("a".equals(al.remove(5)), "checking returnvalue remove -- 9");
        this.th.check("i".equals(al.remove(4)), "checking returnvalue remove -- 10");
        boolean bl7 = false;
        if ("c".equals(al.get(0)) && "c".equals(al.get(2)) && "n".equals(al.get(3)) && "n".equals(al.get(1))) {
            bl7 = true;
        }
        this.th.check(bl7, "checking remove ... -- 3");
        boolean bl8 = false;
        if (al.size() == 4) {
            bl8 = true;
        }
        this.th.check(bl8, "checking new size -- 3");
        al.remove(0);
        al.remove(0);
        al.remove(0);
        al.remove(0);
        boolean bl9 = false;
        if (al.size() == 0) {
            bl9 = true;
        }
        this.th.check(bl9, "checking new size -- 4");
        al = new ArrayList();
        try {
            al.remove(0);
            this.th.fail("should throw an IndexOutOfBoundsException -- 3");
        }
        catch (IndexOutOfBoundsException e) {
            this.th.check(true);
        }
    }

    public void test_set() {
        this.th.checkPoint("set(int,java.lang.Object)java.lang.Object");
        ArrayList al = new ArrayList();
        try {
            al.set(-1, "a");
            this.th.fail("should throw an IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException e) {
            this.th.check(true);
        }
        try {
            al.set(0, "a");
            this.th.fail("should throw an IndexOutOfBoundsException -- 2");
        }
        catch (IndexOutOfBoundsException e) {
            this.th.check(true);
        }
        al = this.buildAL();
        try {
            al.set(-1, "a");
            this.th.fail("should throw an IndexOutOfBoundsException -- 3");
        }
        catch (IndexOutOfBoundsException e) {
            this.th.check(true);
        }
        try {
            al.set(14, "a");
            this.th.fail("should throw an IndexOutOfBoundsException -- 4");
        }
        catch (IndexOutOfBoundsException e) {
            this.th.check(true);
        }
        this.th.check("a".equals(al.set(5, "b")), "checking returnvalue of set -- 1");
        this.th.check("a".equals(al.set(0, null)), "checking returnvalue of set -- 2");
        this.th.check("b".equals(al.get(5)), "checking effect of set -- 1");
        boolean bl = false;
        if (al.get(0) == null) {
            bl = true;
        }
        this.th.check(bl, "checking effect of set -- 2");
        this.th.check("b".equals(al.set(5, "a")), "checking returnvalue of set -- 3");
        boolean bl2 = false;
        if (al.set(0, null) == null) {
            bl2 = true;
        }
        this.th.check(bl2, "checking returnvalue of set -- 4");
        this.th.check("a".equals(al.get(5)), "checking effect of set -- 3");
        boolean bl3 = false;
        if (al.get(0) == null) {
            bl3 = true;
        }
        this.th.check(bl3, "checking effect of set -- 4");
    }

    public void test_contains() {
        this.th.checkPoint("contains(java.lang.Object)boolean");
        ArrayList al = new ArrayList();
        this.th.check(al.contains(null) ^ true, "checking empty List -- 1");
        this.th.check(al.contains(al) ^ true, "checking empty List -- 2");
        al = this.buildAL();
        this.th.check(al.contains(null), "check contains ... -- 1");
        this.th.check(al.contains("a"), "check contains ... -- 2");
        this.th.check(al.contains("c"), "check contains ... -- 3");
        this.th.check(al.contains(this) ^ true, "check contains ... -- 4");
        al.remove(6);
        this.th.check(al.contains(null), "check contains ... -- 5");
        al.remove(12);
        this.th.check(al.contains(null) ^ true, "check contains ... -- 6");
        this.th.check(al.contains("b") ^ true, "check contains ... -- 7");
        this.th.check(al.contains(al) ^ true, "check contains ... -- 8");
    }

    public void test_isEmpty() {
        this.th.checkPoint("isEmpty()boolean");
        ArrayList<String> al = new ArrayList<String>();
        this.th.check(al.isEmpty(), "checking returnvalue -- 1");
        al.add("A");
        this.th.check(al.isEmpty() ^ true, "checking returnvalue -- 2");
        al.remove(0);
        this.th.check(al.isEmpty(), "checking returnvalue -- 3");
    }

    public void test_indexOf() {
        this.th.checkPoint("indexOf(java.lang.Object)int");
        ArrayList al = new ArrayList();
        boolean bl = false;
        if (al.indexOf(null) == -1) {
            bl = true;
        }
        this.th.check(bl, "checks on empty list -- 1");
        boolean bl2 = false;
        if (al.indexOf(al) == -1) {
            bl2 = true;
        }
        this.th.check(bl2, "checks on empty list -- 2");
        Object o = new Object();
        al = this.buildAL();
        boolean bl3 = false;
        if (al.indexOf(o) == -1) {
            bl3 = true;
        }
        this.th.check(bl3, " doesn't contain -- 1");
        boolean bl4 = false;
        if (al.indexOf("a") == 0) {
            bl4 = true;
        }
        this.th.check(bl4, "contains -- 2");
        boolean bl5 = false;
        if (al.indexOf(o) == -1) {
            bl5 = true;
        }
        this.th.check(bl5, "contains -- 3");
        al.add(9, o);
        boolean bl6 = false;
        if (al.indexOf(o) == 9) {
            bl6 = true;
        }
        this.th.check(bl6, "contains -- 4");
        boolean bl7 = false;
        if (al.indexOf(new Object()) == -1) {
            bl7 = true;
        }
        this.th.check(bl7, "doesn't contain -- 5");
        boolean bl8 = false;
        if (al.indexOf(null) == 6) {
            bl8 = true;
        }
        this.th.check(bl8, "null was added to the Vector");
        al.remove(6);
        boolean bl9 = false;
        if (al.indexOf(null) == 13) {
            bl9 = true;
        }
        this.th.check(bl9, "null was added twice to the Vector");
        al.remove(13);
        boolean bl10 = false;
        if (al.indexOf(null) == -1) {
            bl10 = true;
        }
        this.th.check(bl10, "null was removed to the Vector");
        boolean bl11 = false;
        if (al.indexOf("c") == 1) {
            bl11 = true;
        }
        this.th.check(bl11, "contains -- 6");
        boolean bl12 = false;
        if (al.indexOf("u") == 2) {
            bl12 = true;
        }
        this.th.check(bl12, "contains -- 7");
        boolean bl13 = false;
        if (al.indexOf("n") == 3) {
            bl13 = true;
        }
        this.th.check(bl13, "contains -- 8");
    }

    public void test_size() {
        this.th.checkPoint("size()int");
        ArrayList<String> al = new ArrayList<String>();
        boolean bl = false;
        if (al.size() == 0) {
            bl = true;
        }
        this.th.check(bl, "check on size -- 1");
        al.addAll(this.buildAL());
        boolean bl2 = false;
        if (al.size() == 14) {
            bl2 = true;
        }
        this.th.check(bl2, "check on size -- 1");
        al.remove(5);
        boolean bl3 = false;
        if (al.size() == 13) {
            bl3 = true;
        }
        this.th.check(bl3, "check on size -- 1");
        al.add(4, "G");
        boolean bl4 = false;
        if (al.size() == 14) {
            bl4 = true;
        }
        this.th.check(bl4, "check on size -- 1");
    }

    public void test_lastIndexOf() {
        this.th.checkPoint("lastIndexOf(java.lang.Object)int");
        ArrayList al = new ArrayList();
        boolean bl = false;
        if (al.lastIndexOf(null) == -1) {
            bl = true;
        }
        this.th.check(bl, "checks on empty list -- 1");
        boolean bl2 = false;
        if (al.lastIndexOf(al) == -1) {
            bl2 = true;
        }
        this.th.check(bl2, "checks on empty list -- 2");
        Object o = new Object();
        al = this.buildAL();
        boolean bl3 = false;
        if (al.lastIndexOf(o) == -1) {
            bl3 = true;
        }
        this.th.check(bl3, " doesn't contain -- 1");
        boolean bl4 = false;
        if (al.lastIndexOf("a") == 12) {
            bl4 = true;
        }
        this.th.check(bl4, "contains -- 2");
        boolean bl5 = false;
        if (al.lastIndexOf(o) == -1) {
            bl5 = true;
        }
        this.th.check(bl5, "contains -- 3");
        al.add(9, o);
        boolean bl6 = false;
        if (al.lastIndexOf(o) == 9) {
            bl6 = true;
        }
        this.th.check(bl6, "contains -- 4");
        boolean bl7 = false;
        if (al.lastIndexOf(new Object()) == -1) {
            bl7 = true;
        }
        this.th.check(bl7, "doesn't contain -- 5");
        boolean bl8 = false;
        if (al.lastIndexOf(null) == 14) {
            bl8 = true;
        }
        this.th.check(bl8, "null was added to the Vector");
        al.remove(14);
        boolean bl9 = false;
        if (al.lastIndexOf(null) == 6) {
            bl9 = true;
        }
        this.th.check(bl9, "null was added twice to the Vector");
        al.remove(6);
        boolean bl10 = false;
        if (al.lastIndexOf(null) == -1) {
            bl10 = true;
        }
        this.th.check(bl10, "null was removed to the Vector");
        boolean bl11 = false;
        if (al.lastIndexOf("c") == 7) {
            bl11 = true;
        }
        this.th.check(bl11, "contains -- 6, got " + al.lastIndexOf("c"));
        boolean bl12 = false;
        if (al.lastIndexOf("u") == 9) {
            bl12 = true;
        }
        this.th.check(bl12, "contains -- 7, got " + al.lastIndexOf("u"));
        boolean bl13 = false;
        if (al.lastIndexOf("n") == 10) {
            bl13 = true;
        }
        this.th.check(bl13, "contains -- 8, got " + al.lastIndexOf("n"));
    }

    public void test_toArray() {
        this.th.checkPoint("toArray()java.lang.Object[]");
        ArrayList v = new ArrayList();
        Object[] o = v.toArray();
        boolean bl = false;
        if (o.length == 0) {
            bl = true;
        }
        this.th.check(bl, "checking size Object array");
        v.add("a");
        v.add(null);
        v.add("b");
        o = v.toArray();
        boolean bl2 = false;
        if (o[0] == "a" && o[1] == null && o[2] == "b") {
            bl2 = true;
        }
        this.th.check(bl2, "checking elements -- 1");
        boolean bl3 = false;
        if (o.length == 3) {
            bl3 = true;
        }
        this.th.check(bl3, "checking size Object array");
        this.th.checkPoint("toArray(java.lang.Object[])java.lang.Object[]");
        v = new ArrayList();
        try {
            v.toArray((T[])null);
            this.th.fail("should throw NullPointerException -- 1");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        v.add("a");
        v.add(null);
        v.add("b");
        String[] sa = new String[5];
        sa[3] = "deleteme";
        sa[4] = "leavemealone";
        boolean bl4 = false;
        if (v.toArray(sa) == sa) {
            bl4 = true;
        }
        this.th.check(bl4, "sa is large enough, no new array created");
        boolean bl5 = false;
        if (sa[0] == "a" && sa[1] == null && sa[2] == "b") {
            bl5 = true;
        }
        this.th.check(bl5, "checking elements -- 1" + sa[0] + ", " + sa[1] + ", " + sa[2]);
        boolean bl6 = false;
        if (sa.length == 5) {
            bl6 = true;
        }
        this.th.check(bl6, "checking size Object array");
        boolean bl7 = false;
        if (sa[3] == null && sa[4] == "leavemealone") {
            bl7 = true;
        }
        this.th.check(bl7, "check other elements -- 1" + sa[3] + ", " + sa[4]);
        v = this.buildAL();
        try {
            v.toArray((T[])null);
            this.th.fail("should throw NullPointerException -- 2");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        try {
            v.toArray(new Class[5]);
            this.th.fail("should throw an ArrayStoreException");
        }
        catch (ArrayStoreException ae) {
            this.th.check(true);
        }
        v.add(null);
        sa = new String[15];
        String[] sar = v.toArray(sa);
        boolean bl8 = false;
        if (sar == sa) {
            bl8 = true;
        }
        this.th.check(bl8, "returned array is the same");
    }

    public void test_clone() {
        this.th.checkPoint("clone()java.lang.Object");
        ArrayList<String> al = new ArrayList<String>();
        ArrayList cal = (ArrayList)al.clone();
        boolean bl = false;
        if (cal.size() == 0) {
            bl = true;
        }
        this.th.check(bl, "checking size -- 1");
        al.add("a");
        al.add("b");
        al.add("c");
        al.add(null);
        cal = (ArrayList)al.clone();
        boolean bl2 = false;
        if (cal.size() == al.size()) {
            bl2 = true;
        }
        this.th.check(bl2, "checking size -- 2");
        boolean bl3 = false;
        if (al != cal) {
            bl3 = true;
        }
        this.th.check(bl3, "Objects are not the same");
        this.th.check(al.equals(cal), "cloned list is equal");
        al.add("a");
        boolean bl4 = false;
        if (cal.size() == 4) {
            bl4 = true;
        }
        this.th.check(bl4, "changes in one object doen't affect the other -- 2");
    }

    public void test_removeRange() {
        this.th.checkPoint("removeRange(int,int)void");
        SMExArrayList xal = new SMExArrayList((Collection)this.buildAL());
        ArrayList al = this.buildAL();
        xal.ensureCapacity(40);
        try {
            xal.removeRange(0, -1);
            this.th.fail("should throw an IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.th.check(true);
        }
        this.th.check(xal.equals(al), "ArrayList must not be changed -- 1");
        try {
            xal.removeRange(-1, 2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 2");
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.th.check(true);
        }
        this.th.check(xal.equals(al), "ArrayList must not be changed -- 2");
        try {
            xal.removeRange(3, 2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 3");
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.th.check(true);
        }
        this.th.check(al.equals(xal), "ArrayList must not be changed -- 3");
        xal = new SMExArrayList((Collection)this.buildAL());
        xal.ensureCapacity(40);
        try {
            xal.removeRange(3, 15);
            this.th.fail("should throw an IndexOutOfBoundsException -- 4");
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.th.check(true);
        }
        this.th.check(xal.equals(al), "ArrayList must not be changed -- 4");
        xal = new SMExArrayList((Collection)this.buildAL());
        xal.ensureCapacity(40);
        try {
            xal.removeRange(15, 13);
            this.th.fail("should throw an IndexOutOfBoundsException -- 5");
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.th.check(true);
        }
        this.th.check(xal.equals(al), "ArrayList must not be changed -- 5");
        xal = new SMExArrayList((Collection)this.buildAL());
        xal.ensureCapacity(40);
        xal.removeRange(14, 14);
        boolean bl = false;
        if (xal.size() == 14) {
            bl = true;
        }
        this.th.check(bl, "no elements should have been removed -- 6, size = " + xal.size());
        xal.removeRange(10, 14);
        boolean bl2 = false;
        if (xal.size() == 10) {
            bl2 = true;
        }
        this.th.check(bl2, "4 elements should have been removed");
        boolean bl3 = false;
        if ("a".equals(xal.get(0)) && "a".equals(xal.get(5)) && "a".equals(xal.get(7))) {
            bl3 = true;
        }
        this.th.check(bl3, "check contents -- 1");
        xal.removeRange(2, 7);
        boolean bl4 = false;
        if (xal.size() == 5) {
            bl4 = true;
        }
        this.th.check(bl4, "5 elements should have been removed");
        boolean bl5 = false;
        if ("a".equals(xal.get(0)) && "c".equals(xal.get(1)) && "a".equals(xal.get(2)) && "c".equals(xal.get(3)) && "u".equals(xal.get(4))) {
            bl5 = true;
        }
        this.th.check(bl5, "check contents -- 2");
        xal.removeRange(0, 2);
        boolean bl6 = false;
        if ("a".equals(xal.get(0)) && "c".equals(xal.get(1)) && "u".equals(xal.get(2))) {
            bl6 = true;
        }
        this.th.check(bl6, "check contents -- 3");
        boolean bl7 = false;
        if (xal.size() == 3) {
            bl7 = true;
        }
        this.th.check(bl7, "2 elements should have been removed");
    }

    public void test_MC_iterator() {
        this.th.checkPoint("modCount(protected)int");
        SMExArrayList xal = new SMExArrayList((Collection)this.buildAL());
        Iterator it = xal.iterator();
        xal.removeRange(1, 10);
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- 1");
        }
        catch (ConcurrentModificationException ioobe) {
            this.th.check(true);
        }
        ArrayList al = this.buildAL();
        it = al.iterator();
        al.get(0);
        al.trimToSize();
        al.ensureCapacity(25);
        al.contains(null);
        al.isEmpty();
        al.indexOf(null);
        al.lastIndexOf(null);
        al.size();
        al.toArray();
        al.toArray(new String[10]);
        al.clone();
        try {
            it.next();
            this.th.check(true);
        }
        catch (ConcurrentModificationException ioobe) {
            this.th.fail("should not throw a ConcurrentModificationException -- 2");
        }
        it = al.iterator();
        al.add("b");
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- 3");
        }
        catch (ConcurrentModificationException ioobe) {
            this.th.check(true);
        }
        it = al.iterator();
        al.add(3, "b");
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- 4");
        }
        catch (ConcurrentModificationException ioobe) {
            this.th.check(true);
        }
        it = al.iterator();
        al.addAll(xal);
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- 5");
        }
        catch (ConcurrentModificationException ioobe) {
            this.th.check(true);
        }
        it = al.iterator();
        al.addAll(2, xal);
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- 6");
        }
        catch (ConcurrentModificationException ioobe) {
            this.th.check(true);
        }
        it = al.iterator();
        al.set(2, xal);
        try {
            it.next();
            this.th.check(true);
        }
        catch (ConcurrentModificationException ioobe) {
            this.th.fail("should throw Not a ConcurrentModificationException -- 7");
        }
        it = al.iterator();
        al.remove(2);
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- 8");
        }
        catch (ConcurrentModificationException ioobe) {
            this.th.check(true);
        }
        it = al.iterator();
        al.clear();
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- 9");
        }
        catch (ConcurrentModificationException ioobe) {
            this.th.check(true);
        }
    }
}

