/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.security.BasicPermission;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.security.BasicPermission.ExBasicPermission;
import java.io.SerializablePermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;

public class AcuniaSerializablePermissionTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.io.SerializablePermission");
        this.test_SerializablePermission();
        this.test_equals();
        this.test_hashCode();
        this.test_implies();
        this.test_getActions();
        this.test_newPermissionCollection();
    }

    public void test_SerializablePermission() {
        this.th.checkPoint("SerializablePermission(java.lang.String)");
        String s = "acunia.*";
        SerializablePermission bp = new SerializablePermission(s);
        this.th.check(bp.getName(), s, "checking name");
        s = "*";
        bp = new SerializablePermission(s);
        this.th.check(bp.getName(), s, "checking name");
        try {
            new SerializablePermission("");
            this.th.fail("should throw an IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true, "caught exception -- 1");
        }
        try {
            new SerializablePermission("*.java");
            this.th.fail("should throw an IllegalArgumentException -- 2");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true, "caught exception -- 2");
        }
        try {
            new SerializablePermission("*com");
            this.th.fail("should throw an IllegalArgumentException -- 3");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true, "caught exception -- 3");
        }
        try {
            new SerializablePermission("com*acunia");
            this.th.fail("should throw an IllegalArgumentException -- 4");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true, "caught exception -- 4");
        }
        try {
            new SerializablePermission("**");
            this.th.fail("should throw an IllegalArgumentException -- 5");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true, "caught exception -- 5");
        }
        try {
            new SerializablePermission("*.*");
            this.th.fail("should throw an IllegalArgumentException -- 6");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true, "caught exception -- 6");
        }
        try {
            new SerializablePermission(null);
            this.th.fail("should throw a NullPointerException -- 7");
        }
        catch (NullPointerException iae) {
            this.th.check(true, "caught exception -- 7");
        }
        this.th.checkPoint("SerializablePermission(java.lang.String,java.lang.String)");
        try {
            bp = new SerializablePermission("cool.*", null);
            this.th.check(bp.getName(), (Object)"cool.*");
            new SerializablePermission("cool.*", "");
            new SerializablePermission("cool.*", "*ddf");
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception " + e);
        }
    }

    public void test_equals() {
        this.th.checkPoint("equals(java.lang.Object)boolean");
        SerializablePermission bp = new SerializablePermission("com.acunia");
        this.th.check(bp.equals(null) ^ true, "null is allowed");
        this.th.check(bp.equals(new SerializablePermission("com.*")) ^ true, "not equal -- 2");
        this.th.check(bp.equals(new SerializablePermission("com.acunia", "1")), "equal");
        this.th.check(bp.equals(new ExBasicPermission("com.acunia", "1")) ^ true, "not equal -- 2");
    }

    public void test_hashCode() {
        this.th.checkPoint("hashCode()int");
        String s = "com.acunia";
        SerializablePermission bp = new SerializablePermission(s);
        this.th.check(bp.hashCode(), s.hashCode(), "cheking hash algorithm ... - 1");
        s = "com.*";
        bp = new SerializablePermission(s);
        this.th.check(bp.hashCode(), s.hashCode(), "cheking hash algorithm ... - 2");
        s = "*";
        bp = new SerializablePermission(s, s);
        this.th.check(bp.hashCode(), s.hashCode(), "cheking hash algorithm ... - 3");
        bp = new SerializablePermission(s);
        this.th.check(bp.hashCode(), s.hashCode(), "cheking hash algorithm ... - 4");
    }

    public void test_implies() {
        this.th.checkPoint("implies(java.security.Permission)boolean");
        SerializablePermission bp1 = new SerializablePermission("com.acunia");
        SerializablePermission bp2 = new SerializablePermission("com.*");
        this.th.check(bp1.implies(bp2) ^ true, "not implied - 1");
        this.th.check(bp2.implies(bp1), "implied - 1");
        this.th.check(bp1.implies(bp1), "implied - 2");
        this.th.check(bp2.implies(bp2), "implied - 3");
        this.th.check(bp1.implies(new ExBasicPermission("com.acunia", "1")) ^ true, "not implied -- 2");
        bp2 = new SerializablePermission("com.*");
        this.th.check(bp2.implies(bp1), "implied - 4");
        bp1 = new SerializablePermission("com.");
        this.th.check(bp2.implies(bp1), "implied - 5");
        this.th.check(bp1.implies(bp2) ^ true, "not implied - 3");
        bp1 = new SerializablePermission("coma");
        bp2 = new SerializablePermission("coma*");
        this.th.check(bp2.implies(bp1), "implied - 6");
        this.th.check(bp1.implies(bp2) ^ true, "not implied - 4");
    }

    public void test_getActions() {
        this.th.checkPoint("getActions()java.lang.String");
        String s = "com.acunia";
        SerializablePermission bp = new SerializablePermission(s);
        this.th.check(bp.getActions(), "", "getActions returnvalue - 1");
        s = "com.*";
        bp = new SerializablePermission(s);
        this.th.check(bp.getActions(), "", "getActions returnvalue - 2");
        s = "*";
        bp = new SerializablePermission(s, s);
        this.th.check(bp.getActions(), "", "getActions returnvalue - 3");
        bp = new SerializablePermission(s);
        this.th.check(bp.getActions(), "", "getActions returnvalue - 4");
    }

    public void test_newPermissionCollection() {
        Enumeration<Permission> e;
        this.th.checkPoint("newPermissionCollection()java.security.PermissionCollection");
        String s = "com.acunia";
        SerializablePermission bp = new SerializablePermission(s);
        PermissionCollection pc = bp.newPermissionCollection();
        this.th.check(pc.isReadOnly() ^ true);
        pc.setReadOnly();
        this.th.check(pc.isReadOnly());
        try {
            pc.add(bp);
            e = pc.elements();
            this.th.check(e.hasMoreElements() ^ true);
        }
        catch (SecurityException se) {
            this.th.check(true);
        }
        pc = bp.newPermissionCollection();
        pc.add(bp);
        pc.add(new SerializablePermission("be.*"));
        pc.add(new SerializablePermission("vm.smartmove"));
        pc.add(new SerializablePermission("com.acunia.vm*"));
        try {
            e = pc.elements();
            boolean bl = false;
            if (bp == e.nextElement()) {
                bl = true;
            }
            boolean found = bl;
            boolean bl2 = false;
            if (bp == e.nextElement()) {
                bl2 = true;
            }
            found |= bl2;
            boolean bl3 = false;
            if (bp == e.nextElement()) {
                bl3 = true;
            }
            found |= bl3;
            boolean bl4 = false;
            if (bp == e.nextElement()) {
                bl4 = true;
            }
            this.th.check(found |= bl4, "reference should be kept");
            this.th.check(e.hasMoreElements() ^ true, "should be empty");
        }
        catch (Exception e2) {
            this.th.fail("Enumeration elements() was bad");
        }
        e = pc.elements();
        int i = 0;
        while (i < 50 && e.hasMoreElements()) {
            this.th.debug("got " + e.nextElement() + ", i = " + i);
            ++i;
        }
        s = pc.toString();
        this.th.debug(s);
        boolean bl = false;
        if (s.indexOf(bp.toString()) >= 0) {
            bl = true;
        }
        this.th.check(bl, "checking toString ...");
        boolean bl5 = false;
        if (s.indexOf(new SerializablePermission("be.*").toString()) >= 0) {
            bl5 = true;
        }
        this.th.check(bl5, "checking toString ...");
        boolean bl6 = false;
        if (s.indexOf(new SerializablePermission("vm.smartmove").toString()) >= 0) {
            bl6 = true;
        }
        this.th.check(bl6, "checking toString ...");
        boolean bl7 = false;
        if (s.indexOf(new SerializablePermission("com.acunia.vm*").toString()) >= 0) {
            bl7 = true;
        }
        this.th.check(bl7, "checking toString ...");
        this.th.check(pc.implies(bp), "implies -- 1 " + bp);
        bp = new SerializablePermission("com.acu*");
        this.th.check(pc.implies(bp) ^ true, "implies -- 2 " + bp);
        bp = new SerializablePermission("be.");
        this.th.check(pc.implies(bp), "implies -- 3 " + bp);
        bp = new SerializablePermission("be");
        this.th.check(pc.implies(bp) ^ true, "implies -- 4 " + bp);
        bp = new SerializablePermission("com.acunia");
        this.th.check(pc.implies(bp), "implies -- 5 " + bp);
        bp = new SerializablePermission("com.acunia.vm");
        this.th.check(pc.implies(bp), "implies -- 6 " + bp);
        bp = new SerializablePermission("vm");
        this.th.check(pc.implies(bp) ^ true, "implies -- 7 " + bp);
    }
}

