/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.security.AllPermission;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.SecurityPermission;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class AcuniaAllPermissionTest
implements Testlet {
    protected TestHarness th;
    private final String allp = "<all permissions>";
    private final String action = "<all actions>";

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.security.AllPermission");
        this.test_AllPermission();
        this.test_equals();
        this.test_hashCode();
        this.test_implies();
        this.test_getActions();
        this.test_newPermissionCollection();
        this.test_toString();
    }

    public void test_AllPermission() {
        this.th.checkPoint("AllPermission()");
        AllPermission bp = new AllPermission();
        this.th.check(bp.getName(), (Object)"<all permissions>");
        this.th.check(bp.getActions(), (Object)"<all actions>");
        this.th.checkPoint("AllPermission(java.lang.String,java.lang.String)");
        bp = new AllPermission(null, null);
        this.th.check(bp.getName(), (Object)"<all permissions>");
        this.th.check(bp.getActions(), (Object)"<all actions>");
        bp = new AllPermission("*.*fghhgjhf*g", null);
        this.th.check(bp.getName(), (Object)"<all permissions>");
        this.th.check(bp.getActions(), (Object)"<all actions>");
    }

    public void test_equals() {
        this.th.checkPoint("equals(java.lang.Object)boolean");
        AllPermission bp = new AllPermission("com.acunia", "read");
        this.th.check(bp.equals(null) ^ true, "null is allowed");
        this.th.check(bp.equals(new AllPermission()), "equal -- 1");
        this.th.check(bp.equals(new SecurityPermission("com.acunia", "read")) ^ true, "not equal -- 2");
    }

    public void test_hashCode() {
        this.th.checkPoint("hashCode()int");
        String s = "com.acunia";
        AllPermission bp = new AllPermission();
        this.th.check(bp.hashCode(), 1, "cheking hash algorithm ... - 1");
        s = "com.*";
        bp = new AllPermission(s, null);
        this.th.check(bp.hashCode(), 1, "cheking hash algorithm ... - 2");
        s = "*";
    }

    public void test_implies() {
        this.th.checkPoint("implies(java.security.Permission)boolean");
        AllPermission bp1 = new AllPermission("com.acunia", "read");
        AllPermission bp2 = new AllPermission();
        this.th.check(bp1.implies(bp2), "implied - 1");
        this.th.check(bp2.implies(null), "not implied - 1");
        this.th.check(bp2.implies(bp1), "implied - 2");
        this.th.check(bp1.implies(new SecurityPermission("com.acunia", "1")), "implied -- 3");
    }

    public void test_getActions() {
        this.th.checkPoint("getActions()java.lang.String");
        String s = "com.acunia";
        AllPermission bp = new AllPermission(s, "read \n \f");
        this.th.check(bp.getActions(), "<all actions>", "getActions returnvalue - 1");
        s = "com.*";
        bp = new AllPermission(s, "  \t \nwRiTe\f");
        this.th.check(bp.getActions(), "<all actions>", "getActions returnvalue - 2");
        s = "*";
        bp = new AllPermission(s, "WriTe \n ,\t REaD , ReAd ,Write");
        this.th.check(bp.getActions(), "<all actions>", "getActions returnvalue - 3");
        bp = new AllPermission(s, "Read");
        this.th.check(bp.getActions(), "<all actions>", "getActions returnvalue - 4");
    }

    public void test_newPermissionCollection() {
        this.th.checkPoint("newPermissionCollection()java.security.PermissionCollection");
        String s = "com.acunia";
        AllPermission bp = new AllPermission(s, "read");
        PermissionCollection pc = bp.newPermissionCollection();
        Enumeration<Permission> e = pc.elements();
        this.th.check(e.hasMoreElements() ^ true, "should be empty");
        try {
            e.nextElement();
            this.th.fail("Enumeration elements() was bad");
        }
        catch (NoSuchElementException ee) {
            this.th.check(true);
        }
        this.th.check(pc.isReadOnly() ^ true, "not readOnly");
        pc.setReadOnly();
        this.th.check(pc.isReadOnly(), "readOnly");
        try {
            pc.add(bp);
            e = pc.elements();
            this.th.check(e.hasMoreElements() ^ true, "added element");
        }
        catch (SecurityException se) {
            this.th.check(true);
        }
        pc = bp.newPermissionCollection();
        pc.add(bp);
        pc.add(new AllPermission("be.*", "read"));
        pc.add(new AllPermission("vm.smartmove", "write"));
        pc.add(new AllPermission("com.acunia.vm*", "read,write"));
        s = pc.toString();
        this.th.debug(s);
        boolean bl = false;
        if (s.indexOf(bp.toString()) >= 0) {
            bl = true;
        }
        this.th.check(bl, "checking toString ...");
        this.th.check(pc.implies(bp), "implies -- 1 " + bp);
        this.th.check(pc.implies(new SecurityPermission("cool")), "implies -- 2 ");
    }

    public void test_toString() {
        this.th.setclass("java.security.Permission");
        this.th.checkPoint("toString()java.lang.String");
        String s = "com.acunia";
        AllPermission bp = new AllPermission(s, "reAd");
        this.th.check(bp.toString(), (Object)("(\"" + bp.getClass().getName() + "\" \"<all permissions>\" \"<all actions>\")"));
    }
}

