/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.security;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.security.BasicPermission.ExBasicPermission;
import java.io.FilePermission;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.PropertyPermission;

public class AcuniaPermissionTest
implements Testlet {
    protected TestHarness th;

    private void test_implies(Permission a, Permission b, boolean expected) {
        boolean result = a.implies(b);
        this.th.check(result == expected, a + " implies " + b + ": " + result + ", expected: " + expected);
    }

    private void test_implies(PermissionCollection c, Permission b, boolean expected) {
        boolean result = c.implies(b);
        this.th.check(result == expected, c + " implies " + b + ": " + result + ", expected: " + expected);
    }

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("permissions");
        String arch = System.getProperty("os.arch");
        Runtime rt = Runtime.getRuntime();
        ExBasicPermission ba_foo_bar_baz = new ExBasicPermission("foo.bar.baz");
        ExBasicPermission ba_foo_bar_quux = new ExBasicPermission("foo.bar.quux");
        ExBasicPermission ba_foo_bar_bacon = new ExBasicPermission("foo.bar.bacon");
        ExBasicPermission ba_foo_bar_star = new ExBasicPermission("foo.bar.*");
        ExBasicPermission ba_foo_balls = new ExBasicPermission("foo.balls");
        ExBasicPermission ba_off_the_wall = new ExBasicPermission("off.the.wall");
        FilePermission fi_fish_fillet = new FilePermission("wonka", "execute");
        this.test_implies(ba_foo_bar_baz, (Permission)ba_foo_bar_baz, true);
        this.test_implies(ba_foo_bar_baz, (Permission)ba_foo_bar_star, false);
        this.test_implies(ba_foo_bar_star, (Permission)ba_foo_bar_baz, true);
        this.test_implies(ba_foo_bar_star, (Permission)ba_foo_balls, false);
        PermissionCollection ba_pc = ba_foo_bar_baz.newPermissionCollection();
        ba_pc.add(ba_foo_bar_baz);
        ba_pc.add(ba_foo_bar_quux);
        ba_pc.add(ba_foo_bar_star);
        try {
            ba_pc.add(fi_fish_fillet);
            this.th.fail(ba_pc + " accepted add(" + fi_fish_fillet + ") ==> ERROR");
        }
        catch (IllegalArgumentException e) {
            this.th.check(true, "Threw " + e + " ==> OK");
        }
        this.th.checkPoint("BasicPermissionCollection: ");
        Enumeration<Permission> bae = ba_pc.elements();
        while (bae.hasMoreElements()) {
            this.th.debug("  " + bae.nextElement());
        }
        this.test_implies(ba_pc, (Permission)ba_foo_bar_baz, true);
        this.test_implies(ba_pc, (Permission)ba_foo_bar_quux, true);
        this.test_implies(ba_pc, (Permission)ba_foo_bar_star, true);
        this.test_implies(ba_pc, (Permission)ba_foo_bar_bacon, true);
        this.test_implies(ba_pc, (Permission)ba_foo_balls, false);
        this.test_implies(ba_pc, (Permission)ba_off_the_wall, false);
        this.th.checkPoint("FilePermission");
        FilePermission fi_foo_bar_baz = new FilePermission("/foo/bar/baz", "read,write");
        FilePermission fi_foo_bar_quux = new FilePermission("/foo/bar/quux", "execute");
        FilePermission fi_foo_bar_bacon = new FilePermission("/foo/bar/bacon", "read");
        FilePermission fi_foo_bar_star = new FilePermission("/foo/bar/*", "read");
        FilePermission fi_foo_balls = new FilePermission("/foo/balls", "read");
        FilePermission fi_foo_falls = new FilePermission("/foo/falls", "delete");
        FilePermission fi_off_the_wall = new FilePermission("/off/the/wall", "write");
        FilePermission fi_delete_all = new FilePermission("<<ALL FILES>>", "delete");
        ExBasicPermission ba_fish_fillet = new ExBasicPermission("wonk");
        this.test_implies(fi_foo_bar_baz, (Permission)fi_foo_bar_baz, true);
        this.test_implies(fi_foo_bar_baz, (Permission)fi_foo_bar_star, false);
        this.test_implies(fi_foo_bar_star, (Permission)fi_foo_bar_baz, false);
        this.test_implies(fi_foo_bar_star, (Permission)fi_foo_falls, false);
        this.th.checkPoint("FilePermissionCollection");
        PermissionCollection fi_pc = fi_foo_bar_baz.newPermissionCollection();
        fi_pc.add(fi_foo_bar_baz);
        fi_pc.add(fi_foo_bar_quux);
        fi_pc.add(fi_foo_bar_star);
        fi_pc.add(fi_delete_all);
        try {
            fi_pc.add(ba_fish_fillet);
            this.th.fail(fi_pc + " accepted add(" + ba_fish_fillet + ") ==> ERROR");
        }
        catch (IllegalArgumentException e) {
            this.th.check(true, "Threw " + e + " ==> OK");
        }
        Enumeration<Permission> fi_pce = fi_pc.elements();
        while (fi_pce.hasMoreElements()) {
            this.th.debug("  " + fi_pce.nextElement());
        }
        this.test_implies(fi_pc, (Permission)fi_foo_bar_baz, true);
        this.test_implies(fi_pc, (Permission)fi_foo_bar_quux, true);
        this.test_implies(fi_pc, (Permission)fi_foo_bar_star, true);
        this.test_implies(fi_pc, (Permission)fi_foo_bar_bacon, true);
        this.test_implies(fi_pc, (Permission)fi_foo_falls, true);
        this.test_implies(fi_pc, (Permission)fi_foo_balls, false);
        this.test_implies(fi_pc, (Permission)fi_off_the_wall, false);
        this.th.checkPoint("PropertyPermissionCollection");
        PropertyPermission pr_foo_bar_baz = new PropertyPermission("foo.bar.baz", "read,write");
        PropertyPermission pr_foo_bar_quux = new PropertyPermission("foo.bar.quux", "read,write");
        PropertyPermission pr_foo_bar_bacon = new PropertyPermission("foo.bar.bacon", "write");
        PropertyPermission pr_foo_bar_star = new PropertyPermission("foo.bar.*", "read");
        PropertyPermission pr_foo_balls = new PropertyPermission("foo.balls", "read,write");
        try {
            PropertyPermission pr_off_the_wall = new PropertyPermission("off.the.wall", "pruts");
            this.th.fail("bad action should trigger IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        this.test_implies(pr_foo_bar_baz, (Permission)pr_foo_bar_baz, true);
        this.test_implies(pr_foo_bar_baz, (Permission)pr_foo_bar_star, false);
        this.test_implies(pr_foo_bar_star, (Permission)pr_foo_bar_baz, false);
        PermissionCollection pr_pc = pr_foo_bar_baz.newPermissionCollection();
        pr_pc.add(pr_foo_bar_baz);
        pr_pc.add(pr_foo_bar_quux);
        pr_pc.add(pr_foo_bar_star);
        try {
            pr_pc.add(fi_fish_fillet);
            this.th.fail(pr_pc + " accepted add(" + fi_fish_fillet + ") ==> ERROR");
        }
        catch (IllegalArgumentException e) {
            this.th.check(true, "Threw " + e + " ==> OK");
        }
        this.th.checkPoint("PropertyPermissionCollection:");
        Enumeration<Permission> pr_pce = pr_pc.elements();
        while (pr_pce.hasMoreElements()) {
            this.th.debug("  " + pr_pce.nextElement());
        }
        this.test_implies(pr_pc, (Permission)pr_foo_bar_baz, true);
        this.test_implies(pr_pc, (Permission)pr_foo_bar_quux, true);
        this.test_implies(pr_pc, (Permission)pr_foo_bar_star, true);
        this.test_implies(pr_pc, (Permission)pr_foo_bar_bacon, false);
        this.test_implies(pr_pc, (Permission)pr_foo_balls, false);
        AllPermission ap1 = new AllPermission("foo", "bar");
        AllPermission ap2 = new AllPermission();
        this.test_implies(ap1, (Permission)ap2, true);
        this.th.check(ap1.equals(ap2), "ap1.equals(ap2) should be true");
    }
}

