/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.net.Socket;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.net.Socket.MySocket;
import gnu.testlet.wonka.net.Socket.MySocketImpl;
import gnu.testlet.wonka.net.Socket.SocketBServer;
import gnu.testlet.wonka.net.Socket.SocketServer;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class SocketTest
implements Testlet {
    protected static TestHarness harness;

    public void test_BasicServer() {
        InputStream is;
        String str;
        int len;
        byte[] data;
        String str2;
        DataInputStream dis;
        Socket sock;
        harness.checkPoint("BasicServer");
        try {
            SocketServer srv = new SocketServer();
            SocketServer.harness = harness;
            srv.init();
            srv.start();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException i) {}
        }
        catch (Exception e) {
            harness.fail("Error : test_BasicServer failed - 0 exception was thrown :" + e.getMessage());
        }
        try {
            sock = new Socket("localhost", 20001);
            dis = new DataInputStream(sock.getInputStream());
            str2 = dis.readLine();
            if (!str2.equals("hello buddy")) {
                harness.fail("Error : test_BasicServer failed - 1 string returned is not correct.");
            }
            sock.close();
        }
        catch (Exception e) {
            harness.fail("Error : test_BasicServer failed - 2 exception was thrown :" + e.getMessage());
        }
        try {
            sock = new Socket("localhost", 20001);
            dis = new DataInputStream(sock.getInputStream());
            str2 = dis.readLine();
            if (!str2.equals("hello buddy")) {
                harness.fail("Error : test_BasicServer failed - 3 string returned is not correct.");
            }
            sock.close();
        }
        catch (Exception e) {
            harness.fail("Error : test_BasicServer failed - 4 exception was thrown :" + e.getMessage());
        }
        try {
            sock = new Socket("localhost", 20001);
            dis = new DataInputStream(sock.getInputStream());
            data = new byte[5];
            len = dis.read(data);
            str = new String(data, 0, 0, 5);
            if (!str.equals("hello")) {
                harness.fail("Error : test_BasicServer failed - 5 string returned is not correct.");
            }
            dis.close();
            sock.close();
        }
        catch (Exception e) {
            harness.fail("Error : test_BasicServer failed - 6 exception was thrown :" + e.getMessage());
        }
        try {
            sock = new Socket("localhost", 20001);
            is = sock.getInputStream();
            data = new byte[5];
            len = is.read(data, 0, 5);
            str = new String(data, 0, 0, 5);
            if (!str.equals("hello")) {
                harness.fail("Error : test_BasicServer failed - 8 string returned is not correct.");
            }
            is.close();
            sock.close();
        }
        catch (Exception e) {
            harness.fail("Error : test_BasicServer failed - 9 exception was thrown :" + e.getMessage());
        }
        try {
            sock = new Socket("localhost", 20001);
            is = sock.getInputStream();
            data = new byte[5];
            is.skip(2);
            len = is.available();
            if (len != 9) {
                harness.fail("Error : test_BasicServer failed - 7 len returned is not correct.  " + len);
            }
            is.read(data, 0, 3);
            str = new String(data, 0, 0, 3);
            if (!str.equals("llo")) {
                harness.fail("Error : test_BasicServer failed - 10 string returned is not correct.");
            }
            is.close();
            sock.close();
        }
        catch (Exception e) {
            harness.fail("Error : test_BasicServer failed - 11 exception was thrown :" + e.getMessage());
        }
        try {
            sock = new Socket("localhost", 7);
            InputStream sin = null;
            OutputStream sout = null;
            int i = 0;
            while (i < 10) {
                sin = sock.getInputStream();
                sout = sock.getOutputStream();
                ++i;
            }
        }
        catch (IOException e) {
            harness.check(true);
        }
        System.gc();
    }

    public void test_params() {
        harness.checkPoint("params");
        try {
            Socket sock = new Socket("www.acunia.com", 7);
            if (sock.getLocalPort() <= 0) {
                harness.fail("Error : test_params failed - 1 get port did not return proper values");
            }
            try {
                sock.setSoTimeout(100);
                harness.check(sock.getSoTimeout(), 100, "Error : test_params failed - 2 get /set timeout did not return proper values");
            }
            catch (Exception e) {
                e.printStackTrace();
                harness.fail("Error : setSoTimeout fails since vxWorks do not support the feature");
            }
            sock.setTcpNoDelay(true);
            if (!sock.getTcpNoDelay()) {
                harness.fail("Error : test_params failed - 3 get /set tcp delay did not return proper values");
            }
            sock.setSoLinger(true, 10);
            if (sock.getSoLinger() != 10) {
                harness.fail("Error : test_params failed - 4");
            }
            sock.setSoLinger(false, 20);
            if (sock.getSoLinger() != -1) {
                harness.fail("Error : test_params failed - 5");
            }
            if (sock.getPort() != 7) {
                harness.fail("Error : test_params failed - 6");
            }
            if (!sock.getInetAddress().toString().equals("www.cygnus.com/205.180.83.41")) {
                harness.fail("Error : test_params failed - 7");
            }
            if (!sock.getLocalAddress().toString().equals(InetAddress.getLocalHost().toString())) {
                harness.fail("Error : test_params failed - 8");
            }
            if (!sock.toString().equals("Socket[addr=www.cygnus.com/205.180.83.41,port=7,localport=" + sock.getLocalPort() + ']')) {
                harness.fail("Error : test_params failed - 9  toString did not return the expected string ");
            }
            try {
                Socket.setSocketImplFactory(null);
            }
            catch (IOException e) {
                harness.check(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            harness.fail("Error : test_params failed - 10 exception was thrown");
        }
    }

    public void test_Basics() {
        Socket s;
        harness.checkPoint("Basics");
        try {
            s = new Socket("babuspdjflks", 200);
            harness.fail("Error : test_Basics failed - 1  exception should have been thrown here");
        }
        catch (UnknownHostException e) {
            harness.check(true);
        }
        catch (IOException e) {
            harness.fail("Error : test_Basics failed - 2  Unknown host exception should have been thrown here: " + e.getMessage());
        }
        try {
            s = new Socket("localhost", 30001);
            harness.fail("Error : test_Basics failed - 3  exception should have been thrown here");
        }
        catch (UnknownHostException e) {
            harness.fail("Error : test_Basics failed - 4  Unknown host exception should not have been thrown here");
        }
        catch (IOException e) {
            harness.check(true);
        }
        try {
            s = new Socket("localhost", 30001, true);
            harness.fail("Error : test_Basics failed - 5  exception should have been thrown here");
        }
        catch (UnknownHostException e) {
            harness.fail("Error : test_Basics failed - 6  Unknown host exception should not have been thrown here");
        }
        catch (IOException e) {
            harness.check(true, "6");
        }
        try {
            s = new Socket(InetAddress.getLocalHost(), 30002);
            harness.fail("Error : test_Basics failed - 8  exception should have been thrown here");
        }
        catch (Exception e) {
            harness.check(true, "7");
        }
        try {
            s = new Socket("babuspdjflks", 200, InetAddress.getLocalHost(), 20001);
            System.out.println("Warning: test_Basics failed - 9 EJWcr00676 still fail");
        }
        catch (UnknownHostException e) {
            harness.check(true, "8");
        }
        catch (IOException e) {
            harness.fail("Error : test_Basics failed - 10  Unknown host exception should have been thrown here: " + e.getMessage());
        }
        try {
            s = new Socket("localhost", 30003, InetAddress.getLocalHost(), 20001);
            System.out.println("Warning: test_Basics failed - 11 EJWcr00676 still fail");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            harness.fail("Error : test_Basics failed - 12  Unknown host exception should not have been thrown here");
        }
        catch (IOException e) {
            harness.check(true, "9");
        }
        try {
            s = new Socket(InetAddress.getLocalHost(), 30004, InetAddress.getLocalHost(), 20001);
            System.out.println("Warning: test_Basics failed - 13 EJWcr00676 still fail");
        }
        catch (UnknownHostException e) {
            harness.fail("Error : test_Basics failed - 14  Unknown host exception should not have been thrown here");
        }
        catch (IOException e) {
            harness.check(true, "10");
        }
        MySocketImpl msi = null;
        try {
            msi = new MySocketImpl();
        }
        catch (RuntimeException s2) {
            // empty catch block
        }
        try {
            MySocket s2 = new MySocket(msi);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void test_BasicBServer() {
        harness.checkPoint("BasicBServer");
        SocketBServer srv = new SocketBServer();
        SocketBServer.harness = harness;
        srv.init();
        srv.start();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException sock) {
            // empty catch block
        }
        try {
            Socket sock = new Socket("localhost", 20002);
            DataInputStream dis = new DataInputStream(sock.getInputStream());
            String str = dis.readLine();
            if (!str.equals("hello buddy")) {
                harness.fail("Error : test_BasicServer failed - 1 string returned is not correct.");
            }
            sock.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            harness.fail("Error : test_BasicServer failed - 2 exception was thrown :");
        }
    }

    public void testall() {
        this.test_Basics();
        this.test_BasicBServer();
    }

    public void test(TestHarness the_harness) {
        harness = the_harness;
        harness.setclass("java.net.Socket");
        this.testall();
    }
}

