/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.net.InetAddress;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class AcuniaInetAddressTest
implements Testlet {
    protected static TestHarness harness;

    private final void testLocalhost() {
        try {
            harness.checkPoint("InetAddress building local host(getLocalHost)");
            InetAddress local = InetAddress.getLocalHost();
            harness.verbose("=> local adress (getLocalHost): " + local);
            boolean bl = false;
            if (local == InetAddress.getLocalHost()) {
                bl = true;
            }
            harness.check(bl, "local1.equals(InetAddress.getLocalHost())");
            harness.check(local, InetAddress.getLocalHost(), "implicit 'equals'");
            this.testAddressData(local);
        }
        catch (UnknownHostException uex) {
            harness.fail("Unable to resolve local host" + uex.toString());
        }
        catch (Exception e) {
            harness.fail(e.toString());
        }
    }

    private final void testLocalhostByName() {
        try {
            harness.checkPoint("InetAddress building local host(getByName(LocalHost))");
            InetAddress local = InetAddress.getByName("LocalHost");
            harness.verbose("=> local adress (getByName(LocalHost)): " + local);
            harness.check(local, InetAddress.getByName("LocalHost"));
            this.testAddressData(local);
        }
        catch (UnknownHostException uex) {
            harness.fail("Unable to resolve local host" + uex.toString());
        }
        catch (Exception e) {
            harness.fail(e.toString());
        }
    }

    private final void testLoopbackByName() {
        try {
            harness.checkPoint("InetAddress building local host(getByName(LocalHost))");
            InetAddress local = InetAddress.getByName("LocalHost");
            harness.verbose("=> loopback adress (getByName(null)): " + local);
            harness.check(local, InetAddress.getByName(null));
            this.testAddressData(local);
        }
        catch (UnknownHostException uex) {
            harness.fail("Unknown host" + uex.toString());
        }
        catch (Exception e) {
            harness.fail(e.toString());
        }
    }

    private final void testRandomByName() {
        harness.checkPoint("InetAddress getByName(random adress) for valid and invalid address strings");
        this.checkByName("www.kuleuven.ac.be");
        this.failByName("kuleuven.ac.be", "no http or www on web adress");
        this.failByName("www.sun", "no web adress extension");
        this.checkByName("users.skynet.be");
        this.failByName("users.skynet.be/bs975938", "no extensions");
        this.checkByName("mail.yahoo.com");
        this.failByName("www.yahoo.com/r/m1", "no extensions (redirects to mail)");
        this.failByName("www.yah123.com", "unexisting page");
        this.checkByName("127.0.0.1");
        this.checkByName("195.0.76.33");
        this.checkByName("192.168.008.002");
        this.checkByName("194.7.211.212");
        this.checkByName("192.007.211.212");
        this.failByName("192.168.  8.  2", "Name tag no spaces");
        this.failByName("195.0.76.33    ", "Name tag no spaces");
        this.failByName("    195.0.76.33", "Name tag no spaces");
        this.failByName("wonka.acunia. com", "no spaces allowed");
        this.failByName(" wonka.acunia.com", "no spaces allowed");
        this.failByName("wonka.acuni a.com", "no spaces allowed");
        this.failByName("wonka.acunia.com ", "no spaces allowed");
        try {
            harness.checkPoint("InetAddress getByName(random adress))");
            this.testAddressData(InetAddress.getByName("127.0.0.1"));
            this.testAddressData(InetAddress.getByName("hermeske"));
            this.testAddressData(InetAddress.getByName("wonka.acunia.com"));
        }
        catch (Exception e) {
            harness.fail(e.toString());
        }
    }

    private final void checkByName(String target) {
        try {
            InetAddress.getByName(target);
            harness.check(true, "InetAddress getByName(" + target + "))loaded");
        }
        catch (Exception e) {
            harness.fail("Loading <" + target + "> : " + e.toString());
        }
    }

    private final void failByName(String target, String reason) {
        try {
            InetAddress.getByName(target);
            harness.fail("InetAddress getByName(" + target + "))should fail for reason : " + reason);
        }
        catch (UnknownHostException uex) {
            harness.check(true, "InetAddress getByName(" + target + ")) failed for reason : " + reason);
        }
        catch (Exception e) {
            harness.fail(e.toString());
        }
    }

    private final void testAddressData(InetAddress target) throws Exception {
        harness.verbose("  testing address: " + target);
        String constructed = null;
        byte[] byteAddress = new byte[4];
        String name = target.getHostName();
        harness.verbose("  => host name: " + name);
        String address = target.getHostAddress();
        harness.verbose("  => host address : " + address);
        byteAddress = target.getAddress();
        harness.verbose("  => host address (in bytes): " + byteAddress.toString());
        if (byteAddress.length == 4) {
            constructed = "" + this.toUnsigned(byteAddress[0]) + '.' + this.toUnsigned(byteAddress[1]) + '.' + this.toUnsigned(byteAddress[2]) + '.' + this.toUnsigned(byteAddress[3]);
            harness.verbose("  => host address (getAddress()): " + constructed);
            harness.check(constructed, (Object)address);
        } else {
            harness.fail("Host adress must consist out of 4 bytes, consists out of " + byteAddress.length);
        }
        String fullname = target.toString();
        harness.verbose("  => InetAddress.toString() : " + fullname);
        harness.check(fullname, (Object)("" + target));
        harness.check(fullname, (Object)(name + '/' + address));
        InetAddress reverse = InetAddress.getByName(name);
        harness.check(reverse, target, "getByName(" + name + ')');
        reverse = InetAddress.getByName(address);
        harness.check(reverse, target, "getByName(" + address + "))");
    }

    private final int toUnsigned(byte b) {
        return b < 0 ? 256 + b : b;
    }

    private final void testHashCode() {
        try {
            InetAddress local = InetAddress.getLocalHost();
            harness.checkPoint("Testing HashCode : local to self");
            this.checkEquality(InetAddress.getLocalHost(), local, true);
            harness.checkPoint("Testing HashCode : addresses to self");
            this.checkEquality(InetAddress.getByName("uil.be.acunia.com"), InetAddress.getByName("194.7.211.212"), true);
            this.checkEquality(InetAddress.getByName("hermeske"), InetAddress.getByName("librarian"), false);
            this.checkEquality(InetAddress.getByName("www.kuleuven.ac.be"), InetAddress.getByName("www.kul.be"), false);
            harness.checkPoint("Testing HashCode : local to definite other addresses");
            this.checkHashCodes(InetAddress.getByName("195.0.76.33"), local);
            this.checkHashCodes(InetAddress.getByName("wonka.acunia.com"), local);
            harness.checkPoint("Testing HashCode : definite different addresses");
            this.checkHashCodes(InetAddress.getByName("wonka.acunia.com"), InetAddress.getByName("www.kul.be"));
            this.checkHashCodes(InetAddress.getByName("wonka.acunia.com"), InetAddress.getByName("hermeske"));
            this.checkHashCodes(InetAddress.getByName("194.7.211.212"), InetAddress.getByName("195.0.76.33"));
        }
        catch (Exception e) {
            harness.fail(e.toString());
        }
    }

    private final void checkEquality(InetAddress target, InetAddress reference, boolean same_name) {
        harness.debug("     Comparing (" + target + ") and (" + reference + ')');
        harness.check(target, reference);
        harness.check(target.getHostAddress(), (Object)reference.getHostAddress());
        if (same_name) {
            harness.check(target.toString(), (Object)reference.toString());
        } else {
            harness.check(target.toString().equals(reference.toString()) ^ true, "different names must have different addresses (" + target.toString() + " <--> " + reference.toString() + ')');
        }
        harness.check(target.hashCode(), reference.hashCode(), "equal addresses must have equal hashcode");
    }

    private final void checkHashCodes(InetAddress target, InetAddress reference) {
        int targetcode = target.hashCode();
        int referencecode = reference.hashCode();
        harness.verbose("     Comparing (" + target + ") code: " + targetcode);
        harness.verbose("           and (" + reference + ") code: " + referencecode);
        if (target.equals(reference)) {
            harness.check(targetcode, referencecode, "equal addresses must have equal hashcode");
        }
        if (targetcode != referencecode) {
            harness.check(target.equals(reference) ^ true, "Different codes must come from different addresses");
        }
    }

    private final void testMulticastAddress() {
        try {
            harness.checkPoint("Testing multicast address");
            String should = "Class-C (224.0.0.0 to 139.225.225.225) must be Multicast Adress";
            String shouldnot = "Multicast Adress reserved for class-C (224.0.0.0 to 139.225.225.225)";
            harness.check(InetAddress.getByName("223.128.128.128").isMulticastAddress() ^ true, shouldnot);
            harness.check(InetAddress.getByName("224.000.000.000").isMulticastAddress(), should);
            harness.check(InetAddress.getByName("224.000.000.001").isMulticastAddress(), should);
            harness.check(InetAddress.getByName("230.128.128.128").isMulticastAddress(), should);
            harness.check(InetAddress.getByName("239.225.225.224").isMulticastAddress(), should);
            harness.check(InetAddress.getByName("239.225.225.225").isMulticastAddress(), should);
            harness.check(InetAddress.getByName("240.000.000.000").isMulticastAddress() ^ true, shouldnot);
            harness.check(InetAddress.getByName("247.128.128.128").isMulticastAddress() ^ true, shouldnot);
        }
        catch (Exception e) {
            harness.fail(e.toString());
        }
    }

    private final void getAllByName() {
        harness.checkPoint("Testing multiple Inet adresses for one name");
        this.checkMultipleNames("195.0.76.33", false);
        this.checkMultipleNames("hermeske", false);
        this.checkMultipleNames("224.0.0.4", false);
    }

    private final void checkMultipleNames(String target, boolean more_expected) {
        harness.checkPoint("Testing multiple Inet adresses for one name");
        try {
            InetAddress[] resolved = InetAddress.getAllByName(target);
            InetAddress first = InetAddress.getByName(target);
            harness.verbose("Found " + resolved.length + " addresses ");
            if (more_expected && resolved.length <= 1) {
                harness.fail("Expected multiple addresses on <" + target + "> not found");
            }
            int i = 0;
            while (i < resolved.length) {
                harness.verbose("address " + resolved[i]);
                harness.check(resolved[i], first);
                ++i;
            }
        }
        catch (Exception e) {
            harness.fail(e.toString());
        }
    }

    public void test_toString() {
        TestHarness th = harness;
        th.checkPoint("toString()java.lang.String");
        try {
            InetAddress laddr = InetAddress.getLocalHost();
            th.check(InetAddress.getLocalHost(), laddr, "checking -- cache -- 1");
            th.check(laddr.getHostName().equals(laddr.getHostAddress()) ^ true, "checking name was looked up for " + laddr);
            InetAddress local = InetAddress.getByName("127.0.0.1");
            th.check(InetAddress.getByName("127.0.0.1"), local, "checking -- cache -- 2");
            th.check(laddr.getHostName().equals(laddr.getHostAddress()) ^ true, "checking name was looked up for " + local);
            InetAddress laddr2 = InetAddress.getByName(laddr.getHostAddress());
            th.check(laddr2, laddr, "checking -- cache -- 3");
            th.check(laddr2.toString(), laddr.toString(), "checking -- names -- 1");
            InetAddress lib = InetAddress.getByName("195.0.76.33");
            byte[] bytes = lib.getAddress();
            bytes[0] = 127;
            th.check(lib.getHostAddress(), "195.0.76.33", "checking security -- 1");
            boolean bl = false;
            if (lib.getAddress() != bytes) {
                bl = true;
            }
            th.check(bl, "checking security -- 2");
            th.debug("hashCode of " + local + " = " + Integer.toHexString(local.hashCode()));
        }
        catch (Exception e) {
            th.fail("caught unwanted exception " + e);
            e.printStackTrace();
        }
    }

    public void test(TestHarness newharness) {
        harness = newharness;
        harness.setclass("java.net.InetAddress");
        this.testLocalhost();
        this.testLocalhostByName();
        this.testLoopbackByName();
        this.testRandomByName();
        this.testHashCode();
        this.testMulticastAddress();
        this.getAllByName();
        this.test_toString();
    }
}

