/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.math.BigDecimal;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AcuniaBigDecimalTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.math.BigDecimal");
        this.test_BigDecimal();
        this.test_abs();
        this.test_add();
        this.test_divide();
        this.test_max();
        this.test_min();
        this.test_movePointLeft();
        this.test_movePointRight();
        this.test_multiply();
        this.test_negate();
        this.test_signum();
        this.test_subtract();
        this.test_equals();
        this.test_compareTo();
        this.test_doubleValue();
        this.test_floatValue();
        this.test_intValue();
        this.test_longValue();
        this.test_toBigInteger();
        this.test_valueOf();
        this.test_scale();
        this.test_setScale();
        this.test_hashCode();
        this.test_toString();
    }

    public void test_BigDecimal() {
        this.th.check(0, 0, "checking class constant ROUND_UP");
        this.th.check(1, 1, "checking class constant ROUND_DOWN");
        this.th.check(2, 2, "checking class constant ROUND_CEILING");
        this.th.check(3, 3, "checking class constant ROUND_FLOOR");
        this.th.check(4, 4, "checking class constant ROUND_HALF_UP");
        this.th.check(5, 5, "checking class constant ROUND_HALF_DOWN");
        this.th.check(6, 6, "checking class constant ROUND_HALF_EVEN");
        this.th.check(7, 7, "checking class constant ROUND_UNNECESSARY");
        this.th.checkPoint("BigDecimal(java.math.BigInteger)");
        this.checkCreateBigDecimal("1", -1);
        this.checkCreateBigDecimal("123456", -1);
        this.checkCreateBigDecimal("-1", -1);
        this.checkCreateBigDecimal("123345565434", -1);
        this.checkCreateBigDecimal("198574562452467548659846522481940205802587206725082759257234078507408715308141071047814017401", -1);
        this.th.checkPoint("BigDecimal(java.math.BigInteger,int)");
        this.checkCreateBigDecimal(0, "1");
        this.checkCreateBigDecimal(3, "123456");
        this.checkCreateBigDecimal(3, "-1234");
        this.checkCreateBigDecimal(8, "11355666788789879865");
        this.checkCreateBigDecimal(0, "123456");
        this.checkCreateBigDecimal(3, "-12388568576546764764785858578547857854");
        this.th.checkPoint("BigDecimal(java.lang.String)");
        this.th.check(new BigDecimal(".123").toString(), "0.123", "constructing '.123'");
        this.th.check(new BigDecimal(".0").toString(), "0.0", "constructing '.0'");
        this.checkCreateBigDecimal("1", 0);
        this.checkCreateBigDecimal("1234.56", 2);
        this.checkCreateBigDecimal("-1.23", 2);
        this.checkCreateBigDecimal("123345565434", 0);
        this.checkCreateBigDecimal("-123345565434", 0);
        this.checkCreateBigDecimal("198574562452467548659846522481940205.802587206725082759257234078507", 30);
        try {
            new BigDecimal(" 123.456");
            this.th.fail("should throw a NumberFormatException -- 1");
        }
        catch (NumberFormatException nfe) {
            this.th.check(true);
        }
        try {
            new BigDecimal("123.456 ");
            this.th.fail("should throw a NumberFormatException -- 2");
        }
        catch (NumberFormatException nfe) {
            this.th.check(true);
        }
        try {
            new BigDecimal(".");
            this.th.fail("should throw a NumberFormatException -- 3");
        }
        catch (NumberFormatException nfe) {
            this.th.check(true);
        }
        this.th.checkPoint("BigDecimal(double)");
        this.checkCreateBigDecimal(1.0, false);
        this.checkCreateBigDecimal(1.25E308, false);
        this.checkCreateBigDecimal(1.23456E123, false);
        this.checkCreateBigDecimal(1.234567891123456, true);
        this.checkCreateBigDecimal(999999.5, true);
        this.checkCreateBigDecimal(12345.0, false);
        this.checkCreateBigDecimal(1.2334545E234, false);
        this.checkCreateBigDecimal(4.5E-122, false);
        this.checkCreateBigDecimal(5.0E-287, false);
        this.checkCreateBigDecimal(3.0E-308, false);
        try {
            new BigDecimal(Double.NaN);
            this.th.fail("should throw a NumberFormatException -- 1");
        }
        catch (NumberFormatException nfe) {
            this.th.check(true);
        }
        try {
            new BigDecimal(Double.POSITIVE_INFINITY);
            this.th.fail("should throw a NumberFormatException -- 2");
        }
        catch (NumberFormatException nfe) {
            this.th.check(true);
        }
        try {
            new BigDecimal(Double.NEGATIVE_INFINITY);
            this.th.fail("should throw a NumberFormatException -- 3");
        }
        catch (NumberFormatException nfe) {
            this.th.check(true);
        }
    }

    private final void checkCreateBigDecimal(String value, int scale) {
        if (scale < 0) {
            BigDecimal bd = new BigDecimal(new BigInteger(value));
            this.th.check(bd.toString(), value, "constructing BigDecimal with a BigInteger '" + value + '\'');
            this.th.check(bd.scale(), 0, "checking scale BigDecimal('" + value + "')");
        } else {
            BigDecimal bd = new BigDecimal(value);
            this.th.check(bd.toString(), value, "constructing BigDecimal with a String '" + value + '\'');
            this.th.check(bd.scale(), scale, "checking scale BigDecimal('" + value + "')");
        }
    }

    private final void checkCreateBigDecimal(double value, boolean checkString) {
        BigDecimal bd = new BigDecimal(value);
        if (checkString) {
            this.th.check(bd.toString(), String.valueOf(value), "checking constructor BigDecimal(double " + value + ") -- toString");
        }
        this.th.check(bd.doubleValue(), value, "checking constructor BigDecimal(double " + value + ") -- doubleValue");
        value = -value;
        bd = new BigDecimal(value);
        if (checkString) {
            this.th.check(bd.toString(), String.valueOf(value), "checking constructor BigDecimal(double " + value + ") -- toString");
        }
        this.th.check(bd.doubleValue(), value, "checking constructor BigDecimal(double " + value + ") -- doubleValue");
    }

    private final void checkCreateBigDecimal(int scale, String value) {
        BigDecimal bd = new BigDecimal(new BigInteger(value), scale);
        if (scale != 0) {
            int dot = value.length() - scale;
            value = value.substring(0, dot) + '.' + value.substring(dot);
        }
        this.th.check(bd.toString(), value, "constructing BigDecimal with a BigInteger '" + value + "' and scale " + scale);
        this.th.check(bd.scale(), scale, "checking scale BigDecimal('" + value + "')");
    }

    public void test_abs() {
        this.th.checkPoint("abs()java.math.BigDecimal");
        BigDecimal bd = new BigDecimal("0");
        this.th.check(bd.abs(), bd);
        bd = new BigDecimal("0.00008");
        this.th.check(bd.abs(), bd);
        this.th.check(bd.negate().abs(), bd);
        bd = new BigDecimal("676465534.5578678967345");
        this.th.check(bd.abs(), bd);
        this.th.check(bd.negate().abs(), bd);
        bd = new BigDecimal("676465534989900788768767687678676678768756865754");
        this.th.check(bd.abs(), bd);
        this.th.check(bd.negate().abs(), bd);
    }

    public void test_add() {
        this.th.checkPoint("add(java.math.BigDecimal)java.math.BigDecimal");
        this.checkAdd(4.5, 3);
        this.checkAdd(1234.5, 3.5);
        this.checkAdd(0.005, 123.5);
        this.checkAdd(1234567.0, 3.5);
        this.checkAdd(1234.5, 35.125);
        BigDecimal bda = new BigDecimal("987654321.123456789");
        BigDecimal bdb = new BigDecimal("-54321.12345");
        this.th.check(bda.add(bdb).toString(), "987600000.000006789", "check add large -- 1");
        bda = new BigDecimal("987654321123456789987654321");
        bdb = new BigDecimal("0.00000123456789");
        this.th.check(bda.add(bdb).toString(), "987654321123456789987654321.00000123456789", "check add large -- 2");
        bda = new BigDecimal("-987654321.123456789");
        bdb = new BigDecimal("54321.12345");
        this.th.check(bda.add(bdb).toString(), "-987600000.000006789", "check add large -- 3");
    }

    public void checkAdd(double a, double b) {
        BigDecimal bda = new BigDecimal("" + a);
        BigDecimal bdb = new BigDecimal("" + b);
        this.th.check(bda.add(bdb).toString(), "" + (a + b), "check add " + a + " '+' " + b);
        this.th.check(bda.negate().add(bdb).toString(), "" + (-a + b), "check add " + -a + " '+' " + b);
        this.th.check(bda.negate().add(bdb.negate()).toString(), "" + (-a - b), "check add " + -a + " '+' " + -b);
        this.th.check(bda.add(bdb.negate()).toString(), "" + (a - b), "check add " + a + " '+' " + -b);
        this.th.check(bdb.add(bda).toString(), "" + (b + a), "check add " + b + " '+' " + a);
        this.th.check(bdb.negate().add(bda).toString(), "" + (-b + a), "check add " + -b + " '+' " + a);
        this.th.check(bdb.negate().add(bda.negate()).toString(), "" + (-b - a), "check add " + -b + " '+' " + -a);
        this.th.check(bdb.add(bda.negate()).toString(), "" + (b - a), "check add " + b + " '+' " + -a);
    }

    public void test_divide() {
        this.th.checkPoint("divide(java.math.BigDecimal,int)java.math.BigDecimal");
        this.checkdivide(123.5, 1.0, -1, 7);
        this.checkdivide(123.5, 10.0, -1, 1);
        this.checkdivide(12345.5, 12345.5, -1, 1);
        this.checkdivide(12.5, 1.5, -1, 1);
        this.checkdivide(12345.0, 123456.0, -1, 1);
        this.checkdivide(12.0, 36.0, -1, 0);
        this.checkdivide(12345.5, 1.5E8, -1, 0);
        BigDecimal bd = new BigDecimal("123456.789");
        try {
            bd.divide(bd, -1);
            this.th.fail("should throw an IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            bd.divide(bd, 8);
            this.th.fail("should throw an IllegalArgumentException -- 2");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            bd.divide(new BigDecimal(0.0), 1);
            this.th.fail("should throw an ArithmeticException -- 1");
        }
        catch (ArithmeticException ae) {
            this.th.check(true);
        }
        try {
            bd.divide(new BigDecimal(1.23E12), 7);
            this.th.fail("should throw an ArithmeticException -- 2");
        }
        catch (ArithmeticException ae) {
            this.th.check(true);
        }
        this.th.checkPoint("divide(java.math.BigDecimal,int,int)java.math.BigDecimal");
        try {
            bd.divide(bd, 0, -1);
            this.th.fail("should throw an IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            bd.divide(bd, 1, 8);
            this.th.fail("should throw an IllegalArgumentException -- 2");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            bd.divide(new BigDecimal(0.0), 2, 1);
            this.th.fail("should throw an ArithmeticException -- 1");
        }
        catch (ArithmeticException ae) {
            this.th.check(true);
        }
        try {
            bd.divide(new BigDecimal(1.23E12), 3, 7);
            this.th.fail("should throw an ArithmeticException -- 2");
        }
        catch (ArithmeticException ae) {
            this.th.check(true);
        }
        try {
            bd.divide(bd, -1, 4);
            this.th.fail("should throw an ArithmeticException -- 3");
        }
        catch (ArithmeticException iae) {
            this.th.check(true);
        }
        this.checkdivide(123.5, 1.0, 7, 7);
        this.checkdivide(123.5, 10.0, 1, 1);
        this.checkdivide(12345.5, 12345.5, 5, 1);
        this.checkdivide(12.5, 1.5, -1, 1);
        this.checkdivide(12345.0, 123456.0, 0, 1);
        this.checkdivide(12.0, 36.0, 10, 0);
        this.checkdivide(4.5, 1.0, 0, 4);
        this.checkdivide(4.5, 1.0, 0, 5);
        this.checkdivide(4.5, 1.0, 0, 6);
        this.checkdivide(5.5, 1.0, 0, 6);
        this.checkdivide(123.1, 123.0, 0, 3);
        this.checkdivide(123.1, 123.0, 0, 2);
        this.checkdivide(0.5, 1.0, 1, 3);
        this.checkdivide(0.5, 1.0, 1, 2);
    }

    public void checkdivide(double a, double b, int scale, int mode) {
        BigDecimal bdA = new BigDecimal(a);
        BigDecimal bdB = new BigDecimal(b);
        BigDecimal expected = new BigDecimal(a / b);
        if (scale < 0) {
            scale = bdA.scale();
            this.th.check(bdA.divide(bdB, mode), expected.setScale(scale, mode), "dividing " + a + " / " + b);
            this.th.check(bdA.divide(bdB.negate(), mode), expected.negate().setScale(scale, mode), "dividing " + a + " / -" + b);
            this.th.check(bdA.negate().divide(bdB.negate(), mode), expected.setScale(scale, mode), "dividing " + a + " / " + b);
            this.th.check(bdA.negate().divide(bdB, mode), expected.negate().setScale(scale, mode), "dividing " + a + " / -" + b);
        } else {
            this.th.check(bdA.divide(bdB, scale, mode), expected.setScale(scale, mode), "dividing " + a + " / " + b);
            this.th.check(bdA.divide(bdB.negate(), scale, mode), expected.negate().setScale(scale, mode), "dividing " + a + " / -" + b);
            this.th.check(bdA.negate().divide(bdB.negate(), scale, mode), expected.setScale(scale, mode), "dividing " + a + " / " + b);
            this.th.check(bdA.negate().divide(bdB, scale, mode), expected.negate().setScale(scale, mode), "dividing " + a + " / -" + b);
        }
    }

    public void test_max() {
        this.th.checkPoint("max(java.math.BigDecimal)java.math.BigDecimal");
        BigDecimal bd = new BigDecimal("12345");
        BigDecimal val = new BigDecimal("12345");
        boolean bl = false;
        if (bd.max(val) == val) {
            bl = true;
        }
        this.th.check(bl, "checking max -- 1");
        val = new BigDecimal("12345.5");
        boolean bl2 = false;
        if (bd.max(val) == val) {
            bl2 = true;
        }
        this.th.check(bl2, "checking max -- 2");
        val = new BigDecimal("12344.5");
        boolean bl3 = false;
        if (bd.max(val) == bd) {
            bl3 = true;
        }
        this.th.check(bl3, "checking max -- 3");
    }

    public void test_min() {
        this.th.checkPoint("min(java.math.BigDecimal)java.math.BigDecimal");
        BigDecimal bd = new BigDecimal("12345");
        BigDecimal val = new BigDecimal("12345");
        boolean bl = false;
        if (bd.min(val) == val) {
            bl = true;
        }
        this.th.check(bl, "checking min -- 1");
        val = new BigDecimal("12345.5");
        boolean bl2 = false;
        if (bd.min(val) == bd) {
            bl2 = true;
        }
        this.th.check(bl2, "checking min -- 2");
        val = new BigDecimal("12344.5");
        boolean bl3 = false;
        if (bd.min(val) == val) {
            bl3 = true;
        }
        this.th.check(bl3, "checking min -- 3");
    }

    public void test_movePointLeft() {
        this.th.checkPoint("movePointLeft(int)java.math.BigDecimal");
        this.checkMoveLeft("12345", 2, "123.45");
        this.checkMoveLeft("12345", 0, "12345");
        this.checkMoveLeft("123.45", 2, "1.2345");
        this.checkMoveLeft("12345", 10, "0.0000012345");
        this.checkMoveLeft("1.2345", -2, "123.45");
        this.checkMoveLeft("123.45", 0, "123.45");
        this.checkMoveLeft("123.45", -3, "123450");
    }

    public void checkMoveLeft(String val, int n, String moved) {
        this.th.check(new BigDecimal(val).movePointLeft(n).toString(), moved, "moving in '" + val + "' point " + n + " places to the Left");
        this.th.check(new BigDecimal("-" + val).movePointLeft(n).toString(), "-" + moved, "moving in '-" + val + "' point " + n + " places to the Left");
    }

    public void test_movePointRight() {
        this.th.checkPoint("movePointRight(int)java.math.BigDecimal");
        this.checkMoveRight("123.45", 2, "12345");
        this.checkMoveRight("12345", 0, "12345");
        this.checkMoveRight("1.2345", 2, "123.45");
        this.checkMoveRight("1.2345", 10, "12345000000");
        this.checkMoveRight("123.45", -2, "1.2345");
        this.checkMoveRight("123.45", 0, "123.45");
        this.checkMoveRight("123.45", -3, "0.12345");
    }

    public void checkMoveRight(String val, int n, String moved) {
        this.th.check(new BigDecimal(val).movePointRight(n).toString(), moved, "moving in '" + val + "' point " + n + " places to the Right");
        this.th.check(new BigDecimal("-" + val).movePointRight(n).toString(), "-" + moved, "moving in '-" + val + "' point " + n + " places to the Right");
    }

    public void test_multiply() {
        this.th.checkPoint("multiply(java.math.BigInteger)java.math.BigInteger");
        this.checkMultiply(1L, 0, 12L, 0);
        this.checkMultiply(0L, 0, 12L, 0);
        this.checkMultiply(123456L, 0, 129754323L, 0);
        this.checkMultiply(11233L, 0, 1290882367L, 7);
        this.checkMultiply(114323343L, 6, 1290882367L, 9);
        this.checkMultiply(51233L, 2, 1290882231367L, 30);
        this.checkMultiply(31233L, 9, 1290882367433L, 30);
        this.checkMultiply(11233L, 0, 1290882367000L, 3);
    }

    public void checkMultiply(long a, int scaleA, long b, int scaleB) {
        BigDecimal bdA = BigDecimal.valueOf(a, scaleA);
        BigDecimal bdB = BigDecimal.valueOf(b, scaleB);
        BigDecimal result = BigDecimal.valueOf(a * b, scaleB + scaleA);
        this.th.check(bdA.multiply(bdB), result, "multiplying " + a + " * " + b);
        this.th.check(bdA.multiply(bdB.negate()), result.negate(), "multiplying " + a + " * -" + b);
        this.th.check(bdB.multiply(bdA.negate()), result.negate(), "multiplying " + b + " * -" + a);
        this.th.check(bdB.negate().multiply(bdA.negate()), result, "multiplying -" + b + " * -" + a);
    }

    public void test_negate() {
        this.th.checkPoint("negate()java.math.BigDecimal");
        BigDecimal bd = new BigDecimal("0");
        bd = new BigDecimal("12234.454567");
        this.th.check(bd.negate().toString(), "-12234.454567", "negating '12234.454567'");
        bd = new BigDecimal("-0.000454567");
        this.th.check(bd.negate().toString(), "0.000454567", "negating '-0.000454567'");
    }

    public void test_signum() {
        this.th.checkPoint("signum()int");
        BigDecimal bd = new BigDecimal("0");
        this.th.check(bd.signum(), 0);
        bd = new BigDecimal("0.00000");
        this.th.check(bd.signum(), 0);
        bd = new BigDecimal(".0");
        this.th.check(bd.signum(), 0);
        bd = new BigDecimal("122343");
        this.th.check(bd.signum(), 1);
        bd = new BigDecimal("-123.455");
        this.th.check(bd.signum(), -1);
    }

    public void test_subtract() {
        this.th.checkPoint("subtract(java.math.BigDecimal)java.math.BigDecimal");
        this.checkSubtract(4.5, 3);
        this.checkSubtract(1234.5, 3.5);
        this.checkSubtract(0.005, 123.5);
        this.checkSubtract(1234567.0, 3.5);
        this.checkSubtract(1234.5, 35.125);
        BigDecimal bda = new BigDecimal("987654321.123456789");
        BigDecimal bdb = new BigDecimal("54321.12345");
        this.th.check(bda.subtract(bdb).toString(), "987600000.000006789", "check subtract large -- 1");
        bda = new BigDecimal("987654321123456789987654321");
        bdb = new BigDecimal("-0.00000123456789");
        this.th.check(bda.subtract(bdb).toString(), "987654321123456789987654321.00000123456789", "check subtract large -- 2");
        bda = new BigDecimal("-987654321.123456789");
        bdb = new BigDecimal("-54321.12345");
        this.th.check(bda.subtract(bdb).toString(), "-987600000.000006789", "check subtract large -- 3");
    }

    public void checkSubtract(double a, double b) {
        BigDecimal bda = new BigDecimal("" + a);
        BigDecimal bdb = new BigDecimal("" + b);
        this.th.check(bda.subtract(bdb).toString(), "" + (a - b), "check subtract " + a + " '-' " + b);
        this.th.check(bda.negate().subtract(bdb).toString(), "" + (-a - b), "check subtract " + -a + " '-' " + b);
        this.th.check(bda.negate().subtract(bdb.negate()).toString(), "" + (-a + b), "check subtract " + -a + " '-' " + -b);
        this.th.check(bda.subtract(bdb.negate()).toString(), "" + (a + b), "check subtract " + a + " '-' " + -b);
        this.th.check(bdb.subtract(bda).toString(), "" + (b - a), "check subtract " + b + " '-' " + a);
        this.th.check(bdb.negate().subtract(bda).toString(), "" + (-b - a), "check subtract " + -b + " '-' " + a);
        this.th.check(bdb.negate().subtract(bda.negate()).toString(), "" + (-b + a), "check subtract " + -b + " '-' " + -a);
        this.th.check(bdb.subtract(bda.negate()).toString(), "" + (b + a), "check subtract " + b + " '-' " + -a);
    }

    public void test_equals() {
        this.th.checkPoint("equals(java.lang.Object)boolean");
        BigDecimal bd = new BigDecimal("123456789.00");
        this.th.check(bd.equals(null) ^ true, "checking equals -- 'null'");
        this.th.check(bd.equals("123456789.00") ^ true, "checking equals -- 'string'");
        this.th.check(bd.equals(new BigDecimal("123456789.00")), "checking equals -- 'true'");
        this.th.check(bd.equals(bd), "checking equals -- 'itself'");
        this.th.check(bd.equals(new BigDecimal("123456789.0")) ^ true, "checking equals -- 'same value diff precision 1'");
        this.th.check(bd.equals(new BigDecimal("123456789.000")) ^ true, "checking equals -- 'same value diff precision 2'");
    }

    public void test_compareTo() {
        this.th.checkPoint("compareTo(java.lang.Object)int");
        BigDecimal bd = new BigDecimal("123456789.00");
        try {
            bd.compareTo(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        try {
            bd.compareTo("abcd");
            this.th.fail("should throw a ClassCastException");
        }
        catch (ClassCastException npe) {
            this.th.check(true);
        }
        BigDecimal o = bd;
        this.th.check(bd.compareTo((Object)o), 0, "comparingTo itself");
        this.th.checkPoint("compareTo(java.math.BigDecimal)int");
        this.th.check(bd.compareTo(new BigDecimal("123456789.0")), 0, "same value -- 1");
        this.th.check(bd.compareTo(new BigDecimal("123456789.000")), 0, "same value -- 2");
        this.th.check(bd.compareTo(new BigDecimal("123456788.98")), 1, "value -- 1");
        this.th.check(bd.compareTo(new BigDecimal("123456789.001")), -1, "value -- 2");
        BigDecimal zero = new BigDecimal("0");
        this.th.check(bd.compareTo(zero), 1, "value -- 3");
        this.th.check(bd.negate().compareTo(zero), -1, "value -- 4");
        this.th.check(zero.compareTo(bd), -1, "value -- 5");
        this.th.check(zero.compareTo(bd.negate()), 1, "value -- 6");
        BigDecimal ten = new BigDecimal("10");
        bd = new BigDecimal("9.8765432211123456");
        this.th.check(bd.compareTo(ten), -1, "value -- 7");
        this.th.check(bd.negate().compareTo(ten), -1, "value -- 8");
        bd = new BigDecimal("10.8765432211123456");
        this.th.check(bd.compareTo(ten), 1, "value -- 9");
        this.th.check(bd.negate().compareTo(ten), -1, "value -- 10");
    }

    public void test_doubleValue() {
        this.th.checkPoint("doubleValue()double");
        this.check_doubleValue("4");
        this.check_doubleValue("40");
        this.check_doubleValue("400");
        this.check_doubleValue("412");
        this.check_doubleValue("4345");
        this.check_doubleValue("98765432198765433");
        this.check_doubleValue("9876543219876543000111000", 9.876543219876543E24);
        this.check_doubleValue("129876543219876543000111000", 1.2987654321987654E26);
        BigDecimal tobig = new BigDecimal(new BigInteger("10").pow(309));
        this.th.check(tobig.doubleValue(), Double.POSITIVE_INFINITY, "checking large numbers");
        this.th.check(tobig.negate().doubleValue(), Double.NEGATIVE_INFINITY, "checking large numbers");
        this.th.check(new BigDecimal(BigInteger.ONE, 340).doubleValue(), 0.0, "checking to small number");
        this.th.check(new BigDecimal(BigInteger.ONE, 250).doubleValue(), 1.0E-250, "checking small number");
    }

    private final void check_doubleValue(String value) {
        this.th.check(new BigDecimal(value).doubleValue(), Double.parseDouble(value), "checking parseDouble of '" + value + '\'');
        value = "-" + value;
        this.th.check(new BigDecimal(value).doubleValue(), Double.parseDouble(value), "checking parseDouble of '" + value + '\'');
    }

    private final void check_doubleValue(String value, double result) {
        this.th.check(new BigDecimal(value).doubleValue(), result, "checking parseDouble of '" + value + '\'');
        value = "-" + value;
        this.th.check(new BigDecimal(value).doubleValue(), -result, "checking parseDouble of '" + value + '\'');
    }

    public void test_floatValue() {
        this.th.checkPoint("floatValue()float");
        this.check_floatValue("4");
        this.check_floatValue("40");
        this.check_floatValue("400");
        this.check_floatValue("412");
        this.check_floatValue("4345");
        this.check_floatValue("98765432198765433");
        this.check_floatValue("9876543219876543000111000", 9.876544E24f);
        this.check_floatValue("129876543219876543000111000", 1.2987654E26f);
        BigDecimal tobig = new BigDecimal(new BigInteger("10").pow(309));
        this.th.check(tobig.floatValue(), Double.POSITIVE_INFINITY, "checking large numbers");
        this.th.check(tobig.negate().floatValue(), Double.NEGATIVE_INFINITY, "checking large numbers");
        this.th.check(new BigDecimal(BigInteger.ONE, 340).floatValue(), 0.0, "checking to small number");
        this.th.check(new BigDecimal(BigInteger.ONE, 40).floatValue(), 1.0E-40f, "checking small number");
    }

    private final void check_floatValue(String value) {
        this.th.check(new BigDecimal(value).floatValue(), Float.parseFloat(value), "checking parseFloat of '" + value + '\'');
        value = "-" + value;
        this.th.check(new BigDecimal(value).floatValue(), Float.parseFloat(value), "checking parseFloat of '" + value + '\'');
    }

    private final void check_floatValue(String value, float result) {
        this.th.check(new BigDecimal(value).floatValue(), result, "checking parseFloat of '" + value + '\'');
        value = "-" + value;
        this.th.check(new BigDecimal(value).floatValue(), -result, "checking parseFloat of '" + value + '\'');
    }

    public void test_intValue() {
        this.th.checkPoint("intValue()int");
        this.th.check(new BigDecimal("123.456789").intValue(), 123, "checking to intValue -- 1");
        this.th.check(new BigDecimal("-123.456789").intValue(), -123, "checking to intValue -- 2");
        this.th.check(new BigDecimal(".456789").intValue(), 0, "checking to intValue -- 3");
        this.th.check(new BigDecimal("12345678998765432.456789").intValue(), 1664843640, "checking to intValue -- 4");
        this.th.check(new BigDecimal("1234567899876543").intValue(), 1025477823, "checking to intValue -- 5");
        this.th.check(new BigDecimal("1.99999999999").intValue(), 1, "checking to intValue -- 6");
        this.th.check(new BigDecimal("-12345678998765432.456789").intValue(), -1664843640, "checking to intValue -- 7");
        this.th.check(new BigDecimal("-1.99999999999").intValue(), -1, "checking to intValue -- 8");
        this.th.check(new BigDecimal("456789").intValue(), 456789, "checking to intValue -- 9");
        this.th.check(new BigDecimal("-19999").intValue(), -19999, "checking to intValue -- 10");
        this.th.check(new BigDecimal("123456789987654324567899787892374823478234798").intValue(), -1556607314, "checking to intValue -- 11");
        this.th.check(new BigDecimal("-123456789987654324567899787892374823478234798").intValue(), 1556607314, "checking to intValue -- 12");
    }

    public void test_longValue() {
        this.th.checkPoint("longValue()long");
        this.th.check(new BigDecimal("12334.456789").longValue(), 12334L, "checking to longValue -- 1");
        this.th.check(new BigDecimal("-12334.456789").longValue(), -12334L, "checking to longValue -- 2");
        this.th.check(new BigDecimal(".456789").longValue(), 0L, "checking to longValue -- 3");
        this.th.check(new BigDecimal("12345678998765432.456789").longValue(), 12345678998765432L, "checking to longValue -- 4");
        this.th.check(new BigDecimal("1234567899876543").longValue(), 1234567899876543L, "checking to longValue -- 5");
        this.th.check(new BigDecimal("1.99999999999").longValue(), 1L, "checking to longValue -- 6");
        this.th.check(new BigDecimal("-12345678998765432.456789").longValue(), -12345678998765432L, "checking to longValue -- 7");
        this.th.check(new BigDecimal("-1.99999999999").longValue(), (long)-1, "checking to longValue -- 8");
        this.th.check(new BigDecimal("456789").longValue(), 456789L, "checking to longValue -- 9");
        this.th.check(new BigDecimal("-19999").longValue(), -19999L, "checking to longValue -- 10");
        this.th.check(new BigDecimal("123456789987654324567899787892374823478234798").longValue(), -9020399958540939602L, "checking to longValue -- 11");
        this.th.check(new BigDecimal("-123456789987654324567899787892374823478234798").longValue(), 9020399958540939602L, "checking to longValue -- 12");
    }

    public void test_toBigInteger() {
        this.th.checkPoint("toBigInteger()java.math.BigInteger");
        this.th.check(new BigDecimal("12334.456789").toBigInteger(), new BigInteger("12334"), "checking to toBigInteger -- 1");
        this.th.check(new BigDecimal("-12334.456789").toBigInteger(), new BigInteger("-12334"), "checking to toBigInteger -- 2");
        this.th.check(new BigDecimal(".456789").toBigInteger(), new BigInteger("0"), "checking to toBigInteger -- 3");
        this.th.check(new BigDecimal("12345678998765432.456789").toBigInteger(), new BigInteger("12345678998765432"), "checking to toBigInteger -- 4");
        this.th.check(new BigDecimal("1234567899876543").toBigInteger(), new BigInteger("1234567899876543"), "checking to toBigInteger -- 5");
        this.th.check(new BigDecimal("1.99999999999").toBigInteger(), new BigInteger("1"), "checking to toBigInteger -- 6");
        this.th.check(new BigDecimal("-12345678998765432.456789").toBigInteger(), new BigInteger("-12345678998765432"), "checking to toBigInteger -- 7");
        this.th.check(new BigDecimal("-1.99999999999").toBigInteger(), new BigInteger("-1"), "checking to toBigInteger -- 8");
        this.th.check(new BigDecimal("456789").toBigInteger(), new BigInteger("456789"), "checking to toBigInteger -- 9");
        this.th.check(new BigDecimal("-19999").toBigInteger(), new BigInteger("-19999"), "checking to toBigInteger -- 10");
        this.th.check(new BigDecimal("123456789987654324567899787892374823478234798").toBigInteger(), new BigInteger("123456789987654324567899787892374823478234798"), "checking to toBigInteger -- 11");
        this.th.check(new BigDecimal("-123456789987654324567899787892374823478234798").toBigInteger(), new BigInteger("-123456789987654324567899787892374823478234798"), "checking to toBigInteger -- 12");
    }

    public void test_valueOf() {
        this.th.checkPoint("valueOf(long)java.math.BigDecimal");
        this.checkValueOf(12345677898753445L, -1);
        this.checkValueOf(-12345677898753445L, -1);
        this.checkValueOf(123456778L, -1);
        this.checkValueOf(-12345677L, -1);
        this.th.checkPoint("valueOf(long,int)java.math.BigDecimal");
        this.checkValueOf(812345677898753445L, 10);
        this.checkValueOf(128345677898753445L, 0);
        this.checkValueOf(8128345677898753445L, 354);
        this.checkValueOf(-128345677898753445L, 1111223);
        this.checkValueOf(128345677898753445L, 11);
        try {
            BigDecimal.valueOf(12L, -1);
            this.th.fail("should throw a NumberFormatException");
        }
        catch (NumberFormatException nfe) {
            this.th.check(true);
        }
    }

    private final void checkValueOf(long value, int scale) {
        if (scale < 0) {
            BigDecimal bd = BigDecimal.valueOf(value);
            this.th.check(bd.toString(), "" + value, "valueOf '" + value + '\'');
            this.th.check(bd.scale(), 0, "checking scale BigDecimal('" + value + "')");
        } else {
            BigDecimal bd = BigDecimal.valueOf(value, scale);
            this.th.check(bd, new BigDecimal(new BigInteger("" + value), scale), "valueOf '" + value + "','" + scale + '\'');
            this.th.check(bd.scale(), scale, "checking scale BigDecimal('" + value + "')");
        }
    }

    public void test_scale() {
        this.th.checkPoint("scale()int");
        BigDecimal bd = new BigDecimal("123456789.1234567890");
        this.th.check(bd.scale(), 10, "checking scale -- 1");
        bd = new BigDecimal("1234567891234567890");
        this.th.check(bd.scale(), 0, "checking scale -- 2");
        bd = new BigDecimal(12.5);
        this.th.check(bd.scale(), 1, "checking scale -- 3");
        bd = new BigDecimal(12.0);
        this.th.check(bd.scale(), 0, "checking scale -- 4");
    }

    public void test_setScale() {
        this.th.checkPoint("setScale(int)java.math.BigDecimal");
        BigDecimal bd = new BigDecimal("12345");
        BigDecimal result = bd.setScale(3);
        this.th.check(result.toString(), "12345.000", "checking - value -- 1");
        this.th.check(result.scale(), 3, "checking - scale -- 1");
        result = result.setScale(0);
        this.th.check(result, bd, "checking - value -- 2");
        this.th.check(result.scale(), 0, "checking - scale -- 2");
        bd = new BigDecimal("-12345");
        result = bd.setScale(3);
        this.th.check(result.toString(), "-12345.000", "checking - value -- 3");
        this.th.check(result.scale(), 3, "checking - scale -- 3");
        try {
            bd.setScale(-1);
            this.th.fail("should throw an ArethimeticException -- 1");
        }
        catch (ArithmeticException ae) {
            this.th.check(true, "got exception :)");
        }
        bd = new BigDecimal("12.345");
        try {
            bd.setScale(1);
            this.th.fail("should throw an ArethimeticException -- 2");
        }
        catch (ArithmeticException ae) {
            this.th.check(true, "got exception :)");
        }
        this.th.checkPoint("setScale(int,int)java.math.BigDecimal");
        try {
            bd.setScale(1, 7);
            this.th.fail("should throw an ArethimeticException -- 1");
        }
        catch (ArithmeticException ae) {
            this.th.check(true, "got exception :)");
        }
        bd = new BigDecimal("12345");
        try {
            bd.setScale(-1, 7);
            this.th.fail("should throw an ArethimeticException -- 2");
        }
        catch (ArithmeticException ae) {
            this.th.check(true, "got exception :)");
        }
        bd = new BigDecimal("123.45");
        try {
            bd.setScale(1, -1);
            this.th.fail("should throw an IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException ae) {
            this.th.check(true, "got exception :)");
        }
        try {
            bd.setScale(1, 8);
            this.th.fail("should throw an IllegalArgumentException -- 2");
        }
        catch (IllegalArgumentException ae) {
            this.th.check(true, "got exception :)");
        }
        this.checkScaling("1234567890.1234567890", 10, false, false, false);
        this.checkScaling("1234567890.89234567890", 10, true, true, true);
        this.checkScaling("1234567890.1234567881", 1, false, false, false);
        this.checkScaling("1234567890.12345000", 4, true, false, false);
        this.checkScaling("1234567890.12355000", 4, true, true, false);
    }

    private final void checkScaling(String value, int diff, boolean rhUp, boolean rhEv, boolean rhDw) {
        BigDecimal bd = new BigDecimal(value);
        int scale = bd.scale();
        String result = value;
        int k = 0;
        while (k < diff) {
            result = result + '0';
            ++k;
        }
        int newScale = scale + diff;
        int mode = 0;
        while (mode <= 7) {
            BigDecimal scaled = bd.setScale(newScale, mode);
            this.th.check(scaled.toString(), result, "scaling '" + value + "' to scale " + newScale + " valueCheck");
            this.th.check(scaled.scale(), newScale, "scaling '" + value + "' to scale " + newScale + " scaleCheck");
            ++mode;
        }
        newScale = scale - diff;
        result = value.substring(0, value.length() - diff);
        if (result.endsWith(".")) {
            result = result.substring(0, result.length() - 1);
        }
        int last = result.length() - 1;
        char lastChar = (char)(result.charAt(last) + '\u0001');
        String upResult = result.substring(0, last) + lastChar;
        String[] results = new String[7];
        results[2] = bd.signum() == -1 ? result : upResult;
        results[1] = result;
        results[3] = bd.signum() == 1 ? result : upResult;
        results[5] = rhDw ? upResult : result;
        results[6] = rhEv ? upResult : result;
        results[4] = rhUp ? upResult : result;
        results[0] = upResult;
        int loop = 0;
        while (loop < 7) {
            BigDecimal scaled = bd.setScale(newScale, loop);
            this.th.check(scaled.toString(), results[loop], "scaling '" + value + "' to scale " + newScale + " valueCheck -- mode = " + loop);
            this.th.check(scaled.scale(), newScale, "scaling '" + value + "' to scale " + newScale + " scaleCheck -- mode = " + loop);
            ++loop;
        }
    }

    public void test_hashCode() {
        this.th.checkPoint("hashCode()int");
        BigDecimal bd = new BigDecimal("12345.678900");
        this.th.check(bd.hashCode(), new BigDecimal("12345.678900").hashCode(), "checking equality of hashCode -- 1");
        this.th.check(bd.hashCode(), bd.hashCode(), "checking equality of hashCode -- 2");
        boolean bl = false;
        if (bd.hashCode() != new BigDecimal("12345.67890").hashCode()) {
            bl = true;
        }
        this.th.check(bl, "difference of hashCode -- 1");
        boolean bl2 = false;
        if (bd.hashCode() != new BigDecimal("12345.6789000").hashCode()) {
            bl2 = true;
        }
        this.th.check(bl2, "difference of hashCode -- 2");
    }

    public void test_toString() {
        this.th.checkPoint("toString()java.lang.String");
        this.checkToString("123456.789");
        this.checkToString("121213456.768678765454675453212234356789");
        this.checkToString("123976961878947824578456.7084094809481048194089");
        this.checkToString("112345678987654321234567890987623456");
        this.checkToString("123498799878978978378738232848956.7808134901294710471371648091749104801481904819414141241231241389");
        this.checkToString("1234508809184019481938101111380923819308103809136.8095829082342305234324234432270390252352345235789");
    }

    private final void checkToString(String value) {
        this.th.check(new BigDecimal(value).toString(), value, "checking toString of '" + value + '\'');
    }
}

