/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.reflect.Method;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class SMMethodTest
implements Testlet {
    protected TestHarness th;
    protected Method[] mds;
    protected Method[] ms;
    static /* synthetic */ Class class$java$lang$Object;

    public void method1() throws ArrayIndexOutOfBoundsException {
    }

    private static final double method2(int i, long j, char[] ca, String s) {
        return 1.0;
    }

    protected synchronized Object method3(Object[] o) throws NullPointerException, Exception {
        return o;
    }

    private native void method4(String var1, byte var2);

    public String toString() {
        return "string";
    }

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.lang.reflect.Method");
        this.SetupMethods();
        this.test_invoke();
        this.test_getDeclaringClass();
        this.test_getExceptionTypes();
        this.test_getModifiers();
        this.test_getName();
        this.test_getParameterTypes();
        this.test_getReturnType();
        this.test_equals();
        this.test_hashCode();
        this.test_toString();
    }

    public final synchronized void SetupMethods() {
        try {
            int j;
            boolean b;
            int i;
            String[] s;
            Method[] hms = this.getClass().getMethods();
            Method[] hmds = this.getClass().getDeclaredMethods();
            int l = hmds.length;
            if (l != 19) {
                this.th.fail("this.getClass().getDeclaredMethods() returned " + l + " methods, expected 19");
            } else {
                this.mds = new Method[l];
                s = new String[l];
                s[0] = "method1";
                s[1] = "method2";
                s[2] = "method3";
                s[3] = "method4";
                s[4] = "toString";
                s[5] = "test";
                s[6] = "test_invoke";
                s[7] = "test_getDeclaringClass";
                s[8] = "test_getExceptionTypes";
                s[9] = "test_getModifiers";
                s[10] = "test_getName";
                s[11] = "test_getParameterTypes";
                s[12] = "test_getReturnType";
                s[13] = "test_hashCode";
                s[14] = "test_equals";
                s[15] = "test_toString";
                s[16] = "SetupMethods";
                s[17] = "hashCode";
                s[18] = "class$";
                for (i = 0; i < l; ++i) {
                    b = false;
                    for (j = 0; j < l; ++j) {
                        try {
                            if (!s[i].equals(hmds[j].getName())) continue;
                            b = true;
                            this.mds[i] = hmds[j];
                            continue;
                        }
                        catch (Exception e) {
                            this.th.fail("Sorting declared methods, i = " + i + ", j = " + j + ", comparing s[i] (" + s[i] + ") with " + hmds[j].getName() + " threw " + e);
                        }
                    }
                    if (b) continue;
                    this.th.debug("couldn't find " + s[i]);
                }
            }
            l = hms.length;
            if (l != 12) {
                this.th.fail("this.getClass().getMethods() returned " + l + " methods, expected 12");
            } else {
                s = new String[l];
                s[0] = "equals";
                s[1] = "getClass";
                s[2] = "hashCode";
                s[3] = "notify";
                s[4] = "notifyAll";
                s[5] = "toString";
                s[6] = "wait()";
                s[7] = "wait(long)";
                s[8] = "wait(long,int)";
                s[9] = "method1";
                s[10] = "test";
                s[11] = "SetupMethods";
                this.ms = new Method[l];
                for (i = 0; i < l; ++i) {
                    b = false;
                    for (j = 0; j < l; ++j) {
                        try {
                            if (hms[j].toString().lastIndexOf(s[i]) <= 0) continue;
                            b = true;
                            this.ms[i] = hms[j];
                            continue;
                        }
                        catch (Exception e) {
                            this.th.fail("Sorting public methods, i = " + i + ", j = " + j + ", comparing s[i] (" + s[i] + ") with hms[j].getName() threw " + e);
                        }
                    }
                    if (b) continue;
                    this.th.debug("couldn't find " + s[i]);
                }
            }
        }
        catch (Exception e) {
            this.th.fail("caught exception during setup, got:" + e);
        }
    }

    public int hashCode() {
        this.th.check(true);
        return -1;
    }

    protected void test_invoke() {
        Method m;
        this.th.checkPoint("invoke(java.lang.Object,java.lang.Object[])java.lang.Object");
        try {
            m = (class$java$lang$Object == null ? (class$java$lang$Object = SMMethodTest.class$("java.lang.Object")) : class$java$lang$Object).getMethod("hashCode", null);
            this.th.check(m.invoke((Object)this, new Object[0]), new Integer(-1));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.th.fail("caught unwanted exception " + e);
        }
        try {
            m = (class$java$lang$Object == null ? (class$java$lang$Object = SMMethodTest.class$("java.lang.Object")) : class$java$lang$Object).getMethod("hashCode", new Class[0]);
            this.th.check(m.invoke((Object)this, null), new Integer(-1));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.th.fail("caught unwanted exception " + e);
        }
        try {
            Class<?> list = Class.forName("java.util.List");
            Method add = list.getMethod("add", new Object().getClass());
            Vector<SMMethodTest> v = new Vector<SMMethodTest>();
            try {
                Boolean b = (Boolean)add.invoke(v, this);
                this.th.check(b, "checking return value -- 1");
                this.th.check(v.contains(this), "checking result -- 1");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.th.fail("caught unwanted exception " + e);
            }
            v.add(this);
            Class<?> alist = Class.forName("java.util.AbstractList");
            Method get = list.getMethod("get", Integer.TYPE);
            try {
                this.th.check(get.invoke(v, new Integer(0)), this, "checking return value -- 2");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.th.fail("caught unwanted exception " + e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.th.fail("caught unwanted exception " + e);
        }
    }

    protected void test_getDeclaringClass() {
        this.th.checkPoint("getDeclaringClass()java.lang.Class");
        this.th.check(this.mds[0].getDeclaringClass() == this.getClass(), "test -- 1");
        this.th.check(this.mds[1].getDeclaringClass() == this.getClass(), "test -- 2");
        this.th.check(this.mds[2].getDeclaringClass() == this.getClass(), "test -- 3");
        this.th.check(this.ms[10].getDeclaringClass() == this.getClass(), "test -- 4");
        this.th.check(this.ms[1].getDeclaringClass() == new Object().getClass(), "test -- 5, got:" + this.ms[1].getDeclaringClass() + "declared ??? :" + this.ms[1]);
        this.th.check(this.ms[4].getDeclaringClass() == new Object().getClass(), "test -- 6");
    }

    protected void test_getExceptionTypes() {
        this.th.checkPoint("getExceptionTypes()java.lang.Class[]");
        Class<?>[] hca = this.mds[1].getExceptionTypes();
        this.th.check(hca != null, "getExceptionTypes gives a non Null value");
        this.th.check(hca.length == 0, "No exceptions thrown by this method");
        hca = this.mds[2].getExceptionTypes();
        this.th.check(hca.length == 2, "2 exceptions thrown by this method");
        this.th.check(hca[0] == new NullPointerException().getClass(), "checking type -- 1, got" + hca[0]);
        this.th.check(hca[1] == new Exception().getClass(), "checking type -- 2, got" + hca[1]);
    }

    protected void test_getModifiers() {
        this.th.checkPoint("getModifiers()int");
        this.th.check(this.mds[0].getModifiers(), 1, "checking Modifiers -- 1");
        this.th.check(this.mds[1].getModifiers(), 26, "checking Modifiers -- 2");
        this.th.check(this.mds[2].getModifiers(), 36, "checking Modifiers -- 3");
        this.th.check(this.mds[3].getModifiers(), 258, "checking Modifiers -- 4");
        this.th.check(this.ms[11].getModifiers(), 49, "checking Modifiers -- 5, got:" + Modifier.toString(this.ms[0].getModifiers()) + " from method " + this.ms[0].getName());
        this.th.check(this.ms[1].getModifiers(), 273, "checking Modifiers -- 6");
        this.th.check(this.ms[2].getModifiers(), 1, "checking Modifiers -- 7");
    }

    protected void test_getName() {
        this.th.checkPoint("getName()java.lang.String");
        this.th.check(this.mds[0].getName().equals("method1"), "checking names -- 1");
        this.th.check(this.mds[1].getName().equals("method2"), "checking names -- 2");
        this.th.check(this.mds[2].getName().equals("method3"), "checking names -- 3");
        this.th.check(this.mds[3].getName().equals("method4"), "checking names -- 4");
        this.th.check(this.ms[0].getName().equals("equals"), "checking names -- 5");
        this.th.check(this.ms[1].getName().equals("getClass"), "checking names -- 6");
        this.th.check(this.ms[2].getName().equals("hashCode"), "checking names -- 7");
    }

    protected void test_getParameterTypes() {
        this.th.checkPoint("getParameterTypes()java.lang.Class[]");
        Class<?>[] hca = this.mds[0].getParameterTypes();
        this.th.check(hca != null, "getParameterTypes gives a non Null value");
        this.th.check(hca.length == 0, "No parameters taken by this method -- 1");
        hca = this.mds[1].getParameterTypes();
        this.th.check(hca.length == 4, " 4 parameters taken by this method -- 2");
        this.th.check(hca[0] == Integer.TYPE, "checking Class type -- 3, got:" + hca[0] + " from " + this.mds[1]);
        this.th.check(hca[1] == Long.TYPE, "checking Class type -- 4, got:" + hca[1] + " from " + this.mds[1]);
        this.th.check(hca[2], new char[1].getClass(), "checking Class type -- 5, got:" + hca[2] + " from " + this.mds[1]);
        this.th.debug("" + new char[1].getClass());
        this.th.debug("" + new char[2].getClass());
        this.th.debug("" + new char[3].getClass());
        this.th.debug("" + new char[4].getClass());
        this.th.debug("" + new char[5].getClass());
    }

    protected void test_getReturnType() {
        this.th.checkPoint("getReturnType()java.lang.Class");
        this.th.check(this.mds[0].getReturnType() == Void.TYPE, "checking Class type -- 1");
        this.th.check(this.mds[1].getReturnType() == Double.TYPE, "checking Class type -- 2");
        this.th.check(this.mds[2].getReturnType() == new Object().getClass(), "checking Class type -- 3");
        this.th.check(this.ms[0].getReturnType() == Boolean.TYPE, "checking Class type -- 4");
        this.th.check(this.ms[2].getReturnType() == Integer.TYPE, "checking Class type -- 5");
    }

    protected void test_hashCode() {
        this.th.checkPoint("hashCode()int");
        int j = this.mds[0].getName().hashCode();
        int h = this.mds[0].getDeclaringClass().getName().hashCode();
        j = h ^ j;
        h = this.mds[0].hashCode();
        this.th.check(h == j, "checking hashcode algorithm, got:" + h + ", but expected " + j);
    }

    protected void test_equals() {
        this.th.checkPoint("equals(java.lang.Object)boolean");
        Method[] hom = new Object().getClass().getMethods();
        int l = hom.length;
        Method[] om = new Method[2];
        String[] s = new String[l];
        s[0] = "toString";
        s[1] = "equals";
        boolean b = false;
        for (int i = 0; i < 2; ++i) {
            b = false;
            for (int j = 0; j < l; ++j) {
                if (!s[i].equals(hom[j].getName())) continue;
                b = true;
                om[i] = hom[j];
            }
            if (b) continue;
            this.th.debug("couldn't find " + s[i]);
        }
        this.th.check(!om[0].equals(this.mds[5]), "overwritten Methods are different");
        this.th.check(!this.mds[0].equals(this.mds[1]), "different Methods are different");
        this.th.check(this.ms[5].equals(this.ms[5]), "same Method is equal");
        this.th.check(om[1].equals(this.ms[0]), "inherited Methods are the same");
        try {
            this.mds[0].equals(null);
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw exceptions -- " + e);
        }
    }

    protected void test_toString() {
        this.th.checkPoint("toString()java.lang.String");
        this.th.check(this.mds[0].toString().equals("public void gnu.testlet.wonka.lang.reflect.Method.SMMethodTest.method1() throws java.lang.ArrayIndexOutOfBoundsException"));
        this.th.check(this.mds[1].toString().equals("private static final double gnu.testlet.wonka.lang.reflect.Method.SMMethodTest.method2(int,long,char[],java.lang.String)"), "got:" + this.mds[1]);
        this.th.check(this.mds[2].toString().equals("protected synchronized java.lang.Object gnu.testlet.wonka.lang.reflect.Method.SMMethodTest.method3(java.lang.Object[]) throws java.lang.NullPointerException,java.lang.Exception"), "got:" + this.mds[2]);
        this.th.check(this.mds[3].toString().equals("private native void gnu.testlet.wonka.lang.reflect.Method.SMMethodTest.method4(java.lang.String,byte)"));
        this.th.check(this.ms[0].toString(), (Object)"public native boolean java.lang.Object.equals(java.lang.Object)");
        this.th.check(this.mds[16].toString().equals("public final synchronized void gnu.testlet.wonka.lang.reflect.Method.SMMethodTest.SetupMethods()"), "got:" + this.mds[16]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

