/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.reflect.Constructor;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.lang.reflect.Constructor;

public class testNewInstance
implements Testlet {
    private static final String testPackageName = "gnu.testlet.wonka.lang.reflect.Constructor";
    private static final String testClassName = "NewInstanceClass";
    private String fullClassName = "gnu.testlet.wonka.lang.reflect.Constructor.NewInstanceClass";
    protected static TestHarness harness;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    private void testConstructorArray() {
        try {
            harness.checkPoint("Class forName");
            Class<?> c = Class.forName(this.fullClassName);
            if (c == null) {
                harness.fail("Class.forName(NewInstanceClass) returned null");
            } else {
                harness.check(c.getName(), (Object)"gnu.testlet.wonka.lang.reflect.Constructor.NewInstanceClass");
            }
            harness.checkPoint("Class.getConstructors");
            Constructor<?>[] constructorarray = c.getConstructors();
            if (constructorarray == null) {
                harness.fail("Class NewInstanceClassgetConstructors returned null");
            } else {
                harness.check(constructorarray.length, 5);
                for (int i = 0; i < constructorarray.length; ++i) {
                    harness.verbose(" Constructor <" + constructorarray[i].getName() + "> value : " + constructorarray[i].toString());
                    harness.check(constructorarray[i].getName(), (Object)this.fullClassName);
                }
            }
            harness.checkPoint("Class.getDeclaredConstructors");
            Constructor<?>[] declaredconstructorarray = c.getDeclaredConstructors();
            if (constructorarray == null) {
                harness.fail("Class NewInstanceClassgetConstructors returned null");
            } else {
                harness.check(declaredconstructorarray.length, 6);
                for (int i = 0; i < declaredconstructorarray.length; ++i) {
                    harness.verbose(" Constructor <" + declaredconstructorarray[i].getName() + "> value : " + declaredconstructorarray[i].toString());
                    harness.check(declaredconstructorarray[i].getName(), (Object)this.fullClassName);
                }
            }
        }
        catch (Exception e) {
            harness.fail(e.toString());
        }
    }

    private void testConstructorInstances() {
        harness.checkPoint("Testing constructor instances : default testclass(null)");
        harness.debug("Let's do some naughty stuff...");
        this.checkNewInstance(null, null, this.fullClassName + "()");
        Class[] params = new Class[]{};
        Object[] values = new Object[]{};
        harness.checkPoint("Testing constructor instances : default testclass()");
        this.checkNewInstance(params, values, this.fullClassName + "()");
        params = new Class[1];
        values = new Object[1];
        harness.checkPoint("Testing constructor instances : default testclass(String)");
        params[0] = class$java$lang$String == null ? (class$java$lang$String = testNewInstance.class$("java.lang.String")) : class$java$lang$String;
        values[0] = "abcde";
        this.checkNewInstance(params, values, this.fullClassName + "(Ljava.lang.String; abcde)");
        harness.checkPoint("Testing constructor instances : default testclass(int)");
        params[0] = Integer.TYPE;
        values[0] = new Integer(123);
        this.checkNewInstance(params, values, this.fullClassName + "(I 123)");
        harness.checkPoint("Testing constructor instances : default testclass(Integer)");
        params[0] = class$java$lang$Integer == null ? (class$java$lang$Integer = testNewInstance.class$("java.lang.Integer")) : class$java$lang$Integer;
        values[0] = new Integer(123);
        this.checkNewInstance(params, values, this.fullClassName + "(Ljava.lang.Integer; 123)");
        params = new Class[2];
        values = new Object[2];
        harness.checkPoint("Testing constructor instances : default testclass(String, String)");
        params[0] = class$java$lang$String == null ? (class$java$lang$String = testNewInstance.class$("java.lang.String")) : class$java$lang$String;
        params[1] = class$java$lang$String == null ? (class$java$lang$String = testNewInstance.class$("java.lang.String")) : class$java$lang$String;
        values[0] = "abcde";
        values[1] = "ABCDE";
        this.checkNewInstance(params, values, this.fullClassName + "(Ljava.lang.String;Ljava.lang.String; abcde, ABCDE)");
    }

    private void checkNewInstance(Class[] params, Object[] values, String expected) {
        try {
            Class<?> cl = Class.forName("gnu.testlet.wonka.lang.reflect.Constructor.NewInstanceClass");
            Constructor<?> c = cl.getConstructor(params);
            Object o = c.newInstance(values);
            harness.check(o.toString(), (Object)expected);
        }
        catch (Exception e) {
            harness.fail(e.toString());
        }
    }

    public void test(TestHarness newharness) {
        harness = newharness;
        harness.setclass("java.lang.reflect");
        this.testConstructorArray();
        this.testConstructorInstances();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

