/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.ref.ReferenceQueue;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.HashSet;

public class AcuniaReferenceQueueTest
implements Testlet {
    protected TestHarness th;
    private boolean wantedException;
    private Reference onQueue;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.lang.ref.ReferenceQueue");
        this.test_ReferenceQueue();
        this.test_poll();
    }

    public void test_ReferenceQueue() {
        this.th.checkPoint("ReferenceQueue()");
        this.th.check(new ReferenceQueue().poll(), null, "new ReferenceQueue is empty");
    }

    public void test_poll() {
        this.th.checkPoint("poll()java.lang.ref.Reference");
        ReferenceQueue rq = new ReferenceQueue();
        SoftReference<String> sr = new SoftReference<String>("Hello", rq);
        sr.enqueue();
        this.th.check(rq.poll(), sr, "reference should be there -- 1");
        this.th.check(rq.poll(), null, "reference was removed from the queue -- 2");
        String s = "Hello";
        HashSet<Reference> hs = new HashSet<Reference>(7);
        PhantomReference<String> r1 = new PhantomReference<String>(s, rq);
        r1.enqueue();
        hs.add(r1);
        WeakReference<String> r2 = new WeakReference<String>(s, rq);
        r2.enqueue();
        hs.add(r2);
        SoftReference<String> r3 = new SoftReference<String>(s, rq);
        r3.enqueue();
        hs.add(r3);
        this.th.check(hs.remove(rq.poll()), "a reference should be there -- 3");
        this.th.check(hs.remove(rq.poll()), "a reference should be there -- 4");
        this.th.check(hs.remove(rq.poll()), "a reference should be there -- 5");
        this.th.check(rq.poll(), null, "all references were removed from the queue -- 6");
    }

    public void test_remove1() {
        this.th.checkPoint("remove()java.lang.ref.Reference");
        Thread t = new Thread((Runnable)new RQRunner(null, 0L, this), "ReferenceQueueTest");
        t.start();
    }

    public void test_remove2() {
        this.th.checkPoint("remove(long)java.lang.ref.Reference");
    }

    public void reportInterrupt() {
        this.th.check(this.wantedException, "RQRunner got an InterruptedException while removing");
    }

    public void reportReference(Reference ref) {
        this.th.check(ref, this.onQueue, "checking return value remove");
    }

    public static class RQRunner
    implements Runnable {
        private AcuniaReferenceQueueTest testlet;
        private ReferenceQueue rq;
        private long timeOut;

        public void run() {
            try {
                Reference ref = this.timeOut == 0L ? this.rq.remove() : this.rq.remove(this.timeOut);
                this.testlet.reportReference(ref);
            }
            catch (InterruptedException ie) {
                this.testlet.reportInterrupt();
            }
        }

        public RQRunner(ReferenceQueue rq, long timeOut, AcuniaReferenceQueueTest testlet) {
            this.rq = rq != null ? rq : new ReferenceQueue();
            this.timeOut = timeOut;
            this.testlet = testlet;
        }
    }
}

