/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.ref.PhantomReference;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;

public class AcuniaPhantomReferenceTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.lang.ref.PhantomReference");
        this.test_PhantomReference();
        this.test_get();
        this.test_clear();
        this.test_enqueue();
        this.test_isEnqueued();
    }

    public void test_PhantomReference() {
        this.th.checkPoint("PhantomReference(java.lang.Object,java.lang.ref.ReferenceQueue)");
        ReferenceQueue rq = new ReferenceQueue();
        try {
            new PhantomReference<Object>(null, rq);
            this.th.fail("should throw a NullPointerException -- 1");
        }
        catch (NullPointerException np) {
            this.th.check(true, "correct exception was thrown -- 1");
        }
        try {
            new PhantomReference<Object>(new Object(), null);
            this.th.fail("should throw a NullPointerException -- 2");
        }
        catch (NullPointerException np) {
            this.th.check(true, "correct exception was thrown -- 2");
        }
    }

    public void test_get() {
        this.th.checkPoint("get()java.lang.Object");
        String msg = "always returns null";
        PhantomReference<String> pr = new PhantomReference<String>(msg, new ReferenceQueue());
        this.th.check(pr.get(), null, msg);
        pr.clear();
    }

    public void test_clear() {
        this.th.checkPoint("clear()void");
        ReferenceQueue rq = new ReferenceQueue();
        Runtime rt = Runtime.getRuntime();
        PhantomReference pr = this.makePhantom(rq, 1000000);
        Reference ref = null;
        while (ref == null) {
            try {
                System.gc();
                System.runFinalization();
                ref = rq.remove(1000L);
            }
            catch (Exception e) {}
        }
        this.th.check(ref, pr, "reference should be the same");
        long memC = rt.totalMemory() - rt.freeMemory();
        System.gc();
        System.runFinalization();
        ref.clear();
        System.gc();
        System.runFinalization();
        System.gc();
        System.runFinalization();
        long memNow = rt.totalMemory() - rt.freeMemory();
        this.th.debug("Memory used is now " + memNow + ", was " + memC);
        this.th.check(memNow + 1000000L < memC);
    }

    public void test_enqueue() {
        this.th.checkPoint("enqueue()boolean");
        String msg = "checking return value -- ";
        int i = 1;
        ReferenceQueue rq = new ReferenceQueue();
        PhantomReference<String> pr = new PhantomReference<String>(msg, rq);
        this.th.check(pr.enqueue(), msg + i++);
        this.th.check(!pr.enqueue(), msg + i++);
        this.th.check(rq.poll(), pr, "reference was put into the queue");
        this.th.check(!pr.enqueue(), msg + i++);
        pr.clear();
        msg = "special case -- ";
        i = 1;
        pr = new PhantomReference<String>(msg, rq);
        pr.clear();
        this.th.check(!pr.isEnqueued(), msg + i++);
        this.th.check(pr.enqueue(), msg + i++);
        this.th.check(!pr.enqueue(), msg + i++);
        this.th.check(rq.poll(), pr, "reference was put into the queue");
        this.th.check(!pr.enqueue(), msg + i++);
    }

    public void test_isEnqueued() {
        this.th.checkPoint("isEnqueued()boolean");
        String msg = "checking return value -- ";
        int i = 1;
        ReferenceQueue rq = new ReferenceQueue();
        PhantomReference<String> pr = new PhantomReference<String>(msg, rq);
        this.th.check(!pr.isEnqueued(), msg + i++);
        this.th.check(pr.enqueue(), msg + i++);
        this.th.check(pr.isEnqueued(), msg + i++);
        this.th.check(rq.poll(), pr, "reference was put into the queue");
        this.th.check(!pr.isEnqueued(), msg + i++);
        pr.clear();
    }

    private PhantomReference makePhantom(ReferenceQueue rq, int size) {
        return new PhantomReference<long[]>(new long[size], rq);
    }
}

