/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.String;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

public class StringTest
implements Testlet {
    protected static TestHarness harness;

    public void test_Basics() {
        String str6;
        String str62;
        harness.checkPoint("String()");
        String str1 = new String();
        boolean bl = false;
        if (str1.length() != 0) {
            bl = true;
        }
        harness.check(bl ^ true, "Error : test_Basics failed - 1");
        harness.check(str1.toString().equals("") ^ true ^ true, "Error : test_Basics failed - 2");
        harness.checkPoint("String(java.lang.String)");
        String str2 = new String("testing");
        boolean bl2 = false;
        if (str2.length() != 7) {
            bl2 = true;
        }
        harness.check(bl2 ^ true, "Error : test_Basics failed - 3");
        harness.check(str2.toString().equals("testing") ^ true ^ true, "Error : test_Basics failed - 4");
        try {
            String str = null;
            String str3 = new String(str);
            harness.fail("Error : test_Basics failed - 5");
        }
        catch (NullPointerException e) {
            harness.check(true);
        }
        harness.checkPoint("String(java.lang.StringBuffer)");
        String str4 = new String(new StringBuffer("hi there"));
        boolean bl3 = false;
        if (str4.length() != 8) {
            bl3 = true;
        }
        harness.check(bl3 ^ true, "Error : test_Basics failed - 6");
        harness.check(str4.toString().equals("hi there") ^ true ^ true, "Error : test_Basics failed - 7");
        try {
            StringBuffer strb = null;
            String str3 = new String(strb);
            harness.fail("Error : test_Basics failed - 5");
        }
        catch (NullPointerException e) {
            harness.check(true);
        }
        harness.checkPoint("String(char[])");
        char[] cdata = new char[]{'h', 'e', 'l', 'l', 'o'};
        String str5 = new String(cdata);
        boolean bl4 = false;
        if (str5.length() != 5) {
            bl4 = true;
        }
        harness.check(bl4 ^ true, "Error : test_Basics failed - 8");
        harness.check(str5.toString().equals("hello") ^ true ^ true, "Error : test_Basics failed - 9");
        try {
            char[] chra = null;
            String str3 = new String(chra);
            harness.fail("Error : test_Basics failed - 5");
        }
        catch (NullPointerException e) {
            harness.check(true);
        }
        harness.checkPoint("String(char[],int,int)");
        try {
            str62 = new String(cdata, 0, 10);
            harness.fail("Error : test_Basics failed - 10");
        }
        catch (IndexOutOfBoundsException e) {
            harness.check(true);
        }
        try {
            str62 = new String(cdata, 0, -10);
            harness.fail("Error : test_Basics failed - 10");
        }
        catch (IndexOutOfBoundsException e) {
            harness.check(true);
        }
        try {
            str62 = new String(cdata, -1, 4);
            harness.fail("Error : test_Basics failed - 10");
        }
        catch (IndexOutOfBoundsException e) {
            harness.check(true);
        }
        String str8 = new String(cdata, 0, 4);
        harness.check(str8.equals("hell") ^ true ^ true, "Error : test_Basics failed - 12");
        try {
            char[] chra = null;
            String str3 = new String(chra, 0, 0);
            harness.fail("Error : test_Basics failed - 5");
        }
        catch (NullPointerException e) {
            harness.check(true);
        }
        harness.checkPoint("String(byte[])");
        byte[] bdata = new byte[]{100, 97, 110, 99, 105, 110, 103};
        String str14 = new String(bdata);
        harness.check(str14.equals("dancing") ^ true ^ true, "Error : test_Basics failed - 18");
        try {
            byte[] bta = null;
            String str3 = new String(bta);
            harness.fail("Error : test_Basics failed - 5");
        }
        catch (NullPointerException e) {
            harness.check(true);
        }
        harness.checkPoint("String(byte[],int,int)");
        try {
            byte[] barr = null;
            String str7 = new String(barr, 0, 10);
            harness.fail("Error : test_Basics failed - 11");
        }
        catch (NullPointerException e) {
            harness.check(true);
        }
        try {
            str6 = new String(bdata, 0, 10);
            harness.fail("Error : test_Basics failed - 10");
        }
        catch (IndexOutOfBoundsException e) {
            harness.check(true);
        }
        try {
            str6 = new String(bdata, 0, -10);
            harness.fail("Error : test_Basics failed - 10");
        }
        catch (IndexOutOfBoundsException e) {
            harness.check(true);
        }
        try {
            str6 = new String(bdata, -1, 4);
            harness.fail("Error : test_Basics failed - 10");
        }
        catch (IndexOutOfBoundsException e) {
            harness.check(true);
        }
    }

    public void test_toString() {
        harness.checkPoint("toString()java.lang.String");
        String str1 = "218943289";
        harness.check(str1.toString().equals("218943289") ^ true ^ true, "Error : test_toString failed - 1");
        boolean bl = false;
        if (str1 != "218943289") {
            bl = true;
        }
        harness.check(bl ^ true, "Error : test_toString failed - 2");
        harness.check(str1.equals(str1.toString()) ^ true ^ true, "Error : test_toString failed - 3");
        boolean bl2 = false;
        if (str1.toString() == "218943289") {
            bl2 = true;
        }
        harness.check(bl2, "Error : test_toString failed - 4");
    }

    public void test_equals() {
        harness.checkPoint("equals(java.lang.Object)boolean");
        String str2 = new String("Nectar");
        harness.check(str2.equals(null) ^ true, "Error : test_equals failed - 1");
        harness.check(str2.equals("Nectar") ^ true ^ true, "Error : test_equals failed - 2");
        harness.check(str2.equals("") ^ true, "Error : test_equals failed - 3");
        harness.check(str2.equals("nectar") ^ true, "Error : test_equals failed - 4");
        harness.check("".equals("") ^ true ^ true, "Error : test_equals failed - 5");
        str2 = "";
        harness.check(str2.equals(null) ^ true);
    }

    public void test_hashCode() {
        harness.checkPoint("equals(java.lang.Object)boolean");
        String str1 = "hp";
        String str2 = "Hewlett Packard Company";
        String str3 = "Hewlett Packard Company";
        String str4 = "SmartMove";
        int hashSm = str4.charAt(0);
        int i = 1;
        while (i < 9) {
            hashSm = hashSm * 31 + str4.charAt(i);
            ++i;
        }
        boolean bl = false;
        if (str4.hashCode() == hashSm) {
            bl = true;
        }
        harness.check(bl, "testing hashcode algorithm");
        int hash1 = 3336;
        int acthash1 = str1.hashCode();
        boolean bl2 = false;
        if (hash1 != acthash1) {
            bl2 = true;
        }
        harness.check(bl2 ^ true, "Error : test_hashCode failed - 1");
        boolean bl3 = false;
        if (str2.hashCode() == str3.hashCode()) {
            bl3 = true;
        }
        harness.check(bl3, "equal string should have equal hashcodes");
    }

    public void test_length() {
        harness.checkPoint("length()int");
        boolean bl = false;
        if ("".length() != 0) {
            bl = true;
        }
        harness.check(bl ^ true, "Error : test_length failed - 1");
        boolean bl2 = false;
        if ("pentium".length() != 7) {
            bl2 = true;
        }
        harness.check(bl2 ^ true, "Error : test_length failed - 2");
    }

    public void test_charAt() {
        char ch;
        harness.checkPoint("charAt(int)char");
        boolean bl = false;
        if ("abcd".charAt(0) != 'a' || "abcd".charAt(1) != 'b' || "abcd".charAt(2) != 'c' || "abcd".charAt(3) != 'd') {
            bl = true;
        }
        harness.check(bl ^ true, "Error : test_charAt failed - 1");
        try {
            ch = "abcd".charAt(4);
            harness.fail("Error : test_charAt failed - 2");
        }
        catch (IndexOutOfBoundsException ch2) {
            // empty catch block
        }
        try {
            ch = "abcd".charAt(-1);
            harness.fail("Error : test_charAt failed - 3");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void test_getChars() {
        harness.checkPoint("getChars(int,int,char[],int)void");
        String str = "abcdefghijklmn";
        try {
            str.getChars(0, 3, null, 1);
            harness.fail("Error : test_getChars failed - 1");
        }
        catch (NullPointerException dst) {
            // empty catch block
        }
        char[] dst = new char[5];
        try {
            str.getChars(-1, 3, dst, 1);
            harness.fail("Error : test_getChars failed - 2");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            str.getChars(4, 3, dst, 1);
            harness.fail("Error : test_getChars failed - 3");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            str.getChars(1, 15, dst, 1);
            harness.fail("Error : test_getChars failed - 4");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            str.getChars(1, 5, dst, -1);
            harness.fail("Error : test_getChars failed - 5");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            str.getChars(1, 10, dst, 1);
            harness.fail("Error : test_getChars failed - 6");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        str.getChars(0, 5, dst, 0);
        boolean bl = false;
        if (dst[0] != 'a' || dst[1] != 'b' || dst[2] != 'c' || dst[3] != 'd' || dst[4] != 'e') {
            bl = true;
        }
        harness.check(bl ^ true, "Error : test_getChars failed - 7");
        dst[4] = 32;
        dst[3] = 32;
        dst[2] = 32;
        dst[1] = 32;
        dst[0] = 32;
        str.getChars(0, 0, dst, 0);
        boolean bl2 = false;
        if (dst[0] != ' ' || dst[1] != ' ' || dst[2] != ' ' || dst[3] != ' ' || dst[4] != ' ') {
            bl2 = true;
        }
        harness.check(bl2 ^ true, "Error : test_getChars failed - 9");
        dst[4] = 32;
        dst[3] = 32;
        dst[2] = 32;
        dst[1] = 32;
        dst[0] = 32;
        str.getChars(0, 1, dst, 0);
        boolean bl3 = false;
        if (dst[0] != 'a' || dst[1] != ' ' || dst[2] != ' ' || dst[3] != ' ' || dst[4] != ' ') {
            bl3 = true;
        }
        harness.check(bl3 ^ true, "Error : test_getChars failed - 10");
        dst[4] = 32;
        dst[3] = 32;
        dst[2] = 32;
        dst[1] = 32;
        dst[0] = 32;
        str.getChars(3, 7, dst, 0);
        boolean bl4 = false;
        if (dst[0] != 'd' || dst[1] != 'e' || dst[2] != 'f' || dst[3] != 'g' || dst[4] != ' ') {
            bl4 = true;
        }
        harness.check(bl4 ^ true, "Error : test_getChars failed - 11");
        str.getChars(10, 14, dst, 1);
        harness.check("dklmn".equals(new String(dst)), "Error : test_getChars failed - 12");
    }

    public void test_getBytes() {
        harness.checkPoint("getBytes()byte[]");
        String str = "abcdefghijklmn";
        byte[] dst1 = new byte[40];
        dst1 = str.getBytes();
        boolean bl = false;
        if (dst1[0] != 97 || dst1[1] != 98 || dst1[2] != 99 || dst1[3] != 100 || dst1[4] != 101) {
            bl = true;
        }
        harness.check(bl ^ true, "Error : test_getBytes failed - 8");
    }

    public void test_toCharArray() {
        harness.checkPoint("toCharArray()char[]");
        char[] charr = "abcde".toCharArray();
        boolean bl = false;
        if (charr[0] != 'a' || charr[1] != 'b' || charr[2] != 'c' || charr[3] != 'd' || charr[4] != 'e') {
            bl = true;
        }
        harness.check(bl ^ true, "Error : test_toCharArray failed - 1");
        try {
            charr[5] = 108;
            harness.fail("An IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException e) {
            harness.check(true);
        }
        char[] charr1 = "".toCharArray();
        boolean bl2 = false;
        if (charr1.length > 0) {
            bl2 = true;
        }
        harness.check(bl2 ^ true, "Error : test_toCharArray failed - 2");
    }

    public void test_equalsIgnoreCase() {
        harness.checkPoint("equalsIgnoreCase(java.lang.String)boolean");
        harness.check("hi".equalsIgnoreCase(null) ^ true, "Error : test_equalsIgnoreCase failed - 1");
        harness.check("hi".equalsIgnoreCase("HI") ^ true ^ true, "Error : test_equalsIgnoreCase failed - 2");
        harness.check("hi".equalsIgnoreCase("pq") ^ true, "Error : test_equalsIgnoreCase failed - 3");
        harness.check("hi".equalsIgnoreCase("HI ") ^ true, "Error : test_equalsIgnoreCase failed - 4");
    }

    public void test_compareTo() {
        harness.checkPoint("compareTo(java.lang.String)int");
        try {
            int res = "abc".compareTo(null);
            harness.fail("Error : test_compareTo failed - 1");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        boolean bl = false;
        if ("abc".compareTo("bcdef") >= 0) {
            bl = true;
        }
        harness.check(bl ^ true, "Error : test_compareTo failed - 2");
        boolean bl2 = false;
        if ("abc".compareTo("abc") != 0) {
            bl2 = true;
        }
        harness.check(bl2 ^ true, "Error : test_compareTo failed - 3");
        boolean bl3 = false;
        if ("abc".compareTo("aabc") <= 0) {
            bl3 = true;
        }
        harness.check(bl3 ^ true, "Error : test_compareTo failed - 4");
        boolean bl4 = false;
        if ("abcd".compareTo("abc") <= 0) {
            bl4 = true;
        }
        harness.check(bl4 ^ true, "Error : test_compareTo failed - 5");
        boolean bl5 = false;
        if ("".compareTo("abc") >= 0) {
            bl5 = true;
        }
        harness.check(bl5 ^ true, "Error : test_compareTo failed - 6");
        boolean bl6 = false;
        if ("abc".compareTo("efg") == -4) {
            bl6 = true;
        }
        harness.check(bl6, "Error : test_compareTo failed - 7");
        boolean bl7 = false;
        if ("abcdefgh".compareTo("abc") == 5) {
            bl7 = true;
        }
        harness.check(bl7, "Error : test_compareTo failed - 8");
        boolean bl8 = false;
        if ("ebc".compareTo("afg") == 4) {
            bl8 = true;
        }
        harness.check(bl8, "Error : test_compareTo failed - 7");
        boolean bl9 = false;
        if ("abc".compareTo("abcdefgh") == -5) {
            bl9 = true;
        }
        harness.check(bl9, "Error : test_compareTo failed - 8");
    }

    public void test_regionMatches() {
        boolean res;
        harness.checkPoint("regionMatches(int,java.lang.String,int,int)boolean");
        try {
            res = "abc".regionMatches(0, null, 0, 2);
            harness.fail("Error : test_regionMatches failed - 1");
        }
        catch (NullPointerException e) {
            harness.check(true);
        }
        harness.check("abcd".regionMatches(-1, "abcd", 0, 2) ^ true, "Error : test_regionMatches failed - 2");
        harness.check("abcd".regionMatches(0, "abcd", -1, 2) ^ true, "Error : test_regionMatches failed - 3");
        harness.check("abcd".regionMatches(0, "abcd", 0, 10) ^ true, "Error : test_regionMatches failed - 4");
        harness.check("abcd".regionMatches(0, "ab", 0, 3) ^ true, "Error : test_regionMatches failed - 5");
        harness.check("abcd".regionMatches(1, "abc", 1, 2) ^ true ^ true, "Error : test_regionMatches failed - 6");
        harness.check("abcd".regionMatches(1, "abc", 1, 0) ^ true ^ true, "Error : test_regionMatches failed - 7");
        harness.check("abcd".regionMatches(1, "ABC", 1, 2) ^ true, "Error : test_regionMatches failed - 8");
        harness.checkPoint("regionMatches(boolean,int,java.lang.String,int,int)boolean");
        try {
            res = "abc".regionMatches(true, 0, null, 0, 2);
            harness.fail("Error : test_regionMatches failed - 11");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        harness.check("abcd".regionMatches(true, -1, "abcd", 0, 2) ^ true, "Error : test_regionMatches failed - 12");
        harness.check("abcd".regionMatches(true, 0, "abcd", -1, 2) ^ true, "Error : test_regionMatches failed - 13");
        harness.check("abcd".regionMatches(true, 0, "abcd", 0, 10) ^ true, "Error : test_regionMatches failed - 14");
        harness.check("abcd".regionMatches(true, 0, "ab", 0, 3) ^ true, "Error : test_regionMatches failed - 15");
        harness.check("abcd".regionMatches(true, 1, "abc", 1, 2) ^ true ^ true, "Error : test_regionMatches failed - 16");
        harness.check("abcd".regionMatches(true, 1, "abc", 1, 0) ^ true ^ true, "Error : test_regionMatches failed - 17");
        harness.check("abcd".regionMatches(true, 1, "ABC", 1, 2) ^ true ^ true, "Error : test_regionMatches failed - 18");
        harness.check("abcd".regionMatches(false, 1, "ABC", 1, 2) ^ true, "Error : test_regionMatches failed - 19");
    }

    public void test_startsWith() {
        boolean b;
        harness.checkPoint("startsWith(java.lang.String)boolean");
        harness.check("abcdef".startsWith("abc") ^ true ^ true, "Error : test_startsWith failed - 1");
        try {
            b = "abcdef".startsWith(null);
            harness.fail("Error : test_startsWith failed - 2");
        }
        catch (NullPointerException e) {
            harness.check(true);
        }
        harness.check("abcdef".startsWith("ABC") ^ true, "Error : test_startsWith failed - 3");
        harness.check("abcdef".startsWith("") ^ true ^ true, "Error : test_startsWith failed - 4");
        harness.check("abc".startsWith("abcd") ^ true, "Error : test_startsWith failed - 5");
        harness.checkPoint("startsWith(java.lang.String,int)boolean");
        harness.check("abcdef".startsWith("abc", 0) ^ true ^ true, "Error : test_startsWith failed - 6");
        try {
            b = "abcdef".startsWith(null, 0);
            harness.fail("Error : test_startsWith failed - 7");
        }
        catch (NullPointerException e) {
            harness.check(true);
        }
        harness.check("abcdef".startsWith("ABC", 2) ^ true, "Error : test_startsWith failed - 8");
        harness.check("abcdef".startsWith("", 0) ^ true ^ true, "Error : test_startsWith failed - 9");
        harness.check("abc".startsWith("abcd", 3) ^ true, "Error : test_startsWith failed - 10");
        harness.check("abc".startsWith("abc", 10) ^ true, "Error : test_startsWith failed - 11");
        harness.check("defabcdef".startsWith("abc", 3) ^ true ^ true, "Error : test_startsWith failed - 12");
    }

    public void test_endsWith() {
        harness.checkPoint("endsWith(java.lang.String)boolean");
        harness.check("abcdef".endsWith("def") ^ true ^ true, "Error : test_endsWith failed - 1");
        try {
            boolean b = "abcdef".endsWith(null);
            harness.fail("Error : test_endsWith failed - 2");
        }
        catch (NullPointerException e) {
            harness.check(true);
        }
        harness.check("abcdef".endsWith("DEF") ^ true, "Error : test_endsWith failed - 3");
        harness.check("abcdef".endsWith("") ^ true ^ true, "Error : test_endsWith failed - 4");
        harness.check("bcde".endsWith("abcd") ^ true, "Error : test_endsWith failed - 5");
        harness.check("abcd".endsWith("abcd"), "Error : test_endsWith failed - 5");
    }

    public void test_indexOf() {
        int x;
        harness.checkPoint("indexOf(int)int");
        boolean bl = false;
        if ("a".indexOf(97) != 0) {
            bl = true;
        }
        harness.check(bl ^ true, "Error : test_indexOf failed - 1");
        boolean bl2 = false;
        if ("aabc".indexOf(99) != 3) {
            bl2 = true;
        }
        harness.check(bl2 ^ true, "Error : test_indexOf failed - 2");
        boolean bl3 = false;
        if ("a".indexOf(99) != -1) {
            bl3 = true;
        }
        harness.check(bl3 ^ true, "Error : test_indexOf failed - 3");
        boolean bl4 = false;
        if ("".indexOf(97) != -1) {
            bl4 = true;
        }
        harness.check(bl4 ^ true, "Error : test_indexOf failed - 4a");
        boolean bl5 = false;
        if ("ab\t\nsd".indexOf(10) != 3) {
            bl5 = true;
        }
        harness.check(bl5 ^ true, "Error : test_indexOf failed - 4b");
        boolean bl6 = false;
        if ("ab\t\nsd".indexOf(9) != 2) {
            bl6 = true;
        }
        harness.check(bl6 ^ true, "Error : test_indexOf failed - 4c");
        harness.checkPoint("indexOf(int,int)int");
        boolean bl7 = false;
        if ("abcde".indexOf(98, 3) != -1) {
            bl7 = true;
        }
        harness.check(bl7 ^ true, "Error : test_indexOf failed - 5");
        boolean bl8 = false;
        if ("abcde".indexOf(98, 0) != 1) {
            bl8 = true;
        }
        harness.check(bl8 ^ true, "Error : test_indexOf failed - 6");
        boolean bl9 = false;
        if ("abcdee".indexOf(101, 3) != 4) {
            bl9 = true;
        }
        harness.check(bl9 ^ true, "Error : test_indexOf failed - 7");
        boolean bl10 = false;
        if ("abcdee".indexOf(101, 5) != 5) {
            bl10 = true;
        }
        harness.check(bl10 ^ true, "Error : test_indexOf failed - 8");
        boolean bl11 = false;
        if ("abcdee".indexOf(101, -5) != 4) {
            bl11 = true;
        }
        harness.check(bl11 ^ true, "Error : test_indexOf failed - 9");
        boolean bl12 = false;
        if ("abcdee".indexOf(101, 15) != -1) {
            bl12 = true;
        }
        harness.check(bl12 ^ true, "Error : test_indexOf failed - 10");
        harness.checkPoint("indexOf(java.lang.String)int");
        boolean bl13 = false;
        if ("abcdee".indexOf("babu") != -1) {
            bl13 = true;
        }
        harness.check(bl13 ^ true, "Error : test_indexOf failed - 11");
        try {
            x = "abcdee".indexOf(null);
            harness.fail("Error : test_indexOf failed - 12");
        }
        catch (NullPointerException e) {
            harness.check(true);
        }
        boolean bl14 = false;
        if ("abcdee".indexOf("") != 0) {
            bl14 = true;
        }
        harness.check(bl14 ^ true, "Error : test_indexOf failed - 13");
        boolean bl15 = false;
        if ("abcdee".indexOf("ee") != 4) {
            bl15 = true;
        }
        harness.check(bl15 ^ true, "Error : test_indexOf failed - 14");
        boolean bl16 = false;
        if ("abcbcbc".indexOf("cbc") != 2) {
            bl16 = true;
        }
        harness.check(bl16 ^ true, "Error : test_indexOf failed - 15");
        if ("hello \u5236 world".indexOf(21046) != 6) {
            harness.fail("Error : test_indexOf failed - 21");
        }
        if ("hello \u0645 world".indexOf(1605) != 6) {
            harness.fail("Error : test_indexOf failed - 22");
        }
        if ("hello \u07ff world".indexOf(2047) != 6) {
            harness.fail("Error : test_indexOf failed - 23");
        }
        harness.checkPoint("indexOf(java.lang.String,int)int");
        boolean bl17 = false;
        if ("abcdee".indexOf("babu", 3) != -1) {
            bl17 = true;
        }
        harness.check(bl17 ^ true, "Error : test_indexOf failed - 16");
        try {
            x = "abcdee".indexOf(null, 0);
            harness.fail("Error : test_indexOf failed - 17");
        }
        catch (NullPointerException e) {
            harness.check(true);
        }
        boolean bl18 = false;
        if ("abcdee".indexOf("", 0) != 0) {
            bl18 = true;
        }
        harness.check(bl18 ^ true, "Error : test_indexOf failed - 18");
        boolean bl19 = false;
        if ("abcdee".indexOf("ee", 4) != 4) {
            bl19 = true;
        }
        harness.check(bl19 ^ true, "Error : test_indexOf failed - 19");
        boolean bl20 = false;
        if ("abcbcbc".indexOf("cbc", 4) != 4) {
            bl20 = true;
        }
        harness.check(bl20 ^ true, "Error : test_indexOf failed - 20");
    }

    public void test_lastIndexOf() {
        int x;
        harness.checkPoint("lastIndexOf(int)int");
        boolean bl = false;
        if ("a".lastIndexOf(97) != 0) {
            bl = true;
        }
        harness.check(bl ^ true, "Error : test_lastIndexOf failed - 1");
        boolean bl2 = false;
        if ("acbc".lastIndexOf(99) != 3) {
            bl2 = true;
        }
        harness.check(bl2 ^ true, "Error : test_lastIndexOf failed - 2");
        boolean bl3 = false;
        if ("a".lastIndexOf(99) != -1) {
            bl3 = true;
        }
        harness.check(bl3 ^ true, "Error : test_lastIndexOf failed - 3");
        boolean bl4 = false;
        if ("".lastIndexOf(97) != -1) {
            bl4 = true;
        }
        harness.check(bl4 ^ true, "Error : test_lastIndexOf failed - 4");
        harness.checkPoint("lastIndexOf(int,int)int");
        boolean bl5 = false;
        if ("abcde".lastIndexOf(98, 0) != -1) {
            bl5 = true;
        }
        harness.check(bl5 ^ true, "Error : test_lastIndexOf failed - 5");
        boolean bl6 = false;
        if ("abcde".lastIndexOf(98, 4) != 1) {
            bl6 = true;
        }
        harness.check(bl6 ^ true, "Error : test_lastIndexOf failed - 6");
        boolean bl7 = false;
        if ("abcdee".lastIndexOf(101, 7) != 5) {
            bl7 = true;
        }
        harness.check(bl7 ^ true, "Error : test_lastIndexOf failed - 7");
        boolean bl8 = false;
        if ("abcdee".lastIndexOf(101, 4) != 4) {
            bl8 = true;
        }
        harness.check(bl8 ^ true, "Error : test_lastIndexOf failed - 8");
        boolean bl9 = false;
        if ("abcdee".lastIndexOf(101, -5) != -1) {
            bl9 = true;
        }
        harness.check(bl9 ^ true, "Error : test_lastIndexOf failed - 9");
        boolean bl10 = false;
        if ("abcdee".lastIndexOf(101, 15) != 5) {
            bl10 = true;
        }
        harness.check(bl10 ^ true, "Error : test_lastIndexOf failed - 10");
        harness.checkPoint("lastIndexOf(java.lang.String)int");
        boolean bl11 = false;
        if ("abcdee".lastIndexOf("babu") != -1) {
            bl11 = true;
        }
        harness.check(bl11 ^ true, "Error : test_lastIndexOf failed - 11");
        try {
            x = "abcdee".lastIndexOf(null);
            harness.fail("Error : test_lastIndexOf failed - 12");
        }
        catch (NullPointerException e) {
            harness.check(true);
        }
        boolean bl12 = false;
        if ("abcdee".lastIndexOf("") != 6) {
            bl12 = true;
        }
        harness.check(bl12 ^ true, "Error : test_lastIndexOf failed - 13");
        boolean bl13 = false;
        if ("abcdee".lastIndexOf("ee") != 4) {
            bl13 = true;
        }
        harness.check(bl13 ^ true, "Error : test_lastIndexOf failed - 14a");
        boolean bl14 = false;
        if ("abcdeef".lastIndexOf("ee") != 4) {
            bl14 = true;
        }
        harness.check(bl14 ^ true, "Error : test_lastIndexOf failed - 14b");
        boolean bl15 = false;
        if ("abcbcbc".lastIndexOf("cbc") != 4) {
            bl15 = true;
        }
        harness.check(bl15 ^ true, "Error : test_lastIndexOf failed - 15a");
        boolean bl16 = false;
        if ("abcbcbcd".lastIndexOf("cbc") != 4) {
            bl16 = true;
        }
        harness.check(bl16 ^ true, "Error : test_lastIndexOf failed - 15b");
        boolean bl17 = false;
        if ("abcdee".lastIndexOf("babu", 3) != -1) {
            bl17 = true;
        }
        harness.check(bl17 ^ true, "Error : test_lastIndexOf failed - 16");
        harness.checkPoint("lastIndexOf(java.lang.String,int)int");
        try {
            x = "abcdee".lastIndexOf(null, 0);
            harness.fail("Error : test_lastIndexOf failed - 17");
        }
        catch (NullPointerException e) {
            harness.check(true);
        }
        boolean bl18 = false;
        if ("abcdee".lastIndexOf("", 0) != 0) {
            bl18 = true;
        }
        harness.check(bl18 ^ true, "Error : test_lastIndexOf failed - 18a");
        boolean bl19 = false;
        if ("abcdee".lastIndexOf("", 5) != 5) {
            bl19 = true;
        }
        harness.check(bl19 ^ true, "Error : test_lastIndexOf failed - 18b");
        boolean bl20 = false;
        if ("abcdee".lastIndexOf("", 4) != 4) {
            bl20 = true;
        }
        harness.check(bl20 ^ true, "Error : test_lastIndexOf failed - 18c");
        boolean bl21 = false;
        if ("abcdee".lastIndexOf("ee", 4) != 4) {
            bl21 = true;
        }
        harness.check(bl21 ^ true, "Error : test_lastIndexOf failed - 19a");
        boolean bl22 = false;
        if ("abcdeef".lastIndexOf("ee", 4) != 4) {
            bl22 = true;
        }
        harness.check(bl22 ^ true, "Error : test_lastIndexOf failed - 19b");
        boolean bl23 = false;
        if ("abcbcbc".lastIndexOf("cbc", 3) != 2) {
            bl23 = true;
        }
        harness.check(bl23 ^ true, "Error : test_lastIndexOf failed - 20");
        boolean bl24 = false;
        if ("abcdee".lastIndexOf("ee", -5) != -1) {
            bl24 = true;
        }
        harness.check(bl24 ^ true, "Error : test_lastIndexOf failed - 21");
        boolean bl25 = false;
        if ("abcdeeg".lastIndexOf("ee", 55) != 4) {
            bl25 = true;
        }
        harness.check(bl25 ^ true, "Error : test_lastIndexOf failed - 22");
    }

    public void test_substring() {
        String str;
        harness.checkPoint("substring(int)java.lang.String");
        harness.check("unhappy".substring(2).equals("happy") ^ true ^ true, "Error : test_substring failed - 1");
        harness.check("Harbison".substring(3).equals("bison") ^ true ^ true, "Error : test_substring failed - 2");
        harness.check("emptiness".substring(9).equals("") ^ true ^ true, "Error : test_substring failed - 3");
        try {
            str = "hi there".substring(-1);
            harness.fail("Error : test_substring failed - 4");
        }
        catch (IndexOutOfBoundsException e) {
            harness.check(true);
        }
        try {
            str = "hi there".substring(10);
            harness.fail("Error : test_substring failed - 5");
        }
        catch (IndexOutOfBoundsException e) {
            harness.check(true);
        }
        harness.checkPoint("substring(int,int)java.lang.String");
        harness.check("hamburger".substring(4, 8).equals("urge") ^ true ^ true, "Error : test_substring failed - 6");
        harness.check("smiles".substring(1, 5).equals("mile") ^ true ^ true, "Error : test_substring failed - 7");
        harness.check("emptiness".substring(2, 2).equals("") ^ true ^ true, "Error : test_substring failed - 8");
        try {
            str = "hi there".substring(-1, 3);
            harness.fail("Error : test_substring failed - 9");
        }
        catch (IndexOutOfBoundsException e) {
            harness.check(true);
        }
        try {
            str = "hi there".substring(0, 10);
            harness.fail("Error : test_substring failed - 10");
        }
        catch (IndexOutOfBoundsException e) {
            harness.check(true);
        }
        try {
            str = "hi there".substring(7, 6);
            harness.fail("Error : test_substring failed - 11");
        }
        catch (IndexOutOfBoundsException e) {
            harness.check(true);
        }
        harness.check("emptiness".substring(9, 9).equals("") ^ true ^ true, "Error : test_substring failed - 12");
        try {
            str = "emptiness".substring(10, 10);
            harness.fail("Error : test_substring failed - 13");
        }
        catch (IndexOutOfBoundsException e) {
            harness.check(true);
        }
        try {
            str = "emptiness".substring(1110, 1110);
            harness.fail("Error : test_substring failed - 14");
        }
        catch (IndexOutOfBoundsException e) {
            harness.check(true);
        }
    }

    public void test_concat() {
        harness.checkPoint("concat(java.lang.String)java.lang.String");
        try {
            String str = "help".concat(null);
            harness.fail("Error : test_concat failed - 1");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        harness.check("help".concat("me").equals("helpme") ^ true ^ true, "Error : test_concat failed - 2");
        harness.check("to".concat("get").concat("her").equals("together") ^ true ^ true, "Error : test_concat failed - 3");
        boolean bl = false;
        if ("hi".concat("") != "hi") {
            bl = true;
        }
        harness.check(bl ^ true, "Error : test_concat failed - 4");
        String str1 = "".concat("there");
        harness.check(str1.equals("there") ^ true ^ true, "Error : test_concat failed - 5");
        String str2 = new String();
        try {
            str2 = str2.concat("hello");
            if (!str2.equals("hello")) {
                harness.fail("Error : test_concat failed - 7");
            }
        }
        catch (Exception e) {
            harness.fail("Error : test_concat failed - 6");
        }
    }

    public void test_replace() {
        harness.checkPoint("replace(char,char)java.lang.String");
        harness.check("mesquite in your cellar".replace('e', 'o').equals("mosquito in your collar") ^ true ^ true, "Error : test_replace failed - 1");
        harness.check("the war of baronets".replace('r', 'y').equals("the way of bayonets") ^ true ^ true, "Error : test_replace failed - 2");
        harness.check("sparring with a purple porpoise".replace('p', 't').equals("starring with a turtle tortoise") ^ true ^ true, "Error : test_replace failed - 3");
        harness.check("JonL".replace('q', 'x').equals("JonL") ^ true ^ true, "Error : test_replace failed - 4");
        harness.check("ppppppppppppp".replace('p', 'p').equals("ppppppppppppp") ^ true ^ true, "Error : test_replace failed - 5");
        harness.check("ppppppppppppp".replace('p', '1').equals("1111111111111") ^ true ^ true, "Error : test_replace failed - 6");
        harness.check("hp".replace('c', 'd').equals("hp") ^ true ^ true, "Error : test_replace failed - 7");
        harness.check("vmhere".replace('a', 'd').equals("vmhere") ^ true ^ true, "Error : test_replace failed - 8");
        harness.check("hp\nnf\t".replace('\n', 'd').equals("hpdnf\t") ^ true ^ true, "Error : test_replace failed - 9");
        harness.check("vmhere".replace('e', '\t').equals("vmh\tr\t") ^ true ^ true, "Error : test_replace failed - 10");
    }

    public void test_toLowerCase() {
        harness.checkPoint("toLowerCase()java.lang.String");
        harness.check("".toLowerCase().equals("") ^ true ^ true, "Error : test_toLowerCase failed - 1");
        harness.check("French Fries".toLowerCase().equals("french fries") ^ true ^ true, "Error : test_toLowerCase failed - 2");
        harness.check("SMALL-VM".toLowerCase().equals("small-vm") ^ true ^ true, "Error : test_toLowerCase failed - 3");
        harness.check("\u0391\u0392\u0393".toLowerCase().equals("\u03b1\u03b2\u03b3") ^ true ^ true, "Error : test_toLowerCase failed - 4");
        harness.check("\u0401\u0402".toLowerCase().equals("\u0451\u0452") ^ true ^ true, "Error : test_toLowerCase failed - 5");
        harness.check("\u0531\u0532".toLowerCase().equals("\u0561\u0562") ^ true ^ true, "Error : test_toLowerCase failed - 6");
        harness.check("\u00c8\u00ca".toLowerCase().equals("\u00e8\u00ea") ^ true ^ true, "Error : test_toLowerCase failed - 7");
    }

    public void test_toUpperCase() {
        harness.checkPoint("toUpperCase()java.lang.String");
        harness.check("".toUpperCase().equals("") ^ true ^ true, "Error : test_toUpperCase failed - 1");
        harness.check("French Fries".toUpperCase().equals("FRENCH FRIES") ^ true ^ true, "Error : test_toUpperCase failed - 2");
        harness.check("SMALL-VM".toUpperCase().equals("SMALL-VM") ^ true ^ true, "Error : test_toUpperCase failed - 3");
        harness.check("small-jvm".toUpperCase().equals("SMALL-JVM") ^ true ^ true, "Error : test_toUpperCase failed - 4");
        harness.check("\u03b1\u03b2\u03b3".toUpperCase().equals("\u0391\u0392\u0393") ^ true ^ true, "Error : test_toUpperCase failed - 5");
        harness.check("\u0451\u0452".toUpperCase().equals("\u0401\u0402") ^ true ^ true, "Error : test_toUpperCase failed - 6");
        harness.check("\u0561\u0562".toUpperCase().equals("\u0531\u0532") ^ true ^ true, "Error : test_toUpperCase failed - 7");
        harness.check("\u00e8\u00ea".toUpperCase().equals("\u00c8\u00ca") ^ true ^ true, "Error : test_toUpperCase failed - 8");
    }

    public void test_valueOf() {
        String str;
        char[] data;
        harness.checkPoint("valueOf(java.lang.Object)java.lang.String");
        harness.check(String.valueOf(null).equals("null") ^ true ^ true, "Error : test_valueOf failed - 1");
        Object obj = new Object();
        harness.check(String.valueOf(obj).equals(obj.toString()) ^ true ^ true, "Error : test_valueOf failed - 2");
        harness.checkPoint("valueOf(char[])java.lang.String");
        try {
            data = null;
            str = String.valueOf(data);
        }
        catch (NullPointerException e) {
            harness.check(true);
        }
        data = new char[]{'h', 'e', 'l', 'l', 'o'};
        harness.check(String.valueOf(data).equals("hello") ^ true ^ true, "Error : test_valueOf failed - 3");
        harness.checkPoint("valueOf(char[],int,int)java.lang.String");
        try {
            str = String.valueOf(data, -1, 4);
            harness.fail("Error : test_valueOf failed - 4");
        }
        catch (IndexOutOfBoundsException e) {
            harness.check(true);
        }
        try {
            str = String.valueOf(data, 1, 5);
            harness.fail("Error : test_valueOf failed - 5");
        }
        catch (IndexOutOfBoundsException e) {
            harness.check(true);
        }
        try {
            str = String.valueOf(data, 1, -5);
            harness.fail("Error : test_valueOf failed - 6");
        }
        catch (IndexOutOfBoundsException e) {
            harness.check(true);
        }
        try {
            str = String.valueOf(null, 1, 3);
            harness.fail("Error : test_valueOf failed - 7");
        }
        catch (NullPointerException e) {
            harness.check(true);
        }
        harness.check(String.valueOf(data, 2, 2).equals("ll") ^ true ^ true, "Error : test_valueOf failed - 8");
        harness.checkPoint("valueOf(boolean)java.lang.String");
        harness.check(String.valueOf(true).equals("true") ^ true ^ true, "Error : test_valueOf failed - 9");
        harness.check(String.valueOf(false).equals("false") ^ true ^ true, "Error : test_valueOf failed - 10");
        harness.checkPoint("valueOf(char)java.lang.String");
        harness.check(String.valueOf('c').equals("c") ^ true ^ true, "Error : test_valueOf failed - 11");
        harness.check(String.valueOf(' ').equals(" ") ^ true ^ true, "Error : test_valueOf failed - 12");
        harness.checkPoint("valueOf(int)java.lang.String");
        harness.check(String.valueOf(234).equals("234") ^ true ^ true, "Error : test_valueOf failed - 13a");
        harness.check(String.valueOf(234).equals(new Integer(234).toString()) ^ true ^ true, "Error : test_valueOf failed - 13b");
        harness.checkPoint("valueOf(long)java.lang.String");
        harness.check(String.valueOf(234L).equals("234") ^ true ^ true, "Error : test_valueOf failed - 14a");
        harness.check(String.valueOf(234L).equals(new Long(234L).toString()) ^ true ^ true, "Error : test_valueOf failed - 14b");
        harness.checkPoint("valueOf(float)java.lang.String");
        harness.check(String.valueOf(23.45f).equals("23.45") ^ true ^ true, "Error : test_valueOf failed - 15a");
        harness.check(String.valueOf(234.4f).equals(new Float(234.4f).toString()) ^ true ^ true, "Error : test_valueOf failed - 15b");
        harness.checkPoint("valueOf(double)java.lang.String");
        harness.check("23.5".equals(String.valueOf(23.5)), "Error : test_valueOf failed - 16a, got: " + String.valueOf(23.5));
        harness.check(String.valueOf(23.4), "23.4", "Error : test_valueOf failed - 16b");
        harness.check(String.valueOf(234.4).equals(new Double(234.4).toString()) ^ true ^ true, "Error : test_valueOf failed - 16c");
        harness.checkPoint("copyValueOf(char[])java.lang.String");
        harness.check(String.copyValueOf(data).equals("hello") ^ true ^ true, "Error : test_valueOf failed - 3a");
        try {
            String.copyValueOf(null);
            harness.fail("test_copyValueOf failed");
        }
        catch (NullPointerException ne) {
            harness.check(true);
        }
        harness.checkPoint("copyValueOf(char[],int,int)java.lang.String");
        harness.check(String.copyValueOf(data, 2, 2).equals("ll") ^ true ^ true, "Error : test_valueOf failed - 8a");
        try {
            String.copyValueOf(data, -1, 2);
            harness.fail("test_copyValueOf failed");
        }
        catch (IndexOutOfBoundsException ie) {
            harness.check(true);
        }
        try {
            String.copyValueOf(data, 1, -2);
            harness.fail("test_copyValueOf failed");
        }
        catch (IndexOutOfBoundsException ie) {
            harness.check(true);
        }
        try {
            String.copyValueOf(data, 1, 20);
            harness.fail("test_copyValueOf failed");
        }
        catch (IndexOutOfBoundsException ie) {
            harness.check(true);
        }
        try {
            String.copyValueOf(data, 6, 2);
            harness.fail("test_copyValueOf failed");
        }
        catch (IndexOutOfBoundsException ie) {
            harness.check(true);
        }
    }

    public void test_intern() {
        harness.checkPoint("intern()java.lang.String");
        String hp = "hp";
        String nullstr = "";
        boolean bl = false;
        if ("hp".intern() != hp.intern()) {
            bl = true;
        }
        harness.check(bl ^ true, "Error : test_intern failed - 1");
        boolean bl2 = false;
        if ("pqr".intern() == hp.intern()) {
            bl2 = true;
        }
        harness.check(bl2 ^ true, "Error : test_intern failed - 2");
        boolean bl3 = false;
        if ("".intern() != nullstr.intern()) {
            bl3 = true;
        }
        harness.check(bl3 ^ true, "Error : test_intern failed - 3");
        boolean bl4 = false;
        if ("".intern() == hp.intern()) {
            bl4 = true;
        }
        harness.check(bl4 ^ true, "Error : test_intern failed - 4");
        hp = "";
        boolean bl5 = false;
        if ("".intern() != hp.intern()) {
            bl5 = true;
        }
        harness.check(bl5 ^ true, "Error : test_intern failed - 5");
        StringBuffer buff = new StringBuffer();
        buff.append('a');
        buff.append('b');
        boolean bl6 = false;
        if ("ab".intern() != buff.toString().intern()) {
            bl6 = true;
        }
        harness.check(bl6 ^ true, "Error : test_intern failed - 6");
        StringBuffer buff1 = new StringBuffer();
        boolean bl7 = false;
        if ("".intern() != buff1.toString().intern()) {
            bl7 = true;
        }
        harness.check(bl7 ^ true, "Error : test_intern failed - 7");
    }

    public void test_trim() {
        harness.checkPoint("trim()java.lang.String");
        String source = "   laura";
        String dest = source.trim();
        if (!dest.equals("laura")) {
            harness.fail("Error - test_trim - 1");
        }
        if (!(dest = (source = "\t\t\tlaura").trim()).equals("laura")) {
            harness.fail("Error - test_trim - 2");
        }
        if (!(dest = (source = "              ").trim()).equals("")) {
            harness.fail("Error - test_trim - 3");
        }
        if ((dest = (source = "laura").trim()) != source) {
            harness.fail("Error - test_trim - 4");
        }
        if (!(dest = (source = "l        ").trim()).equals("l")) {
            harness.fail("Error - test_trim - 5");
        }
        if (!(dest = (source = "           l").trim()).equals("l")) {
            harness.fail("Error - test_trim - 6");
        }
        if (!(dest = (source = "           l            ").trim()).equals("l")) {
            harness.fail("Error - test_trim - 7");
        }
        if (!(dest = (source = "           l a u r a             ").trim()).equals("l a u r a")) {
            harness.fail("Error - test_trim - 8");
        }
    }

    public void testall() {
        harness.setclass("java.lang.String");
        this.test_Basics();
        this.test_toString();
        this.test_equals();
        this.test_hashCode();
        this.test_length();
        this.test_charAt();
        this.test_getChars();
        this.test_getBytes();
        this.test_toCharArray();
        this.test_equalsIgnoreCase();
        this.test_compareTo();
        this.test_regionMatches();
        this.test_startsWith();
        this.test_endsWith();
        this.test_indexOf();
        this.test_lastIndexOf();
        this.test_substring();
        this.test_concat();
        this.test_replace();
        this.test_toLowerCase();
        this.test_toUpperCase();
        this.test_valueOf();
        this.test_intern();
        this.test_trim();
    }

    public void test(TestHarness the_harness) {
        harness = the_harness;
        this.testall();
    }
}

