/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.String;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.io.UnsupportedEncodingException;

public class SMStringTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.lang.String");
        this.th.checkPoint("trim()java.lang.String");
        this.test_trim();
        this.test_encoding();
        this.th.checkPoint("compareToIgnoreCase(java.lang.String)int");
        this.test_compareToIgnoreCase();
        this.th.checkPoint("compareTo(java.lang.String)int");
        this.test_compareTo2ndMethod();
        this.test_CASE_INSENSITIVE_ORDER();
        this.cygnustests();
        this.test_extra_lastIndexOf();
    }

    public void test_compareToIgnoreCase() {
        String s = new String("abc");
        boolean bl = false;
        if (s.compareToIgnoreCase("ABC") == 0) {
            bl = true;
        }
        this.th.check(bl, "test check small <--> capital\t1");
        boolean bl2 = false;
        if (s.compareToIgnoreCase("ABCa") == -1) {
            bl2 = true;
        }
        this.th.check(bl2, "test check small <--> capital\t2");
        boolean bl3 = false;
        if (s.compareToIgnoreCase("AB") == 1) {
            bl3 = true;
        }
        this.th.check(bl3, "test check small <--> capital\t3");
        boolean bl4 = false;
        if (s.compareToIgnoreCase("ABH") == -5) {
            bl4 = true;
        }
        this.th.check(bl4, "test check small <--> capital\t4");
        s = new String("AbCdEfG");
        boolean bl5 = false;
        if (s.compareToIgnoreCase("ABC") == 4) {
            bl5 = true;
        }
        this.th.check(bl5, "test check small <--> capital\t5");
        boolean bl6 = false;
        if (s.compareToIgnoreCase("abcdefg") == 0) {
            bl6 = true;
        }
        this.th.check(bl6, "test check small <--> capital\t6");
        boolean bl7 = false;
        if (s.compareToIgnoreCase("aBcDeFg") == 0) {
            bl7 = true;
        }
        this.th.check(bl7, "test check small <--> capital\t7");
        boolean bl8 = false;
        if (s.compareToIgnoreCase("ABH") == -5) {
            bl8 = true;
        }
        this.th.check(bl8, "test check small <--> capital\t8");
        s = new String("\u0393a\u03b2");
        boolean bl9 = false;
        if (s.compareToIgnoreCase("\u03b3A\u0392") == 0) {
            bl9 = true;
        }
        this.th.check(bl9, "test check small <--> capital\t9");
    }

    public void test_compareTo2ndMethod() {
        String s = new String("SmartMove");
        try {
            s.compareTo(new Object());
            this.th.fail("ClassCastException should be thrown");
        }
        catch (ClassCastException ce) {
            this.th.check(true);
        }
    }

    public void test_CASE_INSENSITIVE_ORDER() {
    }

    protected void test_trim() {
        String s = new String("\thelp\t");
        this.th.check(s.trim().equals("help"), "\\t is a white space !!");
        s = new String("\nhelp\n");
        this.th.check(s.trim().equals("help"), "\\n is a white space !!");
        s = new String("\u0019\u0018help\u0019\u0018");
        this.th.check(s.trim().equals("help"), "\\u0018 and \\u0019 are white space !!");
        s = new String("\u0017\u0016help\u0017\u0016");
        this.th.check(s.trim().equals("help"), "\\u0016 and \\u0017 are white space !!");
        s = new String("\u0015\u0014help\u0015\u0014");
        this.th.check(s.trim().equals("help"), "\\u0014 and \\u0015 are white space !!");
        s = new String("\u0013\u0012help\u0013\u0012");
        this.th.check(s.trim().equals("help"), "\\u0012 and \\u0013 are white space !!");
        s = new String("\u0011\u0010help\u0010\u0011");
        this.th.check(s.trim().equals("help"), "\\u0010 and \\u0011 are white space !!");
        s = new String("\u001a\u001bhelp\u001a\u001b");
        this.th.check(s.trim().equals("help"), "\\u001a and \\u001b are white space !!");
        s = new String("\u001c\u001dhelp\u001d\u001c");
        this.th.check(s.trim().equals("help"), "\\u001c and \\u001d are white space !!");
        s = new String(" \u001e\u001fhelp\u001f\u001e ");
        this.th.check(s.trim().equals("help"), "\\u001e, \\u001f and \\u0020 are  white space !!");
        s = new String("\u0000\u0001help\u0001\u0000");
        this.th.check(s.trim().equals("help"), "\\u0000 and \\u0001 are white space !!");
        s = new String("\u0002\u0003help\u0002\u0003");
        this.th.check(s.trim().equals("help"), "\\u0002 and \\u0003 are white space !!");
        s = new String("\u0004\u0005help\u0005\u0004");
        this.th.check(s.trim().equals("help"), "\\u0004 and \\u0005 are white space !!");
        s = new String("\u0006\u0007help\u0006\u0007");
        this.th.check(s.trim().equals("help"), "\\u0006 and \\u0007 are white space !!");
        s = new String("\b\thelp\t\b");
        this.th.check(s.trim().equals("help"), "\\u0008 and \\u0009 are  white space !!");
        s = new String("\u2008\u2009help\u2009\u2008");
        this.th.check(s.trim().equals("help") ^ true, "\\u2008 and \\u2009 are not white space !!");
        s = new String("\u2028\u2029\u3000help\u3000\u2029\u2028");
        this.th.check(s.trim().equals("help") ^ true, "\\u2028, \\u2029 and \\u3000 are not white space !!");
    }

    protected void test_encoding() {
        this.th.checkPoint("String(byte[],java.lang.String)");
        char[] cstr = new char[]{'a', 'b', 'c', '\t', 'A', 'B', 'C', ' ', '1', '2', '3'};
        byte[] bstr = new byte[cstr.length];
        int i = 0;
        while (i < cstr.length) {
            bstr[i] = (byte)cstr[i];
            ++i;
        }
        String a = new String(bstr);
        String b = new String(bstr, 3, 3);
        String c = "";
        String d = "";
        try {
            c = new String(bstr, "8859_1");
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        try {
            d = new String(bstr, 3, 3, "8859_1");
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        this.th.check(a, (Object)"abc\tABC 123");
        this.th.check(b, (Object)"\tAB");
        this.th.check(c, (Object)"abc\tABC 123");
        this.th.check(d, (Object)"\tAB");
        boolean ok = false;
        try {
            c = new String(bstr, "foobar8859_1");
        }
        catch (UnsupportedEncodingException ex) {
            ok = true;
        }
        this.th.check(ok);
        ok = false;
        try {
            d = new String(bstr, 3, 3, "foobar8859_1");
        }
        catch (UnsupportedEncodingException ex) {
            ok = true;
        }
        this.th.check(ok);
        this.th.check(String.copyValueOf(cstr), (Object)"abc\tABC 123");
        this.th.check(String.copyValueOf(cstr, 3, 3), (Object)"\tAB");
    }

    protected void cygnustests() {
        this.th.checkPoint("charAt(int)char");
        String b = new String(" abc\tABC 123\t");
        boolean ok = false;
        try {
            b.charAt(b.length());
        }
        catch (StringIndexOutOfBoundsException ex) {
            ok = true;
        }
        this.th.check(ok);
        ok = false;
        try {
            b.charAt(-1);
        }
        catch (StringIndexOutOfBoundsException ex) {
            ok = true;
        }
        this.th.check(ok);
        boolean bl = false;
        if (b.charAt(1) == 'a') {
            bl = true;
        }
        this.th.check(bl, "Error wrong return element !!");
        this.th.checkPoint("compareTo(java.lang.String)int");
        char[] cstr = new char[]{'a', 'b', 'c', '\t', 'A', 'B', 'C', ' ', '1', '2', '3'};
        String a = new String();
        String d = new String(cstr);
        String e = new String(cstr, 3, 3);
        this.th.check(d.compareTo(d), 0);
        this.th.check(d.compareTo(b.trim()), 0);
        this.th.check(d.compareTo(a), 11);
        this.th.check(d.compareTo(b), 65);
        this.th.check(d.compareTo(e), 88);
        this.th.check(d.toLowerCase().compareTo(d), 32);
        this.th.check(d.compareTo(d.substring(0, d.length() - 2)), 2);
        this.th.check(a.compareTo(d), -11);
        this.th.check(b.compareTo(d), -65);
        this.th.check(e.compareTo(d), -88);
        this.th.check(d.compareTo(d.toLowerCase()), -32);
        this.th.check(d.substring(0, d.length() - 2).compareTo(d), -2);
        this.th.check(b.charAt(7), 67);
        this.th.checkPoint("getBytes(java.lang.String)byte[]");
        String s = new String("test me");
        try {
            byte[] ba = s.getBytes("8859_1");
            this.th.check(ba.length, s.length());
        }
        catch (UnsupportedEncodingException _) {
            this.th.check(false);
        }
        this.th.checkPoint("hashCode()int");
        String c = new String(new StringBuffer("abc\tABC 123"));
        this.th.check(a.hashCode(), 0);
        this.th.check(b.hashCode(), -524164548);
        this.th.check(c.hashCode(), -822419571);
        this.th.checkPoint("indexOf(int)int");
        this.th.check(b.indexOf(32), 0);
        this.th.checkPoint("indexOf(int,int)int");
        this.th.check(b.indexOf(32, 1), 8);
        this.th.check(b.indexOf(32, 10), -1);
        this.th.check(b.indexOf(32, -1), 0);
        this.th.check(b.indexOf(32, b.length()), -1);
        this.th.check(b.indexOf("abc"), 1);
        this.th.check(b.indexOf("abc", 1), 1);
        this.th.check(b.indexOf("abc", 10), -1);
        this.th.checkPoint("lastIndexOf(int)int");
        this.th.check(b.lastIndexOf(32), 8);
        this.th.checkPoint("lastIndexOf(int,int)int");
        this.th.check(b.lastIndexOf(32, 1), 0);
        this.th.check(b.lastIndexOf(32, 10), 8);
        this.th.check(b.lastIndexOf(32, -1), -1);
        this.th.check(b.lastIndexOf(32, b.length()), 8);
        this.th.check(b.lastIndexOf("abc"), 1);
        this.th.check(b.lastIndexOf("abc", 1), 1);
        this.th.check(b.lastIndexOf("abc", 10), 1);
    }

    public void test_extra_lastIndexOf() {
        this.th.checkPoint("lastIndexOf(java.lang.String,int)int");
        String s = "";
        this.th.check(s.lastIndexOf("abc", 10), -1, "not there");
        this.th.check(s.lastIndexOf("", 10), 0, "is there ?");
        this.th.check(s.lastIndexOf("", 0), 0, "is there ?");
        this.th.check(s.lastIndexOf("", -1), -1, "not there");
        try {
            s.lastIndexOf(null, 1);
            this.th.fail("should throw NullPointerExcpetion");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        s = "acunia";
        this.th.check(s.lastIndexOf("abc", 10), -1, "not there");
        this.th.check(s.lastIndexOf("", 10), 6, "is there ?");
        this.th.check(s.lastIndexOf("", 0), 0, "is there ?");
        this.th.check(s.lastIndexOf("", -1), -1, "not there");
        this.th.check(s.lastIndexOf("ac", 10), 0, "not there");
        this.th.check(s.lastIndexOf("ia", 10), 4, "is there ?");
        this.th.check(s.lastIndexOf("ia", 2), -1, "is there ?");
        this.th.check(s.lastIndexOf("smartmove", 10), -1, "not there");
        this.th.check(s.lastIndexOf("a", 0), 0, "is there");
        this.th.check(s.lastIndexOf("a", 6), 5, "is there");
        this.th.check(s.lastIndexOf("a", 1), 0, "is there");
    }
}

