/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.Short;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

public class ShortTest
implements Testlet {
    protected static TestHarness harness;

    public void testConstructors() {
        harness.checkPoint("Short(short)");
        Short a = new Short(0);
        Short b = new Short(1);
        Short c = new Short(0);
        Short d = a;
        Short e = new Short(14);
        short fshort = 102;
        Short f = new Short(fshort);
        Short g = new Short(97);
        Integer i = new Integer(0);
        boolean bl = false;
        if (a != null) {
            bl = true;
        }
        harness.check(bl);
        harness.checkPoint("equals(java.lang.Object)boolean");
        harness.check(a.equals(null) ^ true);
        boolean bl2 = false;
        if (a != b) {
            bl2 = true;
        }
        harness.check(bl2);
        harness.check(a.equals(b) ^ true);
        boolean bl3 = false;
        if (a != c) {
            bl3 = true;
        }
        harness.check(bl3);
        harness.check(a.equals(c));
        boolean bl4 = false;
        if (a == d) {
            bl4 = true;
        }
        harness.check(bl4);
        harness.check(a.equals(d));
        boolean bl5 = false;
        if (a == a) {
            bl5 = true;
        }
        harness.check(bl5);
        harness.check(a.equals(i) ^ true);
        harness.checkPoint("shortValue()short");
        harness.check(a.shortValue(), 0);
        harness.check(a.shortValue(), a.shortValue());
        harness.check(a.shortValue(), c.shortValue());
        harness.check(a.shortValue(), d.shortValue());
        harness.check(a.shortValue(), i);
        harness.check(b.shortValue(), 1);
        harness.check(e.shortValue(), 14);
        harness.check(f.shortValue(), fshort);
        harness.check(g.shortValue(), 97);
        harness.check(g.shortValue(), 97);
        harness.check(g.shortValue(), 97);
        harness.checkPoint("MAX_VALUE(public)short");
        harness.check(Short.MAX_VALUE, Short.MAX_VALUE);
        harness.checkPoint("MIN_VALUE(public)short");
        harness.check(Short.MIN_VALUE, Short.MIN_VALUE);
        harness.checkPoint("Short(java.lang.String)");
        this.constructMustSucceed("1", 1);
        this.constructMustSucceed("32767", Short.MAX_VALUE);
        this.constructMustSucceed("-32768", Short.MIN_VALUE);
        this.constructMustFail("32768");
        this.constructMustFail("0x77");
        this.constructMustFail("10a");
        this.constructMustFail(" ");
        this.constructMustFail("");
        this.constructMustFail(null);
    }

    private final void constructMustSucceed(String line, int expected) {
        try {
            Short constructed = new Short(line);
            harness.check(constructed.shortValue(), expected);
        }
        catch (NumberFormatException e) {
            harness.fail("Could not construct desired value <" + line + '>');
        }
    }

    private final void constructMustFail(String line) {
        try {
            new Short(line);
            harness.fail("Attempt to construct out-of-range short < " + line + " > ");
        }
        catch (Exception e) {
            harness.check(true);
        }
    }

    public void testCompare() {
        Comparable<Character> cha2;
        Short cha1;
        harness.checkPoint("compareTo(java.lang.Short)int");
        this.checkCompare(100, 101);
        this.checkCompare(0, 101);
        this.checkCompare(-101, -100);
        this.checkCompare(-100, 0);
        this.checkCompare(-101, 100);
        this.checkCompare(55, 127);
        this.checkCompare(-128, -55);
        harness.checkPoint("compareTo(java.lang.Object)int");
        try {
            cha1 = new Short(97);
            boolean bl = false;
            if (cha1.compareTo(new Short(97)) == 0) {
                bl = true;
            }
            harness.check(bl);
        }
        catch (ClassCastException e) {
            harness.fail("Exception comparing two instances of class Byte ");
        }
        try {
            cha1 = new Short(97);
            cha2 = new Character('a');
            cha1.compareTo(cha2);
            harness.fail("Attempt to compare two different objects ");
        }
        catch (ClassCastException e) {
            harness.check(true);
        }
        try {
            cha1 = new Short(497);
            cha2 = new Integer(497);
            cha1.compareTo(cha2);
            harness.fail("Attempt to compare two different objects ");
        }
        catch (ClassCastException e) {
            harness.check(true);
        }
    }

    private final void checkCompare(int smallvalue, int bigvalue) {
        try {
            Short smallshort = new Short((short)smallvalue);
            Short bigshort = new Short((short)bigvalue);
            if (smallshort.compareTo(bigshort) > 0) {
                harness.fail("compareTo detected <" + smallvalue + "> bigger then <" + bigvalue + '>');
            } else if (smallshort.compareTo(bigshort) == 0) {
                harness.fail("compareTo detected <" + smallvalue + "> equal to <" + bigvalue + '>');
            } else {
                harness.check(true);
            }
            if (bigshort.compareTo(smallshort) < 0) {
                harness.fail("compareTo detected <" + bigvalue + "> smaller then <" + smallvalue + '>');
            } else if (bigshort.compareTo(smallshort) == 0) {
                harness.fail("compareTo detected <" + bigvalue + "> equal to <" + smallvalue + '>');
            } else {
                harness.check(true);
            }
            if (smallshort.compareTo(smallshort) != 0) {
                harness.fail("compareTo detected <" + smallvalue + "> not equal to itselves");
            } else {
                harness.check(true);
            }
            if (bigshort.compareTo(bigshort) != 0) {
                harness.fail("compareTo detected <" + bigvalue + "> not equal to itselves");
            } else {
                harness.check(true);
            }
        }
        catch (Exception e) {
            harness.fail("Exception while comparing <" + smallvalue + "> and <" + bigvalue + '>');
        }
    }

    public void testStringConversion() {
        harness.checkPoint("toString(short)java.lang.String");
        short ashort = 97;
        short zeroshort = 0;
        short negshort = -397;
        Short a = new Short(ashort);
        Short zero = new Short(0);
        Short negative = new Short(negshort);
        String astring = "97";
        String negstring = "-397";
        harness.check(zero.toString(), (Object)"0");
        harness.check(Short.toString(zeroshort), (Object)"0");
        harness.check(a.toString(), (Object)astring);
        harness.check(a.toString(), (Object)Short.toString(ashort));
        harness.check(negative.toString(), (Object)"-397");
        harness.check(negative.toString(), (Object)Short.toString(negshort));
        harness.checkPoint("decode(java.lang.String)java.lang.Short");
        this.decodeMustPass("11", 11);
        this.decodeMustPass("011", 9);
        this.decodeMustPass("#11", 17);
        this.decodeMustPass("0x11", 17);
        this.decodeMustPass("0x1FAB", 8107);
        this.decodeMustPass("0x1fab", 8107);
        this.decodeMustPass("-11", -11);
        this.decodeMustPass("-011", -9);
        this.decodeMustFail("0-11");
        this.decodeMustPass("-#11", -17);
        this.decodeMustFail("#-11");
        this.decodeMustPass("-0x11", -17);
        this.decodeMustFail("0x-11");
        this.decodeMustPass("0x7fff", Short.MAX_VALUE);
        this.decodeMustPass("0x7FFF", Short.MAX_VALUE);
        this.decodeMustFail("0x8000");
        this.decodeMustFail("-32769");
        this.decodeMustFail("019");
        this.decodeMustFail("122.5");
        this.decodeMustFail("4F");
        this.decodeMustFail("#4G");
        this.decodeMustFail("0x4G");
        this.decodeMustFail(" 11");
        this.decodeMustFail(" ");
        this.decodeMustFail("");
        this.decodeMustFail(null);
    }

    private final void decodeMustPass(String line, int checkvalue) {
        try {
            Short decoded = Short.decode(line);
            harness.check(decoded.intValue(), checkvalue);
        }
        catch (Exception e) {
            harness.fail("Exception while trying to decode string <" + line + '>');
        }
    }

    private final void decodeMustFail(String line) {
        try {
            Short.decode(line);
            harness.fail("Attempt to decode illegal string format <" + line + '>');
        }
        catch (Exception e) {
            harness.check(true);
        }
    }

    public void testStringValueParsing() {
        String astring = new String("100");
        Short target = new Short(100);
        harness.checkPoint("parseShort(java.lang.String)short");
        harness.check(Short.parseShort(astring), 100);
        harness.check(Short.valueOf(astring).equals(target));
        harness.check(Short.parseShort("-34"), -34);
        harness.check(Short.valueOf("-56").intValue(), -56);
        harness.check(Short.parseShort("32767"), Short.MAX_VALUE);
        harness.check(Short.valueOf("32767").equals(new Short(Short.MAX_VALUE)));
        harness.check(Short.parseShort("-32768"), Short.MIN_VALUE);
        harness.check(Short.valueOf("-32768").equals(new Short(Short.MIN_VALUE)));
        harness.checkPoint("valueOf(java.lang.String)java.lang.Short");
        this.parseCheckMustFail(" 60  ", 10);
        this.valueCheckMustFail(" 60  ", 10);
        this.parseCheckMustFail("32768", 10);
        this.valueCheckMustFail("32768", 10);
        this.parseCheckMustFail("#60", 10);
        this.valueCheckMustFail("#60", 10);
        this.parseCheckMustFail("0x60", 10);
        this.valueCheckMustFail("0x60", 10);
        harness.check(Short.parseShort("12", 10), Short.parseShort("12"));
        harness.check(Short.parseShort("-34", 10), Short.parseShort("-34"));
        harness.check(Short.valueOf("56", 10), Short.valueOf("56"));
        harness.check(Short.valueOf("-78", 10), Short.valueOf("-78"));
        harness.check(Short.parseShort("11", 2), Short.parseShort("3"), "parseShort binary ");
        harness.check(Short.parseShort("-11", 2), Short.parseShort("-3"), "parseShort binary negative");
        harness.check(Short.valueOf("11", 2), Short.valueOf("3"), "valueOf binary ");
        harness.check(Short.valueOf("-11", 2), Short.valueOf("-3"), "valueOf binary negative");
        harness.check(Short.parseShort("11", 3), Short.parseShort("4"), "parseShort 3-based ");
        harness.check(Short.parseShort("-11", 3), Short.parseShort("-4"), "parseShort 3-based negative");
        harness.check(Short.valueOf("11", 3), Short.valueOf("4"), "valueOf 3-based ");
        harness.check(Short.valueOf("-11", 3), Short.valueOf("-4"), "valueOf 3-based negative");
        harness.check(Short.parseShort("11", 8), Short.parseShort("9"), "parseShort octal ");
        harness.check(Short.parseShort("-11", 8), Short.parseShort("-9"), "parseShort octal negative");
        harness.check(Short.valueOf("11", 8), Short.valueOf("9"), "valueOf octal ");
        harness.check(Short.valueOf("-11", 8), Short.valueOf("-9"), "valueOf octal negative");
        harness.check(Short.parseShort("11", 16), Short.parseShort("17"), "parseShort hex ");
        harness.check(Short.parseShort("-11", 16), Short.parseShort("-17"), "parseShort hex negative");
        harness.check(Short.valueOf("11", 16), Short.valueOf("17"), "valueOf hex ");
        harness.check(Short.valueOf("-11", 16), Short.valueOf("-17"), "valueOf hex negative");
        harness.check(Short.parseShort("f", 16), Short.parseShort("15"), "parseShort hex ");
        harness.check(Short.parseShort("-f", 16), Short.parseShort("-15"), "parseShort hex negative");
        harness.check(Short.parseShort("F", 16), Short.parseShort("15"), "parseShort hex capital");
        harness.check(Short.valueOf("f", 16), Short.valueOf("15"), "valueOf hex ");
        harness.check(Short.valueOf("-f", 16), Short.valueOf("-15"), "valueOf hex negative");
        harness.check(Short.valueOf("F", 16), Short.valueOf("15"), "valueOf hex capital");
        harness.check(Short.parseShort("11", 25), Short.parseShort("26"), "parseShort 25-based ");
        harness.check(Short.parseShort("-11", 25), Short.parseShort("-26"), "parseShort 25-based negative");
        harness.check(Short.valueOf("11", 25), Short.valueOf("26"), "valueOf 25-based ");
        harness.check(Short.valueOf("-11", 25), Short.valueOf("-26"), "valueOf 25-based negative");
        harness.check(Short.parseShort("o", 25), Short.parseShort("24"), "parseShort 25-based ");
        harness.check(Short.parseShort("O", 25), Short.parseShort("24"), "parseShort 25-based capital");
        harness.check(Short.parseShort("-o", 25), Short.parseShort("-24"), "parseShort 25-based negative");
        harness.check(Short.valueOf("o", 25), Short.valueOf("24"), "valueOf 25-based ");
        harness.check(Short.valueOf("O", 25), Short.valueOf("24"), "valueOf 25-based capital");
        harness.check(Short.valueOf("-o", 25), Short.valueOf("-24"), "valueOf 25-based negative");
        harness.check(Short.parseShort("11", 36), Short.parseShort("37"), "parseShort 36-based ");
        harness.check(Short.parseShort("-11", 36), Short.parseShort("-37"), "parseShort 36-based negative");
        harness.check(Short.valueOf("11", 36), Short.valueOf("37"), "valueOf 36-based ");
        harness.check(Short.valueOf("-11", 36), Short.valueOf("-37"), "valueOf 36-based negative");
        harness.check(Short.parseShort("z", 36), Short.parseShort("35"), "parseShort 36-based ");
        harness.check(Short.parseShort("Z", 36), Short.parseShort("35"), "parseShort 36-based capital");
        harness.check(Short.parseShort("-z", 36), Short.parseShort("-35"), "parseShort 36-based negative");
        harness.check(Short.valueOf("z", 36), Short.valueOf("35"), "valueOf 36-based ");
        harness.check(Short.valueOf("Z", 36), Short.valueOf("35"), "valueOf 36-based capital");
        harness.check(Short.valueOf("-z", 36), Short.valueOf("-35"), "valueOf 36-based negative");
        this.parseCheckMustFail(" 11  ", 2);
        this.valueCheckMustFail(" 11  ", 2);
        this.parseCheckMustFail(" 11  ", 3);
        this.valueCheckMustFail(" 11  ", 3);
        this.parseCheckMustFail(" 11  ", 8);
        this.valueCheckMustFail(" 11  ", 8);
        this.parseCheckMustFail(" 11  ", 16);
        this.valueCheckMustFail(" 11  ", 16);
        this.parseCheckMustFail(" 11  ", 25);
        this.valueCheckMustFail(" 11  ", 25);
        this.parseCheckMustFail(" 11  ", 36);
        this.valueCheckMustFail(" 11  ", 36);
        this.parseCheckMustFail("11", 1);
        this.valueCheckMustFail("11", 1);
        this.parseCheckMustFail("11", 37);
        this.valueCheckMustFail("11", 37);
        this.parseCheckMustFail("3", 2);
        this.valueCheckMustFail("3", 2);
        this.parseCheckMustFail("5", 4);
        this.valueCheckMustFail("5", 4);
        this.parseCheckMustFail("9", 8);
        this.valueCheckMustFail("9", 8);
        this.parseCheckMustFail("g", 16);
        this.valueCheckMustFail("g", 16);
        this.parseCheckMustFail("z", 35);
        this.valueCheckMustFail("z", 35);
        this.parseCheckMustFail("1000000000000000", 2);
        this.valueCheckMustFail("1000000000000000", 2);
        this.parseCheckMustFail("100000", 8);
        this.valueCheckMustFail("100000", 8);
        this.parseCheckMustFail("8000", 16);
        this.valueCheckMustFail("8000", 16);
        this.parseCheckMustFail("1000", 32);
        this.valueCheckMustFail("1000", 32);
        this.parseCheckMustFail("-1000000000000001", 2);
        this.valueCheckMustFail("-1000000000000001", 2);
        this.parseCheckMustFail("-100001", 8);
        this.valueCheckMustFail("-100001", 8);
        this.parseCheckMustFail("-8001", 16);
        this.valueCheckMustFail("-8001", 16);
        this.parseCheckMustFail("-1001", 32);
        this.valueCheckMustFail("-1001", 32);
    }

    private final void parseCheckMustFail(String line, int radix) {
        try {
            Short.parseShort(line, radix);
            harness.fail("Attempt to parse illegal short string <" + line + '>');
        }
        catch (NumberFormatException e) {
            harness.check(true);
        }
    }

    private final void valueCheckMustFail(String line, int radix) {
        try {
            Short.valueOf(line, radix);
            harness.fail("Attempt to get value from illegal short string <" + line + '>');
        }
        catch (NumberFormatException e) {
            harness.check(true);
        }
    }

    public void testValueConversion() {
        Short zero = new Short(0);
        Short ashort = new Short(97);
        Short min = new Short(Short.MIN_VALUE);
        Short max = new Short(Short.MAX_VALUE);
        harness.checkPoint("Value conversions");
        boolean bl = false;
        if (zero.byteValue() == 0) {
            bl = true;
        }
        harness.check(bl);
        boolean bl2 = false;
        if (ashort.byteValue() == 97) {
            bl2 = true;
        }
        harness.check(bl2);
        boolean bl3 = false;
        if (max.byteValue() == -1) {
            bl3 = true;
        }
        harness.check(bl3);
        boolean bl4 = false;
        if (min.byteValue() == 0) {
            bl4 = true;
        }
        harness.check(bl4);
        boolean bl5 = false;
        if (zero == 0) {
            bl5 = true;
        }
        harness.check(bl5);
        boolean bl6 = false;
        if (ashort == 97) {
            bl6 = true;
        }
        harness.check(bl6);
        boolean bl7 = false;
        if (ashort.shortValue() == ashort.shortValue()) {
            bl7 = true;
        }
        harness.check(bl7);
        boolean bl8 = false;
        if (max == Short.MAX_VALUE) {
            bl8 = true;
        }
        harness.check(bl8);
        boolean bl9 = false;
        if (min == Short.MIN_VALUE) {
            bl9 = true;
        }
        harness.check(bl9);
        boolean bl10 = false;
        if (zero.intValue() == 0) {
            bl10 = true;
        }
        harness.check(bl10);
        boolean bl11 = false;
        if (ashort.intValue() == 97) {
            bl11 = true;
        }
        harness.check(bl11);
        boolean bl12 = false;
        if (ashort.intValue() == ashort.shortValue()) {
            bl12 = true;
        }
        harness.check(bl12);
        boolean bl13 = false;
        if (max.intValue() == Short.MAX_VALUE) {
            bl13 = true;
        }
        harness.check(bl13);
        boolean bl14 = false;
        if (min.intValue() == Short.MIN_VALUE) {
            bl14 = true;
        }
        harness.check(bl14);
        boolean bl15 = false;
        if (zero.longValue() == 0L) {
            bl15 = true;
        }
        harness.check(bl15);
        boolean bl16 = false;
        if (ashort.longValue() == 97L) {
            bl16 = true;
        }
        harness.check(bl16);
        boolean bl17 = false;
        if (ashort.longValue() == (long)ashort.shortValue()) {
            bl17 = true;
        }
        harness.check(bl17);
        boolean bl18 = false;
        if (max.longValue() == 32767L) {
            bl18 = true;
        }
        harness.check(bl18);
        boolean bl19 = false;
        if (min.longValue() == -32768L) {
            bl19 = true;
        }
        harness.check(bl19);
        boolean bl20 = false;
        if (zero.floatValue() == 0.0f) {
            bl20 = true;
        }
        harness.check(bl20);
        boolean bl21 = false;
        if (ashort.floatValue() == 97.0f) {
            bl21 = true;
        }
        harness.check(bl21);
        boolean bl22 = false;
        if (ashort.floatValue() == (float)ashort.shortValue()) {
            bl22 = true;
        }
        harness.check(bl22);
        boolean bl23 = false;
        if (max.floatValue() == 32767.0f) {
            bl23 = true;
        }
        harness.check(bl23);
        boolean bl24 = false;
        if (min.floatValue() == -32768.0f) {
            bl24 = true;
        }
        harness.check(bl24);
        boolean bl25 = false;
        if (zero.doubleValue() == 0.0) {
            bl25 = true;
        }
        harness.check(bl25);
        boolean bl26 = false;
        if (ashort.doubleValue() == 97.0) {
            bl26 = true;
        }
        harness.check(bl26);
        boolean bl27 = false;
        if (ashort.doubleValue() == (double)ashort.shortValue()) {
            bl27 = true;
        }
        harness.check(bl27);
        boolean bl28 = false;
        if (max.doubleValue() == 32767.0) {
            bl28 = true;
        }
        harness.check(bl28);
        boolean bl29 = false;
        if (min.doubleValue() == -32768.0) {
            bl29 = true;
        }
        harness.check(bl29);
    }

    public void testHashCode() {
        Short a = new Short(97);
        Short b = new Short(-439);
        Short zero = new Short(0);
        Short newa = new Short(97);
        harness.checkPoint("hashCode()int");
        harness.check(a.hashCode(), newa.hashCode());
        harness.check(a.hashCode(), 97);
        harness.check(zero.hashCode(), 0);
        harness.check(b.hashCode(), -439);
    }

    public void testGetClass() {
        Short a = new Short(97);
        Short b = new Short(0);
        Integer i = new Integer(0);
        harness.checkPoint("TYPE(public)java.lang.Class");
        try {
            harness.check(a instanceof Short);
            harness.check(b instanceof Short);
            harness.check(a.getClass().getName(), (Object)"java.lang.Short");
            harness.check(b.getClass().getName(), (Object)"java.lang.Short");
            harness.check(a.getClass(), Class.forName("java.lang.Short"));
            harness.check(b.getClass(), Class.forName("java.lang.Short"));
            boolean bl = false;
            if (i.getClass() != Class.forName("java.lang.Short")) {
                bl = true;
            }
            harness.check(bl);
            harness.check(a.getClass(), b.getClass());
            boolean bl2 = false;
            if (a.getClass() != i.getClass()) {
                bl2 = true;
            }
            harness.check(bl2);
            harness.check(Short.TYPE.getName(), (Object)"short");
        }
        catch (ClassNotFoundException e) {
            harness.fail("error finding class name");
            harness.debug(e);
        }
    }

    public void test(TestHarness newharness) {
        harness = newharness;
        harness.setclass("java.lang.Short");
        this.testConstructors();
        this.testCompare();
        this.testStringConversion();
        this.testStringValueParsing();
        this.testValueConversion();
        this.testHashCode();
        this.testGetClass();
    }
}

