/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.Number;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

public class PrimitiveConversionTest
implements Testlet {
    static final byte bnull = 0;
    static final short snull = 0;
    static final char cnull = '\u0000';
    static final int inull = 0;
    static final byte bmax = 127;
    static final byte bmin = -128;
    static final short smaxbyte = 127;
    static final short sminbyte = -128;
    static final char cmaxbyte = '\u007f';
    static final int imaxbyte = 127;
    static final int iminbyte = -128;
    static final short smax = Short.MAX_VALUE;
    static final short smin = Short.MIN_VALUE;
    static final char cmaxshort = Short.MAX_VALUE;
    static final int imaxshort = Short.MAX_VALUE;
    static final int iminshort = Short.MIN_VALUE;
    static final char cmax = '\uffff';
    static final int imaxchar = 65535;
    TestHarness harness;

    private final void testAssignmentWidening() {
        char bp = '\u007f';
        char c = '\uffffff80';
        this.harness.checkPoint("AssignmentWidening : byte to short, int, long, float, double...");
        char s = bp;
        boolean bl = false;
        if (s == '\u007f') {
            bl = true;
        }
        this.harness.check(bl, "widening byte to short");
        s = c;
        boolean bl2 = false;
        if (s == '\uffffff80') {
            bl2 = true;
        }
        this.harness.check(bl2, "widening byte to short");
        char i = bp;
        boolean bl3 = false;
        if (i == '\u007f') {
            bl3 = true;
        }
        this.harness.check(bl3, "widening byte to int");
        i = c;
        boolean bl4 = false;
        if (i == '\uffffff80') {
            bl4 = true;
        }
        this.harness.check(bl4, "widening byte to int");
        long l = bp;
        boolean bl5 = false;
        if (l == 127L) {
            bl5 = true;
        }
        this.harness.check(bl5, "widening byte to long");
        l = c;
        boolean bl6 = false;
        if (l == -128L) {
            bl6 = true;
        }
        this.harness.check(bl6, "widening byte to long");
        float f = bp;
        boolean bl7 = false;
        if (f == 127.0f) {
            bl7 = true;
        }
        this.harness.check(bl7, "widening byte to float");
        f = c;
        boolean bl8 = false;
        if (f == -128.0f) {
            bl8 = true;
        }
        this.harness.check(bl8, "widening byte to float");
        double d = bp;
        boolean bl9 = false;
        if (d == 127.0) {
            bl9 = true;
        }
        this.harness.check(bl9, "widening byte to double");
        d = c;
        boolean bl10 = false;
        if (d == -128.0) {
            bl10 = true;
        }
        this.harness.check(bl10, "widening byte to double");
        char c2 = Short.MAX_VALUE;
        char c3 = Short.MIN_VALUE;
        this.harness.checkPoint("AssignmentWidening : short to int, long, float, double...");
        i = c2;
        boolean bl11 = false;
        if (i == Short.MAX_VALUE) {
            bl11 = true;
        }
        this.harness.check(bl11, "widening short to int");
        i = c3;
        boolean bl12 = false;
        if (i == Short.MIN_VALUE) {
            bl12 = true;
        }
        this.harness.check(bl12, "widening short to int");
        l = c2;
        boolean bl13 = false;
        if (l == 32767L) {
            bl13 = true;
        }
        this.harness.check(bl13, "widening short to long");
        l = c3;
        boolean bl14 = false;
        if (l == -32768L) {
            bl14 = true;
        }
        this.harness.check(bl14, "widening short to long");
        f = c2;
        boolean bl15 = false;
        if (f == 32767.0f) {
            bl15 = true;
        }
        this.harness.check(bl15, "widening short to float");
        f = c3;
        boolean bl16 = false;
        if (f == -32768.0f) {
            bl16 = true;
        }
        this.harness.check(bl16, "widening short to float");
        d = c2;
        boolean bl17 = false;
        if (d == 32767.0) {
            bl17 = true;
        }
        this.harness.check(bl17, "widening short to double");
        d = c3;
        boolean bl18 = false;
        if (d == -32768.0) {
            bl18 = true;
        }
        this.harness.check(bl18, "widening short to double");
        char cp = (char)-1;
        char cn = '\u0000';
        this.harness.checkPoint("AssignmentWidening : char to int, long, float, double...");
        i = cp;
        boolean bl19 = false;
        if (i == (char)-1) {
            bl19 = true;
        }
        this.harness.check(bl19, "widening char to int");
        i = cn;
        boolean bl20 = false;
        if (i == '\u0000') {
            bl20 = true;
        }
        this.harness.check(bl20, "widening char to int");
        l = cp;
        boolean bl21 = false;
        if (l == 65535L) {
            bl21 = true;
        }
        this.harness.check(bl21, "widening char to long");
        l = cn;
        boolean bl22 = false;
        if (l == 0L) {
            bl22 = true;
        }
        this.harness.check(bl22, "widening char to long");
        f = cp;
        boolean bl23 = false;
        if (f == 65535.0f) {
            bl23 = true;
        }
        this.harness.check(bl23, "widening char to float");
        f = cn;
        boolean bl24 = false;
        if (f == 0.0f) {
            bl24 = true;
        }
        this.harness.check(bl24, "widening char to float");
        d = cp;
        boolean bl25 = false;
        if (d == 65535.0) {
            bl25 = true;
        }
        this.harness.check(bl25, "widening char to double");
        d = cn;
        boolean bl26 = false;
        if (d == 0.0) {
            bl26 = true;
        }
        this.harness.check(bl26, "widening char to double");
        int oneAndHalfGiga = 1500000000;
        int minusOneGiga = -1000000000;
        int caesar = -15;
        int napoleon = 1815;
        this.harness.checkPoint("AssignmentWidening : int to long, float, double...");
        l = oneAndHalfGiga;
        boolean bl27 = false;
        if (l == 1500000000L) {
            bl27 = true;
        }
        this.harness.check(bl27, "widening int to long");
        l = minusOneGiga;
        boolean bl28 = false;
        if (l == -1000000000L) {
            bl28 = true;
        }
        this.harness.check(bl28, "widening int to long");
        l = caesar;
        boolean bl29 = false;
        if (l == -15L) {
            bl29 = true;
        }
        this.harness.check(bl29, "widening int to long");
        l = napoleon;
        boolean bl30 = false;
        if (l == 1815L) {
            bl30 = true;
        }
        this.harness.check(bl30, "widening int to long");
        f = oneAndHalfGiga;
        boolean bl31 = false;
        if (f == 1.5E9f) {
            bl31 = true;
        }
        this.harness.check(bl31, "widening int to float");
        f = minusOneGiga;
        boolean bl32 = false;
        if (f == -1.0E9f) {
            bl32 = true;
        }
        this.harness.check(bl32, "widening int to float");
        f = caesar;
        boolean bl33 = false;
        if (f == -15.0f) {
            bl33 = true;
        }
        this.harness.check(bl33, "widening int to float");
        f = napoleon;
        boolean bl34 = false;
        if (f == 1815.0f) {
            bl34 = true;
        }
        this.harness.check(bl34, "widening int to float");
        d = oneAndHalfGiga;
        boolean bl35 = false;
        if (d == 1.5E9) {
            bl35 = true;
        }
        this.harness.check(bl35, "widening int to double");
        d = minusOneGiga;
        boolean bl36 = false;
        if (d == -1.0E9) {
            bl36 = true;
        }
        this.harness.check(bl36, "widening int to double");
        d = caesar;
        boolean bl37 = false;
        if (d == -15.0) {
            bl37 = true;
        }
        this.harness.check(bl37, "widening int to double");
        d = napoleon;
        boolean bl38 = false;
        if (d == 1815.0) {
            bl38 = true;
        }
        this.harness.check(bl38, "widening int to double");
        long elevenFourTerra = 11400000000000L;
        long minusSevenTerra = -7000000000000L;
        long Friendswood = 77546L;
        long HulsteDorp = -8531L;
        this.harness.checkPoint("AssignmentWidening : long to float, double...");
        f = elevenFourTerra;
        boolean bl39 = false;
        if (f == 1.14E13f) {
            bl39 = true;
        }
        this.harness.check(bl39, "widening long to float");
        f = minusSevenTerra;
        boolean bl40 = false;
        if (f == -7.0E12f) {
            bl40 = true;
        }
        this.harness.check(bl40, "widening long to float");
        f = Friendswood;
        boolean bl41 = false;
        if (f == 77546.0f) {
            bl41 = true;
        }
        this.harness.check(bl41, "widening long to float");
        f = HulsteDorp;
        boolean bl42 = false;
        if (f == -8531.0f) {
            bl42 = true;
        }
        this.harness.check(bl42, "widening long to float");
        d = elevenFourTerra;
        boolean bl43 = false;
        if (d == 1.14E13) {
            bl43 = true;
        }
        this.harness.check(bl43, "widening long to double");
        d = minusSevenTerra;
        boolean bl44 = false;
        if (d == -7.0E12) {
            bl44 = true;
        }
        this.harness.check(bl44, "widening long to double");
        d = Friendswood;
        boolean bl45 = false;
        if (d == 77546.0) {
            bl45 = true;
        }
        this.harness.check(bl45, "widening long to double");
        d = HulsteDorp;
        boolean bl46 = false;
        if (d == -8531.0) {
            bl46 = true;
        }
        this.harness.check(bl46, "widening long to double");
        float posCharge = 1.9E-23f;
        float negCharge = -1.9E-23f;
        float smallest = Float.MIN_VALUE;
        float biggest = Float.MAX_VALUE;
        float nan = Float.NaN;
        float posInfinite = Float.POSITIVE_INFINITY;
        float negInfinite = Float.NEGATIVE_INFINITY;
        this.harness.checkPoint("AssignmentWidening : float to double...");
        d = posCharge;
        this.harness.check(this.inRange(1.9, -23, d), "widening float to double ");
        d = negCharge;
        this.harness.check(this.inRange(-1.9, -23, d), "widening float to double ");
        d = smallest;
        this.harness.check(this.inRange(1.4012984, -45, d), "widening float to double " + d);
        d = biggest;
        this.harness.check(this.inRange(3.4028234, 38, d), "widening float to double " + d);
        d = nan;
        this.harness.check(Double.isNaN(d), "widening float to double " + d);
        d = posInfinite;
        boolean bl47 = false;
        if (d == Double.POSITIVE_INFINITY) {
            bl47 = true;
        }
        this.harness.check(bl47, "widening float to double" + d);
        d = negInfinite;
        boolean bl48 = false;
        if (d == Double.NEGATIVE_INFINITY) {
            bl48 = true;
        }
        this.harness.check(bl48, "widening float to double" + d);
    }

    private final void testAssignmentNarrowing() {
        this.harness.checkPoint("AssignmentNarrowing :  short, char, int, long, narrowed into byte");
        int b = 0;
        boolean bl = false;
        if (b == 0) {
            bl = true;
        }
        this.harness.check(bl, "int=>byte, byte=(+)0");
        b = 0;
        boolean bl2 = false;
        if (b == 0) {
            bl2 = true;
        }
        this.harness.check(bl2, "char=>byte, byte=(+)0");
        b = 0;
        boolean bl3 = false;
        if (b == 0) {
            bl3 = true;
        }
        this.harness.check(bl3, "short=>byte, byte=(+)0");
        b = 127;
        boolean bl4 = false;
        if (b == 127) {
            bl4 = true;
        }
        this.harness.check(bl4, "(+)int=>byte, byte=>0");
        b = 127;
        boolean bl5 = false;
        if (b == 127) {
            bl5 = true;
        }
        this.harness.check(bl5, "(+)char=>byte, byte>0");
        b = 127;
        boolean bl6 = false;
        if (b == 127) {
            bl6 = true;
        }
        this.harness.check(bl6, "(+)short=>byte, byte>0");
        b = -128;
        boolean bl7 = false;
        if (b == -128) {
            bl7 = true;
        }
        this.harness.check(bl7, "(+)int=>byte, byte=<0");
        b = -128;
        boolean bl8 = false;
        if (b == -128) {
            bl8 = true;
        }
        this.harness.check(bl8, "(+)int=>byte, byte=<0");
        this.harness.checkPoint("AssignmentNarrowing :   char, int, long, narrowed into short");
        int s = 0;
        boolean bl9 = false;
        if (s == 0) {
            bl9 = true;
        }
        this.harness.check(bl9, "int=>short, short=(+)0");
        s = 0;
        boolean bl10 = false;
        if (s == 0) {
            bl10 = true;
        }
        this.harness.check(bl10, "char=>short, short=(+)0");
        s = Short.MAX_VALUE;
        boolean bl11 = false;
        if (s == Short.MAX_VALUE) {
            bl11 = true;
        }
        this.harness.check(bl11, "(+)int=>short, short=" + s + " instead of 4095");
        s = Short.MAX_VALUE;
        boolean bl12 = false;
        if (s == Short.MAX_VALUE) {
            bl12 = true;
        }
        this.harness.check(bl12, "(+)char=>short, short=" + s + " instead of 4095");
        s = Short.MIN_VALUE;
        boolean bl13 = false;
        if (s == Short.MIN_VALUE) {
            bl13 = true;
        }
        this.harness.check(bl13, "(+)int=>short, short=" + s + " instead of 4095");
        this.harness.checkPoint("AssignmentNarrowing :   short, int, long, narrowed into char");
        char c = '\u0000';
        boolean bl14 = false;
        if (c == '\u0000') {
            bl14 = true;
        }
        this.harness.check(bl14, "int=>char, char=(+)0");
        c = '\u0000';
        boolean bl15 = false;
        if (c == '\u0000') {
            bl15 = true;
        }
        this.harness.check(bl15, "short=>char, char=(+)0");
        c = (char)-1;
        boolean bl16 = false;
        if (c == (char)-1) {
            bl16 = true;
        }
        this.harness.check(bl16, "(+)int=>char, char=" + c + " instead of 4095");
        c = (char)Short.MAX_VALUE;
        boolean bl17 = false;
        if (c == Short.MAX_VALUE) {
            bl17 = true;
        }
        this.harness.check(bl17, "(+)short=>char, char=" + c + " instead of 4095");
        c = '\u0000';
        boolean bl18 = false;
        if (c == '\u0000') {
            bl18 = true;
        }
        this.harness.check(bl18, "(-)int=>char, char=" + c + " instead of 4095");
        c = (char)127;
        boolean bl19 = false;
        if (c == '\u007f') {
            bl19 = true;
        }
        this.harness.check(bl19, "(-)int=>char, char=" + c + " instead of 4095");
    }

    private final byte b_Positive() {
        return 127;
    }

    private final byte b_Negative() {
        return -128;
    }

    private final short s_Positive() {
        return Short.MAX_VALUE;
    }

    private final short s_Negative() {
        return Short.MIN_VALUE;
    }

    private final char c_Positive() {
        return (char)-1;
    }

    private final char c_Negative() {
        return '\u0000';
    }

    private final int i_OneAndHalfGiga() {
        return 1500000000;
    }

    private final int i_MinusOneGiga() {
        return -1000000000;
    }

    private final int i_Napoleon() {
        return 1815;
    }

    private final int i_Caesar() {
        return -15;
    }

    private final long l_elevenFourTerra() {
        return 11400000000000L;
    }

    private final long l_minusSevenTerra() {
        return -7000000000000L;
    }

    private final long l_Friendswood() {
        return 77546L;
    }

    private final long l_HulsteDorp() {
        return -8531L;
    }

    private final float f_PosCharge() {
        return 1.9E-23f;
    }

    private final float f_NegCharge() {
        return -1.9E-23f;
    }

    private final float f_Smallest() {
        return Float.MIN_VALUE;
    }

    private final float f_Biggest() {
        return Float.MAX_VALUE;
    }

    private final float f_Nan() {
        return Float.NaN;
    }

    private final float f_PosInfinite() {
        return Float.POSITIVE_INFINITY;
    }

    private final float f_NegInfinite() {
        return Float.NEGATIVE_INFINITY;
    }

    private final void testInvocationWidening() {
        this.harness.checkPoint("Invocation Widening : byte to short, int, long, float, double...");
        byte s = this.b_Positive();
        boolean bl = false;
        if (s == 127) {
            bl = true;
        }
        this.harness.check(bl, "widening byte to short");
        s = this.b_Negative();
        boolean bl2 = false;
        if (s == -128) {
            bl2 = true;
        }
        this.harness.check(bl2, "widening byte to short");
        short i = this.b_Positive();
        boolean bl3 = false;
        if (i == 127) {
            bl3 = true;
        }
        this.harness.check(bl3, "widening byte to int");
        i = this.b_Negative();
        boolean bl4 = false;
        if (i == -128) {
            bl4 = true;
        }
        this.harness.check(bl4, "widening byte to int");
        long l = this.b_Positive();
        boolean bl5 = false;
        if (l == 127L) {
            bl5 = true;
        }
        this.harness.check(bl5, "widening byte to long");
        l = this.b_Negative();
        boolean bl6 = false;
        if (l == -128L) {
            bl6 = true;
        }
        this.harness.check(bl6, "widening byte to long");
        float f = this.b_Positive();
        boolean bl7 = false;
        if (f == 127.0f) {
            bl7 = true;
        }
        this.harness.check(bl7, "widening byte to float");
        f = this.b_Negative();
        boolean bl8 = false;
        if (f == -128.0f) {
            bl8 = true;
        }
        this.harness.check(bl8, "widening byte to float");
        double d = this.b_Positive();
        boolean bl9 = false;
        if (d == 127.0) {
            bl9 = true;
        }
        this.harness.check(bl9, "widening byte to double");
        d = this.b_Negative();
        boolean bl10 = false;
        if (d == -128.0) {
            bl10 = true;
        }
        this.harness.check(bl10, "widening byte to double");
        this.harness.checkPoint("Invocation Widening : short to int, long, float, double...");
        i = this.s_Positive();
        boolean bl11 = false;
        if (i == Short.MAX_VALUE) {
            bl11 = true;
        }
        this.harness.check(bl11, "widening short to int");
        i = this.s_Negative();
        boolean bl12 = false;
        if (i == Short.MIN_VALUE) {
            bl12 = true;
        }
        this.harness.check(bl12, "widening short to int");
        l = this.s_Positive();
        boolean bl13 = false;
        if (l == 32767L) {
            bl13 = true;
        }
        this.harness.check(bl13, "widening short to long");
        l = this.s_Negative();
        boolean bl14 = false;
        if (l == -32768L) {
            bl14 = true;
        }
        this.harness.check(bl14, "widening short to long");
        f = this.s_Positive();
        boolean bl15 = false;
        if (f == 32767.0f) {
            bl15 = true;
        }
        this.harness.check(bl15, "widening short to float");
        f = this.s_Negative();
        boolean bl16 = false;
        if (f == -32768.0f) {
            bl16 = true;
        }
        this.harness.check(bl16, "widening short to float");
        d = this.s_Positive();
        boolean bl17 = false;
        if (d == 32767.0) {
            bl17 = true;
        }
        this.harness.check(bl17, "widening short to double");
        d = this.s_Negative();
        boolean bl18 = false;
        if (d == -32768.0) {
            bl18 = true;
        }
        this.harness.check(bl18, "widening short to double");
        this.harness.checkPoint("Invocation Widening : char to int, long, float, double...");
        i = (short)this.c_Positive();
        boolean bl19 = false;
        if (i == (char)-1) {
            bl19 = true;
        }
        this.harness.check(bl19, "widening char to int");
        i = (short)this.c_Negative();
        boolean bl20 = false;
        if (i == 0) {
            bl20 = true;
        }
        this.harness.check(bl20, "widening char to int");
        l = this.c_Positive();
        boolean bl21 = false;
        if (l == 65535L) {
            bl21 = true;
        }
        this.harness.check(bl21, "widening char to long");
        l = this.c_Negative();
        boolean bl22 = false;
        if (l == 0L) {
            bl22 = true;
        }
        this.harness.check(bl22, "widening char to long");
        f = this.c_Positive();
        boolean bl23 = false;
        if (f == 65535.0f) {
            bl23 = true;
        }
        this.harness.check(bl23, "widening char to float");
        f = this.c_Negative();
        boolean bl24 = false;
        if (f == 0.0f) {
            bl24 = true;
        }
        this.harness.check(bl24, "widening char to float");
        d = this.c_Positive();
        boolean bl25 = false;
        if (d == 65535.0) {
            bl25 = true;
        }
        this.harness.check(bl25, "widening char to double");
        d = this.c_Negative();
        boolean bl26 = false;
        if (d == 0.0) {
            bl26 = true;
        }
        this.harness.check(bl26, "widening char to double");
        this.harness.checkPoint("Invocation Widening : int to long, float, double...");
        l = this.i_OneAndHalfGiga();
        boolean bl27 = false;
        if (l == 1500000000L) {
            bl27 = true;
        }
        this.harness.check(bl27, "widening int to long");
        l = this.i_MinusOneGiga();
        boolean bl28 = false;
        if (l == -1000000000L) {
            bl28 = true;
        }
        this.harness.check(bl28, "widening int to long");
        l = this.i_Napoleon();
        boolean bl29 = false;
        if (l == 1815L) {
            bl29 = true;
        }
        this.harness.check(bl29, "widening int to long");
        l = this.i_Caesar();
        boolean bl30 = false;
        if (l == -15L) {
            bl30 = true;
        }
        this.harness.check(bl30, "widening int to long");
        f = this.i_OneAndHalfGiga();
        boolean bl31 = false;
        if (f == 1.5E9f) {
            bl31 = true;
        }
        this.harness.check(bl31, "widening int to float");
        f = this.i_MinusOneGiga();
        boolean bl32 = false;
        if (f == -1.0E9f) {
            bl32 = true;
        }
        this.harness.check(bl32, "widening int to float");
        f = this.i_Napoleon();
        boolean bl33 = false;
        if (f == 1815.0f) {
            bl33 = true;
        }
        this.harness.check(bl33, "widening int to float");
        f = this.i_Caesar();
        boolean bl34 = false;
        if (f == -15.0f) {
            bl34 = true;
        }
        this.harness.check(bl34, "widening int to float");
        d = this.i_OneAndHalfGiga();
        boolean bl35 = false;
        if (d == 1.5E9) {
            bl35 = true;
        }
        this.harness.check(bl35, "widening int to double");
        d = this.i_MinusOneGiga();
        boolean bl36 = false;
        if (d == -1.0E9) {
            bl36 = true;
        }
        this.harness.check(bl36, "widening int to double");
        d = this.i_Napoleon();
        boolean bl37 = false;
        if (d == 1815.0) {
            bl37 = true;
        }
        this.harness.check(bl37, "widening int to double");
        d = this.i_Caesar();
        boolean bl38 = false;
        if (d == -15.0) {
            bl38 = true;
        }
        this.harness.check(bl38, "widening int to double");
        this.harness.checkPoint("Invocation Widening : long, to float, double...");
        f = this.l_elevenFourTerra();
        boolean bl39 = false;
        if (f == 1.14E13f) {
            bl39 = true;
        }
        this.harness.check(bl39, "widening long to float");
        f = this.l_minusSevenTerra();
        boolean bl40 = false;
        if (f == -7.0E12f) {
            bl40 = true;
        }
        this.harness.check(bl40, "widening long to float");
        f = this.l_Friendswood();
        boolean bl41 = false;
        if (f == 77546.0f) {
            bl41 = true;
        }
        this.harness.check(bl41, "widening long to float");
        f = this.l_HulsteDorp();
        boolean bl42 = false;
        if (f == -8531.0f) {
            bl42 = true;
        }
        this.harness.check(bl42, "widening long to float");
        d = this.l_elevenFourTerra();
        boolean bl43 = false;
        if (d == 1.14E13) {
            bl43 = true;
        }
        this.harness.check(bl43, "widening long to double");
        d = this.l_minusSevenTerra();
        boolean bl44 = false;
        if (d == -7.0E12) {
            bl44 = true;
        }
        this.harness.check(bl44, "widening long to double");
        d = this.l_Friendswood();
        boolean bl45 = false;
        if (d == 77546.0) {
            bl45 = true;
        }
        this.harness.check(bl45, "widening long to double");
        d = this.l_HulsteDorp();
        boolean bl46 = false;
        if (d == -8531.0) {
            bl46 = true;
        }
        this.harness.check(bl46, "widening long to double");
        this.harness.checkPoint("Invocation Widening : float to double...");
        d = this.f_PosCharge();
        this.harness.check(this.inRange(1.9, -23, d), "widening float to double " + d);
        d = this.f_NegCharge();
        this.harness.check(this.inRange(-1.9, -23, d), "widening float to double " + d);
        d = this.f_Smallest();
        this.harness.check(this.inRange(1.4012984, -45, d), "widening float to double " + d);
        d = this.f_Biggest();
        this.harness.check(this.inRange(3.4028234, 38, d), "widening float to double " + d);
        d = this.f_Nan();
        this.harness.check(Double.isNaN(d), "widening float to double " + d);
        d = this.f_PosInfinite();
        boolean bl47 = false;
        if (d == Double.POSITIVE_INFINITY) {
            bl47 = true;
        }
        this.harness.check(bl47, "widening float to double");
        d = this.f_NegInfinite();
        boolean bl48 = false;
        if (d == Double.NEGATIVE_INFINITY) {
            bl48 = true;
        }
        this.harness.check(bl48, "widening float to double");
    }

    private final void testCastingWidening() {
        char bp = '\u007f';
        char c = '\uffffff80';
        this.harness.checkPoint("type cast widening : byte to short, int, long, float, double...");
        char s = bp;
        boolean bl = false;
        if (s == '\u007f') {
            bl = true;
        }
        this.harness.check(bl, "widening byte to short");
        s = c;
        boolean bl2 = false;
        if (s == '\uffffff80') {
            bl2 = true;
        }
        this.harness.check(bl2, "widening byte to short");
        char i = bp;
        boolean bl3 = false;
        if (i == '\u007f') {
            bl3 = true;
        }
        this.harness.check(bl3, "widening byte to int");
        i = c;
        boolean bl4 = false;
        if (i == '\uffffff80') {
            bl4 = true;
        }
        this.harness.check(bl4, "widening byte to int");
        long l = bp;
        boolean bl5 = false;
        if (l == 127L) {
            bl5 = true;
        }
        this.harness.check(bl5, "widening byte to long");
        l = c;
        boolean bl6 = false;
        if (l == -128L) {
            bl6 = true;
        }
        this.harness.check(bl6, "widening byte to long");
        float f = bp;
        boolean bl7 = false;
        if (f == 127.0f) {
            bl7 = true;
        }
        this.harness.check(bl7, "widening byte to float");
        f = c;
        boolean bl8 = false;
        if (f == -128.0f) {
            bl8 = true;
        }
        this.harness.check(bl8, "widening byte to float");
        double d = bp;
        boolean bl9 = false;
        if (d == 127.0) {
            bl9 = true;
        }
        this.harness.check(bl9, "widening byte to double");
        d = c;
        boolean bl10 = false;
        if (d == -128.0) {
            bl10 = true;
        }
        this.harness.check(bl10, "widening byte to double");
        char c2 = Short.MAX_VALUE;
        char c3 = Short.MIN_VALUE;
        this.harness.checkPoint("type cast widening : short to int, long, float, double...");
        i = c2;
        boolean bl11 = false;
        if (i == Short.MAX_VALUE) {
            bl11 = true;
        }
        this.harness.check(bl11, "widening short to int");
        i = c3;
        boolean bl12 = false;
        if (i == Short.MIN_VALUE) {
            bl12 = true;
        }
        this.harness.check(bl12, "widening short to int");
        l = c2;
        boolean bl13 = false;
        if (l == 32767L) {
            bl13 = true;
        }
        this.harness.check(bl13, "widening short to long");
        l = c3;
        boolean bl14 = false;
        if (l == -32768L) {
            bl14 = true;
        }
        this.harness.check(bl14, "widening short to long");
        f = c2;
        boolean bl15 = false;
        if (f == 32767.0f) {
            bl15 = true;
        }
        this.harness.check(bl15, "widening short to float");
        f = c3;
        boolean bl16 = false;
        if (f == -32768.0f) {
            bl16 = true;
        }
        this.harness.check(bl16, "widening short to float");
        d = c2;
        boolean bl17 = false;
        if (d == 32767.0) {
            bl17 = true;
        }
        this.harness.check(bl17, "widening short to double");
        d = c3;
        boolean bl18 = false;
        if (d == -32768.0) {
            bl18 = true;
        }
        this.harness.check(bl18, "widening short to double");
        char cp = (char)-1;
        char cn = '\u0000';
        this.harness.checkPoint("type cast widening : char to int, long, float, double...");
        i = cp;
        boolean bl19 = false;
        if (i == (char)-1) {
            bl19 = true;
        }
        this.harness.check(bl19, "widening char to int");
        i = cn;
        boolean bl20 = false;
        if (i == '\u0000') {
            bl20 = true;
        }
        this.harness.check(bl20, "widening char to int");
        l = cp;
        boolean bl21 = false;
        if (l == 65535L) {
            bl21 = true;
        }
        this.harness.check(bl21, "widening char to long");
        l = cn;
        boolean bl22 = false;
        if (l == 0L) {
            bl22 = true;
        }
        this.harness.check(bl22, "widening char to long");
        f = cp;
        boolean bl23 = false;
        if (f == 65535.0f) {
            bl23 = true;
        }
        this.harness.check(bl23, "widening char to float");
        f = cn;
        boolean bl24 = false;
        if (f == 0.0f) {
            bl24 = true;
        }
        this.harness.check(bl24, "widening char to float");
        d = cp;
        boolean bl25 = false;
        if (d == 65535.0) {
            bl25 = true;
        }
        this.harness.check(bl25, "widening char to double");
        d = cn;
        boolean bl26 = false;
        if (d == 0.0) {
            bl26 = true;
        }
        this.harness.check(bl26, "widening char to double");
        int oneAndHalfGiga = 1500000000;
        int minusOneGiga = -1000000000;
        int caesar = -15;
        int napoleon = 1815;
        this.harness.checkPoint("type cast widening : int to long, float, double...");
        l = oneAndHalfGiga;
        boolean bl27 = false;
        if (l == 1500000000L) {
            bl27 = true;
        }
        this.harness.check(bl27, "widening int to long");
        l = minusOneGiga;
        boolean bl28 = false;
        if (l == -1000000000L) {
            bl28 = true;
        }
        this.harness.check(bl28, "widening int to long");
        l = caesar;
        boolean bl29 = false;
        if (l == -15L) {
            bl29 = true;
        }
        this.harness.check(bl29, "widening int to long");
        l = napoleon;
        boolean bl30 = false;
        if (l == 1815L) {
            bl30 = true;
        }
        this.harness.check(bl30, "widening int to long");
        f = oneAndHalfGiga;
        boolean bl31 = false;
        if (f == 1.5E9f) {
            bl31 = true;
        }
        this.harness.check(bl31, "widening int to float");
        f = minusOneGiga;
        boolean bl32 = false;
        if (f == -1.0E9f) {
            bl32 = true;
        }
        this.harness.check(bl32, "widening int to float");
        f = caesar;
        boolean bl33 = false;
        if (f == -15.0f) {
            bl33 = true;
        }
        this.harness.check(bl33, "widening int to float");
        f = napoleon;
        boolean bl34 = false;
        if (f == 1815.0f) {
            bl34 = true;
        }
        this.harness.check(bl34, "widening int to float");
        d = oneAndHalfGiga;
        boolean bl35 = false;
        if (d == 1.5E9) {
            bl35 = true;
        }
        this.harness.check(bl35, "widening int to double");
        d = minusOneGiga;
        boolean bl36 = false;
        if (d == -1.0E9) {
            bl36 = true;
        }
        this.harness.check(bl36, "widening int to double");
        d = caesar;
        boolean bl37 = false;
        if (d == -15.0) {
            bl37 = true;
        }
        this.harness.check(bl37, "widening int to double");
        d = napoleon;
        boolean bl38 = false;
        if (d == 1815.0) {
            bl38 = true;
        }
        this.harness.check(bl38, "widening int to double");
        long elevenFourTerra = 11400000000000L;
        long minusSevenTerra = -7000000000000L;
        long Friendswood = 77546L;
        long HulsteDorp = -8531L;
        this.harness.checkPoint("type cast widening : long to float, double...");
        f = elevenFourTerra;
        boolean bl39 = false;
        if (f == 1.14E13f) {
            bl39 = true;
        }
        this.harness.check(bl39, "widening long to float");
        f = minusSevenTerra;
        boolean bl40 = false;
        if (f == -7.0E12f) {
            bl40 = true;
        }
        this.harness.check(bl40, "widening long to float");
        f = Friendswood;
        boolean bl41 = false;
        if (f == 77546.0f) {
            bl41 = true;
        }
        this.harness.check(bl41, "widening long to float");
        f = HulsteDorp;
        boolean bl42 = false;
        if (f == -8531.0f) {
            bl42 = true;
        }
        this.harness.check(bl42, "widening long to float");
        d = elevenFourTerra;
        boolean bl43 = false;
        if (d == 1.14E13) {
            bl43 = true;
        }
        this.harness.check(bl43, "widening long to double");
        d = minusSevenTerra;
        boolean bl44 = false;
        if (d == -7.0E12) {
            bl44 = true;
        }
        this.harness.check(bl44, "widening long to double");
        d = Friendswood;
        boolean bl45 = false;
        if (d == 77546.0) {
            bl45 = true;
        }
        this.harness.check(bl45, "widening long to double");
        d = HulsteDorp;
        boolean bl46 = false;
        if (d == -8531.0) {
            bl46 = true;
        }
        this.harness.check(bl46, "widening long to double");
        float posCharge = 1.9E-23f;
        float negCharge = -1.9E-23f;
        float smallest = Float.MIN_VALUE;
        float biggest = Float.MAX_VALUE;
        float nan = Float.NaN;
        float posInfinite = Float.POSITIVE_INFINITY;
        float negInfinite = Float.NEGATIVE_INFINITY;
        this.harness.checkPoint("type cast widening : float to, double...");
        d = posCharge;
        this.harness.check(this.inRange(1.9, -23, d), "widening float to double " + d);
        d = negCharge;
        this.harness.check(this.inRange(-1.9, -23, d), "widening float to double " + d);
        d = smallest;
        this.harness.check(this.inRange(1.4012984, -45, d), "widening float to double " + d);
        d = biggest;
        this.harness.check(this.inRange(3.4028234, 38, d), "widening float to double " + d);
        d = nan;
        this.harness.check(Double.isNaN(d), "widening float to double " + d);
        d = posInfinite;
        boolean bl47 = false;
        if (d == Double.POSITIVE_INFINITY) {
            bl47 = true;
        }
        this.harness.check(bl47, "widening float to double");
        d = negInfinite;
        boolean bl48 = false;
        if (d == Double.NEGATIVE_INFINITY) {
            bl48 = true;
        }
        this.harness.check(bl48, "widening float to double");
    }

    private final void testCastingNarrowing() {
        this.harness.checkPoint("cast narowing : short, char, int, long, narrowed into byte");
        long l = 0xFFFFFFFFFFFFF00L;
        int i = 0xFFFFF00;
        char c = '\u0f00';
        int s = 3840;
        int b = (int)l;
        boolean bl = false;
        if (b == 0) {
            bl = true;
        }
        this.harness.check(bl, "long=>byte, byte=(+)0");
        b = (byte)i;
        boolean bl2 = false;
        if (b == 0) {
            bl2 = true;
        }
        this.harness.check(bl2, "int=>byte, byte=(+)0");
        b = (byte)c;
        boolean bl3 = false;
        if (b == 0) {
            bl3 = true;
        }
        this.harness.check(bl3, "char=>byte, byte=(+)0");
        b = (byte)s;
        boolean bl4 = false;
        if (b == 0) {
            bl4 = true;
        }
        this.harness.check(bl4, "short=>byte, byte=(+)0");
        l = -1152921504606846720L;
        i = -268435200;
        c = '\uf000';
        s = -3840;
        b = (byte)l;
        boolean bl5 = false;
        if (b == 0) {
            bl5 = true;
        }
        this.harness.check(bl5, "long=>byte, byte=(-)0");
        b = (byte)i;
        boolean bl6 = false;
        if (b == 0) {
            bl6 = true;
        }
        this.harness.check(bl6, "int=>byte, byte=(-)0");
        b = (byte)c;
        boolean bl7 = false;
        if (b == 0) {
            bl7 = true;
        }
        this.harness.check(bl7, "char=>byte, byte=(-)0");
        b = (byte)s;
        boolean bl8 = false;
        if (b == 0) {
            bl8 = true;
        }
        this.harness.check(bl8, "short=>byte, byte=(-)0");
        l = 0xFFFFFFFFFFFFF0FL;
        i = 0xFFFFF0F;
        c = '\u0f0f';
        s = 3855;
        b = (byte)l;
        boolean bl9 = false;
        if (b == 15) {
            bl9 = true;
        }
        this.harness.check(bl9, "(+)long=>byte, byte = <" + b + "> instead +15");
        b = (byte)i;
        boolean bl10 = false;
        if (b == 15) {
            bl10 = true;
        }
        this.harness.check(bl10, "(+)int=>byte, byte = <" + b + "> instead +15");
        b = (byte)c;
        boolean bl11 = false;
        if (b == 15) {
            bl11 = true;
        }
        this.harness.check(bl11, "(+)char=>byte, byte = <" + b + "> instead +15");
        b = (byte)s;
        boolean bl12 = false;
        if (b == 15) {
            bl12 = true;
        }
        this.harness.check(bl12, "(+)short=>byte, byte = <" + b + "> instead +15");
        l = -1152921504606846961L;
        i = -268435441;
        c = '\u0f0f';
        s = -4081;
        b = (byte)l;
        boolean bl13 = false;
        if (b == 15) {
            bl13 = true;
        }
        this.harness.check(bl13, "(-)long=>byte, byte <" + b + "> instead +15");
        b = (byte)i;
        boolean bl14 = false;
        if (b == 15) {
            bl14 = true;
        }
        this.harness.check(bl14, "(-)int=>byte, byte=" + b + "> instead +15");
        b = (byte)c;
        boolean bl15 = false;
        if (b == 15) {
            bl15 = true;
        }
        this.harness.check(bl15, "(-)char=>byte, byte= <" + b + "> instead +15");
        b = (byte)s;
        boolean bl16 = false;
        if (b == 15) {
            bl16 = true;
        }
        this.harness.check(bl16, "(-)short=>byte, byte= <" + b + "> instead +15");
        l = 0xFFFFFFFFFFFFFF1L;
        i = 0xFFFFFF1;
        c = '\u0ff1';
        s = 4081;
        b = (byte)l;
        boolean bl17 = false;
        if (b == -15) {
            bl17 = true;
        }
        this.harness.check(bl17, "(+)long=>byte, byte <" + b + "> instead -15");
        b = (byte)i;
        boolean bl18 = false;
        if (b == -15) {
            bl18 = true;
        }
        this.harness.check(bl18, "(+)int=>byte, byte <" + b + "> instead -15");
        b = (byte)c;
        boolean bl19 = false;
        if (b == -15) {
            bl19 = true;
        }
        this.harness.check(bl19, "(+)char=>byte, byte <" + b + "> instead -15");
        b = (byte)s;
        boolean bl20 = false;
        if (b == -15) {
            bl20 = true;
        }
        this.harness.check(bl20, "(+)short=>byte, byte <" + b + "> instead -15");
        l = -1152921504606846735L;
        i = -268435215;
        c = '\uf0f1';
        s = -3855;
        b = (byte)l;
        boolean bl21 = false;
        if (b == -15) {
            bl21 = true;
        }
        this.harness.check(bl21, "(-)long=>byte, byte <" + b + "> instead -15");
        b = (byte)i;
        boolean bl22 = false;
        if (b == -15) {
            bl22 = true;
        }
        this.harness.check(bl22, "(-)int=>byte, byte= <" + b + "> instead -15");
        b = (byte)c;
        boolean bl23 = false;
        if (b == -15) {
            bl23 = true;
        }
        this.harness.check(bl23, "(-)char=>byte, byte= <" + b + "> instead -15");
        b = (byte)s;
        boolean bl24 = false;
        if (b == -15) {
            bl24 = true;
        }
        this.harness.check(bl24, "(-)short=>byte, byte= <" + b + "> instead -15");
        this.harness.checkPoint("cast narowing :  char, int, long, narrowed into short");
        l = 0xFFFFFFFFFFF0000L;
        i = 0xFFF0000;
        c = '\u0000';
        s = (short)l;
        boolean bl25 = false;
        if (s == 0) {
            bl25 = true;
        }
        this.harness.check(bl25, "long=>short, short=(+)0");
        s = (short)i;
        boolean bl26 = false;
        if (s == 0) {
            bl26 = true;
        }
        this.harness.check(bl26, "int=>short, short=(+)0");
        s = (short)c;
        boolean bl27 = false;
        if (s == 0) {
            bl27 = true;
        }
        this.harness.check(bl27, "char=>short, short=(+)0");
        l = -1152921504606781440L;
        i = -268369920;
        s = (short)l;
        boolean bl28 = false;
        if (s == 0) {
            bl28 = true;
        }
        this.harness.check(bl28, "long=>short, short=(-)0");
        s = (short)i;
        boolean bl29 = false;
        if (s == 0) {
            bl29 = true;
        }
        this.harness.check(bl29, "int=>short, short=(-)0");
        l = -61441L;
        i = 0xFFF0FFF;
        c = '\u0fff';
        s = (short)l;
        boolean bl30 = false;
        if (s == 4095) {
            bl30 = true;
        }
        this.harness.check(bl30, "(+)long=>short, short" + s + "instead 4095");
        s = (short)i;
        boolean bl31 = false;
        if (s == 4095) {
            bl31 = true;
        }
        this.harness.check(bl31, "(+)int=>short, short=" + s + " instead of 4095");
        s = (short)c;
        boolean bl32 = false;
        if (s == 4095) {
            bl32 = true;
        }
        this.harness.check(bl32, "(+)char=>short, short=" + s + " instead of 4095");
        l = -1152921504606842881L;
        i = -268431361;
        s = (short)l;
        boolean bl33 = false;
        if (s == 4095) {
            bl33 = true;
        }
        this.harness.check(bl33, "(-)long=>short, short=" + s + " instead of 4095");
        s = (short)i;
        boolean bl34 = false;
        if (s == 4095) {
            bl34 = true;
        }
        this.harness.check(bl34, "(-)int=>short, short=" + s + " instead of 4095");
        l = 0xFFFFFFFFFFFF001L;
        i = 0xFFFF001;
        c = '\uf001';
        s = (short)l;
        boolean bl35 = false;
        if (s == -4095) {
            bl35 = true;
        }
        this.harness.check(bl35, "(+)long=>short, short=" + s + " instead of -4095");
        s = (short)i;
        boolean bl36 = false;
        if (s == -4095) {
            bl36 = true;
        }
        this.harness.check(bl36, "(+)int=>short, short=" + s + " instead of -4095");
        s = (short)c;
        boolean bl37 = false;
        if (s == -4095) {
            bl37 = true;
        }
        this.harness.check(bl37, "(+)char=>short, short=" + s + " instead of -4095");
        l = -1152921504606785535L;
        i = -268374015;
        s = (short)l;
        boolean bl38 = false;
        if (s == -4095) {
            bl38 = true;
        }
        this.harness.check(bl38, "(-)long=>short, short=" + s + " instead of -4095");
        s = (short)i;
        boolean bl39 = false;
        if (s == -4095) {
            bl39 = true;
        }
        this.harness.check(bl39, "(-)int=>short, short=" + s + " instead of -4095");
        this.harness.checkPoint("cast narowing :  short, int, long, narrowed into char");
        l = 0xFFFFFFFFFFF0000L;
        i = 0xFFF0000;
        s = 0;
        c = (char)l;
        boolean bl40 = false;
        if (c == '\u0000') {
            bl40 = true;
        }
        this.harness.check(bl40, "long=>char, char=(+)0");
        c = (char)i;
        boolean bl41 = false;
        if (c == '\u0000') {
            bl41 = true;
        }
        this.harness.check(bl41, "int=>char, char=(+)0");
        c = (char)s;
        boolean bl42 = false;
        if (c == '\u0000') {
            bl42 = true;
        }
        this.harness.check(bl42, "short=>char, char=(+)0");
        l = -1152921504606781440L;
        i = -268369920;
        c = (char)l;
        boolean bl43 = false;
        if (c == '\u0000') {
            bl43 = true;
        }
        this.harness.check(bl43, "long=>char, char=(-)0");
        c = (char)i;
        boolean bl44 = false;
        if (c == '\u0000') {
            bl44 = true;
        }
        this.harness.check(bl44, "int=>char, char=(-)0");
        l = -61441L;
        i = 0xFFF0FFF;
        s = 4095;
        c = (char)l;
        boolean bl45 = false;
        if (c == '\u0fff') {
            bl45 = true;
        }
        this.harness.check(bl45, "(+)long=>char, char=" + c + " instead of 4095");
        c = (char)i;
        boolean bl46 = false;
        if (c == '\u0fff') {
            bl46 = true;
        }
        this.harness.check(bl46, "(+)int=>char, char=" + c + " instead of 4095");
        c = (char)s;
        boolean bl47 = false;
        if (c == '\u0fff') {
            bl47 = true;
        }
        this.harness.check(bl47, "(+)short=>char, char=" + c + " instead of 4095");
        l = -1152921504606842881L;
        i = -268431361;
        c = (char)l;
        boolean bl48 = false;
        if (c == '\u0fff') {
            bl48 = true;
        }
        this.harness.check(bl48, "(-)long=>char, char=" + c + " instead of 4095");
        c = (char)i;
        boolean bl49 = false;
        if (c == '\u0fff') {
            bl49 = true;
        }
        this.harness.check(bl49, "(-)int=>char, char=" + c + " instead of 4095");
        l = 0xFFFFFFFFFFFF000L;
        i = 0xFFFF000;
        c = (char)l;
        boolean bl50 = false;
        if (c == '\uf000') {
            bl50 = true;
        }
        this.harness.check(bl50, "(+)long=>char, char=" + c + " instead of 61440");
        c = (char)i;
        boolean bl51 = false;
        if (c == '\uf000') {
            bl51 = true;
        }
        this.harness.check(bl51, "(+)int=>char, char=" + c + " instead of 61440");
        l = -1152921504606785535L;
        i = -268374015;
        s = -4095;
        s = (short)l;
        boolean bl52 = false;
        if (c == '\uf000') {
            bl52 = true;
        }
        this.harness.check(bl52, "(-)long=>char, char=" + c + " instead of 61440");
        s = (short)i;
        boolean bl53 = false;
        if (c == '\uf000') {
            bl53 = true;
        }
        this.harness.check(bl53, "(-)int=>char, char=" + c + " instead of 61440");
        s = (short)c;
        boolean bl54 = false;
        if (c == '\uf000') {
            bl54 = true;
        }
        this.harness.check(bl54, "(+)short=>char, char=" + c + " instead of 61440");
        this.harness.checkPoint("cast narowing :  long narrowed into int");
        l = 0xFFFFFFF00000000L;
        i = (int)l;
        boolean bl55 = false;
        if (i == 0) {
            bl55 = true;
        }
        this.harness.check(bl55, "(+)long=>int, int=0");
        l = -1152921500311879680L;
        i = (int)l;
        boolean bl56 = false;
        if (i == 0) {
            bl56 = true;
        }
        this.harness.check(bl56, "(-)long=>int, int=0");
        l = -4026531841L;
        i = (int)l;
        boolean bl57 = false;
        if (i == 0xFFFFFFF) {
            bl57 = true;
        }
        this.harness.check(bl57, "(+)long=>int, int>0");
        l = -1152921504338411521L;
        i = (int)l;
        boolean bl58 = false;
        if (i == 0xFFFFFFF) {
            bl58 = true;
        }
        this.harness.check(bl58, "(+)long=>int, int>0");
        l = -268435455L;
        i = (int)l;
        boolean bl59 = false;
        if (i == -268435455) {
            bl59 = true;
        }
        this.harness.check(bl59, "(+)long=>int, int<0");
        l = -1152921500580315135L;
        i = (int)l;
        boolean bl60 = false;
        if (i == -268435455) {
            bl60 = true;
        }
        this.harness.check(bl60, "(-)long=>int, int<0");
        this.harness.checkPoint("cast narowing : narrowing' byte into char");
        b = 15;
        c = (char)b;
        boolean bl61 = false;
        if (c == '\u000f') {
            bl61 = true;
        }
        this.harness.check(bl61, "(positive) byte into char");
        b = -15;
        c = (char)b;
        boolean bl62 = false;
        if (c == '\ufff1') {
            bl62 = true;
        }
        this.harness.check(bl62, "(negative) byte into char: got" + c + " instead of 241/-15");
        this.harness.checkPoint("'narrowing' float and double into long");
        float f = 0.0f;
        double d = 0.0;
        l = (long)f;
        boolean bl63 = false;
        if (l == 0L) {
            bl63 = true;
        }
        this.harness.check(bl63, "zero float to long");
        l = (long)d;
        boolean bl64 = false;
        if (l == 0L) {
            bl64 = true;
        }
        this.harness.check(bl64, "zero double to long");
        f = Float.POSITIVE_INFINITY;
        d = Double.POSITIVE_INFINITY;
        l = (long)f;
        boolean bl65 = false;
        if (l == Long.MAX_VALUE) {
            bl65 = true;
        }
        this.harness.check(bl65, "positive infinite float to long");
        l = (long)d;
        boolean bl66 = false;
        if (l == Long.MAX_VALUE) {
            bl66 = true;
        }
        this.harness.check(bl66, "positive infinite double to long");
        f = Float.NEGATIVE_INFINITY;
        d = Double.NEGATIVE_INFINITY;
        l = (long)f;
        boolean bl67 = false;
        if (l == Long.MIN_VALUE) {
            bl67 = true;
        }
        this.harness.check(bl67, "negative infinite float to long");
        l = (long)d;
        boolean bl68 = false;
        if (l == Long.MIN_VALUE) {
            bl68 = true;
        }
        this.harness.check(bl68, "negative infinite double to long");
        f = Float.NaN;
        d = Double.NaN;
        l = (long)f;
        boolean bl69 = false;
        if (l == 0L) {
            bl69 = true;
        }
        this.harness.check(bl69, "NaN float to long");
        l = (long)d;
        boolean bl70 = false;
        if (l == 0L) {
            bl70 = true;
        }
        this.harness.check(bl70, "NaN double to long");
        f = 3.0E30f;
        d = 1.0E300;
        l = (long)f;
        boolean bl71 = false;
        if (l == Long.MAX_VALUE) {
            bl71 = true;
        }
        this.harness.check(bl71, "positive too large float to long");
        l = (long)d;
        boolean bl72 = false;
        if (l == Long.MAX_VALUE) {
            bl72 = true;
        }
        this.harness.check(bl72, "positive too large double to long");
        f = -3.0E30f;
        d = -1.0E300;
        l = (long)f;
        boolean bl73 = false;
        if (l == Long.MIN_VALUE) {
            bl73 = true;
        }
        this.harness.check(bl73, "negative too large float to long");
        l = (long)d;
        boolean bl74 = false;
        if (l == Long.MIN_VALUE) {
            bl74 = true;
        }
        this.harness.check(bl74, "negative too large double to long");
        f = 1.14E7f;
        d = 1.14E13;
        l = (long)f;
        boolean bl75 = false;
        if (l == 11400000L) {
            bl75 = true;
        }
        this.harness.check(bl75, "positive in range float to long : " + l);
        l = (long)d;
        boolean bl76 = false;
        if (l == 11400000000000L) {
            bl76 = true;
        }
        this.harness.check(bl76, "positive in range double to long : " + l);
        f = -7000000.0f;
        d = -7.0E12;
        l = (long)f;
        boolean bl77 = false;
        if (l == -7000000L) {
            bl77 = true;
        }
        this.harness.check(bl77, "negative in range float to long : " + l);
        l = (long)d;
        boolean bl78 = false;
        if (l == -7000000000000L) {
            bl78 = true;
        }
        this.harness.check(bl78, "negative in range double to long : " + l);
        f = 1.45f;
        d = 1.045;
        l = (long)f;
        boolean bl79 = false;
        if (l == 1L) {
            bl79 = true;
        }
        this.harness.check(bl79, "positive round to zero float to long");
        l = (long)d;
        boolean bl80 = false;
        if (l == 1L) {
            bl80 = true;
        }
        this.harness.check(bl80, "positive round to zero double to long");
        f = -1.45f;
        d = -1.045;
        l = (long)f;
        boolean bl81 = false;
        if (l == (long)-1) {
            bl81 = true;
        }
        this.harness.check(bl81, "negative round to zero float to long");
        l = (long)d;
        boolean bl82 = false;
        if (l == (long)-1) {
            bl82 = true;
        }
        this.harness.check(bl82, "negative round to zero double to long");
        this.harness.checkPoint("'narrowing' float and double into int, char, short, byte");
        f = 0.0f;
        d = 0.0;
        i = (int)f;
        boolean bl83 = false;
        if (i == 0) {
            bl83 = true;
        }
        this.harness.check(bl83, "zero float to int");
        c = (char)f;
        boolean bl84 = false;
        if (c == '\u0000') {
            bl84 = true;
        }
        this.harness.check(bl84, "zero float to char");
        s = (short)f;
        boolean bl85 = false;
        if (s == 0) {
            bl85 = true;
        }
        this.harness.check(bl85, "zero float to short");
        b = (byte)f;
        boolean bl86 = false;
        if (b == 0) {
            bl86 = true;
        }
        this.harness.check(bl86, "zero float to byte");
        i = (int)d;
        boolean bl87 = false;
        if (i == 0) {
            bl87 = true;
        }
        this.harness.check(bl87, "zero double to int");
        c = (char)d;
        boolean bl88 = false;
        if (c == '\u0000') {
            bl88 = true;
        }
        this.harness.check(bl88, "zero double to char");
        s = (short)d;
        boolean bl89 = false;
        if (s == 0) {
            bl89 = true;
        }
        this.harness.check(bl89, "zero double to short");
        b = (byte)d;
        boolean bl90 = false;
        if (b == 0) {
            bl90 = true;
        }
        this.harness.check(bl90, "zero double to byte");
        f = Float.POSITIVE_INFINITY;
        d = Double.POSITIVE_INFINITY;
        i = (int)f;
        boolean bl91 = false;
        if (i == Integer.MAX_VALUE) {
            bl91 = true;
        }
        this.harness.check(bl91, "positive infinity float to int");
        c = (char)f;
        boolean bl92 = false;
        if (c == (char)-1) {
            bl92 = true;
        }
        this.harness.check(bl92, "positive infinity float to char");
        s = (short)f;
        boolean bl93 = false;
        if (s == -1) {
            bl93 = true;
        }
        this.harness.check(bl93, "positive infinity float to short");
        b = (byte)f;
        boolean bl94 = false;
        if (b == -1) {
            bl94 = true;
        }
        this.harness.check(bl94, "positive infinity float to byte");
        i = (int)d;
        boolean bl95 = false;
        if (i == Integer.MAX_VALUE) {
            bl95 = true;
        }
        this.harness.check(bl95, "positive infinity double to int");
        c = (char)d;
        boolean bl96 = false;
        if (c == (char)-1) {
            bl96 = true;
        }
        this.harness.check(bl96, "positive infinity double to char");
        s = (short)d;
        boolean bl97 = false;
        if (s == -1) {
            bl97 = true;
        }
        this.harness.check(bl97, "positive infinity double to short");
        b = (byte)d;
        boolean bl98 = false;
        if (b == -1) {
            bl98 = true;
        }
        this.harness.check(bl98, "positive infinity double to byte");
        f = Float.NEGATIVE_INFINITY;
        d = Double.NEGATIVE_INFINITY;
        i = (int)f;
        boolean bl99 = false;
        if (i == Integer.MIN_VALUE) {
            bl99 = true;
        }
        this.harness.check(bl99, "negative infinity float to int");
        c = (char)f;
        boolean bl100 = false;
        if (c == '\u0000') {
            bl100 = true;
        }
        this.harness.check(bl100, "negative infinity float to char");
        s = (short)f;
        boolean bl101 = false;
        if (s == 0) {
            bl101 = true;
        }
        this.harness.check(bl101, "negative infinity float to short");
        b = (byte)f;
        boolean bl102 = false;
        if (b == 0) {
            bl102 = true;
        }
        this.harness.check(bl102, "negative infinity float to byte");
        i = (int)d;
        boolean bl103 = false;
        if (i == Integer.MIN_VALUE) {
            bl103 = true;
        }
        this.harness.check(bl103, "negative infinity double to int");
        c = (char)d;
        boolean bl104 = false;
        if (c == '\u0000') {
            bl104 = true;
        }
        this.harness.check(bl104, "negative infinity double to char");
        s = (short)d;
        boolean bl105 = false;
        if (s == 0) {
            bl105 = true;
        }
        this.harness.check(bl105, "negative infinity double to short");
        b = (byte)d;
        boolean bl106 = false;
        if (b == 0) {
            bl106 = true;
        }
        this.harness.check(bl106, "negative infinity double to byte");
        f = Float.NaN;
        d = Double.NaN;
        i = (int)f;
        this.harness.check(i, 0, "NaN float to int");
        c = (char)f;
        this.harness.check(c, 0, "NaN float to char");
        s = (short)f;
        this.harness.check(s, 0, "NaN float to short");
        b = (byte)f;
        this.harness.check(b, 0, "NaN float to byte");
        i = (int)d;
        this.harness.check(i, 0, "NaN double to int");
        c = (char)d;
        this.harness.check(c, 0, "NaN double to char");
        s = (short)d;
        this.harness.check(s, 0, "NaN double to short");
        b = (byte)d;
        this.harness.check(b, 0, "NaN double to byte");
        f = 3.0E10f;
        d = 1.0E100;
        i = (int)f;
        boolean bl107 = false;
        if (i == Integer.MAX_VALUE) {
            bl107 = true;
        }
        this.harness.check(bl107, "positive too large float to int");
        c = (char)f;
        boolean bl108 = false;
        if (c == (char)-1) {
            bl108 = true;
        }
        this.harness.check(bl108, "positive too large float to char");
        s = (short)f;
        boolean bl109 = false;
        if (s == -1) {
            bl109 = true;
        }
        this.harness.check(bl109, "positive too large float to short");
        b = (byte)f;
        boolean bl110 = false;
        if (b == -1) {
            bl110 = true;
        }
        this.harness.check(bl110, "positive too large float to byte");
        i = (int)d;
        boolean bl111 = false;
        if (i == Integer.MAX_VALUE) {
            bl111 = true;
        }
        this.harness.check(bl111, "positive too large double to int");
        c = (char)d;
        boolean bl112 = false;
        if (c == (char)-1) {
            bl112 = true;
        }
        this.harness.check(bl112, "positive too large double to char");
        s = (short)d;
        boolean bl113 = false;
        if (s == -1) {
            bl113 = true;
        }
        this.harness.check(bl113, "positive too large double to short");
        b = (byte)d;
        boolean bl114 = false;
        if (b == -1) {
            bl114 = true;
        }
        this.harness.check(bl114, "positive too large double to byte");
        f = -3.0E10f;
        d = -1.0E100;
        i = (int)f;
        boolean bl115 = false;
        if (i == Integer.MIN_VALUE) {
            bl115 = true;
        }
        this.harness.check(bl115, "negative too large float to int");
        c = (char)f;
        boolean bl116 = false;
        if (c == '\u0000') {
            bl116 = true;
        }
        this.harness.check(bl116, "negative too large float to char");
        s = (short)f;
        boolean bl117 = false;
        if (s == 0) {
            bl117 = true;
        }
        this.harness.check(bl117, "negative too large float to short");
        b = (byte)f;
        boolean bl118 = false;
        if (b == 0) {
            bl118 = true;
        }
        this.harness.check(bl118, "negative too large float to byte");
        i = (int)d;
        boolean bl119 = false;
        if (i == Integer.MIN_VALUE) {
            bl119 = true;
        }
        this.harness.check(bl119, "negative too large double to int");
        c = (char)d;
        boolean bl120 = false;
        if (c == '\u0000') {
            bl120 = true;
        }
        this.harness.check(bl120, "negative too large double to char");
        s = (short)d;
        boolean bl121 = false;
        if (s == 0) {
            bl121 = true;
        }
        this.harness.check(bl121, "negative too large double to short");
        b = (byte)d;
        boolean bl122 = false;
        if (b == 0) {
            bl122 = true;
        }
        this.harness.check(bl122, "negative too large double to byte");
        f = 66000.0f;
        d = 66000.0;
        i = (int)f;
        boolean bl123 = false;
        if (i == 66000) {
            bl123 = true;
        }
        this.harness.check(bl123, "in-range rounding float to int");
        c = (char)f;
        boolean bl124 = false;
        if (c == '\u01d0') {
            bl124 = true;
        }
        this.harness.check(bl124, "in-range rounding float to char");
        s = (short)f;
        boolean bl125 = false;
        if (s == 464) {
            bl125 = true;
        }
        this.harness.check(bl125, "in-range rounding float to short");
        b = (byte)f;
        boolean bl126 = false;
        if (b == -48) {
            bl126 = true;
        }
        this.harness.check(bl126, "in-range rounding float to byte");
        i = (int)d;
        boolean bl127 = false;
        if (i == 66000) {
            bl127 = true;
        }
        this.harness.check(bl127, "in-range rounding double to int");
        c = (char)d;
        boolean bl128 = false;
        if (c == '\u01d0') {
            bl128 = true;
        }
        this.harness.check(bl128, "in-range rounding double to char");
        s = (short)d;
        boolean bl129 = false;
        if (s == 464) {
            bl129 = true;
        }
        this.harness.check(bl129, "in-range rounding double to short");
        b = (byte)d;
        boolean bl130 = false;
        if (b == -48) {
            bl130 = true;
        }
        this.harness.check(bl130, "in-range rounding double to byte");
        f = 127000.0f;
        d = 127000.0;
        i = (int)f;
        boolean bl131 = false;
        if (i == 127000) {
            bl131 = true;
        }
        this.harness.check(bl131, "in-range rounding float to int");
        c = (char)f;
        boolean bl132 = false;
        if (c == '\uf018') {
            bl132 = true;
        }
        this.harness.check(bl132, "in-range rounding float to char");
        s = (short)f;
        boolean bl133 = false;
        if (s == -4072) {
            bl133 = true;
        }
        this.harness.check(bl133, "in-range rounding float to short");
        b = (byte)f;
        boolean bl134 = false;
        if (b == 24) {
            bl134 = true;
        }
        this.harness.check(bl134, "in-range rounding float to byte");
        i = (int)d;
        boolean bl135 = false;
        if (i == 127000) {
            bl135 = true;
        }
        this.harness.check(bl135, "in-range rounding double to int");
        c = (char)d;
        boolean bl136 = false;
        if (c == '\uf018') {
            bl136 = true;
        }
        this.harness.check(bl136, "in-range rounding double to char");
        s = (short)d;
        boolean bl137 = false;
        if (s == -4072) {
            bl137 = true;
        }
        this.harness.check(bl137, "in-range rounding double to short");
        b = (byte)d;
        boolean bl138 = false;
        if (b == 24) {
            bl138 = true;
        }
        this.harness.check(bl138, "in-range rounding double to byte");
        f = -66000.0f;
        d = -66000.0;
        i = (int)f;
        boolean bl139 = false;
        if (i == -66000) {
            bl139 = true;
        }
        this.harness.check(bl139, "in-range rounding float to int");
        c = (char)f;
        boolean bl140 = false;
        if (c == '\ufe30') {
            bl140 = true;
        }
        this.harness.check(bl140, "in-range rounding float to char");
        s = (short)f;
        boolean bl141 = false;
        if (s == -464) {
            bl141 = true;
        }
        this.harness.check(bl141, "in-range rounding float to short");
        b = (byte)f;
        boolean bl142 = false;
        if (b == 48) {
            bl142 = true;
        }
        this.harness.check(bl142, "in-range rounding float to byte");
        i = (int)d;
        boolean bl143 = false;
        if (i == -66000) {
            bl143 = true;
        }
        this.harness.check(bl143, "in-range rounding double to int");
        c = (char)d;
        boolean bl144 = false;
        if (c == '\ufe30') {
            bl144 = true;
        }
        this.harness.check(bl144, "in-range rounding double to char");
        s = (short)d;
        boolean bl145 = false;
        if (s == -464) {
            bl145 = true;
        }
        this.harness.check(bl145, "in-range rounding double to short");
        b = (byte)d;
        boolean bl146 = false;
        if (b == 48) {
            bl146 = true;
        }
        this.harness.check(bl146, "in-range rounding double to byte");
        f = -127000.0f;
        d = -127000.0;
        i = (int)f;
        boolean bl147 = false;
        if (i == -127000) {
            bl147 = true;
        }
        this.harness.check(bl147, "in-range rounding float to int");
        c = (char)f;
        boolean bl148 = false;
        if (c == '\u0fe8') {
            bl148 = true;
        }
        this.harness.check(bl148, "in-range rounding float to char");
        s = (short)f;
        boolean bl149 = false;
        if (s == 4072) {
            bl149 = true;
        }
        this.harness.check(bl149, "in-range rounding float to short");
        b = (byte)f;
        boolean bl150 = false;
        if (b == -24) {
            bl150 = true;
        }
        this.harness.check(bl150, "in-range rounding float to byte");
        i = (int)d;
        boolean bl151 = false;
        if (i == -127000) {
            bl151 = true;
        }
        this.harness.check(bl151, "in-range rounding double to int");
        c = (char)d;
        boolean bl152 = false;
        if (c == '\u0fe8') {
            bl152 = true;
        }
        this.harness.check(bl152, "in-range rounding double to char");
        s = (short)d;
        boolean bl153 = false;
        if (s == 4072) {
            bl153 = true;
        }
        this.harness.check(bl153, "in-range rounding double to short");
        b = (byte)d;
        boolean bl154 = false;
        if (b == -24) {
            bl154 = true;
        }
        this.harness.check(bl154, "in-range rounding double to byte");
        f = 1.45f;
        d = 1.045;
        i = (int)f;
        boolean bl155 = false;
        if (i == 1) {
            bl155 = true;
        }
        this.harness.check(bl155, "positive round to zero float to int");
        c = (char)f;
        boolean bl156 = false;
        if (c == '\u0001') {
            bl156 = true;
        }
        this.harness.check(bl156, "positive round to zero float to char");
        s = (short)f;
        boolean bl157 = false;
        if (s == 1) {
            bl157 = true;
        }
        this.harness.check(bl157, "positive round to zero float to short");
        b = (byte)f;
        boolean bl158 = false;
        if (b == 1) {
            bl158 = true;
        }
        this.harness.check(bl158, "positive round to zero float to byte");
        i = (int)d;
        boolean bl159 = false;
        if (i == 1) {
            bl159 = true;
        }
        this.harness.check(bl159, "positive round to zero double to int");
        c = (char)d;
        boolean bl160 = false;
        if (c == '\u0001') {
            bl160 = true;
        }
        this.harness.check(bl160, "positive round to zero double to char");
        s = (short)d;
        boolean bl161 = false;
        if (s == 1) {
            bl161 = true;
        }
        this.harness.check(bl161, "positive round to zero double to short");
        b = (byte)d;
        boolean bl162 = false;
        if (b == 1) {
            bl162 = true;
        }
        this.harness.check(bl162, "positive round to zero double to byte");
        f = -1.45f;
        d = -1.045;
        i = (int)f;
        boolean bl163 = false;
        if (i == -1) {
            bl163 = true;
        }
        this.harness.check(bl163, "negative round to zero float to int");
        c = (char)f;
        boolean bl164 = false;
        if (c == (char)-1) {
            bl164 = true;
        }
        this.harness.check(bl164, "negative round to zero float to char");
        s = (short)f;
        boolean bl165 = false;
        if (s == -1) {
            bl165 = true;
        }
        this.harness.check(bl165, "negative round to zero float to short");
        b = (byte)f;
        boolean bl166 = false;
        if (b == -1) {
            bl166 = true;
        }
        this.harness.check(bl166, "negative round to zero float to byte");
        i = (int)d;
        boolean bl167 = false;
        if (i == -1) {
            bl167 = true;
        }
        this.harness.check(bl167, "negative round to zero double to int");
        c = (char)d;
        boolean bl168 = false;
        if (c == (char)-1) {
            bl168 = true;
        }
        this.harness.check(bl168, "negative round to zero double to char");
        s = (short)d;
        boolean bl169 = false;
        if (s == -1) {
            bl169 = true;
        }
        this.harness.check(bl169, "negative round to zero double to short");
        b = (byte)d;
        boolean bl170 = false;
        if (b == -1) {
            bl170 = true;
        }
        this.harness.check(bl170, "negative round to zero double to byte");
        this.harness.checkPoint("'narrowing' double to float");
        d = 0.0;
        f = (float)d;
        boolean bl171 = false;
        if (f == 0.0f) {
            bl171 = true;
        }
        this.harness.check(bl171, "zero double to float");
        d = -0.0;
        f = (float)d;
        boolean bl172 = false;
        if (f == 0.0f) {
            bl172 = true;
        }
        this.harness.check(bl172, "zero double to float");
        d = Double.POSITIVE_INFINITY;
        f = (float)d;
        boolean bl173 = false;
        if (f == Float.POSITIVE_INFINITY) {
            bl173 = true;
        }
        this.harness.check(bl173, "positive infinity double to float");
        d = Double.NEGATIVE_INFINITY;
        f = (float)d;
        boolean bl174 = false;
        if (f == Float.NEGATIVE_INFINITY) {
            bl174 = true;
        }
        this.harness.check(bl174, "negative infinity double to float");
        d = Double.NaN;
        f = (float)d;
        this.harness.check(Float.isNaN(f), "NaN double to float : " + f);
        d = 3.4E40;
        f = (float)d;
        boolean bl175 = false;
        if (f == Float.POSITIVE_INFINITY) {
            bl175 = true;
        }
        this.harness.check(bl175, "positive too large double to float");
        d = -3.4E40;
        f = (float)d;
        boolean bl176 = false;
        if (f == Float.NEGATIVE_INFINITY) {
            bl176 = true;
        }
        this.harness.check(bl176, "negative too large double to float");
        d = 1.4E-50;
        f = (float)d;
        boolean bl177 = false;
        if (f == 0.0f) {
            bl177 = true;
        }
        this.harness.check(bl177, "positive too small double to float : " + f);
        d = -1.4E-50;
        f = (float)d;
        boolean bl178 = false;
        if (f == 0.0f) {
            bl178 = true;
        }
        this.harness.check(bl178, "negative too small double to float : " + f);
        d = 1.9E23;
        f = (float)d;
        boolean bl179 = false;
        if (f == 1.9E23f) {
            bl179 = true;
        }
        this.harness.check(bl179, "normal case double to float");
        d = -1.9E23;
        f = (float)d;
        boolean bl180 = false;
        if (f == -1.9E23f) {
            bl180 = true;
        }
        this.harness.check(bl180, "normal case double to float");
    }

    private final void testStringConversion() {
        String stringvalue = "StringValue:";
        String asstring = "(as String)";
        boolean ztrue = true;
        boolean zfalse = false;
        this.harness.checkPoint("boolean to string");
        this.harness.check(stringvalue + ztrue, (Object)(stringvalue + new Boolean(ztrue)));
        this.harness.check(stringvalue + ztrue, (Object)(stringvalue + new Boolean(ztrue).toString()));
        this.harness.check(ztrue + asstring, (Object)(new Boolean(ztrue) + asstring));
        this.harness.check(ztrue + asstring, (Object)(new Boolean(ztrue).toString() + asstring));
        this.harness.check(stringvalue + zfalse, (Object)(stringvalue + new Boolean(zfalse)));
        this.harness.check(stringvalue + zfalse, (Object)(stringvalue + new Boolean(zfalse).toString()));
        this.harness.check(zfalse + asstring, (Object)(new Boolean(zfalse) + asstring));
        this.harness.check(zfalse + asstring, (Object)(new Boolean(zfalse).toString() + asstring));
        this.harness.checkPoint("byte to string");
        int bnul = 0;
        int bpos = 1;
        int bneg = -1;
        int bmax = 127;
        int bmin = -128;
        this.harness.check(stringvalue + bnul, (Object)(stringvalue + new Integer(bnul)));
        this.harness.check(stringvalue + bnul, (Object)(stringvalue + Integer.toString(bnul)));
        this.harness.check(bnul + asstring, (Object)(new Integer(bnul) + asstring));
        this.harness.check(bnul + asstring, (Object)(Integer.toString(bnul) + asstring));
        this.harness.check(stringvalue + bpos, (Object)(stringvalue + new Integer(bpos)));
        this.harness.check(stringvalue + bpos, (Object)(stringvalue + Integer.toString(bpos)));
        this.harness.check(bpos + asstring, (Object)(new Integer(bpos) + asstring));
        this.harness.check(bpos + asstring, (Object)(Integer.toString(bpos) + asstring));
        this.harness.check(stringvalue + bneg, (Object)(stringvalue + new Integer(bneg)));
        this.harness.check(stringvalue + bneg, (Object)(stringvalue + Integer.toString(bneg)));
        this.harness.check(bneg + asstring, (Object)(new Integer(bneg) + asstring));
        this.harness.check(bneg + asstring, (Object)(Integer.toString(bneg) + asstring));
        this.harness.check(stringvalue + bmax, (Object)(stringvalue + new Integer(bmax)));
        this.harness.check(stringvalue + bmax, (Object)(stringvalue + Integer.toString(bmax)));
        this.harness.check(bmax + asstring, (Object)(new Integer(bmax) + asstring));
        this.harness.check(bmax + asstring, (Object)(Integer.toString(bmax) + asstring));
        this.harness.check(stringvalue + bmin, (Object)(stringvalue + new Integer(bmin)));
        this.harness.check(stringvalue + bmin, (Object)(stringvalue + Integer.toString(bmin)));
        this.harness.check(bmin + asstring, (Object)(new Integer(bmin) + asstring));
        this.harness.check(bmin + asstring, (Object)(Integer.toString(bmin) + asstring));
        this.harness.checkPoint("char to string");
        char cpos = '\u0080';
        char cneg = '\u8000';
        char cmax = (char)-1;
        char cmin = '\u0000';
        this.harness.check(stringvalue + cpos, (Object)(stringvalue + new Character(cpos)));
        this.harness.check(stringvalue + cpos, (Object)(stringvalue + new Character(cpos).toString()));
        this.harness.check(cpos + asstring, (Object)(new Character(cpos) + asstring));
        this.harness.check(cpos + asstring, (Object)(new Character(cpos).toString() + asstring));
        this.harness.check(stringvalue + cneg, (Object)(stringvalue + new Character(cneg)));
        this.harness.check(stringvalue + cneg, (Object)(stringvalue + new Character(cneg).toString()));
        this.harness.check(cneg + asstring, (Object)(new Character(cneg) + asstring));
        this.harness.check(cneg + asstring, (Object)(new Character(cneg).toString() + asstring));
        this.harness.check(stringvalue + cmax, (Object)(stringvalue + new Character(cmax)));
        this.harness.check(stringvalue + cmax, (Object)(stringvalue + new Character(cmax).toString()));
        this.harness.check(cmax + asstring, (Object)(new Character(cmax) + asstring));
        this.harness.check(cmax + asstring, (Object)(new Character(cmax).toString() + asstring));
        this.harness.check(stringvalue + cmin, (Object)(stringvalue + new Character(cmin)));
        this.harness.check(stringvalue + cmin, (Object)(stringvalue + new Character(cmin).toString()));
        this.harness.check(cmin + asstring, (Object)(new Character(cmin) + asstring));
        this.harness.check(cmin + asstring, (Object)(new Character(cmin).toString() + asstring));
        this.harness.checkPoint("short to string");
        int snul = 0;
        int spos = 128;
        int sneg = -129;
        int smax = Short.MAX_VALUE;
        int smin = Short.MIN_VALUE;
        this.harness.check(stringvalue + snul, (Object)(stringvalue + new Integer(snul)));
        this.harness.check(stringvalue + snul, (Object)(stringvalue + Integer.toString(snul)));
        this.harness.check(snul + asstring, (Object)(new Integer(snul) + asstring));
        this.harness.check(snul + asstring, (Object)(Integer.toString(snul) + asstring));
        this.harness.check(stringvalue + spos, (Object)(stringvalue + new Integer(spos)));
        this.harness.check(stringvalue + spos, (Object)(stringvalue + Integer.toString(spos)));
        this.harness.check(spos + asstring, (Object)(new Integer(spos) + asstring));
        this.harness.check(spos + asstring, (Object)(Integer.toString(spos) + asstring));
        this.harness.check(stringvalue + sneg, (Object)(stringvalue + new Integer(sneg)));
        this.harness.check(stringvalue + sneg, (Object)(stringvalue + Integer.toString(sneg)));
        this.harness.check(sneg + asstring, (Object)(new Integer(sneg) + asstring));
        this.harness.check(sneg + asstring, (Object)(Integer.toString(sneg) + asstring));
        this.harness.check(stringvalue + smax, (Object)(stringvalue + new Integer(smax)));
        this.harness.check(stringvalue + smax, (Object)(stringvalue + Integer.toString(smax)));
        this.harness.check(smax + asstring, (Object)(new Integer(smax) + asstring));
        this.harness.check(smax + asstring, (Object)(Integer.toString(smax) + asstring));
        this.harness.check(stringvalue + smin, (Object)(stringvalue + new Integer(smin)));
        this.harness.check(stringvalue + smin, (Object)(stringvalue + Integer.toString(smin)));
        this.harness.check(smin + asstring, (Object)(new Integer(smin) + asstring));
        this.harness.check(smin + asstring, (Object)(Integer.toString(smin) + asstring));
        this.harness.checkPoint("int to string");
        int inul = 0;
        int ipos = 32768;
        int ineg = -32769;
        int imax = Integer.MAX_VALUE;
        int imin = Integer.MIN_VALUE;
        this.harness.check(stringvalue + inul, (Object)(stringvalue + new Integer(inul)));
        this.harness.check(stringvalue + inul, (Object)(stringvalue + Integer.toString(inul)));
        this.harness.check(inul + asstring, (Object)(new Integer(inul) + asstring));
        this.harness.check(inul + asstring, (Object)(Integer.toString(inul) + asstring));
        this.harness.check(stringvalue + ipos, (Object)(stringvalue + new Integer(ipos)));
        this.harness.check(stringvalue + ipos, (Object)(stringvalue + Integer.toString(ipos)));
        this.harness.check(ipos + asstring, (Object)(new Integer(ipos) + asstring));
        this.harness.check(ipos + asstring, (Object)(Integer.toString(ipos) + asstring));
        this.harness.check(stringvalue + ineg, (Object)(stringvalue + new Integer(ineg)));
        this.harness.check(stringvalue + ineg, (Object)(stringvalue + Integer.toString(ineg)));
        this.harness.check(ineg + asstring, (Object)(new Integer(ineg) + asstring));
        this.harness.check(ineg + asstring, (Object)(Integer.toString(ineg) + asstring));
        this.harness.check(stringvalue + imax, (Object)(stringvalue + new Integer(imax)));
        this.harness.check(stringvalue + imax, (Object)(stringvalue + Integer.toString(imax)));
        this.harness.check(imax + asstring, (Object)(new Integer(imax) + asstring));
        this.harness.check(imax + asstring, (Object)(Integer.toString(imax) + asstring));
        this.harness.check(stringvalue + imin, (Object)(stringvalue + new Integer(imin)));
        this.harness.check(stringvalue + imin, (Object)(stringvalue + Integer.toString(imin)));
        this.harness.check(imin + asstring, (Object)(new Integer(imin) + asstring));
        this.harness.check(imin + asstring, (Object)(Integer.toString(imin) + asstring));
        this.harness.checkPoint("long to string");
        long lnul = 0L;
        long lpos = 0x800000000000L;
        long lneg = -140737488355329L;
        long lmax = Long.MAX_VALUE;
        long lmin = Long.MIN_VALUE;
        this.harness.check(stringvalue + lnul, (Object)(stringvalue + new Long(lnul)));
        this.harness.check(stringvalue + lnul, (Object)(stringvalue + Long.toString(lnul)));
        this.harness.check(lnul + asstring, (Object)(new Long(lnul) + asstring));
        this.harness.check(lnul + asstring, (Object)(Long.toString(lnul) + asstring));
        this.harness.check(stringvalue + lpos, (Object)(stringvalue + new Long(lpos)));
        this.harness.check(stringvalue + lpos, (Object)(stringvalue + Long.toString(lpos)));
        this.harness.check(lpos + asstring, (Object)(new Long(lpos) + asstring));
        this.harness.check(lpos + asstring, (Object)(Long.toString(lpos) + asstring));
        this.harness.check(stringvalue + lneg, (Object)(stringvalue + new Long(lneg)));
        this.harness.check(stringvalue + lneg, (Object)(stringvalue + Long.toString(lneg)));
        this.harness.check(lneg + asstring, (Object)(new Long(lneg) + asstring));
        this.harness.check(lneg + asstring, (Object)(Long.toString(lneg) + asstring));
        this.harness.check(stringvalue + lmax, (Object)(stringvalue + new Long(lmax)));
        this.harness.check(stringvalue + lmax, (Object)(stringvalue + Long.toString(lmax)));
        this.harness.check(lmax + asstring, (Object)(new Long(lmax) + asstring));
        this.harness.check(lmax + asstring, (Object)(Long.toString(lmax) + asstring));
        this.harness.check(stringvalue + lmin, (Object)(stringvalue + new Long(lmin)));
        this.harness.check(stringvalue + lmin, (Object)(stringvalue + Long.toString(lmin)));
        this.harness.check(lmin + asstring, (Object)(new Long(lmin) + asstring));
        this.harness.check(lmin + asstring, (Object)(Long.toString(lmin) + asstring));
        this.harness.checkPoint("float to string");
        float fnul = 0.0f;
        float fpos = 0.01f;
        float fneg = -0.01f;
        float fmax = Float.MAX_VALUE;
        float fmin = Float.MIN_VALUE;
        float fpin = Float.POSITIVE_INFINITY;
        float fnin = Float.NEGATIVE_INFINITY;
        float fnan = Float.NaN;
        this.harness.check(stringvalue + fnul, (Object)(stringvalue + new Float(fnul)));
        this.harness.check(stringvalue + fnul, (Object)(stringvalue + Float.toString(fnul)));
        this.harness.check(fnul + asstring, (Object)(new Float(fnul) + asstring));
        this.harness.check(fnul + asstring, (Object)(Float.toString(fnul) + asstring));
        this.harness.check(stringvalue + fpos, (Object)(stringvalue + new Float(fpos)));
        this.harness.check(stringvalue + fpos, (Object)(stringvalue + Float.toString(fpos)));
        this.harness.check(fpos + asstring, (Object)(new Float(fpos) + asstring));
        this.harness.check(fpos + asstring, (Object)(Float.toString(fpos) + asstring));
        this.harness.check(stringvalue + fneg, (Object)(stringvalue + new Float(fneg)));
        this.harness.check(stringvalue + fneg, (Object)(stringvalue + Float.toString(fneg)));
        this.harness.check(fneg + asstring, (Object)(new Float(fneg) + asstring));
        this.harness.check(fneg + asstring, (Object)(Float.toString(fneg) + asstring));
        this.harness.check(stringvalue + fmax, (Object)(stringvalue + Float.toString(fmax)));
        this.harness.check(fmax + asstring, (Object)(Float.toString(fmax) + asstring));
        this.harness.check(stringvalue + fmin, (Object)(stringvalue + Float.toString(fmin)));
        this.harness.check(fmin + asstring, (Object)(Float.toString(fmin) + asstring));
        this.harness.check(stringvalue + fpin, (Object)(stringvalue + Float.toString(fpin)));
        this.harness.check(fpin + asstring, (Object)(Float.toString(fpin) + asstring));
        this.harness.check(stringvalue + fnin, (Object)(stringvalue + Float.toString(fnin)));
        this.harness.check(fnin + asstring, (Object)(Float.toString(fnin) + asstring));
        this.harness.check(stringvalue + fnan, (Object)(stringvalue + Float.toString(fnan)));
        this.harness.check(fnan + asstring, (Object)(Float.toString(fnan) + asstring));
        this.harness.checkPoint("double to string");
        double dnul = 0.0;
        double dpos = 1.0E-4f;
        double dneg = -1.0E-4f;
        double dmax = Double.MAX_VALUE;
        double dmin = Double.MIN_VALUE;
        double dpin = Double.POSITIVE_INFINITY;
        double dnin = Double.NEGATIVE_INFINITY;
        double dnan = Double.NaN;
        this.harness.check(stringvalue + dnul, (Object)(stringvalue + new Double(dnul)));
        this.harness.check(stringvalue + dnul, (Object)(stringvalue + Double.toString(dnul)));
        this.harness.check(dnul + asstring, (Object)(new Double(dnul) + asstring));
        this.harness.check(dnul + asstring, (Object)(Double.toString(dnul) + asstring));
        this.harness.check(stringvalue + dpos, (Object)(stringvalue + new Double(dpos)));
        this.harness.check(stringvalue + dpos, (Object)(stringvalue + Double.toString(dpos)));
        this.harness.check(dpos + asstring, (Object)(new Double(dpos) + asstring));
        this.harness.check(dpos + asstring, (Object)(Double.toString(dpos) + asstring));
        this.harness.check(stringvalue + dneg, (Object)(stringvalue + new Double(dneg)));
        this.harness.check(stringvalue + dneg, (Object)(stringvalue + Double.toString(dneg)));
        this.harness.check(dneg + asstring, (Object)(new Double(dneg) + asstring));
        this.harness.check(dneg + asstring, (Object)(Double.toString(dneg) + asstring));
        this.harness.check(stringvalue + dmax, (Object)(stringvalue + Double.toString(dmax)));
        this.harness.check(dmax + asstring, (Object)(Double.toString(dmax) + asstring));
        this.harness.check(stringvalue + dmin, (Object)(stringvalue + Double.toString(dmin)));
        this.harness.check(dmin + asstring, (Object)(Double.toString(dmin) + asstring));
        this.harness.check(stringvalue + dpin, (Object)(stringvalue + Double.toString(dpin)));
        this.harness.check(dpin + asstring, (Object)(Double.toString(dpin) + asstring));
        this.harness.check(stringvalue + dnin, (Object)(stringvalue + Double.toString(dnin)));
        this.harness.check(dnin + asstring, (Object)(Double.toString(dnin) + asstring));
        this.harness.check(stringvalue + dnan, (Object)(stringvalue + Double.toString(dnan)));
        this.harness.check(dnan + asstring, (Object)(Double.toString(dnan) + asstring));
    }

    private final char getType(boolean z) {
        return 'Z';
    }

    private final char getType(byte b) {
        return 'B';
    }

    private final char getType(short s) {
        return 'S';
    }

    private final char getType(char c) {
        return 'C';
    }

    private final char getType(int i) {
        return 'I';
    }

    private final char getType(long l) {
        return 'L';
    }

    private final char getType(float f) {
        return 'F';
    }

    private final char getType(double d) {
        return 'D';
    }

    private final void testPromotionUnary() {
        int b3 = 3;
        int s3 = 3;
        int c3 = 3;
        int i3 = 3;
        int bmin3 = -3;
        int smin3 = -3;
        int cmin3 = 65531;
        int imin3 = -3;
        int b8 = 8;
        int s8 = 8;
        int c8 = 8;
        int i8 = 8;
        int[] testarray1 = new int[b8];
        int[] testarray2 = new int[s8];
        int[] testarray3 = new int[c8];
        int[] testarray0 = new int[i8];
        int i = 0;
        while (i < 8) {
            testarray0[i] = i;
            testarray1[i] = i;
            testarray2[i] = i;
            testarray3[i] = i;
            ++i;
        }
        this.harness.checkPoint("Unary arrray promotion");
        boolean bl = false;
        if (testarray1.length == testarray0.length) {
            bl = true;
        }
        this.harness.check(bl);
        boolean bl2 = false;
        if (testarray2.length == testarray0.length) {
            bl2 = true;
        }
        this.harness.check(bl2);
        boolean bl3 = false;
        if (testarray3.length == testarray0.length) {
            bl3 = true;
        }
        this.harness.check(bl3);
        boolean bl4 = false;
        if (testarray0[b3] == testarray0[i3]) {
            bl4 = true;
        }
        this.harness.check(bl4);
        boolean bl5 = false;
        if (testarray0[s3] == testarray0[i3]) {
            bl5 = true;
        }
        this.harness.check(bl5);
        boolean bl6 = false;
        if (testarray0[c3] == testarray0[i3]) {
            bl6 = true;
        }
        this.harness.check(bl6);
        boolean bl7 = false;
        if (testarray1[b3] == testarray0[i3]) {
            bl7 = true;
        }
        this.harness.check(bl7);
        boolean bl8 = false;
        if (testarray2[s3] == testarray0[i3]) {
            bl8 = true;
        }
        this.harness.check(bl8);
        boolean bl9 = false;
        if (testarray3[c3] == testarray0[i3]) {
            bl9 = true;
        }
        this.harness.check(bl9);
        long l3 = 3;
        float f3 = 3;
        double d3 = 3;
        long lmin3 = -3L;
        float fmin3 = -3.0f;
        double dmin3 = -3.0;
        this.harness.checkPoint("Unary +,-,~ promotion");
        boolean bl10 = false;
        if (this.getType(b3) == 'I') {
            bl10 = true;
        }
        this.harness.check(bl10, "unary + pos b");
        boolean bl11 = false;
        if (this.getType(s3) == 'I') {
            bl11 = true;
        }
        this.harness.check(bl11, "unary + pos s");
        boolean bl12 = false;
        if (this.getType(c3) == 'I') {
            bl12 = true;
        }
        this.harness.check(bl12, "unary + pos c");
        boolean bl13 = false;
        if (this.getType(i3) == 'I') {
            bl13 = true;
        }
        this.harness.check(bl13, "unary + pos i");
        boolean bl14 = false;
        if (this.getType(l3) == 'L') {
            bl14 = true;
        }
        this.harness.check(bl14, "unary + pos l");
        boolean bl15 = false;
        if (this.getType(f3) == 'F') {
            bl15 = true;
        }
        this.harness.check(bl15, "unary + pos f");
        boolean bl16 = false;
        if (this.getType(d3) == 'D') {
            bl16 = true;
        }
        this.harness.check(bl16, "unary + pos d");
        boolean bl17 = false;
        if (this.getType(bmin3) == 'I') {
            bl17 = true;
        }
        this.harness.check(bl17, "unary + neg b");
        boolean bl18 = false;
        if (this.getType(smin3) == 'I') {
            bl18 = true;
        }
        this.harness.check(bl18, "unary + neg s");
        boolean bl19 = false;
        if (this.getType(cmin3) == 'I') {
            bl19 = true;
        }
        this.harness.check(bl19, "unary + neg c");
        boolean bl20 = false;
        if (this.getType(imin3) == 'I') {
            bl20 = true;
        }
        this.harness.check(bl20, "unary + neg i");
        boolean bl21 = false;
        if (this.getType(lmin3) == 'L') {
            bl21 = true;
        }
        this.harness.check(bl21, "unary + neg l");
        boolean bl22 = false;
        if (this.getType(fmin3) == 'F') {
            bl22 = true;
        }
        this.harness.check(bl22, "unary + neg f");
        boolean bl23 = false;
        if (this.getType(dmin3) == 'D') {
            bl23 = true;
        }
        this.harness.check(bl23, "unary + neg d");
        boolean bl24 = false;
        if (this.getType(-b3) == 'I') {
            bl24 = true;
        }
        this.harness.check(bl24, "unary + pos b");
        boolean bl25 = false;
        if (this.getType(-s3) == 'I') {
            bl25 = true;
        }
        this.harness.check(bl25, "unary + pos s");
        boolean bl26 = false;
        if (this.getType(-c3) == 'I') {
            bl26 = true;
        }
        this.harness.check(bl26, "unary + pos c");
        boolean bl27 = false;
        if (this.getType(-i3) == 'I') {
            bl27 = true;
        }
        this.harness.check(bl27, "unary + pos i");
        boolean bl28 = false;
        if (this.getType(-l3) == 'L') {
            bl28 = true;
        }
        this.harness.check(bl28, "unary + pos l");
        boolean bl29 = false;
        if (this.getType(-f3) == 'F') {
            bl29 = true;
        }
        this.harness.check(bl29, "unary + pos f");
        boolean bl30 = false;
        if (this.getType(-d3) == 'D') {
            bl30 = true;
        }
        this.harness.check(bl30, "unary + pos d");
        boolean bl31 = false;
        if (this.getType(-bmin3) == 'I') {
            bl31 = true;
        }
        this.harness.check(bl31, "unary + neg b");
        boolean bl32 = false;
        if (this.getType(-smin3) == 'I') {
            bl32 = true;
        }
        this.harness.check(bl32, "unary + neg s");
        boolean bl33 = false;
        if (this.getType(-cmin3) == 'I') {
            bl33 = true;
        }
        this.harness.check(bl33, "unary + neg c");
        boolean bl34 = false;
        if (this.getType(-imin3) == 'I') {
            bl34 = true;
        }
        this.harness.check(bl34, "unary + neg i");
        boolean bl35 = false;
        if (this.getType(-lmin3) == 'L') {
            bl35 = true;
        }
        this.harness.check(bl35, "unary + neg l");
        boolean bl36 = false;
        if (this.getType(-fmin3) == 'F') {
            bl36 = true;
        }
        this.harness.check(bl36, "unary + neg f");
        boolean bl37 = false;
        if (this.getType(-dmin3) == 'D') {
            bl37 = true;
        }
        this.harness.check(bl37, "unary + neg d");
        boolean bl38 = false;
        if (this.getType(~b3) == 'I') {
            bl38 = true;
        }
        this.harness.check(bl38, "unary ~ pos b");
        boolean bl39 = false;
        if (this.getType(~s3) == 'I') {
            bl39 = true;
        }
        this.harness.check(bl39, "unary ~ pos s");
        boolean bl40 = false;
        if (this.getType(~c3) == 'I') {
            bl40 = true;
        }
        this.harness.check(bl40, "unary ~ pos c");
        boolean bl41 = false;
        if (this.getType(~i3) == 'I') {
            bl41 = true;
        }
        this.harness.check(bl41, "unary ~ pos i");
        boolean bl42 = false;
        if (this.getType(l3 ^ -1L) == 'L') {
            bl42 = true;
        }
        this.harness.check(bl42, "unary ~ pos l");
        boolean bl43 = false;
        if (this.getType(~bmin3) == 'I') {
            bl43 = true;
        }
        this.harness.check(bl43, "unary ~ neg b");
        boolean bl44 = false;
        if (this.getType(~smin3) == 'I') {
            bl44 = true;
        }
        this.harness.check(bl44, "unary ~ neg s");
        boolean bl45 = false;
        if (this.getType(~cmin3) == 'I') {
            bl45 = true;
        }
        this.harness.check(bl45, "unary ~ neg c");
        boolean bl46 = false;
        if (this.getType(~imin3) == 'I') {
            bl46 = true;
        }
        this.harness.check(bl46, "unary ~ neg i");
        boolean bl47 = false;
        if (this.getType(lmin3 ^ -1L) == 'L') {
            bl47 = true;
        }
        this.harness.check(bl47, "unary ~ neg l");
        this.harness.checkPoint("Unary >>, <<, >>> promotion on base");
        boolean bl48 = false;
        if (this.getType(b8 >> 3) == 'I') {
            bl48 = true;
        }
        this.harness.check(bl48, "unary >> (pos operator)");
        boolean bl49 = false;
        if (this.getType(b8 >> 3) == 'I') {
            bl49 = true;
        }
        this.harness.check(bl49, "unary >> (pos operator)");
        boolean bl50 = false;
        if (this.getType(s8 >> 3) == 'I') {
            bl50 = true;
        }
        this.harness.check(bl50, "unary >> (pos operator)");
        boolean bl51 = false;
        if (this.getType(s8 >> 3) == 'I') {
            bl51 = true;
        }
        this.harness.check(bl51, "unary >> (pos operator)");
        boolean bl52 = false;
        if (this.getType(c8 >> 3) == 'I') {
            bl52 = true;
        }
        this.harness.check(bl52, "unary >> (pos operator)");
        boolean bl53 = false;
        if (this.getType(c8 >> 3) == 'I') {
            bl53 = true;
        }
        this.harness.check(bl53, "unary >> (pos operator)");
        boolean bl54 = false;
        if (this.getType(i8 >> 3) == 'I') {
            bl54 = true;
        }
        this.harness.check(bl54, "unary >> (pos operator)");
        boolean bl55 = false;
        if (this.getType(i8 >> 3) == 'I') {
            bl55 = true;
        }
        this.harness.check(bl55, "unary >> (pos operator)");
        boolean bl56 = false;
        if (this.getType(b8 >> -3) == 'I') {
            bl56 = true;
        }
        this.harness.check(bl56, "unary >> (neg operator)");
        boolean bl57 = false;
        if (this.getType(b8 >> -3) == 'I') {
            bl57 = true;
        }
        this.harness.check(bl57, "unary >> (neg operator)");
        boolean bl58 = false;
        if (this.getType(s8 >> -3) == 'I') {
            bl58 = true;
        }
        this.harness.check(bl58, "unary >> (neg operator)");
        boolean bl59 = false;
        if (this.getType(s8 >> -3) == 'I') {
            bl59 = true;
        }
        this.harness.check(bl59, "unary >> (neg operator)");
        boolean bl60 = false;
        if (this.getType(c8 >> -3) == 'I') {
            bl60 = true;
        }
        this.harness.check(bl60, "unary >> (neg operator)");
        boolean bl61 = false;
        if (this.getType(c8 >> -3) == 'I') {
            bl61 = true;
        }
        this.harness.check(bl61, "unary >> (neg operator)");
        boolean bl62 = false;
        if (this.getType(i8 >> -3) == 'I') {
            bl62 = true;
        }
        this.harness.check(bl62, "unary >> (neg operator)");
        boolean bl63 = false;
        if (this.getType(i8 >> -3) == 'I') {
            bl63 = true;
        }
        this.harness.check(bl63, "unary >> (neg operator)");
        boolean bl64 = false;
        if (this.getType(b8 << 3) == 'I') {
            bl64 = true;
        }
        this.harness.check(bl64, "unary <<");
        boolean bl65 = false;
        if (this.getType(b8 << 3) == 'I') {
            bl65 = true;
        }
        this.harness.check(bl65, "unary <<");
        boolean bl66 = false;
        if (this.getType(s8 << 3) == 'I') {
            bl66 = true;
        }
        this.harness.check(bl66, "unary <<");
        boolean bl67 = false;
        if (this.getType(s8 << 3) == 'I') {
            bl67 = true;
        }
        this.harness.check(bl67, "unary <<");
        boolean bl68 = false;
        if (this.getType(c8 << 3) == 'I') {
            bl68 = true;
        }
        this.harness.check(bl68, "unary <<");
        boolean bl69 = false;
        if (this.getType(c8 << 3) == 'I') {
            bl69 = true;
        }
        this.harness.check(bl69, "unary <<");
        boolean bl70 = false;
        if (this.getType(i8 << 3) == 'I') {
            bl70 = true;
        }
        this.harness.check(bl70, "unary <<");
        boolean bl71 = false;
        if (this.getType(i8 << 3) == 'I') {
            bl71 = true;
        }
        this.harness.check(bl71, "unary <<");
        boolean bl72 = false;
        if (this.getType(b8 >>> 3) == 'I') {
            bl72 = true;
        }
        this.harness.check(bl72, "unary >>>");
        boolean bl73 = false;
        if (this.getType(b8 >>> 3) == 'I') {
            bl73 = true;
        }
        this.harness.check(bl73, "unary >>>");
        boolean bl74 = false;
        if (this.getType(s8 >>> 3) == 'I') {
            bl74 = true;
        }
        this.harness.check(bl74, "unary >>>");
        boolean bl75 = false;
        if (this.getType(s8 >>> 3) == 'I') {
            bl75 = true;
        }
        this.harness.check(bl75, "unary >>>");
        boolean bl76 = false;
        if (this.getType(c8 >>> 3) == 'I') {
            bl76 = true;
        }
        this.harness.check(bl76, "unary >>>");
        boolean bl77 = false;
        if (this.getType(c8 >>> 3) == 'I') {
            bl77 = true;
        }
        this.harness.check(bl77, "unary >>>");
        boolean bl78 = false;
        if (this.getType(i8 >>> 3) == 'I') {
            bl78 = true;
        }
        this.harness.check(bl78, "unary >>>");
        boolean bl79 = false;
        if (this.getType(i8 >>> 3) == 'I') {
            bl79 = true;
        }
        this.harness.check(bl79, "unary >>>");
        this.harness.checkPoint("Unary >>, <<, >>> promotion on operand");
        boolean bl80 = false;
        if (25 >> b3 == 25 >> i3) {
            bl80 = true;
        }
        this.harness.check(bl80, "unary >> (pos operand)");
        boolean bl81 = false;
        if (25L >> b3 == 25L >> i3) {
            bl81 = true;
        }
        this.harness.check(bl81, "unary >> (pos operand)");
        boolean bl82 = false;
        if (25 >> s3 == 25 >> i3) {
            bl82 = true;
        }
        this.harness.check(bl82, "unary >> (pos operand)");
        boolean bl83 = false;
        if (25L >> s3 == 25L >> i3) {
            bl83 = true;
        }
        this.harness.check(bl83, "unary >> (pos operand)");
        boolean bl84 = false;
        if (25 >> c3 == 25 >> i3) {
            bl84 = true;
        }
        this.harness.check(bl84, "unary >> (pos operand)");
        boolean bl85 = false;
        if (25L >> c3 == 25L >> i3) {
            bl85 = true;
        }
        this.harness.check(bl85, "unary >> (pos operand)");
        boolean bl86 = false;
        if (25 >> bmin3 == 25 >> imin3) {
            bl86 = true;
        }
        this.harness.check(bl86, "unary >> (neg operand)");
        boolean bl87 = false;
        if (25L >> bmin3 == 25L >> imin3) {
            bl87 = true;
        }
        this.harness.check(bl87, "unary >> (neg operand)");
        boolean bl88 = false;
        if (25 >> smin3 == 25 >> imin3) {
            bl88 = true;
        }
        this.harness.check(bl88, "unary >> (neg operand)");
        boolean bl89 = false;
        if (25L >> smin3 == 25L >> imin3) {
            bl89 = true;
        }
        this.harness.check(bl89, "unary >> (neg operand)");
        boolean bl90 = false;
        if (25 >> cmin3 == 25 >> imin3) {
            bl90 = true;
        }
        this.harness.check(bl90, "unary >> (neg operand)");
        boolean bl91 = false;
        if (25L >> cmin3 == 25L >> imin3) {
            bl91 = true;
        }
        this.harness.check(bl91, "unary >> (neg operand)");
        boolean bl92 = false;
        if (25 << b3 == 25 << i3) {
            bl92 = true;
        }
        this.harness.check(bl92, "unary <<");
        boolean bl93 = false;
        if (25L << b3 == 25L << i3) {
            bl93 = true;
        }
        this.harness.check(bl93, "unary <<");
        boolean bl94 = false;
        if (25 << s3 == 25 << i3) {
            bl94 = true;
        }
        this.harness.check(bl94, "unary <<");
        boolean bl95 = false;
        if (25L << s3 == 25L << i3) {
            bl95 = true;
        }
        this.harness.check(bl95, "unary <<");
        boolean bl96 = false;
        if (25 << c3 == 25 << i3) {
            bl96 = true;
        }
        this.harness.check(bl96, "unary <<");
        boolean bl97 = false;
        if (25L << c3 == 25L << i3) {
            bl97 = true;
        }
        this.harness.check(bl97, "unary <<");
        boolean bl98 = false;
        if (25 >>> b3 == 25 >>> i3) {
            bl98 = true;
        }
        this.harness.check(bl98, "unary >>>");
        boolean bl99 = false;
        if (25L >>> b3 == 25L >>> i3) {
            bl99 = true;
        }
        this.harness.check(bl99, "unary >>>");
        boolean bl100 = false;
        if (25 >>> s3 == 25 >>> i3) {
            bl100 = true;
        }
        this.harness.check(bl100, "unary >>>");
        boolean bl101 = false;
        if (25L >>> s3 == 25L >>> i3) {
            bl101 = true;
        }
        this.harness.check(bl101, "unary >>>");
        boolean bl102 = false;
        if (25 >>> c3 == 25 >>> i3) {
            bl102 = true;
        }
        this.harness.check(bl102, "unary >>>");
        boolean bl103 = false;
        if (25L >>> c3 == 25L >>> i3) {
            bl103 = true;
        }
        this.harness.check(bl103, "unary >>>");
    }

    private final void testPromotionBinary() {
        this.harness.checkPoint("Binary pronotion on <+> operand");
        this.testPromotionAddition();
        this.harness.checkPoint("Binary pronotion on <-> operand");
        this.testPromotionSubtraction();
        this.harness.checkPoint("Binary pronotion on <*> operand");
        this.testPromotionMultiplication();
        this.harness.checkPoint("Binary pronotion on </> operand");
        this.testPromotionDivision();
        this.harness.checkPoint("Binary pronotion on <%> operand");
        this.testPromotionRemainder();
        this.harness.checkPoint("Binary pronotion on bitwise <&> operand");
        this.testPromotionBitwiseAnd();
        this.harness.checkPoint("Binary pronotion on bitwise <|> operand");
        this.testPromotionBitwiseOr();
        this.harness.checkPoint("Binary pronotion on bitwise <^> operand");
        this.testPromotionBitwiseXor();
        this.harness.checkPoint("Binary pronotion smaller then (<) comparison");
        this.testPromotionCompareSmaller();
        this.harness.checkPoint("Binary pronotion smaller-equals (<=) comparison");
        this.testPromotionCompareSmallerEquals();
        this.harness.checkPoint("Binary pronotion equality (==) comparison");
        this.testPromotionCompareEqual();
        this.harness.checkPoint("Binary pronotion not-equal (!=) comparison");
        this.testPromotionCompareNotEqual();
        this.harness.checkPoint("Binary pronotion bigger then (>) comparison");
        this.testPromotionCompareBigger();
        this.harness.checkPoint("Binary pronotion bigger-equals (>=) comparison");
        this.testPromotionCompareBiggerEquals();
        this.harness.checkPoint("Binary pronotion conditional operator (b)?x1:x2");
        this.testPromotionConditionalOperator();
    }

    private final void testPromotionAddition() {
        int b3 = 3;
        int s3 = 3;
        int c3 = 3;
        int i3 = 3;
        long l3 = 3;
        float f3 = 3;
        double d3 = 3;
        int b8 = 8;
        int s8 = 8;
        int c8 = 8;
        int i8 = 8;
        long l8 = 8L;
        float f8 = 8.0f;
        double d8 = 8.0;
        boolean bl = false;
        if ((double)b8 + d3 == d8 + d3) {
            bl = true;
        }
        this.harness.check(bl, "to double, equals");
        boolean bl2 = false;
        if (d8 + (double)b3 == d8 + d3) {
            bl2 = true;
        }
        this.harness.check(bl2, "to double, equals");
        boolean bl3 = false;
        if (this.getType((double)b8 + d3) == 'D') {
            bl3 = true;
        }
        this.harness.check(bl3, "check type==double");
        boolean bl4 = false;
        if (this.getType(d8 + (double)b3) == 'D') {
            bl4 = true;
        }
        this.harness.check(bl4, "result should be double");
        boolean bl5 = false;
        if ((double)s8 + d3 == d8 + d3) {
            bl5 = true;
        }
        this.harness.check(bl5, "to double, equals");
        boolean bl6 = false;
        if (d8 + (double)s3 == d8 + d3) {
            bl6 = true;
        }
        this.harness.check(bl6, "to double, equals");
        boolean bl7 = false;
        if (this.getType((double)s8 + d3) == 'D') {
            bl7 = true;
        }
        this.harness.check(bl7, "result should be double");
        boolean bl8 = false;
        if (this.getType(d8 + (double)s3) == 'D') {
            bl8 = true;
        }
        this.harness.check(bl8, "result should be double");
        boolean bl9 = false;
        if ((double)c8 + d3 == d8 + d3) {
            bl9 = true;
        }
        this.harness.check(bl9, "to double, equals");
        boolean bl10 = false;
        if (d8 + (double)c3 == d8 + d3) {
            bl10 = true;
        }
        this.harness.check(bl10, "to double, equals");
        boolean bl11 = false;
        if (this.getType((double)c8 + d3) == 'D') {
            bl11 = true;
        }
        this.harness.check(bl11, "result should be double");
        boolean bl12 = false;
        if (this.getType(d8 + (double)c3) == 'D') {
            bl12 = true;
        }
        this.harness.check(bl12, "result should be double");
        boolean bl13 = false;
        if ((double)i8 + d3 == d8 + d3) {
            bl13 = true;
        }
        this.harness.check(bl13, "to double, equals");
        boolean bl14 = false;
        if (d8 + (double)i3 == d8 + d3) {
            bl14 = true;
        }
        this.harness.check(bl14, "to double, equals");
        boolean bl15 = false;
        if (this.getType((double)i8 + d3) == 'D') {
            bl15 = true;
        }
        this.harness.check(bl15, "result should be double");
        boolean bl16 = false;
        if (this.getType(d8 + (double)i3) == 'D') {
            bl16 = true;
        }
        this.harness.check(bl16, "result should be double");
        boolean bl17 = false;
        if ((double)l8 + d3 == d8 + d3) {
            bl17 = true;
        }
        this.harness.check(bl17, "to double, equals");
        boolean bl18 = false;
        if (d8 + (double)l3 == d8 + d3) {
            bl18 = true;
        }
        this.harness.check(bl18, "to double, equals");
        boolean bl19 = false;
        if (this.getType((double)l8 + d3) == 'D') {
            bl19 = true;
        }
        this.harness.check(bl19, "result should be double");
        boolean bl20 = false;
        if (this.getType(d8 + (double)l3) == 'D') {
            bl20 = true;
        }
        this.harness.check(bl20, "result should be double");
        boolean bl21 = false;
        if ((double)f8 + d3 == d8 + d3) {
            bl21 = true;
        }
        this.harness.check(bl21, "to double, equals");
        boolean bl22 = false;
        if (d8 + (double)f3 == d8 + d3) {
            bl22 = true;
        }
        this.harness.check(bl22, "to double, equals");
        boolean bl23 = false;
        if (this.getType((double)f8 + d3) == 'D') {
            bl23 = true;
        }
        this.harness.check(bl23, "result should be double");
        boolean bl24 = false;
        if (this.getType(d8 + (double)f3) == 'D') {
            bl24 = true;
        }
        this.harness.check(bl24, "result should be double");
        boolean bl25 = false;
        if ((float)b8 + f3 == f8 + f3) {
            bl25 = true;
        }
        this.harness.check(bl25, "to float equals");
        boolean bl26 = false;
        if (f8 + (float)b3 == f8 + f3) {
            bl26 = true;
        }
        this.harness.check(bl26, "to float equals");
        boolean bl27 = false;
        if (this.getType((float)b8 + f3) == 'F') {
            bl27 = true;
        }
        this.harness.check(bl27, "result should be float");
        boolean bl28 = false;
        if (this.getType(f8 + (float)b3) == 'F') {
            bl28 = true;
        }
        this.harness.check(bl28, "result should be float");
        boolean bl29 = false;
        if ((float)s8 + f3 == f8 + f3) {
            bl29 = true;
        }
        this.harness.check(bl29, "to float equals");
        boolean bl30 = false;
        if (f8 + (float)s3 == f8 + f3) {
            bl30 = true;
        }
        this.harness.check(bl30, "to float equals");
        boolean bl31 = false;
        if (this.getType((float)s8 + f3) == 'F') {
            bl31 = true;
        }
        this.harness.check(bl31, "result should be float");
        boolean bl32 = false;
        if (this.getType(f8 + (float)s3) == 'F') {
            bl32 = true;
        }
        this.harness.check(bl32, "result should be float");
        boolean bl33 = false;
        if ((float)c8 + f3 == f8 + f3) {
            bl33 = true;
        }
        this.harness.check(bl33, "to float equals");
        boolean bl34 = false;
        if (f8 + (float)c3 == f8 + f3) {
            bl34 = true;
        }
        this.harness.check(bl34, "to float equals");
        boolean bl35 = false;
        if (this.getType((float)c8 + f3) == 'F') {
            bl35 = true;
        }
        this.harness.check(bl35, "result should be float");
        boolean bl36 = false;
        if (this.getType(f8 + (float)c3) == 'F') {
            bl36 = true;
        }
        this.harness.check(bl36, "result should be float");
        boolean bl37 = false;
        if ((float)i8 + f3 == f8 + f3) {
            bl37 = true;
        }
        this.harness.check(bl37, "to float equals");
        boolean bl38 = false;
        if (f8 + (float)i3 == f8 + f3) {
            bl38 = true;
        }
        this.harness.check(bl38, "to float equals");
        boolean bl39 = false;
        if (this.getType((float)i8 + f3) == 'F') {
            bl39 = true;
        }
        this.harness.check(bl39, "result should be float");
        boolean bl40 = false;
        if (this.getType(f8 + (float)i3) == 'F') {
            bl40 = true;
        }
        this.harness.check(bl40, "result should be float");
        boolean bl41 = false;
        if ((float)l8 + f3 == f8 + f3) {
            bl41 = true;
        }
        this.harness.check(bl41, "to float equals");
        boolean bl42 = false;
        if (f8 + (float)l3 == f8 + f3) {
            bl42 = true;
        }
        this.harness.check(bl42, "to float equals");
        boolean bl43 = false;
        if (this.getType((float)l8 + f3) == 'F') {
            bl43 = true;
        }
        this.harness.check(bl43, "result should be float");
        boolean bl44 = false;
        if (this.getType(f8 + (float)l3) == 'F') {
            bl44 = true;
        }
        this.harness.check(bl44, "result should be float");
        boolean bl45 = false;
        if ((long)b8 + l3 == l8 + l3) {
            bl45 = true;
        }
        this.harness.check(bl45, "to long, equals");
        boolean bl46 = false;
        if (l8 + (long)b3 == l8 + l3) {
            bl46 = true;
        }
        this.harness.check(bl46, "to long, equals");
        boolean bl47 = false;
        if (this.getType((long)b8 + l3) == 'L') {
            bl47 = true;
        }
        this.harness.check(bl47, "result should be long");
        boolean bl48 = false;
        if (this.getType(l8 + (long)b3) == 'L') {
            bl48 = true;
        }
        this.harness.check(bl48, "result should be long");
        boolean bl49 = false;
        if ((long)s8 + l3 == l8 + l3) {
            bl49 = true;
        }
        this.harness.check(bl49, "to long, equals");
        boolean bl50 = false;
        if (l8 + (long)s3 == l8 + l3) {
            bl50 = true;
        }
        this.harness.check(bl50, "to long, equals");
        boolean bl51 = false;
        if (this.getType((long)s8 + l3) == 'L') {
            bl51 = true;
        }
        this.harness.check(bl51, "result should be long");
        boolean bl52 = false;
        if (this.getType(l8 + (long)s3) == 'L') {
            bl52 = true;
        }
        this.harness.check(bl52, "result should be long");
        boolean bl53 = false;
        if ((long)c8 + l3 == l8 + l3) {
            bl53 = true;
        }
        this.harness.check(bl53, "to long, equals");
        boolean bl54 = false;
        if (l8 + (long)c3 == l8 + l3) {
            bl54 = true;
        }
        this.harness.check(bl54, "to long, equals");
        boolean bl55 = false;
        if (this.getType((long)c8 + l3) == 'L') {
            bl55 = true;
        }
        this.harness.check(bl55, "result should be long");
        boolean bl56 = false;
        if (this.getType(l8 + (long)c3) == 'L') {
            bl56 = true;
        }
        this.harness.check(bl56, "result should be long");
        boolean bl57 = false;
        if ((long)i8 + l3 == l8 + l3) {
            bl57 = true;
        }
        this.harness.check(bl57, "to long, equals");
        boolean bl58 = false;
        if (l8 + (long)i3 == l8 + l3) {
            bl58 = true;
        }
        this.harness.check(bl58, "to long, equals");
        boolean bl59 = false;
        if (this.getType((long)i8 + l3) == 'L') {
            bl59 = true;
        }
        this.harness.check(bl59, "result should be long");
        boolean bl60 = false;
        if (this.getType(l8 + (long)i3) == 'L') {
            bl60 = true;
        }
        this.harness.check(bl60, "result should be long");
        boolean bl61 = false;
        if (b8 + i3 == i8 + i3) {
            bl61 = true;
        }
        this.harness.check(bl61, "to int, equals");
        boolean bl62 = false;
        if (i8 + b3 == i8 + i3) {
            bl62 = true;
        }
        this.harness.check(bl62, "to int, equals");
        boolean bl63 = false;
        if (this.getType(b8 + i3) == 'I') {
            bl63 = true;
        }
        this.harness.check(bl63, "result should be int");
        boolean bl64 = false;
        if (this.getType(i8 + b3) == 'I') {
            bl64 = true;
        }
        this.harness.check(bl64, "result should be int");
        boolean bl65 = false;
        if (s8 + i3 == i8 + i3) {
            bl65 = true;
        }
        this.harness.check(bl65, "to int, equals");
        boolean bl66 = false;
        if (i8 + s3 == i8 + i3) {
            bl66 = true;
        }
        this.harness.check(bl66, "to int, equals");
        boolean bl67 = false;
        if (this.getType(s8 + i3) == 'I') {
            bl67 = true;
        }
        this.harness.check(bl67, "result should be int");
        boolean bl68 = false;
        if (this.getType(i8 + s3) == 'I') {
            bl68 = true;
        }
        this.harness.check(bl68, "result should be int");
        boolean bl69 = false;
        if (c8 + i3 == i8 + i3) {
            bl69 = true;
        }
        this.harness.check(bl69, "to int, equals");
        boolean bl70 = false;
        if (i8 + c3 == i8 + i3) {
            bl70 = true;
        }
        this.harness.check(bl70, "to int, equals");
        boolean bl71 = false;
        if (this.getType(c8 + i3) == 'I') {
            bl71 = true;
        }
        this.harness.check(bl71, "result should be int");
        boolean bl72 = false;
        if (this.getType(i8 + c3) == 'I') {
            bl72 = true;
        }
        this.harness.check(bl72, "result should be int");
        boolean bl73 = false;
        if (b8 + c3 == i8 + i3) {
            bl73 = true;
        }
        this.harness.check(bl73, "to int, equals");
        boolean bl74 = false;
        if (c8 + b3 == i8 + i3) {
            bl74 = true;
        }
        this.harness.check(bl74, "to int, equals");
        boolean bl75 = false;
        if (this.getType(b8 + c3) == 'I') {
            bl75 = true;
        }
        this.harness.check(bl75, "result should be int");
        boolean bl76 = false;
        if (this.getType(c8 + b3) == 'I') {
            bl76 = true;
        }
        this.harness.check(bl76, "result should be int");
        boolean bl77 = false;
        if (s8 + c3 == i8 + i3) {
            bl77 = true;
        }
        this.harness.check(bl77, "to int, equals");
        boolean bl78 = false;
        if (c8 + s3 == i8 + i3) {
            bl78 = true;
        }
        this.harness.check(bl78, "to int, equals");
        boolean bl79 = false;
        if (this.getType(b8 + c3) == 'I') {
            bl79 = true;
        }
        this.harness.check(bl79, "result should be int");
        boolean bl80 = false;
        if (this.getType(c8 + b3) == 'I') {
            bl80 = true;
        }
        this.harness.check(bl80, "result should be int");
        boolean bl81 = false;
        if (b8 + s3 == i8 + i3) {
            bl81 = true;
        }
        this.harness.check(bl81, "char to int, equals");
        boolean bl82 = false;
        if (s8 + b3 == i8 + i3) {
            bl82 = true;
        }
        this.harness.check(bl82, "char to int, equals");
        boolean bl83 = false;
        if (this.getType(b8 + s3) == 'I') {
            bl83 = true;
        }
        this.harness.check(bl83, "result should be int");
        boolean bl84 = false;
        if (this.getType(s8 + b3) == 'I') {
            bl84 = true;
        }
        this.harness.check(bl84, "result should be int");
    }

    private final void testPromotionSubtraction() {
        int b3 = 3;
        int s3 = 3;
        int c3 = 3;
        int i3 = 3;
        long l3 = 3;
        float f3 = 3;
        double d3 = 3;
        int b8 = 8;
        int s8 = 8;
        int c8 = 8;
        int i8 = 8;
        long l8 = 8L;
        float f8 = 8.0f;
        double d8 = 8.0;
        boolean bl = false;
        if ((double)b8 - d3 == d8 - d3) {
            bl = true;
        }
        this.harness.check(bl, "to double, equals");
        boolean bl2 = false;
        if (d8 - (double)b3 == d8 - d3) {
            bl2 = true;
        }
        this.harness.check(bl2, "to double, equals");
        boolean bl3 = false;
        if (this.getType((double)b8 - d3) == 'D') {
            bl3 = true;
        }
        this.harness.check(bl3, "result should be double");
        boolean bl4 = false;
        if (this.getType(d8 - (double)b3) == 'D') {
            bl4 = true;
        }
        this.harness.check(bl4, "result should be double");
        boolean bl5 = false;
        if ((double)s8 - d3 == d8 - d3) {
            bl5 = true;
        }
        this.harness.check(bl5, "to double, equals");
        boolean bl6 = false;
        if (d8 - (double)s3 == d8 - d3) {
            bl6 = true;
        }
        this.harness.check(bl6, "to double, equals");
        boolean bl7 = false;
        if (this.getType((double)s8 - d3) == 'D') {
            bl7 = true;
        }
        this.harness.check(bl7, "result should be double");
        boolean bl8 = false;
        if (this.getType(d8 - (double)s3) == 'D') {
            bl8 = true;
        }
        this.harness.check(bl8, "result should be double");
        boolean bl9 = false;
        if ((double)c8 - d3 == d8 - d3) {
            bl9 = true;
        }
        this.harness.check(bl9, "to double, equals");
        boolean bl10 = false;
        if (d8 - (double)c3 == d8 - d3) {
            bl10 = true;
        }
        this.harness.check(bl10, "to double, equals");
        boolean bl11 = false;
        if (this.getType((double)c8 - d3) == 'D') {
            bl11 = true;
        }
        this.harness.check(bl11, "result should be double");
        boolean bl12 = false;
        if (this.getType(d8 - (double)c3) == 'D') {
            bl12 = true;
        }
        this.harness.check(bl12, "result should be double");
        boolean bl13 = false;
        if ((double)i8 - d3 == d8 - d3) {
            bl13 = true;
        }
        this.harness.check(bl13, "to double, equals");
        boolean bl14 = false;
        if (d8 - (double)i3 == d8 - d3) {
            bl14 = true;
        }
        this.harness.check(bl14, "to double, equals");
        boolean bl15 = false;
        if (this.getType((double)i8 - d3) == 'D') {
            bl15 = true;
        }
        this.harness.check(bl15, "result should be double");
        boolean bl16 = false;
        if (this.getType(d8 - (double)i3) == 'D') {
            bl16 = true;
        }
        this.harness.check(bl16, "result should be double");
        boolean bl17 = false;
        if ((double)l8 - d3 == d8 - d3) {
            bl17 = true;
        }
        this.harness.check(bl17, "to double, equals");
        boolean bl18 = false;
        if (d8 - (double)l3 == d8 - d3) {
            bl18 = true;
        }
        this.harness.check(bl18, "to double, equals");
        boolean bl19 = false;
        if (this.getType((double)l8 - d3) == 'D') {
            bl19 = true;
        }
        this.harness.check(bl19, "result should be double");
        boolean bl20 = false;
        if (this.getType(d8 - (double)l3) == 'D') {
            bl20 = true;
        }
        this.harness.check(bl20, "result should be double");
        boolean bl21 = false;
        if ((double)f8 - d3 == d8 - d3) {
            bl21 = true;
        }
        this.harness.check(bl21, "to double, equals");
        boolean bl22 = false;
        if (d8 - (double)f3 == d8 - d3) {
            bl22 = true;
        }
        this.harness.check(bl22, "to double, equals");
        boolean bl23 = false;
        if (this.getType((double)f8 - d3) == 'D') {
            bl23 = true;
        }
        this.harness.check(bl23, "result should be double");
        boolean bl24 = false;
        if (this.getType(d8 - (double)f3) == 'D') {
            bl24 = true;
        }
        this.harness.check(bl24, "result should be double");
        boolean bl25 = false;
        if ((float)b8 - f3 == f8 - f3) {
            bl25 = true;
        }
        this.harness.check(bl25, "to float equals");
        boolean bl26 = false;
        if (f8 - (float)b3 == f8 - f3) {
            bl26 = true;
        }
        this.harness.check(bl26, "to float equals");
        boolean bl27 = false;
        if (this.getType((float)b8 - f3) == 'F') {
            bl27 = true;
        }
        this.harness.check(bl27, "result should be float");
        boolean bl28 = false;
        if (this.getType(f8 - (float)b3) == 'F') {
            bl28 = true;
        }
        this.harness.check(bl28, "result should be float");
        boolean bl29 = false;
        if ((float)s8 - f3 == f8 - f3) {
            bl29 = true;
        }
        this.harness.check(bl29, "to float equals");
        boolean bl30 = false;
        if (f8 - (float)s3 == f8 - f3) {
            bl30 = true;
        }
        this.harness.check(bl30, "to float equals");
        boolean bl31 = false;
        if (this.getType((float)s8 - f3) == 'F') {
            bl31 = true;
        }
        this.harness.check(bl31, "result should be float");
        boolean bl32 = false;
        if (this.getType(f8 - (float)s3) == 'F') {
            bl32 = true;
        }
        this.harness.check(bl32, "result should be float");
        boolean bl33 = false;
        if ((float)c8 - f3 == f8 - f3) {
            bl33 = true;
        }
        this.harness.check(bl33, "to float equals");
        boolean bl34 = false;
        if (f8 - (float)c3 == f8 - f3) {
            bl34 = true;
        }
        this.harness.check(bl34, "to float equals");
        boolean bl35 = false;
        if (this.getType((float)c8 - f3) == 'F') {
            bl35 = true;
        }
        this.harness.check(bl35, "result should be float");
        boolean bl36 = false;
        if (this.getType(f8 - (float)c3) == 'F') {
            bl36 = true;
        }
        this.harness.check(bl36, "result should be float");
        boolean bl37 = false;
        if ((float)i8 - f3 == f8 - f3) {
            bl37 = true;
        }
        this.harness.check(bl37, "to float equals");
        boolean bl38 = false;
        if (f8 - (float)i3 == f8 - f3) {
            bl38 = true;
        }
        this.harness.check(bl38, "to float equals");
        boolean bl39 = false;
        if (this.getType((float)i8 - f3) == 'F') {
            bl39 = true;
        }
        this.harness.check(bl39, "result should be float");
        boolean bl40 = false;
        if (this.getType(f8 - (float)i3) == 'F') {
            bl40 = true;
        }
        this.harness.check(bl40, "result should be float");
        boolean bl41 = false;
        if ((float)l8 - f3 == f8 - f3) {
            bl41 = true;
        }
        this.harness.check(bl41, "to float equals");
        boolean bl42 = false;
        if (f8 - (float)l3 == f8 - f3) {
            bl42 = true;
        }
        this.harness.check(bl42, "to float equals");
        boolean bl43 = false;
        if (this.getType((float)l8 - f3) == 'F') {
            bl43 = true;
        }
        this.harness.check(bl43, "result should be float");
        boolean bl44 = false;
        if (this.getType(f8 - (float)l3) == 'F') {
            bl44 = true;
        }
        this.harness.check(bl44, "result should be float");
        boolean bl45 = false;
        if ((long)b8 - l3 == l8 - l3) {
            bl45 = true;
        }
        this.harness.check(bl45, "to long, equals");
        boolean bl46 = false;
        if (l8 - (long)b3 == l8 - l3) {
            bl46 = true;
        }
        this.harness.check(bl46, "to long, equals");
        boolean bl47 = false;
        if (this.getType((long)b8 - l3) == 'L') {
            bl47 = true;
        }
        this.harness.check(bl47, "result should be long");
        boolean bl48 = false;
        if (this.getType(l8 - (long)b3) == 'L') {
            bl48 = true;
        }
        this.harness.check(bl48, "result should be long");
        boolean bl49 = false;
        if ((long)s8 - l3 == l8 - l3) {
            bl49 = true;
        }
        this.harness.check(bl49, "to long, equals");
        boolean bl50 = false;
        if (l8 - (long)s3 == l8 - l3) {
            bl50 = true;
        }
        this.harness.check(bl50, "to long, equals");
        boolean bl51 = false;
        if (this.getType((long)s8 - l3) == 'L') {
            bl51 = true;
        }
        this.harness.check(bl51, "result should be long");
        boolean bl52 = false;
        if (this.getType(l8 - (long)s3) == 'L') {
            bl52 = true;
        }
        this.harness.check(bl52, "result should be long");
        boolean bl53 = false;
        if ((long)c8 - l3 == l8 - l3) {
            bl53 = true;
        }
        this.harness.check(bl53, "to long, equals");
        boolean bl54 = false;
        if (l8 - (long)c3 == l8 - l3) {
            bl54 = true;
        }
        this.harness.check(bl54, "to long, equals");
        boolean bl55 = false;
        if (this.getType((long)c8 - l3) == 'L') {
            bl55 = true;
        }
        this.harness.check(bl55, "result should be long");
        boolean bl56 = false;
        if (this.getType(l8 - (long)c3) == 'L') {
            bl56 = true;
        }
        this.harness.check(bl56, "result should be long");
        boolean bl57 = false;
        if ((long)i8 - l3 == l8 - l3) {
            bl57 = true;
        }
        this.harness.check(bl57, "to long, equals");
        boolean bl58 = false;
        if (l8 - (long)i3 == l8 - l3) {
            bl58 = true;
        }
        this.harness.check(bl58, "to long, equals");
        boolean bl59 = false;
        if (this.getType((long)i8 - l3) == 'L') {
            bl59 = true;
        }
        this.harness.check(bl59, "result should be long");
        boolean bl60 = false;
        if (this.getType(l8 - (long)i3) == 'L') {
            bl60 = true;
        }
        this.harness.check(bl60, "result should be long");
        boolean bl61 = false;
        if (b8 - i3 == i8 - i3) {
            bl61 = true;
        }
        this.harness.check(bl61, "to int, equals");
        boolean bl62 = false;
        if (i8 - b3 == i8 - i3) {
            bl62 = true;
        }
        this.harness.check(bl62, "to int, equals");
        boolean bl63 = false;
        if (this.getType(b8 - i3) == 'I') {
            bl63 = true;
        }
        this.harness.check(bl63, "result should be int");
        boolean bl64 = false;
        if (this.getType(i8 - b3) == 'I') {
            bl64 = true;
        }
        this.harness.check(bl64, "result should be int");
        boolean bl65 = false;
        if (s8 - i3 == i8 - i3) {
            bl65 = true;
        }
        this.harness.check(bl65, "to int, equals");
        boolean bl66 = false;
        if (i8 - s3 == i8 - i3) {
            bl66 = true;
        }
        this.harness.check(bl66, "to int, equals");
        boolean bl67 = false;
        if (this.getType(s8 - i3) == 'I') {
            bl67 = true;
        }
        this.harness.check(bl67, "result should be int");
        boolean bl68 = false;
        if (this.getType(i8 - s3) == 'I') {
            bl68 = true;
        }
        this.harness.check(bl68, "result should be int");
        boolean bl69 = false;
        if (c8 - i3 == i8 - i3) {
            bl69 = true;
        }
        this.harness.check(bl69, "to int, equals");
        boolean bl70 = false;
        if (i8 - c3 == i8 - i3) {
            bl70 = true;
        }
        this.harness.check(bl70, "to int, equals");
        boolean bl71 = false;
        if (this.getType(c8 - i3) == 'I') {
            bl71 = true;
        }
        this.harness.check(bl71, "result should be int");
        boolean bl72 = false;
        if (this.getType(i8 - c3) == 'I') {
            bl72 = true;
        }
        this.harness.check(bl72, "result should be int");
        boolean bl73 = false;
        if (b8 - c3 == i8 - i3) {
            bl73 = true;
        }
        this.harness.check(bl73, "to int, equals");
        boolean bl74 = false;
        if (c8 - b3 == i8 - i3) {
            bl74 = true;
        }
        this.harness.check(bl74, "to int, equals");
        boolean bl75 = false;
        if (this.getType(b8 - c3) == 'I') {
            bl75 = true;
        }
        this.harness.check(bl75, "result should be int");
        boolean bl76 = false;
        if (this.getType(c8 - b3) == 'I') {
            bl76 = true;
        }
        this.harness.check(bl76, "result should be int");
        boolean bl77 = false;
        if (s8 - c3 == i8 - i3) {
            bl77 = true;
        }
        this.harness.check(bl77, "to int, equals");
        boolean bl78 = false;
        if (c8 - s3 == i8 - i3) {
            bl78 = true;
        }
        this.harness.check(bl78, "to int, equals");
        boolean bl79 = false;
        if (this.getType(b8 - c3) == 'I') {
            bl79 = true;
        }
        this.harness.check(bl79, "result should be int");
        boolean bl80 = false;
        if (this.getType(c8 - b3) == 'I') {
            bl80 = true;
        }
        this.harness.check(bl80, "result should be int");
        boolean bl81 = false;
        if (b8 - s3 == i8 - i3) {
            bl81 = true;
        }
        this.harness.check(bl81, "to int, equals");
        boolean bl82 = false;
        if (s8 - b3 == i8 - i3) {
            bl82 = true;
        }
        this.harness.check(bl82, "to int, equals");
        boolean bl83 = false;
        if (this.getType(b8 - s3) == 'I') {
            bl83 = true;
        }
        this.harness.check(bl83, "result should be int");
        boolean bl84 = false;
        if (this.getType(s8 - b3) == 'I') {
            bl84 = true;
        }
        this.harness.check(bl84, "result should be int");
    }

    private final void testPromotionMultiplication() {
        int b3 = 3;
        int s3 = 3;
        int c3 = 3;
        int i3 = 3;
        long l3 = 3;
        float f3 = 3;
        double d3 = 3;
        int b8 = 8;
        int s8 = 8;
        int c8 = 8;
        int i8 = 8;
        long l8 = 8L;
        float f8 = 8.0f;
        double d8 = 8.0;
        boolean bl = false;
        if ((double)b8 * d3 == d8 * d3) {
            bl = true;
        }
        this.harness.check(bl, "to double, equals");
        boolean bl2 = false;
        if (d8 * (double)b3 == d8 * d3) {
            bl2 = true;
        }
        this.harness.check(bl2, "to double, equals");
        boolean bl3 = false;
        if (this.getType((double)b8 * d3) == 'D') {
            bl3 = true;
        }
        this.harness.check(bl3, "result should be double");
        boolean bl4 = false;
        if (this.getType(d8 * (double)b3) == 'D') {
            bl4 = true;
        }
        this.harness.check(bl4, "result should be double");
        boolean bl5 = false;
        if ((double)s8 * d3 == d8 * d3) {
            bl5 = true;
        }
        this.harness.check(bl5, "to double, equals");
        boolean bl6 = false;
        if (d8 * (double)s3 == d8 * d3) {
            bl6 = true;
        }
        this.harness.check(bl6, "to double, equals");
        boolean bl7 = false;
        if (this.getType((double)s8 * d3) == 'D') {
            bl7 = true;
        }
        this.harness.check(bl7, "result should be double");
        boolean bl8 = false;
        if (this.getType(d8 * (double)s3) == 'D') {
            bl8 = true;
        }
        this.harness.check(bl8, "result should be double");
        boolean bl9 = false;
        if ((double)c8 * d3 == d8 * d3) {
            bl9 = true;
        }
        this.harness.check(bl9, "to double, equals");
        boolean bl10 = false;
        if (d8 * (double)c3 == d8 * d3) {
            bl10 = true;
        }
        this.harness.check(bl10, "to double, equals");
        boolean bl11 = false;
        if (this.getType((double)c8 * d3) == 'D') {
            bl11 = true;
        }
        this.harness.check(bl11, "result should be double");
        boolean bl12 = false;
        if (this.getType(d8 * (double)c3) == 'D') {
            bl12 = true;
        }
        this.harness.check(bl12, "result should be double");
        boolean bl13 = false;
        if ((double)i8 * d3 == d8 * d3) {
            bl13 = true;
        }
        this.harness.check(bl13, "to double, equals");
        boolean bl14 = false;
        if (d8 * (double)i3 == d8 * d3) {
            bl14 = true;
        }
        this.harness.check(bl14, "to double, equals");
        boolean bl15 = false;
        if (this.getType((double)i8 * d3) == 'D') {
            bl15 = true;
        }
        this.harness.check(bl15, "result should be double");
        boolean bl16 = false;
        if (this.getType(d8 * (double)i3) == 'D') {
            bl16 = true;
        }
        this.harness.check(bl16, "result should be double");
        boolean bl17 = false;
        if ((double)l8 * d3 == d8 * d3) {
            bl17 = true;
        }
        this.harness.check(bl17, "to double, equals");
        boolean bl18 = false;
        if (d8 * (double)l3 == d8 * d3) {
            bl18 = true;
        }
        this.harness.check(bl18, "to double, equals");
        boolean bl19 = false;
        if (this.getType((double)l8 * d3) == 'D') {
            bl19 = true;
        }
        this.harness.check(bl19, "result should be double");
        boolean bl20 = false;
        if (this.getType(d8 * (double)l3) == 'D') {
            bl20 = true;
        }
        this.harness.check(bl20, "result should be double");
        boolean bl21 = false;
        if ((double)f8 * d3 == d8 * d3) {
            bl21 = true;
        }
        this.harness.check(bl21, "to double, equals");
        boolean bl22 = false;
        if (d8 * (double)f3 == d8 * d3) {
            bl22 = true;
        }
        this.harness.check(bl22, "to double, equals");
        boolean bl23 = false;
        if (this.getType((double)f8 * d3) == 'D') {
            bl23 = true;
        }
        this.harness.check(bl23, "result should be double");
        boolean bl24 = false;
        if (this.getType(d8 * (double)f3) == 'D') {
            bl24 = true;
        }
        this.harness.check(bl24, "result should be double");
        boolean bl25 = false;
        if ((float)b8 * f3 == f8 * f3) {
            bl25 = true;
        }
        this.harness.check(bl25, "to float equals");
        boolean bl26 = false;
        if (f8 * (float)b3 == f8 * f3) {
            bl26 = true;
        }
        this.harness.check(bl26, "to float equals");
        boolean bl27 = false;
        if (this.getType((float)b8 * f3) == 'F') {
            bl27 = true;
        }
        this.harness.check(bl27, "result should be float");
        boolean bl28 = false;
        if (this.getType(f8 * (float)b3) == 'F') {
            bl28 = true;
        }
        this.harness.check(bl28, "result should be float");
        boolean bl29 = false;
        if ((float)s8 * f3 == f8 * f3) {
            bl29 = true;
        }
        this.harness.check(bl29, "to float equals");
        boolean bl30 = false;
        if (f8 * (float)s3 == f8 * f3) {
            bl30 = true;
        }
        this.harness.check(bl30, "to float equals");
        boolean bl31 = false;
        if (this.getType((float)s8 * f3) == 'F') {
            bl31 = true;
        }
        this.harness.check(bl31, "result should be float");
        boolean bl32 = false;
        if (this.getType(f8 * (float)s3) == 'F') {
            bl32 = true;
        }
        this.harness.check(bl32, "result should be float");
        boolean bl33 = false;
        if ((float)c8 * f3 == f8 * f3) {
            bl33 = true;
        }
        this.harness.check(bl33, "to float equals");
        boolean bl34 = false;
        if (f8 * (float)c3 == f8 * f3) {
            bl34 = true;
        }
        this.harness.check(bl34, "to float equals");
        boolean bl35 = false;
        if (this.getType((float)c8 * f3) == 'F') {
            bl35 = true;
        }
        this.harness.check(bl35, "result should be float");
        boolean bl36 = false;
        if (this.getType(f8 * (float)c3) == 'F') {
            bl36 = true;
        }
        this.harness.check(bl36, "result should be float");
        boolean bl37 = false;
        if ((float)i8 * f3 == f8 * f3) {
            bl37 = true;
        }
        this.harness.check(bl37, "to float equals");
        boolean bl38 = false;
        if (f8 * (float)i3 == f8 * f3) {
            bl38 = true;
        }
        this.harness.check(bl38, "to float equals");
        boolean bl39 = false;
        if (this.getType((float)i8 * f3) == 'F') {
            bl39 = true;
        }
        this.harness.check(bl39, "result should be float");
        boolean bl40 = false;
        if (this.getType(f8 * (float)i3) == 'F') {
            bl40 = true;
        }
        this.harness.check(bl40, "result should be float");
        boolean bl41 = false;
        if ((float)l8 * f3 == f8 * f3) {
            bl41 = true;
        }
        this.harness.check(bl41, "to float equals");
        boolean bl42 = false;
        if (f8 * (float)l3 == f8 * f3) {
            bl42 = true;
        }
        this.harness.check(bl42, "to float equals");
        boolean bl43 = false;
        if (this.getType((float)l8 * f3) == 'F') {
            bl43 = true;
        }
        this.harness.check(bl43, "result should be float");
        boolean bl44 = false;
        if (this.getType(f8 * (float)l3) == 'F') {
            bl44 = true;
        }
        this.harness.check(bl44, "result should be float");
        boolean bl45 = false;
        if ((long)b8 * l3 == l8 * l3) {
            bl45 = true;
        }
        this.harness.check(bl45, "to long, equals");
        boolean bl46 = false;
        if (l8 * (long)b3 == l8 * l3) {
            bl46 = true;
        }
        this.harness.check(bl46, "to long, equals");
        boolean bl47 = false;
        if (this.getType((long)b8 * l3) == 'L') {
            bl47 = true;
        }
        this.harness.check(bl47, "result should be long");
        boolean bl48 = false;
        if (this.getType(l8 * (long)b3) == 'L') {
            bl48 = true;
        }
        this.harness.check(bl48, "result should be long");
        boolean bl49 = false;
        if ((long)s8 * l3 == l8 * l3) {
            bl49 = true;
        }
        this.harness.check(bl49, "to long, equals");
        boolean bl50 = false;
        if (l8 * (long)s3 == l8 * l3) {
            bl50 = true;
        }
        this.harness.check(bl50, "to long, equals");
        boolean bl51 = false;
        if (this.getType((long)s8 * l3) == 'L') {
            bl51 = true;
        }
        this.harness.check(bl51, "result should be long");
        boolean bl52 = false;
        if (this.getType(l8 * (long)s3) == 'L') {
            bl52 = true;
        }
        this.harness.check(bl52, "result should be long");
        boolean bl53 = false;
        if ((long)c8 * l3 == l8 * l3) {
            bl53 = true;
        }
        this.harness.check(bl53, "to long, equals");
        boolean bl54 = false;
        if (l8 * (long)c3 == l8 * l3) {
            bl54 = true;
        }
        this.harness.check(bl54, "to long, equals");
        boolean bl55 = false;
        if (this.getType((long)c8 * l3) == 'L') {
            bl55 = true;
        }
        this.harness.check(bl55, "result should be long");
        boolean bl56 = false;
        if (this.getType(l8 * (long)c3) == 'L') {
            bl56 = true;
        }
        this.harness.check(bl56, "result should be long");
        boolean bl57 = false;
        if ((long)i8 * l3 == l8 * l3) {
            bl57 = true;
        }
        this.harness.check(bl57, "to long, equals");
        boolean bl58 = false;
        if (l8 * (long)i3 == l8 * l3) {
            bl58 = true;
        }
        this.harness.check(bl58, "to long, equals");
        boolean bl59 = false;
        if (this.getType((long)i8 * l3) == 'L') {
            bl59 = true;
        }
        this.harness.check(bl59, "result should be long");
        boolean bl60 = false;
        if (this.getType(l8 * (long)i3) == 'L') {
            bl60 = true;
        }
        this.harness.check(bl60, "result should be long");
        boolean bl61 = false;
        if (b8 * i3 == i8 * i3) {
            bl61 = true;
        }
        this.harness.check(bl61, "to int, equals");
        boolean bl62 = false;
        if (i8 * b3 == i8 * i3) {
            bl62 = true;
        }
        this.harness.check(bl62, "to int, equals");
        boolean bl63 = false;
        if (this.getType(b8 * i3) == 'I') {
            bl63 = true;
        }
        this.harness.check(bl63, "result should be int");
        boolean bl64 = false;
        if (this.getType(i8 * b3) == 'I') {
            bl64 = true;
        }
        this.harness.check(bl64, "result should be int");
        boolean bl65 = false;
        if (s8 * i3 == i8 * i3) {
            bl65 = true;
        }
        this.harness.check(bl65, "to int, equals");
        boolean bl66 = false;
        if (i8 * s3 == i8 * i3) {
            bl66 = true;
        }
        this.harness.check(bl66, "to int, equals");
        boolean bl67 = false;
        if (this.getType(s8 * i3) == 'I') {
            bl67 = true;
        }
        this.harness.check(bl67, "result should be int");
        boolean bl68 = false;
        if (this.getType(i8 * s3) == 'I') {
            bl68 = true;
        }
        this.harness.check(bl68, "result should be int");
        boolean bl69 = false;
        if (c8 * i3 == i8 * i3) {
            bl69 = true;
        }
        this.harness.check(bl69, "to int, equals");
        boolean bl70 = false;
        if (i8 * c3 == i8 * i3) {
            bl70 = true;
        }
        this.harness.check(bl70, "to int, equals");
        boolean bl71 = false;
        if (this.getType(c8 * i3) == 'I') {
            bl71 = true;
        }
        this.harness.check(bl71, "result should be int");
        boolean bl72 = false;
        if (this.getType(i8 * c3) == 'I') {
            bl72 = true;
        }
        this.harness.check(bl72, "result should be int");
        boolean bl73 = false;
        if (b8 * c3 == i8 * i3) {
            bl73 = true;
        }
        this.harness.check(bl73, "to int, equals");
        boolean bl74 = false;
        if (c8 * b3 == i8 * i3) {
            bl74 = true;
        }
        this.harness.check(bl74, "to int, equals");
        boolean bl75 = false;
        if (this.getType(b8 * c3) == 'I') {
            bl75 = true;
        }
        this.harness.check(bl75, "result should be int");
        boolean bl76 = false;
        if (this.getType(c8 * b3) == 'I') {
            bl76 = true;
        }
        this.harness.check(bl76, "result should be int");
        boolean bl77 = false;
        if (s8 * c3 == i8 * i3) {
            bl77 = true;
        }
        this.harness.check(bl77, "to int, equals");
        boolean bl78 = false;
        if (c8 * s3 == i8 * i3) {
            bl78 = true;
        }
        this.harness.check(bl78, "to int, equals");
        boolean bl79 = false;
        if (this.getType(b8 * c3) == 'I') {
            bl79 = true;
        }
        this.harness.check(bl79, "result should be int");
        boolean bl80 = false;
        if (this.getType(c8 * b3) == 'I') {
            bl80 = true;
        }
        this.harness.check(bl80, "result should be int");
        boolean bl81 = false;
        if (b8 * s3 == i8 * i3) {
            bl81 = true;
        }
        this.harness.check(bl81, "to int, equals");
        boolean bl82 = false;
        if (s8 * b3 == i8 * i3) {
            bl82 = true;
        }
        this.harness.check(bl82, "to int, equals");
        boolean bl83 = false;
        if (this.getType(b8 * s3) == 'I') {
            bl83 = true;
        }
        this.harness.check(bl83, "result should be int");
        boolean bl84 = false;
        if (this.getType(s8 * b3) == 'I') {
            bl84 = true;
        }
        this.harness.check(bl84, "result should be int");
    }

    private final void testPromotionDivision() {
        int b3 = 3;
        int s3 = 3;
        int c3 = 3;
        int i3 = 3;
        long l3 = 3;
        float f3 = 3;
        double d3 = 3;
        int b8 = 8;
        int s8 = 8;
        int c8 = 8;
        int i8 = 8;
        long l8 = 8L;
        float f8 = 8.0f;
        double d8 = 8.0;
        boolean bl = false;
        if ((double)b8 / d3 == d8 / d3) {
            bl = true;
        }
        this.harness.check(bl, "to double, equals");
        boolean bl2 = false;
        if (d8 / (double)b3 == d8 / d3) {
            bl2 = true;
        }
        this.harness.check(bl2, "to double, equals");
        boolean bl3 = false;
        if (this.getType((double)b8 / d3) == 'D') {
            bl3 = true;
        }
        this.harness.check(bl3, "result should be double");
        boolean bl4 = false;
        if (this.getType(d8 / (double)b3) == 'D') {
            bl4 = true;
        }
        this.harness.check(bl4, "result should be double");
        boolean bl5 = false;
        if ((double)s8 / d3 == d8 / d3) {
            bl5 = true;
        }
        this.harness.check(bl5, "to double, equals");
        boolean bl6 = false;
        if (d8 / (double)s3 == d8 / d3) {
            bl6 = true;
        }
        this.harness.check(bl6, "to double, equals");
        boolean bl7 = false;
        if (this.getType((double)s8 / d3) == 'D') {
            bl7 = true;
        }
        this.harness.check(bl7, "result should be double");
        boolean bl8 = false;
        if (this.getType(d8 / (double)s3) == 'D') {
            bl8 = true;
        }
        this.harness.check(bl8, "result should be double");
        boolean bl9 = false;
        if ((double)c8 / d3 == d8 / d3) {
            bl9 = true;
        }
        this.harness.check(bl9, "to double, equals");
        boolean bl10 = false;
        if (d8 / (double)c3 == d8 / d3) {
            bl10 = true;
        }
        this.harness.check(bl10, "to double, equals");
        boolean bl11 = false;
        if (this.getType((double)c8 / d3) == 'D') {
            bl11 = true;
        }
        this.harness.check(bl11, "result should be double");
        boolean bl12 = false;
        if (this.getType(d8 / (double)c3) == 'D') {
            bl12 = true;
        }
        this.harness.check(bl12, "result should be double");
        boolean bl13 = false;
        if ((double)i8 / d3 == d8 / d3) {
            bl13 = true;
        }
        this.harness.check(bl13, "to double, equals");
        boolean bl14 = false;
        if (d8 / (double)i3 == d8 / d3) {
            bl14 = true;
        }
        this.harness.check(bl14, "to double, equals");
        boolean bl15 = false;
        if (this.getType((double)i8 / d3) == 'D') {
            bl15 = true;
        }
        this.harness.check(bl15, "result should be double");
        boolean bl16 = false;
        if (this.getType(d8 / (double)i3) == 'D') {
            bl16 = true;
        }
        this.harness.check(bl16, "result should be double");
        boolean bl17 = false;
        if ((double)l8 / d3 == d8 / d3) {
            bl17 = true;
        }
        this.harness.check(bl17, "to double, equals");
        boolean bl18 = false;
        if (d8 / (double)l3 == d8 / d3) {
            bl18 = true;
        }
        this.harness.check(bl18, "to double, equals");
        boolean bl19 = false;
        if (this.getType((double)l8 / d3) == 'D') {
            bl19 = true;
        }
        this.harness.check(bl19, "result should be double");
        boolean bl20 = false;
        if (this.getType(d8 / (double)l3) == 'D') {
            bl20 = true;
        }
        this.harness.check(bl20, "result should be double");
        boolean bl21 = false;
        if ((double)f8 / d3 == d8 / d3) {
            bl21 = true;
        }
        this.harness.check(bl21, "to double, equals");
        boolean bl22 = false;
        if (d8 / (double)f3 == d8 / d3) {
            bl22 = true;
        }
        this.harness.check(bl22, "to double, equals");
        boolean bl23 = false;
        if (this.getType((double)f8 / d3) == 'D') {
            bl23 = true;
        }
        this.harness.check(bl23, "result should be double");
        boolean bl24 = false;
        if (this.getType(d8 / (double)f3) == 'D') {
            bl24 = true;
        }
        this.harness.check(bl24, "result should be double");
        boolean bl25 = false;
        if ((float)b8 / f3 == f8 / f3) {
            bl25 = true;
        }
        this.harness.check(bl25, "to float equals");
        boolean bl26 = false;
        if (f8 / (float)b3 == f8 / f3) {
            bl26 = true;
        }
        this.harness.check(bl26, "to float equals");
        boolean bl27 = false;
        if (this.getType((float)b8 / f3) == 'F') {
            bl27 = true;
        }
        this.harness.check(bl27, "result should be float");
        boolean bl28 = false;
        if (this.getType(f8 / (float)b3) == 'F') {
            bl28 = true;
        }
        this.harness.check(bl28, "result should be float");
        boolean bl29 = false;
        if ((float)s8 / f3 == f8 / f3) {
            bl29 = true;
        }
        this.harness.check(bl29, "to float equals");
        boolean bl30 = false;
        if (f8 / (float)s3 == f8 / f3) {
            bl30 = true;
        }
        this.harness.check(bl30, "to float equals");
        boolean bl31 = false;
        if (this.getType((float)s8 / f3) == 'F') {
            bl31 = true;
        }
        this.harness.check(bl31, "result should be float");
        boolean bl32 = false;
        if (this.getType(f8 / (float)s3) == 'F') {
            bl32 = true;
        }
        this.harness.check(bl32, "result should be float");
        boolean bl33 = false;
        if ((float)c8 / f3 == f8 / f3) {
            bl33 = true;
        }
        this.harness.check(bl33, "to float equals");
        boolean bl34 = false;
        if (f8 / (float)c3 == f8 / f3) {
            bl34 = true;
        }
        this.harness.check(bl34, "to float equals");
        boolean bl35 = false;
        if (this.getType((float)c8 / f3) == 'F') {
            bl35 = true;
        }
        this.harness.check(bl35, "result should be float");
        boolean bl36 = false;
        if (this.getType(f8 / (float)c3) == 'F') {
            bl36 = true;
        }
        this.harness.check(bl36, "result should be float");
        boolean bl37 = false;
        if ((float)i8 / f3 == f8 / f3) {
            bl37 = true;
        }
        this.harness.check(bl37, "to float equals");
        boolean bl38 = false;
        if (f8 / (float)i3 == f8 / f3) {
            bl38 = true;
        }
        this.harness.check(bl38, "to float equals");
        boolean bl39 = false;
        if (this.getType((float)i8 / f3) == 'F') {
            bl39 = true;
        }
        this.harness.check(bl39, "result should be float");
        boolean bl40 = false;
        if (this.getType(f8 / (float)i3) == 'F') {
            bl40 = true;
        }
        this.harness.check(bl40, "result should be float");
        boolean bl41 = false;
        if ((float)l8 / f3 == f8 / f3) {
            bl41 = true;
        }
        this.harness.check(bl41, "to float equals");
        boolean bl42 = false;
        if (f8 / (float)l3 == f8 / f3) {
            bl42 = true;
        }
        this.harness.check(bl42, "to float equals");
        boolean bl43 = false;
        if (this.getType((float)l8 / f3) == 'F') {
            bl43 = true;
        }
        this.harness.check(bl43, "result should be float");
        boolean bl44 = false;
        if (this.getType(f8 / (float)l3) == 'F') {
            bl44 = true;
        }
        this.harness.check(bl44, "result should be float");
        boolean bl45 = false;
        if ((long)b8 / l3 == l8 / l3) {
            bl45 = true;
        }
        this.harness.check(bl45, "to long, equals");
        boolean bl46 = false;
        if (l8 / (long)b3 == l8 / l3) {
            bl46 = true;
        }
        this.harness.check(bl46, "to long, equals");
        boolean bl47 = false;
        if (this.getType((long)b8 / l3) == 'L') {
            bl47 = true;
        }
        this.harness.check(bl47, "result should be long");
        boolean bl48 = false;
        if (this.getType(l8 / (long)b3) == 'L') {
            bl48 = true;
        }
        this.harness.check(bl48, "result should be long");
        boolean bl49 = false;
        if ((long)s8 / l3 == l8 / l3) {
            bl49 = true;
        }
        this.harness.check(bl49, "to long, equals");
        boolean bl50 = false;
        if (l8 / (long)s3 == l8 / l3) {
            bl50 = true;
        }
        this.harness.check(bl50, "to long, equals");
        boolean bl51 = false;
        if (this.getType((long)s8 / l3) == 'L') {
            bl51 = true;
        }
        this.harness.check(bl51, "result should be long");
        boolean bl52 = false;
        if (this.getType(l8 / (long)s3) == 'L') {
            bl52 = true;
        }
        this.harness.check(bl52, "result should be long");
        boolean bl53 = false;
        if ((long)c8 / l3 == l8 / l3) {
            bl53 = true;
        }
        this.harness.check(bl53, "to long, equals");
        boolean bl54 = false;
        if (l8 / (long)c3 == l8 / l3) {
            bl54 = true;
        }
        this.harness.check(bl54, "to long, equals");
        boolean bl55 = false;
        if (this.getType((long)c8 / l3) == 'L') {
            bl55 = true;
        }
        this.harness.check(bl55, "result should be long");
        boolean bl56 = false;
        if (this.getType(l8 / (long)c3) == 'L') {
            bl56 = true;
        }
        this.harness.check(bl56, "result should be long");
        boolean bl57 = false;
        if ((long)i8 / l3 == l8 / l3) {
            bl57 = true;
        }
        this.harness.check(bl57, "to long, equals");
        boolean bl58 = false;
        if (l8 / (long)i3 == l8 / l3) {
            bl58 = true;
        }
        this.harness.check(bl58, "to long, equals");
        boolean bl59 = false;
        if (this.getType((long)i8 / l3) == 'L') {
            bl59 = true;
        }
        this.harness.check(bl59, "result should be long");
        boolean bl60 = false;
        if (this.getType(l8 / (long)i3) == 'L') {
            bl60 = true;
        }
        this.harness.check(bl60, "result should be long");
        boolean bl61 = false;
        if (b8 / i3 == i8 / i3) {
            bl61 = true;
        }
        this.harness.check(bl61, "to int, equals");
        boolean bl62 = false;
        if (i8 / b3 == i8 / i3) {
            bl62 = true;
        }
        this.harness.check(bl62, "to int, equals");
        boolean bl63 = false;
        if (this.getType(b8 / i3) == 'I') {
            bl63 = true;
        }
        this.harness.check(bl63, "result should be int");
        boolean bl64 = false;
        if (this.getType(i8 / b3) == 'I') {
            bl64 = true;
        }
        this.harness.check(bl64, "result should be int");
        boolean bl65 = false;
        if (s8 / i3 == i8 / i3) {
            bl65 = true;
        }
        this.harness.check(bl65, "to int, equals");
        boolean bl66 = false;
        if (i8 / s3 == i8 / i3) {
            bl66 = true;
        }
        this.harness.check(bl66, "to int, equals");
        boolean bl67 = false;
        if (this.getType(s8 / i3) == 'I') {
            bl67 = true;
        }
        this.harness.check(bl67, "result should be int");
        boolean bl68 = false;
        if (this.getType(i8 / s3) == 'I') {
            bl68 = true;
        }
        this.harness.check(bl68, "result should be int");
        boolean bl69 = false;
        if (c8 / i3 == i8 / i3) {
            bl69 = true;
        }
        this.harness.check(bl69, "to int, equals");
        boolean bl70 = false;
        if (i8 / c3 == i8 / i3) {
            bl70 = true;
        }
        this.harness.check(bl70, "to int, equals");
        boolean bl71 = false;
        if (this.getType(c8 / i3) == 'I') {
            bl71 = true;
        }
        this.harness.check(bl71, "result should be int");
        boolean bl72 = false;
        if (this.getType(i8 / c3) == 'I') {
            bl72 = true;
        }
        this.harness.check(bl72, "result should be int");
        boolean bl73 = false;
        if (b8 / c3 == i8 / i3) {
            bl73 = true;
        }
        this.harness.check(bl73, "to int, equals");
        boolean bl74 = false;
        if (c8 / b3 == i8 / i3) {
            bl74 = true;
        }
        this.harness.check(bl74, "to int, equals");
        boolean bl75 = false;
        if (this.getType(b8 / c3) == 'I') {
            bl75 = true;
        }
        this.harness.check(bl75, "result should be int");
        boolean bl76 = false;
        if (this.getType(c8 / b3) == 'I') {
            bl76 = true;
        }
        this.harness.check(bl76, "result should be int");
        boolean bl77 = false;
        if (s8 / c3 == i8 / i3) {
            bl77 = true;
        }
        this.harness.check(bl77, "to int, equals");
        boolean bl78 = false;
        if (c8 / s3 == i8 / i3) {
            bl78 = true;
        }
        this.harness.check(bl78, "to int, equals");
        boolean bl79 = false;
        if (this.getType(b8 / c3) == 'I') {
            bl79 = true;
        }
        this.harness.check(bl79, "result should be int");
        boolean bl80 = false;
        if (this.getType(c8 / b3) == 'I') {
            bl80 = true;
        }
        this.harness.check(bl80, "result should be int");
        boolean bl81 = false;
        if (b8 / s3 == i8 / i3) {
            bl81 = true;
        }
        this.harness.check(bl81, "to int, equals");
        boolean bl82 = false;
        if (s8 / b3 == i8 / i3) {
            bl82 = true;
        }
        this.harness.check(bl82, "to int, equals");
        boolean bl83 = false;
        if (this.getType(b8 / s3) == 'I') {
            bl83 = true;
        }
        this.harness.check(bl83, "result should be int");
        boolean bl84 = false;
        if (this.getType(s8 / b3) == 'I') {
            bl84 = true;
        }
        this.harness.check(bl84, "result should be int");
    }

    private final void testPromotionRemainder() {
        int b3 = 3;
        int s3 = 3;
        int c3 = 3;
        int i3 = 3;
        long l3 = 3;
        float f3 = 3;
        double d3 = 3;
        int b8 = 8;
        int s8 = 8;
        int c8 = 8;
        int i8 = 8;
        long l8 = 8L;
        float f8 = 8.0f;
        double d8 = 8.0;
        boolean bl = false;
        if ((double)b8 % d3 == d8 % d3) {
            bl = true;
        }
        this.harness.check(bl, "to double, equals");
        boolean bl2 = false;
        if (d8 % (double)b3 == d8 % d3) {
            bl2 = true;
        }
        this.harness.check(bl2, "to double, equals");
        boolean bl3 = false;
        if (this.getType((double)b8 % d3) == 'D') {
            bl3 = true;
        }
        this.harness.check(bl3, "result should be double");
        boolean bl4 = false;
        if (this.getType(d8 % (double)b3) == 'D') {
            bl4 = true;
        }
        this.harness.check(bl4, "result should be double");
        boolean bl5 = false;
        if ((double)s8 % d3 == d8 % d3) {
            bl5 = true;
        }
        this.harness.check(bl5, "to double, equals");
        boolean bl6 = false;
        if (d8 % (double)s3 == d8 % d3) {
            bl6 = true;
        }
        this.harness.check(bl6, "to double, equals");
        boolean bl7 = false;
        if (this.getType((double)s8 % d3) == 'D') {
            bl7 = true;
        }
        this.harness.check(bl7, "result should be double");
        boolean bl8 = false;
        if (this.getType(d8 % (double)s3) == 'D') {
            bl8 = true;
        }
        this.harness.check(bl8, "result should be double");
        boolean bl9 = false;
        if ((double)c8 % d3 == d8 % d3) {
            bl9 = true;
        }
        this.harness.check(bl9, "to double, equals");
        boolean bl10 = false;
        if (d8 % (double)c3 == d8 % d3) {
            bl10 = true;
        }
        this.harness.check(bl10, "to double, equals");
        boolean bl11 = false;
        if (this.getType((double)c8 % d3) == 'D') {
            bl11 = true;
        }
        this.harness.check(bl11, "result should be double");
        boolean bl12 = false;
        if (this.getType(d8 % (double)c3) == 'D') {
            bl12 = true;
        }
        this.harness.check(bl12, "result should be double");
        boolean bl13 = false;
        if ((double)i8 % d3 == d8 % d3) {
            bl13 = true;
        }
        this.harness.check(bl13, "to double, equals");
        boolean bl14 = false;
        if (d8 % (double)i3 == d8 % d3) {
            bl14 = true;
        }
        this.harness.check(bl14, "to double, equals");
        boolean bl15 = false;
        if (this.getType((double)i8 % d3) == 'D') {
            bl15 = true;
        }
        this.harness.check(bl15, "result should be double");
        boolean bl16 = false;
        if (this.getType(d8 % (double)i3) == 'D') {
            bl16 = true;
        }
        this.harness.check(bl16, "result should be double");
        boolean bl17 = false;
        if ((double)l8 % d3 == d8 % d3) {
            bl17 = true;
        }
        this.harness.check(bl17, "to double, equals");
        boolean bl18 = false;
        if (d8 % (double)l3 == d8 % d3) {
            bl18 = true;
        }
        this.harness.check(bl18, "to double, equals");
        boolean bl19 = false;
        if (this.getType((double)l8 % d3) == 'D') {
            bl19 = true;
        }
        this.harness.check(bl19, "result should be double");
        boolean bl20 = false;
        if (this.getType(d8 % (double)l3) == 'D') {
            bl20 = true;
        }
        this.harness.check(bl20, "result should be double");
        boolean bl21 = false;
        if ((double)f8 % d3 == d8 % d3) {
            bl21 = true;
        }
        this.harness.check(bl21, "to double, equals");
        boolean bl22 = false;
        if (d8 % (double)f3 == d8 % d3) {
            bl22 = true;
        }
        this.harness.check(bl22, "to double, equals");
        boolean bl23 = false;
        if (this.getType((double)f8 % d3) == 'D') {
            bl23 = true;
        }
        this.harness.check(bl23, "result should be double");
        boolean bl24 = false;
        if (this.getType(d8 % (double)f3) == 'D') {
            bl24 = true;
        }
        this.harness.check(bl24, "result should be double");
        boolean bl25 = false;
        if ((float)b8 % f3 == f8 % f3) {
            bl25 = true;
        }
        this.harness.check(bl25, "to float equals");
        boolean bl26 = false;
        if (f8 % (float)b3 == f8 % f3) {
            bl26 = true;
        }
        this.harness.check(bl26, "to float equals");
        boolean bl27 = false;
        if (this.getType((float)b8 % f3) == 'F') {
            bl27 = true;
        }
        this.harness.check(bl27, "result should be float");
        boolean bl28 = false;
        if (this.getType(f8 % (float)b3) == 'F') {
            bl28 = true;
        }
        this.harness.check(bl28, "result should be float");
        boolean bl29 = false;
        if ((float)s8 % f3 == f8 % f3) {
            bl29 = true;
        }
        this.harness.check(bl29, "to float equals");
        boolean bl30 = false;
        if (f8 % (float)s3 == f8 % f3) {
            bl30 = true;
        }
        this.harness.check(bl30, "to float equals");
        boolean bl31 = false;
        if (this.getType((float)s8 % f3) == 'F') {
            bl31 = true;
        }
        this.harness.check(bl31, "result should be float");
        boolean bl32 = false;
        if (this.getType(f8 % (float)s3) == 'F') {
            bl32 = true;
        }
        this.harness.check(bl32, "result should be float");
        boolean bl33 = false;
        if ((float)c8 % f3 == f8 % f3) {
            bl33 = true;
        }
        this.harness.check(bl33, "to float equals");
        boolean bl34 = false;
        if (f8 % (float)c3 == f8 % f3) {
            bl34 = true;
        }
        this.harness.check(bl34, "to float equals");
        boolean bl35 = false;
        if (this.getType((float)c8 % f3) == 'F') {
            bl35 = true;
        }
        this.harness.check(bl35, "result should be float");
        boolean bl36 = false;
        if (this.getType(f8 % (float)c3) == 'F') {
            bl36 = true;
        }
        this.harness.check(bl36, "result should be float");
        boolean bl37 = false;
        if ((float)i8 % f3 == f8 % f3) {
            bl37 = true;
        }
        this.harness.check(bl37, "to float equals");
        boolean bl38 = false;
        if (f8 % (float)i3 == f8 % f3) {
            bl38 = true;
        }
        this.harness.check(bl38, "to float equals");
        boolean bl39 = false;
        if (this.getType((float)i8 % f3) == 'F') {
            bl39 = true;
        }
        this.harness.check(bl39, "result should be float");
        boolean bl40 = false;
        if (this.getType(f8 % (float)i3) == 'F') {
            bl40 = true;
        }
        this.harness.check(bl40, "result should be float");
        boolean bl41 = false;
        if ((float)l8 % f3 == f8 % f3) {
            bl41 = true;
        }
        this.harness.check(bl41, "to float equals");
        boolean bl42 = false;
        if (f8 % (float)l3 == f8 % f3) {
            bl42 = true;
        }
        this.harness.check(bl42, "to float equals");
        boolean bl43 = false;
        if (this.getType((float)l8 % f3) == 'F') {
            bl43 = true;
        }
        this.harness.check(bl43, "result should be float");
        boolean bl44 = false;
        if (this.getType(f8 % (float)l3) == 'F') {
            bl44 = true;
        }
        this.harness.check(bl44, "result should be float");
        boolean bl45 = false;
        if ((long)b8 % l3 == l8 % l3) {
            bl45 = true;
        }
        this.harness.check(bl45, "to long, equals");
        boolean bl46 = false;
        if (l8 % (long)b3 == l8 % l3) {
            bl46 = true;
        }
        this.harness.check(bl46, "to long, equals");
        boolean bl47 = false;
        if (this.getType((long)b8 % l3) == 'L') {
            bl47 = true;
        }
        this.harness.check(bl47, "result should be long");
        boolean bl48 = false;
        if (this.getType(l8 % (long)b3) == 'L') {
            bl48 = true;
        }
        this.harness.check(bl48, "result should be long");
        boolean bl49 = false;
        if ((long)s8 % l3 == l8 % l3) {
            bl49 = true;
        }
        this.harness.check(bl49, "to long, equals");
        boolean bl50 = false;
        if (l8 % (long)s3 == l8 % l3) {
            bl50 = true;
        }
        this.harness.check(bl50, "to long, equals");
        boolean bl51 = false;
        if (this.getType((long)s8 % l3) == 'L') {
            bl51 = true;
        }
        this.harness.check(bl51, "result should be long");
        boolean bl52 = false;
        if (this.getType(l8 % (long)s3) == 'L') {
            bl52 = true;
        }
        this.harness.check(bl52, "result should be long");
        boolean bl53 = false;
        if ((long)c8 % l3 == l8 % l3) {
            bl53 = true;
        }
        this.harness.check(bl53, "to long, equals");
        boolean bl54 = false;
        if (l8 % (long)c3 == l8 % l3) {
            bl54 = true;
        }
        this.harness.check(bl54, "to long, equals");
        boolean bl55 = false;
        if (this.getType((long)c8 % l3) == 'L') {
            bl55 = true;
        }
        this.harness.check(bl55, "result should be long");
        boolean bl56 = false;
        if (this.getType(l8 % (long)c3) == 'L') {
            bl56 = true;
        }
        this.harness.check(bl56, "result should be long");
        boolean bl57 = false;
        if ((long)i8 % l3 == l8 % l3) {
            bl57 = true;
        }
        this.harness.check(bl57, "to long, equals");
        boolean bl58 = false;
        if (l8 % (long)i3 == l8 % l3) {
            bl58 = true;
        }
        this.harness.check(bl58, "to long, equals");
        boolean bl59 = false;
        if (this.getType((long)i8 % l3) == 'L') {
            bl59 = true;
        }
        this.harness.check(bl59, "result should be long");
        boolean bl60 = false;
        if (this.getType(l8 % (long)i3) == 'L') {
            bl60 = true;
        }
        this.harness.check(bl60, "result should be long");
        boolean bl61 = false;
        if (b8 % i3 == i8 % i3) {
            bl61 = true;
        }
        this.harness.check(bl61, "to int, equals");
        boolean bl62 = false;
        if (i8 % b3 == i8 % i3) {
            bl62 = true;
        }
        this.harness.check(bl62, "to int, equals");
        boolean bl63 = false;
        if (this.getType(b8 % i3) == 'I') {
            bl63 = true;
        }
        this.harness.check(bl63, "result should be int");
        boolean bl64 = false;
        if (this.getType(i8 % b3) == 'I') {
            bl64 = true;
        }
        this.harness.check(bl64, "result should be int");
        boolean bl65 = false;
        if (s8 % i3 == i8 % i3) {
            bl65 = true;
        }
        this.harness.check(bl65, "to int, equals");
        boolean bl66 = false;
        if (i8 % s3 == i8 % i3) {
            bl66 = true;
        }
        this.harness.check(bl66, "to int, equals");
        boolean bl67 = false;
        if (this.getType(s8 % i3) == 'I') {
            bl67 = true;
        }
        this.harness.check(bl67, "result should be int");
        boolean bl68 = false;
        if (this.getType(i8 % s3) == 'I') {
            bl68 = true;
        }
        this.harness.check(bl68, "result should be int");
        boolean bl69 = false;
        if (c8 % i3 == i8 % i3) {
            bl69 = true;
        }
        this.harness.check(bl69, "to int, equals");
        boolean bl70 = false;
        if (i8 % c3 == i8 % i3) {
            bl70 = true;
        }
        this.harness.check(bl70, "to int, equals");
        boolean bl71 = false;
        if (this.getType(c8 % i3) == 'I') {
            bl71 = true;
        }
        this.harness.check(bl71, "result should be int");
        boolean bl72 = false;
        if (this.getType(i8 % c3) == 'I') {
            bl72 = true;
        }
        this.harness.check(bl72, "result should be int");
        boolean bl73 = false;
        if (b8 % c3 == i8 % i3) {
            bl73 = true;
        }
        this.harness.check(bl73, "to int, equals");
        boolean bl74 = false;
        if (c8 % b3 == i8 % i3) {
            bl74 = true;
        }
        this.harness.check(bl74, "to int, equals");
        boolean bl75 = false;
        if (this.getType(b8 % c3) == 'I') {
            bl75 = true;
        }
        this.harness.check(bl75, "result should be int");
        boolean bl76 = false;
        if (this.getType(c8 % b3) == 'I') {
            bl76 = true;
        }
        this.harness.check(bl76, "result should be int");
        boolean bl77 = false;
        if (s8 % c3 == i8 % i3) {
            bl77 = true;
        }
        this.harness.check(bl77, "to int, equals");
        boolean bl78 = false;
        if (c8 % s3 == i8 % i3) {
            bl78 = true;
        }
        this.harness.check(bl78, "to int, equals");
        boolean bl79 = false;
        if (this.getType(b8 % c3) == 'I') {
            bl79 = true;
        }
        this.harness.check(bl79, "result should be int");
        boolean bl80 = false;
        if (this.getType(c8 % b3) == 'I') {
            bl80 = true;
        }
        this.harness.check(bl80, "result should be int");
        boolean bl81 = false;
        if (b8 % s3 == i8 % i3) {
            bl81 = true;
        }
        this.harness.check(bl81, "to int, equals");
        boolean bl82 = false;
        if (s8 % b3 == i8 % i3) {
            bl82 = true;
        }
        this.harness.check(bl82, "to int, equals");
        boolean bl83 = false;
        if (this.getType(b8 % s3) == 'I') {
            bl83 = true;
        }
        this.harness.check(bl83, "result should be int");
        boolean bl84 = false;
        if (this.getType(s8 % b3) == 'I') {
            bl84 = true;
        }
        this.harness.check(bl84, "result should be int");
    }

    private final void testPromotionBitwiseAnd() {
        int b3 = 3;
        int s3 = 3;
        int c3 = 3;
        int i3 = 3;
        long l3 = 3;
        int b8 = 8;
        int s8 = 8;
        int c8 = 8;
        int i8 = 8;
        long l8 = 8L;
        boolean bl = false;
        if (((long)b8 & l3) == (l8 & l3)) {
            bl = true;
        }
        this.harness.check(bl, "to long, equals");
        boolean bl2 = false;
        if ((l8 & (long)b3) == (l8 & l3)) {
            bl2 = true;
        }
        this.harness.check(bl2, "to long, equals");
        boolean bl3 = false;
        if (this.getType((long)b8 & l3) == 'L') {
            bl3 = true;
        }
        this.harness.check(bl3, "result should be long");
        boolean bl4 = false;
        if (this.getType(l8 & (long)b3) == 'L') {
            bl4 = true;
        }
        this.harness.check(bl4, "result should be long");
        boolean bl5 = false;
        if (((long)s8 & l3) == (l8 & l3)) {
            bl5 = true;
        }
        this.harness.check(bl5, "to long, equals");
        boolean bl6 = false;
        if ((l8 & (long)s3) == (l8 & l3)) {
            bl6 = true;
        }
        this.harness.check(bl6, "to long, equals");
        boolean bl7 = false;
        if (this.getType((long)s8 & l3) == 'L') {
            bl7 = true;
        }
        this.harness.check(bl7, "result should be long");
        boolean bl8 = false;
        if (this.getType(l8 & (long)s3) == 'L') {
            bl8 = true;
        }
        this.harness.check(bl8, "result should be long");
        boolean bl9 = false;
        if (((long)c8 & l3) == (l8 & l3)) {
            bl9 = true;
        }
        this.harness.check(bl9, "to long, equals");
        boolean bl10 = false;
        if ((l8 & (long)c3) == (l8 & l3)) {
            bl10 = true;
        }
        this.harness.check(bl10, "to long, equals");
        boolean bl11 = false;
        if (this.getType((long)c8 & l3) == 'L') {
            bl11 = true;
        }
        this.harness.check(bl11, "result should be long");
        boolean bl12 = false;
        if (this.getType(l8 & (long)c3) == 'L') {
            bl12 = true;
        }
        this.harness.check(bl12, "result should be long");
        boolean bl13 = false;
        if (((long)i8 & l3) == (l8 & l3)) {
            bl13 = true;
        }
        this.harness.check(bl13, "to long, equals");
        boolean bl14 = false;
        if ((l8 & (long)i3) == (l8 & l3)) {
            bl14 = true;
        }
        this.harness.check(bl14, "to long, equals");
        boolean bl15 = false;
        if (this.getType((long)i8 & l3) == 'L') {
            bl15 = true;
        }
        this.harness.check(bl15, "result should be long");
        boolean bl16 = false;
        if (this.getType(l8 & (long)i3) == 'L') {
            bl16 = true;
        }
        this.harness.check(bl16, "result should be long");
        boolean bl17 = false;
        if ((b8 & i3) == (i8 & i3)) {
            bl17 = true;
        }
        this.harness.check(bl17, "to int, equals");
        boolean bl18 = false;
        if ((i8 & b3) == (i8 & i3)) {
            bl18 = true;
        }
        this.harness.check(bl18, "to int, equals");
        boolean bl19 = false;
        if (this.getType(b8 & i3) == 'I') {
            bl19 = true;
        }
        this.harness.check(bl19, "result should be int");
        boolean bl20 = false;
        if (this.getType(i8 & b3) == 'I') {
            bl20 = true;
        }
        this.harness.check(bl20, "result should be int");
        boolean bl21 = false;
        if ((s8 & i3) == (i8 & i3)) {
            bl21 = true;
        }
        this.harness.check(bl21, "to int, equals");
        boolean bl22 = false;
        if ((i8 & s3) == (i8 & i3)) {
            bl22 = true;
        }
        this.harness.check(bl22, "to int, equals");
        boolean bl23 = false;
        if (this.getType(s8 & i3) == 'I') {
            bl23 = true;
        }
        this.harness.check(bl23, "result should be int");
        boolean bl24 = false;
        if (this.getType(i8 & s3) == 'I') {
            bl24 = true;
        }
        this.harness.check(bl24, "result should be int");
        boolean bl25 = false;
        if ((c8 & i3) == (i8 & i3)) {
            bl25 = true;
        }
        this.harness.check(bl25, "to int, equals");
        boolean bl26 = false;
        if ((i8 & c3) == (i8 & i3)) {
            bl26 = true;
        }
        this.harness.check(bl26, "to int, equals");
        boolean bl27 = false;
        if (this.getType(c8 & i3) == 'I') {
            bl27 = true;
        }
        this.harness.check(bl27, "result should be int");
        boolean bl28 = false;
        if (this.getType(i8 & c3) == 'I') {
            bl28 = true;
        }
        this.harness.check(bl28, "result should be int");
        boolean bl29 = false;
        if ((b8 & c3) == (i8 & i3)) {
            bl29 = true;
        }
        this.harness.check(bl29, "to int, equals");
        boolean bl30 = false;
        if ((c8 & b3) == (i8 & i3)) {
            bl30 = true;
        }
        this.harness.check(bl30, "to int, equals");
        boolean bl31 = false;
        if (this.getType(b8 & c3) == 'I') {
            bl31 = true;
        }
        this.harness.check(bl31, "result should be int");
        boolean bl32 = false;
        if (this.getType(c8 & b3) == 'I') {
            bl32 = true;
        }
        this.harness.check(bl32, "result should be int");
        boolean bl33 = false;
        if ((s8 & c3) == (i8 & i3)) {
            bl33 = true;
        }
        this.harness.check(bl33, "to int, equals");
        boolean bl34 = false;
        if ((c8 & s3) == (i8 & i3)) {
            bl34 = true;
        }
        this.harness.check(bl34, "to int, equals");
        boolean bl35 = false;
        if (this.getType(b8 & c3) == 'I') {
            bl35 = true;
        }
        this.harness.check(bl35, "result should be int");
        boolean bl36 = false;
        if (this.getType(c8 & b3) == 'I') {
            bl36 = true;
        }
        this.harness.check(bl36, "result should be int");
        boolean bl37 = false;
        if ((b8 & s3) == (i8 & i3)) {
            bl37 = true;
        }
        this.harness.check(bl37, "to int, equals");
        boolean bl38 = false;
        if ((s8 & b3) == (i8 & i3)) {
            bl38 = true;
        }
        this.harness.check(bl38, "to int, equals");
        boolean bl39 = false;
        if (this.getType(b8 & s3) == 'I') {
            bl39 = true;
        }
        this.harness.check(bl39, "result should be int");
        boolean bl40 = false;
        if (this.getType(s8 & b3) == 'I') {
            bl40 = true;
        }
        this.harness.check(bl40, "result should be int");
    }

    private final void testPromotionBitwiseOr() {
        int b3 = 3;
        int s3 = 3;
        int c3 = 3;
        int i3 = 3;
        long l3 = 3;
        int b8 = 8;
        int s8 = 8;
        int c8 = 8;
        int i8 = 8;
        long l8 = 8L;
        boolean bl = false;
        if (((long)b8 | l3) == (l8 | l3)) {
            bl = true;
        }
        this.harness.check(bl, "to long, equals");
        boolean bl2 = false;
        if ((l8 | (long)b3) == (l8 | l3)) {
            bl2 = true;
        }
        this.harness.check(bl2, "to long, equals");
        boolean bl3 = false;
        if (this.getType((long)b8 | l3) == 'L') {
            bl3 = true;
        }
        this.harness.check(bl3, "result should be long");
        boolean bl4 = false;
        if (this.getType(l8 | (long)b3) == 'L') {
            bl4 = true;
        }
        this.harness.check(bl4, "result should be long");
        boolean bl5 = false;
        if (((long)s8 | l3) == (l8 | l3)) {
            bl5 = true;
        }
        this.harness.check(bl5, "to long, equals");
        boolean bl6 = false;
        if ((l8 | (long)s3) == (l8 | l3)) {
            bl6 = true;
        }
        this.harness.check(bl6, "to long, equals");
        boolean bl7 = false;
        if (this.getType((long)s8 | l3) == 'L') {
            bl7 = true;
        }
        this.harness.check(bl7, "result should be long");
        boolean bl8 = false;
        if (this.getType(l8 | (long)s3) == 'L') {
            bl8 = true;
        }
        this.harness.check(bl8, "result should be long");
        boolean bl9 = false;
        if (((long)c8 | l3) == (l8 | l3)) {
            bl9 = true;
        }
        this.harness.check(bl9, "to long, equals");
        boolean bl10 = false;
        if ((l8 | (long)c3) == (l8 | l3)) {
            bl10 = true;
        }
        this.harness.check(bl10, "to long, equals");
        boolean bl11 = false;
        if (this.getType((long)c8 | l3) == 'L') {
            bl11 = true;
        }
        this.harness.check(bl11, "result should be long");
        boolean bl12 = false;
        if (this.getType(l8 | (long)c3) == 'L') {
            bl12 = true;
        }
        this.harness.check(bl12, "result should be long");
        boolean bl13 = false;
        if (((long)i8 | l3) == (l8 | l3)) {
            bl13 = true;
        }
        this.harness.check(bl13, "to long, equals");
        boolean bl14 = false;
        if ((l8 | (long)i3) == (l8 | l3)) {
            bl14 = true;
        }
        this.harness.check(bl14, "to long, equals");
        boolean bl15 = false;
        if (this.getType((long)i8 | l3) == 'L') {
            bl15 = true;
        }
        this.harness.check(bl15, "result should be long");
        boolean bl16 = false;
        if (this.getType(l8 | (long)i3) == 'L') {
            bl16 = true;
        }
        this.harness.check(bl16, "result should be long");
        boolean bl17 = false;
        if ((b8 | i3) == (i8 | i3)) {
            bl17 = true;
        }
        this.harness.check(bl17, "to int, equals");
        boolean bl18 = false;
        if ((i8 | b3) == (i8 | i3)) {
            bl18 = true;
        }
        this.harness.check(bl18, "to int, equals");
        boolean bl19 = false;
        if (this.getType(b8 | i3) == 'I') {
            bl19 = true;
        }
        this.harness.check(bl19, "result should be int");
        boolean bl20 = false;
        if (this.getType(i8 | b3) == 'I') {
            bl20 = true;
        }
        this.harness.check(bl20, "result should be int");
        boolean bl21 = false;
        if ((s8 | i3) == (i8 | i3)) {
            bl21 = true;
        }
        this.harness.check(bl21, "to int, equals");
        boolean bl22 = false;
        if ((i8 | s3) == (i8 | i3)) {
            bl22 = true;
        }
        this.harness.check(bl22, "to int, equals");
        boolean bl23 = false;
        if (this.getType(s8 | i3) == 'I') {
            bl23 = true;
        }
        this.harness.check(bl23, "result should be int");
        boolean bl24 = false;
        if (this.getType(i8 | s3) == 'I') {
            bl24 = true;
        }
        this.harness.check(bl24, "result should be int");
        boolean bl25 = false;
        if ((c8 | i3) == (i8 | i3)) {
            bl25 = true;
        }
        this.harness.check(bl25, "to int, equals");
        boolean bl26 = false;
        if ((i8 | c3) == (i8 | i3)) {
            bl26 = true;
        }
        this.harness.check(bl26, "to int, equals");
        boolean bl27 = false;
        if (this.getType(c8 | i3) == 'I') {
            bl27 = true;
        }
        this.harness.check(bl27, "result should be int");
        boolean bl28 = false;
        if (this.getType(i8 | c3) == 'I') {
            bl28 = true;
        }
        this.harness.check(bl28, "result should be int");
        boolean bl29 = false;
        if ((b8 | c3) == (i8 | i3)) {
            bl29 = true;
        }
        this.harness.check(bl29, "to int, equals");
        boolean bl30 = false;
        if ((c8 | b3) == (i8 | i3)) {
            bl30 = true;
        }
        this.harness.check(bl30, "to int, equals");
        boolean bl31 = false;
        if (this.getType(b8 | c3) == 'I') {
            bl31 = true;
        }
        this.harness.check(bl31, "result should be int");
        boolean bl32 = false;
        if (this.getType(c8 | b3) == 'I') {
            bl32 = true;
        }
        this.harness.check(bl32, "result should be int");
        boolean bl33 = false;
        if ((s8 | c3) == (i8 | i3)) {
            bl33 = true;
        }
        this.harness.check(bl33, "to int, equals");
        boolean bl34 = false;
        if ((c8 | s3) == (i8 | i3)) {
            bl34 = true;
        }
        this.harness.check(bl34, "to int, equals");
        boolean bl35 = false;
        if (this.getType(b8 | c3) == 'I') {
            bl35 = true;
        }
        this.harness.check(bl35, "result should be int");
        boolean bl36 = false;
        if (this.getType(c8 | b3) == 'I') {
            bl36 = true;
        }
        this.harness.check(bl36, "result should be int");
        boolean bl37 = false;
        if ((b8 | s3) == (i8 | i3)) {
            bl37 = true;
        }
        this.harness.check(bl37, "to int, equals");
        boolean bl38 = false;
        if ((s8 | b3) == (i8 | i3)) {
            bl38 = true;
        }
        this.harness.check(bl38, "to int, equals");
        boolean bl39 = false;
        if (this.getType(b8 | s3) == 'I') {
            bl39 = true;
        }
        this.harness.check(bl39, "result should be int");
        boolean bl40 = false;
        if (this.getType(s8 | b3) == 'I') {
            bl40 = true;
        }
        this.harness.check(bl40, "result should be int");
    }

    private final void testPromotionBitwiseXor() {
        int b3 = 3;
        int s3 = 3;
        int c3 = 3;
        int i3 = 3;
        long l3 = 3;
        int b8 = 8;
        int s8 = 8;
        int c8 = 8;
        int i8 = 8;
        long l8 = 8L;
        boolean bl = false;
        if (((long)b8 ^ l3) == (l8 ^ l3)) {
            bl = true;
        }
        this.harness.check(bl, "to long, equals");
        boolean bl2 = false;
        if ((l8 ^ (long)b3) == (l8 ^ l3)) {
            bl2 = true;
        }
        this.harness.check(bl2, "to long, equals");
        boolean bl3 = false;
        if (this.getType((long)b8 ^ l3) == 'L') {
            bl3 = true;
        }
        this.harness.check(bl3, "result should be long");
        boolean bl4 = false;
        if (this.getType(l8 ^ (long)b3) == 'L') {
            bl4 = true;
        }
        this.harness.check(bl4, "result should be long");
        boolean bl5 = false;
        if (((long)s8 ^ l3) == (l8 ^ l3)) {
            bl5 = true;
        }
        this.harness.check(bl5, "to long, equals");
        boolean bl6 = false;
        if ((l8 ^ (long)s3) == (l8 ^ l3)) {
            bl6 = true;
        }
        this.harness.check(bl6, "to long, equals");
        boolean bl7 = false;
        if (this.getType((long)s8 ^ l3) == 'L') {
            bl7 = true;
        }
        this.harness.check(bl7, "result should be long");
        boolean bl8 = false;
        if (this.getType(l8 ^ (long)s3) == 'L') {
            bl8 = true;
        }
        this.harness.check(bl8, "result should be long");
        boolean bl9 = false;
        if (((long)c8 ^ l3) == (l8 ^ l3)) {
            bl9 = true;
        }
        this.harness.check(bl9, "to long, equals");
        boolean bl10 = false;
        if ((l8 ^ (long)c3) == (l8 ^ l3)) {
            bl10 = true;
        }
        this.harness.check(bl10, "to long, equals");
        boolean bl11 = false;
        if (this.getType((long)c8 ^ l3) == 'L') {
            bl11 = true;
        }
        this.harness.check(bl11, "result should be long");
        boolean bl12 = false;
        if (this.getType(l8 ^ (long)c3) == 'L') {
            bl12 = true;
        }
        this.harness.check(bl12, "result should be long");
        boolean bl13 = false;
        if (((long)i8 ^ l3) == (l8 ^ l3)) {
            bl13 = true;
        }
        this.harness.check(bl13, "to long, equals");
        boolean bl14 = false;
        if ((l8 ^ (long)i3) == (l8 ^ l3)) {
            bl14 = true;
        }
        this.harness.check(bl14, "to long, equals");
        boolean bl15 = false;
        if (this.getType((long)i8 ^ l3) == 'L') {
            bl15 = true;
        }
        this.harness.check(bl15, "result should be long");
        boolean bl16 = false;
        if (this.getType(l8 ^ (long)i3) == 'L') {
            bl16 = true;
        }
        this.harness.check(bl16, "result should be long");
        boolean bl17 = false;
        if ((b8 ^ i3) == (i8 ^ i3)) {
            bl17 = true;
        }
        this.harness.check(bl17, "to int, equals");
        boolean bl18 = false;
        if ((i8 ^ b3) == (i8 ^ i3)) {
            bl18 = true;
        }
        this.harness.check(bl18, "to int, equals");
        boolean bl19 = false;
        if (this.getType(b8 ^ i3) == 'I') {
            bl19 = true;
        }
        this.harness.check(bl19, "result should be int");
        boolean bl20 = false;
        if (this.getType(i8 ^ b3) == 'I') {
            bl20 = true;
        }
        this.harness.check(bl20, "result should be int");
        boolean bl21 = false;
        if ((s8 ^ i3) == (i8 ^ i3)) {
            bl21 = true;
        }
        this.harness.check(bl21, "to int, equals");
        boolean bl22 = false;
        if ((i8 ^ s3) == (i8 ^ i3)) {
            bl22 = true;
        }
        this.harness.check(bl22, "to int, equals");
        boolean bl23 = false;
        if (this.getType(s8 ^ i3) == 'I') {
            bl23 = true;
        }
        this.harness.check(bl23, "result should be int");
        boolean bl24 = false;
        if (this.getType(i8 ^ s3) == 'I') {
            bl24 = true;
        }
        this.harness.check(bl24, "result should be int");
        boolean bl25 = false;
        if ((c8 ^ i3) == (i8 ^ i3)) {
            bl25 = true;
        }
        this.harness.check(bl25, "to int, equals");
        boolean bl26 = false;
        if ((i8 ^ c3) == (i8 ^ i3)) {
            bl26 = true;
        }
        this.harness.check(bl26, "to int, equals");
        boolean bl27 = false;
        if (this.getType(c8 ^ i3) == 'I') {
            bl27 = true;
        }
        this.harness.check(bl27, "result should be int");
        boolean bl28 = false;
        if (this.getType(i8 ^ c3) == 'I') {
            bl28 = true;
        }
        this.harness.check(bl28, "result should be int");
        boolean bl29 = false;
        if ((b8 ^ c3) == (i8 ^ i3)) {
            bl29 = true;
        }
        this.harness.check(bl29, "to int, equals");
        boolean bl30 = false;
        if ((c8 ^ b3) == (i8 ^ i3)) {
            bl30 = true;
        }
        this.harness.check(bl30, "to int, equals");
        boolean bl31 = false;
        if (this.getType(b8 ^ c3) == 'I') {
            bl31 = true;
        }
        this.harness.check(bl31, "result should be int");
        boolean bl32 = false;
        if (this.getType(c8 ^ b3) == 'I') {
            bl32 = true;
        }
        this.harness.check(bl32, "result should be int");
        boolean bl33 = false;
        if ((s8 ^ c3) == (i8 ^ i3)) {
            bl33 = true;
        }
        this.harness.check(bl33, "to int, equals");
        boolean bl34 = false;
        if ((c8 ^ s3) == (i8 ^ i3)) {
            bl34 = true;
        }
        this.harness.check(bl34, "to int, equals");
        boolean bl35 = false;
        if (this.getType(b8 ^ c3) == 'I') {
            bl35 = true;
        }
        this.harness.check(bl35, "result should be int");
        boolean bl36 = false;
        if (this.getType(c8 ^ b3) == 'I') {
            bl36 = true;
        }
        this.harness.check(bl36, "result should be int");
        boolean bl37 = false;
        if ((b8 ^ s3) == (i8 ^ i3)) {
            bl37 = true;
        }
        this.harness.check(bl37, "to int, equals");
        boolean bl38 = false;
        if ((s8 ^ b3) == (i8 ^ i3)) {
            bl38 = true;
        }
        this.harness.check(bl38, "to int, equals");
        boolean bl39 = false;
        if (this.getType(b8 ^ s3) == 'I') {
            bl39 = true;
        }
        this.harness.check(bl39, "result should be int");
        boolean bl40 = false;
        if (this.getType(s8 ^ b3) == 'I') {
            bl40 = true;
        }
        this.harness.check(bl40, "result should be int");
    }

    private final void testPromotionCompareSmaller() {
        int b3 = 3;
        int s3 = 3;
        int c3 = 3;
        int i3 = 3;
        long l3 = 3;
        float f3 = 3;
        double d3 = 3;
        int b8 = 8;
        int s8 = 8;
        int c8 = 8;
        int i8 = 8;
        long l8 = 8L;
        float f8 = 8.0f;
        double d8 = 8.0;
        boolean bl = false;
        if ((double)b8 < d3) {
            bl = true;
        }
        boolean bl2 = false;
        if (d8 < d3) {
            bl2 = true;
        }
        this.harness.check(bl ^ bl2 ^ true, "to double, equals");
        boolean bl3 = false;
        if (d8 < (double)b3) {
            bl3 = true;
        }
        boolean bl4 = false;
        if (d8 < d3) {
            bl4 = true;
        }
        this.harness.check(bl3 ^ bl4 ^ true, "to double, equals");
        boolean bl5 = false;
        if ((double)s8 < d3) {
            bl5 = true;
        }
        boolean bl6 = false;
        if (d8 < d3) {
            bl6 = true;
        }
        this.harness.check(bl5 ^ bl6 ^ true, "to double, equals");
        boolean bl7 = false;
        if (d8 < (double)s3) {
            bl7 = true;
        }
        boolean bl8 = false;
        if (d8 < d3) {
            bl8 = true;
        }
        this.harness.check(bl7 ^ bl8 ^ true, "to double, equals");
        boolean bl9 = false;
        if ((double)c8 < d3) {
            bl9 = true;
        }
        boolean bl10 = false;
        if (d8 < d3) {
            bl10 = true;
        }
        this.harness.check(bl9 ^ bl10 ^ true, "to double, equals");
        boolean bl11 = false;
        if (d8 < (double)c3) {
            bl11 = true;
        }
        boolean bl12 = false;
        if (d8 < d3) {
            bl12 = true;
        }
        this.harness.check(bl11 ^ bl12 ^ true, "to double, equals");
        boolean bl13 = false;
        if ((double)i8 < d3) {
            bl13 = true;
        }
        boolean bl14 = false;
        if (d8 < d3) {
            bl14 = true;
        }
        this.harness.check(bl13 ^ bl14 ^ true, "to double, equals");
        boolean bl15 = false;
        if (d8 < (double)i3) {
            bl15 = true;
        }
        boolean bl16 = false;
        if (d8 < d3) {
            bl16 = true;
        }
        this.harness.check(bl15 ^ bl16 ^ true, "to double, equals");
        boolean bl17 = false;
        if ((double)l8 < d3) {
            bl17 = true;
        }
        boolean bl18 = false;
        if (d8 < d3) {
            bl18 = true;
        }
        this.harness.check(bl17 ^ bl18 ^ true, "to double, equals");
        boolean bl19 = false;
        if (d8 < (double)l3) {
            bl19 = true;
        }
        boolean bl20 = false;
        if (d8 < d3) {
            bl20 = true;
        }
        this.harness.check(bl19 ^ bl20 ^ true, "to double, equals");
        boolean bl21 = false;
        if ((double)f8 < d3) {
            bl21 = true;
        }
        boolean bl22 = false;
        if (d8 < d3) {
            bl22 = true;
        }
        this.harness.check(bl21 ^ bl22 ^ true, "to double, equals");
        boolean bl23 = false;
        if (d8 < (double)f3) {
            bl23 = true;
        }
        boolean bl24 = false;
        if (d8 < d3) {
            bl24 = true;
        }
        this.harness.check(bl23 ^ bl24 ^ true, "to double, equals");
        boolean bl25 = false;
        if ((float)b8 < f3) {
            bl25 = true;
        }
        boolean bl26 = false;
        if (f8 < f3) {
            bl26 = true;
        }
        this.harness.check(bl25 ^ bl26 ^ true, "to float equals");
        boolean bl27 = false;
        if (f8 < (float)b3) {
            bl27 = true;
        }
        boolean bl28 = false;
        if (f8 < f3) {
            bl28 = true;
        }
        this.harness.check(bl27 ^ bl28 ^ true, "to float equals");
        boolean bl29 = false;
        if ((float)s8 < f3) {
            bl29 = true;
        }
        boolean bl30 = false;
        if (f8 < f3) {
            bl30 = true;
        }
        this.harness.check(bl29 ^ bl30 ^ true, "to float equals");
        boolean bl31 = false;
        if (f8 < (float)s3) {
            bl31 = true;
        }
        boolean bl32 = false;
        if (f8 < f3) {
            bl32 = true;
        }
        this.harness.check(bl31 ^ bl32 ^ true, "to float equals");
        boolean bl33 = false;
        if ((float)c8 < f3) {
            bl33 = true;
        }
        boolean bl34 = false;
        if (f8 < f3) {
            bl34 = true;
        }
        this.harness.check(bl33 ^ bl34 ^ true, "to float equals");
        boolean bl35 = false;
        if (f8 < (float)c3) {
            bl35 = true;
        }
        boolean bl36 = false;
        if (f8 < f3) {
            bl36 = true;
        }
        this.harness.check(bl35 ^ bl36 ^ true, "to float equals");
        boolean bl37 = false;
        if ((float)i8 < f3) {
            bl37 = true;
        }
        boolean bl38 = false;
        if (f8 < f3) {
            bl38 = true;
        }
        this.harness.check(bl37 ^ bl38 ^ true, "to float equals");
        boolean bl39 = false;
        if (f8 < (float)i3) {
            bl39 = true;
        }
        boolean bl40 = false;
        if (f8 < f3) {
            bl40 = true;
        }
        this.harness.check(bl39 ^ bl40 ^ true, "to float equals");
        boolean bl41 = false;
        if ((float)l8 < f3) {
            bl41 = true;
        }
        boolean bl42 = false;
        if (f8 < f3) {
            bl42 = true;
        }
        this.harness.check(bl41 ^ bl42 ^ true, "to float equals");
        boolean bl43 = false;
        if (f8 < (float)l3) {
            bl43 = true;
        }
        boolean bl44 = false;
        if (f8 < f3) {
            bl44 = true;
        }
        this.harness.check(bl43 ^ bl44 ^ true, "to float equals");
        boolean bl45 = false;
        if ((long)b8 < l3) {
            bl45 = true;
        }
        boolean bl46 = false;
        if (l8 < l3) {
            bl46 = true;
        }
        this.harness.check(bl45 ^ bl46 ^ true, "to long, equals");
        boolean bl47 = false;
        if (l8 < (long)b3) {
            bl47 = true;
        }
        boolean bl48 = false;
        if (l8 < l3) {
            bl48 = true;
        }
        this.harness.check(bl47 ^ bl48 ^ true, "to long, equals");
        boolean bl49 = false;
        if ((long)s8 < l3) {
            bl49 = true;
        }
        boolean bl50 = false;
        if (l8 < l3) {
            bl50 = true;
        }
        this.harness.check(bl49 ^ bl50 ^ true, "to long, equals");
        boolean bl51 = false;
        if (l8 < (long)s3) {
            bl51 = true;
        }
        boolean bl52 = false;
        if (l8 < l3) {
            bl52 = true;
        }
        this.harness.check(bl51 ^ bl52 ^ true, "to long, equals");
        boolean bl53 = false;
        if ((long)c8 < l3) {
            bl53 = true;
        }
        boolean bl54 = false;
        if (l8 < l3) {
            bl54 = true;
        }
        this.harness.check(bl53 ^ bl54 ^ true, "to long, equals");
        boolean bl55 = false;
        if (l8 < (long)c3) {
            bl55 = true;
        }
        boolean bl56 = false;
        if (l8 < l3) {
            bl56 = true;
        }
        this.harness.check(bl55 ^ bl56 ^ true, "to long, equals");
        boolean bl57 = false;
        if ((long)i8 < l3) {
            bl57 = true;
        }
        boolean bl58 = false;
        if (l8 < l3) {
            bl58 = true;
        }
        this.harness.check(bl57 ^ bl58 ^ true, "to long, equals");
        boolean bl59 = false;
        if (l8 < (long)i3) {
            bl59 = true;
        }
        boolean bl60 = false;
        if (l8 < l3) {
            bl60 = true;
        }
        this.harness.check(bl59 ^ bl60 ^ true, "to long, equals");
        boolean bl61 = false;
        if (b8 < i3) {
            bl61 = true;
        }
        boolean bl62 = false;
        if (i8 < i3) {
            bl62 = true;
        }
        this.harness.check(bl61 ^ bl62 ^ true, "to int, equals");
        boolean bl63 = false;
        if (i8 < b3) {
            bl63 = true;
        }
        boolean bl64 = false;
        if (i8 < i3) {
            bl64 = true;
        }
        this.harness.check(bl63 ^ bl64 ^ true, "to int, equals");
        boolean bl65 = false;
        if (s8 < i3) {
            bl65 = true;
        }
        boolean bl66 = false;
        if (i8 < i3) {
            bl66 = true;
        }
        this.harness.check(bl65 ^ bl66 ^ true, "to int, equals");
        boolean bl67 = false;
        if (i8 < s3) {
            bl67 = true;
        }
        boolean bl68 = false;
        if (i8 < i3) {
            bl68 = true;
        }
        this.harness.check(bl67 ^ bl68 ^ true, "to int, equals");
        boolean bl69 = false;
        if (c8 < i3) {
            bl69 = true;
        }
        boolean bl70 = false;
        if (i8 < i3) {
            bl70 = true;
        }
        this.harness.check(bl69 ^ bl70 ^ true, "to int, equals");
        boolean bl71 = false;
        if (i8 < c3) {
            bl71 = true;
        }
        boolean bl72 = false;
        if (i8 < i3) {
            bl72 = true;
        }
        this.harness.check(bl71 ^ bl72 ^ true, "to int, equals");
        boolean bl73 = false;
        if (b8 < c3) {
            bl73 = true;
        }
        boolean bl74 = false;
        if (i8 < i3) {
            bl74 = true;
        }
        this.harness.check(bl73 ^ bl74 ^ true, "to int, equals");
        boolean bl75 = false;
        if (c8 < b3) {
            bl75 = true;
        }
        boolean bl76 = false;
        if (i8 < i3) {
            bl76 = true;
        }
        this.harness.check(bl75 ^ bl76 ^ true, "to int, equals");
        boolean bl77 = false;
        if (s8 < c3) {
            bl77 = true;
        }
        boolean bl78 = false;
        if (i8 < i3) {
            bl78 = true;
        }
        this.harness.check(bl77 ^ bl78 ^ true, "to int, equals");
        boolean bl79 = false;
        if (c8 < s3) {
            bl79 = true;
        }
        boolean bl80 = false;
        if (i8 < i3) {
            bl80 = true;
        }
        this.harness.check(bl79 ^ bl80 ^ true, "to int, equals");
        boolean bl81 = false;
        if (b8 < s3) {
            bl81 = true;
        }
        boolean bl82 = false;
        if (i8 < i3) {
            bl82 = true;
        }
        this.harness.check(bl81 ^ bl82 ^ true, "to int, equals");
        boolean bl83 = false;
        if (s8 < b3) {
            bl83 = true;
        }
        boolean bl84 = false;
        if (i8 < i3) {
            bl84 = true;
        }
        this.harness.check(bl83 ^ bl84 ^ true, "to int, equals");
    }

    private final void testPromotionCompareSmallerEquals() {
        int b3 = 3;
        int s3 = 3;
        int c3 = 3;
        int i3 = 3;
        long l3 = 3;
        float f3 = 3;
        double d3 = 3;
        int b8 = 8;
        int s8 = 8;
        int c8 = 8;
        int i8 = 8;
        long l8 = 8L;
        float f8 = 8.0f;
        double d8 = 8.0;
        boolean bl = false;
        if ((double)b8 <= d3) {
            bl = true;
        }
        boolean bl2 = false;
        if (d8 <= d3) {
            bl2 = true;
        }
        this.harness.check(bl ^ bl2 ^ true, "to double, equals");
        boolean bl3 = false;
        if (d8 <= (double)b3) {
            bl3 = true;
        }
        boolean bl4 = false;
        if (d8 <= d3) {
            bl4 = true;
        }
        this.harness.check(bl3 ^ bl4 ^ true, "to double, equals");
        boolean bl5 = false;
        if ((double)s8 <= d3) {
            bl5 = true;
        }
        boolean bl6 = false;
        if (d8 <= d3) {
            bl6 = true;
        }
        this.harness.check(bl5 ^ bl6 ^ true, "to double, equals");
        boolean bl7 = false;
        if (d8 <= (double)s3) {
            bl7 = true;
        }
        boolean bl8 = false;
        if (d8 <= d3) {
            bl8 = true;
        }
        this.harness.check(bl7 ^ bl8 ^ true, "to double, equals");
        boolean bl9 = false;
        if ((double)c8 <= d3) {
            bl9 = true;
        }
        boolean bl10 = false;
        if (d8 <= d3) {
            bl10 = true;
        }
        this.harness.check(bl9 ^ bl10 ^ true, "to double, equals");
        boolean bl11 = false;
        if (d8 <= (double)c3) {
            bl11 = true;
        }
        boolean bl12 = false;
        if (d8 <= d3) {
            bl12 = true;
        }
        this.harness.check(bl11 ^ bl12 ^ true, "to double, equals");
        boolean bl13 = false;
        if ((double)i8 <= d3) {
            bl13 = true;
        }
        boolean bl14 = false;
        if (d8 <= d3) {
            bl14 = true;
        }
        this.harness.check(bl13 ^ bl14 ^ true, "to double, equals");
        boolean bl15 = false;
        if (d8 <= (double)i3) {
            bl15 = true;
        }
        boolean bl16 = false;
        if (d8 <= d3) {
            bl16 = true;
        }
        this.harness.check(bl15 ^ bl16 ^ true, "to double, equals");
        boolean bl17 = false;
        if ((double)l8 <= d3) {
            bl17 = true;
        }
        boolean bl18 = false;
        if (d8 <= d3) {
            bl18 = true;
        }
        this.harness.check(bl17 ^ bl18 ^ true, "to double, equals");
        boolean bl19 = false;
        if (d8 <= (double)l3) {
            bl19 = true;
        }
        boolean bl20 = false;
        if (d8 <= d3) {
            bl20 = true;
        }
        this.harness.check(bl19 ^ bl20 ^ true, "to double, equals");
        boolean bl21 = false;
        if ((double)f8 <= d3) {
            bl21 = true;
        }
        boolean bl22 = false;
        if (d8 <= d3) {
            bl22 = true;
        }
        this.harness.check(bl21 ^ bl22 ^ true, "to double, equals");
        boolean bl23 = false;
        if (d8 <= (double)f3) {
            bl23 = true;
        }
        boolean bl24 = false;
        if (d8 <= d3) {
            bl24 = true;
        }
        this.harness.check(bl23 ^ bl24 ^ true, "to double, equals");
        boolean bl25 = false;
        if ((float)b8 <= f3) {
            bl25 = true;
        }
        boolean bl26 = false;
        if (f8 <= f3) {
            bl26 = true;
        }
        this.harness.check(bl25 ^ bl26 ^ true, "to float equals");
        boolean bl27 = false;
        if (f8 <= (float)b3) {
            bl27 = true;
        }
        boolean bl28 = false;
        if (f8 <= f3) {
            bl28 = true;
        }
        this.harness.check(bl27 ^ bl28 ^ true, "to float equals");
        boolean bl29 = false;
        if ((float)s8 <= f3) {
            bl29 = true;
        }
        boolean bl30 = false;
        if (f8 <= f3) {
            bl30 = true;
        }
        this.harness.check(bl29 ^ bl30 ^ true, "to float equals");
        boolean bl31 = false;
        if (f8 <= (float)s3) {
            bl31 = true;
        }
        boolean bl32 = false;
        if (f8 <= f3) {
            bl32 = true;
        }
        this.harness.check(bl31 ^ bl32 ^ true, "to float equals");
        boolean bl33 = false;
        if ((float)c8 <= f3) {
            bl33 = true;
        }
        boolean bl34 = false;
        if (f8 <= f3) {
            bl34 = true;
        }
        this.harness.check(bl33 ^ bl34 ^ true, "to float equals");
        boolean bl35 = false;
        if (f8 <= (float)c3) {
            bl35 = true;
        }
        boolean bl36 = false;
        if (f8 <= f3) {
            bl36 = true;
        }
        this.harness.check(bl35 ^ bl36 ^ true, "to float equals");
        boolean bl37 = false;
        if ((float)i8 <= f3) {
            bl37 = true;
        }
        boolean bl38 = false;
        if (f8 <= f3) {
            bl38 = true;
        }
        this.harness.check(bl37 ^ bl38 ^ true, "to float equals");
        boolean bl39 = false;
        if (f8 <= (float)i3) {
            bl39 = true;
        }
        boolean bl40 = false;
        if (f8 <= f3) {
            bl40 = true;
        }
        this.harness.check(bl39 ^ bl40 ^ true, "to float equals");
        boolean bl41 = false;
        if ((float)l8 <= f3) {
            bl41 = true;
        }
        boolean bl42 = false;
        if (f8 <= f3) {
            bl42 = true;
        }
        this.harness.check(bl41 ^ bl42 ^ true, "to float equals");
        boolean bl43 = false;
        if (f8 <= (float)l3) {
            bl43 = true;
        }
        boolean bl44 = false;
        if (f8 <= f3) {
            bl44 = true;
        }
        this.harness.check(bl43 ^ bl44 ^ true, "to float equals");
        boolean bl45 = false;
        if ((long)b8 <= l3) {
            bl45 = true;
        }
        boolean bl46 = false;
        if (l8 <= l3) {
            bl46 = true;
        }
        this.harness.check(bl45 ^ bl46 ^ true, "to long, equals");
        boolean bl47 = false;
        if (l8 <= (long)b3) {
            bl47 = true;
        }
        boolean bl48 = false;
        if (l8 <= l3) {
            bl48 = true;
        }
        this.harness.check(bl47 ^ bl48 ^ true, "to long, equals");
        boolean bl49 = false;
        if ((long)s8 <= l3) {
            bl49 = true;
        }
        boolean bl50 = false;
        if (l8 <= l3) {
            bl50 = true;
        }
        this.harness.check(bl49 ^ bl50 ^ true, "to long, equals");
        boolean bl51 = false;
        if (l8 <= (long)s3) {
            bl51 = true;
        }
        boolean bl52 = false;
        if (l8 <= l3) {
            bl52 = true;
        }
        this.harness.check(bl51 ^ bl52 ^ true, "to long, equals");
        boolean bl53 = false;
        if ((long)c8 <= l3) {
            bl53 = true;
        }
        boolean bl54 = false;
        if (l8 <= l3) {
            bl54 = true;
        }
        this.harness.check(bl53 ^ bl54 ^ true, "to long, equals");
        boolean bl55 = false;
        if (l8 <= (long)c3) {
            bl55 = true;
        }
        boolean bl56 = false;
        if (l8 <= l3) {
            bl56 = true;
        }
        this.harness.check(bl55 ^ bl56 ^ true, "to long, equals");
        boolean bl57 = false;
        if ((long)i8 <= l3) {
            bl57 = true;
        }
        boolean bl58 = false;
        if (l8 <= l3) {
            bl58 = true;
        }
        this.harness.check(bl57 ^ bl58 ^ true, "to long, equals");
        boolean bl59 = false;
        if (l8 <= (long)i3) {
            bl59 = true;
        }
        boolean bl60 = false;
        if (l8 <= l3) {
            bl60 = true;
        }
        this.harness.check(bl59 ^ bl60 ^ true, "to long, equals");
        boolean bl61 = false;
        if (b8 <= i3) {
            bl61 = true;
        }
        boolean bl62 = false;
        if (i8 <= i3) {
            bl62 = true;
        }
        this.harness.check(bl61 ^ bl62 ^ true, "to int, equals");
        boolean bl63 = false;
        if (i8 <= b3) {
            bl63 = true;
        }
        boolean bl64 = false;
        if (i8 <= i3) {
            bl64 = true;
        }
        this.harness.check(bl63 ^ bl64 ^ true, "to int, equals");
        boolean bl65 = false;
        if (s8 <= i3) {
            bl65 = true;
        }
        boolean bl66 = false;
        if (i8 <= i3) {
            bl66 = true;
        }
        this.harness.check(bl65 ^ bl66 ^ true, "to int, equals");
        boolean bl67 = false;
        if (i8 <= s3) {
            bl67 = true;
        }
        boolean bl68 = false;
        if (i8 <= i3) {
            bl68 = true;
        }
        this.harness.check(bl67 ^ bl68 ^ true, "to int, equals");
        boolean bl69 = false;
        if (c8 <= i3) {
            bl69 = true;
        }
        boolean bl70 = false;
        if (i8 <= i3) {
            bl70 = true;
        }
        this.harness.check(bl69 ^ bl70 ^ true, "to int, equals");
        boolean bl71 = false;
        if (i8 <= c3) {
            bl71 = true;
        }
        boolean bl72 = false;
        if (i8 <= i3) {
            bl72 = true;
        }
        this.harness.check(bl71 ^ bl72 ^ true, "to int, equals");
        boolean bl73 = false;
        if (b8 <= c3) {
            bl73 = true;
        }
        boolean bl74 = false;
        if (i8 <= i3) {
            bl74 = true;
        }
        this.harness.check(bl73 ^ bl74 ^ true, "to int, equals");
        boolean bl75 = false;
        if (c8 <= b3) {
            bl75 = true;
        }
        boolean bl76 = false;
        if (i8 <= i3) {
            bl76 = true;
        }
        this.harness.check(bl75 ^ bl76 ^ true, "to int, equals");
        boolean bl77 = false;
        if (s8 <= c3) {
            bl77 = true;
        }
        boolean bl78 = false;
        if (i8 <= i3) {
            bl78 = true;
        }
        this.harness.check(bl77 ^ bl78 ^ true, "to int, equals");
        boolean bl79 = false;
        if (c8 <= s3) {
            bl79 = true;
        }
        boolean bl80 = false;
        if (i8 <= i3) {
            bl80 = true;
        }
        this.harness.check(bl79 ^ bl80 ^ true, "to int, equals");
        boolean bl81 = false;
        if (b8 <= s3) {
            bl81 = true;
        }
        boolean bl82 = false;
        if (i8 <= i3) {
            bl82 = true;
        }
        this.harness.check(bl81 ^ bl82 ^ true, "to int, equals");
        boolean bl83 = false;
        if (s8 <= b3) {
            bl83 = true;
        }
        boolean bl84 = false;
        if (i8 <= i3) {
            bl84 = true;
        }
        this.harness.check(bl83 ^ bl84 ^ true, "to int, equals");
    }

    private final void testPromotionCompareEqual() {
        int b3 = 3;
        int s3 = 3;
        int c3 = 3;
        int i3 = 3;
        long l3 = 3;
        float f3 = 3;
        double d3 = 3;
        int b8 = 8;
        int s8 = 8;
        int c8 = 8;
        int i8 = 8;
        long l8 = 8L;
        float f8 = 8.0f;
        double d8 = 8.0;
        boolean bl = false;
        if ((double)b8 == d3) {
            bl = true;
        }
        boolean bl2 = false;
        if (d8 == d3) {
            bl2 = true;
        }
        this.harness.check(bl ^ bl2 ^ true, "to double, equals");
        boolean bl3 = false;
        if (d8 == (double)b3) {
            bl3 = true;
        }
        boolean bl4 = false;
        if (d8 == d3) {
            bl4 = true;
        }
        this.harness.check(bl3 ^ bl4 ^ true, "to double, equals");
        boolean bl5 = false;
        if ((double)s8 == d3) {
            bl5 = true;
        }
        boolean bl6 = false;
        if (d8 == d3) {
            bl6 = true;
        }
        this.harness.check(bl5 ^ bl6 ^ true, "to double, equals");
        boolean bl7 = false;
        if (d8 == (double)s3) {
            bl7 = true;
        }
        boolean bl8 = false;
        if (d8 == d3) {
            bl8 = true;
        }
        this.harness.check(bl7 ^ bl8 ^ true, "to double, equals");
        boolean bl9 = false;
        if ((double)c8 == d3) {
            bl9 = true;
        }
        boolean bl10 = false;
        if (d8 == d3) {
            bl10 = true;
        }
        this.harness.check(bl9 ^ bl10 ^ true, "to double, equals");
        boolean bl11 = false;
        if (d8 == (double)c3) {
            bl11 = true;
        }
        boolean bl12 = false;
        if (d8 == d3) {
            bl12 = true;
        }
        this.harness.check(bl11 ^ bl12 ^ true, "to double, equals");
        boolean bl13 = false;
        if ((double)i8 == d3) {
            bl13 = true;
        }
        boolean bl14 = false;
        if (d8 == d3) {
            bl14 = true;
        }
        this.harness.check(bl13 ^ bl14 ^ true, "to double, equals");
        boolean bl15 = false;
        if (d8 == (double)i3) {
            bl15 = true;
        }
        boolean bl16 = false;
        if (d8 == d3) {
            bl16 = true;
        }
        this.harness.check(bl15 ^ bl16 ^ true, "to double, equals");
        boolean bl17 = false;
        if ((double)l8 == d3) {
            bl17 = true;
        }
        boolean bl18 = false;
        if (d8 == d3) {
            bl18 = true;
        }
        this.harness.check(bl17 ^ bl18 ^ true, "to double, equals");
        boolean bl19 = false;
        if (d8 == (double)l3) {
            bl19 = true;
        }
        boolean bl20 = false;
        if (d8 == d3) {
            bl20 = true;
        }
        this.harness.check(bl19 ^ bl20 ^ true, "to double, equals");
        boolean bl21 = false;
        if ((double)f8 == d3) {
            bl21 = true;
        }
        boolean bl22 = false;
        if (d8 == d3) {
            bl22 = true;
        }
        this.harness.check(bl21 ^ bl22 ^ true, "to double, equals");
        boolean bl23 = false;
        if (d8 == (double)f3) {
            bl23 = true;
        }
        boolean bl24 = false;
        if (d8 == d3) {
            bl24 = true;
        }
        this.harness.check(bl23 ^ bl24 ^ true, "to double, equals");
        boolean bl25 = false;
        if ((float)b8 == f3) {
            bl25 = true;
        }
        boolean bl26 = false;
        if (f8 == f3) {
            bl26 = true;
        }
        this.harness.check(bl25 ^ bl26 ^ true, "to float equals");
        boolean bl27 = false;
        if (f8 == (float)b3) {
            bl27 = true;
        }
        boolean bl28 = false;
        if (f8 == f3) {
            bl28 = true;
        }
        this.harness.check(bl27 ^ bl28 ^ true, "to float equals");
        boolean bl29 = false;
        if ((float)s8 == f3) {
            bl29 = true;
        }
        boolean bl30 = false;
        if (f8 == f3) {
            bl30 = true;
        }
        this.harness.check(bl29 ^ bl30 ^ true, "to float equals");
        boolean bl31 = false;
        if (f8 == (float)s3) {
            bl31 = true;
        }
        boolean bl32 = false;
        if (f8 == f3) {
            bl32 = true;
        }
        this.harness.check(bl31 ^ bl32 ^ true, "to float equals");
        boolean bl33 = false;
        if ((float)c8 == f3) {
            bl33 = true;
        }
        boolean bl34 = false;
        if (f8 == f3) {
            bl34 = true;
        }
        this.harness.check(bl33 ^ bl34 ^ true, "to float equals");
        boolean bl35 = false;
        if (f8 == (float)c3) {
            bl35 = true;
        }
        boolean bl36 = false;
        if (f8 == f3) {
            bl36 = true;
        }
        this.harness.check(bl35 ^ bl36 ^ true, "to float equals");
        boolean bl37 = false;
        if ((float)i8 == f3) {
            bl37 = true;
        }
        boolean bl38 = false;
        if (f8 == f3) {
            bl38 = true;
        }
        this.harness.check(bl37 ^ bl38 ^ true, "to float equals");
        boolean bl39 = false;
        if (f8 == (float)i3) {
            bl39 = true;
        }
        boolean bl40 = false;
        if (f8 == f3) {
            bl40 = true;
        }
        this.harness.check(bl39 ^ bl40 ^ true, "to float equals");
        boolean bl41 = false;
        if ((float)l8 == f3) {
            bl41 = true;
        }
        boolean bl42 = false;
        if (f8 == f3) {
            bl42 = true;
        }
        this.harness.check(bl41 ^ bl42 ^ true, "to float equals");
        boolean bl43 = false;
        if (f8 == (float)l3) {
            bl43 = true;
        }
        boolean bl44 = false;
        if (f8 == f3) {
            bl44 = true;
        }
        this.harness.check(bl43 ^ bl44 ^ true, "to float equals");
        boolean bl45 = false;
        if ((long)b8 == l3) {
            bl45 = true;
        }
        boolean bl46 = false;
        if (l8 == l3) {
            bl46 = true;
        }
        this.harness.check(bl45 ^ bl46 ^ true, "to long, equals");
        boolean bl47 = false;
        if (l8 == (long)b3) {
            bl47 = true;
        }
        boolean bl48 = false;
        if (l8 == l3) {
            bl48 = true;
        }
        this.harness.check(bl47 ^ bl48 ^ true, "to long, equals");
        boolean bl49 = false;
        if ((long)s8 == l3) {
            bl49 = true;
        }
        boolean bl50 = false;
        if (l8 == l3) {
            bl50 = true;
        }
        this.harness.check(bl49 ^ bl50 ^ true, "to long, equals");
        boolean bl51 = false;
        if (l8 == (long)s3) {
            bl51 = true;
        }
        boolean bl52 = false;
        if (l8 == l3) {
            bl52 = true;
        }
        this.harness.check(bl51 ^ bl52 ^ true, "to long, equals");
        boolean bl53 = false;
        if ((long)c8 == l3) {
            bl53 = true;
        }
        boolean bl54 = false;
        if (l8 == l3) {
            bl54 = true;
        }
        this.harness.check(bl53 ^ bl54 ^ true, "to long, equals");
        boolean bl55 = false;
        if (l8 == (long)c3) {
            bl55 = true;
        }
        boolean bl56 = false;
        if (l8 == l3) {
            bl56 = true;
        }
        this.harness.check(bl55 ^ bl56 ^ true, "to long, equals");
        boolean bl57 = false;
        if ((long)i8 == l3) {
            bl57 = true;
        }
        boolean bl58 = false;
        if (l8 == l3) {
            bl58 = true;
        }
        this.harness.check(bl57 ^ bl58 ^ true, "to long, equals");
        boolean bl59 = false;
        if (l8 == (long)i3) {
            bl59 = true;
        }
        boolean bl60 = false;
        if (l8 == l3) {
            bl60 = true;
        }
        this.harness.check(bl59 ^ bl60 ^ true, "to long, equals");
        boolean bl61 = false;
        if (b8 == i3) {
            bl61 = true;
        }
        boolean bl62 = false;
        if (i8 == i3) {
            bl62 = true;
        }
        this.harness.check(bl61 ^ bl62 ^ true, "to int, equals");
        boolean bl63 = false;
        if (i8 == b3) {
            bl63 = true;
        }
        boolean bl64 = false;
        if (i8 == i3) {
            bl64 = true;
        }
        this.harness.check(bl63 ^ bl64 ^ true, "to int, equals");
        boolean bl65 = false;
        if (s8 == i3) {
            bl65 = true;
        }
        boolean bl66 = false;
        if (i8 == i3) {
            bl66 = true;
        }
        this.harness.check(bl65 ^ bl66 ^ true, "to int, equals");
        boolean bl67 = false;
        if (i8 == s3) {
            bl67 = true;
        }
        boolean bl68 = false;
        if (i8 == i3) {
            bl68 = true;
        }
        this.harness.check(bl67 ^ bl68 ^ true, "to int, equals");
        boolean bl69 = false;
        if (c8 == i3) {
            bl69 = true;
        }
        boolean bl70 = false;
        if (i8 == i3) {
            bl70 = true;
        }
        this.harness.check(bl69 ^ bl70 ^ true, "to int, equals");
        boolean bl71 = false;
        if (i8 == c3) {
            bl71 = true;
        }
        boolean bl72 = false;
        if (i8 == i3) {
            bl72 = true;
        }
        this.harness.check(bl71 ^ bl72 ^ true, "to int, equals");
        boolean bl73 = false;
        if (b8 == c3) {
            bl73 = true;
        }
        boolean bl74 = false;
        if (i8 == i3) {
            bl74 = true;
        }
        this.harness.check(bl73 ^ bl74 ^ true, "to int, equals");
        boolean bl75 = false;
        if (c8 == b3) {
            bl75 = true;
        }
        boolean bl76 = false;
        if (i8 == i3) {
            bl76 = true;
        }
        this.harness.check(bl75 ^ bl76 ^ true, "to int, equals");
        boolean bl77 = false;
        if (s8 == c3) {
            bl77 = true;
        }
        boolean bl78 = false;
        if (i8 == i3) {
            bl78 = true;
        }
        this.harness.check(bl77 ^ bl78 ^ true, "to int, equals");
        boolean bl79 = false;
        if (c8 == s3) {
            bl79 = true;
        }
        boolean bl80 = false;
        if (i8 == i3) {
            bl80 = true;
        }
        this.harness.check(bl79 ^ bl80 ^ true, "to int, equals");
        boolean bl81 = false;
        if (b8 == s3) {
            bl81 = true;
        }
        boolean bl82 = false;
        if (i8 == i3) {
            bl82 = true;
        }
        this.harness.check(bl81 ^ bl82 ^ true, "to int, equals");
        boolean bl83 = false;
        if (s8 == b3) {
            bl83 = true;
        }
        boolean bl84 = false;
        if (i8 == i3) {
            bl84 = true;
        }
        this.harness.check(bl83 ^ bl84 ^ true, "to int, equals");
    }

    private final void testPromotionCompareNotEqual() {
        int b3 = 3;
        int s3 = 3;
        int c3 = 3;
        int i3 = 3;
        long l3 = 3;
        float f3 = 3;
        double d3 = 3;
        int b8 = 8;
        int s8 = 8;
        int c8 = 8;
        int i8 = 8;
        long l8 = 8L;
        float f8 = 8.0f;
        double d8 = 8.0;
        boolean bl = false;
        if ((double)b8 != d3) {
            bl = true;
        }
        boolean bl2 = false;
        if (d8 != d3) {
            bl2 = true;
        }
        this.harness.check(bl ^ bl2 ^ true, "to double, equals");
        boolean bl3 = false;
        if (d8 != (double)b3) {
            bl3 = true;
        }
        boolean bl4 = false;
        if (d8 != d3) {
            bl4 = true;
        }
        this.harness.check(bl3 ^ bl4 ^ true, "to double, equals");
        boolean bl5 = false;
        if ((double)s8 != d3) {
            bl5 = true;
        }
        boolean bl6 = false;
        if (d8 != d3) {
            bl6 = true;
        }
        this.harness.check(bl5 ^ bl6 ^ true, "to double, equals");
        boolean bl7 = false;
        if (d8 != (double)s3) {
            bl7 = true;
        }
        boolean bl8 = false;
        if (d8 != d3) {
            bl8 = true;
        }
        this.harness.check(bl7 ^ bl8 ^ true, "to double, equals");
        boolean bl9 = false;
        if ((double)c8 != d3) {
            bl9 = true;
        }
        boolean bl10 = false;
        if (d8 != d3) {
            bl10 = true;
        }
        this.harness.check(bl9 ^ bl10 ^ true, "to double, equals");
        boolean bl11 = false;
        if (d8 != (double)c3) {
            bl11 = true;
        }
        boolean bl12 = false;
        if (d8 != d3) {
            bl12 = true;
        }
        this.harness.check(bl11 ^ bl12 ^ true, "to double, equals");
        boolean bl13 = false;
        if ((double)i8 != d3) {
            bl13 = true;
        }
        boolean bl14 = false;
        if (d8 != d3) {
            bl14 = true;
        }
        this.harness.check(bl13 ^ bl14 ^ true, "to double, equals");
        boolean bl15 = false;
        if (d8 != (double)i3) {
            bl15 = true;
        }
        boolean bl16 = false;
        if (d8 != d3) {
            bl16 = true;
        }
        this.harness.check(bl15 ^ bl16 ^ true, "to double, equals");
        boolean bl17 = false;
        if ((double)l8 != d3) {
            bl17 = true;
        }
        boolean bl18 = false;
        if (d8 != d3) {
            bl18 = true;
        }
        this.harness.check(bl17 ^ bl18 ^ true, "to double, equals");
        boolean bl19 = false;
        if (d8 != (double)l3) {
            bl19 = true;
        }
        boolean bl20 = false;
        if (d8 != d3) {
            bl20 = true;
        }
        this.harness.check(bl19 ^ bl20 ^ true, "to double, equals");
        boolean bl21 = false;
        if ((double)f8 != d3) {
            bl21 = true;
        }
        boolean bl22 = false;
        if (d8 != d3) {
            bl22 = true;
        }
        this.harness.check(bl21 ^ bl22 ^ true, "to double, equals");
        boolean bl23 = false;
        if (d8 != (double)f3) {
            bl23 = true;
        }
        boolean bl24 = false;
        if (d8 != d3) {
            bl24 = true;
        }
        this.harness.check(bl23 ^ bl24 ^ true, "to double, equals");
        boolean bl25 = false;
        if ((float)b8 != f3) {
            bl25 = true;
        }
        boolean bl26 = false;
        if (f8 != f3) {
            bl26 = true;
        }
        this.harness.check(bl25 ^ bl26 ^ true, "to float equals");
        boolean bl27 = false;
        if (f8 != (float)b3) {
            bl27 = true;
        }
        boolean bl28 = false;
        if (f8 != f3) {
            bl28 = true;
        }
        this.harness.check(bl27 ^ bl28 ^ true, "to float equals");
        boolean bl29 = false;
        if ((float)s8 != f3) {
            bl29 = true;
        }
        boolean bl30 = false;
        if (f8 != f3) {
            bl30 = true;
        }
        this.harness.check(bl29 ^ bl30 ^ true, "to float equals");
        boolean bl31 = false;
        if (f8 != (float)s3) {
            bl31 = true;
        }
        boolean bl32 = false;
        if (f8 != f3) {
            bl32 = true;
        }
        this.harness.check(bl31 ^ bl32 ^ true, "to float equals");
        boolean bl33 = false;
        if ((float)c8 != f3) {
            bl33 = true;
        }
        boolean bl34 = false;
        if (f8 != f3) {
            bl34 = true;
        }
        this.harness.check(bl33 ^ bl34 ^ true, "to float equals");
        boolean bl35 = false;
        if (f8 != (float)c3) {
            bl35 = true;
        }
        boolean bl36 = false;
        if (f8 != f3) {
            bl36 = true;
        }
        this.harness.check(bl35 ^ bl36 ^ true, "to float equals");
        boolean bl37 = false;
        if ((float)i8 != f3) {
            bl37 = true;
        }
        boolean bl38 = false;
        if (f8 != f3) {
            bl38 = true;
        }
        this.harness.check(bl37 ^ bl38 ^ true, "to float equals");
        boolean bl39 = false;
        if (f8 != (float)i3) {
            bl39 = true;
        }
        boolean bl40 = false;
        if (f8 != f3) {
            bl40 = true;
        }
        this.harness.check(bl39 ^ bl40 ^ true, "to float equals");
        boolean bl41 = false;
        if ((float)l8 != f3) {
            bl41 = true;
        }
        boolean bl42 = false;
        if (f8 != f3) {
            bl42 = true;
        }
        this.harness.check(bl41 ^ bl42 ^ true, "to float equals");
        boolean bl43 = false;
        if (f8 != (float)l3) {
            bl43 = true;
        }
        boolean bl44 = false;
        if (f8 != f3) {
            bl44 = true;
        }
        this.harness.check(bl43 ^ bl44 ^ true, "to float equals");
        boolean bl45 = false;
        if ((long)b8 != l3) {
            bl45 = true;
        }
        boolean bl46 = false;
        if (l8 != l3) {
            bl46 = true;
        }
        this.harness.check(bl45 ^ bl46 ^ true, "to long, equals");
        boolean bl47 = false;
        if (l8 != (long)b3) {
            bl47 = true;
        }
        boolean bl48 = false;
        if (l8 != l3) {
            bl48 = true;
        }
        this.harness.check(bl47 ^ bl48 ^ true, "to long, equals");
        boolean bl49 = false;
        if ((long)s8 != l3) {
            bl49 = true;
        }
        boolean bl50 = false;
        if (l8 != l3) {
            bl50 = true;
        }
        this.harness.check(bl49 ^ bl50 ^ true, "to long, equals");
        boolean bl51 = false;
        if (l8 != (long)s3) {
            bl51 = true;
        }
        boolean bl52 = false;
        if (l8 != l3) {
            bl52 = true;
        }
        this.harness.check(bl51 ^ bl52 ^ true, "to long, equals");
        boolean bl53 = false;
        if ((long)c8 != l3) {
            bl53 = true;
        }
        boolean bl54 = false;
        if (l8 != l3) {
            bl54 = true;
        }
        this.harness.check(bl53 ^ bl54 ^ true, "to long, equals");
        boolean bl55 = false;
        if (l8 != (long)c3) {
            bl55 = true;
        }
        boolean bl56 = false;
        if (l8 != l3) {
            bl56 = true;
        }
        this.harness.check(bl55 ^ bl56 ^ true, "to long, equals");
        boolean bl57 = false;
        if ((long)i8 != l3) {
            bl57 = true;
        }
        boolean bl58 = false;
        if (l8 != l3) {
            bl58 = true;
        }
        this.harness.check(bl57 ^ bl58 ^ true, "to long, equals");
        boolean bl59 = false;
        if (l8 != (long)i3) {
            bl59 = true;
        }
        boolean bl60 = false;
        if (l8 != l3) {
            bl60 = true;
        }
        this.harness.check(bl59 ^ bl60 ^ true, "to long, equals");
        boolean bl61 = false;
        if (b8 != i3) {
            bl61 = true;
        }
        boolean bl62 = false;
        if (i8 != i3) {
            bl62 = true;
        }
        this.harness.check(bl61 ^ bl62 ^ true, "to int, equals");
        boolean bl63 = false;
        if (i8 != b3) {
            bl63 = true;
        }
        boolean bl64 = false;
        if (i8 != i3) {
            bl64 = true;
        }
        this.harness.check(bl63 ^ bl64 ^ true, "to int, equals");
        boolean bl65 = false;
        if (s8 != i3) {
            bl65 = true;
        }
        boolean bl66 = false;
        if (i8 != i3) {
            bl66 = true;
        }
        this.harness.check(bl65 ^ bl66 ^ true, "to int, equals");
        boolean bl67 = false;
        if (i8 != s3) {
            bl67 = true;
        }
        boolean bl68 = false;
        if (i8 != i3) {
            bl68 = true;
        }
        this.harness.check(bl67 ^ bl68 ^ true, "to int, equals");
        boolean bl69 = false;
        if (c8 != i3) {
            bl69 = true;
        }
        boolean bl70 = false;
        if (i8 != i3) {
            bl70 = true;
        }
        this.harness.check(bl69 ^ bl70 ^ true, "to int, equals");
        boolean bl71 = false;
        if (i8 != c3) {
            bl71 = true;
        }
        boolean bl72 = false;
        if (i8 != i3) {
            bl72 = true;
        }
        this.harness.check(bl71 ^ bl72 ^ true, "to int, equals");
        boolean bl73 = false;
        if (b8 != c3) {
            bl73 = true;
        }
        boolean bl74 = false;
        if (i8 != i3) {
            bl74 = true;
        }
        this.harness.check(bl73 ^ bl74 ^ true, "to int, equals");
        boolean bl75 = false;
        if (c8 != b3) {
            bl75 = true;
        }
        boolean bl76 = false;
        if (i8 != i3) {
            bl76 = true;
        }
        this.harness.check(bl75 ^ bl76 ^ true, "to int, equals");
        boolean bl77 = false;
        if (s8 != c3) {
            bl77 = true;
        }
        boolean bl78 = false;
        if (i8 != i3) {
            bl78 = true;
        }
        this.harness.check(bl77 ^ bl78 ^ true, "to int, equals");
        boolean bl79 = false;
        if (c8 != s3) {
            bl79 = true;
        }
        boolean bl80 = false;
        if (i8 != i3) {
            bl80 = true;
        }
        this.harness.check(bl79 ^ bl80 ^ true, "to int, equals");
        boolean bl81 = false;
        if (b8 != s3) {
            bl81 = true;
        }
        boolean bl82 = false;
        if (i8 != i3) {
            bl82 = true;
        }
        this.harness.check(bl81 ^ bl82 ^ true, "to int, equals");
        boolean bl83 = false;
        if (s8 != b3) {
            bl83 = true;
        }
        boolean bl84 = false;
        if (i8 != i3) {
            bl84 = true;
        }
        this.harness.check(bl83 ^ bl84 ^ true, "to int, equals");
    }

    private final void testPromotionCompareBigger() {
        int b3 = 3;
        int s3 = 3;
        int c3 = 3;
        int i3 = 3;
        long l3 = 3;
        float f3 = 3;
        double d3 = 3;
        int b8 = 8;
        int s8 = 8;
        int c8 = 8;
        int i8 = 8;
        long l8 = 8L;
        float f8 = 8.0f;
        double d8 = 8.0;
        boolean bl = false;
        if ((double)b8 > d3) {
            bl = true;
        }
        boolean bl2 = false;
        if (d8 > d3) {
            bl2 = true;
        }
        this.harness.check(bl ^ bl2 ^ true, "to double, equals");
        boolean bl3 = false;
        if (d8 > (double)b3) {
            bl3 = true;
        }
        boolean bl4 = false;
        if (d8 > d3) {
            bl4 = true;
        }
        this.harness.check(bl3 ^ bl4 ^ true, "to double, equals");
        boolean bl5 = false;
        if ((double)s8 > d3) {
            bl5 = true;
        }
        boolean bl6 = false;
        if (d8 > d3) {
            bl6 = true;
        }
        this.harness.check(bl5 ^ bl6 ^ true, "to double, equals");
        boolean bl7 = false;
        if (d8 > (double)s3) {
            bl7 = true;
        }
        boolean bl8 = false;
        if (d8 > d3) {
            bl8 = true;
        }
        this.harness.check(bl7 ^ bl8 ^ true, "to double, equals");
        boolean bl9 = false;
        if ((double)c8 > d3) {
            bl9 = true;
        }
        boolean bl10 = false;
        if (d8 > d3) {
            bl10 = true;
        }
        this.harness.check(bl9 ^ bl10 ^ true, "to double, equals");
        boolean bl11 = false;
        if (d8 > (double)c3) {
            bl11 = true;
        }
        boolean bl12 = false;
        if (d8 > d3) {
            bl12 = true;
        }
        this.harness.check(bl11 ^ bl12 ^ true, "to double, equals");
        boolean bl13 = false;
        if ((double)i8 > d3) {
            bl13 = true;
        }
        boolean bl14 = false;
        if (d8 > d3) {
            bl14 = true;
        }
        this.harness.check(bl13 ^ bl14 ^ true, "to double, equals");
        boolean bl15 = false;
        if (d8 > (double)i3) {
            bl15 = true;
        }
        boolean bl16 = false;
        if (d8 > d3) {
            bl16 = true;
        }
        this.harness.check(bl15 ^ bl16 ^ true, "to double, equals");
        boolean bl17 = false;
        if ((double)l8 > d3) {
            bl17 = true;
        }
        boolean bl18 = false;
        if (d8 > d3) {
            bl18 = true;
        }
        this.harness.check(bl17 ^ bl18 ^ true, "to double, equals");
        boolean bl19 = false;
        if (d8 > (double)l3) {
            bl19 = true;
        }
        boolean bl20 = false;
        if (d8 > d3) {
            bl20 = true;
        }
        this.harness.check(bl19 ^ bl20 ^ true, "to double, equals");
        boolean bl21 = false;
        if ((double)f8 > d3) {
            bl21 = true;
        }
        boolean bl22 = false;
        if (d8 > d3) {
            bl22 = true;
        }
        this.harness.check(bl21 ^ bl22 ^ true, "to double, equals");
        boolean bl23 = false;
        if (d8 > (double)f3) {
            bl23 = true;
        }
        boolean bl24 = false;
        if (d8 > d3) {
            bl24 = true;
        }
        this.harness.check(bl23 ^ bl24 ^ true, "to double, equals");
        boolean bl25 = false;
        if ((float)b8 > f3) {
            bl25 = true;
        }
        boolean bl26 = false;
        if (f8 > f3) {
            bl26 = true;
        }
        this.harness.check(bl25 ^ bl26 ^ true, "to float equals");
        boolean bl27 = false;
        if (f8 > (float)b3) {
            bl27 = true;
        }
        boolean bl28 = false;
        if (f8 > f3) {
            bl28 = true;
        }
        this.harness.check(bl27 ^ bl28 ^ true, "to float equals");
        boolean bl29 = false;
        if ((float)s8 > f3) {
            bl29 = true;
        }
        boolean bl30 = false;
        if (f8 > f3) {
            bl30 = true;
        }
        this.harness.check(bl29 ^ bl30 ^ true, "to float equals");
        boolean bl31 = false;
        if (f8 > (float)s3) {
            bl31 = true;
        }
        boolean bl32 = false;
        if (f8 > f3) {
            bl32 = true;
        }
        this.harness.check(bl31 ^ bl32 ^ true, "to float equals");
        boolean bl33 = false;
        if ((float)c8 > f3) {
            bl33 = true;
        }
        boolean bl34 = false;
        if (f8 > f3) {
            bl34 = true;
        }
        this.harness.check(bl33 ^ bl34 ^ true, "to float equals");
        boolean bl35 = false;
        if (f8 > (float)c3) {
            bl35 = true;
        }
        boolean bl36 = false;
        if (f8 > f3) {
            bl36 = true;
        }
        this.harness.check(bl35 ^ bl36 ^ true, "to float equals");
        boolean bl37 = false;
        if ((float)i8 > f3) {
            bl37 = true;
        }
        boolean bl38 = false;
        if (f8 > f3) {
            bl38 = true;
        }
        this.harness.check(bl37 ^ bl38 ^ true, "to float equals");
        boolean bl39 = false;
        if (f8 > (float)i3) {
            bl39 = true;
        }
        boolean bl40 = false;
        if (f8 > f3) {
            bl40 = true;
        }
        this.harness.check(bl39 ^ bl40 ^ true, "to float equals");
        boolean bl41 = false;
        if ((float)l8 > f3) {
            bl41 = true;
        }
        boolean bl42 = false;
        if (f8 > f3) {
            bl42 = true;
        }
        this.harness.check(bl41 ^ bl42 ^ true, "to float equals");
        boolean bl43 = false;
        if (f8 > (float)l3) {
            bl43 = true;
        }
        boolean bl44 = false;
        if (f8 > f3) {
            bl44 = true;
        }
        this.harness.check(bl43 ^ bl44 ^ true, "to float equals");
        boolean bl45 = false;
        if ((long)b8 > l3) {
            bl45 = true;
        }
        boolean bl46 = false;
        if (l8 > l3) {
            bl46 = true;
        }
        this.harness.check(bl45 ^ bl46 ^ true, "to long, equals");
        boolean bl47 = false;
        if (l8 > (long)b3) {
            bl47 = true;
        }
        boolean bl48 = false;
        if (l8 > l3) {
            bl48 = true;
        }
        this.harness.check(bl47 ^ bl48 ^ true, "to long, equals");
        boolean bl49 = false;
        if ((long)s8 > l3) {
            bl49 = true;
        }
        boolean bl50 = false;
        if (l8 > l3) {
            bl50 = true;
        }
        this.harness.check(bl49 ^ bl50 ^ true, "to long, equals");
        boolean bl51 = false;
        if (l8 > (long)s3) {
            bl51 = true;
        }
        boolean bl52 = false;
        if (l8 > l3) {
            bl52 = true;
        }
        this.harness.check(bl51 ^ bl52 ^ true, "to long, equals");
        boolean bl53 = false;
        if ((long)c8 > l3) {
            bl53 = true;
        }
        boolean bl54 = false;
        if (l8 > l3) {
            bl54 = true;
        }
        this.harness.check(bl53 ^ bl54 ^ true, "to long, equals");
        boolean bl55 = false;
        if (l8 > (long)c3) {
            bl55 = true;
        }
        boolean bl56 = false;
        if (l8 > l3) {
            bl56 = true;
        }
        this.harness.check(bl55 ^ bl56 ^ true, "to long, equals");
        boolean bl57 = false;
        if ((long)i8 > l3) {
            bl57 = true;
        }
        boolean bl58 = false;
        if (l8 > l3) {
            bl58 = true;
        }
        this.harness.check(bl57 ^ bl58 ^ true, "to long, equals");
        boolean bl59 = false;
        if (l8 > (long)i3) {
            bl59 = true;
        }
        boolean bl60 = false;
        if (l8 > l3) {
            bl60 = true;
        }
        this.harness.check(bl59 ^ bl60 ^ true, "to long, equals");
        boolean bl61 = false;
        if (b8 > i3) {
            bl61 = true;
        }
        boolean bl62 = false;
        if (i8 > i3) {
            bl62 = true;
        }
        this.harness.check(bl61 ^ bl62 ^ true, "to int, equals");
        boolean bl63 = false;
        if (i8 > b3) {
            bl63 = true;
        }
        boolean bl64 = false;
        if (i8 > i3) {
            bl64 = true;
        }
        this.harness.check(bl63 ^ bl64 ^ true, "to int, equals");
        boolean bl65 = false;
        if (s8 > i3) {
            bl65 = true;
        }
        boolean bl66 = false;
        if (i8 > i3) {
            bl66 = true;
        }
        this.harness.check(bl65 ^ bl66 ^ true, "to int, equals");
        boolean bl67 = false;
        if (i8 > s3) {
            bl67 = true;
        }
        boolean bl68 = false;
        if (i8 > i3) {
            bl68 = true;
        }
        this.harness.check(bl67 ^ bl68 ^ true, "to int, equals");
        boolean bl69 = false;
        if (c8 > i3) {
            bl69 = true;
        }
        boolean bl70 = false;
        if (i8 > i3) {
            bl70 = true;
        }
        this.harness.check(bl69 ^ bl70 ^ true, "to int, equals");
        boolean bl71 = false;
        if (i8 > c3) {
            bl71 = true;
        }
        boolean bl72 = false;
        if (i8 > i3) {
            bl72 = true;
        }
        this.harness.check(bl71 ^ bl72 ^ true, "to int, equals");
        boolean bl73 = false;
        if (b8 > c3) {
            bl73 = true;
        }
        boolean bl74 = false;
        if (i8 > i3) {
            bl74 = true;
        }
        this.harness.check(bl73 ^ bl74 ^ true, "to int, equals");
        boolean bl75 = false;
        if (c8 > b3) {
            bl75 = true;
        }
        boolean bl76 = false;
        if (i8 > i3) {
            bl76 = true;
        }
        this.harness.check(bl75 ^ bl76 ^ true, "to int, equals");
        boolean bl77 = false;
        if (s8 > c3) {
            bl77 = true;
        }
        boolean bl78 = false;
        if (i8 > i3) {
            bl78 = true;
        }
        this.harness.check(bl77 ^ bl78 ^ true, "to int, equals");
        boolean bl79 = false;
        if (c8 > s3) {
            bl79 = true;
        }
        boolean bl80 = false;
        if (i8 > i3) {
            bl80 = true;
        }
        this.harness.check(bl79 ^ bl80 ^ true, "to int, equals");
        boolean bl81 = false;
        if (b8 > s3) {
            bl81 = true;
        }
        boolean bl82 = false;
        if (i8 > i3) {
            bl82 = true;
        }
        this.harness.check(bl81 ^ bl82 ^ true, "to int, equals");
        boolean bl83 = false;
        if (s8 > b3) {
            bl83 = true;
        }
        boolean bl84 = false;
        if (i8 > i3) {
            bl84 = true;
        }
        this.harness.check(bl83 ^ bl84 ^ true, "to int, equals");
    }

    private final void testPromotionCompareBiggerEquals() {
        int b3 = 3;
        int s3 = 3;
        int c3 = 3;
        int i3 = 3;
        long l3 = 3;
        float f3 = 3;
        double d3 = 3;
        int b8 = 8;
        int s8 = 8;
        int c8 = 8;
        int i8 = 8;
        long l8 = 8L;
        float f8 = 8.0f;
        double d8 = 8.0;
        boolean bl = false;
        if ((double)b8 >= d3) {
            bl = true;
        }
        boolean bl2 = false;
        if (d8 >= d3) {
            bl2 = true;
        }
        this.harness.check(bl ^ bl2 ^ true, "to double, equals");
        boolean bl3 = false;
        if (d8 >= (double)b3) {
            bl3 = true;
        }
        boolean bl4 = false;
        if (d8 >= d3) {
            bl4 = true;
        }
        this.harness.check(bl3 ^ bl4 ^ true, "to double, equals");
        boolean bl5 = false;
        if ((double)s8 >= d3) {
            bl5 = true;
        }
        boolean bl6 = false;
        if (d8 >= d3) {
            bl6 = true;
        }
        this.harness.check(bl5 ^ bl6 ^ true, "to double, equals");
        boolean bl7 = false;
        if (d8 >= (double)s3) {
            bl7 = true;
        }
        boolean bl8 = false;
        if (d8 >= d3) {
            bl8 = true;
        }
        this.harness.check(bl7 ^ bl8 ^ true, "to double, equals");
        boolean bl9 = false;
        if ((double)c8 >= d3) {
            bl9 = true;
        }
        boolean bl10 = false;
        if (d8 >= d3) {
            bl10 = true;
        }
        this.harness.check(bl9 ^ bl10 ^ true, "to double, equals");
        boolean bl11 = false;
        if (d8 >= (double)c3) {
            bl11 = true;
        }
        boolean bl12 = false;
        if (d8 >= d3) {
            bl12 = true;
        }
        this.harness.check(bl11 ^ bl12 ^ true, "to double, equals");
        boolean bl13 = false;
        if ((double)i8 >= d3) {
            bl13 = true;
        }
        boolean bl14 = false;
        if (d8 >= d3) {
            bl14 = true;
        }
        this.harness.check(bl13 ^ bl14 ^ true, "to double, equals");
        boolean bl15 = false;
        if (d8 >= (double)i3) {
            bl15 = true;
        }
        boolean bl16 = false;
        if (d8 >= d3) {
            bl16 = true;
        }
        this.harness.check(bl15 ^ bl16 ^ true, "to double, equals");
        boolean bl17 = false;
        if ((double)l8 >= d3) {
            bl17 = true;
        }
        boolean bl18 = false;
        if (d8 >= d3) {
            bl18 = true;
        }
        this.harness.check(bl17 ^ bl18 ^ true, "to double, equals");
        boolean bl19 = false;
        if (d8 >= (double)l3) {
            bl19 = true;
        }
        boolean bl20 = false;
        if (d8 >= d3) {
            bl20 = true;
        }
        this.harness.check(bl19 ^ bl20 ^ true, "to double, equals");
        boolean bl21 = false;
        if ((double)f8 >= d3) {
            bl21 = true;
        }
        boolean bl22 = false;
        if (d8 >= d3) {
            bl22 = true;
        }
        this.harness.check(bl21 ^ bl22 ^ true, "to double, equals");
        boolean bl23 = false;
        if (d8 >= (double)f3) {
            bl23 = true;
        }
        boolean bl24 = false;
        if (d8 >= d3) {
            bl24 = true;
        }
        this.harness.check(bl23 ^ bl24 ^ true, "to double, equals");
        boolean bl25 = false;
        if ((float)b8 >= f3) {
            bl25 = true;
        }
        boolean bl26 = false;
        if (f8 >= f3) {
            bl26 = true;
        }
        this.harness.check(bl25 ^ bl26 ^ true, "to float equals");
        boolean bl27 = false;
        if (f8 >= (float)b3) {
            bl27 = true;
        }
        boolean bl28 = false;
        if (f8 >= f3) {
            bl28 = true;
        }
        this.harness.check(bl27 ^ bl28 ^ true, "to float equals");
        boolean bl29 = false;
        if ((float)s8 >= f3) {
            bl29 = true;
        }
        boolean bl30 = false;
        if (f8 >= f3) {
            bl30 = true;
        }
        this.harness.check(bl29 ^ bl30 ^ true, "to float equals");
        boolean bl31 = false;
        if (f8 >= (float)s3) {
            bl31 = true;
        }
        boolean bl32 = false;
        if (f8 >= f3) {
            bl32 = true;
        }
        this.harness.check(bl31 ^ bl32 ^ true, "to float equals");
        boolean bl33 = false;
        if ((float)c8 >= f3) {
            bl33 = true;
        }
        boolean bl34 = false;
        if (f8 >= f3) {
            bl34 = true;
        }
        this.harness.check(bl33 ^ bl34 ^ true, "to float equals");
        boolean bl35 = false;
        if (f8 >= (float)c3) {
            bl35 = true;
        }
        boolean bl36 = false;
        if (f8 >= f3) {
            bl36 = true;
        }
        this.harness.check(bl35 ^ bl36 ^ true, "to float equals");
        boolean bl37 = false;
        if ((float)i8 >= f3) {
            bl37 = true;
        }
        boolean bl38 = false;
        if (f8 >= f3) {
            bl38 = true;
        }
        this.harness.check(bl37 ^ bl38 ^ true, "to float equals");
        boolean bl39 = false;
        if (f8 >= (float)i3) {
            bl39 = true;
        }
        boolean bl40 = false;
        if (f8 >= f3) {
            bl40 = true;
        }
        this.harness.check(bl39 ^ bl40 ^ true, "to float equals");
        boolean bl41 = false;
        if ((float)l8 >= f3) {
            bl41 = true;
        }
        boolean bl42 = false;
        if (f8 >= f3) {
            bl42 = true;
        }
        this.harness.check(bl41 ^ bl42 ^ true, "to float equals");
        boolean bl43 = false;
        if (f8 >= (float)l3) {
            bl43 = true;
        }
        boolean bl44 = false;
        if (f8 >= f3) {
            bl44 = true;
        }
        this.harness.check(bl43 ^ bl44 ^ true, "to float equals");
        boolean bl45 = false;
        if ((long)b8 >= l3) {
            bl45 = true;
        }
        boolean bl46 = false;
        if (l8 >= l3) {
            bl46 = true;
        }
        this.harness.check(bl45 ^ bl46 ^ true, "to long, equals");
        boolean bl47 = false;
        if (l8 >= (long)b3) {
            bl47 = true;
        }
        boolean bl48 = false;
        if (l8 >= l3) {
            bl48 = true;
        }
        this.harness.check(bl47 ^ bl48 ^ true, "to long, equals");
        boolean bl49 = false;
        if ((long)s8 >= l3) {
            bl49 = true;
        }
        boolean bl50 = false;
        if (l8 >= l3) {
            bl50 = true;
        }
        this.harness.check(bl49 ^ bl50 ^ true, "to long, equals");
        boolean bl51 = false;
        if (l8 >= (long)s3) {
            bl51 = true;
        }
        boolean bl52 = false;
        if (l8 >= l3) {
            bl52 = true;
        }
        this.harness.check(bl51 ^ bl52 ^ true, "to long, equals");
        boolean bl53 = false;
        if ((long)c8 >= l3) {
            bl53 = true;
        }
        boolean bl54 = false;
        if (l8 >= l3) {
            bl54 = true;
        }
        this.harness.check(bl53 ^ bl54 ^ true, "to long, equals");
        boolean bl55 = false;
        if (l8 >= (long)c3) {
            bl55 = true;
        }
        boolean bl56 = false;
        if (l8 >= l3) {
            bl56 = true;
        }
        this.harness.check(bl55 ^ bl56 ^ true, "to long, equals");
        boolean bl57 = false;
        if ((long)i8 >= l3) {
            bl57 = true;
        }
        boolean bl58 = false;
        if (l8 >= l3) {
            bl58 = true;
        }
        this.harness.check(bl57 ^ bl58 ^ true, "to long, equals");
        boolean bl59 = false;
        if (l8 >= (long)i3) {
            bl59 = true;
        }
        boolean bl60 = false;
        if (l8 >= l3) {
            bl60 = true;
        }
        this.harness.check(bl59 ^ bl60 ^ true, "to long, equals");
        boolean bl61 = false;
        if (b8 >= i3) {
            bl61 = true;
        }
        boolean bl62 = false;
        if (i8 >= i3) {
            bl62 = true;
        }
        this.harness.check(bl61 ^ bl62 ^ true, "to int, equals");
        boolean bl63 = false;
        if (i8 >= b3) {
            bl63 = true;
        }
        boolean bl64 = false;
        if (i8 >= i3) {
            bl64 = true;
        }
        this.harness.check(bl63 ^ bl64 ^ true, "to int, equals");
        boolean bl65 = false;
        if (s8 >= i3) {
            bl65 = true;
        }
        boolean bl66 = false;
        if (i8 >= i3) {
            bl66 = true;
        }
        this.harness.check(bl65 ^ bl66 ^ true, "to int, equals");
        boolean bl67 = false;
        if (i8 >= s3) {
            bl67 = true;
        }
        boolean bl68 = false;
        if (i8 >= i3) {
            bl68 = true;
        }
        this.harness.check(bl67 ^ bl68 ^ true, "to int, equals");
        boolean bl69 = false;
        if (c8 >= i3) {
            bl69 = true;
        }
        boolean bl70 = false;
        if (i8 >= i3) {
            bl70 = true;
        }
        this.harness.check(bl69 ^ bl70 ^ true, "to int, equals");
        boolean bl71 = false;
        if (i8 >= c3) {
            bl71 = true;
        }
        boolean bl72 = false;
        if (i8 >= i3) {
            bl72 = true;
        }
        this.harness.check(bl71 ^ bl72 ^ true, "to int, equals");
        boolean bl73 = false;
        if (b8 >= c3) {
            bl73 = true;
        }
        boolean bl74 = false;
        if (i8 >= i3) {
            bl74 = true;
        }
        this.harness.check(bl73 ^ bl74 ^ true, "to int, equals");
        boolean bl75 = false;
        if (c8 >= b3) {
            bl75 = true;
        }
        boolean bl76 = false;
        if (i8 >= i3) {
            bl76 = true;
        }
        this.harness.check(bl75 ^ bl76 ^ true, "to int, equals");
        boolean bl77 = false;
        if (s8 >= c3) {
            bl77 = true;
        }
        boolean bl78 = false;
        if (i8 >= i3) {
            bl78 = true;
        }
        this.harness.check(bl77 ^ bl78 ^ true, "to int, equals");
        boolean bl79 = false;
        if (c8 >= s3) {
            bl79 = true;
        }
        boolean bl80 = false;
        if (i8 >= i3) {
            bl80 = true;
        }
        this.harness.check(bl79 ^ bl80 ^ true, "to int, equals");
        boolean bl81 = false;
        if (b8 >= s3) {
            bl81 = true;
        }
        boolean bl82 = false;
        if (i8 >= i3) {
            bl82 = true;
        }
        this.harness.check(bl81 ^ bl82 ^ true, "to int, equals");
        boolean bl83 = false;
        if (s8 >= b3) {
            bl83 = true;
        }
        boolean bl84 = false;
        if (i8 >= i3) {
            bl84 = true;
        }
        this.harness.check(bl83 ^ bl84 ^ true, "to int, equals");
    }

    public void testPromotionConditionalOperator() {
        byte b3 = 3;
        short s3 = 3;
        char c3 = '\u0003';
        int i3 = 3;
        long l3 = 3;
        float f3 = 3;
        double d3 = 3;
        byte b8 = 8;
        short s8 = 8;
        char c8 = '\b';
        int i8 = 8;
        long l8 = 8L;
        float f8 = 8.0f;
        double d8 = 8.0;
        boolean bl = false;
        if (this.getType(d3) == 'D') {
            bl = true;
        }
        this.harness.check(bl, "result should be double");
        boolean bl2 = false;
        if (this.getType(d8) == 'D') {
            bl2 = true;
        }
        this.harness.check(bl2, "result should be double");
        boolean bl3 = false;
        if (this.getType(f3) == 'F') {
            bl3 = true;
        }
        this.harness.check(bl3, "result should be float");
        boolean bl4 = false;
        if (this.getType(f8) == 'F') {
            bl4 = true;
        }
        this.harness.check(bl4, "result should be float");
        boolean bl5 = false;
        if (this.getType(l3) == 'L') {
            bl5 = true;
        }
        this.harness.check(bl5, "result should be long");
        boolean bl6 = false;
        if (this.getType(l8) == 'L') {
            bl6 = true;
        }
        this.harness.check(bl6, "result should be long");
        boolean bl7 = false;
        if (this.getType(i3) == 'I') {
            bl7 = true;
        }
        this.harness.check(bl7, "result should be int");
        boolean bl8 = false;
        if (this.getType(i8) == 'I') {
            bl8 = true;
        }
        this.harness.check(bl8, "result should be int");
        boolean bl9 = false;
        if (this.getType(c3) == 'C') {
            bl9 = true;
        }
        this.harness.check(bl9, "result should be char");
        boolean bl10 = false;
        if (this.getType(c8) == 'C') {
            bl10 = true;
        }
        this.harness.check(bl10, "result should be char");
        boolean bl11 = false;
        if (this.getType(s3) == 'S') {
            bl11 = true;
        }
        this.harness.check(bl11, "result should be short");
        boolean bl12 = false;
        if (this.getType(s8) == 'S') {
            bl12 = true;
        }
        this.harness.check(bl12, "result should be short");
        boolean bl13 = false;
        if (this.getType(b3) == 'B') {
            bl13 = true;
        }
        this.harness.check(bl13, "result should be byte");
        boolean bl14 = false;
        if (this.getType(b8) == 'B') {
            bl14 = true;
        }
        this.harness.check(bl14, "result should be byte");
        boolean bl15 = false;
        if (this.getType((short)b3) == 'S') {
            bl15 = true;
        }
        this.harness.check(bl15, "result should be short");
        boolean bl16 = false;
        if (this.getType(s8) == 'S') {
            bl16 = true;
        }
        this.harness.check(bl16, "result should be short");
        boolean bl17 = false;
        if (this.getType(s3) == 'S') {
            bl17 = true;
        }
        this.harness.check(bl17, "result should be short");
        boolean bl18 = false;
        if (this.getType((short)b8) == 'S') {
            bl18 = true;
        }
        this.harness.check(bl18, "result should be short");
        boolean bl19 = false;
        if (this.getType((int)b3) == 'I') {
            bl19 = true;
        }
        this.harness.check(bl19, "result should be int");
        boolean bl20 = false;
        if (this.getType((int)c8) == 'I') {
            bl20 = true;
        }
        this.harness.check(bl20, "result should be int");
        boolean bl21 = false;
        if (this.getType((int)c3) == 'I') {
            bl21 = true;
        }
        this.harness.check(bl21, "result should be int");
        boolean bl22 = false;
        if (this.getType((int)b8) == 'I') {
            bl22 = true;
        }
        this.harness.check(bl22, "result should be int");
        boolean bl23 = false;
        if (this.getType((int)b3) == 'I') {
            bl23 = true;
        }
        this.harness.check(bl23, "result should be int");
        boolean bl24 = false;
        if (this.getType(i8) == 'I') {
            bl24 = true;
        }
        this.harness.check(bl24, "result should be int");
        boolean bl25 = false;
        if (this.getType(i3) == 'I') {
            bl25 = true;
        }
        this.harness.check(bl25, "result should be int");
        boolean bl26 = false;
        if (this.getType((int)b8) == 'I') {
            bl26 = true;
        }
        this.harness.check(bl26, "result should be int");
        boolean bl27 = false;
        if (this.getType((int)s3) == 'I') {
            bl27 = true;
        }
        this.harness.check(bl27, "result should be int");
        boolean bl28 = false;
        if (this.getType((int)c8) == 'I') {
            bl28 = true;
        }
        this.harness.check(bl28, "result should be int");
        boolean bl29 = false;
        if (this.getType((int)c3) == 'I') {
            bl29 = true;
        }
        this.harness.check(bl29, "result should be int");
        boolean bl30 = false;
        if (this.getType((int)s8) == 'I') {
            bl30 = true;
        }
        this.harness.check(bl30, "result should be int");
        boolean bl31 = false;
        if (this.getType((int)s3) == 'I') {
            bl31 = true;
        }
        this.harness.check(bl31, "result should be int");
        boolean bl32 = false;
        if (this.getType(i8) == 'I') {
            bl32 = true;
        }
        this.harness.check(bl32, "result should be int");
        boolean bl33 = false;
        if (this.getType(i3) == 'I') {
            bl33 = true;
        }
        this.harness.check(bl33, "result should be int");
        boolean bl34 = false;
        if (this.getType((int)s8) == 'I') {
            bl34 = true;
        }
        this.harness.check(bl34, "result should be int");
        boolean bl35 = false;
        if (this.getType((int)c3) == 'I') {
            bl35 = true;
        }
        this.harness.check(bl35, "result should be int");
        boolean bl36 = false;
        if (this.getType(i8) == 'I') {
            bl36 = true;
        }
        this.harness.check(bl36, "result should be int");
        boolean bl37 = false;
        if (this.getType(i3) == 'I') {
            bl37 = true;
        }
        this.harness.check(bl37, "result should be int");
        boolean bl38 = false;
        if (this.getType((int)c8) == 'I') {
            bl38 = true;
        }
        this.harness.check(bl38, "result should be int");
        boolean bl39 = false;
        if (this.getType((long)b3) == 'L') {
            bl39 = true;
        }
        this.harness.check(bl39, "result should be long");
        boolean bl40 = false;
        if (this.getType(l8) == 'L') {
            bl40 = true;
        }
        this.harness.check(bl40, "result should be long");
        boolean bl41 = false;
        if (this.getType(l3) == 'L') {
            bl41 = true;
        }
        this.harness.check(bl41, "result should be long");
        boolean bl42 = false;
        if (this.getType((long)b8) == 'L') {
            bl42 = true;
        }
        this.harness.check(bl42, "result should be long");
        boolean bl43 = false;
        if (this.getType((long)s3) == 'L') {
            bl43 = true;
        }
        this.harness.check(bl43, "result should be long");
        boolean bl44 = false;
        if (this.getType(l8) == 'L') {
            bl44 = true;
        }
        this.harness.check(bl44, "result should be long");
        boolean bl45 = false;
        if (this.getType(l3) == 'L') {
            bl45 = true;
        }
        this.harness.check(bl45, "result should be long");
        boolean bl46 = false;
        if (this.getType((long)s8) == 'L') {
            bl46 = true;
        }
        this.harness.check(bl46, "result should be long");
        boolean bl47 = false;
        if (this.getType((long)c3) == 'L') {
            bl47 = true;
        }
        this.harness.check(bl47, "result should be long");
        boolean bl48 = false;
        if (this.getType(l8) == 'L') {
            bl48 = true;
        }
        this.harness.check(bl48, "result should be long");
        boolean bl49 = false;
        if (this.getType(l3) == 'L') {
            bl49 = true;
        }
        this.harness.check(bl49, "result should be long");
        boolean bl50 = false;
        if (this.getType((long)c8) == 'L') {
            bl50 = true;
        }
        this.harness.check(bl50, "result should be long");
        boolean bl51 = false;
        if (this.getType((long)i3) == 'L') {
            bl51 = true;
        }
        this.harness.check(bl51, "result should be long");
        boolean bl52 = false;
        if (this.getType(l8) == 'L') {
            bl52 = true;
        }
        this.harness.check(bl52, "result should be long");
        boolean bl53 = false;
        if (this.getType(l3) == 'L') {
            bl53 = true;
        }
        this.harness.check(bl53, "result should be long");
        boolean bl54 = false;
        if (this.getType((long)i8) == 'L') {
            bl54 = true;
        }
        this.harness.check(bl54, "result should be long");
        boolean bl55 = false;
        if (this.getType((float)b3) == 'F') {
            bl55 = true;
        }
        this.harness.check(bl55, "result should be float");
        boolean bl56 = false;
        if (this.getType(f8) == 'F') {
            bl56 = true;
        }
        this.harness.check(bl56, "result should be float");
        boolean bl57 = false;
        if (this.getType(f3) == 'F') {
            bl57 = true;
        }
        this.harness.check(bl57, "result should be float");
        boolean bl58 = false;
        if (this.getType((float)b8) == 'F') {
            bl58 = true;
        }
        this.harness.check(bl58, "result should be float");
        boolean bl59 = false;
        if (this.getType((float)s3) == 'F') {
            bl59 = true;
        }
        this.harness.check(bl59, "result should be float");
        boolean bl60 = false;
        if (this.getType(f8) == 'F') {
            bl60 = true;
        }
        this.harness.check(bl60, "result should be float");
        boolean bl61 = false;
        if (this.getType(f3) == 'F') {
            bl61 = true;
        }
        this.harness.check(bl61, "result should be float");
        boolean bl62 = false;
        if (this.getType((float)s8) == 'F') {
            bl62 = true;
        }
        this.harness.check(bl62, "result should be float");
        boolean bl63 = false;
        if (this.getType((float)c3) == 'F') {
            bl63 = true;
        }
        this.harness.check(bl63, "result should be float");
        boolean bl64 = false;
        if (this.getType(f8) == 'F') {
            bl64 = true;
        }
        this.harness.check(bl64, "result should be float");
        boolean bl65 = false;
        if (this.getType(f3) == 'F') {
            bl65 = true;
        }
        this.harness.check(bl65, "result should be float");
        boolean bl66 = false;
        if (this.getType((float)c8) == 'F') {
            bl66 = true;
        }
        this.harness.check(bl66, "result should be float");
        boolean bl67 = false;
        if (this.getType((float)i3) == 'F') {
            bl67 = true;
        }
        this.harness.check(bl67, "result should be float");
        boolean bl68 = false;
        if (this.getType(f8) == 'F') {
            bl68 = true;
        }
        this.harness.check(bl68, "result should be float");
        boolean bl69 = false;
        if (this.getType(f3) == 'F') {
            bl69 = true;
        }
        this.harness.check(bl69, "result should be float");
        boolean bl70 = false;
        if (this.getType((float)i8) == 'F') {
            bl70 = true;
        }
        this.harness.check(bl70, "result should be float");
        boolean bl71 = false;
        if (this.getType((float)l3) == 'F') {
            bl71 = true;
        }
        this.harness.check(bl71, "result should be float");
        boolean bl72 = false;
        if (this.getType(f8) == 'F') {
            bl72 = true;
        }
        this.harness.check(bl72, "result should be float");
        boolean bl73 = false;
        if (this.getType(f3) == 'F') {
            bl73 = true;
        }
        this.harness.check(bl73, "result should be float");
        boolean bl74 = false;
        if (this.getType((float)l8) == 'F') {
            bl74 = true;
        }
        this.harness.check(bl74, "result should be float");
        boolean bl75 = false;
        if (this.getType((double)b3) == 'D') {
            bl75 = true;
        }
        this.harness.check(bl75, "result should be double");
        boolean bl76 = false;
        if (this.getType(d8) == 'D') {
            bl76 = true;
        }
        this.harness.check(bl76, "result should be double");
        boolean bl77 = false;
        if (this.getType(d3) == 'D') {
            bl77 = true;
        }
        this.harness.check(bl77, "result should be double");
        boolean bl78 = false;
        if (this.getType((double)b8) == 'D') {
            bl78 = true;
        }
        this.harness.check(bl78, "result should be double");
        boolean bl79 = false;
        if (this.getType((double)s3) == 'D') {
            bl79 = true;
        }
        this.harness.check(bl79, "result should be double");
        boolean bl80 = false;
        if (this.getType(d8) == 'D') {
            bl80 = true;
        }
        this.harness.check(bl80, "result should be double");
        boolean bl81 = false;
        if (this.getType(d3) == 'D') {
            bl81 = true;
        }
        this.harness.check(bl81, "result should be double");
        boolean bl82 = false;
        if (this.getType((double)s8) == 'D') {
            bl82 = true;
        }
        this.harness.check(bl82, "result should be double");
        boolean bl83 = false;
        if (this.getType((double)c3) == 'D') {
            bl83 = true;
        }
        this.harness.check(bl83, "result should be double");
        boolean bl84 = false;
        if (this.getType(d8) == 'D') {
            bl84 = true;
        }
        this.harness.check(bl84, "result should be double");
        boolean bl85 = false;
        if (this.getType(d3) == 'D') {
            bl85 = true;
        }
        this.harness.check(bl85, "result should be double");
        boolean bl86 = false;
        if (this.getType((double)c8) == 'D') {
            bl86 = true;
        }
        this.harness.check(bl86, "result should be double");
        boolean bl87 = false;
        if (this.getType((double)i3) == 'D') {
            bl87 = true;
        }
        this.harness.check(bl87, "result should be double");
        boolean bl88 = false;
        if (this.getType(d8) == 'D') {
            bl88 = true;
        }
        this.harness.check(bl88, "result should be double");
        boolean bl89 = false;
        if (this.getType(d3) == 'D') {
            bl89 = true;
        }
        this.harness.check(bl89, "result should be double");
        boolean bl90 = false;
        if (this.getType((double)i8) == 'D') {
            bl90 = true;
        }
        this.harness.check(bl90, "result should be double");
        boolean bl91 = false;
        if (this.getType((double)l3) == 'D') {
            bl91 = true;
        }
        this.harness.check(bl91, "result should be double");
        boolean bl92 = false;
        if (this.getType(d8) == 'D') {
            bl92 = true;
        }
        this.harness.check(bl92, "result should be double");
        boolean bl93 = false;
        if (this.getType(d3) == 'D') {
            bl93 = true;
        }
        this.harness.check(bl93, "result should be double");
        boolean bl94 = false;
        if (this.getType((double)l8) == 'D') {
            bl94 = true;
        }
        this.harness.check(bl94, "result should be double");
        boolean bl95 = false;
        if (this.getType((double)f3) == 'D') {
            bl95 = true;
        }
        this.harness.check(bl95, "result should be double");
        boolean bl96 = false;
        if (this.getType(d8) == 'D') {
            bl96 = true;
        }
        this.harness.check(bl96, "result should be double");
        boolean bl97 = false;
        if (this.getType(d3) == 'D') {
            bl97 = true;
        }
        this.harness.check(bl97, "result should be double");
        boolean bl98 = false;
        if (this.getType((double)f8) == 'D') {
            bl98 = true;
        }
        this.harness.check(bl98, "result should be double");
        boolean bl99 = false;
        if (this.getType(b3) == 'B') {
            bl99 = true;
        }
        this.harness.check(bl99, "result should be byte");
        boolean bl100 = false;
        if (this.getType((byte)127) == 'B') {
            bl100 = true;
        }
        this.harness.check(bl100, "result should be byte");
        boolean bl101 = false;
        if (this.getType((byte)127) == 'B') {
            bl101 = true;
        }
        this.harness.check(bl101, "result should be byte");
        boolean bl102 = false;
        if (this.getType(b8) == 'B') {
            bl102 = true;
        }
        this.harness.check(bl102, "result should be byte");
        boolean bl103 = false;
        if (this.getType((int)b3) == 'I') {
            bl103 = true;
        }
        this.harness.check(bl103, "result should be int");
        boolean bl104 = false;
        if (this.getType((int)Short.MAX_VALUE) == 'I') {
            bl104 = true;
        }
        this.harness.check(bl104, "result should be int");
        boolean bl105 = false;
        if (this.getType((int)Short.MAX_VALUE) == 'I') {
            bl105 = true;
        }
        this.harness.check(bl105, "result should be int");
        boolean bl106 = false;
        if (this.getType((int)b8) == 'I') {
            bl106 = true;
        }
        this.harness.check(bl106, "result should be int");
        boolean bl107 = false;
        if (this.getType(s3) == 'S') {
            bl107 = true;
        }
        this.harness.check(bl107, "result should be short");
        boolean bl108 = false;
        if (this.getType((short)Short.MAX_VALUE) == 'S') {
            bl108 = true;
        }
        this.harness.check(bl108, "result should be short");
        boolean bl109 = false;
        if (this.getType((short)Short.MAX_VALUE) == 'S') {
            bl109 = true;
        }
        this.harness.check(bl109, "result should be short");
        boolean bl110 = false;
        if (this.getType(s8) == 'S') {
            bl110 = true;
        }
        this.harness.check(bl110, "result should be short");
        boolean bl111 = false;
        if (this.getType((int)s3) == 'I') {
            bl111 = true;
        }
        this.harness.check(bl111, "result should be int");
        boolean bl112 = false;
        if (this.getType((int)((char)-1)) == 'I') {
            bl112 = true;
        }
        this.harness.check(bl112, "result should be int");
        boolean bl113 = false;
        if (this.getType((int)((char)-1)) == 'I') {
            bl113 = true;
        }
        this.harness.check(bl113, "result should be int");
        boolean bl114 = false;
        if (this.getType((int)s8) == 'I') {
            bl114 = true;
        }
        this.harness.check(bl114, "result should be int");
        boolean bl115 = false;
        if (this.getType(c3) == 'C') {
            bl115 = true;
        }
        this.harness.check(bl115, "result should be char");
        boolean bl116 = false;
        if (this.getType((char)-1) == 'C') {
            bl116 = true;
        }
        this.harness.check(bl116, "result should be char");
        boolean bl117 = false;
        if (this.getType((char)-1) == 'C') {
            bl117 = true;
        }
        this.harness.check(bl117, "result should be char");
        boolean bl118 = false;
        if (this.getType(c8) == 'C') {
            bl118 = true;
        }
        this.harness.check(bl118, "result should be char");
        boolean bl119 = false;
        if (this.getType((int)c3) == 'I') {
            bl119 = true;
        }
        this.harness.check(bl119, "result should be int");
        boolean bl120 = false;
        if (this.getType(-128) == 'I') {
            bl120 = true;
        }
        this.harness.check(bl120, "result should be int");
        boolean bl121 = false;
        if (this.getType(-128) == 'I') {
            bl121 = true;
        }
        this.harness.check(bl121, "result should be int");
        boolean bl122 = false;
        if (this.getType((int)c8) == 'I') {
            bl122 = true;
        }
        this.harness.check(bl122, "result should be int");
    }

    private final boolean inRange(float base, int exponent, float tocheck) {
        float min;
        int i;
        float ex = 1.0f;
        if (exponent > 0) {
            i = 0;
            while (i < exponent) {
                ex *= 10.0f;
                ++i;
            }
        }
        if (exponent < 0) {
            i = 0;
            while (i > exponent) {
                ex /= 10.0f;
                --i;
            }
        }
        if ((min = (base - 1.0E-4f) * ex) > tocheck) {
            return false;
        }
        float max = (base + 1.0E-4f) * ex;
        return !(max < tocheck);
    }

    private final boolean inRange(double base, int exponent, double tocheck) {
        double min;
        int i;
        double ex = 1.0;
        if (exponent > 0) {
            i = 0;
            while (i < exponent) {
                ex *= 10.0;
                ++i;
            }
        }
        if (exponent < 0) {
            i = 0;
            while (i > exponent) {
                ex /= 10.0;
                --i;
            }
        }
        if ((min = (base - 1.0E-7) * ex) > tocheck) {
            return false;
        }
        double max = (base + 1.0E-7) * ex;
        return !(max < tocheck);
    }

    public void test(TestHarness newharness) {
        this.harness = newharness;
        this.harness.setclass("java.lang: conversion and casting primitives");
        this.testAssignmentWidening();
        this.testAssignmentNarrowing();
        this.testInvocationWidening();
        this.testCastingWidening();
        this.testCastingNarrowing();
        this.testStringConversion();
        this.testPromotionUnary();
        this.testPromotionBinary();
    }
}

