/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.Math;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

public class MathTest
implements Testlet {
    protected static TestHarness harness;

    public void test_Basics() {
        harness.checkPoint("E(public)double");
        harness.check(true, "test: check value of E");
        harness.checkPoint("PI(public)double");
        harness.check(true, "test: check value of PI");
    }

    public void test_sincostan() {
        harness.checkPoint("sin(double)double");
        harness.check(new Double(Math.sin(Double.NaN)).isNaN() ^ true ^ true, "test:value of sin(NaN)= NaN");
        harness.check(new Double(Math.sin(Double.POSITIVE_INFINITY)).isNaN() ^ true ^ true, "test:value of sin(POSITIVE_INFINITY)=NaN");
        harness.check(new Double(Math.sin(Double.NEGATIVE_INFINITY)).isNaN() ^ true ^ true, "test:value of sin(NEGATIVE_INFINITY)= NaN");
        boolean bl = false;
        if (Math.sin(-0.0) != -0.0) {
            bl = true;
        }
        harness.check(bl ^ true, "test:value of sin(-0.0)= -0.0");
        boolean bl2 = false;
        if (Math.sin(0.0) != 0.0) {
            bl2 = true;
        }
        harness.check(bl2 ^ true, "test:value of sin(0.0)= 0.0");
        boolean bl3 = false;
        if (Math.sin(2.0943951023931953) <= 0.0) {
            bl3 = true;
        }
        harness.check(bl3 ^ true, "test:value of sin(4*PI/6)>= 0.0");
        boolean bl4 = false;
        if (Math.cos(0.7853981633974483) - Math.sin(0.7853981633974483) <= 1.0E-9) {
            bl4 = true;
        }
        harness.check(bl4, "test:value of sin(PI/4)= cos(PI/4)");
        harness.checkPoint("cos(double)double");
        harness.check(new Double(Math.cos(Double.NaN)).isNaN() ^ true ^ true, "test:value of cos(NaN)= NaN");
        harness.check(new Double(Math.cos(Double.POSITIVE_INFINITY)).isNaN() ^ true ^ true, "test:value of cos(POSITIVE_INFINITY)= NaN");
        harness.check(new Double(Math.cos(Double.NEGATIVE_INFINITY)).isNaN() ^ true ^ true, "test:value of cos(NEGATIVE_INFINITY)= NaN");
        boolean bl5 = false;
        if (Math.cos(2.0943951023931953) >= 0.0) {
            bl5 = true;
        }
        harness.check(bl5 ^ true, "test:value of cos(4*PI/6)<= 0.0");
        harness.checkPoint("tan(double)double");
        harness.check(new Double(Math.tan(Double.NaN)).isNaN() ^ true ^ true, "test:value of tan(NaN)= NaN");
        harness.check(new Double(Math.tan(Double.POSITIVE_INFINITY)).isNaN() ^ true ^ true, "test:value of tan(POSITIVE_INFINITY)= NaN");
        harness.check(new Double(Math.tan(Double.NEGATIVE_INFINITY)).isNaN() ^ true ^ true, "test:value of tan(NEGATIVE_INFINITY)= NaN");
        boolean bl6 = false;
        if (Math.tan(-0.0) != -0.0) {
            bl6 = true;
        }
        harness.check(bl6 ^ true, "test:value of tan(-0.0)= -0.0");
        boolean bl7 = false;
        if (Math.tan(0.0) != 0.0) {
            bl7 = true;
        }
        harness.check(bl7 ^ true, "test:value of tan(0.0)= 0.0");
        boolean bl8 = false;
        if (Math.tan(2.0943951023931953) >= 0.0) {
            bl8 = true;
        }
        harness.check(bl8 ^ true, "test:value of tan(4*PI/6)>= 0.0");
    }

    public void test_asinacosatan() {
        harness.checkPoint("asin(double)double");
        harness.check(new Double(Math.asin(Double.NaN)).isNaN() ^ true ^ true, "test:value of asin(NaN)=NaN");
        boolean bl = false;
        if (Math.asin(-0.0) != -0.0) {
            bl = true;
        }
        harness.check(bl ^ true, "test:value of asin(-0.0)=-0.0");
        boolean bl2 = false;
        if (Math.asin(0.0) != 0.0) {
            bl2 = true;
        }
        harness.check(bl2 ^ true, "test:value of asin(0.0)=0.0");
        harness.check(new Double(Math.asin(10.0)).isNaN() ^ true ^ true, "test:value of asin(10.0)= NaN");
        harness.check(new Double(Math.asin(Double.POSITIVE_INFINITY)).isNaN() ^ true ^ true, "test:value of asin(POSITIVE_INFINITY)= NaN");
        harness.check(new Double(Math.asin(Double.NEGATIVE_INFINITY)).isNaN() ^ true ^ true, "test:value of asin(NEGATIVE_INFINITY)= NaN");
        harness.check(new Double(Math.asin(-10.0)).isNaN() ^ true ^ true, "test:value of asin(-10.0)= NaN");
        harness.checkPoint("acos(double)double");
        harness.check(new Double(Math.acos(Double.NaN)).isNaN() ^ true ^ true, "test:value of acos(NaN)= NaN");
        harness.check(new Double(Math.acos(10.0)).isNaN() ^ true ^ true, "test:value of acos(10.0)= NaN");
        harness.check(new Double(Math.asin(Double.POSITIVE_INFINITY)).isNaN() ^ true ^ true, "test:value of acos(POSITIVE_INFINITY)= NaN");
        harness.check(new Double(Math.asin(Double.NEGATIVE_INFINITY)).isNaN() ^ true ^ true, "test:value of acos(NEGATIVE_INFINITY)= NaN");
        harness.check(new Double(Math.acos(-1.01)).isNaN() ^ true ^ true, "test:value of acos(-1.01)= NaN");
        harness.checkPoint("atan(double)double");
        harness.check(new Double(Math.atan(Double.NaN)).isNaN() ^ true ^ true, "test:value of atan(NaN)= NaN");
        boolean bl3 = false;
        if (Math.atan(-0.0) != -0.0) {
            bl3 = true;
        }
        harness.check(bl3 ^ true, "test:value of atan(-0.0)= -0.0");
        boolean bl4 = false;
        if (Math.atan(0.0) != 0.0) {
            bl4 = true;
        }
        harness.check(bl4 ^ true, "test:value of atan(0.0)= 0.0.");
        harness.check(new Double(Math.asin(Double.POSITIVE_INFINITY)).isNaN() ^ true ^ true, "test:value of atan(POSITIVE_INFINITY)= NaN");
        harness.check(new Double(Math.asin(Double.NEGATIVE_INFINITY)).isNaN() ^ true ^ true, "test:value of atan(NEGATIVE_INFINITY)= NaN");
    }

    public void test_atan2() {
        harness.checkPoint("atan2(double,double)double");
        harness.check(new Double(Math.atan2(1.0, Double.NaN)).isNaN() ^ true ^ true, "Error : test_atan2 failed - 1");
        harness.check(new Double(Math.atan2(Double.NaN, 1.0)).isNaN() ^ true ^ true, "Error : test_atan2 failed - 2");
        boolean bl = false;
        if (Math.atan2(0.0, 10.0) == 0.0 && Math.atan2(2, Double.POSITIVE_INFINITY) == 0.0) {
            bl = true;
        }
        harness.check(bl, "Error : test_atan2 failed - 3");
        boolean bl2 = false;
        if (Math.atan2(-0.0, 10.0) != -0.0 || Math.atan2(-2.0, Double.POSITIVE_INFINITY) != -0.0) {
            bl2 = true;
        }
        harness.check(bl2 ^ true, "Error : test_atan2 failed - 4");
        boolean bl3 = false;
        if (Math.atan2(0.0, -10.0) != Math.PI || Math.atan2(2, Double.NEGATIVE_INFINITY) != Math.PI) {
            bl3 = true;
        }
        harness.check(bl3 ^ true, "Error : test_atan2 failed - 5");
        harness.check(Math.atan2(-0.0, -10.0), -Math.PI, "Error : test_atan2 failed - 6a - got " + Math.atan2(-0.0, -10.0) + ", but exp -3.141592653589793");
        harness.check(Math.atan2(-2.0, Double.NEGATIVE_INFINITY), -Math.PI, "Error : test_atan2 failed - 6b - got " + Math.atan2(-2.0, Double.NEGATIVE_INFINITY) + ", but exp -3.141592653589793");
        boolean bl4 = false;
        if (Math.atan2(10.0, 0.0) != 1.5707963267948966 || Math.atan2(Double.POSITIVE_INFINITY, 3) != 1.5707963267948966) {
            bl4 = true;
        }
        harness.check(bl4 ^ true, "Error : test_atan2 failed - 7");
        boolean bl5 = false;
        if (Math.atan2(10.0, -0.0) != 1.5707963267948966 || Math.atan2(Double.POSITIVE_INFINITY, -3.0) != 1.5707963267948966) {
            bl5 = true;
        }
        harness.check(bl5 ^ true, "Error : test_atan2 failed - 8");
        boolean bl6 = false;
        if (Math.atan2(-10.0, 0.0) != -1.5707963267948966 || Math.atan2(Double.NEGATIVE_INFINITY, 3) != -1.5707963267948966) {
            bl6 = true;
        }
        harness.check(bl6 ^ true, "Error : test_atan2 failed - 9");
        boolean bl7 = false;
        if (Math.atan2(-10.0, -0.0) != -1.5707963267948966 || Math.atan2(Double.NEGATIVE_INFINITY, -3.0) != -1.5707963267948966) {
            bl7 = true;
        }
        harness.check(bl7 ^ true, "Error : test_atan2 failed - 10");
        boolean bl8 = false;
        if (Math.abs(Math.atan2(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY) - 0.7853981633974483) < 1.0E-15) {
            bl8 = true;
        }
        harness.check(bl8, "Error : test_atan2 failed - 11 got: " + Math.atan2(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY));
        boolean bl9 = false;
        if (Math.abs(Math.atan2(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY) - 2.356194490192345) < 1.0E-15) {
            bl9 = true;
        }
        harness.check(bl9, "Error : test_atan2 failed - 12 got: " + Math.atan2(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY));
        boolean bl10 = false;
        if (Math.abs(Math.atan2(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY) + 0.7853981633974483) < 1.0E-15) {
            bl10 = true;
        }
        harness.check(bl10, "Error : test_atan2 failed - 13 got: " + Math.atan2(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
        boolean bl11 = false;
        if (Math.abs(Math.atan2(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY) + 2.356194490192345) < 1.0E-15) {
            bl11 = true;
        }
        harness.check(bl11, "Error : test_atan2 failed - 14 got: " + Math.atan2(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY));
        harness.check(new Double(Math.atan2(0.0, Double.NaN)).isNaN() ^ true ^ true, "Error : test_atan2 failed - 15");
        harness.check(new Double(Math.atan2(Double.NaN, 0.0)).isNaN() ^ true ^ true, "Error : test_atan2 failed - 16");
        harness.check(new Double(Math.atan2(-0.0, Double.NaN)).isNaN() ^ true ^ true, "Error : test_atan2 failed - 17");
        harness.check(new Double(Math.atan2(Double.NaN, -0.0)).isNaN() ^ true ^ true, "Error : test_atan2 failed - 18");
        harness.check(new Double(Math.atan2(Double.POSITIVE_INFINITY, Double.NaN)).isNaN() ^ true ^ true, "Error : test_atan2 failed - 19");
        harness.check(new Double(Math.atan2(Double.NaN, Double.POSITIVE_INFINITY)).isNaN() ^ true ^ true, "Error : test_atan2 failed - 20");
        harness.check(new Double(Math.atan2(Double.NEGATIVE_INFINITY, Double.NaN)).isNaN() ^ true ^ true, "Error : test_atan2 failed - 21");
        harness.check(new Double(Math.atan2(Double.NaN, Double.NEGATIVE_INFINITY)).isNaN() ^ true ^ true, "Error : test_atan2 failed - 22");
    }

    public void test_exp() {
        harness.check(new Double(Math.exp(Double.NaN)).isNaN() ^ true ^ true, "Error : test_exp failed - 1");
        harness.check(new Double(Math.exp(Double.POSITIVE_INFINITY)).isInfinite() ^ true ^ true, "Error : test_exp failed - 2");
        boolean bl = false;
        if (Math.exp(Double.NEGATIVE_INFINITY) != 0.0) {
            bl = true;
        }
        harness.check(bl ^ true, "Error : test_exp failed - 3");
        boolean bl2 = false;
        if (Math.exp(0.0) == 1.0) {
            bl2 = true;
        }
        harness.check(bl2, "Error : test_exp failed - 4");
        boolean bl3 = false;
        if (Math.exp(1.0) - Math.E <= 1.0E-10) {
            bl3 = true;
        }
        harness.check(bl3, "Error : test_exp failed - 5");
    }

    public void test_log() {
        harness.check(new Double(Math.log(Double.NaN)).isNaN() ^ true ^ true, "Error : test_log failed - 1");
        harness.check(new Double(Math.log(-1.0)).isNaN() ^ true ^ true, "Error : test_log failed - 2");
        harness.check(new Double(Math.log(Double.NEGATIVE_INFINITY)).isNaN() ^ true ^ true, "Error : test_log failed - 3");
        harness.check(new Double(Math.log(Double.POSITIVE_INFINITY)).isInfinite() ^ true ^ true, "Error : test_log failed - 4");
        boolean bl = false;
        if (Math.log(1.0) == 0.0) {
            bl = true;
        }
        harness.check(bl, "Error : test_log failed - 5");
        boolean bl2 = false;
        if (Math.log(0.0) == Double.NEGATIVE_INFINITY) {
            bl2 = true;
        }
        harness.check(bl2, "Error : test_log failed - 6 got: " + Math.log(0.0));
        boolean bl3 = false;
        if (Math.log(-0.0) == Double.NEGATIVE_INFINITY) {
            bl3 = true;
        }
        harness.check(bl3, "Error : test_log failed - 7 got: " + Math.log(-0.0));
    }

    public void test_sqrt() {
        boolean bl = false;
        if (!new Double(Math.sqrt(Double.NaN)).isNaN() || !new Double(Math.sqrt(-10.0)).isNaN()) {
            bl = true;
        }
        harness.check(bl ^ true, "Error : test_sqrt failed - 1");
        boolean bl2 = false;
        if (!new Double(Math.sqrt(Double.NaN)).isNaN() || !new Double(Math.sqrt(-10.0)).isNaN()) {
            bl2 = true;
        }
        harness.check(bl2 ^ true, "Error : test_sqrt failed - 2");
        harness.check(new Double(Math.sqrt(Double.POSITIVE_INFINITY)).isInfinite() ^ true ^ true, "Error : test_sqrt failed - 3");
        boolean bl3 = false;
        if (Math.sqrt(-0.0) != -0.0 || Math.sqrt(0.0) != 0.0) {
            bl3 = true;
        }
        harness.check(bl3 ^ true, "Error : test_sqrt failed - 4");
        boolean bl4 = false;
        if (Math.sqrt(-0.0) != -0.0 || Math.sqrt(0.0) != 0.0) {
            bl4 = true;
        }
        harness.check(bl4 ^ true, "Error : test_sqrt failed - 5");
        double sq = Math.sqrt(4);
        boolean bl5 = false;
        if (sq >= 1.9999 && sq <= 2.0001) {
            bl5 = true;
        }
        harness.check(bl5 ^ true ^ true, "Error : test_sqrt failed - 6");
        harness.check(new Double(Math.sqrt(Double.NEGATIVE_INFINITY)).isNaN() ^ true ^ true, "Error : test_sqrt failed - 5");
    }

    public void test_pow() {
        boolean bl = false;
        if (Math.pow(1.0, 0.0) != 1.0) {
            bl = true;
        }
        harness.check(bl ^ true, "Error : test_pow failed - 1");
        boolean bl2 = false;
        if (Math.pow(2, -0.0) != 1.0) {
            bl2 = true;
        }
        harness.check(bl2 ^ true, "Error : test_pow failed - 2");
        boolean bl3 = false;
        if (Math.abs(Math.pow(123.0, 1.0) - 123.0) < 0.001) {
            bl3 = true;
        }
        harness.check(bl3, "Error : test_pow failed - 3, got :" + Math.pow(123.0, 1.0));
        harness.check(new Double(Math.pow(10.0, Double.NaN)).isNaN() ^ true ^ true, "Error : test_pow failed - 4");
        harness.check(new Double(Math.pow(Double.NaN, 1.0)).isNaN() ^ true ^ true, "Error : test_pow failed - 5");
        harness.check(new Double(Math.pow(2, Double.POSITIVE_INFINITY)).isInfinite() ^ true ^ true, "Error : test_pow failed - 6");
        harness.check(new Double(Math.pow(0.5, Double.NEGATIVE_INFINITY)).isInfinite() ^ true ^ true, "Error : test_pow failed - 7");
        boolean bl4 = false;
        if (Math.pow(1.5, Double.NEGATIVE_INFINITY) != 0.0 || Math.pow(0.5, Double.POSITIVE_INFINITY) != 0.0) {
            bl4 = true;
        }
        harness.check(bl4 ^ true, "Error : test_pow failed - 8");
        harness.check(new Double(Math.pow(1.0, Double.POSITIVE_INFINITY)).isNaN() ^ true ^ true, "Error : test_pow failed - 9");
        boolean bl5 = false;
        if (Math.pow(0.0, 1.0) != 0.0 || Math.pow(Double.POSITIVE_INFINITY, -1.0) != 0.0) {
            bl5 = true;
        }
        harness.check(bl5 ^ true, "Error : test_pow failed - 10");
        boolean bl6 = false;
        if (!new Double(Math.pow(0.0, -1.0)).isInfinite() || !new Double(Math.pow(Double.POSITIVE_INFINITY, 1.0)).isInfinite()) {
            bl6 = true;
        }
        harness.check(bl6 ^ true, "Error : test_pow failed - 11");
        boolean bl7 = false;
        if (Math.pow(-0.0, 5) != -0.0 || Math.pow(Double.NEGATIVE_INFINITY, -7.0) != -0.0) {
            bl7 = true;
        }
        harness.check(bl7 ^ true, "Error : test_pow failed - 12");
        boolean bl8 = false;
        if (Math.pow(-2.0, 6.0) != Math.pow(2, 6.0)) {
            bl8 = true;
        }
        harness.check(bl8 ^ true, "Error : test_pow failed - 13");
        boolean bl9 = false;
        if (Math.pow(-2.0, 5) != -Math.pow(2, 5)) {
            bl9 = true;
        }
        harness.check(bl9 ^ true, "Error : test_pow failed - 14");
        harness.check(new Double(Math.pow(-2.0, -3.4534)).isNaN() ^ true ^ true, "Error : test_pow failed - 15");
    }

    public void test_IEEEremainder() {
        harness.check(new Double(Math.IEEEremainder(Double.NaN, 1.0)).isNaN() ^ true ^ true, "Error :  test_IEEEremainder failed - 1");
        harness.check(new Double(Math.IEEEremainder(1.0, Double.NaN)).isNaN() ^ true ^ true, "Error :  test_IEEEremainder failed - 2");
        harness.check(new Double(Math.IEEEremainder(Double.POSITIVE_INFINITY, 2)).isNaN() ^ true ^ true, "Error :  test_IEEEremainder failed - 3");
        harness.check(new Double(Math.IEEEremainder(2, 0.0)).isNaN() ^ true ^ true, "Error :  test_IEEEremainder failed - 4");
        boolean bl = false;
        if (Math.IEEEremainder(3, Double.POSITIVE_INFINITY) != (double)3) {
            bl = true;
        }
        harness.check(bl ^ true, "Error :  test_IEEEremainder failed - 5");
        boolean bl2 = false;
        if (Math.IEEEremainder(3, Double.NEGATIVE_INFINITY) != (double)3) {
            bl2 = true;
        }
        harness.check(bl2 ^ true, "Error :  test_IEEEremainder failed - 6");
        harness.check(new Double(Math.IEEEremainder(Double.NaN, Double.POSITIVE_INFINITY)).isNaN(), "Error :  test_IEEEremainder failed - 7");
        harness.check(new Double(Math.IEEEremainder(Double.POSITIVE_INFINITY, Double.NaN)).isNaN(), "Error :  test_IEEEremainder failed - 8");
        harness.check(new Double(Math.IEEEremainder(Double.NaN, Double.NEGATIVE_INFINITY)).isNaN(), "Error :  test_IEEEremainder failed - 9");
        harness.check(new Double(Math.IEEEremainder(Double.NEGATIVE_INFINITY, Double.NaN)).isNaN(), "Error :  test_IEEEremainder failed - 10");
        harness.check(new Double(Math.IEEEremainder(0.0, Double.NaN)).isNaN(), "Error :  test_IEEEremainder failed - 11");
        harness.check(new Double(Math.IEEEremainder(Double.NaN, 0.0)).isNaN(), "Error :  test_IEEEremainder failed - 12");
        harness.check(new Double(Math.IEEEremainder(-0.0, Double.NaN)).isNaN(), "Error :  test_IEEEremainder failed - 13");
        harness.check(new Double(Math.IEEEremainder(Double.NaN, -0.0)).isNaN(), "Error :  test_IEEEremainder failed - 14");
        harness.check(new Double(Math.IEEEremainder(Double.NaN, Double.NaN)).isNaN(), "Error :  test_IEEEremainder failed - 15");
    }

    public void test_ceil() {
        boolean bl = false;
        if (Math.ceil(5) != (double)5) {
            bl = true;
        }
        harness.check(bl ^ true, "Error :  test_ceil failed - 1");
        boolean bl2 = false;
        if (Math.ceil(0.0) != 0.0 || Math.ceil(-0.0) != -0.0) {
            bl2 = true;
        }
        harness.check(bl2 ^ true, "Error :  test_ceil failed - 2");
        boolean bl3 = false;
        if (!new Double(Math.ceil(Double.POSITIVE_INFINITY)).isInfinite() || !new Double(Math.ceil(Double.NaN)).isNaN()) {
            bl3 = true;
        }
        harness.check(bl3 ^ true, "Error :  test_ceil failed - 3");
        harness.check(new Double(Math.ceil(Double.NEGATIVE_INFINITY)).isInfinite(), "Error :  test_ceil failed - 4");
        boolean bl4 = false;
        if (Math.ceil(-0.5) != -0.0) {
            bl4 = true;
        }
        harness.check(bl4 ^ true, "Error :  test_ceil failed - 5");
        boolean bl5 = false;
        if (Math.ceil(2.5) != (double)3) {
            bl5 = true;
        }
        harness.check(bl5 ^ true, "Error :  test_ceil failed - 6");
        boolean bl6 = false;
        if (Math.ceil(0.5) != 1.0) {
            bl6 = true;
        }
        harness.check(bl6 ^ true, "Error :  test_ceil failed - 7");
    }

    public void test_floor() {
        boolean bl = false;
        if (Math.floor(5) != (double)5) {
            bl = true;
        }
        harness.check(bl ^ true, "Error :  test_floor failed - 1");
        boolean bl2 = false;
        if (Math.floor(2.5) != (double)2) {
            bl2 = true;
        }
        harness.check(bl2 ^ true, "Error :  test_floor failed - 2");
        boolean bl3 = false;
        if (!new Double(Math.floor(Double.POSITIVE_INFINITY)).isInfinite() || !new Double(Math.floor(Double.NaN)).isNaN()) {
            bl3 = true;
        }
        harness.check(bl3 ^ true, "Error :  test_floor failed - 3");
        harness.check(new Double(Math.floor(Double.POSITIVE_INFINITY)).isInfinite(), "Error :  test_floor failed - 4");
        boolean bl4 = false;
        if (Math.floor(0.0) != 0.0 || Math.floor(-0.0) != -0.0) {
            bl4 = true;
        }
        harness.check(bl4 ^ true, "Error :  test_floor failed - 5");
        boolean bl5 = false;
        if (Math.floor(-0.5) != -1.0) {
            bl5 = true;
        }
        harness.check(bl5 ^ true, "Error :  test_floor failed - 6, got: " + Math.floor(-0.5));
        boolean bl6 = false;
        if (Math.floor(-6.56566) == -7.0) {
            bl6 = true;
        }
        harness.check(bl6, "Error :  test_floor failed - 7, got: " + Math.floor(-6.56566) + " but exp.: -7.0");
    }

    public void test_rint() {
        boolean bl = false;
        if (Math.rint(2.3) != (double)2) {
            bl = true;
        }
        harness.check(bl ^ true, "Error :  test_rint failed - 1");
        boolean bl2 = false;
        if (Math.rint(2.7) != (double)3) {
            bl2 = true;
        }
        harness.check(bl2 ^ true, "Error :  test_rint failed - 2");
        boolean bl3 = false;
        if (Math.rint(2.5) != (double)2) {
            bl3 = true;
        }
        harness.check(bl3 ^ true, "Error :  test_rint failed - 3");
        boolean bl4 = false;
        if (Math.rint(2) != (double)2) {
            bl4 = true;
        }
        harness.check(bl4 ^ true, "Error :  test_rint failed - 4");
        boolean bl5 = false;
        if (Math.rint(2) != (double)2) {
            bl5 = true;
        }
        harness.check(bl5 ^ true, "Error :  test_rint failed - 5");
        boolean bl6 = false;
        if (!new Double(Math.rint(Double.POSITIVE_INFINITY)).isInfinite() || !new Double(Math.rint(Double.NaN)).isNaN()) {
            bl6 = true;
        }
        harness.check(bl6 ^ true, "Error :  test_rint failed - 6");
        harness.check(new Double(Math.rint(Double.POSITIVE_INFINITY)).isInfinite(), "Error :  test_rint failed - 7");
        boolean bl7 = false;
        if (Math.rint(0.0) != 0.0 || Math.rint(-0.0) != -0.0) {
            bl7 = true;
        }
        harness.check(bl7 ^ true, "Error :  test_rint failed - 8");
        float f1 = -2.1474836E9f;
        boolean bl8 = false;
        if (Math.rint(f1 -= (float)5) != -2.147483648E9) {
            bl8 = true;
        }
        harness.check(bl8 ^ true, "Error :  test_round failed - 9");
    }

    public void test_round() {
        harness.checkPoint("round(float)int");
        boolean bl = false;
        if (Math.round(3.4f) != 3) {
            bl = true;
        }
        harness.check(bl ^ true, "Error :  test_round failed - 1");
        boolean bl2 = false;
        if (Math.round(9.55f) != 10) {
            bl2 = true;
        }
        harness.check(bl2 ^ true, "Error :  test_round failed - 2");
        boolean bl3 = false;
        if (Math.round(Float.NaN) != 0) {
            bl3 = true;
        }
        harness.check(bl3 ^ true, "Error :  test_round failed - 3");
        float f1 = -2.1474836E9f;
        boolean bl4 = false;
        if (Math.round(f1 -= (float)5) != Integer.MIN_VALUE || Math.round(Float.NEGATIVE_INFINITY) != Integer.MIN_VALUE) {
            bl4 = true;
        }
        harness.check(bl4 ^ true, "Error :  test_round failed - 4");
        f1 = 2.1474836E9f;
        boolean bl5 = false;
        if (Math.round(f1 += (float)5) != Integer.MAX_VALUE || Math.round(Float.POSITIVE_INFINITY) != Integer.MAX_VALUE) {
            bl5 = true;
        }
        harness.check(bl5 ^ true, "Error :  test_round failed - 5");
        harness.checkPoint("round(double)long");
        double d1 = -9.223372036854776E18;
        boolean bl6 = false;
        if (Math.round(d1 -= (double)5) != Long.MIN_VALUE || Math.round(Double.NEGATIVE_INFINITY) != Long.MIN_VALUE) {
            bl6 = true;
        }
        harness.check(bl6 ^ true, "Error :  test_round failed - 6");
        d1 = 9.223372036854776E18;
        boolean bl7 = false;
        if (Math.round(d1 += (double)5) != Long.MAX_VALUE || Math.round(Double.POSITIVE_INFINITY) != Long.MAX_VALUE) {
            bl7 = true;
        }
        harness.check(bl7 ^ true, "Error :  test_round failed - 7");
        boolean bl8 = false;
        if (Math.round(3.4) != (long)3) {
            bl8 = true;
        }
        harness.check(bl8 ^ true, "Error :  test_round failed - 8");
        boolean bl9 = false;
        if (Math.round(9.55) != 10L) {
            bl9 = true;
        }
        harness.check(bl9 ^ true, "Error :  test_round failed - 9");
        boolean bl10 = false;
        if (Math.round(Double.NaN) != 0L) {
            bl10 = true;
        }
        harness.check(bl10 ^ true, "Error :  test_round failed - 10");
    }

    public void test_random() {
        int[] s = new int[20];
        int i = 0;
        while (i < 20) {
            s[i] = 0;
            ++i;
        }
        double minv = 1.0;
        double maxv = 0.0;
        double sumv = 0.0;
        double devv = 0.0;
        double rndv = 0.0;
        try {
            Exception e = new Exception();
            int i2 = 0;
            while (i2 < 10000) {
                rndv = Math.random();
                if (rndv < 0.0 || rndv >= 1.0) {
                    throw e;
                }
                sumv += rndv;
                devv += Math.abs(rndv - 0.5);
                minv = Math.min(minv, rndv);
                maxv = Math.max(maxv, rndv);
                if (rndv < 0.05) {
                    s[0] = s[0] + 1;
                } else if (rndv < 0.1) {
                    s[1] = s[1] + 1;
                } else if (rndv < 0.15) {
                    s[2] = s[2] + 1;
                } else if (rndv < 0.2) {
                    s[3] = s[3] + 1;
                } else if (rndv < 0.25) {
                    s[4] = s[4] + 1;
                } else if (rndv < 0.3) {
                    s[5] = s[5] + 1;
                } else if (rndv < 0.35) {
                    s[6] = s[6] + 1;
                } else if (rndv < 0.4) {
                    s[7] = s[7] + 1;
                } else if (rndv < 0.45) {
                    s[8] = s[8] + 1;
                } else if (rndv < 0.5) {
                    s[9] = s[9] + 1;
                } else if (rndv < 0.55) {
                    s[10] = s[10] + 1;
                } else if (rndv < 0.6) {
                    s[11] = s[11] + 1;
                } else if (rndv < 0.65) {
                    s[12] = s[12] + 1;
                } else if (rndv < 0.7) {
                    s[13] = s[13] + 1;
                } else if (rndv < 0.75) {
                    s[14] = s[14] + 1;
                } else if (rndv < 0.8) {
                    s[15] = s[15] + 1;
                } else if (rndv < 0.85) {
                    s[16] = s[16] + 1;
                } else if (rndv < 0.9) {
                    s[17] = s[17] + 1;
                } else if (rndv < 0.95) {
                    s[18] = s[18] + 1;
                } else {
                    s[19] = s[19] + 1;
                }
                ++i2;
            }
        }
        catch (Exception e) {
            harness.fail("RandomGenerator generated value: " + rndv);
        }
        boolean bl = false;
        if (maxv > 0.9986) {
            bl = true;
        }
        harness.check(bl, "maximum value is to small : " + maxv);
        boolean bl2 = false;
        if (minv < 0.0012) {
            bl2 = true;
        }
        harness.check(bl2, "minimum value is to large : " + minv);
        boolean bl3 = false;
        if (Math.abs(sumv - 5000.0) < 120.0) {
            bl3 = true;
        }
        harness.check(bl3, "average value is wrong: " + sumv / 10000.0 + " != 0.5");
        boolean bl4 = false;
        if (Math.abs(devv - 2500.0) < 58.0) {
            bl4 = true;
        }
        harness.check(bl4, "the deviation is wrong: " + devv / 10000.0 + " != 0.25");
        int mins = 550;
        int maxs = 450;
        double sigma = 0.0;
        int i3 = 0;
        while (i3 < 20) {
            sigma += (double)(s[i3] * (s[i3] - 1000) + 250000);
            mins = Math.min(mins, s[i3]);
            maxs = Math.max(maxs, s[i3]);
            ++i3;
        }
        boolean bl5 = false;
        if (mins > 395) {
            bl5 = true;
        }
        harness.check(bl5, "distribution is not uniform " + mins + " smallest section");
        boolean bl6 = false;
        if (maxs < 610) {
            bl6 = true;
        }
        harness.check(bl6, "distribution is not uniform " + maxs + " largest section");
        sigma = Math.sqrt(sigma / 20.0);
        boolean bl7 = false;
        if (sigma < 36.5) {
            bl7 = true;
        }
        harness.check(bl7, "the standard deviation is to big -- " + sigma);
        harness.debug("\tmaxv = " + maxv + "\n\tminv = " + minv + "\n\tavgv = " + sumv / 10000.0 + "\n\tdevv = " + devv / 10000.0);
        harness.debug("maxs = " + maxs + "\n\tmins = " + mins + "\n\tsigma = " + Math.sqrt(sigma / 20.0));
        harness.debug("\t" + s[0] + '\t' + s[1] + '\t' + s[2] + '\t' + s[3] + '\t' + s[4] + "\n\t" + s[5] + '\t' + s[6] + '\t' + s[7] + '\t' + s[8] + '\t' + s[9]);
        harness.debug("\t" + s[10] + '\t' + s[11] + '\t' + s[12] + '\t' + s[13] + '\t' + s[14] + "\n\t" + s[15] + '\t' + s[16] + '\t' + s[17] + '\t' + s[18] + '\t' + s[19]);
    }

    public void test_abs() {
        harness.checkPoint("abs(int)int");
        boolean bl = false;
        if (Math.abs(10) != 10) {
            bl = true;
        }
        harness.check(bl ^ true, "Error :  test_abs failed - 1");
        boolean bl2 = false;
        if (Math.abs(-23) != 23) {
            bl2 = true;
        }
        harness.check(bl2 ^ true, "Error :  test_abs failed - 2");
        boolean bl3 = false;
        if (Math.abs(Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            bl3 = true;
        }
        harness.check(bl3 ^ true, "Error :  test_abs failed - 3");
        boolean bl4 = false;
        if (Math.abs(0) != 0) {
            bl4 = true;
        }
        harness.check(bl4 ^ true, "Error :  test_abs failed - 4");
        harness.checkPoint("abs(long)long");
        boolean bl5 = false;
        if (Math.abs(1000L) != 1000L) {
            bl5 = true;
        }
        harness.check(bl5 ^ true, "Error :  test_abs failed - 5");
        boolean bl6 = false;
        if (Math.abs(-2334242L) != 2334242L) {
            bl6 = true;
        }
        harness.check(bl6 ^ true, "Error :  test_abs failed - 6");
        harness.check(Math.abs(Long.MIN_VALUE), Long.MIN_VALUE, "Error :  test_abs failed - 7");
        harness.checkPoint("abs(float)float");
        boolean bl7 = false;
        if (Math.abs(0.0f) != 0.0f || Math.abs(-0.0f) != 0.0f) {
            bl7 = true;
        }
        harness.check(bl7 ^ true, "Error :  test_abs failed - 8");
        harness.check(new Float(Math.abs(Float.POSITIVE_INFINITY)).isInfinite() ^ true ^ true, "Error :  test_abs failed - 9a");
        harness.check(new Float(Math.abs(Float.NEGATIVE_INFINITY)).isInfinite() ^ true ^ true, "Error :  test_abs failed - 9b");
        harness.check(new Float(Math.abs(Float.NaN)).isNaN() ^ true ^ true, "Error :  test_abs failed - 10");
        boolean bl8 = false;
        if (Math.abs(23.34f) != 23.34f) {
            bl8 = true;
        }
        harness.check(bl8 ^ true, "Error :  test_abs failed - 11a");
        boolean bl9 = false;
        if (Math.abs(-23.34f) != 23.34f) {
            bl9 = true;
        }
        harness.check(bl9 ^ true, "Error :  test_abs failed - 11b");
        harness.checkPoint("abs(double)double");
        boolean bl10 = false;
        if (Math.abs(0.0) != 0.0 || Math.abs(-0.0) != 0.0) {
            bl10 = true;
        }
        harness.check(bl10 ^ true, "Error :  test_abs failed - 12");
        harness.check(new Double(Math.abs(Double.POSITIVE_INFINITY)).isInfinite() ^ true ^ true, "Error :  test_abs failed - 13a");
        harness.check(new Double(Math.abs(Double.NEGATIVE_INFINITY)).isInfinite() ^ true ^ true, "Error :  test_abs failed - 13b");
        harness.check(new Double(Math.abs(Double.NaN)).isNaN() ^ true ^ true, "Error :  test_abs failed - 14");
        boolean bl11 = false;
        if (Math.abs(23.34) != 23.34) {
            bl11 = true;
        }
        harness.check(bl11 ^ true, "Error :  test_abs failed - 15");
        boolean bl12 = false;
        if (Math.abs(-23.34) != 23.34) {
            bl12 = true;
        }
        harness.check(bl12 ^ true, "Error :  test_abs failed - 16");
    }

    public void test_min() {
        harness.checkPoint("min(int,int)int");
        boolean bl = false;
        if (Math.min(100, 12) != 12) {
            bl = true;
        }
        harness.check(bl ^ true, "Error :  test_min failed - 1");
        boolean bl2 = false;
        if (Math.min(Integer.MIN_VALUE, -2147483647) != Integer.MIN_VALUE) {
            bl2 = true;
        }
        harness.check(bl2 ^ true, "Error :  test_min failed - 2");
        boolean bl3 = false;
        if (Math.min(Integer.MAX_VALUE, 0x7FFFFFFE) != 0x7FFFFFFE) {
            bl3 = true;
        }
        harness.check(bl3 ^ true, "Error :  test_min failed - 3");
        boolean bl4 = false;
        if (Math.min(10, 10) != 10) {
            bl4 = true;
        }
        harness.check(bl4 ^ true, "Error :  test_min failed - 4");
        boolean bl5 = false;
        if (Math.min(0, 0) != 0) {
            bl5 = true;
        }
        harness.check(bl5 ^ true, "Error :  test_min failed - 5");
        harness.checkPoint("min(long,long)long");
        boolean bl6 = false;
        if (Math.min(100L, 12L) != 12L) {
            bl6 = true;
        }
        harness.check(bl6 ^ true, "Error :  test_min failed - 6");
        boolean bl7 = false;
        if (Math.min(Long.MIN_VALUE, -9223372036854775807L) != Long.MIN_VALUE) {
            bl7 = true;
        }
        harness.check(bl7 ^ true, "Error :  test_min failed - 7");
        boolean bl8 = false;
        if (Math.min(Long.MAX_VALUE, 0x7FFFFFFFFFFFFFFEL) != 0x7FFFFFFFFFFFFFFEL) {
            bl8 = true;
        }
        harness.check(bl8 ^ true, "Error :  test_min failed - 8");
        boolean bl9 = false;
        if (Math.min(10L, 10L) != 10L) {
            bl9 = true;
        }
        harness.check(bl9 ^ true, "Error :  test_min failed - 9");
        boolean bl10 = false;
        if (Math.min(0L, 0L) != 0L) {
            bl10 = true;
        }
        harness.check(bl10 ^ true, "Error :  test_min failed - 10");
        harness.checkPoint("min(float,float)float");
        boolean bl11 = false;
        if (Math.min(23.4f, 12.3f) != 12.3f) {
            bl11 = true;
        }
        harness.check(bl11 ^ true, "Error :  test_min failed - 11");
        harness.check(new Float(Math.min(Float.NaN, 1.0f)).isNaN() ^ true ^ true, "Error :  test_min failed - 12a");
        harness.check(new Float(Math.min(1.0f, Float.NaN)).isNaN() ^ true ^ true, "Error :  test_min failed - 12b");
        boolean bl12 = false;
        if (Math.min(10.0f, 10.0f) != 10.0f) {
            bl12 = true;
        }
        harness.check(bl12 ^ true, "Error :  test_min failed - 13");
        boolean bl13 = false;
        if (Math.min(0.0f, -0.0f) != -0.0f) {
            bl13 = true;
        }
        harness.check(bl13 ^ true, "Error :  test_min failed - 14a");
        boolean bl14 = false;
        if (Math.min(-0.0f, 0.0f) != -0.0f) {
            bl14 = true;
        }
        harness.check(bl14 ^ true, "Error :  test_min failed - 14b");
        boolean bl15 = false;
        if (Math.min(Float.NEGATIVE_INFINITY, 2.3f) == Float.NEGATIVE_INFINITY) {
            bl15 = true;
        }
        harness.check(bl15, "Error : test should return Neg. Inf.");
        boolean bl16 = false;
        if (Math.min(Float.POSITIVE_INFINITY, 2.3f) == 2.3f) {
            bl16 = true;
        }
        harness.check(bl16, "Error : Pos. Inf.should be treated as value");
        boolean bl17 = false;
        if (Math.min(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY) == Float.POSITIVE_INFINITY) {
            bl17 = true;
        }
        harness.check(bl17, "Error : Pos. Inf.should be treated as value");
        harness.checkPoint("min(double,double)double");
        boolean bl18 = false;
        if (Math.min(23.4, 12.3) != 12.3) {
            bl18 = true;
        }
        harness.check(bl18 ^ true, "Error :  test_min failed - 15");
        harness.check(new Double(Math.min(Double.NaN, 1.0)).isNaN() ^ true ^ true, "Error :  test_min failed - 16a, got: " + new Double(Math.min(Double.NaN, 1.0)));
        harness.check(new Double(Math.min(1.0, Double.NaN)).isNaN() ^ true ^ true, "Error :  test_min failed - 16b, got: " + new Double(Math.min(1.0, Double.NaN)));
        boolean bl19 = false;
        if (Math.min(10.0, 10.0) != 10.0) {
            bl19 = true;
        }
        harness.check(bl19 ^ true, "Error :  test_min failed - 17");
        boolean bl20 = false;
        if (Math.min(0.0, -0.0) != -0.0) {
            bl20 = true;
        }
        harness.check(bl20 ^ true, "Error :  test_min failed - 18");
        boolean bl21 = false;
        if (Math.min(-0.0, 0.0) != -0.0) {
            bl21 = true;
        }
        harness.check(bl21 ^ true, "Error :  test_min failed - 18");
        boolean bl22 = false;
        if (Math.min(Double.NEGATIVE_INFINITY, 2.3) == Double.NEGATIVE_INFINITY) {
            bl22 = true;
        }
        harness.check(bl22, "Error : test should return Neg. Inf.");
        boolean bl23 = false;
        if (Math.min(Double.POSITIVE_INFINITY, (double)2.3f) == (double)2.3f) {
            bl23 = true;
        }
        harness.check(bl23, "Error : Pos. Inf.should be treated as value");
        boolean bl24 = false;
        if (Math.min(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY) == Double.POSITIVE_INFINITY) {
            bl24 = true;
        }
        harness.check(bl24, "Error : Pos. Inf.should be treated as value");
    }

    public void test_max() {
        harness.checkPoint("max(int,int)int");
        boolean bl = false;
        if (Math.max(100, 12) != 100) {
            bl = true;
        }
        harness.check(bl ^ true, "Error :  test_max failed - 1");
        boolean bl2 = false;
        if (Math.max(Integer.MAX_VALUE, 0x7FFFFFFE) != Integer.MAX_VALUE) {
            bl2 = true;
        }
        harness.check(bl2 ^ true, "Error :  test_max failed - 2");
        boolean bl3 = false;
        if (Math.max(Integer.MIN_VALUE, -2147483647) != -2147483647) {
            bl3 = true;
        }
        harness.check(bl3 ^ true, "Error :  test_max failed - 3");
        boolean bl4 = false;
        if (Math.max(10, 10) != 10) {
            bl4 = true;
        }
        harness.check(bl4 ^ true, "Error :  test_max failed - 4");
        boolean bl5 = false;
        if (Math.max(0, 0) != 0) {
            bl5 = true;
        }
        harness.check(bl5 ^ true, "Error :  test_max failed - 5");
        harness.checkPoint("max(long,long)long");
        boolean bl6 = false;
        if (Math.max(100L, 12L) != 100L) {
            bl6 = true;
        }
        harness.check(bl6 ^ true, "Error :  test_max failed - 6");
        boolean bl7 = false;
        if (Math.max(Long.MAX_VALUE, 0x7FFFFFFFFFFFFFFEL) != Long.MAX_VALUE) {
            bl7 = true;
        }
        harness.check(bl7 ^ true, "Error :  test_max failed - 7");
        boolean bl8 = false;
        if (Math.max(Long.MIN_VALUE, -9223372036854775807L) != -9223372036854775807L) {
            bl8 = true;
        }
        harness.check(bl8 ^ true, "Error :  test_max failed - 8");
        boolean bl9 = false;
        if (Math.max(10L, 10L) != 10L) {
            bl9 = true;
        }
        harness.check(bl9 ^ true, "Error :  test_max failed - 9");
        boolean bl10 = false;
        if (Math.max(0L, 0L) != 0L) {
            bl10 = true;
        }
        harness.check(bl10 ^ true, "Error :  test_max failed - 10");
        harness.checkPoint("max(float,float)float");
        boolean bl11 = false;
        if (Math.max(23.4f, 12.3f) != 23.4f) {
            bl11 = true;
        }
        harness.check(bl11 ^ true, "Error :  test_max failed - 11");
        harness.check(new Float(Math.max(Float.NaN, 1.0f)).isNaN() ^ true ^ true, "Error :  test_max failed - 12a");
        harness.check(new Float(Math.max(1.0f, Float.NaN)).isNaN() ^ true ^ true, "Error :  test_max failed - 12b");
        boolean bl12 = false;
        if (Math.max(10.0f, 10.0f) != 10.0f) {
            bl12 = true;
        }
        harness.check(bl12 ^ true, "Error :  test_max failed - 13");
        boolean bl13 = false;
        if (Math.max(0.0f, -0.0f) != 0.0f) {
            bl13 = true;
        }
        harness.check(bl13 ^ true, "Error :  test_max failed - 14a");
        boolean bl14 = false;
        if (Math.max(-0.0f, 0.0f) != 0.0f) {
            bl14 = true;
        }
        harness.check(bl14 ^ true, "Error :  test_max failed - 14b");
        boolean bl15 = false;
        if (Math.max(Float.NEGATIVE_INFINITY, 2.3f) == 2.3f) {
            bl15 = true;
        }
        harness.check(bl15, "Error : test should treat Neg. Inf. as number");
        boolean bl16 = false;
        if (Math.max(Float.POSITIVE_INFINITY, 2.3f) == Float.POSITIVE_INFINITY) {
            bl16 = true;
        }
        harness.check(bl16, "Error : Pos. Inf.should be treated as value");
        boolean bl17 = false;
        if (Math.max(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY) == Float.NEGATIVE_INFINITY) {
            bl17 = true;
        }
        harness.check(bl17, "Error : Neg. Inf.should be treated as value");
        harness.checkPoint("max(double,double)double");
        boolean bl18 = false;
        if (Math.max(23.4, 12.3) != 23.4) {
            bl18 = true;
        }
        harness.check(bl18 ^ true, "Error :  test_max failed - 15");
        harness.check(new Double(Math.max(Double.NaN, 1.0)).isNaN() ^ true ^ true, "Error :  test_max failed - 16a, got: " + new Double(Math.max(Double.NaN, 1.0)));
        harness.check(new Double(Math.max(1.0, Double.NaN)).isNaN() ^ true ^ true, "Error :  test_max failed - 16b, got: " + new Double(Math.max(1.0, Double.NaN)));
        boolean bl19 = false;
        if (Math.max(10.0, 10.0) != 10.0) {
            bl19 = true;
        }
        harness.check(bl19 ^ true, "Error :  test_max failed - 17");
        boolean bl20 = false;
        if (Math.max(0.0, -0.0) != 0.0) {
            bl20 = true;
        }
        harness.check(bl20 ^ true, "Error :  test_max failed - 18");
        boolean bl21 = false;
        if (Math.max(-0.0, 0.0) != 0.0) {
            bl21 = true;
        }
        harness.check(bl21 ^ true, "Error :  test_max failed - 18");
        boolean bl22 = false;
        if (Math.max(Double.NEGATIVE_INFINITY, 2.3) == 2.3) {
            bl22 = true;
        }
        harness.check(bl22, "Error : test should treat Neg. Inf. as number");
        boolean bl23 = false;
        if (Math.max(Double.POSITIVE_INFINITY, 2.3) == Double.POSITIVE_INFINITY) {
            bl23 = true;
        }
        harness.check(bl23, "Error : Pos. Inf.should be treated as value");
        boolean bl24 = false;
        if (Math.max(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY) == Double.NEGATIVE_INFINITY) {
            bl24 = true;
        }
        harness.check(bl24, "Error : Neg. Inf.should be treated as value");
    }

    public void testall() {
        harness.setclass("java.lang.Math");
        this.test_Basics();
        this.test_sincostan();
        this.test_asinacosatan();
        this.test_atan2();
        harness.checkPoint("log(double)double");
        this.test_log();
        harness.checkPoint("exp(double)double");
        this.test_exp();
        harness.checkPoint("sqrt(double)double");
        this.test_sqrt();
        harness.checkPoint("pow(double,double)double");
        this.test_pow();
        harness.checkPoint("IEEEremainder(double,double)double");
        this.test_IEEEremainder();
        harness.checkPoint("ceil(double)double");
        this.test_ceil();
        harness.checkPoint("floor(double)double");
        this.test_floor();
        harness.checkPoint("rint(double)double");
        this.test_rint();
        this.test_round();
        harness.checkPoint("random()double");
        int j = 0;
        while (j < 10) {
            this.test_random();
            ++j;
        }
        this.test_abs();
        this.test_min();
        this.test_max();
    }

    public void test(TestHarness the_harness) {
        harness = the_harness;
        this.testall();
    }
}

