/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.Long;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.Properties;

public class LongTest
implements Testlet {
    protected static TestHarness harness;

    public void testConstructors() {
        harness.checkPoint("Long(long)/ Long");
        Long a = new Long(0L);
        Long b = new Long(1L);
        Long c = new Long(0L);
        Long d = a;
        Long e = new Long(14L);
        long flong = 102L;
        Long f = new Long(flong);
        Long g = new Long(97L);
        Integer i = new Integer(0);
        harness.checkPoint("equals(java.lang.Object)boolean");
        boolean bl = false;
        if (a != null) {
            bl = true;
        }
        harness.check(bl);
        harness.check(a.equals(null) ^ true);
        boolean bl2 = false;
        if (a != b) {
            bl2 = true;
        }
        harness.check(bl2);
        harness.check(a.equals(b) ^ true);
        boolean bl3 = false;
        if (a != c) {
            bl3 = true;
        }
        harness.check(bl3);
        harness.check(a.equals(c));
        boolean bl4 = false;
        if (a == d) {
            bl4 = true;
        }
        harness.check(bl4);
        harness.check(a.equals(d));
        boolean bl5 = false;
        if (a == a) {
            bl5 = true;
        }
        harness.check(bl5);
        harness.check(a.equals(i) ^ true);
        harness.checkPoint("longValue()long");
        harness.check(a, 0L);
        harness.check(a, a);
        harness.check(a, c);
        harness.check(a, d);
        harness.check(a, i.longValue());
        harness.check(b, 1L);
        harness.check(e, 14L);
        harness.check(f, flong);
        harness.check(g, 97L);
        harness.check(g, 97L);
        harness.check(g, 97L);
        harness.checkPoint("MAX_VALUE(public)long");
        harness.check(Long.MAX_VALUE, Long.MAX_VALUE);
        harness.checkPoint("MIN_VALUE(public)long");
        harness.check(Long.MIN_VALUE, Long.MIN_VALUE);
        harness.checkPoint("Long(java.lang.String)");
        this.constructMustSucceed("1", 1L);
        this.constructMustSucceed("9223372036854775807", Long.MAX_VALUE);
        this.constructMustSucceed("-9223372036854775808", Long.MIN_VALUE);
        this.constructMustFail("9223372036854775808");
        this.constructMustFail("-9223372036854775809");
        this.constructMustFail("0x77");
        this.constructMustFail("#77");
        this.constructMustFail("4f");
        this.constructMustFail("0x4f");
        this.constructMustFail(" ");
        this.constructMustFail("");
        this.constructMustFail(null);
        this.constructMustFail("  1 ");
    }

    private final void constructMustSucceed(String line, long expected) {
        try {
            Long constructed = new Long(line);
            harness.check(constructed, expected);
        }
        catch (NumberFormatException e8) {
            harness.fail("Could not construct desired value <" + line + ">\n" + e8);
        }
    }

    private final void constructMustFail(String line) {
        try {
            new Long(line);
            harness.fail("Attempt to construct out-of-range long < " + line + " > ");
        }
        catch (Exception e) {
            harness.check(true);
        }
    }

    public void testCompare() {
        Comparable<Character> cha2;
        Long cha1;
        harness.checkPoint("compareTo(java.lang.Long)int");
        this.checkCompare(100L, 101L);
        this.checkCompare(0L, 101L);
        this.checkCompare(-101L, -100L);
        this.checkCompare(-100L, 0L);
        this.checkCompare(-101L, 100L);
        this.checkCompare(0x7FFFFFFFFFFFFFF0L, Long.MAX_VALUE);
        this.checkCompare(Long.MIN_VALUE, -9223372036854775792L);
        harness.checkPoint("compareTo(java.lang.Object)int");
        try {
            cha1 = new Long(97L);
            boolean bl = false;
            if (cha1.compareTo(new Long(97L)) == 0) {
                bl = true;
            }
            harness.check(bl);
        }
        catch (ClassCastException e) {
            harness.fail("Exception comparing two instances of class Long ");
        }
        try {
            cha1 = new Long(97L);
            cha2 = new Character('a');
            cha1.compareTo(cha2);
            harness.fail("Attempt to compare two different objects ");
        }
        catch (ClassCastException e) {
            harness.check(true);
        }
        try {
            cha1 = new Long(0x7FFFFFFEL);
            cha2 = new Integer(0x7FFFFFFE);
            cha1.compareTo(cha2);
            harness.fail("Attempt to compare two different objects ");
        }
        catch (ClassCastException e) {
            harness.check(true);
        }
    }

    private final void checkCompare(long smallvalue, long bigvalue) {
        try {
            Long smalllong = new Long(smallvalue);
            Long biglong = new Long(bigvalue);
            if (smalllong.compareTo(biglong) > 0) {
                harness.fail("compareTo detected <" + smallvalue + "> bigger then <" + bigvalue + '>');
            } else if (smalllong.compareTo(biglong) == 0) {
                harness.fail("compareTo detected <" + smallvalue + "> equal to <" + bigvalue + '>');
            } else {
                harness.check(true);
            }
            if (biglong.compareTo(smalllong) < 0) {
                harness.fail("compareTo detected <" + bigvalue + "> smaller then <" + smallvalue + '>');
            } else if (biglong.compareTo(smalllong) == 0) {
                harness.fail("compareTo detected <" + bigvalue + "> equal to <" + smallvalue + '>');
            } else {
                harness.check(true);
            }
            if (smalllong.compareTo(smalllong) != 0) {
                harness.fail("compareTo detected <" + smallvalue + "> not equal to itselves");
            } else {
                harness.check(true);
            }
            if (biglong.compareTo(biglong) != 0) {
                harness.fail("compareTo detected <" + bigvalue + "> not equal to itselves");
            } else {
                harness.check(true);
            }
        }
        catch (Exception e) {
            harness.fail("Exception while comparing <" + smallvalue + "> and <" + bigvalue + '>');
        }
    }

    public void testStringConversion() {
        harness.checkPoint("toString(long)java.lang.String");
        long along = 97L;
        long zerolong = 0L;
        Long a = new Long(along);
        Long zero = new Long(0L);
        String astring = "97";
        harness.check(zero.toString(), (Object)"0");
        harness.check(Long.toString(zerolong), (Object)"0");
        harness.check(a.toString(), (Object)astring);
        harness.check(a.toString(), (Object)Long.toString(along));
        harness.checkPoint("toBinaryString(long)java.lang.String");
        harness.check(Long.toBinaryString(0L), (Object)"0");
        harness.check(Long.toBinaryString(1L), (Object)"1");
        harness.check(Long.toBinaryString(3), (Object)"11");
        harness.check(Long.toBinaryString(-1), (Object)"1111111111111111111111111111111111111111111111111111111111111111");
        harness.checkPoint("toOctalString(long)java.lang.String");
        harness.check(Long.toOctalString(0L), (Object)"0");
        harness.check(Long.toOctalString(1L), (Object)"1");
        harness.check(Long.toOctalString(9L), (Object)"11");
        harness.check(Long.toOctalString(-1), (Object)"1777777777777777777777");
        harness.checkPoint("toHexString(long)java.lang.String");
        harness.check(Long.toHexString(0L), (Object)"0");
        harness.check(Long.toHexString(1L), (Object)"1");
        harness.check(Long.toHexString(17L), (Object)"11");
        harness.check(Long.toHexString(31L), (Object)"1f");
        harness.check(Long.toHexString(-1), (Object)"ffffffffffffffff");
        harness.checkPoint("toString(long,int)java.lang.String");
        harness.check(Long.toString(along, 2), (Object)Long.toBinaryString(along));
        harness.check(Long.toString(along, 8), (Object)Long.toOctalString(along));
        harness.check(Long.toString(along, 10), (Object)Long.toString(along));
        harness.check(Long.toString(along, 16), (Object)Long.toHexString(along));
        harness.check(Long.toString(along, 1), (Object)Long.toString(along));
        harness.check(Long.toString(along, 37), (Object)Long.toString(along));
        harness.check(Long.toString(4, 3), (Object)"11");
        harness.check(Long.toString(11L, 11), (Object)"10");
        harness.check(Long.toString(21L, 11), (Object)"1a");
        harness.check(Long.toString(21L, 20), (Object)"11");
        harness.check(Long.toString(20L, 20), (Object)"10");
        harness.check(Long.toString(39L, 20), (Object)"1j");
        harness.check(Long.toString(37L, 36), (Object)"11");
        harness.check(Long.toString(36L, 36), (Object)"10");
        harness.check(Long.toString(71L, 36), (Object)"1z");
        harness.checkPoint("decode(java.lang.String)java.lang.Long");
        this.decodeMustPass("11", 11L);
        this.decodeMustPass("011", 9L);
        this.decodeMustPass("#11", 17L);
        this.decodeMustPass("0x11", 17L);
        this.decodeMustPass("0xCAFEBABBE", 54491065278L);
        this.decodeMustPass("0xd0edef0efe", 897345064702L);
        this.decodeMustPass("0", 0L);
        this.decodeMustPass("-11", -11L);
        this.decodeMustPass("-011", -9L);
        this.decodeMustFail("0-11");
        this.decodeMustPass("-#11", -17L);
        this.decodeMustFail("#-11");
        this.decodeMustPass("-0x11", -17L);
        this.decodeMustFail("0x-11");
        this.decodeMustPass("0x7fffffffffffffff", Long.MAX_VALUE);
        this.decodeMustPass("0x7FFFFFFFFFFFFFFF", Long.MAX_VALUE);
        harness.check(Long.decode("0x7fffffffffffffff"), new Long(Long.MAX_VALUE));
        harness.check(Long.decode("0x7FFFFFFFFFFFFFFF"), new Long(Long.MAX_VALUE));
        harness.check(Long.decode("-0x8000000000000000"), new Long(Long.MIN_VALUE));
        this.decodeMustFail("0x8000000000000000");
        this.decodeMustFail("-0x8000000000000001");
        this.decodeMustFail("019");
        this.decodeMustFail("122.5");
        this.decodeMustFail("4F");
        this.decodeMustFail("#4G");
        this.decodeMustFail("0x4G");
        this.decodeMustFail(" 11");
        this.decodeMustFail(" ");
        this.decodeMustFail("");
        this.decodeMustFail(null);
    }

    private final void decodeMustPass(String line, long checkvalue) {
        try {
            Long decoded = Long.decode(line);
            harness.check(decoded, checkvalue);
        }
        catch (Exception e) {
            harness.fail("Exception while trying to decode string <" + line + '>');
        }
    }

    private final void decodeMustFail(String line) {
        try {
            Long.decode(line);
            harness.fail("Attempt to decode illegal string format <" + line + '>');
        }
        catch (Exception e) {
            harness.check(true);
        }
    }

    public void testStringValueParsing() {
        String astring = new String("100");
        Long target = new Long(100L);
        harness.checkPoint("parseLong(java.lang.String)long");
        harness.check(Long.parseLong(astring), 100L);
        harness.check(Long.valueOf(astring).equals(target));
        harness.check(Long.parseLong("0"), 0L);
        harness.check(Long.parseLong("-34"), -34L);
        harness.check(Long.valueOf("-56").equals(new Long(-56L)));
        harness.check(Long.parseLong("9223372036854775807"), Long.MAX_VALUE);
        harness.check(Long.valueOf("9223372036854775807").equals(new Long(Long.MAX_VALUE)));
        harness.check(Long.parseLong("-9223372036854775808"), Long.MIN_VALUE);
        harness.check(Long.valueOf("-9223372036854775808").equals(new Long(Long.MIN_VALUE)));
        harness.checkPoint("valueOf(java.lang.String)java.lang.Long");
        this.parseCheckMustFail("9223372036854775808", 10);
        this.valueCheckMustFail("9223372036854775808", 10);
        this.parseCheckMustFail("-9223372036854775809", 10);
        this.valueCheckMustFail("-9223372036854775809", 10);
        this.parseCheckMustFail("0x60", 10);
        this.valueCheckMustFail("0x60", 10);
        this.parseCheckMustFail(" ", 10);
        this.valueCheckMustFail(" ", 10);
        this.parseCheckMustFail("", 10);
        this.valueCheckMustFail("", 10);
        this.parseCheckMustFail(null, 10);
        this.valueCheckMustFail(null, 10);
        this.parseCheckMustFail(" 78  ", 10);
        this.valueCheckMustFail(" 78  ", 10);
        harness.check(Long.parseLong("12", 10), Long.parseLong("12"));
        harness.check(Long.parseLong("-34", 10), Long.parseLong("-34"));
        harness.check(Long.valueOf("56", 10), Long.valueOf("56"));
        harness.check(Long.valueOf("-78", 10), Long.valueOf("-78"));
        harness.check(Long.parseLong("11", 2), Long.parseLong("3"), "parseLong binary ");
        harness.check(Long.parseLong("-11", 2), Long.parseLong("-3"), "parseLong binary negative");
        harness.check(Long.valueOf("11", 2), Long.valueOf("3"), "valueOf binary ");
        harness.check(Long.valueOf("-11", 2), Long.valueOf("-3"), "valueOf binary negative");
        harness.check(Long.parseLong("11", 3), Long.parseLong("4"), "parseLong 3-based ");
        harness.check(Long.parseLong("-11", 3), Long.parseLong("-4"), "parseLong 3-based negative");
        harness.check(Long.valueOf("11", 3), Long.valueOf("4"), "valueOf 3-based ");
        harness.check(Long.valueOf("-11", 3), Long.valueOf("-4"), "valueOf 3-based negative");
        harness.check(Long.parseLong("11", 8), Long.parseLong("9"), "parseLong octal ");
        harness.check(Long.parseLong("-11", 8), Long.parseLong("-9"), "parseLong octal negative");
        harness.check(Long.valueOf("11", 8), Long.valueOf("9"), "valueOf octal ");
        harness.check(Long.valueOf("-11", 8), Long.valueOf("-9"), "valueOf octal negative");
        harness.check(Long.parseLong("11", 16), Long.parseLong("17"), "parseLong hex ");
        harness.check(Long.parseLong("-11", 16), Long.parseLong("-17"), "parseLong hex negative");
        harness.check(Long.valueOf("11", 16), Long.valueOf("17"), "valueOf hex ");
        harness.check(Long.valueOf("-11", 16), Long.valueOf("-17"), "valueOf hex negative");
        harness.check(Long.parseLong("f", 16), Long.parseLong("15"), "parseLong hex ");
        harness.check(Long.parseLong("-f", 16), Long.parseLong("-15"), "parseLong hex negative");
        harness.check(Long.parseLong("F", 16), Long.parseLong("15"), "parseLong hex capital");
        harness.check(Long.valueOf("f", 16), Long.valueOf("15"), "valueOf hex ");
        harness.check(Long.valueOf("-f", 16), Long.valueOf("-15"), "valueOf hex negative");
        harness.check(Long.valueOf("F", 16), Long.valueOf("15"), "valueOf hex capital");
        harness.check(Long.parseLong("11", 25), Long.parseLong("26"), "parseLong 25-based ");
        harness.check(Long.parseLong("-11", 25), Long.parseLong("-26"), "parseLong 25-based negative");
        harness.check(Long.valueOf("11", 25), Long.valueOf("26"), "valueOf 25-based ");
        harness.check(Long.valueOf("-11", 25), Long.valueOf("-26"), "valueOf 25-based negative");
        harness.check(Long.parseLong("o", 25), Long.parseLong("24"), "parseLong 25-based ");
        harness.check(Long.parseLong("O", 25), Long.parseLong("24"), "parseLong 25-based capital");
        harness.check(Long.parseLong("-o", 25), Long.parseLong("-24"), "parseLong 25-based negative");
        harness.check(Long.valueOf("o", 25), Long.valueOf("24"), "valueOf 25-based ");
        harness.check(Long.valueOf("O", 25), Long.valueOf("24"), "valueOf 25-based capital");
        harness.check(Long.valueOf("-o", 25), Long.valueOf("-24"), "valueOf 25-based negative");
        harness.check(Long.parseLong("11", 36), Long.parseLong("37"), "parseLong 36-based ");
        harness.check(Long.parseLong("-11", 36), Long.parseLong("-37"), "parseLong 36-based negative");
        harness.check(Long.valueOf("11", 36), Long.valueOf("37"), "valueOf 36-based ");
        harness.check(Long.valueOf("-11", 36), Long.valueOf("-37"), "valueOf 36-based negative");
        harness.check(Long.parseLong("z", 36), Long.parseLong("35"), "parseLong 36-based ");
        harness.check(Long.parseLong("Z", 36), Long.parseLong("35"), "parseLong 36-based capital");
        harness.check(Long.parseLong("-z", 36), Long.parseLong("-35"), "parseLong 36-based negative");
        harness.check(Long.valueOf("z", 36), Long.valueOf("35"), "valueOf 36-based ");
        harness.check(Long.valueOf("Z", 36), Long.valueOf("35"), "valueOf 36-based capital");
        harness.check(Long.valueOf("-z", 36), Long.valueOf("-35"), "valueOf 36-based negative");
        this.parseCheckMustFail(" 78  ", 2);
        this.valueCheckMustFail(" 78  ", 2);
        this.parseCheckMustFail(" 78  ", 3);
        this.valueCheckMustFail(" 78  ", 3);
        this.parseCheckMustFail(" 78  ", 8);
        this.valueCheckMustFail(" 78  ", 8);
        this.parseCheckMustFail(" 78  ", 16);
        this.valueCheckMustFail(" 78  ", 16);
        this.parseCheckMustFail(" 78  ", 25);
        this.valueCheckMustFail(" 78  ", 25);
        this.parseCheckMustFail(" 78  ", 36);
        this.valueCheckMustFail(" 78  ", 36);
        this.parseCheckMustFail("11", 1);
        this.valueCheckMustFail("11", 1);
        this.parseCheckMustFail("11", 37);
        this.valueCheckMustFail("11", 37);
        this.parseCheckMustFail("3", 2);
        this.valueCheckMustFail("3", 2);
        this.parseCheckMustFail("5", 4);
        this.valueCheckMustFail("5", 4);
        this.parseCheckMustFail("9", 8);
        this.valueCheckMustFail("9", 8);
        this.parseCheckMustFail("g", 16);
        this.valueCheckMustFail("g", 16);
        this.parseCheckMustFail("z", 35);
        this.valueCheckMustFail("z", 35);
        this.parseCheckMustFail("1000000000000000000000000000000000000000000000000000000000000000", 2);
        this.valueCheckMustFail("1000000000000000000000000000000000000000000000000000000000000000", 2);
        this.parseCheckMustFail("1000000000000000000000", 8);
        this.valueCheckMustFail("1000000000000000000000", 8);
        this.parseCheckMustFail("8000000000000000", 16);
        this.valueCheckMustFail("8000000000000000", 16);
        this.parseCheckMustFail("8000000000000", 32);
        this.valueCheckMustFail("8000000000000", 32);
        this.parseCheckMustFail("-1000000000000000000000000000000000000000000000000000000000000001", 2);
        this.valueCheckMustFail("-1000000000000000000000000000000000000000000000000000000000000001", 2);
        this.parseCheckMustFail("-1000000000000000000001", 8);
        this.valueCheckMustFail("-1000000000000000000001", 8);
        this.parseCheckMustFail("-8000000000000001", 16);
        this.valueCheckMustFail("-8000000000000001", 16);
        this.parseCheckMustFail("-8000000000001", 32);
        this.valueCheckMustFail("-8000000000001", 32);
    }

    private final void parseCheckMustFail(String line, int radix) {
        try {
            Long.parseLong(line, radix);
            harness.fail("Attempt to parse illegal int string <" + line + '>');
        }
        catch (NumberFormatException e) {
            harness.check(true);
        }
    }

    private final void valueCheckMustFail(String line, int radix) {
        try {
            Long.valueOf(line, radix);
            harness.fail("Attempt to get value from illegal long string <" + line + '>');
        }
        catch (NumberFormatException e) {
            harness.check(true);
        }
    }

    public void testValueConversion() {
        Long zero = new Long(0L);
        Long along = new Long(97L);
        Long min = new Long(Long.MIN_VALUE);
        Long max = new Long(Long.MAX_VALUE);
        harness.checkPoint("Value conversins");
        boolean bl = false;
        if (zero.byteValue() == 0) {
            bl = true;
        }
        harness.check(bl);
        boolean bl2 = false;
        if (along.byteValue() == 97) {
            bl2 = true;
        }
        harness.check(bl2);
        boolean bl3 = false;
        if (along.byteValue() == (byte)along.longValue()) {
            bl3 = true;
        }
        harness.check(bl3);
        boolean bl4 = false;
        if (max.byteValue() == -1) {
            bl4 = true;
        }
        harness.check(bl4);
        boolean bl5 = false;
        if (min.byteValue() == 0) {
            bl5 = true;
        }
        harness.check(bl5);
        boolean bl6 = false;
        if (zero.shortValue() == 0) {
            bl6 = true;
        }
        harness.check(bl6);
        boolean bl7 = false;
        if (along.shortValue() == 97) {
            bl7 = true;
        }
        harness.check(bl7);
        boolean bl8 = false;
        if (along.shortValue() == (short)along.longValue()) {
            bl8 = true;
        }
        harness.check(bl8);
        boolean bl9 = false;
        if (max.shortValue() == -1) {
            bl9 = true;
        }
        harness.check(bl9);
        boolean bl10 = false;
        if (min.shortValue() == 0) {
            bl10 = true;
        }
        harness.check(bl10);
        boolean bl11 = false;
        if (zero.intValue() == 0) {
            bl11 = true;
        }
        harness.check(bl11);
        boolean bl12 = false;
        if (along.intValue() == 97) {
            bl12 = true;
        }
        harness.check(bl12);
        boolean bl13 = false;
        if (max.intValue() == -1) {
            bl13 = true;
        }
        harness.check(bl13);
        boolean bl14 = false;
        if (min.intValue() == 0) {
            bl14 = true;
        }
        harness.check(bl14);
        boolean bl15 = false;
        if (zero == 0L) {
            bl15 = true;
        }
        harness.check(bl15);
        boolean bl16 = false;
        if (along == 97L) {
            bl16 = true;
        }
        harness.check(bl16);
        boolean bl17 = false;
        if (along.longValue() == along.longValue()) {
            bl17 = true;
        }
        harness.check(bl17);
        boolean bl18 = false;
        if (max == Long.MAX_VALUE) {
            bl18 = true;
        }
        harness.check(bl18);
        boolean bl19 = false;
        if (min == Long.MIN_VALUE) {
            bl19 = true;
        }
        harness.check(bl19);
        boolean bl20 = false;
        if (zero.floatValue() == 0.0f) {
            bl20 = true;
        }
        harness.check(bl20);
        boolean bl21 = false;
        if (along.floatValue() == 97.0f) {
            bl21 = true;
        }
        harness.check(bl21);
        boolean bl22 = false;
        if (along.floatValue() == (float)along.longValue()) {
            bl22 = true;
        }
        harness.check(bl22);
        boolean bl23 = false;
        if (max.floatValue() == 9.223372E18f) {
            bl23 = true;
        }
        harness.check(bl23);
        boolean bl24 = false;
        if (min.floatValue() == -9.223372E18f) {
            bl24 = true;
        }
        harness.check(bl24);
        harness.check(zero.doubleValue(), 0.0);
        harness.check(along.doubleValue(), 97.0);
        harness.check(along.doubleValue(), (double)along.longValue());
        harness.check(max.doubleValue(), 9.223372036854776E18);
        harness.check(min.doubleValue(), -9.223372036854776E18);
    }

    public void testProperties() {
        harness.checkPoint("getLong(java.lang.String)long");
        Properties p = System.getProperties();
        p.put("along", "97");
        p.put("zero", "0");
        p.put("newa", "97");
        Long along = new Long(97L);
        harness.check(Long.getLong("along"), along);
        harness.check(Long.getLong("zero"), new Long(0L));
        boolean bl = false;
        if (Long.getLong("along") == Long.getLong("newa")) {
            bl = true;
        }
        harness.check(bl);
        boolean bl2 = false;
        if (Long.getLong("along") != Long.getLong("zero")) {
            bl2 = true;
        }
        harness.check(bl2);
        boolean bl3 = false;
        if (Long.getLong("blong") == null) {
            bl3 = true;
        }
        harness.check(bl3);
        harness.check(Long.getLong("clong", 97L), along);
        harness.check(Long.getLong("dlong", along), along);
    }

    public void testHashCode() {
        Long a = new Long(97L);
        long blong = 1311768467463790320L;
        Long b = new Long(blong);
        Long zero = new Long(0L);
        Long newa = new Long(97L);
        harness.checkPoint("hashCode()int");
        harness.check(a.hashCode(), newa.hashCode());
        harness.check(a.hashCode(), 97);
        harness.check(b.hashCode(), (int)(blong ^ blong >>> 32));
        harness.check(zero.hashCode(), 0);
    }

    public void testGetClass() {
        Long a = new Long(97L);
        Long b = new Long(0L);
        Integer i = new Integer(0);
        Long c = new Long(1311768467463790320L);
        harness.checkPoint("TYPE(public)java.lang.Class");
        try {
            harness.check(a instanceof Long);
            harness.check(b instanceof Long);
            harness.check(a.getClass().getName(), (Object)"java.lang.Long");
            harness.check(b.getClass().getName(), (Object)"java.lang.Long");
            harness.check(a.getClass(), Class.forName("java.lang.Long"));
            harness.check(b.getClass(), Class.forName("java.lang.Long"));
            boolean bl = false;
            if (i.getClass() != Class.forName("java.lang.Long")) {
                bl = true;
            }
            harness.check(bl);
            harness.check(a.getClass(), b.getClass());
            boolean bl2 = false;
            if (a.getClass() != i.getClass()) {
                bl2 = true;
            }
            harness.check(bl2);
            harness.check(Long.TYPE.getName(), (Object)"long");
        }
        catch (ClassNotFoundException e) {
            harness.fail("error finding class name");
            harness.debug(e);
        }
    }

    public void test(TestHarness newharness) {
        harness = newharness;
        harness.setclass("java.lang.Long");
        int i = 45;
        int j = -999;
        harness.check(j / i, -22, "-999 / 45 = -22");
        j = 999;
        harness.check(j / i, 22, " 999 / 45 =  22");
        i = -45;
        harness.check(j / i, -22, " 999 /-45 = -22");
        j = -999;
        harness.check(j / i, 22, "-999 /-45 =  22");
        this.testConstructors();
        this.testCompare();
        this.testStringConversion();
        this.testStringValueParsing();
        this.testValueConversion();
        this.testHashCode();
        this.testGetClass();
    }
}

