/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.Integer;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.Properties;

public class IntegerTest
implements Testlet {
    protected static TestHarness harness;

    public void testConstructors() {
        harness.checkPoint("Integer(int)");
        Integer a = new Integer(0);
        Integer b = new Integer(1);
        Integer c = new Integer(0);
        Integer d = a;
        Integer e = new Integer(14);
        int fint = 102;
        Integer f = new Integer(fint);
        Integer g = new Integer(97);
        Long l = new Long(0L);
        harness.checkPoint("equals(java.lang.Object)boolean");
        boolean bl = false;
        if (a != null) {
            bl = true;
        }
        harness.check(bl);
        harness.check(a.equals(null) ^ true);
        boolean bl2 = false;
        if (a != b) {
            bl2 = true;
        }
        harness.check(bl2);
        harness.check(a.equals(b) ^ true);
        boolean bl3 = false;
        if (a != c) {
            bl3 = true;
        }
        harness.check(bl3);
        harness.check(a.equals(c));
        boolean bl4 = false;
        if (a == d) {
            bl4 = true;
        }
        harness.check(bl4);
        harness.check(a.equals(d));
        boolean bl5 = false;
        if (a == a) {
            bl5 = true;
        }
        harness.check(bl5);
        harness.check(a.equals(l) ^ true);
        harness.checkPoint("intValue()int");
        harness.check(a, 0);
        harness.check(a, a);
        harness.check(a, c);
        harness.check(a, d);
        harness.check(a, l.intValue());
        harness.check(b, 1);
        harness.check(e, 14);
        harness.check(f, fint);
        harness.check(g, 97);
        harness.check(g, 97);
        harness.check(g, 97);
        harness.checkPoint("MAX_VALUE(public)int");
        harness.check(Integer.MAX_VALUE, Integer.MAX_VALUE);
        harness.checkPoint("MIN_VALUE(public)int");
        harness.check(Integer.MIN_VALUE, Integer.MIN_VALUE);
        harness.checkPoint("Integer(java.lang.String)");
        this.constructMustSucceed("1", 1);
        this.constructMustSucceed("2147483647", Integer.MAX_VALUE);
        this.constructMustSucceed("-2147483648", Integer.MIN_VALUE);
        this.constructMustFail("2147483648");
        this.constructMustFail("-2147483649");
        this.constructMustFail("0x77");
        this.constructMustFail("#77");
        this.constructMustFail("4f");
        this.constructMustFail("0x4f");
        this.constructMustFail(" ");
        this.constructMustFail("");
        this.constructMustFail(null);
    }

    private final void constructMustSucceed(String line, int expected) {
        try {
            Integer constructed = new Integer(line);
            harness.check(constructed, expected);
        }
        catch (NumberFormatException e) {
            harness.fail("Could not construct desired value <" + line + '>');
        }
    }

    private final void constructMustFail(String line) {
        try {
            new Integer(line);
            harness.fail("Attempt to construct out-of-range integer < " + line + " > ");
        }
        catch (Exception e) {
            harness.check(true);
        }
    }

    public void testCompare() {
        Comparable<Character> cha2;
        Number cha1;
        harness.checkPoint("compareTo(java.lang.Object)int");
        this.checkCompare(100, 101);
        this.checkCompare(0, 101);
        this.checkCompare(-101, -100);
        this.checkCompare(-100, 0);
        this.checkCompare(-101, 100);
        this.checkCompare(0x7FFFFFF0, Integer.MAX_VALUE);
        this.checkCompare(Integer.MIN_VALUE, -2147483632);
        try {
            cha1 = new Integer(-9359);
            boolean bl = false;
            if (((Integer)cha1).compareTo(new Integer(-9359)) == 0) {
                bl = true;
            }
            harness.check(bl);
        }
        catch (ClassCastException e) {
            harness.fail("Exception comparing two instances of class Byte ");
        }
        try {
            cha1 = new Integer(97);
            cha2 = new Character('a');
            ((Integer)cha1).compareTo(cha2);
            harness.fail("Attempt to compare two different objects ");
        }
        catch (ClassCastException e) {
            harness.check(true);
        }
        try {
            cha1 = new Long(97L);
            cha2 = new Integer(97);
            ((Long)cha1).compareTo(cha2);
            harness.fail("Attempt to compare two different objects ");
        }
        catch (ClassCastException e) {
            harness.check(true);
        }
    }

    private final void checkCompare(int smallvalue, int bigvalue) {
        try {
            Integer smallint = new Integer(smallvalue);
            Integer bigint = new Integer(bigvalue);
            if (smallint.compareTo(bigint) > 0) {
                harness.fail("compareTo detected <" + smallvalue + "> bigger then <" + bigvalue + '>');
            } else if (smallint.compareTo(bigint) == 0) {
                harness.fail("compareTo detected <" + smallvalue + "> equal to <" + bigvalue + '>');
            } else {
                harness.check(true);
            }
            if (bigint.compareTo(smallint) < 0) {
                harness.fail("compareTo detected <" + bigvalue + "> smaller then <" + smallvalue + '>');
            } else if (bigint.compareTo(smallint) == 0) {
                harness.fail("compareTo detected <" + bigvalue + "> equal to <" + smallvalue + '>');
            } else {
                harness.check(true);
            }
            if (smallint.compareTo(smallint) != 0) {
                harness.fail("compareTo detected <" + smallvalue + "> not equal to itselves");
            } else {
                harness.check(true);
            }
            if (bigint.compareTo(bigint) != 0) {
                harness.fail("compareTo detected <" + bigvalue + "> not equal to itselves");
            } else {
                harness.check(true);
            }
        }
        catch (Exception e) {
            harness.fail("Exception while comparing <" + smallvalue + "> and <" + bigvalue + '>');
        }
    }

    public void testStringConversion() {
        harness.checkPoint("toString(int)java.lang.String");
        int aint = 97;
        int zeroint = 0;
        int negint = -97;
        Integer a = new Integer(aint);
        Integer zero = new Integer(0);
        Integer negative = new Integer(negint);
        String astring = "97";
        String negstring = "-97";
        harness.check(zero.toString(), (Object)"0");
        harness.check(Integer.toString(zeroint), (Object)"0");
        harness.check(a.toString(), (Object)astring);
        harness.check(a.toString(), (Object)Integer.toString(aint));
        harness.check(negative.toString(), (Object)"-97");
        harness.check(negative.toString(), (Object)Integer.toString(negint));
        harness.checkPoint("toBinaryString(int)java.lang.String");
        harness.check(Integer.toBinaryString(0), (Object)"0");
        harness.check(Integer.toBinaryString(1), (Object)"1");
        harness.check(Integer.toBinaryString(3), (Object)"11");
        harness.check(Integer.toBinaryString(-1), (Object)"11111111111111111111111111111111");
        harness.check(Integer.toBinaryString(358).equals("101100110"));
        harness.check(Integer.toBinaryString(-5478).equals("11111111111111111110101010011010"));
        harness.checkPoint("toOctalString(int)java.lang.String");
        harness.check(Integer.toOctalString(0), (Object)"0");
        harness.check(Integer.toOctalString(1), (Object)"1");
        harness.check(Integer.toOctalString(9), (Object)"11");
        harness.check(Integer.toOctalString(-1), (Object)"37777777777");
        harness.check(Integer.toOctalString(5847).equals("13327"));
        harness.check(Integer.toOctalString(-9863).equals("37777754571"));
        harness.checkPoint("toHexString(int)java.lang.String");
        harness.check(Integer.toHexString(0), (Object)"0");
        harness.check(Integer.toHexString(1), (Object)"1");
        harness.check(Integer.toHexString(17), (Object)"11");
        harness.check(Integer.toHexString(31), (Object)"1f");
        harness.check(Integer.toHexString(-1), (Object)"ffffffff");
        harness.checkPoint("toString(int,int)java.lang.String");
        harness.check(Integer.toString(aint, 2), (Object)Integer.toBinaryString(aint));
        harness.check(Integer.toString(aint, 8), (Object)Integer.toOctalString(aint));
        harness.check(Integer.toString(aint, 10), (Object)Integer.toString(aint));
        harness.check(Integer.toString(aint, 16), (Object)Integer.toHexString(aint));
        harness.check(Integer.toString(aint, 1), (Object)Integer.toString(aint));
        harness.check(Integer.toString(aint, 37), (Object)Integer.toString(aint));
        harness.check(Integer.toString(4, 3), (Object)"11");
        harness.check(Integer.toString(11, 11), (Object)"10");
        harness.check(Integer.toString(21, 11), (Object)"1a");
        harness.check(Integer.toString(21, 20), (Object)"11");
        harness.check(Integer.toString(20, 20), (Object)"10");
        harness.check(Integer.toString(39, 20), (Object)"1j");
        harness.check(Integer.toString(37, 36), (Object)"11");
        harness.check(Integer.toString(36, 36), (Object)"10");
        harness.check(Integer.toString(71, 36), (Object)"1z");
        harness.checkPoint("decode(java.lang.String)java.lang.Integer");
        this.decodeMustPass("11", 11);
        this.decodeMustPass("011", 9);
        this.decodeMustPass("#11", 17);
        this.decodeMustPass("0x11", 17);
        this.decodeMustPass("0x1F", 31);
        this.decodeMustPass("0x1f", 31);
        this.decodeMustPass("0", 0);
        this.decodeMustPass("-11", -11);
        this.decodeMustPass("-011", -9);
        this.decodeMustFail("0-11");
        this.decodeMustPass("-#11", -17);
        this.decodeMustFail("#-11");
        this.decodeMustPass("-0x11", -17);
        this.decodeMustFail("0x-11");
        this.decodeMustPass("0x7fffffff", Integer.MAX_VALUE);
        this.decodeMustPass("0x7FFFFFFF", Integer.MAX_VALUE);
        this.decodeMustFail("0x80000000");
        this.decodeMustFail("-0x80000001");
        this.decodeMustFail("019");
        this.decodeMustFail("122.5");
        this.decodeMustFail("4F");
        this.decodeMustFail("#4G");
        this.decodeMustFail("0x4G");
        this.decodeMustFail(" 11");
        this.decodeMustFail(" ");
        this.decodeMustFail("");
        this.decodeMustFail(null);
    }

    private final void decodeMustPass(String line, int checkvalue) {
        try {
            Integer decoded = Integer.decode(line);
            harness.check(decoded, checkvalue);
        }
        catch (Exception e) {
            harness.fail("Exception while trying to decode string <" + line + ">\n" + e);
        }
    }

    private final void decodeMustFail(String line) {
        try {
            Integer.decode(line);
            harness.fail("Attempt to decode illegal string format <" + line + '>');
        }
        catch (Exception e) {
            harness.check(true);
        }
    }

    public void testStringValueParsing() {
        String astring = new String("100");
        Integer target = new Integer(100);
        harness.checkPoint("parseInt(java.lang.String)int");
        harness.check(Integer.parseInt(astring), 100);
        harness.check(Integer.valueOf(astring).equals(target));
        harness.check(Integer.parseInt("0"), 0);
        harness.check(Integer.parseInt("-34"), -34);
        harness.check(Integer.valueOf("-56").equals(new Integer(-56)));
        harness.check(Integer.parseInt("2147483647"), Integer.MAX_VALUE);
        harness.check(Integer.valueOf("2147483647").equals(new Integer(Integer.MAX_VALUE)));
        harness.check(Integer.parseInt("-2147483648"), Integer.MIN_VALUE);
        harness.check(Integer.valueOf("-2147483648").equals(new Integer(Integer.MIN_VALUE)));
        harness.checkPoint("valueOf(java.lang.String)java.lang.Integer");
        this.parseCheckMustFail("2147483648", 10);
        this.valueCheckMustFail("-2147483649", 10);
        this.parseCheckMustFail("0x60", 10);
        this.valueCheckMustFail("0x60", 10);
        this.parseCheckMustFail(" 11  ", 10);
        this.valueCheckMustFail(" 11  ", 10);
        this.parseCheckMustFail(" ", 10);
        this.valueCheckMustFail(" ", 10);
        this.parseCheckMustFail("", 10);
        this.valueCheckMustFail("", 10);
        this.parseCheckMustFail(null, 10);
        this.valueCheckMustFail(null, 10);
        harness.check(Integer.parseInt("12", 10), Integer.parseInt("12"));
        harness.check(Integer.parseInt("-34", 10), Integer.parseInt("-34"));
        harness.check(Integer.valueOf("56", 10), Integer.valueOf("56"));
        harness.check(Integer.valueOf("-78", 10), Integer.valueOf("-78"));
        harness.check(Integer.parseInt("11", 2), Integer.parseInt("3"), "parseInt binary ");
        harness.check(Integer.parseInt("-11", 2), Integer.parseInt("-3"), "parseInt binary negative");
        harness.check(Integer.valueOf("11", 2), Integer.valueOf("3"), "valueOf binary ");
        harness.check(Integer.valueOf("-11", 2), Integer.valueOf("-3"), "valueOf binary negative");
        harness.check(Integer.parseInt("11", 3), Integer.parseInt("4"), "parseInt 3-based ");
        harness.check(Integer.parseInt("-11", 3), Integer.parseInt("-4"), "parseInt 3-based negative");
        harness.check(Integer.valueOf("11", 3), Integer.valueOf("4"), "valueOf 3-based ");
        harness.check(Integer.valueOf("-11", 3), Integer.valueOf("-4"), "valueOf 3-based negative");
        harness.check(Integer.parseInt("11", 8), Integer.parseInt("9"), "parseInt octal ");
        harness.check(Integer.parseInt("-11", 8), Integer.parseInt("-9"), "parseInt octal negative");
        harness.check(Integer.valueOf("11", 8), Integer.valueOf("9"), "valueOf octal ");
        harness.check(Integer.valueOf("-11", 8), Integer.valueOf("-9"), "valueOf octal negative");
        harness.check(Integer.parseInt("11", 16), Integer.parseInt("17"), "parseInt hex ");
        harness.check(Integer.parseInt("-11", 16), Integer.parseInt("-17"), "parseInt hex negative");
        harness.check(Integer.valueOf("11", 16), Integer.valueOf("17"), "valueOf hex ");
        harness.check(Integer.valueOf("-11", 16), Integer.valueOf("-17"), "valueOf hex negative");
        harness.check(Integer.parseInt("f", 16), Integer.parseInt("15"), "parseInt hex ");
        harness.check(Integer.parseInt("-f", 16), Integer.parseInt("-15"), "parseInt hex negative");
        harness.check(Integer.parseInt("F", 16), Integer.parseInt("15"), "parseInt hex capital");
        harness.check(Integer.valueOf("f", 16), Integer.valueOf("15"), "valueOf hex ");
        harness.check(Integer.valueOf("-f", 16), Integer.valueOf("-15"), "valueOf hex negative");
        harness.check(Integer.valueOf("F", 16), Integer.valueOf("15"), "valueOf hex capital");
        harness.check(Integer.parseInt("11", 25), Integer.parseInt("26"), "parseInt 25-based ");
        harness.check(Integer.parseInt("-11", 25), Integer.parseInt("-26"), "parseInt 25-based negative");
        harness.check(Integer.valueOf("11", 25), Integer.valueOf("26"), "valueOf 25-based ");
        harness.check(Integer.valueOf("-11", 25), Integer.valueOf("-26"), "valueOf 25-based negative");
        harness.check(Integer.parseInt("o", 25), Integer.parseInt("24"), "parseInt 25-based ");
        harness.check(Integer.parseInt("O", 25), Integer.parseInt("24"), "parseInt 25-based capital");
        harness.check(Integer.parseInt("-o", 25), Integer.parseInt("-24"), "parseInt 25-based negative");
        harness.check(Integer.valueOf("o", 25), Integer.valueOf("24"), "valueOf 25-based ");
        harness.check(Integer.valueOf("O", 25), Integer.valueOf("24"), "valueOf 25-based capital");
        harness.check(Integer.valueOf("-o", 25), Integer.valueOf("-24"), "valueOf 25-based negative");
        harness.check(Integer.parseInt("11", 36), Integer.parseInt("37"), "parseInt 36-based ");
        harness.check(Integer.parseInt("-11", 36), Integer.parseInt("-37"), "parseInt 36-based negative");
        harness.check(Integer.valueOf("11", 36), Integer.valueOf("37"), "valueOf 36-based ");
        harness.check(Integer.valueOf("-11", 36), Integer.valueOf("-37"), "valueOf 36-based negative");
        harness.check(Integer.parseInt("z", 36), Integer.parseInt("35"), "parseInt 36-based ");
        harness.check(Integer.parseInt("Z", 36), Integer.parseInt("35"), "parseInt 36-based capital");
        harness.check(Integer.parseInt("-z", 36), Integer.parseInt("-35"), "parseInt 36-based negative");
        harness.check(Integer.valueOf("z", 36), Integer.valueOf("35"), "valueOf 36-based ");
        harness.check(Integer.valueOf("Z", 36), Integer.valueOf("35"), "valueOf 36-based capital");
        harness.check(Integer.valueOf("-z", 36), Integer.valueOf("-35"), "valueOf 36-based negative");
        this.parseCheckMustFail(" 11  ", 2);
        this.valueCheckMustFail(" 11  ", 2);
        this.parseCheckMustFail(" 11  ", 3);
        this.valueCheckMustFail(" 11  ", 3);
        this.parseCheckMustFail(" 11  ", 8);
        this.valueCheckMustFail(" 11  ", 8);
        this.parseCheckMustFail(" 11  ", 16);
        this.valueCheckMustFail(" 11  ", 16);
        this.parseCheckMustFail(" 11  ", 25);
        this.valueCheckMustFail(" 11  ", 25);
        this.parseCheckMustFail(" 11  ", 36);
        this.valueCheckMustFail(" 11  ", 36);
        this.parseCheckMustFail("11", 1);
        this.valueCheckMustFail("11", 1);
        this.parseCheckMustFail("11", 37);
        this.valueCheckMustFail("11", 37);
        this.parseCheckMustFail("3", 2);
        this.valueCheckMustFail("3", 2);
        this.parseCheckMustFail("5", 4);
        this.valueCheckMustFail("5", 4);
        this.parseCheckMustFail("9", 8);
        this.valueCheckMustFail("9", 8);
        this.parseCheckMustFail("g", 16);
        this.valueCheckMustFail("g", 16);
        this.parseCheckMustFail("z", 35);
        this.valueCheckMustFail("z", 35);
        this.parseCheckMustFail("10000000000000000000000000000000", 2);
        this.valueCheckMustFail("10000000000000000000000000000000", 2);
        this.parseCheckMustFail("20000000000", 8);
        this.valueCheckMustFail("20000000000", 8);
        this.parseCheckMustFail("80000000", 16);
        this.valueCheckMustFail("80000000", 16);
        this.parseCheckMustFail("4000000", 32);
        this.valueCheckMustFail("4000000", 32);
        this.parseCheckMustFail("-10000000000000000000000000000001", 2);
        this.valueCheckMustFail("-10000000000000000000000000000001", 2);
        this.parseCheckMustFail("-20000000001", 8);
        this.valueCheckMustFail("-20000000001", 8);
        this.parseCheckMustFail("-80000001", 16);
        this.valueCheckMustFail("-80000001", 16);
        this.parseCheckMustFail("-4000001", 32);
        this.valueCheckMustFail("-4000001", 32);
    }

    private final void parseCheckMustFail(String line, int radix) {
        try {
            Integer.parseInt(line, radix);
            harness.fail("Attempt to parse illegal int string <" + line + '>');
        }
        catch (NumberFormatException e) {
            harness.check(true);
        }
    }

    private final void valueCheckMustFail(String line, int radix) {
        try {
            Integer.valueOf(line, radix);
            harness.fail("Attempt to get value from illegal int string <" + line + '>');
        }
        catch (NumberFormatException e) {
            harness.check(true);
        }
    }

    public void testValueConversion() {
        Integer zero = new Integer(0);
        Integer aint = new Integer(97);
        Integer min = new Integer(Integer.MIN_VALUE);
        Integer max = new Integer(Integer.MAX_VALUE);
        harness.checkPoint("Value conversions");
        boolean bl = false;
        if (zero.byteValue() == 0) {
            bl = true;
        }
        harness.check(bl);
        boolean bl2 = false;
        if (aint.byteValue() == 97) {
            bl2 = true;
        }
        harness.check(bl2);
        boolean bl3 = false;
        if (aint.byteValue() == (byte)aint.intValue()) {
            bl3 = true;
        }
        harness.check(bl3);
        boolean bl4 = false;
        if (max.byteValue() == -1) {
            bl4 = true;
        }
        harness.check(bl4);
        boolean bl5 = false;
        if (min.byteValue() == 0) {
            bl5 = true;
        }
        harness.check(bl5);
        boolean bl6 = false;
        if (zero.shortValue() == 0) {
            bl6 = true;
        }
        harness.check(bl6);
        boolean bl7 = false;
        if (aint.shortValue() == 97) {
            bl7 = true;
        }
        harness.check(bl7);
        boolean bl8 = false;
        if (aint.shortValue() == (short)aint.intValue()) {
            bl8 = true;
        }
        harness.check(bl8);
        boolean bl9 = false;
        if (max.shortValue() == -1) {
            bl9 = true;
        }
        harness.check(bl9);
        boolean bl10 = false;
        if (min.shortValue() == 0) {
            bl10 = true;
        }
        harness.check(bl10);
        boolean bl11 = false;
        if (zero == 0) {
            bl11 = true;
        }
        harness.check(bl11);
        boolean bl12 = false;
        if (aint == 97) {
            bl12 = true;
        }
        harness.check(bl12);
        boolean bl13 = false;
        if (max == Integer.MAX_VALUE) {
            bl13 = true;
        }
        harness.check(bl13);
        boolean bl14 = false;
        if (min == Integer.MIN_VALUE) {
            bl14 = true;
        }
        harness.check(bl14);
        boolean bl15 = false;
        if (zero.longValue() == 0L) {
            bl15 = true;
        }
        harness.check(bl15);
        boolean bl16 = false;
        if (aint.longValue() == 97L) {
            bl16 = true;
        }
        harness.check(bl16);
        boolean bl17 = false;
        if (aint.longValue() == (long)aint.intValue()) {
            bl17 = true;
        }
        harness.check(bl17);
        boolean bl18 = false;
        if (max.longValue() == Integer.MAX_VALUE) {
            bl18 = true;
        }
        harness.check(bl18);
        boolean bl19 = false;
        if (min.longValue() == Integer.MIN_VALUE) {
            bl19 = true;
        }
        harness.check(bl19);
        boolean bl20 = false;
        if (zero.floatValue() == 0.0f) {
            bl20 = true;
        }
        harness.check(bl20);
        boolean bl21 = false;
        if (aint.floatValue() == 97.0f) {
            bl21 = true;
        }
        harness.check(bl21);
        boolean bl22 = false;
        if (aint.floatValue() == (float)aint.intValue()) {
            bl22 = true;
        }
        harness.check(bl22);
        boolean bl23 = false;
        if (max.floatValue() == 2.1474836E9f) {
            bl23 = true;
        }
        harness.check(bl23);
        boolean bl24 = false;
        if (min.floatValue() == -2.1474836E9f) {
            bl24 = true;
        }
        harness.check(bl24);
        boolean bl25 = false;
        if (zero.doubleValue() == 0.0) {
            bl25 = true;
        }
        harness.check(bl25);
        boolean bl26 = false;
        if (aint.doubleValue() == 97.0) {
            bl26 = true;
        }
        harness.check(bl26);
        boolean bl27 = false;
        if (aint.doubleValue() == (double)aint.intValue()) {
            bl27 = true;
        }
        harness.check(bl27);
        boolean bl28 = false;
        if (max.doubleValue() == 2.147483647E9) {
            bl28 = true;
        }
        harness.check(bl28);
        boolean bl29 = false;
        if (min.doubleValue() == -2.147483648E9) {
            bl29 = true;
        }
        harness.check(bl29);
    }

    public void testProperties() {
        harness.checkPoint("getInteger(java.lang.String)int");
        Properties p = System.getProperties();
        p.put("aint", "97");
        p.put("zero", "0");
        p.put("newa", "97");
        Integer aint = new Integer(97);
        harness.check(Integer.getInteger("aint"), aint);
        harness.check(Integer.getInteger("zero"), new Integer(0));
        boolean bl = false;
        if (Integer.getInteger("aint") == Integer.getInteger("newa")) {
            bl = true;
        }
        harness.check(bl);
        boolean bl2 = false;
        if (Integer.getInteger("aint") != Integer.getInteger("zero")) {
            bl2 = true;
        }
        harness.check(bl2);
        boolean bl3 = false;
        if (Integer.getInteger("bint") == null) {
            bl3 = true;
        }
        harness.check(bl3);
        harness.check(Integer.getInteger("cint", 97), aint);
        harness.check(Integer.getInteger("dint", aint), aint);
    }

    public void testHashCode() {
        Integer a = new Integer(97);
        Integer b = new Integer(123456);
        Integer zero = new Integer(0);
        Integer newa = new Integer(97);
        harness.checkPoint("hashCode()int");
        harness.check(a.hashCode(), newa.hashCode());
        harness.check(a.hashCode(), 97);
        harness.check(b.hashCode(), 123456);
        harness.check(zero.hashCode(), 0);
        boolean bl = false;
        if (a.hashCode() != b.hashCode()) {
            bl = true;
        }
        harness.check(bl);
    }

    public void testGetClass() {
        Integer a = new Integer(97);
        Integer b = new Integer(0);
        Long l = new Long(0L);
        harness.checkPoint("TYPE(public)java.lang.Class");
        try {
            harness.check(a instanceof Integer);
            harness.check(b instanceof Integer);
            harness.check(a.getClass().getName(), (Object)"java.lang.Integer");
            harness.check(b.getClass().getName(), (Object)"java.lang.Integer");
            harness.check(a.getClass(), Class.forName("java.lang.Integer"));
            harness.check(b.getClass(), Class.forName("java.lang.Integer"));
            boolean bl = false;
            if (l.getClass() != Class.forName("java.lang.Integer")) {
                bl = true;
            }
            harness.check(bl);
            harness.check(a.getClass(), b.getClass());
            boolean bl2 = false;
            if (a.getClass() != l.getClass()) {
                bl2 = true;
            }
            harness.check(bl2);
            harness.check(Integer.TYPE.getName(), (Object)"int");
        }
        catch (ClassNotFoundException e) {
            harness.fail("error finding class name");
            harness.debug(e);
        }
    }

    public void test(TestHarness newharness) {
        harness = newharness;
        harness.setclass("java.lang.Integer");
        this.testConstructors();
        this.testCompare();
        this.testStringConversion();
        this.testStringValueParsing();
        this.testValueConversion();
        this.testHashCode();
        this.testGetClass();
    }
}

