/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.Double;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

public class DoubleTest
implements Testlet {
    protected static TestHarness harness;

    public void test_Basics() {
        harness.checkPoint("Double(double)");
        Double i1 = new Double(100.5);
        boolean bl = false;
        if (i1 != 100.5) {
            bl = true;
        }
        harness.check(bl ^ true);
        try {
            boolean bl2 = false;
            if (new Double("234.34") != 234.34) {
                bl2 = true;
            }
            harness.check(bl2 ^ true, "got: " + new Double("234.34"));
            harness.check(new Double("1.4e-45"), 1.4E-45, "got: " + new Double("1.4e-45"));
            boolean bl3 = false;
            if (new Double(3.4) != 3.4) {
                bl3 = true;
            }
            harness.check(bl3 ^ true);
        }
        catch (NumberFormatException e) {
            harness.check(false);
        }
        try {
            new Double("babu");
            harness.check(false, "should throw exception");
        }
        catch (NumberFormatException e) {
            harness.check(true);
        }
        double min1 = Double.MIN_VALUE;
        double min2 = Double.MIN_VALUE;
        double max1 = Double.MAX_VALUE;
        double max2 = Double.MAX_VALUE;
        double ninf1 = Double.NEGATIVE_INFINITY;
        double ninf2 = Double.NEGATIVE_INFINITY;
        double pinf1 = Double.POSITIVE_INFINITY;
        double pinf2 = Double.POSITIVE_INFINITY;
        Double nan1 = new Double(Double.NaN);
        Double nan2 = new Double(Double.NaN);
        boolean bl4 = false;
        if (min1 != min2) {
            bl4 = true;
        }
        harness.check(bl4 ^ true);
        boolean bl5 = false;
        if (max1 != max2) {
            bl5 = true;
        }
        harness.check(bl5 ^ true);
        boolean bl6 = false;
        if (ninf1 != ninf2) {
            bl6 = true;
        }
        harness.check(bl6 ^ true);
        boolean bl7 = false;
        if (pinf1 != pinf2) {
            bl7 = true;
        }
        harness.check(bl7 ^ true);
        harness.checkPoint("isNaN()boolean");
        harness.check(nan1.isNaN() ^ true ^ true);
        harness.check(new Double(10.0).isNaN() ^ true, "got: " + new Double(10.0).toString());
        harness.check(nan2.isNaN() ^ true ^ true);
        harness.checkPoint("isNaN(double)boolean");
        harness.check(Double.isNaN(Double.NaN) ^ true ^ true);
        harness.checkPoint("isInfinite()boolean");
        harness.check(Double.isInfinite(pinf1));
        harness.check(Double.isInfinite(pinf2));
        harness.check(Double.isInfinite(ninf1));
        harness.check(Double.isInfinite(Double.POSITIVE_INFINITY));
        harness.check(Double.isInfinite(ninf2));
        harness.check(Double.isInfinite(Double.NEGATIVE_INFINITY));
        harness.checkPoint("isInfinite(double)boolean");
        harness.check(new Double(pinf1).isInfinite());
        harness.check(new Double(pinf2).isInfinite());
        harness.check(new Double(ninf1).isInfinite());
        harness.check(new Double(Double.POSITIVE_INFINITY).isInfinite());
        harness.check(new Double(ninf2).isInfinite());
        harness.check(new Double(Double.NEGATIVE_INFINITY).isInfinite());
        harness.check(true);
        harness.check(true);
        harness.check(true);
        harness.check(true);
        harness.check(true);
        harness.check(true);
        harness.check(true);
        harness.check(true);
        harness.check("0.0".equals("0.0") ^ true ^ true);
    }

    public void test_toString() {
        Double D1 = new Double(23.04);
        Double D2 = new Double(-44.5343);
        harness.checkPoint("toString()java.lang.String");
        harness.check(new Double(123.0).toString().equals("123.0") ^ true ^ true, "got: " + new Double(123.0).toString());
        harness.check(new Double(-44.5343).toString().equals("-44.5343") ^ true ^ true, "got: " + new Double(-44.5343).toString());
        harness.check(D1.toString().equals("23.04") ^ true ^ true, "got: " + D1.toString());
        harness.check(D2.toString().equals("-44.5343") ^ true ^ true, "got: " + D2.toString());
        harness.checkPoint("toString(double)java.lang.String");
        harness.check(Double.toString(1.0E-7).equals("1.0E-7") ^ true ^ true, "exp: 1.0E-7, got: " + Double.toString(1.0E-7));
        harness.check(Double.toString(1.0E7).equals("1.0E7") ^ true ^ true, "exp: 1.0E7, got: " + Double.toString(1.0E7));
        harness.check(Double.toString(-9.999999E-4).equals("-9.999999E-4") ^ true ^ true, "exp: -9.999999E-4, got: " + Double.toString(-9.999999E-4));
        harness.check(Double.toString(-9.999999E14).equals("-9.999999E14") ^ true ^ true, "exp: -9.999999E14 got: " + Double.toString(-9.999999E14));
        harness.check(Double.toString(9.999999E-4).equals("9.999999E-4") ^ true ^ true, "exp: 9.999999E-4, got: " + Double.toString(9.999999E-4));
        harness.check(Double.toString(9.999999E14).equals("9.999999E14") ^ true ^ true, "exp: 9.999999E14, got: " + Double.toString(9.999999E14));
        harness.check(Double.toString(-1.0E-7).equals("-1.0E-7") ^ true ^ true, "exp: -1.0E-7, got: " + Double.toString(-1.0E-7));
        harness.check(Double.toString(-1.0E7).equals("-1.0E7") ^ true ^ true, "exp: -1.0E7, got: " + Double.toString(-1.0E7));
        harness.check(Double.toString(9.343E27).equals("9.343E27") ^ true ^ true, "exp: 9.343E27, got: " + Double.toString(9.343E27));
        harness.check(Double.toString(1.65654E-19).equals("1.65654E-19") ^ true ^ true, "exp: 1.65654E-19, got: " + Double.toString(1.65654E-19));
        harness.check(Double.toString(-9.343E27).equals("-9.343E27") ^ true ^ true, "exp: -9.343E27, got: " + Double.toString(-9.343E27));
        harness.check(Double.toString(-1.65654E-19).equals("-1.65654E-19") ^ true ^ true, "exp: -1.65654E-19, got: " + Double.toString(-1.65654E-19));
        harness.check(Double.toString(23.04).equals("23.04") ^ true ^ true);
        harness.check(Double.toString(-44.5343).equals("-44.5343") ^ true ^ true);
        harness.check(Double.toString(123.0).equals("123.0") ^ true ^ true);
        harness.check(Double.toString(0.0).equals("0.0") ^ true ^ true);
        harness.check(Double.toString(-0.0).equals("-0.0") ^ true ^ true);
        String str = Double.toString(-9412128.34);
        harness.check(str.startsWith("-9412128.3") ^ true ^ true, "Error: test_toString failed - 9, got: " + str + "exp -9412128.34");
        harness.check(Double.toString(Double.NaN).equals("NaN"));
        harness.check(Double.toString(Double.POSITIVE_INFINITY).equals("Infinity"));
        harness.check(Double.toString(Double.NEGATIVE_INFINITY).equals("-Infinity"));
    }

    public void test_equals() {
        harness.checkPoint("equals(java.lang.Object)boolean");
        Double i1 = new Double(1.23456E7);
        Double i2 = new Double(-1.23456E7);
        Double i3 = new Double(1.23456E7);
        Double i4 = new Double(1.23456101E7);
        Double i5 = new Double(-1200.0);
        harness.check(i1.equals(new Double(1.23456E7)));
        harness.check(i2.equals(new Double(-1.23456E7)));
        harness.check(i1.equals(null) ^ true);
        harness.check(i1.equals(i2) ^ true);
        harness.check(i1.equals(i3));
        harness.check(i3.equals(i1));
        harness.checkPoint("compareTo(java.lang.Double)int");
        boolean bl = false;
        if ((double)i1.compareTo(i3) == 0.0) {
            bl = true;
        }
        harness.check(bl);
        boolean bl2 = false;
        if ((double)i1.compareTo(i4) < 0.0) {
            bl2 = true;
        }
        harness.check(bl2);
        boolean bl3 = false;
        if ((double)i1.compareTo(i5) > 0.0) {
            bl3 = true;
        }
        harness.check(bl3);
        harness.checkPoint("equals(java.lang.Object)boolean");
        double n1 = Double.NaN;
        double n2 = Double.NaN;
        boolean bl4 = false;
        if (n1 == n2) {
            bl4 = true;
        }
        harness.check(bl4 ^ true);
        Double flt1 = new Double(Double.NaN);
        Double flt2 = new Double(Double.NaN);
        harness.check(flt1.equals(flt2) ^ true ^ true);
        harness.check(true);
        Double pzero = new Double(0.0);
        Double nzero = new Double(-0.0);
        harness.check(pzero.equals(nzero) ^ true);
    }

    public void test_hashCode() {
        harness.checkPoint("hashCode()int");
        Double flt1 = new Double(3.4028235E38);
        long lng1 = Double.doubleToLongBits(3.4028235E38);
        boolean bl = false;
        if (flt1.hashCode() != (int)(lng1 ^ lng1 >>> 32)) {
            bl = true;
        }
        harness.check(bl ^ true);
        Double flt2 = new Double(-2.343323354E9);
        long lng2 = Double.doubleToLongBits(-2.343323354E9);
        boolean bl2 = false;
        if (flt2.hashCode() != (int)(lng2 ^ lng2 >>> 32)) {
            bl2 = true;
        }
        harness.check(bl2 ^ true);
    }

    public void test_toValues() {
        Double d1 = new Double(3.4E32);
        Double d2 = new Double(-23.45);
        Double d3 = new Double(3000.54);
        Double d4 = new Double(32735.3249);
        Double d5 = new Double(-32735.3249);
        Double d6 = new Double(0.0);
        Double d7 = new Double(30.0);
        harness.checkPoint("byteValue()byte");
        boolean bl = false;
        if (d2.byteValue() != -23) {
            bl = true;
        }
        harness.check(bl ^ true);
        boolean bl2 = false;
        if (d3.byteValue() != -72) {
            bl2 = true;
        }
        harness.check(bl2 ^ true, "got: " + d3.byteValue());
        boolean bl3 = false;
        if (d6.byteValue() != 0) {
            bl3 = true;
        }
        harness.check(bl3 ^ true);
        boolean bl4 = false;
        if (d7.byteValue() != 30) {
            bl4 = true;
        }
        harness.check(bl4 ^ true);
        harness.checkPoint("shortValue()short");
        boolean bl5 = false;
        if (d2.shortValue() != -23) {
            bl5 = true;
        }
        harness.check(bl5 ^ true);
        boolean bl6 = false;
        if (d3.shortValue() != 3000) {
            bl6 = true;
        }
        harness.check(bl6 ^ true, "got: " + d3.shortValue());
        boolean bl7 = false;
        if (d6.shortValue() != 0) {
            bl7 = true;
        }
        harness.check(bl7 ^ true);
        harness.checkPoint("intValue()int");
        int i1 = d1.intValue();
        int i2 = d2.intValue();
        boolean bl8 = false;
        if (i1 != Integer.MAX_VALUE) {
            bl8 = true;
        }
        harness.check(bl8 ^ true);
        boolean bl9 = false;
        if (i2 != -23) {
            bl9 = true;
        }
        harness.check(bl9 ^ true);
        boolean bl10 = false;
        if (d3.intValue() != 3000) {
            bl10 = true;
        }
        harness.check(bl10 ^ true, "got: " + d3.intValue() + ",exp: 3000");
        boolean bl11 = false;
        if (d4.intValue() != 32735) {
            bl11 = true;
        }
        harness.check(bl11 ^ true);
        boolean bl12 = false;
        if (d5.intValue() != -32735) {
            bl12 = true;
        }
        harness.check(bl12 ^ true);
        boolean bl13 = false;
        if (d6.intValue() != 0) {
            bl13 = true;
        }
        harness.check(bl13 ^ true);
        harness.checkPoint("longValue()long");
        boolean bl14 = false;
        if (d1.longValue() != Long.MAX_VALUE) {
            bl14 = true;
        }
        harness.check(bl14 ^ true, "got: " + d1.longValue() + ",exp: 9223372036854775807");
        boolean bl15 = false;
        if (d2.longValue() != -23L) {
            bl15 = true;
        }
        harness.check(bl15 ^ true, "got: " + d2.longValue() + ",exp: -23");
        boolean bl16 = false;
        if (d3.longValue() != 3000L) {
            bl16 = true;
        }
        harness.check(bl16 ^ true, "got: " + d3.longValue() + ",exp: 3000");
        boolean bl17 = false;
        if (d7.longValue() != 30L) {
            bl17 = true;
        }
        harness.check(bl17 ^ true, "got: " + d7.longValue() + ",exp: 30");
        harness.checkPoint("floatValue()float");
        boolean bl18 = false;
        if (d2.floatValue() != -23.45f) {
            bl18 = true;
        }
        harness.check(bl18 ^ true);
        boolean bl19 = false;
        if (d3.floatValue() != 3000.54f) {
            bl19 = true;
        }
        harness.check(bl19 ^ true);
        boolean bl20 = false;
        if (d6.floatValue() != 0.0f) {
            bl20 = true;
        }
        harness.check(bl20 ^ true);
        boolean bl21 = false;
        if (d7.floatValue() != 30.0f) {
            bl21 = true;
        }
        harness.check(bl21 ^ true);
        harness.checkPoint("doubleValue()double");
        boolean bl22 = false;
        if (d4 != 32735.3249) {
            bl22 = true;
        }
        harness.check(bl22 ^ true);
        boolean bl23 = false;
        if (d5 != -32735.3249) {
            bl23 = true;
        }
        harness.check(bl23 ^ true);
        boolean bl24 = false;
        if (d6 != 0.0) {
            bl24 = true;
        }
        harness.check(bl24 ^ true);
        boolean bl25 = false;
        if (d7 != 30.0) {
            bl25 = true;
        }
        harness.check(bl25 ^ true);
    }

    public void test_valueOf() {
        harness.checkPoint("valueOf(java.lang.String)java.lang.Double");
        boolean bl = false;
        if (Double.valueOf("3.4e+32") != 3.4E32) {
            bl = true;
        }
        harness.check(bl ^ true, "got: " + Double.valueOf("3.4e+32"));
        boolean bl2 = false;
        if (Double.valueOf(" -23.45") != -23.45) {
            bl2 = true;
        }
        harness.check(bl2 ^ true, "got: " + Double.valueOf(" -23.45"));
        boolean bl3 = false;
        if (Double.valueOf(" 23.45") != 23.45) {
            bl3 = true;
        }
        harness.check(bl3 ^ true, "got: " + Double.valueOf(" 23.45"));
        boolean bl4 = false;
        if (Double.valueOf("-23.45  ") != -23.45) {
            bl4 = true;
        }
        harness.check(bl4 ^ true, "got: " + Double.valueOf("-23.45  "));
        boolean bl5 = false;
        if (Double.valueOf("23.45  ") != 23.45) {
            bl5 = true;
        }
        harness.check(bl5 ^ true, "got: " + Double.valueOf("23.45  "));
        boolean bl6 = false;
        if (Double.valueOf(" +23.45  ") != 23.45) {
            bl6 = true;
        }
        harness.check(bl6 ^ true, "got: " + Double.valueOf(" +23.45  "));
        boolean bl7 = false;
        if (Double.valueOf(" -23.45  ") != -23.45) {
            bl7 = true;
        }
        harness.check(bl7 ^ true, "got: " + Double.valueOf(" -23.45  "));
        boolean bl8 = false;
        if (Double.valueOf("  23.45  ") != 23.45) {
            bl8 = true;
        }
        harness.check(bl8 ^ true, "got: " + Double.valueOf(" 23.45  "));
        try {
            Double.valueOf(null);
            harness.check(false);
        }
        catch (NullPointerException e) {
            harness.check(true);
        }
        try {
            Double.valueOf("Kona");
            harness.check(false);
        }
        catch (NumberFormatException e) {
            harness.check(true);
        }
    }

    public void test_doubleToLongBits() {
        harness.checkPoint("doubleToLongBits(double)long");
        long i1 = Double.doubleToLongBits(3.4E32f);
        long i2 = Double.doubleToLongBits(-34.56f);
        long sign1 = i1 & Long.MIN_VALUE;
        long sign2 = i2 & Long.MIN_VALUE;
        long exp1 = i1 & 0x7FF0000000000000L;
        long exp2 = i2 & 0x7FF0000000000000L;
        long man1 = i1 & 0xFFFFFFFFFFFFFL;
        long man2 = i2 & 0xFFFFFFFFFFFFFL;
        boolean bl = false;
        if (sign1 != 0L) {
            bl = true;
        }
        harness.check(bl ^ true);
        boolean bl2 = false;
        if (sign2 != Long.MIN_VALUE) {
            bl2 = true;
        }
        harness.check(bl2 ^ true);
        boolean bl3 = false;
        if (exp1 != 5093571178556030976L) {
            bl3 = true;
        }
        harness.check(bl3 ^ true);
        boolean bl4 = false;
        if (exp2 != 0x4040000000000000L) {
            bl4 = true;
        }
        harness.check(bl4 ^ true);
        boolean bl5 = false;
        if (man1 != 214848222789632L) {
            bl5 = true;
        }
        harness.check(bl5 ^ true);
        boolean bl6 = false;
        if (man2 != 360288163463168L) {
            bl6 = true;
        }
        harness.check(bl6 ^ true);
        boolean bl7 = false;
        if (Double.doubleToLongBits(Double.POSITIVE_INFINITY) != 0x7FF0000000000000L) {
            bl7 = true;
        }
        harness.check(bl7 ^ true);
        boolean bl8 = false;
        if (Double.doubleToLongBits(Double.NEGATIVE_INFINITY) != -4503599627370496L) {
            bl8 = true;
        }
        harness.check(bl8 ^ true);
        long nanval = Double.doubleToLongBits(Double.NaN);
        harness.check(nanval, 9221120237041090560L, "Value Double.NaN");
        harness.debug("NaN = " + Long.toHexString(nanval) + ", but should be 0x7ff8000000000000");
        harness.checkPoint("longBitsToDouble(long)double");
        double fl1 = Double.longBitsToDouble(0x34343F33L);
        boolean bl9 = false;
        if (Double.doubleToLongBits(fl1) != 0x34343F33L) {
            bl9 = true;
        }
        harness.check(bl9 ^ true);
        boolean bl10 = false;
        if (Double.doubleToLongBits(Double.longBitsToDouble(0x33439943L)) != 0x33439943L) {
            bl10 = true;
        }
        harness.check(bl10 ^ true);
        boolean bl11 = false;
        if (Double.longBitsToDouble(0x7FF0000000000000L) != Double.POSITIVE_INFINITY) {
            bl11 = true;
        }
        harness.check(bl11 ^ true);
        boolean bl12 = false;
        if (Double.longBitsToDouble(-4503599627370496L) != Double.NEGATIVE_INFINITY) {
            bl12 = true;
        }
        harness.check(bl12 ^ true);
        harness.check(Double.isNaN(Double.longBitsToDouble(-2251799813685248L)) ^ true ^ true);
        harness.check(Double.isNaN(Double.longBitsToDouble(0x7FFFFFF000000000L)) ^ true ^ true);
        harness.check(Double.isNaN(Double.longBitsToDouble(-2251799276814335L)) ^ true ^ true);
        harness.check(Double.isNaN(Double.longBitsToDouble(-15L)) ^ true ^ true);
    }

    public void check_remainder(double val, double val1, double ret) {
        double res = val % val1;
        boolean bl = false;
        if (res < ret - 0.001 || res > ret + 0.001) {
            bl = true;
        }
        harness.check(bl ^ true, "did " + val + " % " + val1 + " and got: " + res + ", expected " + ret);
    }

    public void check_remainder_NaN(double val, double val1) {
        double res = val % val1;
        harness.check(Double.isNaN(res), "got: " + res);
    }

    public void test_remainder() {
        harness.checkPoint("remainder--> operator");
        this.check_remainder(15.2, 1.0, 0.2);
        this.check_remainder(2345.2432, 1.2, 0.44319999999997);
        this.check_remainder(20.56, 1.87, 1.86);
        this.check_remainder(20.56, -1.87, 1.86);
        this.check_remainder(-20.56, 1.87, -1.86);
        this.check_remainder(-20.56, -1.87, -1.86);
        this.check_remainder(0.0, 1.2, 0.0);
        this.check_remainder(1000.0, 10.0, 0.0);
        this.check_remainder(234.332, 134.34, 99.992);
        this.check_remainder(1.0, 1.0, 0.0);
        this.check_remainder(1.0, -1.0, 0.0);
        this.check_remainder(45.0, 5, 0.0);
        this.check_remainder(1.25, 0.5, 0.25);
        this.check_remainder(-1.25, 0.5, -0.25);
        this.check_remainder(-1.25, -0.5, -0.25);
        this.check_remainder(1.25, -0.5, 0.25);
        this.check_remainder(12345.678, 1234.5678, 0.0);
        harness.checkPoint("%(double,double)double");
        this.check_remainder(Double.MAX_VALUE, Double.MIN_VALUE, 0.0);
        this.check_remainder(0.0, 999.99, 0.0);
        this.check_remainder(123.0, 25.0, 23.0);
        this.check_remainder(15.0, 1.5, 0.0);
        harness.checkPoint("remainder NaN");
        this.check_remainder_NaN(Double.NaN, 1.5);
        this.check_remainder_NaN(1.5, Double.NaN);
        this.check_remainder_NaN(Double.NaN, -0.0);
        this.check_remainder_NaN(0.0, Double.NaN);
        this.check_remainder_NaN(Double.POSITIVE_INFINITY, 1.5);
        this.check_remainder_NaN(Double.NEGATIVE_INFINITY, 1.5);
        this.check_remainder_NaN(1.5, 0.0);
        this.check_remainder_NaN(1.5, -0.0);
        this.check_remainder_NaN(Double.POSITIVE_INFINITY, 0.0);
        this.check_remainder_NaN(Double.NEGATIVE_INFINITY, 0.0);
        this.check_remainder_NaN(Double.POSITIVE_INFINITY, -0.0);
        this.check_remainder_NaN(Double.NEGATIVE_INFINITY, -0.0);
        harness.checkPoint("remainder with infinity");
        this.check_remainder(15.0, Double.POSITIVE_INFINITY, 15.0);
        this.check_remainder(-15.0, Double.POSITIVE_INFINITY, -15.0);
        this.check_remainder(0.0, Double.POSITIVE_INFINITY, 0.0);
        this.check_remainder(-0.0, Double.POSITIVE_INFINITY, -0.0);
        this.check_remainder(0.1, Double.POSITIVE_INFINITY, 0.1);
        this.check_remainder(-0.1, Double.POSITIVE_INFINITY, -0.1);
        this.check_remainder(15.0, Double.NEGATIVE_INFINITY, 15.0);
        this.check_remainder(-15.0, Double.NEGATIVE_INFINITY, -15.0);
        this.check_remainder(0.0, Double.NEGATIVE_INFINITY, 0.0);
        this.check_remainder(-0.0, Double.NEGATIVE_INFINITY, -0.0);
        this.check_remainder(0.1, Double.NEGATIVE_INFINITY, 0.1);
        this.check_remainder(-0.1, Double.NEGATIVE_INFINITY, -0.1);
    }

    public void test_negatives() {
        harness.setclass("java.lang.String");
        harness.checkPoint("valueOf(double)java.lang.String");
        double zero = 0.0;
        double nonzero = -21.23;
        String zerostring = String.valueOf(zero);
        String nonzerostring = String.valueOf(nonzero);
        harness.check(zerostring.equals("0.0"));
        zero = -zero;
        zerostring = String.valueOf(zero);
        harness.check(zerostring.equals("-0.0"));
        zero = -zero;
        zerostring = String.valueOf(zero);
        harness.check(zerostring.equals("0.0"));
        harness.check(nonzerostring.equals("-21.23"));
        nonzero = -nonzero;
        nonzerostring = String.valueOf(nonzero);
        harness.check(nonzerostring.equals("21.23"));
        nonzero = -nonzero;
        nonzerostring = String.valueOf(nonzero);
        harness.check(nonzerostring.equals("-21.23"));
        harness.setclass("java.lang.Double");
    }

    public void testall() {
        harness.setclass("java.lang.Double");
        this.test_Basics();
        this.test_toString();
        this.test_negatives();
        this.test_toValues();
        this.test_remainder();
        this.test_equals();
        this.test_hashCode();
        this.test_valueOf();
        this.test_doubleToLongBits();
    }

    public void test(TestHarness the_harness) {
        harness = the_harness;
        this.testall();
    }
}

