/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.Class;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.io.Serializable;
import java.util.Vector;

public class ClassTest
implements Cloneable,
Serializable,
Testlet {
    protected static TestHarness harness;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$Number;

    public void test_toString() {
        if (!this.getClass().toString().equals(this.getClass().isInterface() ? "interface " : "class " + this.getClass().getName())) {
            harness.fail("Error: toString returned wrong string");
        } else {
            harness.check(true);
        }
        if (!new Object().getClass().toString().equals("class java.lang.Object")) {
            harness.fail("Error: toString returned wrong string");
        } else {
            harness.check(true);
        }
        Class<Integer> ci = Integer.TYPE;
        harness.check(ci.toString().equals("int"));
        harness.check(ci.toString().equals(ci.getName()));
    }

    public void test_getName() {
        try {
            if (!new Vector().getClass().getName().equals("java.util.Vector")) {
                harness.fail("Error: getName returned wrong string - 1");
            } else {
                harness.check(true);
            }
            if (!new Object[3].getClass().getName().equals("[Ljava.lang.Object;")) {
                harness.fail("Error: getName returned wrong string - 2");
            } else {
                harness.check(true);
            }
            if (!new int[6][7][8].getClass().getName().equals("[[[I")) {
                harness.fail("Error: getName returned wrong string - 3");
            } else {
                harness.check(true);
            }
            Class<Float> ci = Float.TYPE;
            harness.check(ci.getName().equals("float"));
        }
        catch (Error e) {
            harness.fail("Error: getName failed  - 4");
        }
    }

    public void test_isInterface() {
        if (new Object().getClass().isInterface()) {
            harness.fail("Error: isInterface returned wrong result - 1");
        } else {
            harness.check(true);
        }
        if (this.getClass().isInterface()) {
            harness.fail("Error: isInterface returned wrong result - 2");
        } else {
            harness.check(true);
        }
        try {
            if (!Class.forName("java.lang.Cloneable").isInterface()) {
                harness.fail("Error: isInterface returned wrong result - 3");
            } else {
                harness.check(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void test_getSuperclass() {
        Class<?> clss;
        try {
            if (new Boolean(true).getClass().getSuperclass() != Class.forName("java.lang.Object")) {
                harness.fail("Error: getSuperclass returned wrong values - 1");
            } else {
                harness.check(true);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (new Object().getClass().getSuperclass() != null) {
            harness.fail("Error: getSuperclass returned wrong values - 2");
        } else {
            harness.check(true);
        }
        try {
            clss = Class.forName("[[I");
            if (clss.getSuperclass() != Class.forName("java.lang.Object")) {
                harness.fail(" Error : getSuperclass   failed - 3 ");
            } else {
                harness.check(true);
            }
        }
        catch (Exception e) {
            harness.fail(" Error: getSuperclass failed - 4");
        }
        try {
            clss = Class.forName("[D");
            if (clss.getSuperclass() != Class.forName("java.lang.Object")) {
                harness.fail(" Error : getSuperclass   failed - 5 ");
            } else {
                harness.check(true);
            }
            harness.check(true);
        }
        catch (Exception e) {
            harness.fail(" Error: getSuperclass failed - 6");
        }
        Class<Object> ci = Integer.TYPE;
        harness.check(ci.getSuperclass() == null, "integer class");
        ci = Void.TYPE;
        harness.check(ci.getSuperclass() == null, "void class");
        try {
            ci = this.getClass();
            harness.check(ci.getSuperclass() == Class.forName("java.lang.Object"));
            harness.check(Class.forName("java.lang.Cloneable").getSuperclass() == null);
        }
        catch (Exception e) {
            harness.fail("Debuggin ERROR");
        }
    }

    public void test_getInterfaces() {
        Class<?> clsss;
        Class<?>[] clss = this.getClass().getInterfaces();
        Class<?> clclass = null;
        Class<?> clclass1 = null;
        try {
            clclass = Class.forName("java.lang.Cloneable");
            clclass1 = Class.forName("java.io.Serializable");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (clss == null) {
            harness.fail("Error: getInterfaces returned wrong values - 1");
        } else {
            harness.check(true);
            if (clss.length != 3) {
                harness.fail("Error: getInterfaces returned wrong values - 2");
            } else {
                harness.check(true);
                if (clss[0] != clclass || clss[1] != clclass1) {
                    harness.fail("Error: getInterfaces returned wrong values - 3");
                    for (int i = 0; i < clss.length; ++i) {
                        harness.debug("" + clss[i], false);
                        harness.debug(" ", false);
                    }
                    harness.debug("");
                } else {
                    harness.check(true);
                }
            }
        }
        try {
            clsss = Class.forName("[[I");
            harness.check(clsss.getInterfaces().length, 2);
        }
        catch (Exception e) {
            harness.fail(" Error: getInterfaces failed - 5");
        }
        try {
            clsss = Class.forName("[D");
            harness.check(clsss.getInterfaces().length, 2);
        }
        catch (Exception e) {
            harness.fail(" Error: getInterfaces failed - 7");
        }
        harness.check(clclass.getInterfaces().length == 0);
        try {
            clclass = Class.forName("java.lang.Object");
            harness.check(clclass.getInterfaces().length == 0);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void test_newInstance() {
        Class<?> clss = this.getClass();
        try {
            Object obj = clss.newInstance();
            obj = clss.newInstance();
            obj = clss.newInstance();
            obj = clss.newInstance();
            harness.check(true);
        }
        catch (Exception e) {
            harness.fail("Error: newInstance failed ");
        }
        catch (Error e) {
            harness.fail("Error: newInstance failed  with out of memory error ");
        }
        try {
            (class$java$lang$Class == null ? (class$java$lang$Class = ClassTest.class$("java.lang.Class")) : class$java$lang$Class).newInstance();
            harness.fail("should throw an IllegalAccessException");
        }
        catch (IllegalAccessException iae) {
            harness.check(true);
        }
        catch (Exception e) {
            harness.fail("should throw an IllegalAccessException, but got" + e);
        }
        try {
            (class$java$lang$Number == null ? (class$java$lang$Number = ClassTest.class$("java.lang.Number")) : class$java$lang$Number).newInstance();
            harness.fail("should throw an InstatiationException");
        }
        catch (InstantiationException ie) {
            harness.check(true);
        }
        catch (Exception e) {
            harness.fail("should throw an InstatiationException, but got" + e);
        }
    }

    public void test_forName() {
        harness.checkPoint("forName");
        try {
            Class<?> obj = Class.forName("java.lang.Object");
            harness.check(obj != null);
        }
        catch (Exception e) {
            harness.check(false);
        }
        try {
            Class<?> obj1 = Class.forName("ab.cd.ef");
            harness.check(false);
        }
        catch (ClassNotFoundException e) {
            harness.check(true);
        }
        try {
            Class<?> obj2 = Class.forName("I");
            harness.check(false);
        }
        catch (ClassNotFoundException e) {
            harness.check(true);
        }
    }

    public void test_getClassloader() {
        try {
            Class<?> obj1 = Class.forName("java.lang.String");
            ClassLoader ldr = obj1.getClassLoader();
            if (ldr != null) {
                harness.fail("Error: test_getClassLoader failed - 1");
            } else {
                harness.check(true);
            }
            Class<?> obj2 = Class.forName("gnu.testlet.wonka.lang.Class.ClassTest");
            ClassLoader ldr1 = obj2.getClassLoader();
            if (ldr1 == null) {
                harness.fail("Error: test_getClassLoader failed - 2");
            } else {
                harness.check(true);
            }
        }
        catch (Exception e) {
            harness.fail("Error: test_getClassLoader failed -3");
        }
    }

    public void test_ComponentType() {
        try {
            Class<?> obj1 = Class.forName("java.lang.String");
            if (obj1.getComponentType() != null) {
                harness.fail("Error: test_getComponentType failed - 1");
            } else {
                harness.check(true);
            }
            Class<?> obj2 = Class.forName("java.lang.Exception");
            if (obj2.getComponentType() != null) {
                harness.fail("Error: test_getComponentType failed - 2");
            } else {
                harness.check(true);
            }
            Class<?> arrclass = Class.forName("[I");
            if (arrclass.getComponentType() == null) {
                harness.fail("Error: test_getComponentType failed - 3");
            } else {
                harness.check(true);
                harness.check(arrclass.getComponentType().getName().equals("int"));
            }
            arrclass = Class.forName("[[[[I");
            if (arrclass.getComponentType() == null) {
                harness.fail("Error: test_getComponentType failed - 4");
            } else {
                harness.check(true);
            }
        }
        catch (Exception e) {
            harness.fail("Error: test_getComponentType failed - 6");
        }
    }

    public void test_isMethods() {
        try {
            Class<?> obj1 = Class.forName("java.lang.String");
            if (!obj1.isInstance("babu")) {
                harness.fail("Error: test_isMethods failed - 1");
            } else {
                harness.check(true);
            }
            Class<?> obj2 = Class.forName("java.lang.Integer");
            if (!obj2.isInstance(new Integer(10))) {
                harness.fail("Error: test_isMethods failed - 2");
            } else {
                harness.check(true);
            }
            int[] arr = new int[3];
            Class<?> arrclass = Class.forName("[I");
            if (!arrclass.isInstance(arr)) {
                harness.fail("Error: test_isMethods failed - 3");
            } else {
                harness.check(true);
            }
            Class<?> cls1 = Class.forName("java.lang.String");
            Class<?> supercls = Class.forName("java.lang.Object");
            if (!supercls.isAssignableFrom(cls1)) {
                harness.fail("Error: test_isMethods failed - 4");
            } else {
                harness.check(true);
            }
            if (cls1.isAssignableFrom(supercls)) {
                harness.fail("Error: test_isMethods failed - 5");
            } else {
                harness.check(true);
            }
            Class<?> cls2 = Class.forName("java.lang.String");
            if (!cls2.isAssignableFrom(cls1)) {
                harness.fail("Error: test_isMethods failed - 6");
            } else {
                harness.check(true);
            }
            arrclass = Class.forName("[I");
            Class<?> arrclass1 = Class.forName("[[[I");
            Class<?> arrclass2 = Class.forName("[[D");
            harness.check(!cls1.isArray());
            if (arrclass.isArray() && arrclass1.isArray() && arrclass2.isArray()) {
                harness.check(true);
            } else {
                harness.fail("Error : test_isMethods failed - 7");
            }
        }
        catch (Exception e) {
            harness.fail("Error: test_isMethods failed - 6");
        }
        Class<Integer> ci = Integer.TYPE;
        Class<Integer> cit = Integer.TYPE;
        int i = 5;
        ci = cit;
        harness.check(!ci.isInstance(cit));
        harness.check(ci.isAssignableFrom(cit));
        try {
            ci = Class.forName("java.io.Serializable");
            int[] ia = new int[2];
            harness.check(ci.isInstance(ia), "array implements");
            harness.check(!ci.isInstance(null));
            Class<?> arrclass = Class.forName("[I");
            harness.check(ci.isAssignableFrom(arrclass));
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testall() {
        harness.setclass("java.lang.Class");
        harness.checkPoint("toString");
        this.test_toString();
        harness.checkPoint("getName");
        this.test_getName();
        harness.checkPoint("isInterface");
        this.test_isInterface();
        harness.checkPoint("getSuperclass");
        this.test_getSuperclass();
        harness.checkPoint("getInterface");
        this.test_getInterfaces();
        harness.checkPoint("newInstance");
        this.test_newInstance();
        this.test_forName();
        harness.checkPoint("ComponentType");
        this.test_ComponentType();
        harness.checkPoint("getClassloader");
        this.test_getClassloader();
        harness.checkPoint("isMethods");
        this.test_isMethods();
        harness.checkPoint("getResource");
    }

    public void test(TestHarness the_harness) {
        harness = the_harness;
        this.testall();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

