/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.Character;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

public class CharacterTest
implements Testlet {
    protected static TestHarness harness;

    public void test_Basics() {
        boolean bl = false;
        if (Character.forDigit(8, 2) != '\u0000') {
            bl = true;
        }
        harness.check(bl ^ true, "Error: test_forDigit - 50");
        boolean bl2 = false;
        if (Character.forDigit(-3, 2) != '\u0000') {
            bl2 = true;
        }
        harness.check(bl2 ^ true, "Error: test_forDigit - 51");
        boolean bl3 = false;
        if (Character.forDigit(2, 8) != '2') {
            bl3 = true;
        }
        harness.check(bl3 ^ true, "Error: test_forDigit - 52");
        boolean bl4 = false;
        if (Character.forDigit(12, 16) != 'c') {
            bl4 = true;
        }
        harness.check(bl4 ^ true, "Error: test_forDigit - 53");
        harness.check(Character.isJavaLetter((char)-1) ^ true, "Error: test_forDigit - 54");
        harness.check(Character.isJavaLetter('a') ^ true ^ true, "Error: test_forDigit - 55");
        harness.check(true, "Error: test_Basics failed - 1");
        harness.check(true, "Error: test_Basics failed - 2");
        harness.check(true, "Error: test_Basics failed - 3");
        harness.check(true, "Error: test_Basics failed - 4");
        Character ch = new Character('b');
        boolean bl5 = false;
        if (ch.charValue() != 'b') {
            bl5 = true;
        }
        harness.check(bl5 ^ true, "Error: test_Basics failed - 5");
    }

    public void test_toString() {
        Character ch = new Character('a');
        String str = ch.toString();
        boolean bl = false;
        if (str.length() != 1 || !str.equals("a")) {
            bl = true;
        }
        harness.check(bl ^ true, "Error: test_toString failed ");
    }

    public void test_equals() {
        Character ch1 = new Character('+');
        Character ch2 = new Character('+');
        Character ch3 = new Character('-');
        boolean bl = false;
        if (!ch1.equals(ch2) || ch1.equals(ch3) || ch1.equals(null)) {
            bl = true;
        }
        harness.check(bl ^ true, "Error: test_equals failed - 1");
    }

    public void test_hashCode() {
        Character ch1 = new Character('a');
        boolean bl = false;
        if (ch1.hashCode() != 97) {
            bl = true;
        }
        harness.check(bl ^ true, "Error: test_hashCode returned wrong results");
    }

    public void test_isSpace() {
        boolean bl = false;
        if (!(Character.isSpace('\t') && Character.isSpace('\f') && Character.isSpace('\r') && Character.isSpace('\n') && Character.isSpace(' ') && !Character.isSpace('+'))) {
            bl = true;
        }
        harness.check(bl ^ true, "Error: test_isSpace returned wrong results");
    }

    public void test_digit() {
        boolean bl = false;
        if (Character.digit('a', 1) != -1) {
            bl = true;
        }
        harness.check(bl ^ true, "Error: test_digit returned wrong results - 1");
        boolean bl2 = false;
        if (Character.digit('a', 37) != -1) {
            bl2 = true;
        }
        harness.check(bl2 ^ true, "Error: test_digit returned wrong results - 2");
    }

    public void test_others() {
        Character.isDefined('a');
        Character.isDefined((char)-1);
        Character.digit('\u0665', 10);
        Character.digit('\u06f5', 10);
        Character.digit('\u0968', 10);
        Character.digit('\u06e8', 10);
        Character.digit('\u0a68', 10);
        Character.digit('\u0ae8', 10);
        Character.digit('\u0b68', 10);
        Character.digit('\u0be8', 10);
        Character.digit('\u0c68', 10);
        Character.digit('\u0ce8', 10);
        Character.digit('\u0d68', 10);
        Character.digit('\u0e52', 10);
        Character.digit('\u0ed2', 10);
        Character.digit('\uff12', 10);
        Character.digit((char)-1, 10);
        Character.isJavaLetterOrDigit('a');
        harness.check(Character.isJavaLetterOrDigit((char)-1) ^ true, "Error: isJavaLetterOrDigit - 60");
        harness.check(Character.isLetterOrDigit((char)-1) ^ true, "Error: isLetterOrDigit - 61");
        Character.isLetterOrDigit('a');
        Character.isLowerCase('A');
        Character.isLowerCase('a');
        Character.isSpace('a');
        Character.isUpperCase('a');
        Character.isUpperCase('A');
    }

    public void testall() {
        this.test_Basics();
        this.test_toString();
        this.test_equals();
        this.test_hashCode();
        this.test_isSpace();
        this.test_digit();
        this.test_others();
    }

    public void test(TestHarness the_harness) {
        harness = the_harness;
        this.testall();
    }
}

