/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.jni;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.jni.ConstructionContainer;
import gnu.testlet.wonka.jni.ContainerFunctions;
import gnu.testlet.wonka.jni.FunctionContainer;
import gnu.testlet.wonka.jni.MultiFunctionContainer;
import gnu.testlet.wonka.jni.SimpleContainer;

public class JNIClassAccessTest
extends ContainerFunctions
implements Testlet {
    protected static TestHarness harness;

    private final void testClassVariableAccess() {
        SimpleContainer container = this.buildSimpleContainer(1400, "alfa", false, false, true, 100);
        harness.checkPoint("Direct access class member <primitive int> through native calls");
        harness.check(this.getClassInteger(container), 1400);
        this.setClassInteger(container, 1401);
        harness.check(container.number, 1401);
        harness.checkPoint("Direct access class member <String> through native calls");
        harness.check(this.getClassString(container), (Object)"alfa");
        this.setClassString(container, "beta");
        harness.check(container.name, (Object)"beta");
        harness.checkPoint("Direct access member <Array[3]> via native calls");
        this.checkBoolArray(this.getClassArray(container), false, false, true, harness);
        this.setClassArray(container, this.buildBoolArray(false, true, false));
        this.checkBoolArray(container.preferences, false, true, false, harness);
        this.setClassArray(container, false, true, true);
        this.checkBoolArray(container.preferences, false, true, true, harness);
        harness.checkPoint("Direct access static class member through native calls");
        harness.check(this.getClassStatic(container), 100);
        this.setClassStatic(container, 101);
        harness.check(SimpleContainer.common, 101);
    }

    private final native int getClassInteger(SimpleContainer var1);

    private final native void setClassInteger(SimpleContainer var1, int var2);

    private final native String getClassString(SimpleContainer var1);

    private final native void setClassString(SimpleContainer var1, String var2);

    private final native boolean[] getClassArray(SimpleContainer var1);

    private final native void setClassArray(SimpleContainer var1, boolean[] var2);

    private final native void setClassArray(SimpleContainer var1, boolean var2, boolean var3, boolean var4);

    private final native int getClassStatic(SimpleContainer var1);

    private final native void setClassStatic(SimpleContainer var1, int var2);

    private final void testClassFunctionAccess() {
        FunctionContainer container = this.buildFunctionContainer(1402, "gamma", true, false, false, 1403, "delta", true, true, true);
        harness.checkPoint("Function access class member <primitive int> through native calls");
        harness.check(this.getClassInteger(container), 1402);
        this.setClassInteger(container, 1404);
        harness.check(container.getNumber(), 1404);
        harness.checkPoint("Function access class member <String> through native calls");
        harness.check(this.getClassString(container), (Object)"gamma");
        this.setClassString(container, "epsilon");
        harness.check(container.getName(), (Object)"epsilon");
        harness.checkPoint("Function access member <Array[3]> via native calls");
        this.checkBoolArray(this.getClassArray(container), true, false, false, harness);
        this.setClassArray(container, this.buildBoolArray(true, false, true));
        this.checkBoolArray(container.getPreferences(), true, false, true, harness);
        this.setClassArray(container, true, true, false);
        this.checkBoolArray(container.getPreferences(), true, true, false, harness);
        harness.checkPoint("Function access class member <self-defined class> through native calls");
        this.compareSimpleContainer(this.getClassContainer(container), 1403, "delta", true, true, true, harness);
        this.setClassContainer(container, this.buildSimpleContainer(1404, "zeta", false, false, false));
        this.compareSimpleContainer(container.getInternal(), 1404, "zeta", false, false, false, harness);
    }

    private final native int getClassInteger(FunctionContainer var1);

    private final native void setClassInteger(FunctionContainer var1, int var2);

    private final native String getClassString(FunctionContainer var1);

    private final native void setClassString(FunctionContainer var1, String var2);

    private final native boolean[] getClassArray(FunctionContainer var1);

    private final native void setClassArray(FunctionContainer var1, boolean[] var2);

    private final native void setClassArray(FunctionContainer var1, boolean var2, boolean var3, boolean var4);

    private final native SimpleContainer getClassContainer(FunctionContainer var1);

    private final native void setClassContainer(FunctionContainer var1, SimpleContainer var2);

    private final void testClassStaticMemberAccess() {
        SimpleContainer direct = new SimpleContainer();
        SimpleContainer member1 = new SimpleContainer();
        SimpleContainer member2 = new SimpleContainer();
        FunctionContainer member3 = new FunctionContainer();
        SimpleContainer.common = 1405;
        harness.checkPoint("accessing static member variable through JNI calls");
        harness.check(this.getClassStatic(member1), 1405);
        this.setClassStatic(member1, 1406);
        harness.check(SimpleContainer.common, 1406);
        harness.check(this.getClassStatic(member2), 1406);
        harness.checkPoint("accessing static member from secundary class variable through JNI calls");
        SimpleContainer.common = 1407;
        harness.check(this.getClassStatic(member3), 1407);
        this.setClassStatic(member3, 1408);
        harness.check(SimpleContainer.common, 1408);
        harness.check(this.getClassStatic(member1), 1408);
    }

    private final native int getClassStatic(FunctionContainer var1);

    private final native void setClassStatic(FunctionContainer var1, int var2);

    private final void testClassStaticFunctionAccess() {
        MultiFunctionContainer mfc1 = new MultiFunctionContainer();
        harness.checkPoint("accessing static function through JNI calls");
        this.compareSimpleContainer(this.buildSimpleContainerStatic(mfc1, 1409, "eta", false, false, true), 1409, "eta", false, false, true, harness);
    }

    private final native SimpleContainer buildSimpleContainerStatic(MultiFunctionContainer var1, int var2, String var3, boolean var4, boolean var5, boolean var6);

    private final void testClassNonvirtualFunctionAccess() {
        MultiFunctionContainer mfc2 = new MultiFunctionContainer();
        harness.checkPoint("accessing virtual base class function through JNI calls");
        ConstructionContainer.invert = true;
        this.buildSimpleContainer(mfc2, 1410, "theta", false, true, false);
        this.compareConstructionContainer(mfc2, 1410, "theta", false, true, false, harness);
        this.buildSimpleContainerNonvirtual(mfc2, 1411, "iota", false, true, true);
        this.compareConstructionContainer(mfc2, -1411, "IOTA", true, false, false, harness);
        ConstructionContainer.invert = false;
    }

    private final native void buildSimpleContainer(ConstructionContainer var1, int var2, String var3, boolean var4, boolean var5, boolean var6);

    private final native void buildSimpleContainerNonvirtual(ConstructionContainer var1, int var2, String var3, boolean var4, boolean var5, boolean var6);

    public void test(TestHarness newharness) {
        harness = newharness;
        harness.setclass("JNI access members/functions of given classes");
        this.testClassVariableAccess();
        this.testClassFunctionAccess();
        this.testClassStaticMemberAccess();
        this.testClassStaticFunctionAccess();
        this.testClassNonvirtualFunctionAccess();
    }

    static {
        System.loadLibrary("JNIClassAccessTest");
    }
}

