/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.jni;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.jni.ContainerFunctions;
import gnu.testlet.wonka.jni.SimpleContainer;

public class JNIArrayTest
extends ContainerFunctions
implements Testlet {
    TestHarness harness;

    private final void testByteArrayFunctions() {
        byte[] refarray = new byte[6];
        byte[] buildarray = new byte[6];
        this.harness.checkPoint("NewByteArray()");
        int current = 64;
        int i = 0;
        while (i < 6) {
            refarray[i] = current;
            current = (byte)(current + 16);
            ++i;
        }
        buildarray = this.buildArray(6, (byte)64, (byte)16);
        this.compare(buildarray, refarray);
        this.harness.checkPoint("GetArrayLength");
        this.harness.check(this.getArrayLength(refarray), 6);
        this.harness.checkPoint("Accessing elements of byte array");
        this.harness.check(this.scanArrayElements(refarray, (byte)0), 4, "GetByteArrayElements/ReleaseByteArrayElements");
        this.harness.check(this.scanArrayRegionComplete(refarray, (byte)0), 4, "GetByteArrayRegion: complete region");
        this.harness.check(this.scanArrayRegionOneByOne(refarray, (byte)0), 4, "GetByteArrayRegion: one by one");
        i = 0;
        while (i < 3) {
            refarray[i] = (byte)(16 * i);
            refarray[i + 3] = (byte)(16 * i);
            buildarray[i] = (byte)(16 * i);
            buildarray[i + 3] = (byte)(16 * i);
            ++i;
        }
        this.harness.checkPoint("changing elements of byte array");
        refarray[0] = 64;
        refarray[3] = 64;
        this.changeArrayElements(buildarray, (byte)0, (byte)64);
        this.compare(buildarray, refarray, "GetByteArrayElements/ReleaseByteArrayElements");
        refarray[2] = 96;
        refarray[5] = 96;
        this.changeArrayRegionComplete(buildarray, (byte)32, (byte)96);
        this.compare(buildarray, refarray, "GetByteArrayRegion: complete region");
        refarray[0] = 112;
        refarray[3] = 112;
        this.changeArrayRegionOneByOne(buildarray, (byte)64, (byte)112);
        this.compare(buildarray, refarray, "GetByteArrayRegion: one by one");
    }

    private final void testByteArrayCritical() {
        byte[] refarray = this.buildArray(6, (byte)64, (byte)16);
        byte[] buildarray = this.buildArray(6, (byte)64, (byte)16);
        this.harness.checkPoint("Accessing elements of byte array, critical");
        this.harness.check(this.scanArrayCritical(refarray, (byte)0), 4, "GetPrimitiveArrayCritical/ReleasePrimitiveArrayCritical");
        this.harness.checkPoint("changing elements of byte array, critical");
        refarray[1] = 16;
        this.changeArrayCritical(buildarray, (byte)80, (byte)16);
        this.compare(buildarray, refarray, "GetPrimitiveArrayCritical/ReleasePrimitiveArrayCritical");
    }

    private final native byte[] buildArray(int var1, byte var2, byte var3);

    private final native int getArrayLength(byte[] var1);

    private final native int scanArrayElements(byte[] var1, byte var2);

    private final native int scanArrayCritical(byte[] var1, byte var2);

    private final native int scanArrayRegionComplete(byte[] var1, byte var2);

    private final native int scanArrayRegionOneByOne(byte[] var1, byte var2);

    private final native void changeArrayElements(byte[] var1, byte var2, byte var3);

    private final native void changeArrayCritical(byte[] var1, byte var2, byte var3);

    private final native void changeArrayRegionComplete(byte[] var1, byte var2, byte var3);

    private final native void changeArrayRegionOneByOne(byte[] var1, byte var2, byte var3);

    private final void testShortArrayFunctions() {
        short[] refarray = new short[6];
        short[] buildarray = new short[6];
        this.harness.checkPoint("NewShortArray()");
        int current = 16448;
        int i = 0;
        while (i < 6) {
            refarray[i] = current;
            current = (short)(current + 4112);
            ++i;
        }
        buildarray = this.buildArray(6, (short)16448, (short)4112);
        this.compare(buildarray, refarray);
        this.harness.checkPoint("GetArrayLength");
        this.harness.check(this.getArrayLength(refarray), 6);
        this.harness.checkPoint("Accessing elements of short array");
        this.harness.check(this.scanArrayElements(refarray, (short)0), 4, "GetShortArrayElements/ReleaseShortArrayElements");
        this.harness.check(this.scanArrayRegionComplete(refarray, (short)0), 4, "GetShortArrayRegion: complete region");
        this.harness.check(this.scanArrayRegionOneByOne(refarray, (short)0), 4, "GetShortArrayRegion: one by one");
        i = 0;
        while (i < 3) {
            refarray[i] = (short)(4112 * i);
            refarray[i + 3] = (short)(4112 * i);
            buildarray[i] = (short)(4112 * i);
            buildarray[i + 3] = (short)(4112 * i);
            ++i;
        }
        this.harness.checkPoint("changing elements of short array");
        refarray[0] = 16448;
        refarray[3] = 16448;
        this.changeArrayElements(buildarray, (short)0, (short)16448);
        this.compare(buildarray, refarray, "GetShortArrayElements/ReleaseShortArrayElements");
        refarray[2] = 24672;
        refarray[5] = 24672;
        this.changeArrayRegionComplete(buildarray, (short)8224, (short)24672);
        this.compare(buildarray, refarray, "GetShortArrayRegion: complete region");
        refarray[0] = 28784;
        refarray[3] = 28784;
        this.changeArrayRegionOneByOne(buildarray, (short)16448, (short)28784);
        this.compare(buildarray, refarray, "GetShortArrayRegion: one by one");
    }

    private final void testShortArrayCritical() {
        short[] refarray = this.buildArray(6, (short)16448, (short)4112);
        short[] buildarray = this.buildArray(6, (short)16448, (short)4112);
        this.harness.checkPoint("Accessing elements of array, critical");
        this.harness.check(this.scanArrayCritical(refarray, (short)0), 4, "GetPrimitiveArrayCritical/ReleasePrimitiveArrayCritical");
        this.harness.checkPoint("changing elements of array, critical");
        refarray[1] = 4112;
        this.changeArrayCritical(buildarray, (short)20560, (short)4112);
        this.compare(buildarray, refarray, "GetPrimitiveArrayCritical/ReleasePrimitiveArrayCritical");
    }

    private final native short[] buildArray(int var1, short var2, short var3);

    private final native int getArrayLength(short[] var1);

    private final native int scanArrayElements(short[] var1, short var2);

    private final native int scanArrayCritical(short[] var1, short var2);

    private final native int scanArrayRegionComplete(short[] var1, short var2);

    private final native int scanArrayRegionOneByOne(short[] var1, short var2);

    private final native void changeArrayElements(short[] var1, short var2, short var3);

    private final native void changeArrayCritical(short[] var1, short var2, short var3);

    private final native void changeArrayRegionComplete(short[] var1, short var2, short var3);

    private final native void changeArrayRegionOneByOne(short[] var1, short var2, short var3);

    private final void testIntArrayFunctions() {
        int[] refarray = new int[6];
        int[] buildarray = new int[6];
        this.harness.checkPoint("NewIntArray()");
        int current = 0x40404040;
        int i = 0;
        while (i < 6) {
            refarray[i] = current;
            current += 0x10101010;
            ++i;
        }
        buildarray = this.buildArray(6, 0x40404040, 0x10101010);
        this.compare(buildarray, refarray);
        this.harness.checkPoint("GetArrayLength integer array");
        this.harness.check(this.getArrayLength(refarray), 6);
        this.harness.checkPoint("Accessing elements of integer array");
        this.harness.check(this.scanArrayElements(refarray, 0), 4, "GetIntArrayElements/ReleaseIntArrayElements");
        this.harness.check(this.scanArrayRegionComplete(refarray, 0), 4, "GetIntArrayRegion: complete region");
        this.harness.check(this.scanArrayRegionOneByOne(refarray, 0), 4, "GetIntArrayRegion: one by one");
        i = 0;
        while (i < 3) {
            refarray[i] = 0x10101010 * i;
            refarray[i + 3] = 0x10101010 * i;
            buildarray[i] = 0x10101010 * i;
            buildarray[i + 3] = 0x10101010 * i;
            ++i;
        }
        this.harness.checkPoint("changing elements of integer array");
        refarray[0] = 0x40404040;
        refarray[3] = 0x40404040;
        this.changeArrayElements(buildarray, 0, 0x40404040);
        this.compare(buildarray, refarray, "GetIntArrayElements/ReleaseIntArrayElements");
        refarray[2] = 0x60606060;
        refarray[5] = 0x60606060;
        this.changeArrayRegionComplete(buildarray, 0x20202020, 0x60606060);
        this.compare(buildarray, refarray, "GetIntArrayRegion: complete region");
        refarray[0] = 0x70707070;
        refarray[3] = 0x70707070;
        this.changeArrayRegionOneByOne(buildarray, 0x40404040, 0x70707070);
        this.compare(buildarray, refarray, "GetIntArrayRegion: one by one");
    }

    private final void testIntArrayCritical() {
        int[] refarray = this.buildArray(6, 0x40404040, 0x10101010);
        int[] buildarray = this.buildArray(6, 0x40404040, 0x10101010);
        this.harness.checkPoint("Accessing elements of array, critical");
        this.harness.verbose("Accessing elements of array, critical");
        this.harness.check(this.scanArrayCritical(refarray, 0), 4, "GetPrimitiveArrayCritical/ReleasePrimitiveArrayCritical");
        this.harness.checkPoint("changing elements of array, critical");
        this.harness.verbose("changing elements of array, critical");
        refarray[1] = 0x10101010;
        this.changeArrayCritical(buildarray, 0x50505050, 0x10101010);
        this.compare(buildarray, refarray, "GetPrimitiveArrayCritical/ReleasePrimitiveArrayCritical");
    }

    private final native int[] buildArray(int var1, int var2, int var3);

    private final native int getArrayLength(int[] var1);

    private final native int scanArrayElements(int[] var1, int var2);

    private final native int scanArrayCritical(int[] var1, int var2);

    private final native int scanArrayRegionComplete(int[] var1, int var2);

    private final native int scanArrayRegionOneByOne(int[] var1, int var2);

    private final native void changeArrayElements(int[] var1, int var2, int var3);

    private final native void changeArrayCritical(int[] var1, int var2, int var3);

    private final native void changeArrayRegionComplete(int[] var1, int var2, int var3);

    private final native void changeArrayRegionOneByOne(int[] var1, int var2, int var3);

    private final void testLongArrayFunctions() {
        long[] refarray = new long[6];
        long[] buildarray = new long[6];
        this.harness.checkPoint("NewLongArray()");
        long current = 0x4040404040404040L;
        int i = 0;
        while (i < 6) {
            refarray[i] = current;
            current += 0x1010101010101010L;
            ++i;
        }
        buildarray = this.buildArray(6, 0x4040404040404040L, 0x1010101010101010L);
        this.compare(buildarray, refarray);
        this.harness.checkPoint("GetArrayLength long array");
        this.harness.check(this.getArrayLength(refarray), 6);
        this.harness.checkPoint("Accessing elements of long array");
        this.harness.check(this.scanArrayElements(refarray, 0L), 4, "GetLongArrayElements/ReleaseLongArrayElements");
        this.harness.check(this.scanArrayRegionComplete(refarray, 0L), 4, "GetLongArrayRegion: complete region");
        this.harness.check(this.scanArrayRegionOneByOne(refarray, 0L), 4, "GetLongArrayRegion: one by one");
        i = 0;
        while (i < 3) {
            refarray[i] = 0x1010101010101010L * (long)i;
            refarray[i + 3] = 0x1010101010101010L * (long)i;
            buildarray[i] = 0x1010101010101010L * (long)i;
            buildarray[i + 3] = 0x1010101010101010L * (long)i;
            ++i;
        }
        this.harness.checkPoint("changing elements of long array");
        refarray[0] = 0x4040404040404040L;
        refarray[3] = 0x4040404040404040L;
        this.changeArrayElements(buildarray, 0L, 0x4040404040404040L);
        this.compare(buildarray, refarray, "GetLongArrayElements/ReleaseLongArrayElements");
        refarray[2] = 0x6060606060606060L;
        refarray[5] = 0x6060606060606060L;
        this.changeArrayRegionComplete(buildarray, 0x2020202020202020L, 0x6060606060606060L);
        this.compare(buildarray, refarray, "GetLongArrayRegion: complete region");
        refarray[0] = 0x7070707070707070L;
        refarray[3] = 0x7070707070707070L;
        this.changeArrayRegionOneByOne(buildarray, 0x4040404040404040L, 0x7070707070707070L);
        this.compare(buildarray, refarray, "GetLongArrayRegion: one by one");
    }

    private final void testLongArrayCritical() {
        long[] refarray = this.buildArray(6, 0x4040404040404040L, 0x1010101010101010L);
        long[] buildarray = this.buildArray(6, 0x4040404040404040L, 0x1010101010101010L);
        this.harness.checkPoint("Accessing elements of array, critical");
        this.harness.check(this.scanArrayCritical(refarray, 0L), 4, "GetPrimitiveArrayCritical/ReleasePrimitiveArrayCritical");
        this.harness.checkPoint("changing elements of array, critical");
        refarray[1] = 0x1010101010101010L;
        this.changeArrayCritical(buildarray, 0x5050505050505050L, 0x1010101010101010L);
        this.compare(buildarray, refarray, "GetPrimitiveArrayCritical/ReleasePrimitiveArrayCritical");
    }

    private final native long[] buildArray(int var1, long var2, long var4);

    private final native int getArrayLength(long[] var1);

    private final native int scanArrayElements(long[] var1, long var2);

    private final native int scanArrayCritical(long[] var1, long var2);

    private final native int scanArrayRegionComplete(long[] var1, long var2);

    private final native int scanArrayRegionOneByOne(long[] var1, long var2);

    private final native void changeArrayElements(long[] var1, long var2, long var4);

    private final native void changeArrayCritical(long[] var1, long var2, long var4);

    private final native void changeArrayRegionComplete(long[] var1, long var2, long var4);

    private final native void changeArrayRegionOneByOne(long[] var1, long var2, long var4);

    private final void testFloatArrayFunctions() {
        float[] refarray = new float[6];
        float[] buildarray = new float[6];
        this.harness.checkPoint("NewFloatArray()");
        float current = 0.61f;
        int i = 0;
        while (i < 6) {
            refarray[i] = current;
            current += 0.11f;
            ++i;
        }
        buildarray = this.buildArray(6, 0.61f, 0.11f);
        this.compare(buildarray, refarray);
        this.harness.checkPoint("GetArrayLength float array");
        this.harness.check(this.getArrayLength(refarray), 6);
        this.harness.checkPoint("Accessing elements of float array");
        this.harness.check(this.scanArrayElements(refarray, 1.0f), 2, "GetFloatArrayElements/ReleaseFloatArrayElements");
        this.harness.check(this.scanArrayRegionComplete(refarray, 1.0f), 2, "GetFloatArrayRegion: complete region");
        this.harness.check(this.scanArrayRegionOneByOne(refarray, 1.0f), 2, "GetFloatArrayRegion: one by one");
        i = 0;
        while (i < 3) {
            refarray[i] = 0.11f * (float)i;
            refarray[i + 3] = 0.11f * (float)i;
            buildarray[i] = 0.11f * (float)i;
            buildarray[i + 3] = 0.11f * (float)i;
            ++i;
        }
        this.harness.checkPoint("changing elements of float array");
        refarray[0] = 0.44f;
        refarray[3] = 0.44f;
        this.changeArrayElements(buildarray, 0.0f, 0.44f);
        this.compare(buildarray, refarray, "GetFloatArrayElements/ReleaseFloatArrayElements");
        refarray[2] = 0.66f;
        refarray[5] = 0.66f;
        this.changeArrayRegionComplete(buildarray, 0.22f, 0.66f);
        this.compare(buildarray, refarray, "GetFloatArrayRegion: complete region");
        refarray[0] = 0.77f;
        refarray[3] = 0.77f;
        this.changeArrayRegionOneByOne(buildarray, 0.44f, 0.77f);
        this.compare(buildarray, refarray, "GetFloatArrayRegion: one by one");
    }

    private final void testFloatArrayCritical() {
        float[] refarray = this.buildArray(6, 0.61f, 0.11f);
        float[] buildarray = this.buildArray(6, 0.61f, 0.11f);
        this.harness.checkPoint("Accessing elements of array, critical");
        this.harness.check(this.scanArrayCritical(refarray, 1.0f), 2, "GetPrimitiveArrayCritical/ReleasePrimitiveArrayCritical");
        this.harness.checkPoint("changing elements of array, critical");
        refarray[1] = 0.22f;
        this.changeArrayCritical(buildarray, 0.72f, 0.22f);
        this.compare(buildarray, refarray, "GetPrimitiveArrayCritical/ReleasePrimitiveArrayCritical");
    }

    private final native float[] buildArray(int var1, float var2, float var3);

    private final native int getArrayLength(float[] var1);

    private final native int scanArrayElements(float[] var1, float var2);

    private final native int scanArrayCritical(float[] var1, float var2);

    private final native int scanArrayRegionComplete(float[] var1, float var2);

    private final native int scanArrayRegionOneByOne(float[] var1, float var2);

    private final native void changeArrayElements(float[] var1, float var2, float var3);

    private final native void changeArrayCritical(float[] var1, float var2, float var3);

    private final native void changeArrayRegionComplete(float[] var1, float var2, float var3);

    private final native void changeArrayRegionOneByOne(float[] var1, float var2, float var3);

    private final void testDoubleArrayFunctions() {
        double[] refarray = new double[6];
        double[] buildarray = new double[6];
        this.harness.checkPoint("NewDoubleArray()");
        double current = 0.6006;
        int i = 0;
        while (i < 6) {
            refarray[i] = current;
            current += 0.1001;
            ++i;
        }
        buildarray = this.buildArray(6, 0.6006, 0.1001);
        this.compare(buildarray, refarray);
        this.harness.checkPoint("GetArrayLength double array");
        this.harness.check(this.getArrayLength(refarray), 6);
        this.harness.checkPoint("Accessing elements of double array");
        this.harness.check(this.scanArrayElements(refarray, 1.0), 2, "GetDoubleArrayElements/ReleaseDoubleArrayElements");
        this.harness.check(this.scanArrayRegionComplete(refarray, 1.0), 2, "GetDoubleArrayRegion: complete region");
        this.harness.check(this.scanArrayRegionOneByOne(refarray, 1.0), 2, "GetDoubleArrayRegion: one by one");
        i = 0;
        while (i < 3) {
            refarray[i] = 0.10011 * (double)i;
            refarray[i + 3] = 0.10011 * (double)i;
            buildarray[i] = 0.10011 * (double)i;
            buildarray[i + 3] = 0.10011 * (double)i;
            ++i;
        }
        this.harness.checkPoint("changing elements of double array");
        refarray[0] = 0.400456;
        refarray[3] = 0.400456;
        this.changeArrayElements(buildarray, 0.0, 0.400456);
        this.compare(buildarray, refarray, "GetDoubleArrayElements/ReleaseDoubleArrayElements");
        refarray[2] = 0.600456;
        refarray[5] = 0.600456;
        this.changeArrayRegionComplete(buildarray, 0.20022, 0.600456);
        this.compare(buildarray, refarray, "GetDoubleArrayRegion: complete region");
        refarray[0] = 0.700456;
        refarray[3] = 0.700456;
        this.changeArrayRegionOneByOne(buildarray, 0.400456, 0.700456);
        this.compare(buildarray, refarray, "GetDoubleArrayRegion: one by one");
    }

    private final void testDoubleArrayCritical() {
        double[] refarray = this.buildArray(6, 0.601, 0.101);
        double[] buildarray = this.buildArray(6, 0.601, 0.101);
        this.harness.checkPoint("Accessing elements of array, critical");
        this.harness.check(this.scanArrayCritical(refarray, 1.0), 2, "GetPrimitiveArrayCritical/ReleasePrimitiveArrayCritical");
        this.harness.checkPoint("changing elements of array, critical");
        refarray[1] = 0.2202;
        this.changeArrayCritical(buildarray, 0.702, 0.2202);
        this.compare(buildarray, refarray, "GetPrimitiveArrayCritical/ReleasePrimitiveArrayCritical");
    }

    private final native double[] buildArray(int var1, double var2, double var4);

    private final native int getArrayLength(double[] var1);

    private final native int scanArrayElements(double[] var1, double var2);

    private final native int scanArrayCritical(double[] var1, double var2);

    private final native int scanArrayRegionComplete(double[] var1, double var2);

    private final native int scanArrayRegionOneByOne(double[] var1, double var2);

    private final native void changeArrayElements(double[] var1, double var2, double var4);

    private final native void changeArrayCritical(double[] var1, double var2, double var4);

    private final native void changeArrayRegionComplete(double[] var1, double var2, double var4);

    private final native void changeArrayRegionOneByOne(double[] var1, double var2, double var4);

    private final void testBooleanArrayFunctions() {
        this.harness.checkPoint("NewBooleanArray()");
        boolean[] blArray = new boolean[6];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        boolean[] refarray = blArray;
        boolean[] buildarray = this.buildArray(4, 2);
        this.compare(buildarray, refarray);
        this.harness.checkPoint("GetArrayLength");
        this.harness.check(this.getArrayLength(refarray), 6);
        this.harness.checkPoint("Accessing elements of boolean array");
        refarray[0] = false;
        buildarray[0] = false;
        this.harness.check(this.scanArrayElements(refarray, false), 3, "GetBooleanArrayElements/ReleaseBooleanArrayElements");
        this.harness.check(this.scanArrayRegionComplete(refarray, false), 3, "GetBooleanArrayRegion: complete region");
        this.harness.check(this.scanArrayRegionOneByOne(refarray, false), 3, "GetBooleanArrayRegion: one by one");
        this.harness.checkPoint("changing elements of boolean array");
        this.shiftleft(refarray, true);
        this.changeArrayElements(buildarray, true);
        this.compare(buildarray, refarray, "GetBooleanArrayElements/ReleaseBooleanArrayElements");
        this.shiftleft(refarray, true);
        this.changeArrayRegionComplete(buildarray, true);
        this.compare(buildarray, refarray, "GetBooleanArrayRegion: complete region");
        this.shiftleft(refarray, false);
        this.changeArrayRegionOneByOne(buildarray, false);
        this.compare(buildarray, refarray, "GetBooleanArrayRegion: one by one");
    }

    private final void testBooleanArrayCritical() {
        boolean[] blArray = new boolean[6];
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        boolean[] refarray = blArray;
        boolean[] blArray2 = new boolean[6];
        blArray2[1] = true;
        blArray2[2] = true;
        blArray2[3] = true;
        boolean[] buildarray = blArray2;
        this.harness.checkPoint("Accessing elements of boolean array, critical");
        this.harness.check(this.scanArrayCritical(refarray, false), 3, "GetPrimitiveArrayCritical/ReleasePrimitiveArrayCritical");
        this.harness.checkPoint("changing elements of boolean array, critical");
        this.shiftleft(refarray, true);
        this.changeArrayCritical(buildarray, true);
        this.compare(buildarray, refarray, "GetPrimitiveArrayCritical/ReleasePrimitiveArrayCritical");
    }

    private final void shiftleft(boolean[] refarray, boolean nextvalue) {
        int i = 1;
        while (i < refarray.length) {
            refarray[i - 1] = refarray[i];
            ++i;
        }
        refarray[refarray.length - 1] = nextvalue;
    }

    private final native boolean[] buildArray(int var1, int var2);

    private final native int getArrayLength(boolean[] var1);

    private final native int scanArrayElements(boolean[] var1, boolean var2);

    private final native int scanArrayCritical(boolean[] var1, boolean var2);

    private final native int scanArrayRegionComplete(boolean[] var1, boolean var2);

    private final native int scanArrayRegionOneByOne(boolean[] var1, boolean var2);

    private final native void changeArrayElements(boolean[] var1, boolean var2);

    private final native void changeArrayCritical(boolean[] var1, boolean var2);

    private final native void changeArrayRegionComplete(boolean[] var1, boolean var2);

    private final native void changeArrayRegionOneByOne(boolean[] var1, boolean var2);

    private final void testObjectArrayFunctions() {
        SimpleContainer[] testarray = new SimpleContainer[6];
        int number = 1200;
        int i = 0;
        while (i < 6) {
            testarray[i] = this.buildSimpleContainer(number + i, "test" + i, false, false, false);
            ++i;
        }
        this.harness.checkPoint("GetArrayLength object array");
        this.harness.check(this.getArrayLength(testarray), 6);
        this.harness.checkPoint("Accessing elements of object array");
        this.harness.check(this.scanArrayElements(testarray, 1203), 2);
        this.harness.checkPoint("changing elements of object array");
        this.changeArrayElements(testarray, 1201, this.buildSimpleContainer(1210, "new value", false, false, true));
        this.compareSimpleContainer(testarray[0], 1200, "test0", false, false, false, this.harness);
        this.compareSimpleContainer(testarray[1], 1210, "new value", false, false, true, this.harness);
        this.compareSimpleContainer(testarray[2], 1202, "test2", false, false, false, this.harness);
    }

    private final native int getArrayLength(SimpleContainer[] var1);

    private final native int scanArrayElements(SimpleContainer[] var1, int var2);

    private final native void changeArrayElements(SimpleContainer[] var1, int var2, SimpleContainer var3);

    private final String buildString(boolean[] testarray) {
        String notation = "Z" + testarray.length + '<';
        if (testarray.length > 0) {
            notation = notation + (testarray[0] ? "1" : "0");
        }
        int i = 1;
        while (i < testarray.length) {
            notation = notation + (testarray[i] ? ",1" : ",0");
            ++i;
        }
        notation = notation + '>';
        return notation;
    }

    private final String buildString(byte[] testarray) {
        String notation = "B" + testarray.length + '<';
        if (testarray.length > 0) {
            notation = notation + Integer.toHexString(testarray[0]);
        }
        int i = 1;
        while (i < testarray.length) {
            notation = notation + ',' + Integer.toHexString(testarray[i]);
            ++i;
        }
        notation = notation + '>';
        return notation;
    }

    private final String buildString(short[] testarray) {
        String notation = "S" + testarray.length + '<';
        if (testarray.length > 0) {
            notation = notation + Integer.toHexString(testarray[0]);
        }
        int i = 1;
        while (i < testarray.length) {
            notation = notation + ',' + Integer.toHexString(testarray[i]);
            ++i;
        }
        notation = notation + '>';
        return notation;
    }

    private final String buildString(int[] testarray) {
        String notation = "I" + testarray.length + '<';
        if (testarray.length > 0) {
            notation = notation + Integer.toHexString(testarray[0]);
        }
        int i = 1;
        while (i < testarray.length) {
            notation = notation + ',' + Integer.toHexString(testarray[i]);
            ++i;
        }
        notation = notation + '>';
        return notation;
    }

    private final String buildString(long[] testarray) {
        String notation = "J" + testarray.length + '<';
        if (testarray.length > 0) {
            notation = notation + Long.toHexString(testarray[0]);
        }
        int i = 1;
        while (i < testarray.length) {
            notation = notation + ',' + Long.toHexString(testarray[i]);
            ++i;
        }
        notation = notation + '>';
        return notation;
    }

    private final String buildString(float[] testarray) {
        String notation = "F" + testarray.length + '<';
        if (testarray.length > 0) {
            notation = notation + Float.toString(testarray[0]);
        }
        int i = 1;
        while (i < testarray.length) {
            notation = notation + ',' + Float.toString(testarray[i]);
            ++i;
        }
        notation = notation + '>';
        return notation;
    }

    private final String buildString(double[] testarray) {
        String notation = "D" + testarray.length + '<';
        if (testarray.length > 0) {
            notation = notation + Double.toString(testarray[0]);
        }
        int i = 1;
        while (i < testarray.length) {
            notation = notation + ',' + Double.toString(testarray[i]);
            ++i;
        }
        notation = notation + '>';
        return notation;
    }

    private final void compare(boolean[] testarray, String reference) {
        this.harness.check(this.buildString(testarray), (Object)reference);
    }

    private final void compare(byte[] testarray, String reference) {
        this.harness.check(this.buildString(testarray), (Object)reference);
    }

    private final void compare(short[] testarray, String reference) {
        this.harness.check(this.buildString(testarray), (Object)reference);
    }

    private final void compare(int[] testarray, String reference) {
        this.harness.check(this.buildString(testarray), (Object)reference);
    }

    private final void compare(long[] testarray, String reference) {
        this.harness.check(this.buildString(testarray), (Object)reference);
    }

    private final void compare(float[] testarray, String reference) {
        this.harness.check(this.buildString(testarray), (Object)reference);
    }

    private final void compare(double[] testarray, String reference) {
        this.harness.check(this.buildString(testarray), (Object)reference);
    }

    private final void compare(boolean[] testarray, String reference, String note) {
        this.harness.check(this.buildString(testarray), reference, note);
    }

    private final void compare(byte[] testarray, String reference, String note) {
        this.harness.check(this.buildString(testarray), reference, note);
    }

    private final void compare(short[] testarray, String reference, String note) {
        this.harness.check(this.buildString(testarray), reference, note);
    }

    private final void compare(int[] testarray, String reference, String note) {
        this.harness.check(this.buildString(testarray), reference, note);
    }

    private final void compare(long[] testarray, String reference, String note) {
        this.harness.check(this.buildString(testarray), reference, note);
    }

    private final void compare(float[] testarray, String reference, String note) {
        this.harness.check(this.buildString(testarray), reference, note);
    }

    private final void compare(double[] testarray, String reference, String note) {
        this.harness.check(this.buildString(testarray), reference, note);
    }

    private final void compare(boolean[] testarray, boolean[] reference) {
        this.harness.check(this.buildString(testarray), (Object)this.buildString(reference));
    }

    private final void compare(byte[] testarray, byte[] reference) {
        this.harness.check(this.buildString(testarray), (Object)this.buildString(reference));
    }

    private final void compare(short[] testarray, short[] reference) {
        this.harness.check(this.buildString(testarray), (Object)this.buildString(reference));
    }

    private final void compare(int[] testarray, int[] reference) {
        this.harness.check(this.buildString(testarray), (Object)this.buildString(reference));
    }

    private final void compare(long[] testarray, long[] reference) {
        this.harness.check(this.buildString(testarray), (Object)this.buildString(reference));
    }

    private final void compare(float[] testarray, float[] reference) {
        this.harness.check(this.buildString(testarray), (Object)this.buildString(reference));
    }

    private final void compare(double[] testarray, double[] reference) {
        this.harness.check(this.buildString(testarray), (Object)this.buildString(reference));
    }

    private final void compare(boolean[] testarray, boolean[] reference, String note) {
        this.harness.check(this.buildString(testarray), this.buildString(reference), note);
    }

    private final void compare(byte[] testarray, byte[] reference, String note) {
        this.harness.check(this.buildString(testarray), this.buildString(reference), note);
    }

    private final void compare(short[] testarray, short[] reference, String note) {
        this.harness.check(this.buildString(testarray), this.buildString(reference), note);
    }

    private final void compare(int[] testarray, int[] reference, String note) {
        this.harness.check(this.buildString(testarray), this.buildString(reference), note);
    }

    private final void compare(long[] testarray, long[] reference, String note) {
        this.harness.check(this.buildString(testarray), this.buildString(reference), note);
    }

    private final void compare(float[] testarray, float[] reference, String note) {
        this.harness.check(this.buildString(testarray), this.buildString(reference), note);
    }

    private final void compare(double[] testarray, double[] reference, String note) {
        this.harness.check(this.buildString(testarray), this.buildString(reference), note);
    }

    public void test(TestHarness newharness) {
        this.harness = newharness;
        this.harness.setclass("JNI class and array construction/ class dependencies");
        this.testByteArrayFunctions();
        this.testByteArrayCritical();
        this.testShortArrayFunctions();
        this.testShortArrayCritical();
        this.testIntArrayFunctions();
        this.testIntArrayCritical();
        this.testLongArrayFunctions();
        this.testLongArrayCritical();
        this.testFloatArrayFunctions();
        this.testFloatArrayCritical();
        this.testDoubleArrayFunctions();
        this.testDoubleArrayCritical();
        this.testBooleanArrayFunctions();
        this.testBooleanArrayCritical();
        this.testObjectArrayFunctions();
    }

    static {
        System.loadLibrary("JNIArrayTest");
    }
}

