/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.io.Writer;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.io.Writer.SMExWriter;

public class SMWriterTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.io.Writer");
        this.test_Writer();
        this.test_write();
        this.test_lock();
    }

    public void test_Writer() {
        this.th.checkPoint("Writer()");
        SMExWriter xw = new SMExWriter();
        boolean bl = false;
        if (xw == xw.getLock()) {
            bl = true;
        }
        this.th.check(bl, "uses itself as lock");
        this.th.checkPoint("Writer(java.lang.Object)");
        xw = new SMExWriter(this);
        boolean bl2 = false;
        if (this == xw.getLock()) {
            bl2 = true;
        }
        this.th.check(bl2, "uses this object as lock");
        try {
            new SMExWriter(null);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
    }

    public void test_write() {
        String s;
        this.th.checkPoint("write(int)void");
        SMExWriter xw = new SMExWriter();
        try {
            xw.write(97);
            xw.write(98);
            xw.write(99);
            xw.write(100);
            xw.write(101);
            this.th.check("abcde".equals(xw.toString()), "checking write");
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw any Exception, got:" + e);
        }
        this.th.checkPoint("write(char[])void");
        try {
            xw = new SMExWriter();
            xw.write("".toCharArray());
            this.th.check("".equals(xw.toString()), "checking write -- 1");
            xw.write("abcdefgh".toCharArray());
            this.th.check("abcdefgh".equals(xw.toString()), "checking write -- 2");
            xw.write("abcd".toCharArray());
            this.th.check("abcdefghabcd".equals(xw.toString()), "checking write -- 3");
            xw.write("".toCharArray());
            this.th.check("abcdefghabcd".equals(xw.toString()), "checking write -- 4");
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw any Exception, got:" + e);
        }
        try {
            char[] ca = null;
            xw.write(ca);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception, got:" + e);
        }
        this.th.checkPoint("write(java.lang.String)void");
        try {
            xw = new SMExWriter();
            xw.write("");
            this.th.check("".equals(xw.toString()), "checking write -- 1");
            xw.write("abcdefgh");
            this.th.check("abcdefgh".equals(xw.toString()), "checking write -- 2");
            xw.write("abcd");
            this.th.check("abcdefghabcd".equals(xw.toString()), "checking write -- 3");
            xw.write("");
            this.th.check("abcdefghabcd".equals(xw.toString()), "checking write -- 4");
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw any Exception, got:" + e);
        }
        try {
            s = null;
            xw.write(s);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception, got:" + e);
        }
        this.th.checkPoint("write(java.lang.String,int,int)void");
        try {
            xw = new SMExWriter();
            xw.write("", 0, 0);
            this.th.check("".equals(xw.toString()), "checking write -- 1, got:" + xw.toString());
            xw.write("abcdefgh", 1, 6);
            this.th.check("bcdefg".equals(xw.toString()), "checking write -- 2, got:" + xw.toString());
            xw.write("abcd", 4, 0);
            this.th.check("bcdefg".equals(xw.toString()), "checking write -- 3, got:" + xw.toString());
            xw.write("a", 0, 0);
            this.th.check("bcdefg".equals(xw.toString()), "checking write -- 4, got:" + xw.toString());
            xw.write("abcd", 2, 2);
            this.th.check("bcdefgcd".equals(xw.toString()), "checking write -- 5, got:" + xw.toString());
            xw.write("abcd", 0, 4);
            this.th.check("bcdefgcdabcd".equals(xw.toString()), "checking write -- 6, got:" + xw.toString());
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw any Exception, got:" + e);
        }
        try {
            s = null;
            xw.write(s, 4, 5);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 1, got:" + e);
        }
        try {
            xw.write("abcde", 4, 2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 2, got:" + e);
        }
        try {
            xw.write("abcde", -4, 2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 2");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 3, got:" + e);
        }
        try {
            xw.write("abcde", 4, -2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 3");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 4, got:" + e);
        }
        try {
            xw.write("abcde", 6, 0);
            this.th.fail("should throw an IndexOutOfBoundsException -- 4");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 5, got:" + e);
        }
    }

    public void test_lock() {
        this.th.checkPoint("()");
    }
}

