/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.io.PrintStream;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.io.PrintStream.SMErrorStream;
import gnu.testlet.wonka.io.PrintStream.SMExPrintStream;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Field;

public class SMPrintStreamTest
implements Testlet {
    protected TestHarness th;
    protected Field fautof = null;
    protected String sep = System.getProperty("line.separator", "\n");
    private boolean JDK = false;
    static /* synthetic */ Class class$java$io$PrintStream;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.io.PrintStream");
        this.setupFields();
        this.test_PrintStream();
        this.test_print();
        this.test_println();
        this.test_write();
        this.test_checkError();
        this.test_setError();
        this.test_close();
        this.test_flush();
    }

    public void setupFields() {
        int i;
        this.th.checkPoint("setting up reflection()...");
        Field[] fa = (class$java$io$PrintStream == null ? (class$java$io$PrintStream = SMPrintStreamTest.class$("java.io.PrintStream")) : class$java$io$PrintStream).getDeclaredFields();
        for (i = 0; i < fa.length && !fa[i].getName().equals(this.JDK ? "autoFlush" : "autoFlush"); ++i) {
        }
        if (i == fa.length) {
            this.th.fail("field auto_flush not found");
        } else {
            fa[i].setAccessible(true);
            this.fautof = fa[i];
        }
    }

    public void test_PrintStream() {
        this.th.checkPoint("PrintStream(java.io.OutputStream)");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SMExPrintStream xpw = new SMExPrintStream(bos);
        try {
            this.th.check(!this.fautof.getBoolean(xpw), "checking auto_flush value");
            this.th.check(xpw.getOut() == bos, "checking value field out");
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception -- 1, got:" + e);
        }
        try {
            new SMExPrintStream(null);
            this.th.fail("should throw a NullpointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        this.th.checkPoint("PrintStream(java.io.OutputStream,boolean)");
        xpw = new SMExPrintStream(bos, true);
        try {
            this.th.check(this.fautof.getBoolean(xpw), "checking auto_flush value");
            this.th.check(xpw.getOut() == bos, "checking value field out");
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception -- 1, got:" + e);
        }
        try {
            new SMExPrintStream(null, false);
            this.th.fail("should throw a NullpointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
    }

    public void test_print() {
        this.th.checkPoint("print(boolean)void");
        this.th.checkPoint("print(boolean)void");
        ByteArrayOutputStream caw = new ByteArrayOutputStream();
        SMExPrintStream xpw = new SMExPrintStream(caw);
        xpw.print(true);
        this.th.check(caw.toString().equals(String.valueOf(true)), "checking true");
        xpw.print(false);
        this.th.check(caw.toString().equals("truefalse"), "checking true+false");
        this.th.checkPoint("print(int)void");
        caw = new ByteArrayOutputStream();
        xpw = new SMExPrintStream(caw);
        xpw.print(43);
        this.th.check(caw.toString().equals(String.valueOf(43)), "checking intValue");
        this.th.checkPoint("print(long)void");
        caw = new ByteArrayOutputStream();
        xpw = new SMExPrintStream(caw);
        xpw.print(43L);
        this.th.check(caw.toString().equals(String.valueOf(43L)), "checking longValue");
        this.th.checkPoint("print(float)void");
        caw = new ByteArrayOutputStream();
        xpw = new SMExPrintStream(caw);
        xpw.print(43.5f);
        this.th.check(caw.toString().equals(String.valueOf(43.5f)), "checking floatValue");
        this.th.checkPoint("print(double)void");
        caw = new ByteArrayOutputStream();
        xpw = new SMExPrintStream(caw);
        xpw.print(43.25);
        this.th.check(caw.toString().equals(String.valueOf(43.25)), "checking doubleValue");
        this.th.checkPoint("print(java.lang.Object)void");
        caw = new ByteArrayOutputStream();
        xpw = new SMExPrintStream(caw);
        Object o = new Object();
        xpw.print(o);
        this.th.check(caw.toString().equals(String.valueOf(o)), "checking doubleValue");
        try {
            xpw.print((Object)null);
            this.th.check(caw.toString().equals(String.valueOf(o) + "null"), "checking string");
        }
        catch (NullPointerException ne) {
            this.th.fail("should not throw a NullpointerException");
        }
        this.th.checkPoint("print(java.lang.String)void");
        caw = new ByteArrayOutputStream();
        xpw = new SMExPrintStream(caw);
        String s = "smartmove rules!";
        xpw.print(s);
        this.th.check(caw.toString().equals(s), "checking string");
        try {
            xpw.print((String)null);
            this.th.check(caw.toString().equals(s + "null"), "checking string");
        }
        catch (NullPointerException ne) {
            this.th.fail("should not throw a NullpointerException");
        }
        SMErrorStream es = new SMErrorStream();
        xpw = new SMExPrintStream(es, true);
        xpw.print("hello,\nhow are you?");
        this.th.check(es.isFlushed(), "checking autoflush");
        es = new SMErrorStream();
        xpw = new SMExPrintStream(es, false);
        xpw.print("hello,\nhow are you?");
        this.th.check(!es.isFlushed(), "checking autoflush");
        this.th.checkPoint("print(char)void");
        caw = new ByteArrayOutputStream();
        xpw = new SMExPrintStream(caw);
        xpw.print('a');
        this.th.check(caw.toString().equals(String.valueOf('a')), "checking char");
        this.th.checkPoint("print(char[])void");
        caw = new ByteArrayOutputStream();
        xpw = new SMExPrintStream(caw, true);
        xpw.print(s.toCharArray());
        this.th.check(caw.toString().equals(String.valueOf(s.toCharArray())), "checking charArray");
        try {
            xpw.print((char[])null);
            this.th.fail("should throw a NullpointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
    }

    public void test_println() {
        this.th.checkPoint("println()void");
        ByteArrayOutputStream caw = new ByteArrayOutputStream();
        SMExPrintStream xpw = new SMExPrintStream(caw);
        xpw.println();
        this.th.check(caw.toString().equals(this.sep), "checking line separator");
        SMErrorStream ew = new SMErrorStream();
        xpw = new SMExPrintStream(ew, false);
        xpw.println();
        this.th.check(!ew.isFlushed(), "not flushed --> auto_flush is off");
        xpw = new SMExPrintStream(ew, true);
        xpw.println();
        this.th.check(ew.isFlushed(), "flushed --> auto_flush is on");
        this.th.checkPoint("println(boolean)void");
        caw = new ByteArrayOutputStream();
        xpw = new SMExPrintStream(caw);
        xpw.println(true);
        this.th.check(caw.toString().equals(String.valueOf(true) + this.sep), "checking true");
        xpw.println(false);
        this.th.check(caw.toString().equals("true" + this.sep + "false" + this.sep), "checking true+false");
        this.th.checkPoint("println(int)void");
        caw = new ByteArrayOutputStream();
        xpw = new SMExPrintStream(caw);
        xpw.println(43);
        this.th.check(caw.toString().equals(String.valueOf(43) + this.sep), "checking intValue");
        this.th.checkPoint("println(long)void");
        caw = new ByteArrayOutputStream();
        xpw = new SMExPrintStream(caw);
        xpw.println(43L);
        this.th.check(caw.toString().equals(String.valueOf(43L) + this.sep), "checking longValue");
        this.th.checkPoint("println(float)void");
        caw = new ByteArrayOutputStream();
        xpw = new SMExPrintStream(caw);
        xpw.println(43.5f);
        this.th.check(caw.toString().equals(String.valueOf(43.5f) + this.sep), "checking floatValue");
        this.th.checkPoint("println(double)void");
        caw = new ByteArrayOutputStream();
        xpw = new SMExPrintStream(caw);
        xpw.println(43.25);
        this.th.check(caw.toString().equals(String.valueOf(43.25) + this.sep), "checking doubleValue");
        this.th.checkPoint("println(java.lang.Object)void");
        caw = new ByteArrayOutputStream();
        xpw = new SMExPrintStream(caw);
        Object o = new Object();
        xpw.println(o);
        this.th.check(caw.toString().equals(String.valueOf(o) + this.sep), "checking ObjectValue");
        try {
            xpw.println((Object)null);
            this.th.check(caw.toString().equals(String.valueOf(o) + this.sep + "null" + this.sep), "checking string");
        }
        catch (NullPointerException ne) {
            this.th.fail("should not throw a NullpointerException");
        }
        this.th.checkPoint("println(java.lang.String)void");
        caw = new ByteArrayOutputStream();
        xpw = new SMExPrintStream(caw);
        String s = "smartmove rules!";
        xpw.println(s);
        this.th.check(caw.toString().equals(s + this.sep), "checking string");
        try {
            xpw.println((String)null);
            this.th.check(caw.toString().equals(s + this.sep + "null" + this.sep), "checking string");
        }
        catch (NullPointerException ne) {
            this.th.fail("should not throw a NullpointerException");
        }
        this.th.checkPoint("println(char)void");
        caw = new ByteArrayOutputStream();
        xpw = new SMExPrintStream(caw);
        xpw.println('a');
        this.th.check(caw.toString().equals(String.valueOf('a') + this.sep), "checking char");
        this.th.checkPoint("println(char[])void");
        caw = new ByteArrayOutputStream();
        xpw = new SMExPrintStream(caw);
        xpw.println(s.toCharArray());
        this.th.check(caw.toString().equals(String.valueOf(s.toCharArray()) + this.sep), "checking charArray");
        try {
            xpw.println((char[])null);
            this.th.fail("should throw a NullpointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
    }

    public void test_write() {
        this.th.checkPoint("write(int)void");
        ByteArrayOutputStream caw = new ByteArrayOutputStream();
        SMExPrintStream xw = new SMExPrintStream(caw);
        xw.write(97);
        xw.write(98);
        xw.write(99);
        xw.write(98);
        xw.write(97);
        this.th.check(caw.toString().equals("abcba"), "check if chars are added, got:" + caw.toString());
        this.th.checkPoint("write(byte[],int,int)void");
        caw = new ByteArrayOutputStream();
        xw = new SMExPrintStream(caw);
        try {
            xw.write("".getBytes());
            this.th.check("".equals(caw.toString()), "checking write -- 1, got:" + caw.toString());
            xw.write("bcdefg".getBytes());
            this.th.check("bcdefg".equals(caw.toString()), "checking write -- 2, got:" + caw.toString());
            xw.write("abcd".getBytes());
            this.th.check("bcdefgabcd".equals(caw.toString()), "checking write -- 3, got:" + caw.toString());
            xw.write("a".getBytes());
            this.th.check("bcdefgabcda".equals(caw.toString()), "checking write -- 4, got:" + caw.toString());
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 1, got:" + e);
        }
        try {
            xw.write(null);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 1, got:" + e);
        }
        this.th.checkPoint("write(byte[],int,int)void");
        caw = new ByteArrayOutputStream();
        xw = new SMExPrintStream(caw);
        xw.write("".getBytes(), 0, 0);
        this.th.check("".equals(caw.toString()), "checking write -- 1, got:" + caw.toString());
        xw.write("abcdefgh".getBytes(), 1, 6);
        this.th.check("bcdefg".equals(caw.toString()), "checking write -- 2, got:" + caw.toString());
        xw.write("abcd".getBytes(), 4, 0);
        this.th.check("bcdefg".equals(caw.toString()), "checking write -- 3, got:" + caw.toString());
        xw.write("a".getBytes(), 0, 0);
        this.th.check("bcdefg".equals(caw.toString()), "checking write -- 4, got:" + caw.toString());
        xw.write("abcd".getBytes(), 2, 2);
        this.th.check("bcdefgcd".equals(caw.toString()), "checking write -- 5, got:" + caw.toString());
        xw.write("abcd".getBytes(), 0, 4);
        this.th.check("bcdefgcdabcd".equals(caw.toString()), "checking write -- 6, got:" + caw.toString());
        try {
            xw.write(null, 4, 5);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 1, got:" + e);
        }
        try {
            xw.write("abcde".getBytes(), 4, 2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 2, got:" + e);
        }
        try {
            xw.write("abcde".getBytes(), -4, 2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 2");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 3, got:" + e);
        }
        try {
            xw.write("abcde".getBytes(), 4, -2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 3");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 4, got:" + e);
        }
        try {
            xw.write("abcde".getBytes(), 6, 0);
            this.th.fail("should throw an IndexOutOfBoundsException -- 4");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 5, got:" + e);
        }
    }

    public void test_checkError() {
        this.th.checkPoint("checkError()boolean");
        SMErrorStream ew = new SMErrorStream();
        SMExPrintStream xw = new SMExPrintStream(ew);
        xw.close();
        this.th.check(xw.checkError(), "checking Error flag set -- close");
        xw = new SMExPrintStream(ew);
        xw.flush();
        this.th.check(xw.checkError(), "checking Error flag set -- flush");
        xw = new SMExPrintStream(ew);
        xw.write(1);
        this.th.check(xw.checkError(), "checking Error flag set -- write 1");
        xw = new SMExPrintStream(ew);
        byte[] ca = "abcde".getBytes();
        xw.write(ca, 1, 3);
        this.th.check(xw.checkError(), "checking Error flag set -- write 2");
        xw = new SMExPrintStream(ew);
    }

    public void test_setError() {
        this.th.checkPoint("setError()void");
        ByteArrayOutputStream caw = new ByteArrayOutputStream();
        SMExPrintStream xw = new SMExPrintStream(caw);
        xw.setError();
        this.th.check(xw.checkError(), "checking setError");
    }

    public void test_close() {
        this.th.checkPoint("close()void");
        SMErrorStream ew = new SMErrorStream(1);
        SMExPrintStream xw = new SMExPrintStream(ew);
        xw.close();
        this.th.check(ew.timesClosed() == 1);
        xw.close();
        xw.close();
        xw.close();
        this.th.check(ew.timesClosed() == 1, "should only sent one close");
    }

    public void test_flush() {
        this.th.checkPoint("flush()void");
        SMErrorStream ew = new SMErrorStream();
        SMExPrintStream xw = new SMExPrintStream(ew);
        xw.flush();
        this.th.check(ew.isFlushed());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

