/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.io.CharArrayWriter;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.io.CharArrayWriter.SMlockCharArrayWriter;
import java.io.CharArrayWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SMCharArrayWriterTest
implements Testlet {
    protected TestHarness th;
    protected int accesed;
    private Thread t;
    private volatile boolean f1;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.io.CharArrayWriter");
        this.test_CharArrayWriter();
        this.test_write();
        this.test_close();
        this.test_flush();
        this.test_reset();
        this.test_size();
        this.test_toCharArray();
        this.test_toString();
        this.test_writeTo();
        this.test_lock();
    }

    public void test_CharArrayWriter() {
        this.th.checkPoint("CharArrayWriter()");
        this.th.checkPoint("CharArrayWriter(int)");
        try {
            CharArrayWriter cw = new CharArrayWriter(-1);
            this.th.fail("should throw an IllegalArgumentExeption");
        }
        catch (IllegalArgumentException ie) {
            this.th.check(true);
        }
    }

    public void test_write() {
        this.th.checkPoint("write(int)void");
        CharArrayWriter cw = new CharArrayWriter();
        cw.write(97);
        cw.write(98);
        cw.write(99);
        cw.write(98);
        cw.write(97);
        this.th.check(cw.toString().equals("abcba"), "check if chars are added");
        this.th.checkPoint("write(char[],int,int)void");
        CharArrayWriter xw = new CharArrayWriter();
        try {
            xw.write("".toCharArray(), 0, 0);
            this.th.check("".equals(xw.toString()), "checking write -- 1, got:" + xw.toString());
            xw.write("abcdefgh".toCharArray(), 1, 6);
            this.th.check("bcdefg".equals(xw.toString()), "checking write -- 2, got:" + xw.toString());
            xw.write("abcd".toCharArray(), 4, 0);
            this.th.check("bcdefg".equals(xw.toString()), "checking write -- 3, got:" + xw.toString());
            xw.write("a".toCharArray(), 0, 0);
            this.th.check("bcdefg".equals(xw.toString()), "checking write -- 4, got:" + xw.toString());
            xw.write("abcd".toCharArray(), 2, 2);
            this.th.check("bcdefgcd".equals(xw.toString()), "checking write -- 5, got:" + xw.toString());
            xw.write("abcd".toCharArray(), 0, 4);
            this.th.check("bcdefgcdabcd".equals(xw.toString()), "checking write -- 6, got:" + xw.toString());
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw any Exception, got:" + e);
        }
        try {
            char[] ca = null;
            xw.write(ca, 4, 5);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 1, got:" + e);
        }
        try {
            xw.write("abcde".toCharArray(), 4, 2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 2, got:" + e);
        }
        try {
            xw.write("abcde".toCharArray(), -4, 2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 2");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 3, got:" + e);
        }
        try {
            xw.write("abcde".toCharArray(), 4, -2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 3");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 4, got:" + e);
        }
        try {
            xw.write("abcde".toCharArray(), 6, 0);
            this.th.fail("should throw an IndexOutOfBoundsException -- 4");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 5, got:" + e);
        }
        this.th.checkPoint("write(java.lang.String,int,int)void");
        xw = new CharArrayWriter();
        try {
            xw.write("", 0, 0);
            this.th.check("".equals(xw.toString()), "checking write -- 1, got:" + xw.toString());
            xw.write("abcdefgh", 1, 6);
            this.th.check("bcdefg".equals(xw.toString()), "checking write -- 2, got:" + xw.toString());
            xw.write("abcd", 4, 0);
            this.th.check("bcdefg".equals(xw.toString()), "checking write -- 3, got:" + xw.toString());
            xw.write("a", 0, 0);
            this.th.check("bcdefg".equals(xw.toString()), "checking write -- 4, got:" + xw.toString());
            xw.write("abcd", 2, 2);
            this.th.check("bcdefgcd".equals(xw.toString()), "checking write -- 5, got:" + xw.toString());
            xw.write("abcd", 0, 4);
            this.th.check("bcdefgcdabcd".equals(xw.toString()), "checking write -- 6, got:" + xw.toString());
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw any Exception, got:" + e);
        }
        try {
            String s = null;
            xw.write(s, 4, 5);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 1, got:" + e);
        }
        try {
            xw.write("abcde", 4, 2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 2, got:" + e);
        }
        try {
            xw.write("abcde", -4, 2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 2");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 3, got:" + e);
        }
        try {
            xw.write("abcde", 4, -2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 3");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 4, got:" + e);
        }
        try {
            xw.write("abcde", 6, 0);
            this.th.fail("should throw an IndexOutOfBoundsException -- 4");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw this Exception -- 5, got:" + e);
        }
    }

    public void test_close() {
        this.th.checkPoint("close()void");
        CharArrayWriter cw = new CharArrayWriter();
        cw.close();
        try {
            cw.write(97);
            this.th.check("a".equals(cw.toString()));
        }
        catch (Exception e) {
            this.th.fail("it is allowed to write in closed CharArrayReader");
        }
    }

    public void test_flush() {
        this.th.checkPoint("flush()void");
        CharArrayWriter cw = new CharArrayWriter();
        try {
            cw.write("abcde");
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception");
        }
        cw.flush();
        this.th.check("abcde".equals(cw.toString()));
    }

    public void test_reset() {
        this.th.checkPoint("reset()void");
        CharArrayWriter cw = new CharArrayWriter();
        try {
            cw.write("abcde");
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception");
        }
        cw.reset();
        this.th.check("".equals(cw.toString()));
        boolean bl = false;
        if (cw.size() == 0) {
            bl = true;
        }
        this.th.check(bl, "size is 0 after reset");
    }

    public void test_size() {
        this.th.checkPoint("size()int");
        CharArrayWriter cw = new CharArrayWriter();
        try {
            cw.write("abcde");
            boolean bl = false;
            if (cw.size() == 5) {
                bl = true;
            }
            this.th.check(bl);
            cw.write("abcde".toCharArray(), 2, 3);
            boolean bl2 = false;
            if (cw.size() == 8) {
                bl2 = true;
            }
            this.th.check(bl2);
            cw.write(99);
            boolean bl3 = false;
            if (cw.size() == 9) {
                bl3 = true;
            }
            this.th.check(bl3);
            cw.write("abcde", 0, 5);
            boolean bl4 = false;
            if (cw.size() == 14) {
                bl4 = true;
            }
            this.th.check(bl4);
            cw.write("abcde", 4, 0);
            boolean bl5 = false;
            if (cw.size() == 14) {
                bl5 = true;
            }
            this.th.check(bl5);
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception");
        }
    }

    public void test_toCharArray() {
        this.th.checkPoint("toCharArray()char[]");
        CharArrayWriter cw = new CharArrayWriter();
        String s = "abcdefghij\nklm";
        try {
            cw.write(s);
            this.th.check(s.equals(new String(cw.toCharArray())));
            cw.write(s);
            this.th.check(new String(cw.toCharArray()).equals(s + s));
            cw.reset();
            this.th.check("".equals(new String(cw.toCharArray())));
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception");
        }
    }

    public void test_toString() {
        this.th.checkPoint("toString()java.lang.String");
        CharArrayWriter cw = new CharArrayWriter();
        String s = "abcdefghij\nklm";
        try {
            cw.write(s);
            this.th.check(s.equals(cw.toString()));
            cw.write(s);
            this.th.check(cw.toString().equals(s + s));
            cw.reset();
            this.th.check("".equals(cw.toString()));
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception");
        }
    }

    public void test_writeTo() {
        this.th.checkPoint("writeTo(java.io.Writer)void");
        CharArrayWriter cws = new CharArrayWriter();
        CharArrayWriter cwd = new CharArrayWriter();
        String s = "abcdefghij\nklm";
        try {
            cws.writeTo(cwd);
            this.th.check(cwd.toString().equals(""));
            cws.write(s);
            cws.writeTo(cwd);
            this.th.check(cwd.toString().equals(s));
            cws.writeTo(cwd);
            this.th.check(cwd.toString().equals(s + s));
            cws.reset();
            cws.writeTo(cwd);
            this.th.check(cwd.toString().equals(s + s));
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception");
        }
    }

    public void test_lock() {
        this.th.checkPoint("lock(protected)java.lang.Object");
        SMlockCharArrayWriter lt = new SMlockCharArrayWriter();
        CharArrayWriter wr = new CharArrayWriter();
        int i = this.setupLockThread(lt, wr);
        try {
            wr.writeTo(new CharArrayWriter());
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl = false;
        if (i + 1 == this.accesed) {
            bl = true;
        }
        this.th.check(bl, "accesed xr before lock was released -- writeTo");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        wr = new CharArrayWriter();
        i = this.setupLockThread(lt, wr);
        wr.toString();
        boolean bl2 = false;
        if (i + 1 == this.accesed) {
            bl2 = true;
        }
        this.th.check(bl2, "accesed xr before lock was released -- toString");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        wr = new CharArrayWriter();
        i = this.setupLockThread(lt, wr);
        wr.toCharArray();
        boolean bl3 = false;
        if (i + 1 == this.accesed) {
            bl3 = true;
        }
        this.th.check(bl3, "accesed xr before lock was released -- toCharArray");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        wr = new CharArrayWriter();
        i = this.setupLockThread(lt, wr);
        wr.size();
        this.th.check(i, this.accesed, "accesed xr before lock was released -- size");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        wr = new CharArrayWriter();
        i = this.setupLockThread(lt, wr);
        wr.reset();
        this.th.check(i, this.accesed, "accesed xr before lock was released -- reset");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        wr = new CharArrayWriter();
        i = this.setupLockThread(lt, wr);
        wr.write(96);
        boolean bl4 = false;
        if (i + 1 == this.accesed) {
            bl4 = true;
        }
        this.th.check(bl4, "accesed xr before lock was released -- write(int)");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        wr = new CharArrayWriter();
        i = this.setupLockThread(lt, wr);
        wr.write("abcd", 1, 2);
        boolean bl5 = false;
        if (i + 1 == this.accesed) {
            bl5 = true;
        }
        this.th.check(bl5, "accesed xr before lock was released -- write(String,int,int)");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        wr = new CharArrayWriter();
        i = this.setupLockThread(lt, wr);
        wr.write(new char[4], 1, 2);
        boolean bl6 = false;
        if (i + 1 == this.accesed) {
            bl6 = true;
        }
        this.th.check(bl6, "accesed xr before lock was released -- write(char[],int,int)");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void inc() {
        ++this.accesed;
    }

    public int setupLockThread(SMlockCharArrayWriter lt, CharArrayWriter xr) {
        this.f1 = false;
        lt.setWriter(xr);
        lt.setTestHarness(this.th);
        lt.setWT(this);
        this.t = new Thread(lt);
        this.t.start();
        while (!this.f1) {
            Thread.yield();
        }
        return this.accesed;
    }

    public void set1() {
        this.f1 = true;
    }

    private final /* synthetic */ void this() {
        this.accesed = 0;
        this.t = null;
        this.f1 = false;
    }

    public SMCharArrayWriterTest() {
        this.this();
    }
}

